/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval;

import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;

public abstract class EqkProbDistCalc
implements ParameterChangeListener {
    static final boolean D = true;
    protected EvenlyDiscretizedFunc pdf;
    protected EvenlyDiscretizedFunc cdf;
    protected EvenlyDiscretizedFunc integratedCDF;
    protected EvenlyDiscretizedFunc integratedOneMinusCDF;
    protected double mean;
    protected double aperiodicity;
    protected double deltaX;
    protected double duration;
    protected double histOpenInterval;
    protected int numPoints;
    protected boolean interpolate = true;
    public static final double DELTA_X_DEFAULT = 0.001;
    protected boolean upToDate = false;
    protected String NAME;
    protected String commonInfoString;
    public static final String MEAN_PARAM_NAME = "Mean";
    public static final String APERIODICITY_PARAM_NAME = "Aperiodicity";
    public static final String DURATION_PARAM_NAME = "Duration";
    public static final String DELTA_X_PARAM_NAME = "Delta T";
    public static final String NUM_POINTS_PARAM_NAME = "Num Points";
    public static final String HIST_OPEN_INTERVAL_PARAM_NAME = "Historic Open Interval";
    protected static final String MEAN_PARAM_INFO = "Mean";
    protected static final String APERIODICITY_PARAM_INFO = "Aperiodicity is the standard deviation divided by the mean ";
    protected static final String DURATION_PARAM_INFO = "Duration of the forecast";
    protected static final String DELTA_X_PARAM_INFO = "The time discretization for the distribution";
    protected static final String NUM_POINTS_PARAM_INFO = "The number of points for the distribution";
    protected static final String HIST_OPEN_INTERVAL_PARAM_INFO = "Historic time interval over which event is known not to have occurred";
    protected static final Double DEFAULT_MEAN_PARAM_VAL = 100.0;
    protected static final Double DEFAULT_APERIODICITY_PARAM_VAL = 0.5;
    protected static final Double DEFAULT_DURATION_PARAM_VAL = 30.0;
    protected static final Double DEFAULT_DELTAX_PARAM_VAL = 1.0;
    protected static final Integer DEFAULT_NUMPOINTS_PARAM_VAL = 500;
    protected static final Double DEFAULT_HIST_OPEN_INTERVAL_PARAM_VAL = 0.0;
    protected DoubleParameter meanParam;
    protected DoubleParameter aperiodicityParam;
    protected DoubleParameter durationParam;
    protected DoubleParameter deltaX_Param;
    protected DoubleParameter histOpenIntParam;
    protected IntegerParameter numPointsParam;
    protected ParameterList adjustableParams;

    abstract void computeDistributions();

    public EvenlyDiscretizedFunc getCDF() {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        this.cdf.setName(this.NAME + " CDF (Cumulative Density Function)");
        this.cdf.setInfo(this.adjustableParams.toString());
        return this.cdf;
    }

    public EvenlyDiscretizedFunc getPDF() {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        this.pdf.setName(this.NAME + " PDF (Probability Density Function)");
        this.pdf.setInfo(this.adjustableParams.toString() + "\nComputed mean = " + (float)EqkProbDistCalc.computeMeanFromPDF(this.pdf));
        return this.pdf;
    }

    public EvenlyDiscretizedFunc getHazFunc() {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        EvenlyDiscretizedFunc hazFunc = new EvenlyDiscretizedFunc(0.0, this.pdf.getMaxX(), this.pdf.size());
        for (int i = 0; i < hazFunc.size(); ++i) {
            double haz = this.pdf.getY(i) / (1.0 - this.cdf.getY(i));
            if (Double.isInfinite(haz) || Double.isInfinite(-haz)) {
                haz = Double.NaN;
            }
            hazFunc.set(i, haz);
        }
        hazFunc.setName(this.NAME + " Hazard Function");
        hazFunc.setInfo(this.adjustableParams.toString());
        return hazFunc;
    }

    public EvenlyDiscretizedFunc getCondProbFunc() {
        if (this.duration == 0.0) {
            throw new RuntimeException("duration has not been set");
        }
        if (!this.upToDate) {
            this.computeDistributions();
        }
        int numPts = this.numPoints - (int)(this.duration / this.deltaX + 1.0);
        EvenlyDiscretizedFunc condFunc = new EvenlyDiscretizedFunc(0.0, numPts, this.deltaX);
        for (int i = 0; i < condFunc.size(); ++i) {
            condFunc.set(i, this.getCondProb(condFunc.getX(i), this.duration));
        }
        condFunc.setName(this.NAME + " Conditional Probability Function");
        condFunc.setInfo(this.adjustableParams.toString());
        return condFunc;
    }

    public EvenlyDiscretizedFunc getCondProbFunc(double duration) {
        this.duration = duration;
        if (!this.upToDate) {
            this.computeDistributions();
        }
        return this.getCondProbFunc();
    }

    public EvenlyDiscretizedFunc getCondProbGainFunc() {
        EvenlyDiscretizedFunc func = this.getCondProbFunc();
        func.scale(this.mean / this.duration);
        func.setName(this.NAME + " Conditional Probability Gain Function");
        func.setInfo("Defined as cond prob divided by expected number (duration/mean=" + (float)(this.duration / this.mean) + ").\n" + this.adjustableParams.toString());
        return func;
    }

    public double getCondProb(double timeSinceLast, double duration) {
        double p2;
        double p1;
        this.duration = duration;
        if (!this.upToDate) {
            this.computeDistributions();
        }
        boolean interpolate = this.interpolate;
        int pt1 = 0;
        int pt2 = 0;
        if (!(interpolate || (pt1 = (int)Math.round(timeSinceLast / this.deltaX)) != (pt2 = (int)Math.round((timeSinceLast + duration) / this.deltaX)) && pt1 != 0)) {
            interpolate = true;
        }
        if (interpolate) {
            p1 = this.cdf.getInterpolatedY(timeSinceLast);
            p2 = this.cdf.getInterpolatedY(timeSinceLast + duration);
        } else {
            p2 = this.cdf.getY(pt2);
            p1 = this.cdf.getY(pt1);
        }
        return (p2 - p1) / (1.0 - p1);
    }

    protected void initAdjParams() {
        this.meanParam = new DoubleParameter("Mean", Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_MEAN_PARAM_VAL);
        this.meanParam.setInfo("Mean");
        this.meanParam.addParameterChangeListener(this);
        this.aperiodicityParam = new DoubleParameter(APERIODICITY_PARAM_NAME, Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_APERIODICITY_PARAM_VAL);
        this.aperiodicityParam.setInfo(APERIODICITY_PARAM_INFO);
        this.aperiodicityParam.addParameterChangeListener(this);
        this.durationParam = new DoubleParameter(DURATION_PARAM_NAME, Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_DURATION_PARAM_VAL);
        this.durationParam.setInfo(DURATION_PARAM_INFO);
        this.durationParam.addParameterChangeListener(this);
        this.deltaX_Param = new DoubleParameter(DELTA_X_PARAM_NAME, Double.MIN_VALUE, Double.MAX_VALUE, DEFAULT_DELTAX_PARAM_VAL);
        this.deltaX_Param.setInfo(DELTA_X_PARAM_INFO);
        this.deltaX_Param.addParameterChangeListener(this);
        this.numPointsParam = new IntegerParameter(NUM_POINTS_PARAM_NAME, Integer.MIN_VALUE, Integer.MAX_VALUE, DEFAULT_NUMPOINTS_PARAM_VAL);
        this.numPointsParam.setInfo(NUM_POINTS_PARAM_INFO);
        this.numPointsParam.addParameterChangeListener(this);
        this.histOpenIntParam = new DoubleParameter(HIST_OPEN_INTERVAL_PARAM_NAME, 0.0, Double.MAX_VALUE, DEFAULT_HIST_OPEN_INTERVAL_PARAM_VAL);
        this.histOpenIntParam.setInfo(HIST_OPEN_INTERVAL_PARAM_INFO);
        this.histOpenIntParam.addParameterChangeListener(this);
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.meanParam);
        this.adjustableParams.addParameter(this.aperiodicityParam);
        this.adjustableParams.addParameter(this.durationParam);
        this.adjustableParams.addParameter(this.deltaX_Param);
        this.adjustableParams.addParameter(this.numPointsParam);
        this.adjustableParams.addParameter(this.histOpenIntParam);
        this.setAll(DEFAULT_MEAN_PARAM_VAL, DEFAULT_APERIODICITY_PARAM_VAL, DEFAULT_DELTAX_PARAM_VAL, DEFAULT_NUMPOINTS_PARAM_VAL, DEFAULT_DURATION_PARAM_VAL, DEFAULT_HIST_OPEN_INTERVAL_PARAM_VAL);
    }

    public ParameterList getAdjParams() {
        return this.adjustableParams;
    }

    public String getName() {
        return this.NAME;
    }

    public void fitToThisFunction(EvenlyDiscretizedFunc dist, double minMean, double maxMean, int numMean, double minAper, double maxAper, int numAper) {
        if (!this.upToDate) {
            this.computeDistributions();
        }
        this.deltaX_Param.setValue(dist.getDelta() / 2.0);
        this.numPointsParam.setValue(dist.size() * 2 + 1);
        double bestMean = 0.0;
        double bestAper = 0.0;
        double best_rms = Double.MAX_VALUE;
        double deltaMean = (maxMean - minMean) / (double)(numMean - 1);
        double deltaAper = (maxAper - minAper) / (double)(numAper - 1);
        for (int m = 0; m < numMean; ++m) {
            for (int c = 0; c < numAper; ++c) {
                this.meanParam.setValue(minMean + (double)m * deltaMean);
                this.aperiodicityParam.setValue(minAper + (double)c * deltaAper);
                EvenlyDiscretizedFunc pdf = this.getPDF();
                double rms = 0.0;
                for (int i = 0; i < dist.size() - 1; ++i) {
                    double diff = dist.getY(i) - pdf.getInterpolatedY(dist.getX(i));
                    rms += diff * diff;
                }
                if (!(rms < best_rms)) continue;
                bestMean = this.mean;
                bestAper = this.aperiodicity;
                best_rms = rms;
            }
        }
        this.meanParam.setValue(bestMean);
        this.aperiodicityParam.setValue(bestAper);
    }

    public double getMean() {
        return this.mean;
    }

    public double getAperiodicity() {
        return this.aperiodicity;
    }

    public double getCondProbForUnknownTimeSinceLastEvent() {
        int firstIndex;
        if (!this.upToDate) {
            this.computeDistributions();
        }
        if (this.integratedCDF == null) {
            this.makeIntegratedCDFs();
        }
        double numer = this.duration - (this.integratedCDF.getInterpolatedY(this.histOpenInterval + this.duration) - this.integratedCDF.getInterpolatedY(this.histOpenInterval));
        double denom = this.integratedOneMinusCDF.getY(this.numPoints - 1) - this.integratedOneMinusCDF.getInterpolatedY(this.histOpenInterval);
        double result = numer / denom;
        double numer2 = 0.0;
        double denom2 = 0.0;
        EvenlyDiscretizedFunc condProbFunc = this.getCondProbFunc();
        for (int i = firstIndex = condProbFunc.getClosestXIndex(this.histOpenInterval); i < condProbFunc.size(); ++i) {
            double probOfTimeSince = 1.0 - this.cdf.getY(i);
            if (i == firstIndex) {
                probOfTimeSince *= (this.cdf.getX(i) + this.deltaX / 2.0 - this.histOpenInterval) / this.deltaX;
            }
            denom2 += probOfTimeSince;
            numer2 += condProbFunc.getY(i) * probOfTimeSince;
        }
        double result2 = (numer2 *= this.deltaX) / (denom2 *= this.deltaX);
        double numer3 = 0.0;
        int numIndicesForDuration = (int)Math.round(this.duration / this.cdf.getDelta());
        for (int i = firstIndex; i < this.cdf.size() - numIndicesForDuration; ++i) {
            numer3 += (this.cdf.getY(i + numIndicesForDuration) - this.cdf.getY(i)) * this.cdf.getDelta();
        }
        double result3 = numer3 / denom2;
        int lastIndex = condProbFunc.getClosestXIndex(this.histOpenInterval + this.duration);
        double sumCDF = 0.0;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            sumCDF += this.cdf.getY(i) * this.cdf.getDelta();
        }
        double numer4 = this.duration - sumCDF;
        double result4 = numer4 / denom2;
        double poisProb1orMore = 1.0 - Math.exp(-this.duration / this.mean);
        double poisProbOf1 = this.duration / this.mean * Math.exp(-this.duration / this.mean);
        System.out.println("result=" + (float)result + "\tnumer=" + numer + "\tdenom=" + denom + "\nresult2=" + (float)result2 + " (" + (float)(result / result2) + ")\tnumer2=" + numer2 + "\tdemon2=" + denom2 + "\nresult3=" + (float)result3 + " (" + (float)(result / result3) + ")\tnumer3=" + numer3 + "\nresult4=" + (float)result4 + " (" + (float)(result / result4) + ")\tnumer4=" + numer4 + "\nduration/mean=" + this.duration / this.mean + "\npoisProb1orMore=" + (float)poisProb1orMore + "\npoisProbOf1=" + (float)poisProbOf1);
        return result;
    }

    protected void makeIntegratedCDFs() {
        this.integratedCDF = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.integratedOneMinusCDF = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 1; i < this.numPoints; ++i) {
            this.integratedCDF.set(i, sum1 += this.deltaX * (this.cdf.getY(i - 1) + this.cdf.getY(i)) / 2.0);
            this.integratedOneMinusCDF.set(i, sum2 += this.deltaX * (1.0 - (this.cdf.getY(i - 1) + this.cdf.getY(i)) / 2.0));
        }
    }

    public EvenlyDiscretizedFunc getTimeSinceLastEventPDF() {
        int firstIndex;
        if (!this.upToDate) {
            this.computeDistributions();
        }
        EvenlyDiscretizedFunc timeSinceLastPDF = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        double normDenom = 0.0;
        for (int i = firstIndex = timeSinceLastPDF.getClosestXIndex(this.histOpenInterval); i < timeSinceLastPDF.size(); ++i) {
            double probOfTimeSince = 1.0 - this.cdf.getY(i);
            timeSinceLastPDF.set(i, probOfTimeSince);
            normDenom += probOfTimeSince;
        }
        timeSinceLastPDF.scale(1.0 / (this.deltaX * normDenom));
        timeSinceLastPDF.setName("Time Since Last Event PDF");
        timeSinceLastPDF.setInfo("The PDF of date of last event when only the historic open interval (" + this.histOpenInterval + ") is known\nmean = " + (float)EqkProbDistCalc.computeMeanFromPDF(timeSinceLastPDF));
        return timeSinceLastPDF;
    }

    public double getMeanTimeSinceLastEventPDF() {
        return EqkProbDistCalc.computeMeanFromPDF(this.getTimeSinceLastEventPDF());
    }

    public static double computeMeanFromPDF(EvenlyDiscretizedFunc pdf) {
        double result = 0.0;
        double normDenom = 0.0;
        for (int i = 0; i < pdf.size(); ++i) {
            result += pdf.getX(i) * pdf.getY(i);
            normDenom += pdf.getY(i);
        }
        return result / normDenom;
    }

    public void setAll(double mean, double aperiodicity, double deltaX, int numPoints) {
        this.mean = mean;
        this.aperiodicity = aperiodicity;
        this.deltaX = deltaX;
        this.numPoints = numPoints;
        this.upToDate = false;
    }

    public void setAll(double mean, double aperiodicity, double deltaX, int numPoints, double duration) {
        this.mean = mean;
        this.aperiodicity = aperiodicity;
        this.deltaX = deltaX;
        this.numPoints = numPoints;
        this.duration = duration;
        this.upToDate = false;
    }

    public void setAll(double mean, double aperiodicity, double deltaX, int numPoints, double duration, double histOpenInterval) {
        this.mean = mean;
        this.aperiodicity = aperiodicity;
        this.deltaX = deltaX;
        this.numPoints = numPoints;
        this.duration = duration;
        this.histOpenInterval = histOpenInterval;
        this.upToDate = false;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public void setAllParameters(double mean, double aperiodicity, double deltaX, int numPoints, double duration, double histOpenInterval) {
        this.meanParam.setValue(mean);
        this.aperiodicityParam.setValue(aperiodicity);
        this.deltaX_Param.setValue(deltaX);
        this.numPointsParam.setValue(numPoints);
        this.durationParam.setValue(duration);
        this.histOpenIntParam.setValue(histOpenInterval);
        this.upToDate = false;
    }

    public void setAll(double mean, double aperiodicity) {
        this.mean = mean;
        this.aperiodicity = aperiodicity;
        this.deltaX = 0.001 * mean;
        this.numPoints = (int)Math.round(aperiodicity * 10.0 * mean / this.deltaX) + 1;
        this.upToDate = false;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public void setDurationAndHistOpenInterval(double duration, double histOpenInterval) {
        this.duration = duration;
        this.histOpenInterval = histOpenInterval;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase("Mean")) {
            this.mean = (Double)this.meanParam.getValue();
        } else if (paramName.equalsIgnoreCase(APERIODICITY_PARAM_NAME)) {
            this.aperiodicity = (Double)this.aperiodicityParam.getValue();
        } else if (paramName.equalsIgnoreCase(DURATION_PARAM_NAME)) {
            this.duration = (Double)this.durationParam.getValue();
        } else if (paramName.equalsIgnoreCase(DELTA_X_PARAM_NAME)) {
            this.deltaX = (Double)this.deltaX_Param.getValue();
        } else if (paramName.equalsIgnoreCase(NUM_POINTS_PARAM_NAME)) {
            this.numPoints = (Integer)this.numPointsParam.getValue();
        } else if (paramName.equalsIgnoreCase(HIST_OPEN_INTERVAL_PARAM_NAME)) {
            this.histOpenInterval = (Double)this.histOpenIntParam.getValue();
        }
        this.upToDate = false;
    }
}

