/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval;

import cern.jet.stat.tdouble.Gamma;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.earthquake.calc.recurInterval.EqkProbDistCalc;

public final class WeibullDistCalc
extends EqkProbDistCalc
implements ParameterChangeListener {
    public WeibullDistCalc() {
        this.NAME = "Weibull";
    }

    @Override
    protected void computeDistributions() {
        this.integratedCDF = null;
        this.integratedOneMinusCDF = null;
        this.pdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.cdf = new EvenlyDiscretizedFunc(0.0, this.numPoints, this.deltaX);
        this.pdf.set(0, 0.0);
        this.cdf.set(0, 0.0);
        double k = WeibullDistCalc.getShapeParameter(this.aperiodicity);
        double gamma1 = Math.exp(Gamma.logGamma((double)(1.0 + 1.0 / k)));
        double lambda = this.mean / gamma1;
        double cd = 0.0;
        for (int i = 1; i < this.pdf.size(); ++i) {
            double t = this.cdf.getX(i);
            double pd = k / lambda * Math.pow(t / lambda, k - 1.0) * Math.exp(-1.0 * Math.pow(t / lambda, k));
            if (Double.isNaN(pd)) {
                pd = 0.0;
                System.out.println("pd=0 for i=" + i);
            }
            this.pdf.set(i, pd);
            this.cdf.set(i, cd += this.deltaX * (pd + this.pdf.getY(i - 1)) / 2.0);
        }
        this.upToDate = true;
    }

    private static double getShapeParameter(double cov) {
        double best_k = Double.NaN;
        double minDiff = Double.POSITIVE_INFINITY;
        for (int i = 0; i < 400; ++i) {
            double test_k = 1.0 + (double)i * 0.01;
            double bigGamma1 = Math.exp(Gamma.logGamma((double)(1.0 + 1.0 / test_k)));
            double bigGamma2 = Math.exp(Gamma.logGamma((double)(1.0 + 2.0 / test_k)));
            double testCOV = Math.sqrt(bigGamma2 / (bigGamma1 * bigGamma1) - 1.0);
            double diff = Math.abs(testCOV - cov);
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            best_k = test_k;
        }
        return best_k;
    }

    public static void main(String[] args) {
    }
}

