/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.calc.recurInterval.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.calc.recurInterval.BPT_DistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.EqkProbDistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.ExponentialDistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.LognormalDistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.WeibullDistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.gui.PlottingPanel;

public class ProbabilityDistGUI
extends JFrame
implements ParameterChangeListener {
    private static final int W = 870;
    private static final int H = 750;
    private final boolean D = false;
    private JSplitPane mainSplitPane = new JSplitPane();
    private JSplitPane paramSplitPane = new JSplitPane();
    private JTabbedPane plotTabPane = new JTabbedPane();
    private JPanel editorPanel = new JPanel();
    private ArrayList<PlottingPanel> plottingPanelsList;
    private ArrayList<String> plottingPanelNames;
    private ArrayList<EqkProbDistCalc> probDistList;
    private ArrayList<String> probDistNames;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private static final String POWERED_BY_IMAGE = "logos/PoweredByOpenSHA_Agua.jpg";
    private static final String PROB_DIST_PARAM_NAME = "Probability Distribution";
    private StringParameter probDistParam;

    public ProbabilityDistGUI() {
        try {
            this.makeProbDistList();
            this.jbInit();
            this.setDefaultCloseOperation(3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        JButton addButton = new JButton();
        addButton.setText("Plot-Dist");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbabilityDistGUI.this.addButton_actionPerformed(e);
            }
        });
        JButton peelOffButton = new JButton();
        peelOffButton.setText("Peel-Off");
        peelOffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbabilityDistGUI.this.peelOffButton_actionPerformed(e);
            }
        });
        JButton clearButton = new JButton();
        clearButton.setText("Clear-Plot");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbabilityDistGUI.this.clearButton_actionPerformed(e);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add((Component)addButton, 0);
        buttonPanel.add((Component)clearButton, 1);
        buttonPanel.add((Component)peelOffButton, 2);
        JLabel imgLabel = new JLabel(new ImageIcon(FileUtils.loadImage(POWERED_BY_IMAGE)));
        buttonPanel.add((Component)imgLabel, 3);
        this.setMenuBar();
        this.setToolBar();
        this.editorPanel.setLayout(this.gridBagLayout1);
        this.initSupportedProbDistParamAndEditor();
        this.showAdjParams();
        JSplitPane plotSplitPane = new JSplitPane();
        this.mainSplitPane.setOrientation(0);
        plotSplitPane.setOrientation(1);
        plotSplitPane.add((Component)this.plotTabPane, "left");
        this.mainSplitPane.add((Component)plotSplitPane, "top");
        plotSplitPane.add((Component)this.paramSplitPane, "right");
        this.mainSplitPane.add((Component)buttonPanel, "bottom");
        this.paramSplitPane.setOrientation(0);
        this.paramSplitPane.setDividerLocation(100);
        this.paramSplitPane.add((Component)this.editorPanel, "bottom");
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        plotSplitPane.setDividerLocation(600);
        this.mainSplitPane.setDividerLocation(570);
        this.makePlottingPanels();
        for (int i = 0; i < this.plottingPanelNames.size(); ++i) {
            this.plotTabPane.add(this.plottingPanelNames.get(i), this.plottingPanelsList.get(i));
        }
        this.setSize(870, 750);
        Dimension dm = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dm.width - this.getSize().width) / 2, (dm.height - this.getSize().height) / 2);
        this.setTitle("Probability Distribution Application");
        this.setVisible(true);
    }

    private void makePlottingPanels() {
        this.plottingPanelsList = new ArrayList();
        this.plottingPanelNames = new ArrayList();
        int numPlottingPanels = 6;
        for (int i = 0; i < numPlottingPanels; ++i) {
            this.plottingPanelsList.add(new PlottingPanel());
        }
        this.plottingPanelNames.add("PDF");
        this.plottingPanelNames.add("CDF");
        this.plottingPanelNames.add("Cond Prob");
        this.plottingPanelNames.add("Haz Func");
        this.plottingPanelNames.add("Time Since Last PDF");
        this.plottingPanelNames.add("Cond Prob Gain");
    }

    private void makeProbDistList() {
        this.probDistList = new ArrayList();
        this.probDistList.add(new BPT_DistCalc());
        this.probDistList.add(new LognormalDistCalc());
        this.probDistList.add(new ExponentialDistCalc());
        this.probDistList.add(new WeibullDistCalc());
        this.probDistNames = new ArrayList();
        for (int i = 0; i < this.probDistList.size(); ++i) {
            this.probDistNames.add(this.probDistList.get(i).getName());
        }
    }

    private void setToolBar() {
        JToolBar jToolBar = new JToolBar();
        JButton closeButton = new JButton();
        ImageIcon closeFileImage = new ImageIcon(FileUtils.loadImage("icons/closeFile.png"));
        JButton printButton = new JButton();
        ImageIcon printFileImage = new ImageIcon(FileUtils.loadImage("icons/printFile.jpg"));
        JButton saveButton = new JButton();
        ImageIcon saveFileImage = new ImageIcon(FileUtils.loadImage("icons/saveFile.jpg"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProbabilityDistGUI.this.closeButton_actionPerformed(actionEvent);
            }
        });
        printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProbabilityDistGUI.this.printButton_actionPerformed(actionEvent);
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProbabilityDistGUI.this.saveButton_actionPerformed(actionEvent);
            }
        });
        closeButton.setIcon(closeFileImage);
        closeButton.setToolTipText("Exit Application");
        Dimension d = closeButton.getSize();
        jToolBar.add(closeButton);
        printButton.setIcon(printFileImage);
        printButton.setToolTipText("Print Graph");
        printButton.setSize(d);
        jToolBar.add(printButton);
        saveButton.setIcon(saveFileImage);
        saveButton.setToolTipText("Save Graph as image");
        saveButton.setSize(d);
        jToolBar.add(saveButton);
        jToolBar.setFloatable(false);
        this.getContentPane().add((Component)jToolBar, "North");
    }

    private void setMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem fileExitMenu = new JMenuItem();
        JMenuItem fileSaveMenu = new JMenuItem();
        JCheckBoxMenuItem filePrintMenu = new JCheckBoxMenuItem();
        fileMenu.setText("File");
        fileExitMenu.setText("Exit");
        fileSaveMenu.setText("Save");
        filePrintMenu.setText("Print");
        fileExitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbabilityDistGUI.this.fileExitMenu_actionPerformed(e);
            }
        });
        fileSaveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbabilityDistGUI.this.fileSaveMenu_actionPerformed(e);
            }
        });
        filePrintMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProbabilityDistGUI.this.filePrintMenu_actionPerformed(e);
            }
        });
        menuBar.add(fileMenu);
        fileMenu.add(fileSaveMenu);
        fileMenu.add(filePrintMenu);
        fileMenu.add(fileExitMenu);
        this.setJMenuBar(menuBar);
    }

    private void initSupportedProbDistParamAndEditor() {
        this.probDistParam = new StringParameter(PROB_DIST_PARAM_NAME, this.probDistNames, this.probDistNames.get(0));
        ConstrainedStringParameterEditor probDistParamEditor = new ConstrainedStringParameterEditor(this.probDistParam);
        this.probDistParam.addParameterChangeListener(this);
        JPanel probDistSelectorPanel = new JPanel();
        probDistSelectorPanel.setLayout(this.gridBagLayout1);
        probDistSelectorPanel.add((Component)probDistParamEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        probDistSelectorPanel.validate();
        probDistSelectorPanel.repaint();
        this.paramSplitPane.add((Component)probDistSelectorPanel, "top");
    }

    private void showAdjParams() {
        EqkProbDistCalc selectedProbDist = this.getSelectedProbDist();
        this.editorPanel.removeAll();
        ParameterListEditor paramListEditor = new ParameterListEditor(selectedProbDist.getAdjParams());
        this.editorPanel.add((Component)paramListEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.editorPanel.validate();
        this.editorPanel.repaint();
    }

    private EqkProbDistCalc getSelectedProbDist() {
        String selectedProbDistName = (String)this.probDistParam.getValue();
        int selectedProbDistIndex = this.probDistNames.indexOf(selectedProbDistName);
        EqkProbDistCalc selectedProbDist = this.probDistList.get(selectedProbDistIndex);
        return selectedProbDist;
    }

    private void addGraphPanel() {
        for (int i = 0; i < this.plottingPanelsList.size(); ++i) {
            this.plottingPanelsList.get(i).addGraphPanel();
        }
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.addButton();
    }

    private void addButton() {
        try {
            EqkProbDistCalc selectedProbDist = this.getSelectedProbDist();
            this.plottingPanelsList.get(0).addFunc(selectedProbDist.getPDF());
            this.plottingPanelsList.get(1).addFunc(selectedProbDist.getCDF());
            EvenlyDiscretizedFunc condFunc = selectedProbDist.getCondProbFunc();
            Parameter param = selectedProbDist.getAdjParams().getParameter("Historic Open Interval");
            condFunc.setInfo(condFunc.getInfo() + "\nCond Prob = " + (float)selectedProbDist.getCondProbForUnknownTimeSinceLastEvent() + " if date of last event unknown, but " + param.getName() + " = " + String.valueOf(param.getValue()) + "\n");
            this.plottingPanelsList.get(2).addFunc(condFunc);
            this.plottingPanelsList.get(3).addFunc(selectedProbDist.getHazFunc());
            this.plottingPanelsList.get(4).addFunc(selectedProbDist.getTimeSinceLastEventPDF());
            this.plottingPanelsList.get(5).addFunc(selectedProbDist.getCondProbGainFunc());
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, new String("Enter a Valid Numerical Value"), "Invalid Data Entered", 0);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, new String(e.getMessage()), "Invalid Data Entered", 0);
        }
    }

    void clearButton_actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.plottingPanelsList.size(); ++i) {
            this.plottingPanelsList.get(i).clearPlot();
        }
    }

    private void fileSaveMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    private void filePrintMenu_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    public void save() throws IOException {
        int selectedIndex = this.plotTabPane.getSelectedIndex();
        this.plottingPanelsList.get(selectedIndex).save();
    }

    public void print() {
        int selectedIndex = this.plotTabPane.getSelectedIndex();
        this.plottingPanelsList.get(selectedIndex).print();
    }

    private void peelOffCurves() {
        int selectedIndex = this.plotTabPane.getSelectedIndex();
        this.plottingPanelsList.get(selectedIndex).peelOff();
    }

    void peelOffButton_actionPerformed(ActionEvent e) {
        this.peelOffCurves();
    }

    private void fileExitMenu_actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void close() {
        int option = JOptionPane.showConfirmDialog(this, "Do you really want to exit the application?\nYou will loose all unsaved data.", "Exit App", 2);
        if (option == 0) {
            System.exit(0);
        }
    }

    public void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    public void printButton_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    public void saveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equals(PROB_DIST_PARAM_NAME)) {
            this.showAdjParams();
        }
    }

    public static void main(String[] args) {
        ProbabilityDistGUI.launch();
    }

    public static ProbabilityDistGUI launch() {
        ProbabilityDistGUI probDistGUI = new ProbabilityDistGUI();
        probDistGUI.setVisible(true);
        return probDistGUI;
    }
}

