/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.sha.earthquake.faultSysSolution.RupSetFaultModel;
import org.opensha.sha.earthquake.faultSysSolution.RupSetSubsectioningModel;
import org.opensha.sha.earthquake.faultSysSolution.util.SubSectionBuilder;
import org.opensha.sha.faultSurface.FaultSection;

public interface RupSetDeformationModel
extends LogicTreeNode {
    public boolean isApplicableTo(RupSetFaultModel var1);

    default public List<? extends FaultSection> build(LogicTreeBranch<? extends LogicTreeNode> branch) throws IOException {
        return this.build(branch.requireValue(RupSetFaultModel.class), branch.getValue(RupSetSubsectioningModel.class), branch);
    }

    default public <E extends RupSetFaultModel & RupSetSubsectioningModel> List<? extends FaultSection> build(E faultAndSubSectModel) throws IOException {
        return this.build(faultAndSubSectModel, faultAndSubSectModel, null);
    }

    default public <E extends RupSetFaultModel & RupSetSubsectioningModel> List<? extends FaultSection> build(E faultAndSubSectModel, LogicTreeBranch<? extends LogicTreeNode> branch) throws IOException {
        return this.build(faultAndSubSectModel, faultAndSubSectModel, branch);
    }

    default public List<? extends FaultSection> build(RupSetFaultModel faultModel, RupSetSubsectioningModel subSectionModel, LogicTreeBranch<? extends LogicTreeNode> branch) throws IOException {
        List<? extends FaultSection> subSects;
        Preconditions.checkState((boolean)this.isApplicableTo(faultModel), (String)"Fault and deformation models are not compatible: %s, %s", (Object)faultModel.getName(), (Object)this.getName());
        List<? extends FaultSection> fullSects = faultModel.getFaultSections();
        if (subSectionModel == null) {
            SubSectionBuilder.validateSubSects(fullSects);
            subSects = fullSects;
        } else {
            subSects = subSectionModel.buildSubSects(faultModel, fullSects);
        }
        return this.apply(faultModel, branch, fullSects, subSects);
    }

    default public List<? extends FaultSection> apply(RupSetFaultModel faultModel, LogicTreeBranch<? extends LogicTreeNode> branch, List<? extends FaultSection> subSects) throws IOException {
        Preconditions.checkState((boolean)this.isApplicableTo(faultModel), (String)"Fault and deformation models are not compatible: %s, %s", (Object)faultModel.getName(), (Object)this.getName());
        return this.apply(faultModel, branch, faultModel.getFaultSections(), subSects);
    }

    public List<? extends FaultSection> apply(RupSetFaultModel var1, LogicTreeBranch<? extends LogicTreeNode> var2, List<? extends FaultSection> var3, List<? extends FaultSection> var4) throws IOException;
}

