/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Doubles;
import com.itextpdf.awt.FontMapper;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.MathArrays;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.title.PaintScaleLegend;
import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.gui.plot.GeographicMapMaker;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.gui.plot.pdf.PDF_UTF8_FontMapper;
import org.opensha.commons.logicTree.BranchWeightProvider;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.ExecutorUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.hazard.AbstractLTVarianceDecomposition;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeCurveAverager;
import org.opensha.sha.earthquake.faultSysSolution.hazard.MarginalAveragingLTVarianceDecomposition;
import org.opensha.sha.earthquake.faultSysSolution.hazard.SparseLTVarianceDecomposition;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_LogicTreeHazardCalc;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;

public class LogicTreeHazardCompare {
    private static boolean TITLES = false;
    private static final Location DEBUG_LOC = null;
    private SolHazardMapCalc.ReturnPeriods[] rps;
    private double[] periods;
    private boolean forceSparseLTVar = false;
    private ZipFile zip;
    private List<? extends LogicTreeBranch<?>> branches;
    private List<Double> weights;
    private double totWeight;
    private GriddedRegion gridReg;
    private double spacing;
    private CPT logCPT;
    private CPT spreadCPT;
    private CPT spreadDiffCPT;
    private CPT iqrCPT;
    private CPT iqrDiffCPT;
    private CPT sdCPT;
    private CPT sdDiffCPT;
    private CPT covCPT;
    private CPT covDiffCPT;
    private CPT diffCPT;
    private CPT pDiffCPT;
    private CPT percentileCPT;
    private SolHazardMapCalc mapper;
    private ExecutorService exec;
    private List<Future<?>> futures;
    private Region mapRegion;
    private GriddedRegion forceRemapRegion;
    private SolutionLogicTree solLogicTree;
    private LogicTree<?> tree;
    private boolean floatMaps = false;
    private boolean skipLogicTree = false;
    private boolean ignorePrecomputed = false;
    private static final int MAX_NORMCDF_POINTS = 10000;
    static final DecimalFormat threeDigits = new DecimalFormat("0.000");
    static final DecimalFormat twoDigits = new DecimalFormat("0.00");
    static final DecimalFormat pDF = new DecimalFormat("0.0%");
    private static final Comparator<LogicTreeNode> nodeNameCompare = new Comparator<LogicTreeNode>(){

        @Override
        public int compare(LogicTreeNode o1, LogicTreeNode o2) {
            return o1.getShortName().compareTo(o2.getShortName());
        }
    };
    private static boolean CENTER_SUBPLOTS = true;
    private static boolean INCLUDE_SUBPLOT_WEIGHT_LABELS = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        double[] periods;
        SolutionLogicTree solTree;
        File compHazardFile;
        File compResultsFile;
        File hazardFile;
        File resultsFile;
        boolean forceFileBacked;
        System.setProperty("java.awt.headless", "true");
        boolean currentWeights = false;
        boolean compCurrentWeights = false;
        File mainDir = null;
        String mainName = null;
        Object subsetNodes = null;
        LogicTreeNode[] compSubsetNodes = null;
        File compDir = null;
        String compName = null;
        File outputDir = null;
        CommandLine cmd = FaultSysTools.parseOptions(LogicTreeHazardCompare.createOptions(), args, LogicTreeHazardCompare.class);
        args = cmd.getArgs();
        if (cmd.hasOption("write-pdfs")) {
            SolHazardMapCalc.PDFS = true;
        }
        if (forceFileBacked = cmd.hasOption("force-file-backed-lt")) {
            System.out.println("Forcing file-backed logic trees");
        }
        LogicTree<Object> tree = null;
        LogicTree<Object> compTree = null;
        boolean ignorePrecomputed = false;
        if (args.length > 0) {
            File treeFile;
            Preconditions.checkArgument((args.length == 4 || args.length == 7 ? 1 : 0) != 0, (Object)"USAGE: <primary-results-zip> <primary-hazard-zip> <primary-name> [<comparison-results-zip> <comparison-hazard-zip> <comparison-name>] <output-dir>");
            int cnt = 0;
            resultsFile = args[cnt].equals("null") ? null : new File(args[cnt]);
            int n = ++cnt;
            ++cnt;
            hazardFile = new File(args[n]);
            if (cmd.hasOption("logic-tree")) {
                treeFile = new File(cmd.getOptionValue("logic-tree"));
                System.out.println("Reading custom logic tree from: " + treeFile.getAbsolutePath());
                tree = treeFile.getName().endsWith("zip") ? LogicTreeHazardCompare.loadTreeFromResults(treeFile, forceFileBacked) : (forceFileBacked ? LogicTree.readFileBacked(treeFile) : LogicTree.read(treeFile));
                ignorePrecomputed = true;
            } else {
                tree = LogicTreeHazardCompare.loadTreeFromResults(hazardFile, forceFileBacked);
            }
            if (cmd.hasOption("ignore-precomputed-maps")) {
                ignorePrecomputed = true;
            }
            mainName = args[cnt++];
            if (args.length > 4) {
                compResultsFile = args[cnt].toLowerCase().trim().equals("null") ? null : new File(args[cnt++]);
                int n2 = ++cnt;
                ++cnt;
                compHazardFile = new File(args[n2]);
                if (cmd.hasOption("comp-logic-tree")) {
                    treeFile = new File(cmd.getOptionValue("comp-logic-tree"));
                    System.out.println("Reading custom logic tree from: " + treeFile.getAbsolutePath());
                    compTree = forceFileBacked ? LogicTree.readFileBacked(treeFile) : LogicTree.read(treeFile);
                    ignorePrecomputed = true;
                } else {
                    compTree = LogicTreeHazardCompare.loadTreeFromResults(compHazardFile, forceFileBacked);
                }
                compName = args[cnt++];
            } else {
                compResultsFile = null;
                compHazardFile = null;
                compName = null;
            }
            outputDir = new File(args[cnt++]);
            subsetNodes = null;
            compSubsetNodes = null;
            currentWeights = false;
            compCurrentWeights = false;
        } else {
            resultsFile = new File(mainDir, "results.zip");
            hazardFile = new File(mainDir, "results_hazard.zip");
            if (compDir == null) {
                compResultsFile = null;
                compHazardFile = null;
            } else {
                compResultsFile = new File(compDir, "results.zip");
                compHazardFile = new File(compDir, "results_hazard.zip");
            }
        }
        if (resultsFile == null) {
            solTree = null;
        } else {
            ArchiveInput resultsInput = ArchiveInput.getDefaultInput(resultsFile);
            if (FaultSystemSolution.isSolution(resultsInput)) {
                FaultSystemSolution sol = FaultSystemSolution.load(resultsInput);
                solTree = new SolutionLogicTree.InMemory(sol, null);
            } else {
                solTree = SolutionLogicTree.load(resultsInput);
            }
        }
        SolHazardMapCalc.ReturnPeriods[] rps = SolHazardMapCalc.MAP_RPS;
        if (cmd.hasOption("periods")) {
            String perStr = cmd.getOptionValue("periods");
            if (perStr.contains(",")) {
                String[] split = perStr.split(",");
                periods = new double[split.length];
                for (int i = 0; i < split.length; ++i) {
                    periods[i] = Double.parseDouble(split[i]);
                }
            } else {
                periods = new double[]{Double.parseDouble(perStr)};
            }
        } else {
            ArchiveInput hazardZip = ArchiveInput.getDefaultInput(hazardFile);
            if (compHazardFile == null) {
                periods = LogicTreeHazardCompare.detectHazardPeriods(rps, hazardZip);
            } else {
                ArchiveInput compHazardZip = ArchiveInput.getDefaultInput(compHazardFile);
                periods = LogicTreeHazardCompare.detectHazardPeriods(rps, hazardZip, compHazardZip);
                compHazardZip.close();
            }
        }
        double spacing = -1.0;
        if (tree == null && solTree != null) {
            tree = solTree.getLogicTree();
        }
        if (subsetNodes != null && tree != null) {
            tree = tree.matchingAll(subsetNodes);
        }
        if (currentWeights && tree != null) {
            tree.setWeightProvider(new BranchWeightProvider.CurrentWeights());
        }
        LogicTreeHazardCompare mapper = null;
        LogicTreeHazardCompare comp = null;
        int exit = 0;
        try {
            mapper = new LogicTreeHazardCompare(solTree, tree, hazardFile, rps, periods, spacing);
            boolean bl = mapper.skipLogicTree = cmd.hasOption("skip-logic-tree") || tree == null;
            if (ignorePrecomputed) {
                System.out.println("Ignoring any pre-computed mean maps");
            }
            mapper.ignorePrecomputed = ignorePrecomputed;
            if (cmd.hasOption("cpt-range")) {
                String rangeStr = cmd.getOptionValue("cpt-range");
                Preconditions.checkArgument((boolean)rangeStr.contains(","));
                String[] split = rangeStr.split(",");
                double lower = Double.parseDouble(split[0]);
                double upper = Double.parseDouble(split[1]);
                System.out.println("CPT range: [" + (float)lower + ", " + (float)upper + "]");
                mapper.setCPTRange(lower, upper);
            }
            if (cmd.hasOption("pdiff-range")) {
                mapper.setPDiffRange(Double.parseDouble(cmd.getOptionValue("pdiff-range")));
            }
            if (cmd.hasOption("diff-range")) {
                mapper.setDiffRange(Double.parseDouble(cmd.getOptionValue("diff-range")));
            }
            mapper.forceSparseLTVar = cmd.hasOption("force-sparse-lt-var");
            if (cmd.hasOption("plot-region")) {
                String plotRegStr = cmd.getOptionValue("plot-region");
                File regFile = new File(plotRegStr);
                if (regFile.exists()) {
                    Feature feature = Feature.read(regFile);
                    mapper.mapRegion = Region.fromFeature(feature);
                } else {
                    String[] commaSplit = plotRegStr.split(",");
                    Preconditions.checkState((commaSplit.length == 4 ? 1 : 0) != 0, (Object)"--plot-region must be either a GeoJSON file, or minLat,minLon,maxLat,maxLon");
                    double minLat = Double.parseDouble(commaSplit[0]);
                    double minLon = Double.parseDouble(commaSplit[1]);
                    double maxLat = Double.parseDouble(commaSplit[2]);
                    double maxLon = Double.parseDouble(commaSplit[3]);
                    mapper.mapRegion = new Region(new Location(minLat, minLon), new Location(maxLat, maxLon));
                }
            }
            if (compHazardFile != null) {
                SolutionLogicTree compSolTree;
                if (compResultsFile == null) {
                    compSolTree = null;
                } else {
                    ZipFile compResultsZip = new ZipFile(compResultsFile);
                    if (FaultSystemSolution.isSolution(compResultsZip)) {
                        FaultSystemSolution sol = FaultSystemSolution.load(compResultsZip);
                        compSolTree = new SolutionLogicTree.InMemory(sol, sol.requireModule(LogicTreeBranch.class));
                    } else {
                        compSolTree = SolutionLogicTree.load(compResultsZip);
                    }
                    if (compTree == null) {
                        compTree = compSolTree.getLogicTree();
                    }
                    if (compSubsetNodes != null) {
                        compTree = compTree.matchingAll(compSubsetNodes);
                    }
                    if (compCurrentWeights) {
                        compTree.setWeightProvider(new BranchWeightProvider.CurrentWeights());
                    }
                }
                comp = new LogicTreeHazardCompare(compSolTree, compTree, compHazardFile, rps, periods, spacing);
                mapper.ignorePrecomputed = ignorePrecomputed;
            }
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
            mapper.buildReport(outputDir, mainName, comp, compName);
        }
        catch (Exception e) {
            e.printStackTrace();
            exit = 1;
        }
        finally {
            if (mapper != null) {
                mapper.close();
            }
            if (comp != null) {
                comp.close();
            }
        }
        System.exit(exit);
    }

    public static double[] detectHazardPeriods(SolHazardMapCalc.ReturnPeriods[] rps, ArchiveInput ... archives) throws IOException {
        Preconditions.checkState((archives.length > 0 ? 1 : 0) != 0);
        ArrayList<Double> periods = null;
        for (ArchiveInput archive : archives) {
            Set uniqueMapNames = archive.entryStream().map(s -> s.contains("/") ? s.substring(s.lastIndexOf(47) + 1) : s).filter(s -> s.startsWith("map_")).filter(s -> s.contains(rps[0].name())).collect(Collectors.toSet());
            System.out.println("Detecting periods for " + archive.getName() + " with " + uniqueMapNames.size() + " unique map names detected for " + rps[0].name());
            Preconditions.checkState((!uniqueMapNames.isEmpty() ? 1 : 0) != 0, (String)"No map files found in %s", (Object)archive.getName());
            ArrayList<Double> myPeriods = new ArrayList<Double>();
            for (double period = 0.0; period <= 10.00001; period += 0.01) {
                String fileName = MPJ_LogicTreeHazardCalc.mapPrefix(period = DataUtils.roundFixed(period, 3), rps[0]) + ".txt";
                if (!uniqueMapNames.contains(fileName)) continue;
                myPeriods.add(period);
            }
            Preconditions.checkState((!myPeriods.isEmpty() ? 1 : 0) != 0, (String)"No periods detected for %s", (Object)archive.getName());
            System.out.println("\tDetected periods: " + String.valueOf(myPeriods));
            if (periods == null) {
                periods = myPeriods;
                continue;
            }
            periods.retainAll(myPeriods);
            Preconditions.checkState((!periods.isEmpty() ? 1 : 0) != 0, (String)"No common periods detected after adding %s from %s", myPeriods, (Object)archive.getName());
        }
        return Doubles.toArray(periods);
    }

    public static Options createOptions() {
        Options ops = new Options();
        ops.addOption("slt", "skip-logic-tree", false, "Flag to disable logic tree calculations and only focus on top level maps and comparisions.");
        ops.addOption("lt", "logic-tree", true, "Path to alternative logic tree JSON file. Implies --ignore-precomputed-maps");
        ops.addOption("clt", "comp-logic-tree", true, "Path to alternative logic tree JSON file for the comparison model. Implies --ignore-precomputed-maps");
        ops.addOption("ipm", "ignore-precomputed-maps", false, "Flag to ignore precomputed mean maps");
        ops.addOption(null, "plot-region", true, "Custom plotting region. Must be either a path to a geojson file, or specified as minLat,minLon,maxLat,maxLon");
        ops.addOption("pdf", "write-pdfs", false, "Flag to write PDFs of top level maps");
        ops.addOption(null, "cpt-range", true, "Custom CPT range for hazard maps, in log10 units. Specify as min,max");
        ops.addOption(null, "pdiff-range", true, "Maximum % difference to plot");
        ops.addOption(null, "diff-range", true, "Maximum difference to plot");
        ops.addOption(null, "periods", true, "Custom spectral periods, comma separated");
        ops.addOption(null, "force-sparse-lt-var", false, "Flag to force using the sparse logic tree variance algorithm");
        ops.addOption(null, "force-file-backed-lt", false, "Flag to force loading the logic tree exactly as registered in the tree file and ignoring matching enums or classes");
        return ops;
    }

    private static LogicTree<?> loadTreeFromResults(File resultsFile, boolean forceFileBacked) throws IOException {
        ZipFile zip = new ZipFile(resultsFile);
        ZipEntry entry = zip.getEntry("logic_tree.json");
        if (entry == null) {
            zip.close();
            return null;
        }
        BufferedInputStream logicTreeIS = new BufferedInputStream(zip.getInputStream(entry));
        InputStreamReader reader = new InputStreamReader(logicTreeIS);
        LogicTree<LogicTreeNode> tree = forceFileBacked ? LogicTree.readFileBacked(reader) : LogicTree.read(reader);
        zip.close();
        return tree;
    }

    public LogicTreeHazardCompare(SolutionLogicTree solLogicTree, File mapsZipFile, SolHazardMapCalc.ReturnPeriods[] rps, double[] periods, double spacing) throws IOException {
        this(solLogicTree, solLogicTree.getLogicTree(), mapsZipFile, rps, periods, spacing);
    }

    public LogicTreeHazardCompare(SolutionLogicTree solLogicTree, LogicTree<?> tree, File mapsZipFile, SolHazardMapCalc.ReturnPeriods[] rps, double[] periods, double spacing) throws IOException {
        this.solLogicTree = solLogicTree;
        this.tree = tree;
        this.rps = rps;
        this.periods = periods;
        this.spacing = spacing;
        this.logCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-3.0, 1.0);
        this.logCPT.setLog10(true);
        this.spreadCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
        this.spreadCPT.setNanColor(Color.LIGHT_GRAY);
        this.spreadDiffCPT = GMT_CPT_Files.DIVERGING_BAM_UNIFORM.instance().reverse().rescale(-1.0, 1.0);
        this.spreadDiffCPT.setNanColor(Color.LIGHT_GRAY);
        this.iqrCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-2.0, 0.0);
        this.iqrCPT.setLog10(true);
        this.iqrCPT.setNanColor(Color.LIGHT_GRAY);
        this.iqrDiffCPT = GMT_CPT_Files.DIVERGING_BAM_UNIFORM.instance().reverse().rescale(-0.05, 0.05);
        this.iqrDiffCPT.setNanColor(Color.LIGHT_GRAY);
        this.covCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
        this.covCPT.setNanColor(Color.LIGHT_GRAY);
        this.covDiffCPT = GMT_CPT_Files.DIVERGING_BAM_UNIFORM.instance().reverse().rescale(-0.3, 0.3);
        this.covDiffCPT.setNanColor(Color.LIGHT_GRAY);
        this.sdCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 0.2);
        this.sdCPT.setNanColor(Color.LIGHT_GRAY);
        this.sdDiffCPT = GMT_CPT_Files.DIVERGING_BAM_UNIFORM.instance().reverse().rescale(-0.05, 0.05);
        this.sdDiffCPT.setNanColor(Color.LIGHT_GRAY);
        this.pDiffCPT = GMT_CPT_Files.DIVERGING_VIK_UNIFORM.instance().rescale(-50.0, 50.0);
        this.pDiffCPT.setNanColor(Color.LIGHT_GRAY);
        this.diffCPT = GMT_CPT_Files.DIVERGING_BAM_UNIFORM.instance().reverse().rescale(-0.2, 0.2);
        this.diffCPT.setNanColor(Color.LIGHT_GRAY);
        this.percentileCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 100.0);
        this.percentileCPT.setNanColor(Color.BLACK);
        this.percentileCPT.setBelowMinColor(Color.LIGHT_GRAY);
        this.zip = new ZipFile(mapsZipFile);
        ZipEntry regEntry = this.zip.getEntry("gridded_region.geojson");
        if (regEntry != null) {
            System.out.println("Reading gridded region from zip file: " + regEntry.getName());
            BufferedReader bRead = new BufferedReader(new InputStreamReader(this.zip.getInputStream(regEntry)));
            this.gridReg = GriddedRegion.fromFeature(Feature.read(bRead));
            spacing = this.gridReg.getSpacing();
        }
        if (tree == null) {
            this.branches = new ArrayList();
            this.weights = new ArrayList<Double>();
            this.branches.add(null);
            this.weights.add(1.0);
            this.totWeight = 1.0;
            Preconditions.checkNotNull((Object)this.gridReg, (Object)"Must supply gridded region in zip file if external");
        } else {
            this.branches = tree.getBranches();
            this.weights = new ArrayList<Double>();
            BranchWeightProvider weightProv = tree.getWeightProvider();
            for (int i = 0; i < this.branches.size(); ++i) {
                LogicTreeBranch<?> branch = this.branches.get(i);
                double weight = weightProv.getWeight(branch);
                Preconditions.checkState((weight >= 0.0 ? 1 : 0) != 0, (String)"Bad weight=%s for branch %s, weightProv=%s", (Object)weight, branch, (Object)weightProv.getClass().getName());
                if (weight == 0.0) {
                    System.err.println("WARNING: zero weight for branch: " + String.valueOf(branch));
                }
                this.weights.add(weight);
                this.totWeight += weight;
            }
        }
        int threads = Integer.max(2, Integer.min(16, FaultSysTools.defaultNumThreads()));
        this.exec = ExecutorUtils.newBlockingThreadPool(threads, Integer.max(threads * 4, threads + 10));
        System.out.println(this.branches.size() + " branches, total weight: " + this.totWeight);
    }

    public void setCPTRange(double lower, double upper) {
        try {
            this.logCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(lower, upper);
            this.logCPT.setLog10(true);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public void setPDiffRange(double maxPDiff) {
        this.pDiffCPT = this.pDiffCPT.rescale(-maxPDiff, maxPDiff);
    }

    public void setDiffRange(double maxDiff) {
        this.diffCPT = this.diffCPT.rescale(-maxDiff, maxDiff);
    }

    public SolHazardMapCalc getMapper() {
        return this.mapper;
    }

    public void setGriddedRegion(GriddedRegion gridReg) {
        this.gridReg = gridReg;
    }

    public synchronized GriddedGeoDataSet[] loadMaps(final SolHazardMapCalc.ReturnPeriods rp, final double period) throws IOException {
        String line;
        BufferedReader bRead;
        ZipEntry entry;
        FaultSystemSolution sol;
        System.out.println("Loading maps for rp=" + String.valueOf((Object)rp) + ", period=" + period);
        final GriddedGeoDataSet[] rpPerMaps = new GriddedGeoDataSet[this.branches.size()];
        int printMod = 10;
        LinkedList processFutures = new LinkedList();
        CompletableFuture<Runnable> readFuture = null;
        LogicTreeBranch<?> branch0 = this.branches.get(0);
        if (branch0 != null) {
            sol = null;
            if (this.mapper == null && this.solLogicTree != null) {
                sol = this.solLogicTree.forBranch(branch0, false);
            }
            if (this.gridReg == null) {
                if (this.spacing <= 0.0) {
                    String dirName = branch0.getBranchZipPath();
                    String name = dirName + "/" + MPJ_LogicTreeHazardCalc.mapPrefix(this.periods[0], this.rps[0]) + ".txt";
                    entry = this.zip.getEntry(name);
                    Preconditions.checkNotNull((Object)entry, (String)"Entry is null for %s", (Object)name);
                    InputStream is = this.zip.getInputStream(entry);
                    Preconditions.checkNotNull((Object)is, (String)"IS is null for %s", (Object)name);
                    bRead = new BufferedReader(new InputStreamReader(is));
                    line = bRead.readLine();
                    double prevLat = Double.NaN;
                    double prevLon = Double.NaN;
                    ArrayList<Double> deltas = new ArrayList<Double>();
                    while (line != null) {
                        if (!(line = line.trim()).startsWith("#")) {
                            StringTokenizer tok = new StringTokenizer(line);
                            double lon = Double.parseDouble(tok.nextToken());
                            double lat = Double.parseDouble(tok.nextToken());
                            if (Double.isFinite(prevLat)) {
                                deltas.add(Math.abs(lat - prevLat));
                                deltas.add(Math.abs(lon - prevLon));
                            }
                            prevLat = lat;
                            prevLon = lon;
                        }
                        line = bRead.readLine();
                    }
                    double medianSpacing = DataUtils.median(Doubles.toArray(deltas));
                    medianSpacing = (double)Math.round(medianSpacing * 1000.0) / 1000.0;
                    System.out.println("Detected spacing: " + medianSpacing + " degrees");
                    this.spacing = medianSpacing;
                }
                Preconditions.checkNotNull((Object)this.solLogicTree, (Object)"Can't determine region; neither a region nor a solution was found.");
                sol = this.solLogicTree.forBranch(branch0);
                Region region = ReportMetadata.detectRegion(sol);
                if (region == null) {
                    region = RupSetMapMaker.buildBufferedRegion(sol.getRupSet().getFaultSectionDataList());
                }
                this.gridReg = new GriddedRegion(region, this.spacing, GriddedRegion.ANCHOR_0_0);
            }
            boolean bl = this.floatMaps = this.branches.size() > 10000 && this.gridReg.getNodeCount() > 10000;
            if (this.floatMaps) {
                System.out.println("Loading maps at 4-byte floating precision for " + this.branches.size() + " branches and " + this.gridReg.getNodeCount() + " grid locs");
            }
            if (this.mapper == null) {
                this.mapper = new SolHazardMapCalc(sol, null, this.gridReg, this.periods);
                if (this.mapRegion != null) {
                    this.mapper.setMapPlotRegion(this.mapRegion);
                }
            }
        }
        if (this.mapper == null) {
            if (this.solLogicTree != null && this.solLogicTree instanceof SolutionLogicTree.InMemory && this.tree == null) {
                sol = this.solLogicTree.forBranch(null);
                this.mapper = new SolHazardMapCalc(sol, null, this.gridReg, this.periods);
            } else {
                this.mapper = new SolHazardMapCalc(null, null, this.gridReg, this.periods);
            }
            if (this.mapRegion != null) {
                this.mapper.setMapPlotRegion(this.mapRegion);
            }
        }
        Stopwatch watch = Stopwatch.createStarted();
        for (int i = 0; i < this.branches.size(); ++i) {
            LogicTreeBranch<?> branch;
            if (i % printMod == 0) {
                try {
                    while (!processFutures.isEmpty()) {
                        ((Future)processFutures.pop()).get();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                String str = "Loading map for branch " + i + "/" + this.branches.size();
                if (i > 0) {
                    double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                    double rate = (double)i / secs;
                    str = str + " (rate=" + twoDigits.format((double)i / secs) + " /s; ";
                    int branchesLeft = this.branches.size() - i;
                    double secsLeft = (double)branchesLeft / rate;
                    if (secsLeft < 120.0) {
                        str = str + twoDigits.format(secsLeft) + " s";
                    } else {
                        double minsLeft = secsLeft / 60.0;
                        str = str + twoDigits.format(minsLeft) + " m";
                    }
                    str = str + " left)";
                }
                System.out.println(str);
            }
            if (i >= printMod * 10 && printMod < 1000) {
                printMod *= 10;
            }
            if ((branch = this.branches.get(i)) == null) {
                Preconditions.checkState((this.branches.size() == 1 ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)this.gridReg, (Object)"Must supply gridded region in zip file if external");
                entry = this.zip.getEntry(MPJ_LogicTreeHazardCalc.mapPrefix(period, rp) + ".txt");
                GriddedGeoDataSet xyz = new GriddedGeoDataSet(this.gridReg, false);
                bRead = new BufferedReader(new InputStreamReader(this.zip.getInputStream(entry)));
                line = bRead.readLine();
                int index = 0;
                while (line != null) {
                    if (!(line = line.trim()).startsWith("#")) {
                        StringTokenizer tok = new StringTokenizer(line);
                        double lon = Double.parseDouble(tok.nextToken());
                        double lat = Double.parseDouble(tok.nextToken());
                        double val = Double.parseDouble(tok.nextToken());
                        Location loc = new Location(lat, lon);
                        Preconditions.checkState((boolean)LocationUtils.areSimilar(loc, this.gridReg.getLocation(index)));
                        xyz.set(index++, val);
                    }
                    line = bRead.readLine();
                }
                Preconditions.checkState((index == this.gridReg.getNodeCount() ? 1 : 0) != 0);
                rpPerMaps[0] = this.checkRemap(xyz);
                continue;
            }
            final String dirName = branch.getBranchZipPath();
            if (readFuture != null) {
                processFutures.push(this.exec.submit((Runnable)readFuture.join()));
            }
            final int mapIndex = i;
            readFuture = CompletableFuture.supplyAsync(new Supplier<Runnable>(){
                final /* synthetic */ LogicTreeHazardCompare this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Runnable get() {
                    final String entryName = dirName + "/" + MPJ_LogicTreeHazardCalc.mapPrefix(period, rp) + ".txt";
                    try {
                        ZipEntry entry = this.this$0.zip.getEntry(entryName);
                        final BufferedReader bRead = this.this$0.prereadMapEntry(entry);
                        return new Runnable(){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                try {
                                    rpPerMaps[mapIndex] = this.this$1.this$0.readMapReader(bRead);
                                }
                                catch (IOException e) {
                                    System.err.println("Exception loading: " + entryName);
                                    System.err.flush();
                                    throw ExceptionUtils.asRuntimeException(e);
                                }
                            }
                        };
                    }
                    catch (Exception e) {
                        System.err.println("Exception loading: " + entryName);
                        System.err.flush();
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
            });
        }
        if (readFuture != null) {
            processFutures.push(this.exec.submit((Runnable)readFuture.join()));
        }
        try {
            while (!processFutures.isEmpty()) {
                ((Future)processFutures.pop()).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        watch.stop();
        LogicTreeHazardCompare.printTime(watch, "load " + this.branches.size() + " maps", 0.0);
        return rpPerMaps;
    }

    private BufferedReader prereadMapEntry(ZipEntry entry) throws IOException {
        int length;
        InputStream is = this.zip.getInputStream(entry);
        int size = Integer.max(1024, Integer.min(102400, (int)(entry.getSize() / 12L)));
        byte[] buffer = new byte[size];
        ByteArrayOutputStream os = new ByteArrayOutputStream(size);
        while ((length = is.read(buffer)) != -1) {
            os.write(buffer, 0, length);
        }
        return new BufferedReader(new StringReader(os.toString(Charset.defaultCharset())));
    }

    private GriddedGeoDataSet readMapEntry(ZipEntry entry) throws IOException {
        BufferedReader bRead = new BufferedReader(new InputStreamReader(this.zip.getInputStream(entry)));
        return this.readMapReader(bRead);
    }

    private GriddedGeoDataSet readMapReader(BufferedReader bRead) throws IOException {
        GriddedGeoDataSet xyz = this.floatMaps ? new GriddedGeoDataSet.FloatData(this.gridReg, false) : new GriddedGeoDataSet(this.gridReg, false);
        String line = bRead.readLine();
        int index = 0;
        while (line != null) {
            if (!(line = line.trim()).startsWith("#")) {
                StringTokenizer tok = new StringTokenizer(line);
                double lon = Double.parseDouble(tok.nextToken());
                double lat = Double.parseDouble(tok.nextToken());
                double val = Double.parseDouble(tok.nextToken());
                Location loc = new Location(lat, lon);
                Preconditions.checkState((boolean)LocationUtils.areSimilar(loc, this.gridReg.getLocation(index)));
                xyz.set(index++, val);
            }
            line = bRead.readLine();
        }
        Preconditions.checkState((index == this.gridReg.getNodeCount() ? 1 : 0) != 0);
        return this.checkRemap(xyz);
    }

    GriddedGeoDataSet loadPrecomputedMeanMap(String key, SolHazardMapCalc.ReturnPeriods rp, double period) throws IOException {
        String entryName = key + "_" + MPJ_LogicTreeHazardCalc.mapPrefix(period, rp) + ".txt";
        ZipEntry entry = this.zip.getEntry(entryName);
        if (entry == null) {
            return null;
        }
        return this.readMapEntry(entry);
    }

    public void setRemapToRegion(GriddedRegion gridReg) {
        this.forceRemapRegion = gridReg;
    }

    private GriddedGeoDataSet checkRemap(GriddedGeoDataSet xyz) {
        if (this.forceRemapRegion != null) {
            int origCount = this.gridReg.getNodeCount();
            int newCount = this.forceRemapRegion.getNodeCount();
            int testIndex = origCount / 3;
            if (origCount != newCount || !LocationUtils.areSimilar(this.gridReg.getLocation(testIndex), this.forceRemapRegion.getLocation(testIndex))) {
                GriddedGeoDataSet remapped = new GriddedGeoDataSet(this.forceRemapRegion, false);
                for (int i = 0; i < newCount; ++i) {
                    int origIndex = this.gridReg.indexForLocation(remapped.getLocation(i));
                    if (origIndex >= 0) {
                        remapped.set(i, xyz.get(origIndex));
                        continue;
                    }
                    remapped.set(i, 0.0);
                }
                xyz = remapped;
            }
        }
        return xyz;
    }

    public GriddedGeoDataSet buildMean(GriddedGeoDataSet[] maps) {
        GriddedGeoDataSet avg = new GriddedGeoDataSet(maps[0].getRegion(), false);
        for (int i = 0; i < avg.size(); ++i) {
            double val = 0.0;
            for (int j = 0; j < maps.length; ++j) {
                val += maps[j].get(i) * this.weights.get(j);
            }
            avg.set(i, val /= this.totWeight);
        }
        return avg;
    }

    public static GriddedGeoDataSet buildMean(List<GriddedGeoDataSet> maps, List<Double> weights) {
        GriddedGeoDataSet avg = new GriddedGeoDataSet(maps.get(0).getRegion(), false);
        double totWeight = 0.0;
        for (Double weight : weights) {
            totWeight += weight.doubleValue();
        }
        for (int i = 0; i < avg.size(); ++i) {
            double val = 0.0;
            for (int j = 0; j < maps.size(); ++j) {
                val += maps.get(j).get(i) * weights.get(j);
            }
            avg.set(i, val /= totWeight);
        }
        return avg;
    }

    GriddedGeoDataSet buildMin(GriddedGeoDataSet[] maps, List<Double> weights) {
        Preconditions.checkState((maps.length == weights.size() ? 1 : 0) != 0);
        GriddedGeoDataSet min = new GriddedGeoDataSet(maps[0].getRegion(), false);
        for (int i = 0; i < min.size(); ++i) {
            double val = Double.POSITIVE_INFINITY;
            for (int j = 0; j < maps.length; ++j) {
                if (!(weights.get(j) > 0.0)) continue;
                val = Math.min(val, maps[j].get(i));
            }
            min.set(i, val);
        }
        return min;
    }

    GriddedGeoDataSet buildMax(GriddedGeoDataSet[] maps, List<Double> weights) {
        Preconditions.checkState((maps.length == weights.size() ? 1 : 0) != 0);
        GriddedGeoDataSet max = new GriddedGeoDataSet(maps[0].getRegion(), false);
        for (int i = 0; i < max.size(); ++i) {
            double val = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < maps.length; ++j) {
                if (!(weights.get(j) > 0.0)) continue;
                val = Math.max(val, maps[j].get(i));
            }
            max.set(i, val);
        }
        return max;
    }

    private GriddedGeoDataSet buildPDiffFromRange(GriddedGeoDataSet min, GriddedGeoDataSet max, GriddedGeoDataSet comp) {
        GriddedGeoDataSet diff = new GriddedGeoDataSet(min.getRegion(), false);
        for (int i = 0; i < max.size(); ++i) {
            double compVal = comp.get(i);
            double minVal = min.get(i);
            double maxVal = max.get(i);
            double pDiff = compVal >= minVal && compVal <= maxVal ? 0.0 : (compVal < minVal ? 100.0 * (compVal - minVal) / minVal : 100.0 * (compVal - maxVal) / maxVal);
            diff.set(i, pDiff);
        }
        return diff;
    }

    private GriddedGeoDataSet buildSpread(GriddedGeoDataSet min, GriddedGeoDataSet max) {
        GriddedGeoDataSet diff = new GriddedGeoDataSet(min.getRegion(), false);
        for (int i = 0; i < max.size(); ++i) {
            double minVal = min.get(i);
            double maxVal = max.get(i);
            diff.set(i, maxVal - minVal);
        }
        return diff;
    }

    private GriddedGeoDataSet buildPDiff(GriddedGeoDataSet ref, GriddedGeoDataSet comp) {
        GriddedGeoDataSet diff = new GriddedGeoDataSet(ref.getRegion(), false);
        for (int i = 0; i < ref.size(); ++i) {
            double compVal = comp.get(i);
            double refVal = ref.get(i);
            double pDiff = 100.0 * (compVal - refVal) / refVal;
            diff.set(i, pDiff);
        }
        return diff;
    }

    LightFixedXFunc[] buildNormCDFs(GriddedGeoDataSet[] maps, List<Double> weights) {
        return this.buildNormCDFs(List.of(maps), weights);
    }

    private LightFixedXFunc[] buildNormCDFs(final List<GriddedGeoDataSet> maps, final List<Double> weights) {
        Preconditions.checkState((maps.size() == weights.size() ? 1 : 0) != 0);
        final LightFixedXFunc[] ret = new LightFixedXFunc[maps.get(0).size()];
        double totWeight = 0.0;
        for (double weight : weights) {
            totWeight += weight;
        }
        Stopwatch watch = Stopwatch.createStarted();
        if (maps.size() < 500 || ret.length < 100) {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = LogicTreeHazardCompare.calcNormCDF(maps, weights, i, totWeight);
            }
        } else {
            ArrayList futures = new ArrayList(ret.length);
            final double finalTotWeight = totWeight;
            int i = 0;
            while (i < ret.length) {
                final int n = i++;
                futures.add(this.exec.submit(new Runnable(){
                    final /* synthetic */ LogicTreeHazardCompare this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        ret[n] = LogicTreeHazardCompare.calcNormCDF(maps, weights, n, finalTotWeight);
                    }
                }));
            }
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        watch.stop();
        LogicTreeHazardCompare.printTime(watch, "build nrom CDFs for " + maps.size() + " maps", 10.0);
        for (int i = 0; i < ret.length; ++i) {
            LightFixedXFunc ncdf = ret[i];
            if (ncdf.size() <= 1) continue;
            double first = ncdf.getY(0);
            double d = ncdf.getY(ncdf.size() - 1);
            Preconditions.checkState(((float)d == 1.0f ? 1 : 0) != 0, (String)"last value in ncdf not 1: %s", (Object)d);
            Preconditions.checkState((first < d ? 1 : 0) != 0, (String)"first value in ncdf is not less than last: %s %s", (Object)first, (Object)d);
        }
        return ret;
    }

    private static void printTime(Stopwatch watch, String operation, double minSecsToPrint) {
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        if (secs < minSecsToPrint) {
            return;
        }
        if (secs > 90.0) {
            System.out.println("Took " + twoDigits.format(secs / 60.0) + " mins to " + operation);
        } else {
            System.out.println("Took " + twoDigits.format(secs) + " secs to " + operation);
        }
    }

    public static LightFixedXFunc calcNormCDF(List<GriddedGeoDataSet> maps, List<Double> weights, int gridIndex, double totWeight) {
        Preconditions.checkState((totWeight > 0.0 ? 1 : 0) != 0, (String)"Bad total weight=%s", (Object)totWeight);
        Object[] valWeights = new ValWeights[maps.size()];
        for (int j = 0; j < valWeights.length; ++j) {
            valWeights[j] = new ValWeights(maps.get(j).get(gridIndex), weights.get(j));
        }
        Arrays.sort(valWeights);
        int destIndex = -1;
        double[] xVals = new double[valWeights.length];
        double[] yVals = new double[valWeights.length];
        for (int srcIndex = 0; srcIndex < valWeights.length; ++srcIndex) {
            Object val = valWeights[srcIndex];
            if (destIndex >= 0 && (float)((ValWeights)val).val == (float)xVals[destIndex]) {
                int n = destIndex;
                yVals[n] = yVals[n] + ((ValWeights)val).weight;
                continue;
            }
            xVals[++destIndex] = ((ValWeights)val).val;
            yVals[destIndex] = ((ValWeights)val).weight;
        }
        int size = destIndex + 1;
        if (size < xVals.length) {
            xVals = Arrays.copyOf(xVals, size);
            yVals = Arrays.copyOf(yVals, size);
        }
        double sum = 0.0;
        for (int j = 0; j < yVals.length; ++j) {
            yVals[j] = (sum += yVals[j]) / totWeight;
            if (j <= 0) continue;
            Preconditions.checkState((xVals[j] > xVals[j - 1] ? 1 : 0) != 0, (String)"Normm CDF not monotomoically increasing. x[%s]=%s, x[%s]=%s", (Object)(j - 1), (Object)xVals[j - 1], (Object)j, (Object)xVals[j]);
        }
        LightFixedXFunc ret = new LightFixedXFunc(xVals, yVals);
        if ((double)size > 12000.0) {
            double xVal;
            int i;
            EvenlyDiscretizedFunc logVals;
            double[] remappedX = new double[10000];
            if (xVals[0] == 0.0) {
                remappedX[0] = 0.0;
                Preconditions.checkState((xVals[1] > 0.0 ? 1 : 0) != 0);
                logVals = new EvenlyDiscretizedFunc(Math.log(xVals[1]), Math.log(xVals[xVals.length - 1]), 9999);
                for (i = 0; i < logVals.size(); ++i) {
                    xVal = i == 0 ? xVals[1] : (i == xVals.length - 1 ? xVals[xVals.length - 1] : Math.exp(logVals.getX(i)));
                    remappedX[i + 1] = xVal;
                }
            } else {
                logVals = new EvenlyDiscretizedFunc(Math.log(xVals[0]), Math.log(xVals[xVals.length - 1]), 10000);
                for (i = 0; i < logVals.size(); ++i) {
                    xVal = i == 0 ? xVals[0] : (i == xVals.length - 1 ? xVals[xVals.length - 1] : Math.exp(logVals.getX(i)));
                    remappedX[i] = xVal;
                }
            }
            double[] remappedY = new double[10000];
            for (i = 0; i < 10000; ++i) {
                remappedY[i] = i == 0 ? yVals[0] : (i == 9999 ? yVals[yVals.length - 1] : ret.getInterpolatedY(remappedX[i]));
            }
            ret = new LightFixedXFunc(remappedX, remappedY);
        }
        return ret;
    }

    GriddedGeoDataSet calcMapAtPercentile(LightFixedXFunc[] ncdfs, GriddedRegion gridReg, double percentile) {
        Preconditions.checkState((gridReg.getNodeCount() == ncdfs.length ? 1 : 0) != 0, (String)"grid reg has %s, but have %s ncdfs", (int)gridReg.getNodeCount(), (int)ncdfs.length);
        GriddedGeoDataSet ret = new GriddedGeoDataSet(gridReg, false);
        double fractile = percentile / 100.0;
        Preconditions.checkState((fractile >= 0.0 && fractile <= 1.0 ? 1 : 0) != 0);
        Stopwatch watch = Stopwatch.createStarted();
        for (int i = 0; i < ret.size(); ++i) {
            double val = ArbDiscrEmpiricalDistFunc.calcFractileFromNormCDF(ncdfs[i], fractile);
            ret.set(i, val);
        }
        watch.stop();
        LogicTreeHazardCompare.printTime(watch, "calc map at p" + (float)percentile + " for " + ncdfs.length + " normCDFs", 10.0);
        return ret;
    }

    private GriddedGeoDataSet calcIQR(LightFixedXFunc[] ncdfs, GriddedRegion gridReg) {
        GriddedGeoDataSet p75 = this.calcMapAtPercentile(ncdfs, gridReg, 75.0);
        GriddedGeoDataSet p25 = this.calcMapAtPercentile(ncdfs, gridReg, 25.0);
        GriddedGeoDataSet ret = new GriddedGeoDataSet(gridReg, false);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, p75.get(i) - p25.get(i));
        }
        return ret;
    }

    public static GriddedGeoDataSet calcPercentileWithinDist(LightFixedXFunc[] ncdfs, GriddedGeoDataSet comp) {
        Preconditions.checkState((comp.size() == ncdfs.length ? 1 : 0) != 0);
        GriddedGeoDataSet ret = new GriddedGeoDataSet(comp.getRegion(), false);
        for (int i = 0; i < ret.size(); ++i) {
            double compVal = comp.get(i);
            double percentile = ncdfs[i].size() == 1 ? (compVal > 0.0 && (float)ncdfs[i].getX(0) == (float)compVal ? 50.0 : -1.0) : (compVal < ncdfs[i].getMinX() || compVal > ncdfs[i].getMaxX() ? ((float)compVal == (float)ncdfs[i].getMinX() ? 0.0 : ((float)compVal == (float)ncdfs[i].getMaxX() ? 100.0 : Double.NaN)) : 100.0 * ncdfs[i].getInterpolatedY(compVal));
            ret.set(i, percentile);
        }
        return ret;
    }

    private static GriddedGeoDataSet calcPercentileWithinDists(List<LightFixedXFunc[]> ncdfsList, List<Double> weightsList, GriddedGeoDataSet comp) {
        Preconditions.checkState((weightsList.size() == ncdfsList.size() ? 1 : 0) != 0);
        if (ncdfsList.size() == 1) {
            return LogicTreeHazardCompare.calcPercentileWithinDist(ncdfsList.get(0), comp);
        }
        for (LightFixedXFunc[] ncdfs : ncdfsList) {
            Preconditions.checkState((comp.size() == ncdfs.length ? 1 : 0) != 0);
        }
        GriddedGeoDataSet ret = new GriddedGeoDataSet(comp.getRegion(), false);
        double sumWeights = 0.0;
        for (double weight : weightsList) {
            sumWeights += weight;
        }
        double weightScale = 1.0 / sumWeights;
        for (int i = 0; i < ret.size(); ++i) {
            double percentile;
            double compVal = comp.get(i);
            float compValFloat = (float)compVal;
            double minVal = Double.POSITIVE_INFINITY;
            double maxVal = Double.NEGATIVE_INFINITY;
            for (LightFixedXFunc[] ncdfs : ncdfsList) {
                minVal = Double.min(minVal, ncdfs[i].getMinX());
                maxVal = Double.max(maxVal, ncdfs[i].getMaxX());
            }
            if ((float)minVal == (float)maxVal) {
                percentile = compVal > 0.0 && compValFloat == (float)minVal ? 50.0 : -1.0;
            } else if (compVal < minVal || compVal > maxVal) {
                percentile = compValFloat == (float)minVal ? 0.0 : (compValFloat == (float)maxVal ? 100.0 : Double.NaN);
            } else {
                double sumY = 0.0;
                for (int n = 0; n < ncdfsList.size(); ++n) {
                    double weight = weightsList.get(n);
                    LightFixedXFunc[] ncdfs = ncdfsList.get(n);
                    float myMin = (float)ncdfs[i].getMinX();
                    float myMax = (float)ncdfs[i].getMaxX();
                    if (compValFloat == myMin && compValFloat == myMax) {
                        sumY += 0.5 * weight;
                        continue;
                    }
                    if (compValFloat >= myMax) {
                        sumY += weight;
                        continue;
                    }
                    if (compValFloat <= myMin) {
                        sumY += 0.0;
                        continue;
                    }
                    sumY += ncdfs[i].getInterpolatedY(compVal) * weight;
                }
                percentile = 100.0 * sumY * weightScale;
            }
            ret.set(i, percentile);
        }
        return ret;
    }

    private void calcSD_COV(GriddedGeoDataSet[] maps, List<Double> weights, GriddedGeoDataSet meanMap, GriddedGeoDataSet sd, GriddedGeoDataSet cov) {
        LogicTreeHazardCompare.calcSD_COV(maps, weights, meanMap, sd, cov, this.exec);
    }

    static void calcSD_COV(final GriddedGeoDataSet[] maps, List<Double> weights, final GriddedGeoDataSet meanMap, final GriddedGeoDataSet sd, final GriddedGeoDataSet cov, ExecutorService exec) {
        final double[] weightsArray = MathArrays.normalizeArray((double[])Doubles.toArray(weights), (double)weights.size());
        Stopwatch watch = Stopwatch.createStarted();
        if (maps.length < 500 || sd.size() < 100) {
            for (int i = 0; i < sd.size(); ++i) {
                double[] vals = LogicTreeHazardCompare.calcSD_COV(maps, weightsArray, meanMap, i);
                sd.set(i, vals[0]);
                cov.set(i, vals[1]);
            }
        } else {
            ArrayList futures = new ArrayList(sd.size());
            int i = 0;
            while (i < sd.size()) {
                final int n = i++;
                futures.add(exec.submit(new Runnable(){

                    @Override
                    public void run() {
                        double[] vals = LogicTreeHazardCompare.calcSD_COV(maps, weightsArray, meanMap, n);
                        sd.set(n, vals[0]);
                        cov.set(n, vals[1]);
                    }
                }));
            }
            try {
                for (Future future : futures) {
                    future.get();
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        watch.stop();
        LogicTreeHazardCompare.printTime(watch, "calc SDs/COVs for " + maps.length + " maps", 10.0);
    }

    private static double[] calcSD_COV(GriddedGeoDataSet[] maps, double[] weights, GriddedGeoDataSet meanMap, int gridIndex) {
        double cov;
        double sd;
        double mean = meanMap.get(gridIndex);
        if (maps.length == 1) {
            sd = 0.0;
            cov = 0.0;
        } else if (mean == 0.0) {
            sd = 0.0;
            cov = Double.NaN;
        } else {
            Variance var = new Variance(false);
            double[] cellVals = new double[maps.length];
            for (int j = 0; j < cellVals.length; ++j) {
                cellVals[j] = maps[j].get(gridIndex);
            }
            sd = Math.sqrt(var.evaluate(cellVals, weights));
            cov = sd / mean;
        }
        return new double[]{sd, cov};
    }

    public void buildReport(File outputDir, String name, LogicTreeHazardCompare comp, String compName) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        File resourcesDir = new File(outputDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        lines.add("# " + name + " Hazard Maps");
        lines.add("");
        int tocIndex = lines.size();
        String topLink = "_[(top)](#table-of-contents)_";
        this.futures = new ArrayList();
        boolean intermediateWrite = this.branches != null && this.branches.size() > 50 && !new File(outputDir, "index.html").exists();
        int cptWidth = 800;
        ArrayList uniqueSamplingLevels = null;
        Boolean canDecomposeVariance = null;
        AbstractLTVarianceDecomposition varDecomposer = null;
        for (double period : this.periods) {
            Object perPrefix;
            Object unitlessPerLabel;
            if (period == 0.0) {
                unitlessPerLabel = "PGA";
                perPrefix = "pga";
            } else {
                unitlessPerLabel = (float)period + "s SA";
                perPrefix = (float)period + "s";
            }
            String perUnits = "(g)";
            String perLabel = (String)unitlessPerLabel + " " + perUnits;
            for (SolHazardMapCalc.ReturnPeriods rp : this.rps) {
                int index;
                MarkdownUtils.TableBuilder table;
                boolean multi;
                boolean meanIsFromCurves;
                String label = perLabel + ", " + rp.label;
                String unitlessLabel = (String)unitlessPerLabel + ", " + rp.label;
                String prefix = (String)perPrefix + "_" + rp.name();
                PlotUtils.writeScaleLegendOnly(resourcesDir, prefix + "_cpt", GeographicMapMaker.buildCPTLegend(this.logCPT, label), cptWidth, true, true);
                PlotUtils.writeScaleLegendOnly(resourcesDir, prefix + "_cpt_cov", GeographicMapMaker.buildCPTLegend(this.covCPT, "COV, " + unitlessLabel), cptWidth, true, true);
                PlotUtils.writeScaleLegendOnly(resourcesDir, prefix + "_cpt_pDiff", GeographicMapMaker.buildCPTLegend(this.pDiffCPT, "% Change, " + unitlessLabel), cptWidth, true, true);
                PlotUtils.writeScaleLegendOnly(resourcesDir, prefix + "_cpt_diff", GeographicMapMaker.buildCPTLegend(this.diffCPT, "Difference, " + label), cptWidth, true, true);
                System.out.println(label);
                lines.add("## " + unitlessLabel);
                lines.add(topLink);
                lines.add("");
                GriddedGeoDataSet[] maps = this.loadMaps(rp, period);
                Preconditions.checkNotNull((Object)maps);
                for (int i = 0; i < maps.length; ++i) {
                    Preconditions.checkNotNull((Object)maps[i], (String)"map %s is null", (int)i);
                }
                GriddedRegion region = maps[0].getRegion();
                System.out.println("Calculating norm CDFs");
                LightFixedXFunc[] mapNCDFs = this.buildNormCDFs(maps, this.weights);
                System.out.println("Calculating mean, median, bounds, COV");
                GriddedGeoDataSet mean = this.ignorePrecomputed ? null : this.loadPrecomputedMeanMap("mean", rp, period);
                GriddedGeoDataSet mapMean = null;
                boolean bl = meanIsFromCurves = mean != null;
                if (mean == null) {
                    mean = mapMean = this.buildMean(maps);
                }
                GriddedGeoDataSet median = this.calcMapAtPercentile(mapNCDFs, region, 50.0);
                GriddedGeoDataSet max = this.buildMax(maps, this.weights);
                GriddedGeoDataSet min = this.buildMin(maps, this.weights);
                GriddedGeoDataSet spread = this.buildSpread(LogicTreeHazardCompare.log10(min), LogicTreeHazardCompare.log10(max));
                GriddedGeoDataSet iqr = this.calcIQR(mapNCDFs, region);
                GriddedGeoDataSet sd = new GriddedGeoDataSet(region);
                GriddedGeoDataSet cov = new GriddedGeoDataSet(region);
                this.calcSD_COV(maps, this.weights, mean, sd, cov);
                GriddedGeoDataSet meanPercentile = LogicTreeHazardCompare.calcPercentileWithinDist(mapNCDFs, mean);
                File hazardCSV = new File(resourcesDir, prefix + ".csv");
                System.out.println("Writing CSV: " + hazardCSV.getAbsolutePath());
                this.writeHazardCSV(hazardCSV, mean, median, min, max, cov, meanPercentile, null, null);
                LightFixedXFunc[] cmapNCDFs = null;
                GriddedGeoDataSet cmean = null;
                GriddedGeoDataSet cmedian = null;
                GriddedGeoDataSet cmin = null;
                GriddedGeoDataSet cmax = null;
                GriddedGeoDataSet cspread = null;
                GriddedGeoDataSet ciqr = null;
                GriddedGeoDataSet csd = null;
                GriddedGeoDataSet ccov = null;
                GriddedGeoDataSet cMeanPercentile = null;
                GriddedGeoDataSet cMedianPercentile = null;
                boolean bl2 = multi = this.branches.size() > 1;
                if (comp != null) {
                    comp.setRemapToRegion(region);
                    System.out.println("Loading comparison");
                    GriddedGeoDataSet[] cmaps = comp.loadMaps(rp, period);
                    Preconditions.checkNotNull((Object)cmaps);
                    for (int i = 0; i < cmaps.length; ++i) {
                        Preconditions.checkNotNull((Object)cmaps[i], (String)"map %s is null", (int)i);
                    }
                    System.out.println("Calculating comparison norm CDFs");
                    cmapNCDFs = this.buildNormCDFs(cmaps, comp.weights);
                    System.out.println("Calculating comparison mean, median, bounds, COV");
                    if (!this.ignorePrecomputed) {
                        cmean = comp.loadPrecomputedMeanMap("mean", rp, period);
                    }
                    if (cmean == null) {
                        cmean = comp.buildMean(cmaps);
                    }
                    cmedian = this.calcMapAtPercentile(cmapNCDFs, region, 50.0);
                    cmax = comp.buildMax(cmaps, comp.weights);
                    cmin = comp.buildMin(cmaps, comp.weights);
                    cspread = comp.buildSpread(LogicTreeHazardCompare.log10(cmin), LogicTreeHazardCompare.log10(cmax));
                    ciqr = this.calcIQR(cmapNCDFs, region);
                    csd = new GriddedGeoDataSet(region);
                    ccov = new GriddedGeoDataSet(region);
                    this.calcSD_COV(cmaps, comp.weights, cmean, csd, ccov);
                    if (multi) {
                        cMeanPercentile = LogicTreeHazardCompare.calcPercentileWithinDist(mapNCDFs, cmean);
                        cMedianPercentile = LogicTreeHazardCompare.calcPercentileWithinDist(mapNCDFs, cmedian);
                    }
                    File compHazardCSV = new File(resourcesDir, prefix + "_comp.csv");
                    System.out.println("Writing CSV: " + compHazardCSV.getAbsolutePath());
                    this.writeHazardCSV(compHazardCSV, cmean, cmedian, cmin, cmax, ccov, null, cMeanPercentile, cMedianPercentile);
                    lines.add("Download Mean Hazard CSVs: [" + hazardCSV.getName() + "](" + resourcesDir.getName() + "/" + hazardCSV.getName() + ")  [" + compHazardCSV.getName() + "](" + resourcesDir.getName() + "/" + compHazardCSV.getName() + ")");
                } else {
                    lines.add("Download Mean Hazard CSV: [" + hazardCSV.getName() + "](" + resourcesDir.getName() + "/" + hazardCSV.getName() + ")");
                }
                lines.add("");
                boolean cmulti = comp != null && comp.branches != null && comp.branches.size() > 1;
                SolHazardMapCalc.MapPlot meanMapPlot = this.mapper.buildMapPlot(resourcesDir, prefix + "_mean", mean, this.logCPT, TITLES ? name : " ", (multi ? "Weighted-Average" : "Mean") + ", " + label, false);
                File meanMapFile = new File(resourcesDir, meanMapPlot.prefix + ".png");
                GriddedGeoDataSet.writeXYZFile((XYZ_DataSet)mean, new File(resourcesDir, prefix + "_mean.xyz"));
                File medianMapFile = null;
                if (multi) {
                    medianMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_median", median, this.logCPT, TITLES ? name : " ", "Weighted-Median, " + label);
                    GriddedGeoDataSet.writeXYZFile((XYZ_DataSet)median, new File(resourcesDir, prefix + "_median.xyz"));
                }
                if (cmean == null) {
                    if (multi) {
                        lines.add("### Mean and median hazard maps, " + unitlessLabel);
                        lines.add(topLink);
                        lines.add("");
                    }
                    table = MarkdownUtils.tableBuilder();
                    if (multi) {
                        table.initNewLine();
                        table.addColumn(MarkdownUtils.boldCentered("Weighted-Average"));
                        table.addColumn(MarkdownUtils.boldCentered("Weighted-Median"));
                        table.finalizeLine();
                    }
                    table.initNewLine();
                    table.addColumn("![Mean Map](" + resourcesDir.getName() + "/" + meanMapFile.getName() + ")");
                    if (multi) {
                        table.addColumn("![Median Map](" + resourcesDir.getName() + "/" + medianMapFile.getName() + ")");
                    }
                    table.finalizeLine();
                    table.initNewLine();
                    table.addColumn(this.mapStats(mean));
                    if (multi) {
                        table.addColumn(this.mapStats(median));
                    }
                    table.finalizeLine();
                    lines.addAll(table.build());
                    lines.add("");
                    if (!multi) {
                        if (!intermediateWrite) continue;
                        LogicTreeHazardCompare.writeIntermediate(outputDir, lines, tocIndex);
                        continue;
                    }
                } else {
                    if (multi) {
                        lines.add("### Mean hazard maps and comparisons, " + unitlessLabel);
                        lines.add(topLink);
                        lines.add("");
                    }
                    table = MarkdownUtils.tableBuilder();
                    File cmeanMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp_mean", cmean, this.logCPT, TITLES ? compName : " ", "Weighted-Average, " + label);
                    GriddedGeoDataSet.writeXYZFile((XYZ_DataSet)cmean, new File(resourcesDir, prefix + "_comp_mean.xyz"));
                    table.initNewLine();
                    if (multi) {
                        table.addColumn(MarkdownUtils.boldCentered("Primary (_" + name + "_) Weighted-Average"));
                    } else {
                        table.addColumn(MarkdownUtils.boldCentered("Primary (_" + name + "_)"));
                    }
                    if (cmulti) {
                        table.addColumn(MarkdownUtils.boldCentered("Comparison (_" + compName + "_) Weighted-Average"));
                    } else {
                        table.addColumn(MarkdownUtils.boldCentered("Comparison (_" + compName + "_)"));
                    }
                    table.finalizeLine().initNewLine();
                    table.addColumn("![Mean Map](" + resourcesDir.getName() + "/" + meanMapFile.getName() + ")");
                    table.addColumn("![Mean Map](" + resourcesDir.getName() + "/" + cmeanMapFile.getName() + ")");
                    table.finalizeLine();
                    table.initNewLine();
                    table.addColumn(this.mapStats(mean));
                    if (multi) {
                        table.addColumn(this.mapStats(cmean));
                    }
                    table.finalizeLine();
                    lines.addAll(table.build());
                    lines.add("");
                    if (multi) {
                        GriddedGeoDataSet remappedMeanPercentile;
                        table = MarkdownUtils.tableBuilder();
                        this.addDiffInclExtremesLines(mean, name, min, max, cmean, compName, prefix + "_mean", resourcesDir, table, "Mean", unitlessLabel, false, comp.gridReg);
                        this.addDiffInclExtremesLines(mean, name, min, max, cmean, compName, prefix + "_mean", resourcesDir, table, "Mean", label, true, comp.gridReg);
                        lines.add("The following plots compare mean hazard between _" + name + "_ and a comparison model, _" + compName + "_. The top row gives hazard ratios, expressed as % change, and the bottom row gives differences.");
                        lines.add("");
                        lines.add("The left column compares the mean maps directly, with the comparison model as the divisor/subtrahend. Warmer colors indicate increased hazard in _" + name + "_ relative to _" + compName + "_.");
                        lines.add("");
                        lines.add("The right column shows where and by how much the comparison mean model (_" + compName + "_) is outside the distribution of values across all branches of the primary model (_" + name + "_). Here, places that are zeros (light gray) indicate that the comparison mean hazard map is fully contained within the range of values in _" + name + "_, cool colors indicate areas where the primary model is always lower than the comparison mean model, and warm colors areas where the primary model is always greater. Note that the color scales are reversed here so that colors are consistent with the left column even though the comparison model is now the dividend/minuend.");
                        lines.add("");
                        lines.addAll(table.build());
                        lines.add("");
                        File cmedianMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp_median", cmedian, this.logCPT, TITLES ? compName : " ", "Weighted-Median, " + label);
                        GriddedGeoDataSet.writeXYZFile((XYZ_DataSet)cmedian, new File(resourcesDir, prefix + "_comp_median.xyz"));
                        lines.add("### Median hazard maps and comparisons, " + unitlessLabel);
                        lines.add(topLink);
                        lines.add("");
                        table = MarkdownUtils.tableBuilder();
                        table.initNewLine();
                        table.addColumn(MarkdownUtils.boldCentered("Primary Weighted-Median"));
                        if (cmulti) {
                            table.addColumn(MarkdownUtils.boldCentered("Comparison Weighted-Median"));
                        } else {
                            table.addColumn(MarkdownUtils.boldCentered("Comparison"));
                        }
                        table.finalizeLine().initNewLine();
                        table.addColumn("![Median Map](" + resourcesDir.getName() + "/" + medianMapFile.getName() + ")");
                        table.addColumn("![Median Map](" + resourcesDir.getName() + "/" + cmedianMapFile.getName() + ")");
                        table.finalizeLine();
                        table.initNewLine();
                        table.addColumn(this.mapStats(median));
                        if (multi) {
                            table.addColumn(this.mapStats(cmedian));
                        }
                        table.finalizeLine();
                        lines.addAll(table.build());
                        lines.add("");
                        table = MarkdownUtils.tableBuilder();
                        this.addDiffInclExtremesLines(median, name, min, max, cmedian, compName, prefix + "_median", resourcesDir, table, "Median", unitlessLabel, false, comp.gridReg);
                        this.addDiffInclExtremesLines(median, name, min, max, cmedian, compName, prefix + "_median", resourcesDir, table, "Median", label, true, comp.gridReg);
                        lines.add("");
                        lines.add("This section is the same as above, but using median hazard maps rather than mean.");
                        lines.add("");
                        lines.addAll(table.build());
                        lines.add("");
                        table = MarkdownUtils.tableBuilder();
                        table.addLine(MarkdownUtils.boldCentered("Comparison Mean Percentile"), MarkdownUtils.boldCentered("Comparison Median Percentile"));
                        if (comp.gridReg.getNodeCount() < this.gridReg.getNodeCount() && this.checkShrinkToComparison(cMeanPercentile, remappedMeanPercentile = new GriddedGeoDataSet(comp.gridReg, false))) {
                            GriddedGeoDataSet remappedMedianPercentile = new GriddedGeoDataSet(comp.gridReg, false);
                            Preconditions.checkState((boolean)this.checkShrinkToComparison(cMedianPercentile, remappedMedianPercentile));
                            cMeanPercentile = remappedMeanPercentile;
                            cMedianPercentile = remappedMedianPercentile;
                        }
                        table.initNewLine();
                        File map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp_mean_percentile", cMeanPercentile, this.percentileCPT, (String)(TITLES ? name + " vs " + compName : " "), "Comparison Mean %-ile, " + unitlessLabel);
                        table.addColumn("![Mean Percentile Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
                        map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp_median_percentile", cMedianPercentile, this.percentileCPT, (String)(TITLES ? name + " vs " + compName : " "), "Comparison Median %-ile, " + unitlessLabel);
                        table.addColumn("![Median Percentile Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
                        table.finalizeLine();
                        table.addLine(this.mapStats(cMeanPercentile), this.mapStats(cMedianPercentile));
                        lines.add("### Percentile comparison maps, " + unitlessLabel);
                        lines.add(topLink);
                        lines.add("");
                        lines.add("The maps below show where the comparison (_" + compName + "_) model mean (left column) and median (right column) map lies within the primary model (_" + name + "_) distribution. Areas where the comparison mean or median map is outside the primary model distribution are shown here in black regardless of if they are above or below.");
                        lines.add("");
                        lines.addAll(table.build());
                        lines.add("");
                    } else {
                        table = MarkdownUtils.tableBuilder();
                        this.addSingleBranchDiffLines(mean, name, cmean, compName, prefix + "_mean", resourcesDir, table, unitlessLabel, label, comp.gridReg);
                        lines.add("The following plots compare hazard between _" + name + "_ and a comparison model, _" + compName + "_. The left column gives hazard ratios, expressed as % change, and the right column gives differences. The comparison model is the divisor/subtrahend; warmer colors indicate increased hazard in _" + name + "_ relative to _" + compName + "_.");
                        lines.add("");
                        lines.addAll(table.build());
                        lines.add("");
                        if (!intermediateWrite) continue;
                        LogicTreeHazardCompare.writeIntermediate(outputDir, lines, tocIndex);
                        continue;
                    }
                }
                table = MarkdownUtils.tableBuilder();
                File meanPercentileMap = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_mean_percentile", meanPercentile, this.percentileCPT, TITLES ? "Branch-Averaged Percentiles" : " ", "Branch Averaged %-ile, " + unitlessLabel);
                table.addLine("Mean Map Percentile", "Mean vs Median");
                GriddedGeoDataSet meanMedDiff = this.buildPDiff(median, mean);
                File meanMedDiffMap = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_mean_median_diff", meanMedDiff, this.pDiffCPT, TITLES ? name : " ", "Mean / Median, % Change, " + unitlessLabel, true);
                table.addLine("![BA percentiles](" + resourcesDir.getName() + "/" + meanPercentileMap.getName() + ")", "![Median vs Mean](" + resourcesDir.getName() + "/" + meanMedDiffMap.getName() + ")");
                table.addLine(this.mapStats(meanPercentile), this.mapStats(meanMedDiff, true));
                Object branchStr = "Branched-average hazard can be dominated by outlier branches. The map below on the left shows the percentile at which the ";
                branchStr = comp != null ? (String)branchStr + "primary model's mean map lies within its own full hazard distribution. " : (String)branchStr + "mean map lies within the full hazard distribution. ";
                branchStr = (String)branchStr + "Areas far from the 50-th percentile here are likely outlier-dominated and may show up in percentile comparison maps, even if mean hazard differences are minimal. Keep this in mind when evaluating ";
                if (comp != null) {
                    branchStr = (String)branchStr + "the maps above, and ";
                }
                branchStr = (String)branchStr + "the influence of individual logic tree branches by this metric. The right map show the ratio of mean to median hazard.";
                if (DEBUG_LOC != null && (index = this.gridReg.indexForLocation(DEBUG_LOC)) > 0) {
                    File debugFile = new File(resourcesDir, "loc_debug_" + prefix + ".txt");
                    System.out.println("Writing debug info to: " + debugFile.getAbsolutePath());
                    FileWriter fw = new FileWriter(debugFile);
                    fw.write("Median, mean, percentile debug for location " + index + ": " + String.valueOf(DEBUG_LOC) + "\n");
                    fw.write("Mean: " + mean.get(index) + "\n");
                    fw.write("Median: " + median.get(index) + "\n");
                    fw.write("Mean percentile: " + meanPercentile.get(index) + "\n");
                    fw.write("Norm CDF:\n");
                    LightFixedXFunc ncdf = mapNCDFs[index];
                    for (int i = 0; i < ncdf.size(); ++i) {
                        fw.write("\t" + (float)ncdf.getX(i) + "\t" + (float)ncdf.getY(i) + "\n");
                    }
                    fw.close();
                }
                lines.add((String)branchStr);
                lines.add("");
                if (meanIsFromCurves) {
                    lines.add("Note: The mean map here is computed directly from mean hazard curves, but the median map is taken as the median value of hazard maps across all branches (rather than first calculating median curves at each location), which might bias this comparison.");
                    lines.add("");
                }
                lines.addAll(table.build());
                lines.add("");
                lines.add("### Bounds, spread, and COV, " + unitlessLabel);
                lines.add(topLink);
                lines.add("");
                String minMaxStr = "The maps below show the range of values across all logic tree branches, the ratio of the maximum to minimum value, the interquartile range (p75 - p25), standard deviation, and the coefficient of variation (std. dev. / mean). Note that the minimum and maximum maps are not a result for any single logic tree branch, but rather the smallest or largest value encountered at each location across all logic tree branches.";
                if (cmean == null || comp.branches.size() == 1) {
                    table = MarkdownUtils.tableBuilder();
                    table.addLine(MarkdownUtils.boldCentered("Minimum"), MarkdownUtils.boldCentered("Maximum"));
                    File minMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_min", min, this.logCPT, TITLES ? name : " ", "Minimum, " + label);
                    File maxMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_max", max, this.logCPT, TITLES ? name : " ", "Maximum, " + label);
                    File spreadMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_spread", spread, this.spreadCPT, TITLES ? name : " ", "Log10 (Max/Min), " + unitlessLabel);
                    File iqrMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_iqr", iqr, this.iqrCPT, TITLES ? name : " ", "IQR, " + label);
                    File sdMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_sd", sd, this.sdCPT, TITLES ? name : " ", "SD, " + label);
                    File covMapFile = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_cov", cov, this.covCPT, TITLES ? name : " ", "COV, " + unitlessLabel);
                    table.initNewLine();
                    table.addColumn("![Min Map](" + resourcesDir.getName() + "/" + minMapFile.getName() + ")");
                    table.addColumn("![Max Map](" + resourcesDir.getName() + "/" + maxMapFile.getName() + ")");
                    table.finalizeLine();
                    table.addLine(this.mapStats(min), this.mapStats(max));
                    table.addLine(MarkdownUtils.boldCentered("Log10 (Max/Min)"), MarkdownUtils.boldCentered("Interquartile Range"));
                    table.initNewLine();
                    table.addColumn("![Spread Map](" + resourcesDir.getName() + "/" + spreadMapFile.getName() + ")");
                    table.addColumn("![IQR Map](" + resourcesDir.getName() + "/" + iqrMapFile.getName() + ")");
                    table.finalizeLine();
                    table.addLine(this.mapStats(spread), this.mapStats(iqr));
                    table.addLine(MarkdownUtils.boldCentered("SD"), MarkdownUtils.boldCentered("COV"));
                    table.initNewLine();
                    table.addColumn("![SD Map](" + resourcesDir.getName() + "/" + sdMapFile.getName() + ")");
                    table.addColumn("![COV Map](" + resourcesDir.getName() + "/" + covMapFile.getName() + ")");
                    table.finalizeLine();
                    table.addLine(this.mapStats(sd), this.mapStats(cov));
                    lines.add("");
                    lines.add(minMaxStr);
                    lines.add("");
                    lines.addAll(table.build());
                    lines.add("");
                } else {
                    table = MarkdownUtils.tableBuilder();
                    this.addMapCompDiffLines(min, name, cmin, compName, prefix + "_min", resourcesDir, table, "Minimum", "Minimum " + label, "Minimum " + unitlessLabel, this.logCPT, this.diffCPT, this.pDiffCPT, comp.gridReg);
                    this.addMapCompDiffLines(max, name, cmax, compName, prefix + "_max", resourcesDir, table, "Maximum", "Maximum " + label, "Maximum " + unitlessLabel, this.logCPT, this.diffCPT, this.pDiffCPT, comp.gridReg);
                    this.addMapCompDiffLines(spread, name, cspread, compName, prefix + "_spread", resourcesDir, table, "Log10 (Max/Min)", "Log10 (Max/Min) " + unitlessLabel, "Log10 (Max/Min) " + unitlessLabel, this.spreadCPT, this.spreadDiffCPT, this.pDiffCPT, comp.gridReg);
                    this.addMapCompDiffLines(iqr, name, ciqr, compName, prefix + "_iqr", resourcesDir, table, "Interquartile Range", "IQR " + label, "IQR " + unitlessLabel, this.iqrCPT, this.iqrDiffCPT, this.pDiffCPT, comp.gridReg);
                    this.addMapCompDiffLines(sd, name, csd, compName, prefix + "_sd", resourcesDir, table, "SD", label + ", SD", unitlessLabel + ", SD", this.sdCPT, this.sdDiffCPT, this.pDiffCPT, comp.gridReg);
                    this.addMapCompDiffLines(cov, name, ccov, compName, prefix + "_cov", resourcesDir, table, "COV", unitlessLabel + ", COV", unitlessLabel + ", COV", this.covCPT, this.covDiffCPT, this.pDiffCPT, comp.gridReg);
                    lines.add("");
                    lines.add(minMaxStr + " Each of those quantities is plotted separately for the primary and comparison model, then compared in the rightmost columns.");
                    lines.add("");
                    lines.addAll(table.build());
                    lines.add("");
                }
                if (this.skipLogicTree) {
                    if (!intermediateWrite) continue;
                    LogicTreeHazardCompare.writeIntermediate(outputDir, lines, tocIndex);
                    continue;
                }
                cmapNCDFs = null;
                cmean = null;
                cmedian = null;
                cmin = null;
                cmax = null;
                cspread = null;
                ccov = null;
                System.gc();
                lines.add("### " + unitlessLabel + " Logic Tree Comparisons");
                lines.add(topLink);
                lines.add("");
                lines.add("This section shows how hazard changes across branch choices at each level of the logic tree. The summary figures below show mean hazard on the left, and then ratios & differences between the mean map considering subsets of the model holding each branch choice constant, and the overall mean map.");
                lines.add("");
                lines.add("Summary CSVs: [Branch Mean % Change](" + resourcesDir.getName() + "/" + prefix + "_branch_mean_summary.csv) &nbsp;|&nbsp; [Branch Abs Mean % Change](" + resourcesDir.getName() + "/" + prefix + "_branch_mean_abs_summary.csv)");
                lines.add("");
                int combinedMapIndex = lines.size();
                int numLevels = this.tree.getLevels().size();
                if (canDecomposeVariance == null) {
                    System.out.println("Seeing if the logic tree is structured in a way that supports variance decomposition");
                    uniqueSamplingLevels = new ArrayList();
                    System.out.println("Looking for unique random sampling levels (those where samples are not reused across upstream branches) for exclusion in variance calculations");
                    boolean firstVaryingLevel = true;
                    block7: for (int l = 0; l < numLevels; ++l) {
                        LogicTreeLevel level = (LogicTreeLevel)this.tree.getLevels().get(l);
                        if (level instanceof LogicTreeLevel.RandomlySampledLevel || level instanceof LogicTreeLevel.FileBackedLevel) {
                            if (level.getNodes().size() == this.tree.size()) {
                                System.out.println("\tDetected that " + level.getName() + " is a randomly sampled level because it has a unique value for each tree branch");
                                uniqueSamplingLevels.add(level);
                            } else if (!firstVaryingLevel) {
                                ArrayList levelsAbove = new ArrayList(this.tree.getLevels().subList(0, l));
                                HashMap prevBranchesAbove = new HashMap();
                                boolean match = true;
                                for (LogicTreeBranch<?> branch : this.tree) {
                                    Object node = branch.getValue(l);
                                    LogicTreeBranch branchAbove = new LogicTreeBranch(levelsAbove);
                                    for (int i = 0; i < l; ++i) {
                                        branchAbove.setValue(i, branch.getValue(i));
                                    }
                                    LogicTreeBranch prevBranchAbove = (LogicTreeBranch)prevBranchesAbove.get(node);
                                    if (prevBranchAbove == null) {
                                        prevBranchesAbove.put(node, branchAbove);
                                        continue;
                                    }
                                    if (prevBranchAbove.equals(branchAbove)) continue;
                                    match = false;
                                    break;
                                }
                                if (match) {
                                    System.out.println("\tDetected that " + level.getName() + " is a randomly sampled level because no unique upstream branches re-use it, even though it only has " + level.getNodes().size() + " nodes for " + this.tree.size() + " total branches");
                                    uniqueSamplingLevels.add(level);
                                }
                            }
                        }
                        if (!firstVaryingLevel) continue;
                        Object firstVal = this.tree.getBranch(0).getValue(l);
                        for (LogicTreeBranch<?> branch : this.tree) {
                            if (branch.getValue(l).equals(firstVal)) continue;
                            firstVaryingLevel = false;
                            continue block7;
                        }
                    }
                    if (uniqueSamplingLevels.isEmpty()) {
                        System.out.println("\tNo such sampling levels found");
                    }
                    HashSet concreteBranches = new HashSet();
                    ArrayList<LogicTreeLevel<LogicTreeLevel>> concreteLevels = new ArrayList<LogicTreeLevel<LogicTreeLevel>>();
                    ArrayList<Integer> levelMappings = new ArrayList<Integer>();
                    ArrayList encounteredConcreteNodes = new ArrayList();
                    for (int l = 0; l < numLevels; ++l) {
                        LogicTreeLevel logicTreeLevel = (LogicTreeLevel)this.tree.getLevels().get(l);
                        if (uniqueSamplingLevels.contains(logicTreeLevel)) continue;
                        concreteLevels.add(logicTreeLevel);
                        levelMappings.add(l);
                        encounteredConcreteNodes.add(new HashSet());
                    }
                    for (LogicTreeBranch<?> logicTreeBranch : this.tree) {
                        LogicTreeBranch concreteBranch = new LogicTreeBranch(concreteLevels);
                        for (int i = 0; i < concreteLevels.size(); ++i) {
                            Object node = logicTreeBranch.getValue((Integer)levelMappings.get(i));
                            concreteBranch.setValue(i, node);
                            ((HashSet)encounteredConcreteNodes.get(i)).add(node);
                        }
                        concreteBranches.add(concreteBranch);
                    }
                    int completeTreeCount = 1;
                    for (HashSet nodes : encounteredConcreteNodes) {
                        completeTreeCount *= nodes.size();
                    }
                    if (completeTreeCount == 1) {
                        canDecomposeVariance = false;
                    } else if (completeTreeCount != concreteBranches.size() || this.forceSparseLTVar) {
                        System.out.println("Have to use sparse variance decomposition approach because the logic tree is downsampled");
                        canDecomposeVariance = true;
                        varDecomposer = new SparseLTVarianceDecomposition(this.tree, uniqueSamplingLevels, this.exec);
                    } else {
                        canDecomposeVariance = true;
                        varDecomposer = new MarginalAveragingLTVarianceDecomposition(this.tree, uniqueSamplingLevels, this.exec);
                    }
                }
                ArrayList<AbstractLTVarianceDecomposition.VarianceContributionResult> varResults = null;
                if (canDecomposeVariance.booleanValue()) {
                    GriddedGeoDataSet covOfMapMean;
                    varResults = new ArrayList<AbstractLTVarianceDecomposition.VarianceContributionResult>(numLevels);
                    for (int l = 0; l < numLevels; ++l) {
                        varResults.add(null);
                    }
                    if (meanIsFromCurves) {
                        mapMean = this.buildMean(maps);
                        covOfMapMean = new GriddedGeoDataSet(region);
                        for (int i = 0; i < mapMean.size(); ++i) {
                            covOfMapMean.set(i, sd.get(i) / mapMean.get(i));
                        }
                    } else {
                        Preconditions.checkNotNull((Object)mapMean);
                        covOfMapMean = cov;
                    }
                    GriddedGeoDataSet varOfMapMean = new GriddedGeoDataSet(region);
                    for (int i = 0; i < cov.size(); ++i) {
                        double var = sd.get(i) * sd.get(i);
                        varOfMapMean.set(i, var);
                    }
                    varDecomposer.initForMaps(mapMean, varOfMapMean, maps, this.weights);
                }
                System.out.println("Building logic tree plots");
                ArrayList branchLevels = new ArrayList();
                ArrayList<List<LogicTreeNode>> branchLevelValues = new ArrayList<List<LogicTreeNode>>();
                ArrayList<List<SolHazardMapCalc.MapPlot>> branchLevelPDiffPlots = new ArrayList<List<SolHazardMapCalc.MapPlot>>();
                ArrayList<List<SolHazardMapCalc.MapPlot>> branchLevelDiffPlots = new ArrayList<List<SolHazardMapCalc.MapPlot>>();
                ArrayList<HashMap<LogicTreeNode, List<GriddedGeoDataSet>>> choiceMapsList = new ArrayList<HashMap<LogicTreeNode, List<GriddedGeoDataSet>>>();
                ArrayList<HashMap<LogicTreeNode, List<Double>>> arrayList = new ArrayList<HashMap<LogicTreeNode, List<Double>>>();
                ArrayList choiceMeansList = new ArrayList();
                ArrayList choiceMeanWithoutsList = new ArrayList();
                ArrayList choiceMeanPercentilesList = new ArrayList();
                for (int l = 0; l < numLevels; ++l) {
                    boolean include;
                    LogicTreeLevel level = (LogicTreeLevel)this.tree.getLevels().get(l);
                    HashMap<LogicTreeNode, List<GriddedGeoDataSet>> choiceMaps = new HashMap<LogicTreeNode, List<GriddedGeoDataSet>>();
                    HashMap<LogicTreeNode, List<Double>> choiceWeights = new HashMap<LogicTreeNode, List<Double>>();
                    for (int i = 0; i < this.branches.size(); ++i) {
                        LogicTreeBranch<?> branch = this.branches.get(i);
                        Object choice = branch.getValue(l);
                        ArrayList<GriddedGeoDataSet> myChoiceMaps = (ArrayList<GriddedGeoDataSet>)choiceMaps.get(choice);
                        if (myChoiceMaps == null) {
                            myChoiceMaps = new ArrayList<GriddedGeoDataSet>();
                            choiceMaps.put((LogicTreeNode)choice, (List<GriddedGeoDataSet>)myChoiceMaps);
                            choiceWeights.put((LogicTreeNode)choice, new ArrayList());
                        }
                        myChoiceMaps.add(maps[i]);
                        choiceWeights.get(choice).add(this.weights.get(i));
                    }
                    boolean bl3 = include = choiceMaps.size() > 1;
                    if (canDecomposeVariance.booleanValue() && include) {
                        if (uniqueSamplingLevels.size() > 1 && uniqueSamplingLevels.get(0) != level && uniqueSamplingLevels.contains(level)) continue;
                        AbstractLTVarianceDecomposition.VarianceContributionResult varResult = varDecomposer.calcMapVarianceContributionForLevel(l, level, choiceMaps, choiceWeights);
                        if (varResult != null) {
                            varResults.set(l, varResult);
                        }
                    }
                    if (LogicTreeCurveAverager.shouldSkipLevel(level, choiceMaps.size())) {
                        System.out.println("Skipping randomly sampled level (" + level.getName() + ") with " + choiceMaps.size() + " choices");
                        include = false;
                    }
                    if (include) {
                        choiceMapsList.add(choiceMaps);
                        arrayList.add(choiceWeights);
                        HashMap<LogicTreeNode, GriddedGeoDataSet> choiceMeans = new HashMap<LogicTreeNode, GriddedGeoDataSet>();
                        HashMap<LogicTreeNode, GriddedGeoDataSet> choiceMeanWithouts = new HashMap<LogicTreeNode, GriddedGeoDataSet>();
                        HashMap<LogicTreeNode, GriddedGeoDataSet> choiceMeanPercentiles = new HashMap<LogicTreeNode, GriddedGeoDataSet>();
                        for (LogicTreeNode choice : choiceMaps.keySet()) {
                            GriddedGeoDataSet choiceMean;
                            GriddedGeoDataSet choiceMeanWithout = null;
                            if (meanIsFromCurves) {
                                Object key = LogicTreeCurveAverager.choicePrefix(level, choice);
                                key = "level_choice_maps/" + (String)key;
                                choiceMean = this.loadPrecomputedMeanMap((String)key, rp, period);
                                Preconditions.checkNotNull((Object)choiceMean, (String)"Mean map was precomputed for curves, but levels were not? Couldn't find mean map for %s, %s, %s", (Object)key, (Object)((Object)rp), (Object)period);
                                if (choiceMeanWithouts != null) {
                                    key = LogicTreeCurveAverager.choiceWithoutPrefix(level, choice);
                                    choiceMeanWithout = this.loadPrecomputedMeanMap((String)(key = "level_choice_maps/" + (String)key), rp, period);
                                    if (choiceMeanWithout == null) {
                                        choiceMeanWithouts = null;
                                    }
                                }
                            } else {
                                choiceMean = LogicTreeHazardCompare.buildMean(choiceMaps.get(choice), choiceWeights.get(choice));
                                int numOthers = this.branches.size() - choiceMaps.get(choice).size();
                                ArrayList<GriddedGeoDataSet> mapsWithout = new ArrayList<GriddedGeoDataSet>(numOthers);
                                ArrayList<Double> weightsWithout = new ArrayList<Double>(numOthers);
                                for (LogicTreeNode oChoice : choiceMaps.keySet()) {
                                    if (oChoice == choice) continue;
                                    mapsWithout.addAll((Collection<GriddedGeoDataSet>)choiceMaps.get(oChoice));
                                    weightsWithout.addAll((Collection<Double>)choiceWeights.get(oChoice));
                                }
                                choiceMeanWithout = LogicTreeHazardCompare.buildMean(mapsWithout, weightsWithout);
                            }
                            choiceMeans.put(choice, choiceMean);
                            if (choiceMeanWithouts != null) {
                                choiceMeanWithouts.put(choice, choiceMeanWithout);
                            }
                            GriddedGeoDataSet percentile = LogicTreeHazardCompare.calcPercentileWithinDist(mapNCDFs, choiceMean);
                            choiceMeanPercentiles.put(choice, percentile);
                        }
                        choiceMeansList.add(choiceMeans);
                        choiceMeanWithoutsList.add(choiceMeanWithouts);
                        choiceMeanPercentilesList.add(choiceMeanPercentiles);
                        continue;
                    }
                    choiceMapsList.add(null);
                    arrayList.add(null);
                    choiceMeansList.add(null);
                    choiceMeanWithoutsList.add(null);
                    choiceMeanPercentilesList.add(null);
                }
                mapNCDFs = null;
                System.gc();
                if (period == this.periods[0] && rp == this.rps[0]) {
                    PlotUtils.writeScaleLegendOnly(resourcesDir, "cpt_branch_pDiff", GeographicMapMaker.buildCPTLegend(this.pDiffCPT, "Branch Choice / Mean, % Change"), cptWidth, true, true);
                    PlotUtils.writeScaleLegendOnly(resourcesDir, "cpt_branch_diff", GeographicMapMaker.buildCPTLegend(this.diffCPT, "Branch Choice - Mean " + perUnits), cptWidth, true, true);
                }
                CSVFile<String> choiceMeanSummaryCSV = new CSVFile<String>(false);
                CSVFile<Object> choiceMeanAbsSummaryCSV = new CSVFile<Object>(false);
                boolean levelNameOverlap = false;
                ArrayList<Object> levelPrefixes = new ArrayList<Object>();
                for (LogicTreeLevel level : this.tree.getLevels()) {
                    String ltPrefix = level.getFilePrefix();
                    levelNameOverlap |= levelPrefixes.contains(ltPrefix);
                    levelPrefixes.add(ltPrefix);
                }
                if (levelNameOverlap) {
                    for (int i = 0; i < levelPrefixes.size(); ++i) {
                        levelPrefixes.set(i, i + "_" + (String)levelPrefixes.get(i));
                    }
                }
                for (int l = 0; l < choiceMapsList.size(); ++l) {
                    LogicTreeLevel level;
                    level = (LogicTreeLevel)this.tree.getLevels().get(l);
                    String levelPrefix = prefix + "_" + (String)levelPrefixes.get(l);
                    HashMap choiceMaps = (HashMap)choiceMapsList.get(l);
                    if (choiceMaps == null) continue;
                    System.out.println(level.getName() + " has " + choiceMaps.size() + " choices");
                    lines.add("#### " + level.getName() + ", " + unitlessLabel);
                    lines.add(topLink);
                    lines.add("");
                    lines.add("This section shows how mean hazard varies accross " + choiceMaps.size() + " choices at the _" + level.getName() + "_ branch level.");
                    lines.add("");
                    HashMap choiceMeans = (HashMap)choiceMeansList.get(l);
                    HashMap choiceMeanPercentiles = (HashMap)choiceMeanPercentilesList.get(l);
                    table = MarkdownUtils.tableBuilder();
                    table.initNewLine().addColumn("**Choice**").addColumn("**Vs Mean**");
                    MarkdownUtils.TableBuilder mapVsChoiceTable = MarkdownUtils.tableBuilder();
                    mapVsChoiceTable.initNewLine().addColumn("**Choice**");
                    ArrayList<LogicTreeNode> choices = new ArrayList<LogicTreeNode>();
                    for (LogicTreeNode choice : level.getNodes()) {
                        if (!choiceMaps.containsKey(choice)) continue;
                        choices.add(choice);
                    }
                    Preconditions.checkState((choices.size() == choiceMaps.size() ? 1 : 0) != 0);
                    if (choiceMeanSummaryCSV.getNumRows() > 0) {
                        choiceMeanSummaryCSV.addLine("");
                        choiceMeanAbsSummaryCSV.addLine("");
                    }
                    int summaryRow = choiceMeanSummaryCSV.getNumRows();
                    choiceMeanSummaryCSV.addLine(level.getName());
                    choiceMeanAbsSummaryCSV.addLine(level.getName(), "Overall average absolute difference:", "");
                    ArrayList<Object> csvHeader = new ArrayList<Object>();
                    csvHeader.add("Choice");
                    csvHeader.add("Vs Mean");
                    for (LogicTreeNode choice : choices) {
                        csvHeader.add("Vs " + choice.getShortName());
                        table.addColumn("**Vs " + choice.getShortName() + "**");
                        mapVsChoiceTable.addColumn("**Vs " + choice.getShortName() + "**");
                    }
                    choiceMeanSummaryCSV.addLine((List<String>)csvHeader);
                    choiceMeanAbsSummaryCSV.addLine((List<Object>)csvHeader);
                    table.finalizeLine();
                    mapVsChoiceTable.finalizeLine();
                    MarkdownUtils.TableBuilder mapTable = MarkdownUtils.tableBuilder();
                    mapTable.addLine("", "Choice Mean vs Full Mean, % Change", "Choice Mean - Full Mean", "Choice Percentile in Full Dist", "Choice Percentile in Dist Without");
                    DataUtils.MinMaxAveTracker runningDiffAvg = new DataUtils.MinMaxAveTracker();
                    DataUtils.MinMaxAveTracker runningAbsDiffAvg = new DataUtils.MinMaxAveTracker();
                    branchLevels.add(level);
                    branchLevelValues.add(choices);
                    ArrayList<SolHazardMapCalc.MapPlot> branchPDiffPlots = new ArrayList<SolHazardMapCalc.MapPlot>();
                    ArrayList<SolHazardMapCalc.MapPlot> branchDiffPlots = new ArrayList<SolHazardMapCalc.MapPlot>();
                    branchLevelPDiffPlots.add(branchPDiffPlots);
                    branchLevelDiffPlots.add(branchDiffPlots);
                    System.out.println("Building choice CDFs for " + level.getName());
                    LightFixedXFunc[][] choiceCDFs = new LightFixedXFunc[choices.size()][];
                    double[] choiceSumWeights = new double[choices.size()];
                    for (int c = 0; c < choices.size(); ++c) {
                        ArrayList<GriddedGeoDataSet> mapsWith = new ArrayList<GriddedGeoDataSet>();
                        ArrayList<Double> weightsWith = new ArrayList<Double>();
                        LogicTreeNode choice = (LogicTreeNode)choices.get(c);
                        for (int i = 0; i < this.branches.size(); ++i) {
                            LogicTreeBranch<?> branch = this.branches.get(i);
                            if (!branch.hasValue(choice)) continue;
                            mapsWith.add(maps[i]);
                            double weight = this.weights.get(i);
                            weightsWith.add(weight);
                            int n = c;
                            choiceSumWeights[n] = choiceSumWeights[n] + weight;
                        }
                        System.out.println("\tBuilding " + choice.getShortName() + " with " + mapsWith.size() + " maps, sumWeight=" + (float)choiceSumWeights[c]);
                        choiceCDFs[c] = this.buildNormCDFs(mapsWith, weightsWith);
                    }
                    ArrayList<GriddedGeoDataSet> choicePDiffs = new ArrayList<GriddedGeoDataSet>();
                    ArrayList<GriddedGeoDataSet> choiceDiffs = new ArrayList<GriddedGeoDataSet>();
                    ArrayList<String> choiceShortNames = new ArrayList<String>();
                    for (int c = 0; c < choices.size(); ++c) {
                        LogicTreeNode choice = (LogicTreeNode)choices.get(c);
                        table.initNewLine().addColumn("**" + choice.getShortName() + "**");
                        mapVsChoiceTable.initNewLine().addColumn("**" + choice.getShortName() + "**");
                        ArrayList<String> meanCSVLine = new ArrayList<String>(csvHeader.size());
                        ArrayList<String> meanAbsCSVLine = new ArrayList<String>(csvHeader.size());
                        meanCSVLine.add(choice.getShortName());
                        meanAbsCSVLine.add(choice.getShortName());
                        GriddedGeoDataSet choiceMap = (GriddedGeoDataSet)choiceMeans.get(choice);
                        table.addColumn(LogicTreeHazardCompare.mapPDiffStr(choiceMap, mean, null, null, meanCSVLine, meanAbsCSVLine));
                        for (LogicTreeNode oChoice : choices) {
                            if (choice == oChoice) {
                                table.addColumn("");
                                mapVsChoiceTable.addColumn("");
                                meanCSVLine.add("");
                                meanAbsCSVLine.add("");
                                continue;
                            }
                            table.addColumn(LogicTreeHazardCompare.mapPDiffStr(choiceMap, (GriddedGeoDataSet)choiceMeans.get(oChoice), runningDiffAvg, runningAbsDiffAvg, meanCSVLine, meanAbsCSVLine));
                            GriddedGeoDataSet oChoiceMap = (GriddedGeoDataSet)choiceMeans.get(oChoice);
                            GriddedGeoDataSet pDiff = this.buildPDiff(oChoiceMap, choiceMap);
                            File map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, levelPrefix + "_" + choice.getFilePrefix() + "_vs_" + oChoice.getFilePrefix(), pDiff, this.pDiffCPT, (String)(TITLES ? choice.getShortName() + " vs " + oChoice.getShortName() : " "), choice.getShortName() + " / " + oChoice.getShortName() + ", % Change, " + unitlessLabel, true);
                            mapVsChoiceTable.addColumn("![Difference Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
                        }
                        table.finalizeLine();
                        mapVsChoiceTable.finalizeLine();
                        choiceMeanSummaryCSV.addLine((List<String>)meanCSVLine);
                        choiceMeanAbsSummaryCSV.addLine((List<Object>)meanAbsCSVLine);
                        mapTable.initNewLine().addColumn("**" + choice.getShortName() + "**");
                        choiceShortNames.add(choice.getShortName());
                        GriddedGeoDataSet pDiff = this.buildPDiff(mean, choiceMap);
                        choicePDiffs.add(pDiff);
                        SolHazardMapCalc.MapPlot pDiffMap = this.mapper.buildMapPlot(resourcesDir, levelPrefix + "_" + choice.getFilePrefix() + "_pDiff", pDiff, this.pDiffCPT, (String)(TITLES ? choice.getShortName() + " Comparison" : " "), choice.getShortName() + " / Mean, % Change, " + unitlessLabel, true);
                        branchPDiffPlots.add(pDiffMap);
                        File map = new File(resourcesDir, pDiffMap.prefix + ".png");
                        mapTable.addColumn("![Percent Difference Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
                        GriddedGeoDataSet diff = new GriddedGeoDataSet(region, false);
                        choiceDiffs.add(diff);
                        for (int i = 0; i < diff.size(); ++i) {
                            diff.set(i, choiceMap.get(i) - mean.get(i));
                        }
                        SolHazardMapCalc.MapPlot diffMap = this.mapper.buildMapPlot(resourcesDir, levelPrefix + "_" + choice.getFilePrefix() + "_diff", diff, this.diffCPT, (String)(TITLES ? choice.getShortName() + " Comparison" : " "), choice.getShortName() + " - Mean, " + label, false);
                        branchDiffPlots.add(diffMap);
                        map = new File(resourcesDir, diffMap.prefix + ".png");
                        mapTable.addColumn("![Difference Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
                        GriddedGeoDataSet percentile = (GriddedGeoDataSet)choiceMeanPercentiles.get(choice);
                        map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, levelPrefix + "_" + choice.getFilePrefix() + "_percentile", percentile, this.percentileCPT, (String)(TITLES ? choice.getShortName() + " Comparison" : " "), choice.getShortName() + " %-ile, " + unitlessLabel);
                        mapTable.addColumn("![Percentile Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
                        ArrayList<LightFixedXFunc[]> withoutNCDFs = new ArrayList<LightFixedXFunc[]>(choices.size() - 1);
                        ArrayList<Double> withoutWeights = new ArrayList<Double>();
                        for (int i = 0; i < choices.size(); ++i) {
                            if (i == c) continue;
                            withoutNCDFs.add(choiceCDFs[i]);
                            withoutWeights.add(choiceSumWeights[i]);
                        }
                        GriddedGeoDataSet percentileWithout = LogicTreeHazardCompare.calcPercentileWithinDists(withoutNCDFs, withoutWeights, choiceMap);
                        map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, levelPrefix + "_" + choice.getFilePrefix() + "_percentile_without", percentileWithout, this.percentileCPT, (String)(TITLES ? choice.getShortName() + " Comparison" : " "), choice.getShortName() + " %-ile, " + unitlessLabel);
                        mapTable.addColumn("![Percentile Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
                        mapTable.finalizeLine();
                    }
                    int height = 360;
                    int titleFont = 12;
                    int subtitleFont = 46;
                    File pDiffMulti = LogicTreeHazardCompare.submitMultiMapFuture(this.mapper, this.exec, this.futures, resourcesDir, levelPrefix + "_choice_pDiffs", choicePDiffs, this.pDiffCPT, null, titleFont, choiceShortNames, subtitleFont, null, true, height);
                    File diffMulti = LogicTreeHazardCompare.submitMultiMapFuture(this.mapper, this.exec, this.futures, resourcesDir, levelPrefix + "_choice_diffs", choiceDiffs, this.diffCPT, null, titleFont, choiceShortNames, subtitleFont, null, true, height);
                    File choicesCSV = new File(resourcesDir, levelPrefix + ".csv");
                    this.writeChoiceHazardCSV(choicesCSV, mean, choices, choiceMeans);
                    lines.add("![Combined " + level.getShortName() + " % difference plot](" + resourcesDir.getName() + "/" + pDiffMulti.getName() + ")");
                    lines.add("");
                    lines.add("![% Diff CPT](" + resourcesDir.getName() + "/cpt_branch_pDiff.png)");
                    lines.add("");
                    lines.add("![Combined " + level.getShortName() + " difference plot](" + resourcesDir.getName() + "/" + diffMulti.getName() + ")");
                    lines.add("");
                    lines.add("![Diff CPT](" + resourcesDir.getName() + "/cpt_branch_diff.png)");
                    lines.add("");
                    lines.add("Download Choice Hazard CSV: [" + choicesCSV.getName() + "](" + resourcesDir.getName() + "/" + choicesCSV.getName() + ")");
                    lines.add("");
                    lines.add("The table below gives summary statistics for the spatial average difference and average absolute difference of hazard between mean hazard maps for each individual branch choices. In other words, it gives the expected difference (or absolute difference) between two models if you picked a location at random. Values are listed between each pair of branch choices, and also between that choice and the overall mean map in the first column.");
                    lines.add("");
                    lines.add("The overall average absolute difference between the map for any choice to each other choice, a decent summary measure of how much hazard varies due to this branch choice, is: **" + twoDigits.format(runningAbsDiffAvg.getAverage()) + "%**");
                    System.out.println("\tOverall MAD: " + twoDigits.format(runningAbsDiffAvg.getAverage()) + " %");
                    choiceMeanAbsSummaryCSV.set(summaryRow, 2, runningAbsDiffAvg.getAverage() + "%");
                    lines.add("");
                    lines.addAll(table.build());
                    lines.add("");
                    lines.add("The map table below shows how the mean map for each branch choice compares to the overall mean map, expressed as % change (first column) and difference (second column). The third column, 'Choice Percentile in Full Dist', shows at what percentile the map for that branch choice lies within the full distribution, and the fourth column, 'Choice Percentile in Dist Without', shows the same but for the distribution of all other branches (without this choice included).");
                    lines.add("");
                    lines.add("Note that these percentile comparisons can be outlier dominated, in which case even if a choice is near the overall mean hazard it may still lie far from the 50th percentile (see 'Mean Map Percentile' above to better understand outlier dominated regions).");
                    lines.add("");
                    lines.addAll(mapTable.build());
                    lines.add("");
                    lines.add("The table below gives % change maps between each option, head-to-head.");
                    lines.add("");
                    lines.addAll(mapVsChoiceTable.build());
                    lines.add("");
                    HashMap choiceMeanWithouts = (HashMap)choiceMeanWithoutsList.get(l);
                    if (choiceMeanWithouts == null) continue;
                    table = MarkdownUtils.tableBuilder();
                    ArrayList<File> ratioPlots = new ArrayList<File>();
                    ArrayList<File> diffPlots = new ArrayList<File>();
                    table.initNewLine();
                    for (LogicTreeNode choice : choices) {
                        table.addColumn(choice.getShortName());
                        GriddedGeoDataSet choiceWithout = (GriddedGeoDataSet)choiceMeanWithouts.get(choice);
                        GriddedGeoDataSet pDiff = this.buildPDiff(mean, choiceWithout);
                        ratioPlots.add(LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, levelPrefix + "_" + choice.getFilePrefix() + "_mean_pDiff_without", pDiff, this.pDiffCPT, (String)(TITLES ? choice.getShortName() + " Removal Comparison" : " "), choice.getShortName() + ", Mean Without / With, % Change, " + unitlessLabel, true));
                        GriddedGeoDataSet diff = new GriddedGeoDataSet(region, false);
                        for (int i = 0; i < diff.size(); ++i) {
                            diff.set(i, choiceWithout.get(i) - mean.get(i));
                        }
                        diffPlots.add(LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, levelPrefix + "_" + choice.getFilePrefix() + "_mean_diff_without", diff, this.diffCPT, (String)(TITLES ? choice.getShortName() + " Removal Comparison" : " "), choice.getShortName() + ", Mean Without - With, " + label, false));
                    }
                    table.finalizeLine();
                    table.initNewLine();
                    for (File ratioPlot : ratioPlots) {
                        table.addColumn("![Percent Difference Map](" + resourcesDir.getName() + "/" + ratioPlot.getName() + ")");
                    }
                    table.finalizeLine();
                    table.initNewLine();
                    for (File diffPlot : diffPlots) {
                        table.addColumn("![Difference Map](" + resourcesDir.getName() + "/" + diffPlot.getName() + ")");
                    }
                    table.finalizeLine();
                    lines.add("The table below shows how much the mean hazard map would change if each branch were eliminated. This differs from the above comparisons in that it also reflects the weight assigned to each branch. The sign is now flipped such that blue and green areas indicate areas where hazard is higher due to inclusion of the listed listed choice, and would go down were that choice eliminated.");
                    lines.add("");
                    lines.addAll(table.build());
                    lines.add("");
                }
                ArrayList<Object> addInLines = new ArrayList<Object>();
                if (!branchLevels.isEmpty()) {
                    String combPrefix = prefix + "_branches_combined";
                    if (branchLevels.size() < 5) {
                        this.writeCombinedBranchMap(resourcesDir, combPrefix, name + ", Mean Hazard Map", meanMapPlot, branchLevels, branchLevelValues, branchLevelPDiffPlots, "Branch Choice / Mean, % Change", branchLevelDiffPlots, "Branch Choice - Mean (g)");
                    }
                    combPrefix = prefix + "_branches_combined_pDiff";
                    this.writeCombinedBranchMap(resourcesDir, combPrefix, name + ", Mean Hazard Map", meanMapPlot, branchLevels, branchLevelValues, branchLevelPDiffPlots, "Branch Choice / Mean, % Change");
                    table = MarkdownUtils.tableBuilder();
                    table.addLine("Combined Summary Maps");
                    table.addLine("![Combined Map](" + resourcesDir.getName() + "/" + combPrefix + ".png)");
                    combPrefix = prefix + "_branches_combined_diff";
                    this.writeCombinedBranchMap(resourcesDir, combPrefix, name + ", Mean Hazard Map", meanMapPlot, branchLevels, branchLevelValues, branchLevelDiffPlots, "Branch Choice - Mean (g)");
                    table.addLine("![Combined Map](" + resourcesDir.getName() + "/" + combPrefix + ".png)");
                    addInLines.addAll(table.build());
                    choiceMeanSummaryCSV.writeToFile(new File(resourcesDir, prefix + "_branch_mean_summary.csv"));
                    choiceMeanAbsSummaryCSV.writeToFile(new File(resourcesDir, prefix + "_branch_mean_abs_summary.csv"));
                }
                if (canDecomposeVariance.booleanValue()) {
                    List<String> varLines = varDecomposer.buildLines(varResults);
                    if (varLines != null && !varLines.isEmpty()) {
                        if (!addInLines.isEmpty()) {
                            addInLines.add("");
                        }
                        addInLines.add("#### " + varDecomposer.getHeading() + ", " + unitlessLabel);
                        addInLines.add(topLink);
                        addInLines.add("");
                        addInLines.addAll(varLines);
                    } else {
                        canDecomposeVariance = false;
                    }
                }
                if (!addInLines.isEmpty()) {
                    lines.addAll(combinedMapIndex, addInLines);
                }
                if (!intermediateWrite) continue;
                LogicTreeHazardCompare.writeIntermediate(outputDir, lines, tocIndex);
            }
        }
        System.out.println("Waiting on " + this.futures.size() + " map futures....");
        Object object = this.futures.iterator();
        while (object.hasNext()) {
            Future future = (Future)object.next();
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        System.out.println("DONE with maps");
        lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, 4));
        lines.add(tocIndex, "## Table Of Contents");
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
    }

    private String mapStats(GriddedGeoDataSet map) {
        return this.mapStats(map, false);
    }

    private String mapStats(GriddedGeoDataSet map, boolean percent) {
        Object ret;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double sum = 0.0;
        boolean hasNeg = false;
        double sumAbs = 0.0;
        int count = 0;
        for (int i = 0; i < map.size(); ++i) {
            double val;
            if (this.mapRegion != null && !this.mapRegion.contains(map.getLocation(i)) || !Double.isFinite(val = map.get(i))) continue;
            min = Double.min(min, val);
            max = Double.max(max, val);
            sum += val;
            hasNeg |= val < 0.0;
            sumAbs += Math.abs(val);
            ++count;
        }
        if (count == 0) {
            ret = "All values non-finite";
        } else {
            ret = "mean: " + String.format("%.3g", sum / (double)count);
            if (percent) {
                ret = (String)ret + "%";
            }
            if (hasNeg) {
                ret = (String)ret + ", abs: " + String.format("%.3g", sumAbs / (double)count);
                if (percent) {
                    ret = (String)ret + "%";
                }
            }
            ret = (String)ret + ", range: [";
            ret = percent ? (String)ret + String.format("%.3g", min) + "%, " + String.format("%.3g", max) + "%]" : (String)ret + String.format("%.3g", min) + ", " + String.format("%.3g", max) + "]";
        }
        return "<small>" + (String)ret + "</small>";
    }

    private static void writeIntermediate(File outputDir, List<String> lines, int tocIndex) throws IOException {
        System.out.println("Writing intermediate markdown");
        lines = new ArrayList<String>(lines);
        lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, 4));
        lines.add(tocIndex, "## Table Of Contents");
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
    }

    private static File submitMapFuture(SolHazardMapCalc mapper, ExecutorService exec, List<Future<?>> futures, File outputDir, String prefix, GriddedGeoDataSet xyz, CPT cpt, String title, String zLabel) {
        return LogicTreeHazardCompare.submitMapFuture(mapper, exec, futures, outputDir, prefix, xyz, cpt, title, zLabel, false);
    }

    private static File submitMapFuture(final SolHazardMapCalc mapper, ExecutorService exec, List<Future<?>> futures, final File outputDir, final String prefix, final GriddedGeoDataSet xyz, final CPT cpt, final String title, final String zLabel, final boolean diffStats) {
        File ret = new File(outputDir, prefix + ".png");
        futures.add(exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    mapper.plotMap(outputDir, prefix, xyz, cpt, title, zLabel, diffStats);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }));
        return ret;
    }

    private static File submitMultiMapFuture(final SolHazardMapCalc mapper, ExecutorService exec, List<Future<?>> futures, final File outputDir, final String prefix, final List<GriddedGeoDataSet> xyzs, final CPT cpt, final String title, final int titleFontSize, final List<String> subtitles, final int subtitleFontSize, final String zLabel, final boolean horizontal, final int dimension) {
        File ret = new File(outputDir, prefix + ".png");
        futures.add(exec.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    mapper.plotMultiMap(outputDir, prefix, xyzs, cpt, title, titleFontSize, subtitles, subtitleFontSize, zLabel, horizontal, dimension, false, false);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }));
        return ret;
    }

    private void writeHazardCSV(File outputFile, GriddedGeoDataSet mean, GriddedGeoDataSet median, GriddedGeoDataSet min, GriddedGeoDataSet max, GriddedGeoDataSet cov, GriddedGeoDataSet meanPercentile, GriddedGeoDataSet meanPercentileInComparison, GriddedGeoDataSet medianPercentileInComparison) throws IOException {
        CSVFile csv = new CSVFile(true);
        ArrayList<String> header = new ArrayList<String>();
        header.addAll(List.of("Location Index", "Latitutde", "Longitude", "Weighted Mean", "Weighted Median", "Min", "Max", "COV"));
        if (meanPercentile != null) {
            if (meanPercentileInComparison == null) {
                header.add("Mean Map Percentile");
            } else {
                header.add("Mean Map Percentile (within own distribution)");
            }
        }
        if (meanPercentileInComparison != null) {
            header.add("Mean Map Percentile (within comparison distribution)");
        }
        if (medianPercentileInComparison != null) {
            header.add("Median Map Percentile (within comparison distribution)");
        }
        csv.addLine(header);
        GriddedRegion reg = mean.getRegion();
        for (int i = 0; i < reg.getNodeCount(); ++i) {
            Location loc = reg.getLocation(i);
            ArrayList<CallSite> line = new ArrayList<CallSite>(header.size());
            line.add((CallSite)((Object)("" + i)));
            line.add((CallSite)((Object)("" + (float)loc.getLatitude())));
            line.add((CallSite)((Object)("" + (float)loc.getLongitude())));
            line.add((CallSite)((Object)("" + mean.get(i))));
            line.add((CallSite)((Object)("" + median.get(i))));
            line.add((CallSite)((Object)("" + min.get(i))));
            line.add((CallSite)((Object)("" + max.get(i))));
            line.add((CallSite)((Object)("" + cov.get(i))));
            if (meanPercentile != null) {
                line.add((CallSite)((Object)("" + (float)meanPercentile.get(i))));
            }
            if (meanPercentileInComparison != null) {
                line.add((CallSite)((Object)("" + (float)meanPercentileInComparison.get(i))));
            }
            if (medianPercentileInComparison != null) {
                line.add((CallSite)((Object)("" + (float)medianPercentileInComparison.get(i))));
            }
            csv.addLine(line);
        }
        csv.writeToFile(outputFile);
    }

    private void writeChoiceHazardCSV(File outputFile, GriddedGeoDataSet mean, List<LogicTreeNode> choices, Map<LogicTreeNode, GriddedGeoDataSet> choiceMeans) throws IOException {
        CSVFile csv = new CSVFile(true);
        ArrayList<String> header = new ArrayList<String>();
        header.add("Location Index");
        header.add("Latitutde");
        header.add("Longitude");
        header.add("Weighted Mean");
        for (LogicTreeNode choice : choices) {
            header.add(choice.getShortName());
        }
        csv.addLine(header);
        GriddedRegion reg = mean.getRegion();
        for (int i = 0; i < reg.getNodeCount(); ++i) {
            Location loc = reg.getLocation(i);
            ArrayList<CallSite> line = new ArrayList<CallSite>();
            line.add((CallSite)((Object)("" + i)));
            line.add((CallSite)((Object)("" + (float)loc.getLatitude())));
            line.add((CallSite)((Object)("" + (float)loc.getLongitude())));
            line.add((CallSite)((Object)("" + mean.get(i))));
            for (LogicTreeNode choice : choices) {
                line.add((CallSite)((Object)("" + choiceMeans.get(choice).get(i))));
            }
            csv.addLine(line);
        }
        csv.writeToFile(outputFile);
    }

    private static String mapPDiffStr(GriddedGeoDataSet map, GriddedGeoDataSet ref, DataUtils.MinMaxAveTracker runningDiffAvg, DataUtils.MinMaxAveTracker runningAbsDiffAvg, List<String> meanCSVLine, List<String> meanAbsCSVLine) {
        double mean = 0.0;
        double meanAbs = 0.0;
        int numFinite = 0;
        for (int i = 0; i < map.size(); ++i) {
            double z1 = map.get(i);
            double z2 = ref.get(i);
            double pDiff = 100.0 * (z1 - z2) / z2;
            if (z1 == z2 && z1 > 0.0) {
                pDiff = 0.0;
            }
            if (!Double.isFinite(pDiff)) continue;
            mean += pDiff;
            meanAbs += Math.abs(pDiff);
            if (runningDiffAvg != null) {
                runningDiffAvg.addValue(pDiff);
            }
            if (runningAbsDiffAvg != null) {
                runningAbsDiffAvg.addValue(Math.abs(pDiff));
            }
            ++numFinite;
        }
        meanCSVLine.add((mean /= (double)numFinite) + "%");
        meanAbsCSVLine.add((meanAbs /= (double)numFinite) + "%");
        return "Mean: " + twoDigits.format(mean) + "%, Mean Abs: " + twoDigits.format(meanAbs) + "%";
    }

    private static GriddedGeoDataSet log10(GriddedGeoDataSet map) {
        map = map.copy();
        map.log10();
        return map;
    }

    private void addDiffInclExtremesLines(GriddedGeoDataSet primary, String name, GriddedGeoDataSet min, GriddedGeoDataSet max, GriddedGeoDataSet comparison, String compName, String prefix, File resourcesDir, MarkdownUtils.TableBuilder table, String type, String label, boolean difference, GriddedRegion compReg) throws IOException {
        GriddedGeoDataSet remappedDiff;
        GriddedGeoDataSet diffFromRange;
        GriddedGeoDataSet diff;
        CPT cpt;
        String diffPrefix;
        String diffLabel;
        int i;
        boolean minEqualMax = true;
        for (i = 0; minEqualMax && i < min.size(); ++i) {
            double minVal = min.get(i);
            double maxVal = max.get(i);
            if (!Double.isFinite(minVal) || !Double.isFinite(maxVal)) continue;
            minEqualMax = (float)minVal == (float)maxVal;
        }
        if (difference) {
            diffLabel = "Difference";
            diffPrefix = "diff";
            cpt = this.diffCPT;
            diff = new GriddedGeoDataSet(primary.getRegion(), false);
            diffFromRange = new GriddedGeoDataSet(primary.getRegion(), false);
            for (i = 0; i < diff.size(); ++i) {
                double val = primary.get(i);
                double compVal = comparison.get(i);
                diff.set(i, val - compVal);
                double minVal = min.get(i);
                double maxVal = max.get(i);
                double rangeDiff = compVal >= minVal && compVal <= maxVal ? 0.0 : (compVal < minVal ? compVal - minVal : compVal - maxVal);
                diffFromRange.set(i, rangeDiff);
            }
        } else {
            diffLabel = "% Change";
            diffPrefix = "pDiff";
            cpt = this.pDiffCPT;
            diff = this.buildPDiff(comparison, primary);
            diffFromRange = this.buildPDiffFromRange(min, max, comparison);
        }
        table.addLine(MarkdownUtils.boldCentered(type + " " + diffLabel), MarkdownUtils.boldCentered("Comparison " + type + " " + diffLabel + " From Extremes"));
        int compRegCount = compReg.getNodeCount();
        if (compRegCount < primary.size() && this.checkShrinkToComparison(diff, remappedDiff = new GriddedGeoDataSet(compReg, false))) {
            GriddedGeoDataSet remappedRangeDiff = new GriddedGeoDataSet(compReg, false);
            Preconditions.checkState((boolean)this.checkShrinkToComparison(diffFromRange, remappedRangeDiff));
            diff = remappedDiff;
            diffFromRange = remappedRangeDiff;
        }
        table.initNewLine();
        String op = difference ? "-" : "/";
        File map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp_" + diffPrefix, diff, cpt, (String)(TITLES ? name + " vs " + compName : " "), (String)(TITLES ? "Primary " + op + " Comparison, " : "") + diffLabel + ", " + label, !difference);
        table.addColumn("![Difference Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
        if (minEqualMax) {
            table.addColumn("_(N/A)_");
        } else {
            map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp_" + diffPrefix + "_range", diffFromRange, cpt.reverse(), (String)(TITLES ? name + " vs " + compName : " "), "Comparison " + op + " Extremes, " + diffLabel + ", " + label, !difference);
            table.addColumn("![Range Difference Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
        }
        table.finalizeLine();
        table.initNewLine();
        table.addColumn(this.mapStats(diff, !difference));
        table.addColumn(this.mapStats(diffFromRange, !difference));
        table.finalizeLine();
    }

    private void addSingleBranchDiffLines(GriddedGeoDataSet primary, String name, GriddedGeoDataSet comparison, String compName, String prefix, File resourcesDir, MarkdownUtils.TableBuilder table, String unitlessLlabel, String label, GriddedRegion compReg) throws IOException {
        GriddedGeoDataSet remappedDiff;
        GriddedGeoDataSet pDiff = this.buildPDiff(comparison, primary);
        GriddedGeoDataSet diff = new GriddedGeoDataSet(primary.getRegion(), false);
        for (int i = 0; i < diff.size(); ++i) {
            double val = primary.get(i);
            double compVal = comparison.get(i);
            diff.set(i, val - compVal);
        }
        table.addLine(MarkdownUtils.boldCentered("% Change"), MarkdownUtils.boldCentered("Difference"));
        int compRegCount = compReg.getNodeCount();
        if (compRegCount < primary.size() && this.checkShrinkToComparison(diff, remappedDiff = new GriddedGeoDataSet(compReg, false))) {
            GriddedGeoDataSet remappedPDiff = new GriddedGeoDataSet(compReg, false);
            Preconditions.checkState((boolean)this.checkShrinkToComparison(pDiff, remappedPDiff));
            diff = remappedDiff;
            pDiff = remappedPDiff;
        }
        table.initNewLine();
        File pDiffMap = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp_pDiff", pDiff, this.pDiffCPT, (String)(TITLES ? name + " vs " + compName : " "), (TITLES ? "Primary / Comparison, " : "") + "% Change, " + unitlessLlabel, true);
        table.addColumn("![% Difference Map](" + resourcesDir.getName() + "/" + pDiffMap.getName() + ")");
        File diffMap = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp_diff", diff, this.diffCPT, (String)(TITLES ? name + " vs " + compName : " "), (TITLES ? "Primary - Comparison, " : "") + "Difference, " + label, false);
        table.addColumn("![Difference Map](" + resourcesDir.getName() + "/" + diffMap.getName() + ")");
        table.finalizeLine();
        table.initNewLine();
        table.addColumn(this.mapStats(pDiff, true));
        table.addColumn(this.mapStats(diff, false));
        table.finalizeLine();
    }

    private boolean checkShrinkToComparison(GriddedGeoDataSet orig, GriddedGeoDataSet remapped) {
        GriddedRegion origReg = orig.getRegion();
        GriddedRegion compReg = remapped.getRegion();
        int compRegCount = compReg.getNodeCount();
        if (compRegCount >= origReg.getNodeCount()) {
            return false;
        }
        for (int i = 0; i < compRegCount; ++i) {
            int index = origReg.indexForLocation(compReg.getLocation(i));
            if (index < 0) {
                return false;
            }
            remapped.set(i, orig.get(index));
        }
        return true;
    }

    private void addMapCompDiffLines(GriddedGeoDataSet primary, String name, GriddedGeoDataSet comparison, String compName, String prefix, File resourcesDir, MarkdownUtils.TableBuilder table, String type, String label, String unitlessLabel, CPT cpt, CPT diffCPT, CPT pDiffCPT, GriddedRegion compReg) throws IOException {
        table.addLine(MarkdownUtils.boldCentered("Primary " + type), MarkdownUtils.boldCentered("Comparison " + type), MarkdownUtils.boldCentered("Difference"), MarkdownUtils.boldCentered("% Change"));
        table.initNewLine();
        File map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix, primary, cpt, name, label);
        table.addColumn("![" + type + "](" + resourcesDir.getName() + "/" + map.getName() + ")");
        map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, prefix + "_comp", comparison, cpt, compName, label);
        table.addColumn("![" + type + "](" + resourcesDir.getName() + "/" + map.getName() + ")");
        GriddedGeoDataSet diffForStats = null;
        GriddedGeoDataSet pDiffForStats = null;
        for (boolean difference : new boolean[]{true, false}) {
            GriddedGeoDataSet remappedDiff;
            CPT myDiffCPT;
            String diffPrefix;
            String diffLabel;
            GriddedGeoDataSet diff;
            if (difference) {
                diff = new GriddedGeoDataSet(primary.getRegion(), false);
                for (int i = 0; i < diff.size(); ++i) {
                    diff.set(i, primary.get(i) - comparison.get(i));
                }
                diffLabel = "Primary - Comparison, " + label;
                diffPrefix = prefix + "_comp_diff";
                myDiffCPT = diffCPT;
                diffForStats = diff;
            } else {
                diff = this.buildPDiff(comparison, primary);
                diffLabel = "Primary / Comparison, % Change, " + unitlessLabel;
                diffPrefix = prefix + "_comp_pDiff";
                myDiffCPT = pDiffCPT;
                pDiffForStats = diff;
            }
            if (compReg != null && compReg.getNodeCount() < primary.getRegion().getNodeCount() && this.checkShrinkToComparison(diff, remappedDiff = new GriddedGeoDataSet(compReg, false))) {
                diff = remappedDiff;
            }
            map = LogicTreeHazardCompare.submitMapFuture(this.mapper, this.exec, this.futures, resourcesDir, diffPrefix, diff, myDiffCPT, name + " vs " + compName, diffLabel, !difference);
            table.addColumn("![Difference Map](" + resourcesDir.getName() + "/" + map.getName() + ")");
        }
        table.finalizeLine();
        table.addLine(this.mapStats(primary), this.mapStats(comparison), this.mapStats(diffForStats), this.mapStats(pDiffForStats, true));
    }

    public void writeCombinedBranchMap(File resourcesDir, String prefix, String fullTitle, SolHazardMapCalc.MapPlot meanMap, List<LogicTreeLevel<?>> branchLevels, List<List<LogicTreeNode>> branchLevelValues, List<List<SolHazardMapCalc.MapPlot>> branchLevelPlots, String label) throws IOException {
        this.writeCombinedBranchMap(resourcesDir, prefix, fullTitle, meanMap, branchLevels, branchLevelValues, branchLevelPlots, label, null, null);
    }

    public void writeCombinedBranchMap(File resourcesDir, String prefix, String fullTitle, SolHazardMapCalc.MapPlot meanMap, List<LogicTreeLevel<?>> branchLevels, List<List<LogicTreeNode>> branchLevelValues, List<List<SolHazardMapCalc.MapPlot>> branchLevelPlots1, String label1, List<List<SolHazardMapCalc.MapPlot>> branchLevelPlots2, String label2) throws IOException {
        int secondaryStartX;
        int primaryWidth = 1200;
        int primaryWidthDelta = 5;
        int secondaryWidth = primaryWidth / primaryWidthDelta;
        int padding = 10;
        int heightLevelName = 40;
        int heightChoice = 25;
        double secondaryScale = (double)secondaryWidth / (double)primaryWidth;
        int maxNumChoices = 0;
        for (List<SolHazardMapCalc.MapPlot> plots : branchLevelPlots1) {
            maxNumChoices = Integer.max(maxNumChoices, plots.size());
        }
        if (branchLevelPlots2 != null) {
            Preconditions.checkState((branchLevelPlots2.size() == branchLevelPlots1.size() ? 1 : 0) != 0);
        }
        Preconditions.checkState((maxNumChoices > 0 ? 1 : 0) != 0);
        PlotPreferences primaryPrefs = PlotUtils.getDefaultFigurePrefs();
        primaryPrefs.scaleFontSizes(1.25);
        PlotPreferences secondaryPrefs = primaryPrefs.clone();
        secondaryPrefs.scaleFontSizes(secondaryScale);
        Font fontLevelName = new Font("SansSerif", 1, primaryPrefs.getPlotLabelFontSize());
        Font fontChoiceName = new Font("SansSerif", 1, primaryPrefs.getLegendFontSize());
        Font fontWeight = new Font("SansSerif", 2, primaryPrefs.getLegendFontSize());
        HeadlessGraphPanel primaryGP = new HeadlessGraphPanel(primaryPrefs);
        XYZPlotSpec primarySpec = meanMap.spec;
        primarySpec.setCPTTickUnit(0.5);
        primarySpec.setTitle(fullTitle);
        CPT diffCPT = branchLevelPlots1.get((int)0).get((int)0).spec.getCPT();
        PlotPreferences prefs = primaryGP.getPlotPrefs();
        PaintScaleLegend diffSubtitle = GraphPanel.getLegendForCPT(diffCPT, label1, prefs.getAxisLabelFontSize(), prefs.getTickLabelFontSize(), -1.0, RectangleEdge.BOTTOM);
        if (branchLevelPlots2 != null) {
            CPT diffCPT2 = branchLevelPlots2.get((int)0).get((int)0).spec.getCPT();
            PaintScaleLegend diffSubtitle2 = GraphPanel.getLegendForCPT(diffCPT2, label2, prefs.getAxisLabelFontSize(), prefs.getTickLabelFontSize(), -1.0, RectangleEdge.BOTTOM);
            primarySpec.addSubtitle((Title)diffSubtitle2);
        }
        primarySpec.addSubtitle((Title)diffSubtitle);
        primaryGP.drawGraphPanel(primarySpec, false, false, meanMap.xRnage, meanMap.yRange);
        PlotUtils.setXTick(primaryGP, meanMap.xTick);
        PlotUtils.setYTick(primaryGP, meanMap.yTick);
        int primaryHeight = PlotUtils.calcHeight(primaryGP, primaryWidth, true);
        SolHazardMapCalc.MapPlot secondaryPlot = branchLevelPlots1.get(0).get(0);
        HeadlessGraphPanel secondaryGP = this.drawSimplifiedSecondaryPlot(secondaryPlot, secondaryPrefs, 1.0);
        int secondaryHeight = PlotUtils.calcHeight(secondaryGP, secondaryWidth, true);
        int secondaryHeightEach = heightLevelName + heightChoice + secondaryHeight;
        if (branchLevelPlots2 != null) {
            secondaryHeightEach += secondaryHeight;
        }
        int totalHeight = Integer.max(primaryHeight, padding * 2 + branchLevels.size() * secondaryHeightEach);
        int totalWidth = padding * 2 + primaryWidth + maxNumChoices * secondaryWidth;
        System.out.println("Building combined map with dimensions: primary=" + primaryWidth + "x" + primaryHeight + ", secondary=" + secondaryWidth + "x" + secondaryHeight + ", total=" + totalWidth + "x" + totalHeight);
        JLayeredPane panel = new JLayeredPane();
        panel.setOpaque(true);
        panel.setBackground(Color.WHITE);
        panel.setSize(totalWidth, totalHeight);
        ArrayList<Consumer<Graphics2D>> redraws = new ArrayList<Consumer<Graphics2D>>();
        int plotLayer = JLayeredPane.DEFAULT_LAYER;
        int labelLayer = JLayeredPane.PALETTE_LAYER;
        int primaryTopY = 0;
        redraws.add(this.placeGraph(panel, plotLayer, 0, primaryTopY, primaryWidth, primaryHeight, primaryGP.getChartPanel()));
        primarySpec.setSubtitles(null);
        int levelLabelX = secondaryStartX = padding + primaryWidth;
        int levelLabelWidth = totalWidth - secondaryStartX - padding;
        int y = 0;
        for (int l = 0; l < branchLevels.size(); ++l) {
            int levelLabelY = y;
            LogicTreeLevel<?> level = branchLevels.get(l);
            int choiceLabelY = y + heightLevelName;
            int choiceMapY = y + heightLevelName + heightChoice;
            int choiceMapY2 = y + heightLevelName + heightChoice + secondaryHeight;
            List<LogicTreeNode> myChoices = branchLevelValues.get(l);
            List<SolHazardMapCalc.MapPlot> myPlots = branchLevelPlots1.get(l);
            int n = secondaryStartX;
            if (CENTER_SUBPLOTS && myChoices.size() < maxNumChoices) {
                n += (maxNumChoices - myChoices.size()) * secondaryWidth / 2;
            }
            for (int i = 0; i < myChoices.size(); ++i) {
                secondaryPlot = myPlots.get(i);
                secondaryGP = this.drawSimplifiedSecondaryPlot(secondaryPlot, secondaryPrefs, secondaryScale);
                redraws.add(this.placeGraph(panel, plotLayer, n, choiceMapY, secondaryWidth, secondaryHeight, secondaryGP.getChartPanel()));
                LogicTreeNode choice = branchLevelValues.get(l).get(i);
                this.placeLabel(panel, labelLayer, n, choiceLabelY, secondaryWidth, heightChoice, choice.getShortName(), fontChoiceName);
                if (INCLUDE_SUBPLOT_WEIGHT_LABELS) {
                    double totWeight = 0.0;
                    double matchWeight = 0.0;
                    for (int b = 0; b < this.branches.size(); ++b) {
                        LogicTreeBranch<?> branch = this.branches.get(b);
                        double weight = this.weights.get(b);
                        if (branch.hasValue(choice)) {
                            matchWeight += weight;
                        }
                        totWeight += weight;
                    }
                    String label = " (" + new DecimalFormat("0.0#").format(matchWeight / totWeight) + ")";
                    int weightLabelY = choiceMapY + secondaryHeight - 3 * heightChoice / 2;
                    final JLabel jLabel = this.placeLabel(panel, labelLayer, n, weightLabelY, secondaryWidth, heightChoice, " " + label, fontWeight, 2);
                    redraws.add(new Consumer<Graphics2D>(){
                        final /* synthetic */ LogicTreeHazardCompare this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void accept(Graphics2D t) {
                            jLabel.paintImmediately(jLabel.getBounds());
                        }
                    });
                }
                n += secondaryWidth;
            }
            this.placeLabel(panel, labelLayer, levelLabelX, levelLabelY, levelLabelWidth, heightLevelName, level.getName(), fontLevelName);
            if (branchLevelPlots2 != null) {
                n = secondaryStartX;
                List<SolHazardMapCalc.MapPlot> myPlots2 = branchLevelPlots2.get(l);
                for (int i = 0; i < myChoices.size(); ++i) {
                    secondaryPlot = myPlots2.get(i);
                    secondaryGP = this.drawSimplifiedSecondaryPlot(secondaryPlot, secondaryPrefs, secondaryScale);
                    redraws.add(this.placeGraph(panel, plotLayer, n, choiceMapY2, secondaryWidth, secondaryHeight, secondaryGP.getChartPanel()));
                    n += secondaryWidth;
                }
            }
            y += secondaryHeightEach;
        }
        BufferedImage bi = new BufferedImage(totalWidth, totalHeight, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        panel.paint(bi.getGraphics());
        ImageIO.write((RenderedImage)bi, "png", new File(resourcesDir, prefix + ".png"));
        if (SolHazardMapCalc.PDFS) {
            Document metadataDocument = new Document(new Rectangle((float)totalWidth, (float)totalHeight));
            metadataDocument.addAuthor("OpenSHA");
            metadataDocument.addCreationDate();
            try {
                PdfWriter writer = PdfWriter.getInstance((Document)metadataDocument, (OutputStream)new FileOutputStream(new File(resourcesDir, prefix + ".pdf")));
                metadataDocument.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate tp = cb.createTemplate((float)totalWidth, (float)totalHeight);
                PDF_UTF8_FontMapper fontMapper = new PDF_UTF8_FontMapper();
                g2d = new PdfGraphics2D((PdfContentByte)tp, (float)totalWidth, (float)totalHeight, (FontMapper)fontMapper);
                panel.paint(g2d);
                for (Consumer consumer : redraws) {
                    consumer.accept(g2d);
                }
                g2d.dispose();
                cb.addTemplate(tp, 0.0f, 0.0f);
            }
            catch (DocumentException de) {
                de.printStackTrace();
            }
            metadataDocument.close();
        }
    }

    private HeadlessGraphPanel drawSimplifiedSecondaryPlot(SolHazardMapCalc.MapPlot secondaryPlot, PlotPreferences secondaryPrefs, double lineScalar) {
        secondaryPrefs.setAxisLabelFontSize(2);
        HeadlessGraphPanel secondaryGP = new HeadlessGraphPanel(secondaryPrefs);
        XYZPlotSpec secondarySpec = secondaryPlot.spec;
        List<PlotCurveCharacterstics> origChars = null;
        if (lineScalar != 1.0 && secondarySpec.getChars() != null) {
            origChars = secondarySpec.getChars();
            ArrayList<PlotCurveCharacterstics> modChars = new ArrayList<PlotCurveCharacterstics>();
            for (PlotCurveCharacterstics pChar : origChars) {
                modChars.add(new PlotCurveCharacterstics(pChar.getLineType(), (float)((double)pChar.getLineWidth() * lineScalar), pChar.getSymbol(), (float)((double)pChar.getSymbolWidth() * lineScalar), pChar.getColor()));
            }
            secondarySpec.setChars(modChars);
        }
        secondarySpec.setCPTVisible(false);
        secondarySpec.setTitle(null);
        secondarySpec.setPlotAnnotations(null);
        secondaryGP.drawGraphPanel(secondarySpec, false, false, secondaryPlot.xRnage, secondaryPlot.yRange);
        secondaryGP.getXAxis().setTickLabelsVisible(false);
        secondaryGP.getXAxis().setLabel(" ");
        secondaryGP.getYAxis().setTickLabelsVisible(false);
        secondaryGP.getYAxis().setLabel(null);
        PlotUtils.setXTick(secondaryGP, secondaryPlot.xTick);
        PlotUtils.setYTick(secondaryGP, secondaryPlot.yTick);
        if (origChars != null) {
            secondarySpec.setChars(origChars);
        }
        return secondaryGP;
    }

    private Consumer<Graphics2D> placeGraph(JLayeredPane panel, int layer, final int xTop, final int yTop, final int width, final int height, final ChartPanel chart) {
        chart.setBorder(null);
        chart.getChart().createBufferedImage(width, height, new ChartRenderingInfo());
        chart.setSize(width, height);
        panel.setLayer((Component)chart, layer);
        panel.add((Component)chart);
        chart.setLocation(xTop, yTop);
        return new Consumer<Graphics2D>(){
            final /* synthetic */ LogicTreeHazardCompare this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(Graphics2D t) {
                chart.getChart().draw(t, (Rectangle2D)new Rectangle2D.Double(xTop, yTop, width, height));
            }
        };
    }

    private JLabel placeLabel(JLayeredPane panel, int layer, int xTop, int yTop, int width, int height, String text, Font font) {
        return this.placeLabel(panel, layer, xTop, yTop, width, height, text, font, 0);
    }

    private JLabel placeLabel(JLayeredPane panel, int layer, int xTop, int yTop, int width, int height, String text, Font font, int horizAlign) {
        JLabel label = new JLabel(text, horizAlign);
        label.setFont(font);
        label.setSize(width, height);
        panel.setLayer(label, layer);
        panel.add(label);
        label.setLocation(xTop, yTop);
        return label;
    }

    public void close() throws IOException {
        this.zip.close();
        this.exec.shutdown();
    }

    private static class ValWeights
    implements Comparable<ValWeights> {
        double val;
        double weight;

        public ValWeights(double val, double weight) {
            this.val = val;
            this.weight = weight;
        }

        @Override
        public int compareTo(ValWeights o) {
            return Double.compare(this.val, o.val);
        }
    }

    private static class LayeredPaneLayout
    implements LayoutManager {
        private final Container target;
        private final Dimension preferredSize;

        public LayeredPaneLayout(Container target, Dimension preferredSize) {
            this.target = target;
            this.preferredSize = preferredSize;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container container) {
            for (Component component : container.getComponents()) {
                component.setBounds(new java.awt.Rectangle(0, 0, this.target.getWidth(), this.target.getHeight()));
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.preferredSize;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private static class AvgMaxCalc {
        private double sum;
        private double max = Double.NEGATIVE_INFINITY;
        private int numUsed;
        private int numSkipped;

        private AvgMaxCalc() {
        }

        public void addValue(double value) {
            if (Double.isFinite(value)) {
                this.sum += value;
                this.max = Math.max(value, this.max);
                ++this.numUsed;
            } else {
                ++this.numSkipped;
            }
        }

        public double getAverage() {
            return this.sum / (double)this.numUsed;
        }

        public double getMax() {
            return this.max;
        }
    }
}

