/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.stat.descriptive.moment.Variance;
import org.apache.commons.math3.util.MathArrays;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.uncertainty.UncertainBoundedDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.ExecutorUtils;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.hazard.LogicTreeCurveAverager;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_SiteLogicTreeHazardCurveCalc;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.earthquake.faultSysSolution.util.SolSiteHazardCalc;

public class SiteLogicTreeHazardPageGen {
    private static final DecimalFormat pDF = new DecimalFormat("0.##%");
    private static final double[] fractiles = new double[]{0.0, 0.025, 0.16, 0.84, 0.975, 1.0};
    private static final String[] fractileHeaders = new String[fractiles.length];

    public static void main(String[] args) throws ZipException, IOException {
        File outFile;
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            args = new String[]{"/home/kevin/OpenSHA/UCERF4/batch_inversions/2022_09_16-nshm23_branches-NSHM23_v2-CoulombRupSet-TotNuclRate-NoRed-ThreshAvgIterRelGR/results_hazard_sites.zip", "/tmp/site_hazard"};
        }
        System.setProperty("java.awt.headless", "true");
        CommandLine cmd = FaultSysTools.parseOptions(SiteLogicTreeHazardPageGen.createOptions(), args, SiteLogicTreeHazardPageGen.class);
        args = cmd.getArgs();
        boolean resume = cmd.hasOption("resume");
        if (args.length < 2 || args.length > 3) {
            System.err.println("USAGE: <zip-file> <output-dir> [<comp-zip-file>]");
            System.exit(1);
        }
        File zipFile = new File(args[0]);
        File outputDir = new File(args[1]);
        File compZipFile = null;
        if (args.length > 2) {
            compZipFile = new File(args[2]);
        }
        int threads = FaultSysTools.getNumThreads(cmd);
        ExecutorService exec = ExecutorUtils.newBlockingThreadPool(threads);
        int downsample = -1;
        if (cmd.hasOption("downsample")) {
            downsample = Integer.parseInt(cmd.getOptionValue("downsample"));
            System.out.println("Will downsample to at most " + downsample + " curves when plotting individual curves");
        }
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        File resourcesDir = new File(outputDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        ZipFile zip = new ZipFile(zipFile);
        ZipFile compZip = compZipFile == null ? null : new ZipFile(compZipFile);
        CSVFile<String> sitesCSV = CSVFile.readStream(zip.getInputStream(zip.getEntry("sites.csv")), true);
        LogicTree<LogicTreeNode> tree = LogicTree.read(new InputStreamReader(zip.getInputStream(zip.getEntry("logic_tree.json"))));
        List<Site> sites = MPJ_SiteLogicTreeHazardCurveCalc.parseSitesCSV(sitesCSV, null);
        SolHazardMapCalc.ReturnPeriods[] rps = SolHazardMapCalc.MAP_RPS;
        sites.sort(new NamedComparator());
        Color primaryColor = Color.RED;
        Color compColor = Color.BLUE;
        Color compHistColor = new Color(180, 180, 220);
        Color primaryHistColorOnCompPlot = new Color(220, 180, 180);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# Logic Tree Site Hazard Curves");
        lines.add("");
        int tocIndex = lines.size();
        String topLink = "_[(top)](#table-of-contents)_";
        boolean levelNameOverlap = false;
        ArrayList<Object> levelPrefixes = new ArrayList<Object>();
        for (LogicTreeLevel level : tree.getLevels()) {
            String ltPrefix = level.getFilePrefix();
            levelNameOverlap |= levelPrefixes.contains(ltPrefix);
            levelPrefixes.add(ltPrefix);
        }
        if (levelNameOverlap) {
            for (int i = 0; i < levelPrefixes.size(); ++i) {
                levelPrefixes.set(i, i + "_" + (String)levelPrefixes.get(i));
            }
        }
        ArrayList distSummaryCSVs = new ArrayList();
        ArrayList compDistSummaryCSVs = compZip == null ? null : new ArrayList();
        for (int r = 0; r < rps.length; ++r) {
            List<String> header = SiteLogicTreeHazardPageGen.buildDistHeader("Site Name", " g");
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine(header);
            distSummaryCSVs.add(csv);
            if (compDistSummaryCSVs == null) continue;
            csv = new CSVFile(true);
            csv.addLine(header);
            compDistSummaryCSVs.add(csv);
        }
        for (Site site : sites) {
            ArrayList<String> siteLines = new ArrayList<String>();
            siteLines.add("# " + site.getName() + " Logic Tree Hazard Curves");
            siteLines.add(topLink);
            siteLines.add("");
            siteLines.add("[Return to Full Site List](README.md)");
            siteLines.add("");
            int siteTOCIndex = siteLines.size();
            lines.add("## " + site.getName());
            lines.add(topLink);
            lines.add("");
            System.out.println("Site: " + site.getName());
            String sitePrefix = FileNameUtils.simplify(site.getName());
            lines.add("Summary figures across all branches are shown here. _[Click here for detailed branch-specific hazard curves for " + site.getName() + "](" + sitePrefix + ".md)_");
            lines.add("");
            Map<Double, ZipEntry> perEntries = SiteLogicTreeHazardPageGen.locateSiteCurveCSVs(sitePrefix, zip);
            Preconditions.checkState((!perEntries.isEmpty() ? 1 : 0) != 0);
            ArrayList<Double> periods = new ArrayList<Double>(perEntries.keySet());
            Collections.sort(periods);
            Map<Double, ZipEntry> compPerEntries = null;
            if (compZip != null && (compPerEntries = SiteLogicTreeHazardPageGen.locateSiteCurveCSVs(sitePrefix, compZip)).isEmpty()) {
                compPerEntries = null;
            }
            Iterator iterator = periods.iterator();
            while (iterator.hasNext()) {
                Iterator future2;
                int r;
                MarkdownUtils.TableBuilder table;
                String perUnits;
                Object perPrefix;
                Object perLabel;
                double period = (Double)iterator.next();
                if (period == -1.0) {
                    perLabel = "PGV";
                    perPrefix = "pgv";
                    perUnits = "cm/s";
                } else if (period == 0.0) {
                    perLabel = "PGA";
                    perPrefix = "pga";
                    perUnits = "g";
                } else {
                    perLabel = (float)period + "s SA";
                    perPrefix = "sa_" + (float)period;
                    perUnits = "g";
                }
                if (periods.size() > 1) {
                    siteLines.add("## " + site.getName() + ", " + (String)perLabel);
                    siteLines.add(topLink);
                    siteLines.add("");
                    lines.add("### " + site.getName() + ", " + (String)perLabel);
                    lines.add(topLink);
                    lines.add("");
                }
                lines.add("");
                siteLines.add("");
                System.out.println("Period: " + (String)perLabel);
                ArrayList plotFutures = new ArrayList();
                System.out.println("\tReading curves");
                CSVFile<String> curvesCSV = CSVFile.readStream(zip.getInputStream(perEntries.get(period)), true);
                ArrayList<DiscretizedFunc> curves = new ArrayList<DiscretizedFunc>();
                ArrayList<Double> weights = new ArrayList<Double>();
                ArrayList branches = new ArrayList();
                System.out.println("\tBuilding curve dists");
                ValueDistribution[] dists = SiteLogicTreeHazardPageGen.loadCurvesAndDists(curvesCSV, tree.getLevels(), curves, branches, weights, true);
                DiscretizedFunc meanCurve = SiteLogicTreeHazardPageGen.calcMeanCurve(dists, SiteLogicTreeHazardPageGen.xVals((DiscretizedFunc)curves.get(0)));
                ZipEntry compEntry = null;
                if (compPerEntries != null) {
                    compEntry = compPerEntries.get(period);
                }
                ArrayList<DiscretizedFunc> compCurves = null;
                ArrayList<Double> compWeights = null;
                ValueDistribution[] compDists = null;
                DiscretizedFunc compMeanCurve = null;
                if (compEntry != null) {
                    System.out.println("\tReading comparison curves");
                    CSVFile<String> compCurvesCSV = CSVFile.readStream(compZip.getInputStream(compPerEntries.get(period)), true);
                    compCurves = new ArrayList<DiscretizedFunc>();
                    compWeights = new ArrayList<Double>();
                    System.out.println("\tBuilding comparison curve dists");
                    compDists = SiteLogicTreeHazardPageGen.loadCurvesAndDists(compCurvesCSV, null, compCurves, null, compWeights, true);
                    DiscretizedFunc discretizedFunc = compMeanCurve = compCurves.size() == 1 ? (DiscretizedFunc)compCurves.get(0) : SiteLogicTreeHazardPageGen.calcMeanCurve(compDists, SiteLogicTreeHazardPageGen.xVals((DiscretizedFunc)compCurves.get(0)));
                    if (compCurves.size() == 1) {
                        compDists = null;
                    }
                }
                String prefix = sitePrefix + "_" + (String)perPrefix;
                double[] xVals = SiteLogicTreeHazardPageGen.xVals((DiscretizedFunc)curves.get(0));
                System.out.println("\tBuilding plots");
                String plotPrefix = prefix + "_curve_dists";
                File plot = new File(resourcesDir, plotPrefix + ".png");
                if (!resume || !plot.exists()) {
                    SiteLogicTreeHazardPageGen.curveDistPlot(resourcesDir, plotPrefix, site.getName(), (String)perLabel, perUnits, dists, xVals, primaryColor, rps, compMeanCurve, compColor, exec, plotFutures);
                }
                if (compDists == null || compCurves.size() < 2) {
                    lines.add("![Curve Dist](" + resourcesDir.getName() + "/" + plot.getName() + ")");
                    siteLines.add("![Curve Dist](" + resourcesDir.getName() + "/" + plot.getName() + ")");
                    lines.add("");
                    lines.add("[__Download CSV__](" + resourcesDir.getName() + "/" + prefix + "_curve_dists.csv)");
                } else {
                    table = MarkdownUtils.tableBuilder();
                    table.addLine("Primary", "Comparison");
                    table.initNewLine();
                    table.addColumn("![Curve Dist](" + resourcesDir.getName() + "/" + plot.getName() + ")");
                    plotPrefix = prefix + "_comp_curve_dists";
                    plot = new File(resourcesDir, plotPrefix + ".png");
                    if (!resume || !plot.exists()) {
                        plot = SiteLogicTreeHazardPageGen.curveDistPlot(resourcesDir, plotPrefix, site.getName(), (String)perLabel, perUnits, compDists, SiteLogicTreeHazardPageGen.xVals((DiscretizedFunc)compCurves.get(0)), compColor, rps, SiteLogicTreeHazardPageGen.calcMeanCurve(dists, SiteLogicTreeHazardPageGen.xVals((DiscretizedFunc)compCurves.get(0))), primaryColor, exec, plotFutures);
                    }
                    table.addColumn("![Curve Dist](" + resourcesDir.getName() + "/" + plot.getName() + ")");
                    table.finalizeLine();
                    table.initNewLine();
                    table.addColumn("[__Download CSV__](" + resourcesDir.getName() + "/" + prefix + "_curve_dists.csv)");
                    table.addColumn("[__Download CSV__](" + resourcesDir.getName() + "/" + prefix + "_comp_curve_dists.csv)");
                    table.finalizeLine();
                    lines.addAll(table.build());
                    siteLines.addAll(table.build());
                }
                lines.add("");
                siteLines.add("");
                table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                for (SolHazardMapCalc.ReturnPeriods rp : rps) {
                    table.addColumn(rp.label);
                }
                table.finalizeLine().initNewLine();
                ArrayList<HistogramFunction> rpHists = new ArrayList<HistogramFunction>();
                ArrayList<HistogramFunction> rpCompHists = new ArrayList<HistogramFunction>();
                ArrayList<Double> rpMeans = new ArrayList<Double>();
                ArrayList<Double> rpCompMeans = compCurves == null ? null : new ArrayList<Double>();
                ArrayList<ArrayList<Double>> rpBranchValsList = new ArrayList<ArrayList<Double>>();
                ArrayList<ArrayList<Double>> rpCompBranchValsList = compCurves == null ? null : new ArrayList<ArrayList<Double>>();
                ValueDistribution[] branchDists = new ValueDistribution[rps.length];
                ValueDistribution[] compBranchDists = compCurves == null ? null : new ValueDistribution[rps.length];
                for (r = 0; r < rps.length; ++r) {
                    HistogramFunction refHist;
                    SolHazardMapCalc.ReturnPeriods rp = rps[r];
                    ArrayList<Double> branchVals = new ArrayList<Double>();
                    for (DiscretizedFunc curve : curves) {
                        branchVals.add(SiteLogicTreeHazardPageGen.curveVal(curve, rp));
                    }
                    rpBranchValsList.add(branchVals);
                    branchDists[r] = new ValueDistribution(branchVals, weights);
                    ArrayList<Double> compBranchVals = null;
                    Double compMean = null;
                    HistogramFunction compHist = null;
                    if (compCurves != null) {
                        compBranchVals = new ArrayList<Double>();
                        for (DiscretizedFunc curve : compCurves) {
                            compBranchVals.add(SiteLogicTreeHazardPageGen.curveVal(curve, rp));
                        }
                        compBranchDists[r] = new ValueDistribution(compBranchVals, compWeights);
                        ArrayList<Double> allVals = new ArrayList<Double>(curves.size() + compCurves.size());
                        allVals.addAll(branchVals);
                        allVals.addAll(compBranchVals);
                        refHist = SiteLogicTreeHazardPageGen.initHist(allVals);
                        rpCompBranchValsList.add(compBranchVals);
                        compMean = SiteLogicTreeHazardPageGen.curveVal(compMeanCurve, rp);
                        rpCompMeans.add(compMean);
                        if (compCurves.size() > 1) {
                            compHist = SiteLogicTreeHazardPageGen.buildHist(compWeights, compBranchVals, refHist);
                            compHist.setName("Comparison Distribution");
                        }
                        rpCompHists.add(compHist);
                    } else {
                        refHist = SiteLogicTreeHazardPageGen.initHist(branchVals);
                    }
                    HistogramFunction hist = SiteLogicTreeHazardPageGen.buildHist(branches, weights, branchVals, null, refHist);
                    hist.setName("Distribution");
                    rpHists.add(hist);
                    double mean = SiteLogicTreeHazardPageGen.curveVal(meanCurve, rp);
                    rpMeans.add(mean);
                    String label = (String)perLabel + ", " + rp.label + " (" + perUnits + ")";
                    plotPrefix = prefix + "_" + rp.name();
                    plot = new File(resourcesDir, plotPrefix + ".png");
                    if (!resume || !plot.exists()) {
                        plot = SiteLogicTreeHazardPageGen.valDistPlot(resourcesDir, plotPrefix, site.getName(), label, hist, mean, branchDists[r], primaryColor, null, compHist, compMean, compColor, compHistColor, "Comparison", exec, plotFutures);
                    }
                    table.addColumn("![Dist](" + resourcesDir.getName() + "/" + plot.getName() + ")");
                }
                table.finalizeLine();
                if (compCurves != null) {
                    if (compCurves.size() > 1) {
                        table.initNewLine();
                        for (SolHazardMapCalc.ReturnPeriods rp : rps) {
                            table.addColumn(MarkdownUtils.boldCentered("Comparison Distribution, " + rp.label));
                        }
                        table.finalizeLine().initNewLine();
                        for (r = 0; r < rps.length; ++r) {
                            double mean = (Double)rpMeans.get(r);
                            double compMean = (Double)rpCompMeans.get(r);
                            HistogramFunction compHist = (HistogramFunction)rpCompHists.get(r);
                            String label = (String)perLabel + ", " + rps[r].label + " (" + perUnits + ")";
                            HistogramFunction origHist = (HistogramFunction)rpHists.get(r);
                            origHist.setName("Primary Distribution");
                            plotPrefix = prefix + "_" + rps[r].name() + "_comp";
                            plot = new File(resourcesDir, plotPrefix + ".png");
                            if (!resume || !plot.exists()) {
                                plot = SiteLogicTreeHazardPageGen.valDistPlot(resourcesDir, plotPrefix, site.getName(), label, compHist, compMean, compBranchDists[r], compColor, "Comparison", origHist, mean, primaryColor, primaryHistColorOnCompPlot, "Primary", exec, plotFutures);
                            }
                            table.addColumn("![Dist](" + resourcesDir.getName() + "/" + plot.getName() + ")");
                        }
                        table.finalizeLine();
                    } else {
                        for (r = 0; r < rps.length; ++r) {
                            List compBranchVals = (List)rpCompBranchValsList.get(r);
                            Preconditions.checkState((compBranchVals.size() == 1 ? 1 : 0) != 0);
                            rpCompMeans.add((Double)compBranchVals.get(0));
                        }
                    }
                }
                if (periods.size() > 1) {
                    lines.add("#### " + site.getName() + ", " + (String)perLabel + ", Hazard Value Distributions");
                    siteLines.add("### " + site.getName() + ", " + (String)perLabel + ", Hazard Value Distributions");
                } else {
                    lines.add("### " + site.getName() + ", " + (String)perLabel + ", Hazard Value Distributions");
                    siteLines.add("## " + site.getName() + ", " + (String)perLabel + ", Hazard Value Distributions");
                }
                lines.add(topLink);
                lines.add("");
                lines.add("");
                lines.addAll(table.build());
                siteLines.add(topLink);
                siteLines.add("");
                siteLines.add("");
                siteLines.addAll(table.build());
                table = MarkdownUtils.tableBuilder();
                table.initNewLine().addColumn("");
                for (SolHazardMapCalc.ReturnPeriods rp : rps) {
                    if (compBranchDists == null) {
                        table.addColumn(rp.label);
                        continue;
                    }
                    table.addColumn("Primary " + rp.label).addColumn("Comparison " + rp.label);
                }
                table.finalizeLine();
                table.initNewLine().addColumn("__Mean (g)__");
                for (r = 0; r < rps.length; ++r) {
                    table.addColumn(Float.valueOf(((Double)rpMeans.get(r)).floatValue()));
                    if (compBranchDists == null) continue;
                    table.addColumn(Float.valueOf(((Double)rpCompMeans.get(r)).floatValue()));
                }
                table.finalizeLine();
                if (dists[0].size > 1) {
                    table.initNewLine().addColumn("__Median (g)__");
                    for (r = 0; r < rps.length; ++r) {
                        table.addColumn("" + (float)branchDists[r].getInterpolatedFractile(0.5));
                        if (compBranchDists == null) continue;
                        if (compBranchDists[0].size > 1) {
                            table.addColumn("" + (float)compBranchDists[r].getInterpolatedFractile(0.5));
                            continue;
                        }
                        table.addColumn("__(N/A)__");
                    }
                    table.finalizeLine();
                    table.initNewLine().addColumn("__Std. Dev. (g)__");
                    for (r = 0; r < rps.length; ++r) {
                        table.addColumn("" + (float)branchDists[r].stdDev);
                        if (compBranchDists == null) continue;
                        if (compBranchDists[0].size > 1) {
                            table.addColumn("" + (float)compBranchDists[r].stdDev);
                            continue;
                        }
                        table.addColumn("__(N/A)__");
                    }
                    table.finalizeLine();
                    table.initNewLine().addColumn("__COV__");
                    for (r = 0; r < rps.length; ++r) {
                        table.addColumn("" + (float)(branchDists[r].stdDev / (Double)rpMeans.get(r)));
                        if (compBranchDists == null) continue;
                        if (compBranchDists[0].size > 1) {
                            table.addColumn("" + (float)(compBranchDists[r].stdDev / (Double)rpCompMeans.get(r)));
                            continue;
                        }
                        table.addColumn("__(N/A)__");
                    }
                    table.finalizeLine();
                    for (int f = 0; f < fractiles.length; ++f) {
                        table.initNewLine().addColumn("__" + fractileHeaders[f] + " (g)__");
                        for (int r2 = 0; r2 < rps.length; ++r2) {
                            table.addColumn(Float.valueOf((float)branchDists[r2].getInterpolatedFractile(fractiles[f])));
                            if (compBranchDists == null) continue;
                            if (compBranchDists[0].size > 1) {
                                table.addColumn(Float.valueOf((float)compBranchDists[r2].getInterpolatedFractile(fractiles[f])));
                                continue;
                            }
                            table.addColumn("__(N/A)__");
                        }
                        table.finalizeLine();
                    }
                }
                for (r = 0; r < rps.length; ++r) {
                    ((CSVFile)distSummaryCSVs.get(r)).addLine(dists[r].buildLine(site.getName()));
                    if (compDists == null) continue;
                    ((CSVFile)compDistSummaryCSVs.get(r)).addLine(compDists[r].buildLine(site.getName()));
                }
                lines.add("");
                lines.addAll(table.build());
                lines.add("");
                siteLines.add("");
                siteLines.addAll(table.build());
                siteLines.add("");
                int siteLinesLevelTableIndex = siteLines.size();
                ArrayList<CallSite> levelLinks = new ArrayList<CallSite>();
                ArrayList<CallSite> levelAvgPlotLinks = new ArrayList<CallSite>();
                for (int l = 0; l < tree.getLevels().size(); ++l) {
                    int r3;
                    ArrayList<LogicTreeNode> nodes = new ArrayList<LogicTreeNode>();
                    ArrayList<DiscretizedFunc> nodeMeanCurves = new ArrayList<DiscretizedFunc>();
                    ArrayList<List<DiscretizedFunc>> nodeCurves = new ArrayList<List<DiscretizedFunc>>();
                    ArrayList nodeHists = new ArrayList();
                    ArrayList nodeMeans = new ArrayList();
                    for (int r4 = 0; r4 < rps.length; ++r4) {
                        nodeHists.add(new ArrayList());
                        nodeMeans.add(new ArrayList());
                    }
                    LogicTreeLevel level = (LogicTreeLevel)tree.getLevels().get(l);
                    for (LogicTreeNode node : level.getNodes()) {
                        ArrayList<DiscretizedFunc> myNodeCurves;
                        DiscretizedFunc nodeMeanCurve = SiteLogicTreeHazardPageGen.getNodeMeanCurve(branches, weights, curves, node, myNodeCurves = new ArrayList<DiscretizedFunc>());
                        if (nodeMeanCurve == null) continue;
                        nodes.add(node);
                        nodeCurves.add(myNodeCurves);
                        for (int r5 = 0; r5 < rps.length; ++r5) {
                            List branchVals = (List)rpBranchValsList.get(r5);
                            ((List)nodeHists.get(r5)).add(SiteLogicTreeHazardPageGen.buildHist(branches, weights, branchVals, node, (HistogramFunction)rpHists.get(r5)));
                            ((List)nodeMeans.get(r5)).add(SiteLogicTreeHazardPageGen.curveVal(nodeMeanCurve, rps[r5]));
                        }
                        nodeMeanCurves.add(nodeMeanCurve);
                    }
                    if (nodes.size() <= 1 || LogicTreeCurveAverager.shouldSkipLevel(level, nodes.size())) continue;
                    String ltPrefix = prefix + "_" + (String)levelPrefixes.get(l);
                    String heading = site.getName() + ", " + (String)perLabel + ", " + level.getName() + " Hazard";
                    if (periods.size() > 1) {
                        siteLines.add("### " + heading);
                    } else {
                        siteLines.add("## " + heading);
                    }
                    siteLines.add(topLink);
                    siteLines.add("");
                    System.out.println("\t\tLogic tree level: " + level.getName());
                    table = MarkdownUtils.tableBuilder();
                    table.addLine(MarkdownUtils.boldCentered("Individual Curves"), MarkdownUtils.boldCentered("Choice Mean Curves"));
                    table.initNewLine();
                    plotPrefix = ltPrefix + "_indv";
                    plot = new File(resourcesDir, plotPrefix + ".png");
                    if (!resume || !plot.exists()) {
                        plot = SiteLogicTreeHazardPageGen.curveBranchPlot(resourcesDir, plotPrefix, site.getName(), (String)perLabel, perUnits, dists, xVals, Color.BLACK, rps, compDists, Color.GRAY, nodes, nodeCurves, downsample, null, exec, plotFutures);
                    }
                    table.addColumn("![" + level.getShortName() + " Individual](" + resourcesDir.getName() + "/" + plot.getName() + ")");
                    plotPrefix = ltPrefix + "_means";
                    plot = new File(resourcesDir, plotPrefix + ".png");
                    if (!resume || !plot.exists()) {
                        plot = SiteLogicTreeHazardPageGen.curveBranchPlot(resourcesDir, plotPrefix, site.getName(), (String)perLabel, perUnits, dists, xVals, Color.BLACK, rps, compDists, Color.GRAY, nodes, null, downsample, nodeMeanCurves, exec, plotFutures);
                    }
                    String plotEmbed = "![" + level.getShortName() + " Means](" + resourcesDir.getName() + "/" + plot.getName() + ")";
                    table.addColumn(plotEmbed);
                    levelLinks.add((CallSite)((Object)("[" + level.getName() + "](#" + MarkdownUtils.getAnchorName(heading) + ")")));
                    levelAvgPlotLinks.add((CallSite)((Object)plotEmbed));
                    table.finalizeLine();
                    if (rps.length != 2) {
                        siteLines.addAll(table.build());
                        siteLines.add("");
                        table = MarkdownUtils.tableBuilder();
                    }
                    table.initNewLine();
                    for (r3 = 0; r3 < rps.length; ++r3) {
                        table.addColumn(MarkdownUtils.boldCentered(rps[r3].label));
                    }
                    table.finalizeLine();
                    table.initNewLine();
                    for (r3 = 0; r3 < rps.length; ++r3) {
                        String label = (String)perLabel + ", " + rps[r3].label + " (" + perUnits + ")";
                        Double compVal = rpCompMeans == null ? null : (Double)rpCompMeans.get(r3);
                        HistogramFunction hist = (HistogramFunction)rpHists.get(r3);
                        hist.setName(null);
                        plotPrefix = ltPrefix + "_" + rps[r3].name();
                        plot = new File(resourcesDir, plotPrefix + ".png");
                        if (!resume || !plot.exists()) {
                            plot = SiteLogicTreeHazardPageGen.valDistPlot(resourcesDir, plotPrefix, site.getName(), label, hist, (Double)rpMeans.get(r3), null, Color.BLACK, null, null, compVal, Color.GRAY, null, "Comparison", nodes, (List)nodeHists.get(r3), (List)nodeMeans.get(r3), exec, plotFutures);
                        }
                        table.addColumn("![Dist](" + resourcesDir.getName() + "/" + plot.getName() + ")");
                    }
                    table.finalizeLine();
                    siteLines.addAll(table.build());
                    siteLines.add("");
                    siteLines.add("[__Download Choice Mean Curves CSV__](" + resourcesDir.getName() + "/" + ltPrefix + "_means.csv)");
                    siteLines.add("");
                    table = MarkdownUtils.tableBuilder();
                    table.initNewLine();
                    table.addColumn("");
                    for (SolHazardMapCalc.ReturnPeriods rp : rps) {
                        table.addColumn(rp.label);
                    }
                    table.finalizeLine();
                    table.initNewLine();
                    table.addColumn("__Full Model__");
                    Iterator r6 = rpMeans.iterator();
                    while (r6.hasNext()) {
                        double rpVal = (Double)r6.next();
                        table.addColumn((float)rpVal + " (g)");
                    }
                    table.finalizeLine();
                    for (int i = 0; i < nodes.size(); ++i) {
                        table.initNewLine();
                        table.addColumn("__" + ((LogicTreeNode)nodes.get(i)).getShortName() + "__");
                        for (int r7 = 0; r7 < rps.length; ++r7) {
                            table.addColumn(((Double)((List)nodeMeans.get(r7)).get(i)).floatValue() + " (g)");
                        }
                        table.finalizeLine();
                    }
                    siteLines.add("");
                    siteLines.addAll(table.build());
                    siteLines.add("");
                }
                System.out.println("\tFinishing up " + plotFutures.size() + " plot futures");
                for (Iterator future2 : plotFutures) {
                    try {
                        future2.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        exec.shutdown();
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
                if (levelLinks.isEmpty()) continue;
                MarkdownUtils.TableBuilder summaryTable = MarkdownUtils.tableBuilder();
                summaryTable.initNewLine();
                for (String link : levelLinks) {
                    summaryTable.addColumn("__" + link + "__");
                }
                summaryTable.finalizeLine();
                summaryTable.initNewLine();
                future2 = levelAvgPlotLinks.iterator();
                while (future2.hasNext()) {
                    String plotEmbed = (String)future2.next();
                    summaryTable.addColumn(plotEmbed);
                }
                summaryTable.finalizeLine();
                ArrayList<Object> linesAdd = new ArrayList<Object>();
                linesAdd.add("");
                if (periods.size() > 1) {
                    linesAdd.add("### " + site.getName() + ", " + (String)perLabel + ", Logic Tree Summary");
                } else {
                    linesAdd.add("## " + site.getName() + ", Logic Tree Summary");
                }
                linesAdd.add(topLink);
                linesAdd.add("");
                linesAdd.addAll(summaryTable.wrap(3, 0).build());
                linesAdd.add("");
                siteLines.addAll(siteLinesLevelTableIndex, linesAdd);
            }
            siteLines.addAll(siteTOCIndex, MarkdownUtils.buildTOC(siteLines, 2, 3));
            siteLines.add(siteTOCIndex, "## Table Of Contents");
            MarkdownUtils.writeReadmeAndHTML(siteLines, outputDir, sitePrefix);
        }
        exec.shutdown();
        lines.addAll(tocIndex, MarkdownUtils.buildTOC(lines, 2, sites.size() > 10 ? 2 : 3));
        lines.add(tocIndex, "## Table Of Contents");
        ArrayList<String> valDistLines = new ArrayList<String>();
        valDistLines.add("Distribution CSV summary files:");
        valDistLines.add("");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        if (compDistSummaryCSVs == null) {
            table.initNewLine();
            for (int r = 0; r < rps.length; ++r) {
                CSVFile csv = (CSVFile)distSummaryCSVs.get(r);
                outFile = new File(resourcesDir, "dist_summary_" + rps[r].name() + ".csv");
                csv.writeToFile(outFile);
                table.addColumn("[" + rps[r].label + "](" + resourcesDir.getName() + "/" + outFile.getName() + ")");
            }
            table.finalizeLine();
        } else {
            int r;
            table.initNewLine().addColumn("");
            for (r = 0; r < rps.length; ++r) {
                table.addColumn(rps[r].label);
            }
            table.finalizeLine();
            table.initNewLine().addColumn("Primary");
            for (r = 0; r < rps.length; ++r) {
                CSVFile csv = (CSVFile)distSummaryCSVs.get(r);
                outFile = new File(resourcesDir, "dist_summary_" + rps[r].name() + ".csv");
                csv.writeToFile(outFile);
                table.addColumn("[Download](" + resourcesDir.getName() + "/" + outFile.getName() + ")");
            }
            table.finalizeLine();
            table.initNewLine().addColumn("Comparison");
            for (r = 0; r < rps.length; ++r) {
                CSVFile csv = (CSVFile)compDistSummaryCSVs.get(r);
                outFile = new File(resourcesDir, "dist_summary_comp_" + rps[r].name() + ".csv");
                csv.writeToFile(outFile);
                table.addColumn("[Download](" + resourcesDir.getName() + "/" + outFile.getName() + ")");
            }
            table.finalizeLine();
        }
        valDistLines.addAll(table.build());
        valDistLines.add("");
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
    }

    public static Options createOptions() {
        Options ops = new Options();
        ops.addOption(null, "downsample", true, "Maximum number of individual curves to include in plots (will be randomly downsampled to match if more curves exist).");
        ops.addOption(null, "resume", false, "Flag to resume a previos plot without regenerating everything.");
        ops.addOption(FaultSysTools.threadsOption());
        return ops;
    }

    public static Map<Double, ZipEntry> locateSiteCurveCSVs(String sitePrefix, ZipFile zip) {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        HashMap<Double, ZipEntry> perEntires = new HashMap<Double, ZipEntry>();
        while (entries.hasMoreElements()) {
            double period;
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(sitePrefix)) continue;
            String nameLeft = name.substring(sitePrefix.length());
            if (nameLeft.equals("_pgv.csv")) {
                period = -1.0;
            } else if (nameLeft.equals("_pga.csv")) {
                period = 0.0;
            } else if (nameLeft.startsWith("_sa_") && nameLeft.endsWith(".csv")) {
                String perStr = nameLeft.substring(4, nameLeft.length() - 4);
                period = Double.parseDouble(perStr);
            } else {
                System.err.println("Skipping unexpected file that we couldn't parse for a period: " + name);
                continue;
            }
            perEntires.put(period, entry);
        }
        return perEntires;
    }

    public static List<DiscretizedFunc> loadCurves(CSVFile<String> curvesCSV, LogicTree<?> tree) {
        ArrayList<DiscretizedFunc> curves = new ArrayList<DiscretizedFunc>(tree.size());
        ArrayList branches = new ArrayList(tree.size());
        ArrayList<Double> weights = new ArrayList<Double>(tree.size());
        SiteLogicTreeHazardPageGen.loadCurvesAndDists(curvesCSV, tree.getLevels(), curves, branches, weights, false);
        Preconditions.checkState((curves.size() == branches.size() ? 1 : 0) != 0);
        if (curves.size() != tree.size()) {
            System.out.println("WARNING: we have " + curves.size() + " curves but the passed in tree has " + tree.size() + " breanches. It's likely resampled and we will attempt to match.");
        }
        ArrayList<DiscretizedFunc> reordered = null;
        HashMap treeBranchIndexes = null;
        for (int i = 0; i < curves.size(); ++i) {
            Integer index;
            LogicTreeBranch<?> treeBranch = i < tree.size() ? tree.getBranch(i) : null;
            LogicTreeBranch curveBranch = (LogicTreeBranch)branches.get(i);
            if (reordered == null && treeBranch != null && treeBranch.equals(curveBranch)) continue;
            if (reordered == null) {
                int index2;
                treeBranchIndexes = new HashMap(tree.size());
                for (index2 = 0; index2 < tree.size(); ++index2) {
                    LogicTreeBranch<?> tempBranch = tree.getBranch(index2);
                    if (treeBranchIndexes.containsKey(tempBranch)) continue;
                    treeBranchIndexes.put(tempBranch, index2);
                    Preconditions.checkState((boolean)treeBranchIndexes.containsKey(tempBranch));
                }
                reordered = new ArrayList<DiscretizedFunc>(tree.size());
                for (index2 = 0; index2 < tree.size(); ++index2) {
                    if (index2 < i) {
                        reordered.add((DiscretizedFunc)curves.get(index2));
                        continue;
                    }
                    reordered.add(null);
                }
                System.out.println("Had to reorder hazard curves to match passed in logic tree; first mismatch i=" + i + " -> " + String.valueOf(treeBranchIndexes.get(curveBranch)) + "\n\ttreeBranch= " + String.valueOf(treeBranch) + "\n\tcurveBranch=" + String.valueOf(curveBranch));
            }
            if ((index = (Integer)treeBranchIndexes.get(curveBranch)) == null) continue;
            Preconditions.checkState((reordered.set(index, (DiscretizedFunc)curves.get(i)) == null ? 1 : 0) != 0);
        }
        if (reordered != null) {
            int holes = 0;
            for (int i = 0; i < reordered.size(); ++i) {
                if (reordered.get(i) != null) continue;
                ++holes;
                LogicTreeBranch<?> treeBranch = tree.getBranch(i);
                Integer prevIndex = (Integer)treeBranchIndexes.get(treeBranch);
                Preconditions.checkState((prevIndex != null ? 1 : 0) != 0, (String)"No mappings found for branch %s; i=%s, prevIndex=%s", treeBranch, (Object)i, (Object)prevIndex);
                DiscretizedFunc curve = (DiscretizedFunc)reordered.get(prevIndex);
                Preconditions.checkNotNull((Object)curve, (String)"Filling in a hole at %s, found prevIndex=%s but the curve at the index was null? branch: %s", (Object)i, (Object)prevIndex, treeBranch);
                reordered.set(i, curve);
            }
            if (holes > 0) {
                System.out.println("Filled in " + holes + " holes (i.e., input tree has duplicates)");
            }
            return reordered;
        }
        return curves;
    }

    static ValueDistribution[] loadCurvesAndDists(CSVFile<String> curvesCSV, List<? extends LogicTreeLevel<? extends LogicTreeNode>> levels, List<DiscretizedFunc> curves, List<LogicTreeBranch<?>> branches, List<Double> weights, boolean buildDists) {
        return SiteLogicTreeHazardPageGen.loadCurvesAndDists(curvesCSV, levels, curves, branches, weights, buildDists, null);
    }

    static ValueDistribution[] loadCurvesAndDists(CSVFile<String> curvesCSV, List<? extends LogicTreeLevel<? extends LogicTreeNode>> levels, List<DiscretizedFunc> curves, List<LogicTreeBranch<?>> branches, List<Double> weights, boolean buildDists, double[] outXVals) {
        int i;
        int startCol;
        ArrayList levelsCopy;
        if (levels == null) {
            levelsCopy = null;
            List<String> header = curvesCSV.getLine(0);
            startCol = -1;
            for (int i2 = 0; i2 < header.size(); ++i2) {
                try {
                    Double.parseDouble(header.get(i2));
                    startCol = i2;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            Preconditions.checkState((startCol > 2 ? 1 : 0) != 0);
        } else {
            levelsCopy = new ArrayList(levels);
            startCol = 3 + levels.size();
        }
        double[] inXVals = new double[curvesCSV.getNumCols() - startCol];
        ArrayList distValues = null;
        if (buildDists) {
            distValues = new ArrayList();
        }
        for (i = 0; i < inXVals.length; ++i) {
            inXVals[i] = curvesCSV.getDouble(0, startCol + i);
        }
        if (outXVals == null) {
            outXVals = inXVals;
        }
        if (buildDists) {
            for (i = 0; i < outXVals.length; ++i) {
                distValues.add(new ArrayList(curvesCSV.getNumRows() - 1));
            }
        }
        Preconditions.checkState((boolean)curves.isEmpty());
        Preconditions.checkState((boolean)weights.isEmpty());
        for (int row = 1; row < curvesCSV.getNumRows(); ++row) {
            double weight = curvesCSV.getDouble(row, 2);
            double[] yVals = new double[inXVals.length];
            for (int i3 = 0; i3 < yVals.length; ++i3) {
                yVals[i3] = curvesCSV.getDouble(row, startCol + i3);
            }
            LightFixedXFunc curve = new LightFixedXFunc(inXVals, yVals);
            if (outXVals != inXVals) {
                double[] interpYVals = new double[outXVals.length];
                double curveMinX = curve.getMinX();
                double curveMaxX = curve.getMaxX();
                for (int j = 0; j < outXVals.length; ++j) {
                    double x = outXVals[j];
                    interpYVals[j] = x < curveMinX ? curve.getY(0) : (x > curveMaxX ? 0.0 : curve.getInterpolatedY_inLogXDomain(x));
                }
                curve = new LightFixedXFunc(outXVals, interpYVals);
            }
            if (buildDists) {
                for (int i4 = 0; i4 < curve.size(); ++i4) {
                    ((List)distValues.get(i4)).add(curve.getY(i4));
                }
            }
            curves.add(curve);
            weights.add(weight);
            if (branches == null) continue;
            Preconditions.checkState((levelsCopy != null ? 1 : 0) != 0);
            ArrayList<LogicTreeNode> nodes = new ArrayList<LogicTreeNode>();
            for (int i5 = 0; i5 < levelsCopy.size(); ++i5) {
                String nodeName = curvesCSV.get(row, i5 + 3);
                LogicTreeLevel level = (LogicTreeLevel)levelsCopy.get(i5);
                LogicTreeNode match = null;
                for (LogicTreeNode node : level.getNodes()) {
                    if (!nodeName.equals(node.getShortName())) continue;
                    Preconditions.checkState((match == null ? 1 : 0) != 0, (String)"Multiple nodes match name %s for level %s", (Object)nodeName, (Object)level.getName());
                    match = node;
                }
                Preconditions.checkNotNull(match, (String)"No match found for %s in level %s", (Object)nodeName, (Object)level.getName());
                nodes.add(match);
            }
            branches.add(new LogicTreeBranch(levelsCopy, nodes));
        }
        if (!buildDists) {
            return null;
        }
        ValueDistribution[] dists = new ValueDistribution[outXVals.length];
        for (int i6 = 0; i6 < dists.length; ++i6) {
            dists[i6] = new ValueDistribution((List)distValues.get(i6), weights);
        }
        return dists;
    }

    private static File curveDistPlot(final File resourcesDir, final String prefix, String siteName, String perLabel, String units, ValueDistribution[] curveDists, double[] xVals, Color color, SolHazardMapCalc.ReturnPeriods[] rps, DiscretizedFunc compMeanCurve, Color compColor, ExecutorService exec, List<Future<?>> plotFutures) throws IOException {
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        DiscretizedFunc meanCurve = SiteLogicTreeHazardPageGen.calcMeanCurve(curveDists, xVals);
        DiscretizedFunc medianCurve = SiteLogicTreeHazardPageGen.calcFractileCurve(curveDists, xVals, 0.5);
        UncertainArbDiscFunc minMax = new UncertainArbDiscFunc(medianCurve, SiteLogicTreeHazardPageGen.calcFractileCurve(curveDists, xVals, 0.0), SiteLogicTreeHazardPageGen.calcFractileCurve(curveDists, xVals, 1.0));
        UncertainArbDiscFunc bounds95 = new UncertainArbDiscFunc(medianCurve, SiteLogicTreeHazardPageGen.calcFractileCurve(curveDists, xVals, 0.025), SiteLogicTreeHazardPageGen.calcFractileCurve(curveDists, xVals, 0.975));
        UncertainArbDiscFunc bounds68 = new UncertainArbDiscFunc(medianCurve, SiteLogicTreeHazardPageGen.calcFractileCurve(curveDists, xVals, 0.16), SiteLogicTreeHazardPageGen.calcFractileCurve(curveDists, xVals, 0.84));
        Color transColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 60);
        meanCurve.setName("Mean");
        funcs.add(meanCurve);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, color.darker().darker()));
        if (compMeanCurve != null) {
            compMeanCurve.setName("Comparison Mean");
            funcs.add(compMeanCurve);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, compColor.darker().darker()));
        }
        medianCurve.setName("Median");
        funcs.add(medianCurve);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, color.darker()));
        minMax.setName("p[0,2.5,16,84,97.5,100]");
        funcs.add(minMax);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, transColor));
        funcs.add(bounds95);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, transColor));
        funcs.add(bounds68);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, transColor));
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine(perLabel + " (" + units + ")", "Mean", "Median", "Min", "p2.5", "p16", "p84", "p97.5", "Max");
        Preconditions.checkState((meanCurve.size() == medianCurve.size() ? 1 : 0) != 0);
        for (int i = 0; i < meanCurve.size(); ++i) {
            csv.addLine("" + meanCurve.getX(i), "" + meanCurve.getY(i), "" + medianCurve.getY(i), "" + minMax.getLowerY(i), "" + bounds95.getLowerY(i), "" + bounds68.getLowerY(i), "" + bounds68.getUpperY(i), "" + bounds95.getUpperY(i), "" + minMax.getUpperY(i));
        }
        csv.writeToFile(new File(resourcesDir, prefix + ".csv"));
        final Range yRange = new Range(1.0E-6, 1.0);
        double minX = Double.POSITIVE_INFINITY;
        double maxX = 0.0;
        for (DiscretizedFunc func : funcs) {
            DiscretizedFunc[] iterFuncs = func instanceof UncertainBoundedDiscretizedFunc ? new DiscretizedFunc[]{func, ((UncertainBoundedDiscretizedFunc)func).getLower(), ((UncertainBoundedDiscretizedFunc)func).getUpper()} : new DiscretizedFunc[]{func};
            for (DiscretizedFunc iterFunc : iterFuncs) {
                for (Point2D pt : iterFunc) {
                    if (!(pt.getX() > 0.01) || !((float)pt.getY() < (float)yRange.getUpperBound()) || !((float)pt.getY() > (float)yRange.getLowerBound())) continue;
                    minX = Math.min(minX, pt.getX());
                    maxX = Math.max(maxX, pt.getX());
                }
            }
        }
        if (minX >= maxX || !Double.isFinite(minX) || !Double.isFinite(maxX)) {
            System.out.println("min=" + minX + ", max=" + maxX + " for " + siteName + " per=" + perLabel);
            System.out.println(meanCurve);
        }
        minX = Math.pow(10.0, Math.floor(Math.log10(minX)));
        maxX = Math.pow(10.0, Math.ceil(Math.log10(maxX)));
        final Range xRange = new Range(minX, maxX);
        List<XYAnnotation> anns = SolSiteHazardCalc.addRPAnnotations(funcs, chars, xRange, yRange, rps, true);
        final PlotSpec spec = new PlotSpec(funcs, chars, siteName, perLabel + " (" + units + ")", "Annual Probability of Exceedance");
        spec.setLegendInset(true);
        spec.setPlotAnnotations(anns);
        plotFutures.add(exec.submit(new Runnable(){

            @Override
            public void run() {
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
                gp.drawGraphPanel(spec, true, true, xRange, yRange);
                try {
                    Stopwatch watch = Stopwatch.createStarted();
                    PlotUtils.writePlots(resourcesDir, prefix, (GraphPanel)gp, 1000, 800, true, true, false);
                    watch.stop();
                    double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                    if (secs > 10.0) {
                        System.out.println("\t\tDONE " + prefix + ".png in " + (float)secs + " s");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }));
        return new File(resourcesDir, prefix + ".png");
    }

    /*
     * WARNING - void declaration
     */
    private static File curveBranchPlot(final File resourcesDir, final String prefix, String siteName, String perLabel, String units, ValueDistribution[] curveDists, double[] xVals, Color color, SolHazardMapCalc.ReturnPeriods[] rps, ValueDistribution[] compCurveDists, Color compColor, List<LogicTreeNode> nodes, final List<List<DiscretizedFunc>> nodeIndvCurves, int downsample, List<DiscretizedFunc> nodeMeanCurves, ExecutorService exec, List<Future<?>> plotFutures) throws IOException {
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        DiscretizedFunc meanCurve = SiteLogicTreeHazardPageGen.calcMeanCurve(curveDists, xVals);
        meanCurve.setName("Mean");
        funcs.add(meanCurve);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, color));
        if (compCurveDists != null) {
            DiscretizedFunc compMeanCurve = SiteLogicTreeHazardPageGen.calcMeanCurve(compCurveDists, xVals);
            compMeanCurve.setName("Comparison Mean");
            funcs.add(compMeanCurve);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, compColor));
        }
        List<Color> nodeColors = SiteLogicTreeHazardPageGen.getNodeColors(nodes.size());
        if (nodeMeanCurves != null) {
            int i;
            for (int i2 = 0; i2 < nodes.size(); ++i2) {
                Color nodeColor = nodeColors.get(i2);
                DiscretizedFunc nodeCurve = nodeMeanCurves.get(i2);
                nodeCurve.setName(nodes.get(i2).getShortName());
                funcs.add(nodeCurve);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, nodeColor));
            }
            CSVFile csv = new CSVFile(true);
            ArrayList header = new ArrayList();
            header.add(perLabel + " (" + units + ")");
            header.add("Mean");
            for (i = 0; i < nodes.size(); ++i) {
                header.add(nodes.get(i).getShortName());
            }
            csv.addLine(header);
            for (i = 0; i < meanCurve.size(); ++i) {
                ArrayList<CallSite> line = new ArrayList<CallSite>(header.size());
                line.add((CallSite)((Object)("" + (float)meanCurve.getX(i))));
                line.add((CallSite)((Object)("" + meanCurve.getY(i))));
                for (DiscretizedFunc discretizedFunc : nodeMeanCurves) {
                    Preconditions.checkState(((float)discretizedFunc.getX(i) == (float)meanCurve.getX(i) ? 1 : 0) != 0);
                    line.add((CallSite)((Object)("" + discretizedFunc.getY(i))));
                }
                csv.addLine(line);
            }
            csv.writeToFile(new File(resourcesDir, prefix + ".csv"));
        }
        if (nodeIndvCurves != null) {
            int totNumCurves = 0;
            for (List<DiscretizedFunc> curves : nodeIndvCurves) {
                totNumCurves += curves.size();
            }
            int plotNumCurves = totNumCurves;
            if (downsample > 0 && downsample < totNumCurves) {
                plotNumCurves = downsample;
            }
            int alpha = plotNumCurves < 50 ? 255 : (plotNumCurves < 100 ? 180 : (plotNumCurves < 500 ? 100 : (plotNumCurves < 1000 ? 60 : (plotNumCurves < 5000 ? 40 : (plotNumCurves < 10000 ? 20 : 10)))));
            ArrayList<CurveChar> allCurveChars = new ArrayList<CurveChar>();
            for (int i = 0; i < nodes.size(); ++i) {
                void var29_50;
                double keepFract;
                int myKept;
                void var26_40;
                Color color2 = nodeColors.get(i);
                ArbitrarilyDiscretizedFunc fakeCurve = new ArbitrarilyDiscretizedFunc();
                fakeCurve.set(0.0, 0.0);
                fakeCurve.set(0.0, 1.0);
                fakeCurve.setName(nodes.get(i).getShortName());
                funcs.add(fakeCurve);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color2));
                if (alpha != 255) {
                    Color color3 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), alpha);
                }
                PlotCurveCharacterstics pChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, (Color)var26_40);
                ArrayList arrayList = new ArrayList(nodeIndvCurves.get(i));
                Collections.shuffle(arrayList, new Random((long)arrayList.size() * 1000L));
                if (downsample > 0 && downsample < totNumCurves && (myKept = (int)((keepFract = (double)downsample / (double)totNumCurves) * (double)arrayList.size() + 0.5)) < arrayList.size()) {
                    List list = arrayList.subList(0, myKept);
                }
                for (DiscretizedFunc nodeCurve : var29_50) {
                    allCurveChars.add(new CurveChar(nodeCurve, pChar));
                }
            }
            if (allCurveChars.size() > 2000) {
                int blockSize = allCurveChars.size() / 1000;
                ArrayList arrayList = new ArrayList();
                ArrayList<CurveChar> curBlock = new ArrayList<CurveChar>(blockSize);
                for (int i = 0; i < allCurveChars.size(); ++i) {
                    if (curBlock.size() == blockSize) {
                        arrayList.add(curBlock);
                        curBlock = new ArrayList(blockSize);
                    }
                    curBlock.add((CurveChar)allCurveChars.get(i));
                }
                arrayList.add(curBlock);
                Collections.shuffle(arrayList, new Random((long)allCurveChars.size() * 1000L * (long)nodes.size()));
                for (List list : arrayList) {
                    for (CurveChar curve : list) {
                        funcs.add(curve.curve);
                        chars.add(curve.pChar);
                    }
                }
            } else {
                Collections.shuffle(allCurveChars, new Random((long)allCurveChars.size() * 1000L * (long)nodes.size()));
                for (CurveChar curveChar : allCurveChars) {
                    funcs.add(curveChar.curve);
                    chars.add(curveChar.pChar);
                }
            }
        }
        final Range yRange = new Range(1.0E-6, 1.0);
        double minX = Double.POSITIVE_INFINITY;
        double maxX = 0.0;
        for (DiscretizedFunc func : funcs) {
            for (Point2D point2D : func) {
                if (!(point2D.getX() > 0.01) || !((float)point2D.getY() < (float)yRange.getUpperBound()) || !((float)point2D.getY() > (float)yRange.getLowerBound())) continue;
                minX = Math.min(minX, point2D.getX());
                maxX = Math.max(maxX, point2D.getX());
            }
        }
        minX = Math.pow(10.0, Math.floor(Math.log10(minX)));
        maxX = Math.pow(10.0, Math.ceil(Math.log10(maxX)));
        final Range range = new Range(minX, maxX);
        List<XYAnnotation> anns = SolSiteHazardCalc.addRPAnnotations(funcs, chars, range, yRange, rps, true);
        final PlotSpec spec = new PlotSpec(funcs, chars, siteName, perLabel + " (" + units + ")", "Annual Probability of Exceedance");
        spec.setLegendInset(true);
        spec.setPlotAnnotations(anns);
        plotFutures.add(exec.submit(new Runnable(){

            @Override
            public void run() {
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
                gp.drawGraphPanel(spec, true, true, range, yRange);
                try {
                    Stopwatch watch = Stopwatch.createStarted();
                    PlotUtils.writePlots(resourcesDir, prefix, (GraphPanel)gp, 1000, 800, true, nodeIndvCurves == null, false);
                    watch.stop();
                    double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                    if (secs > 10.0) {
                        System.out.println("\t\tDONE " + prefix + ".png in " + (float)secs + " s");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }));
        return new File(resourcesDir, prefix + ".png");
    }

    static List<String> buildDistHeader(String firstCol, String units) {
        if (units == null) {
            units = "";
        } else if (!((String)units).isBlank() && !((String)units).startsWith(" ")) {
            units = " " + (String)units;
        }
        ArrayList<String> header = new ArrayList<String>();
        header.add(firstCol);
        header.add("Mean" + (String)units);
        header.add("Std. Dev." + (String)units);
        header.add("COV");
        for (String f : fractileHeaders) {
            header.add(f + (String)units);
        }
        return header;
    }

    private static double[] xVals(DiscretizedFunc curve) {
        double[] ret = new double[curve.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = curve.getX(i);
        }
        return ret;
    }

    private static DiscretizedFunc calcMeanCurve(ValueDistribution[] dists, double[] xVals) {
        Preconditions.checkState((dists.length == xVals.length ? 1 : 0) != 0, (String)"have %s dists but %s xVals", (int)dists.length, (int)xVals.length);
        double[] yVals = new double[xVals.length];
        for (int i = 0; i < dists.length; ++i) {
            yVals[i] = dists[i].mean;
        }
        return new LightFixedXFunc(xVals, yVals);
    }

    private static DiscretizedFunc calcFractileCurve(ValueDistribution[] dists, double[] xVals, double fractile) {
        Preconditions.checkState((dists.length == xVals.length ? 1 : 0) != 0, (String)"have %s dists but %s xVals", (int)dists.length, (int)xVals.length);
        double[] yVals = new double[xVals.length];
        for (int i = 0; i < dists.length; ++i) {
            yVals[i] = dists[i].getInterpolatedFractile(fractile);
        }
        return new LightFixedXFunc(xVals, yVals);
    }

    private static HistogramFunction initHist(List<Double> branchVals) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (double val : branchVals) {
            min = Math.min(val, min);
            max = Math.max(val, max);
        }
        if (min == max) {
            max = min + 0.1;
        }
        double span = max - min;
        int minNumBins = 30;
        double delta = SiteLogicTreeHazardPageGen.getHistDelta(span, minNumBins);
        return HistogramFunction.getEncompassingHistogram(min, max, delta);
    }

    private static double getHistDelta(double span, int numDistBins) {
        Preconditions.checkState((span > 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((span > 0.0 ? 1 : 0) != 0, (Object)"Span must be positive");
        Preconditions.checkArgument((numDistBins > 0 ? 1 : 0) != 0, (Object)"numDistBins must be positive");
        double minDelta = 0.001;
        double targetDelta = span / (double)numDistBins;
        if (targetDelta < minDelta) {
            return minDelta;
        }
        double[] multipliers = new double[]{1.0, 2.0, 5.0};
        double bestDelta = Double.NaN;
        double currentExp = Math.floor(Math.log10(targetDelta)) - 1.0;
        for (int expOffset = 0; expOffset < 20; ++expOffset) {
            double base = Math.pow(10.0, currentExp + (double)expOffset);
            for (double mult : multipliers) {
                double candidate = mult * base;
                if (candidate < minDelta) continue;
                if (candidate > targetDelta) {
                    if (Double.isNaN(bestDelta)) break;
                    return bestDelta;
                }
                bestDelta = candidate;
            }
            if (expOffset != 19 || Double.isNaN(bestDelta)) continue;
            return bestDelta;
        }
        throw new IllegalStateException("No valid 1-2-5 delta found for span=" + span + " and numDistBins=" + numDistBins);
    }

    private static DiscretizedFunc getNodeMeanCurve(List<LogicTreeBranch<?>> branches, List<Double> weights, List<DiscretizedFunc> curves, LogicTreeNode node, List<DiscretizedFunc> nodeCurves) {
        AbstractDiscretizedFunc meanCurve = null;
        double nodeWeight = 0.0;
        for (int i = 0; i < branches.size(); ++i) {
            LogicTreeBranch<?> branch = branches.get(i);
            double weight = weights.get(i);
            if (!branch.hasValue(node)) continue;
            DiscretizedFunc curve = curves.get(i);
            if (meanCurve == null) {
                meanCurve = new LightFixedXFunc(SiteLogicTreeHazardPageGen.xVals(curve), new double[curve.size()]);
            } else {
                Preconditions.checkState((curve.size() == ((LightFixedXFunc)meanCurve).size() ? 1 : 0) != 0);
            }
            nodeCurves.add(curves.get(i));
            nodeWeight += weight;
            for (int j = 0; j < curve.size(); ++j) {
                ((LightFixedXFunc)meanCurve).set(j, ((LightFixedXFunc)meanCurve).getY(j) + weight * curve.getY(j));
            }
        }
        if (nodeCurves.isEmpty()) {
            return null;
        }
        meanCurve.scale(1.0 / nodeWeight);
        return meanCurve;
    }

    private static HistogramFunction buildHist(List<Double> weights, List<Double> branchVals, HistogramFunction refHist) {
        return SiteLogicTreeHazardPageGen.buildHist(null, weights, branchVals, null, refHist);
    }

    private static HistogramFunction buildHist(List<LogicTreeBranch<?>> branches, List<Double> weights, List<Double> branchVals, LogicTreeNode node, HistogramFunction refHist) {
        HistogramFunction hist = new HistogramFunction(refHist.getMinX(), refHist.getMaxX(), refHist.size());
        double totWeight = 0.0;
        int count = 0;
        for (int i = 0; i < branchVals.size(); ++i) {
            LogicTreeBranch<?> branch;
            double weight = weights.get(i);
            totWeight += weight;
            if (node != null && !(branch = branches.get(i)).hasValue(node)) continue;
            ++count;
            hist.add(hist.getClosestXIndex(branchVals.get(i)), weight);
        }
        if (count == 0) {
            return null;
        }
        hist.scale(1.0 / totWeight);
        return hist;
    }

    private static double mean(List<Double> weights, List<Double> vals) {
        return SiteLogicTreeHazardPageGen.mean(null, weights, vals, null);
    }

    private static double mean(List<LogicTreeBranch<?>> branches, List<Double> weights, List<Double> branchVals, LogicTreeNode node) {
        double sumWeight = 0.0;
        double ret = 0.0;
        if (node != null) {
            Preconditions.checkState((branches != null ? 1 : 0) != 0);
        }
        for (int i = 0; i < branchVals.size(); ++i) {
            LogicTreeBranch<?> branch;
            double weight = weights.get(i);
            if (node != null && !(branch = branches.get(i)).hasValue(node)) continue;
            sumWeight += weight;
            ret += branchVals.get(i) * weight;
        }
        return ret / sumWeight;
    }

    public static double curveVal(DiscretizedFunc curve, SolHazardMapCalc.ReturnPeriods rp) {
        double curveLevel = rp.oneYearProb;
        if (curveLevel > curve.getMaxY()) {
            return 0.0;
        }
        if (curveLevel < curve.getMinY()) {
            return curve.getMaxX();
        }
        return curve.getFirstInterpolatedX_inLogXLogYDomain(curveLevel);
    }

    private static File valDistPlot(File resourcesDir, String prefix, String siteName, String label, HistogramFunction hist, double mean, ValueDistribution dist, Color color, String primaryName, HistogramFunction compHist, Double compMean, Color compColor, Color compHistColor, String compName, ExecutorService exec, List<Future<?>> plotFutures) throws IOException {
        return SiteLogicTreeHazardPageGen.valDistPlot(resourcesDir, prefix, siteName, label, hist, mean, dist, color, primaryName, compHist, compMean, compColor, compHistColor, compName, null, null, null, exec, plotFutures);
    }

    private static File valDistPlot(final File resourcesDir, final String prefix, String siteName, String label, HistogramFunction hist, double mean, ValueDistribution dist, Color color, String primaryName, HistogramFunction compHist, Double compMean, Color compColor, Color compHistColor, String compName, List<LogicTreeNode> nodes, List<HistogramFunction> nodeHists, List<Double> nodeMeans, ExecutorService exec, List<Future<?>> plotFutures) throws IOException {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        double maxY = hist.getMaxY() * 1.2;
        if (compHist != null) {
            funcs.add(compHist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, compHistColor));
            maxY = Math.max(maxY, compHist.getMaxY() * 1.2);
            if (compMean != null) {
                funcs.add(SiteLogicTreeHazardPageGen.vertLine(compMean, 0.0, maxY, compName + " Mean"));
                chars.add(new PlotCurveCharacterstics(nodeHists == null ? PlotLineType.SOLID : PlotLineType.DASHED, 4.0f, compColor));
            }
        }
        funcs.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.GRAY));
        if (nodeHists != null) {
            EvenlyDiscretizedFunc sumHist = null;
            ArrayList<HistogramFunction> usedNodeHists = new ArrayList<HistogramFunction>();
            ArrayList<Double> usedNodeMeans = new ArrayList<Double>();
            for (int i = 0; i < nodes.size(); ++i) {
                HistogramFunction nodeSumHist;
                HistogramFunction nodeHist = nodeHists.get(i);
                if (nodeHist == null) continue;
                Preconditions.checkState((nodeHist.size() == hist.size() ? 1 : 0) != 0, (String)"%s != %s", (int)nodeHist.size(), (int)hist.size());
                if (sumHist == null) {
                    nodeSumHist = nodeHist;
                } else {
                    nodeSumHist = new HistogramFunction(hist.getMinX(), hist.getMaxX(), hist.size());
                    for (int j = 0; j < hist.size(); ++j) {
                        nodeSumHist.set(j, sumHist.getY(j) + nodeHist.getY(j));
                    }
                }
                nodeSumHist.setName(nodes.get(i).getShortName());
                usedNodeHists.add(nodeSumHist);
                usedNodeMeans.add(nodeMeans.get(i));
                sumHist = nodeSumHist;
            }
            if (usedNodeHists.size() > 1) {
                int i;
                maxY *= 1.1;
                List<Color> colors = SiteLogicTreeHazardPageGen.getNodeColors(usedNodeHists.size());
                for (i = 0; i < usedNodeHists.size(); ++i) {
                    funcs.add((XY_DataSet)usedNodeHists.get(i));
                    chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, colors.get(i)));
                }
                for (i = 0; i < usedNodeHists.size(); ++i) {
                    funcs.add(SiteLogicTreeHazardPageGen.vertLine((Double)usedNodeMeans.get(i), 0.0, maxY, null));
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, colors.get(i)));
                }
                i = usedNodeHists.size();
                while (--i >= 0) {
                    EvenlyDiscretizedFunc copy = ((HistogramFunction)usedNodeHists.get(i)).deepClone();
                    copy.setName(null);
                    funcs.add(copy);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, colors.get(i)));
                }
            }
        }
        if (compMean != null) {
            String lineLabel = compHist == null ? compName + " Mean" : null;
            funcs.add(SiteLogicTreeHazardPageGen.vertLine(compMean, 0.0, maxY, lineLabel));
            chars.add(new PlotCurveCharacterstics(nodeHists == null ? PlotLineType.SOLID : PlotLineType.DASHED, 4.0f, compColor.darker()));
        }
        funcs.add(SiteLogicTreeHazardPageGen.vertLine(mean, 0.0, maxY, (String)(primaryName != null && !primaryName.isBlank() ? primaryName + " " : "") + "Mean"));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 5.0f, color.darker().darker()));
        if (dist != null && dist.size > 1) {
            funcs.add(SiteLogicTreeHazardPageGen.vertLine(dist.getInterpolatedFractile(0.025), 0.0, maxY, "p[2.5, 16, 50, 84, 97.5]"));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
            funcs.add(SiteLogicTreeHazardPageGen.vertLine(dist.getInterpolatedFractile(0.16), 0.0, maxY, null));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
            funcs.add(SiteLogicTreeHazardPageGen.vertLine(dist.getInterpolatedFractile(0.5), 0.0, maxY, null));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
            funcs.add(SiteLogicTreeHazardPageGen.vertLine(dist.getInterpolatedFractile(0.84), 0.0, maxY, null));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
            funcs.add(SiteLogicTreeHazardPageGen.vertLine(dist.getInterpolatedFractile(0.975), 0.0, maxY, null));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, color));
        }
        final Range xRange = new Range(hist.getMinX() - 0.5 * hist.getDelta(), hist.getMaxX() + 0.5 * hist.getDelta());
        final Range yRange = new Range(0.0, maxY);
        final PlotSpec spec = new PlotSpec(funcs, chars, siteName, label, "Fraction");
        spec.setLegendInset(true);
        plotFutures.add(exec.submit(new Runnable(){

            @Override
            public void run() {
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.drawGraphPanel(spec, false, false, xRange, yRange);
                try {
                    Stopwatch watch = Stopwatch.createStarted();
                    PlotUtils.writePlots(resourcesDir, prefix, (GraphPanel)gp, 800, 700, true, true, false);
                    watch.stop();
                    double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                    if (secs > 10.0) {
                        System.out.println("\t\tDONE " + prefix + ".png in " + (float)secs + " s");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }));
        return new File(resourcesDir, prefix + ".png");
    }

    public static List<Color> getNodeColors(int numNodes) throws IOException {
        CPT cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, Double.max((double)numNodes - 1.0, 1.0));
        ArrayList<Color> colors = new ArrayList<Color>();
        for (int i = 0; i < numNodes; ++i) {
            colors.add(cpt.getColor(i));
        }
        return colors;
    }

    private static XY_DataSet vertLine(double x, double y0, double y1, String name) {
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        xy.set(x, y0);
        xy.set(x, y1);
        xy.setName(name);
        return xy;
    }

    static {
        for (int f = 0; f < fractiles.length; ++f) {
            SiteLogicTreeHazardPageGen.fractileHeaders[f] = fractiles[f] == 0.5 ? "Median" : (fractiles[f] == 0.0 ? "Minimum" : (fractiles[f] == 1.0 ? "Maximum" : "p" + (float)(fractiles[f] * 100.0)));
        }
    }

    static class ValueDistribution {
        public final double mean;
        public final double min;
        public final double max;
        public final int size;
        public final double stdDev;
        public final LightFixedXFunc normCDF;
        public final boolean allZero;

        public ValueDistribution(List<Double> values, List<Double> weights) {
            Preconditions.checkState((values.size() == weights.size() ? 1 : 0) != 0);
            Preconditions.checkState((values.size() >= 1 ? 1 : 0) != 0);
            this.size = values.size();
            if (this.size == 1) {
                this.min = this.mean = values.get(0).doubleValue();
                this.max = this.mean;
                this.stdDev = Double.NaN;
                this.normCDF = null;
                this.allZero = this.mean == 0.0;
            } else {
                double weightedMean = 0.0;
                double sumOrigWeights = 0.0;
                boolean allZero = true;
                double min = Double.POSITIVE_INFINITY;
                double max = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < values.size(); ++i) {
                    double val = values.get(i);
                    min = Math.min(min, val);
                    max = Math.max(max, val);
                    allZero &= val == 0.0;
                    double weight = weights.get(i);
                    weightedMean += val * weight;
                    sumOrigWeights += weight;
                }
                this.mean = weightedMean /= sumOrigWeights;
                this.min = min;
                this.max = max;
                double[] valsArray = Doubles.toArray(values);
                double[] weightsArray = MathArrays.normalizeArray((double[])Doubles.toArray(weights), (double)weights.size());
                double var = new Variance(false).evaluate(valsArray, weightsArray, weightedMean);
                this.stdDev = Math.sqrt(var);
                this.normCDF = ArbDiscrEmpiricalDistFunc.calcQuickNormCDF(valsArray, weightsArray);
                this.allZero = allZero;
            }
        }

        public double getInterpolatedFractile(double fractile) {
            if (this.allZero) {
                return 0.0;
            }
            return ArbDiscrEmpiricalDistFunc.calcFractileFromNormCDF(this.normCDF, fractile);
        }

        public List<String> buildLine(String firstCol) {
            ArrayList<String> line = new ArrayList<String>(fractiles.length + 4);
            line.add(firstCol);
            line.add("" + (float)this.mean);
            if (this.size > 1) {
                line.add("" + (float)this.stdDev);
                line.add("" + (float)(this.stdDev / this.mean));
                for (double fractile : fractiles) {
                    line.add("" + (float)this.getInterpolatedFractile(fractile));
                }
            } else {
                for (int i = 0; i < fractiles.length + 2; ++i) {
                    line.add("");
                }
            }
            return line;
        }
    }

    private static class CurveChar {
        final DiscretizedFunc curve;
        final PlotCurveCharacterstics pChar;

        public CurveChar(DiscretizedFunc curve, PlotCurveCharacterstics pChar) {
            this.curve = curve;
            this.pChar = pChar;
        }
    }
}

