/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.hazard.mpj;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import mpi.MPI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.xyz.AbstractXYZ_DataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.sha.calc.params.filters.SourceFilterManager;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.erf.BaseFaultSystemSolutionERF;
import org.opensha.sha.earthquake.faultSysSolution.hazard.QuickGriddedHazardMapCalc;
import org.opensha.sha.earthquake.faultSysSolution.hazard.mpj.MPJ_LogicTreeHazardCalc;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysHazardCalcSettings;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.imr.AttenRelSupplier;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.TectonicRegionType;

public class MPJ_SingleSolHazardCalc
extends MPJTaskCalculator {
    private File outputDir;
    private LogicTree<?> tree;
    private FaultSystemSolution singleSol;
    private double gridSpacing = 0.1;
    private Map<TectonicRegionType, AttenRelSupplier> gmmRefs;
    private double[] periods = MPJ_LogicTreeHazardCalc.PERIODS_DEFAULT;
    private SolHazardMapCalc.ReturnPeriods[] rps = SolHazardMapCalc.MAP_RPS;
    private IncludeBackgroundOption gridSeisOp = MPJ_LogicTreeHazardCalc.GRID_SEIS_DEFAULT;
    private GriddedSeismicitySettings griddedSettings;
    private boolean applyAftershockFilter = false;
    private boolean aseisReducesArea = true;
    private SourceFilterManager sourceFilter;
    private SourceFilterManager siteSkipSourceFilter;
    private GriddedRegion gridRegion;
    private File combineWithOtherDir;
    private String hazardSubDirName;
    private String combineWithHazardExcludingSubDirName;
    private String combineWithHazardBGOnlySubDirName;
    private File nodesCurveDir;
    private File outputFile;
    private GridSourceProvider externalGridProv;
    private SolHazardMapCalc externalGriddedCurveCalc;
    private QuickGriddedHazardMapCalc[] quickGridCalcs;
    private ExecutorService quickGridExec;
    private boolean noMFDs;
    private boolean noProxyRups;
    private SolHazardMapCalc combineWithExcludeCurves = null;
    private SolHazardMapCalc combineWithOnlyCurves = null;
    private SolHazardMapCalc combineWithCurves = null;
    private SolHazardMapCalc calc = null;
    private boolean externalDone = false;
    private BaseFaultSystemSolutionERF erf;

    public MPJ_SingleSolHazardCalc(CommandLine cmd) throws IOException {
        super(cmd);
        ZipFile zip;
        LogicTreeBranch<?> branch;
        SolutionLogicTree solTree;
        this.shuffle = true;
        File inputFile = new File(cmd.getOptionValue("input-file"));
        Preconditions.checkState((boolean)inputFile.exists());
        if (inputFile.isDirectory()) {
            Preconditions.checkArgument((boolean)cmd.hasOption("logic-tree"), (Object)"Must supply logic tree file if input-file is a results directory");
            File logicTreeFile = new File(cmd.getOptionValue("logic-tree"));
            Preconditions.checkArgument((boolean)logicTreeFile.exists(), (String)"Logic tree file doesn't exist: %s", (Object)logicTreeFile.getAbsolutePath());
            this.tree = LogicTree.read(logicTreeFile);
            solTree = new SolutionLogicTree.ResultsDirReader(inputFile, this.tree);
            Preconditions.checkArgument((solTree.getLogicTree().size() == 1 ? 1 : 0) != 0, (Object)"Must only have one solution with this calculator");
            branch = solTree.getLogicTree().getBranch(0);
            this.singleSol = solTree.forBranch(branch);
            this.singleSol.addModule(branch);
        } else {
            ZipFile zip2 = new ZipFile(inputFile);
            if (FaultSystemSolution.isSolution(zip2)) {
                this.singleSol = FaultSystemSolution.load(zip2);
            } else {
                solTree = SolutionLogicTree.load(inputFile);
                this.tree = solTree.getLogicTree();
                Preconditions.checkArgument((this.tree.size() == 1 ? 1 : 0) != 0, (Object)"Must only have one solution with this calculator");
                branch = solTree.getLogicTree().getBranch(0);
                this.singleSol = solTree.forBranch(branch);
                this.singleSol.addModule(branch);
            }
        }
        this.outputDir = new File(cmd.getOptionValue("output-dir"));
        if (cmd.hasOption("gridded-seis")) {
            this.gridSeisOp = IncludeBackgroundOption.valueOf(cmd.getOptionValue("gridded-seis"));
        }
        this.griddedSettings = FaultSysHazardCalcSettings.getGridSeisSettings(cmd);
        if (this.gridSeisOp != IncludeBackgroundOption.EXCLUDE) {
            this.debug("Gridded settings: " + String.valueOf(this.griddedSettings));
        }
        if (cmd.hasOption("grid-spacing")) {
            this.gridSpacing = Double.parseDouble(cmd.getOptionValue("grid-spacing"));
        }
        this.sourceFilter = FaultSysHazardCalcSettings.getSourceFilters(cmd);
        this.siteSkipSourceFilter = FaultSysHazardCalcSettings.getSiteSkipSourceFilters(this.sourceFilter, cmd);
        this.gmmRefs = FaultSysHazardCalcSettings.getGMMs(cmd);
        if (this.rank == 0) {
            this.debug("GMMs:");
            for (TectonicRegionType trt : this.gmmRefs.keySet()) {
                this.debug("\tGMM for " + trt.name() + ": " + this.gmmRefs.get(trt).getName());
            }
        }
        if (cmd.hasOption("periods")) {
            ArrayList<Double> periodsList = new ArrayList<Double>();
            String periodsStr = cmd.getOptionValue("periods");
            if (periodsStr.contains(",")) {
                String[] split;
                for (String str : split = periodsStr.split(",")) {
                    periodsList.add(Double.parseDouble(str));
                }
            } else {
                periodsList.add(Double.parseDouble(periodsStr));
            }
            this.periods = Doubles.toArray(periodsList);
        }
        if (cmd.hasOption("region")) {
            Region region;
            File regFile = new File(cmd.getOptionValue("region"));
            Preconditions.checkState((boolean)regFile.exists(), (String)"Supplied region file doesn't exist: %s", (Object)regFile.getAbsolutePath());
            if (regFile.getName().toLowerCase().endsWith(".zip")) {
                zip = new ZipFile(regFile);
                ZipEntry regEntry = zip.getEntry("gridded_region.geojson");
                if (this.rank == 0) {
                    this.debug("Reading gridded region from zip file: " + regEntry.getName());
                }
                BufferedReader bRead = new BufferedReader(new InputStreamReader(zip.getInputStream(regEntry)));
                region = GriddedRegion.fromFeature(Feature.read(bRead));
                zip.close();
            } else {
                Feature feature = Feature.read(regFile);
                region = Region.fromFeature(feature);
            }
            if (region instanceof GriddedRegion) {
                this.gridRegion = (GriddedRegion)region;
                Preconditions.checkState((!cmd.hasOption("grid-spacing") || (float)this.gridSpacing == (float)this.gridRegion.getSpacing() ? 1 : 0) != 0, (Object)"Supplied a gridded region via the command line, cannont also specify grid spacing.");
                this.gridSpacing = this.gridRegion.getSpacing();
            } else {
                this.gridRegion = new GriddedRegion(region, this.gridSpacing, GriddedRegion.ANCHOR_0_0);
            }
        } else {
            this.gridRegion = this.detectRegion(this.singleSol);
        }
        if (cmd.hasOption("aftershock-filter")) {
            this.applyAftershockFilter = true;
        }
        if (cmd.hasOption("aseis-reduces-area") || cmd.hasOption("no-aseis-reduces-area")) {
            Preconditions.checkState((!cmd.hasOption("aseis-reduces-area") || !cmd.hasOption("no-aseis-reduces-area") ? 1 : 0) != 0, (Object)"Can't both enable and disable aseismicity area reductions!");
            this.aseisReducesArea = cmd.hasOption("aseis-reduces-area");
        }
        String hazardPrefix = "hazard_" + (float)this.gridSpacing + "deg";
        if (this.applyAftershockFilter) {
            hazardPrefix = hazardPrefix + "_aftershock_filter";
        }
        hazardPrefix = hazardPrefix + "_grid_seis_";
        this.hazardSubDirName = hazardPrefix + this.gridSeisOp.name();
        if (cmd.hasOption("external-grid-prov")) {
            File gpFile = new File(cmd.getOptionValue("external-grid-prov"));
            Preconditions.checkState((boolean)gpFile.exists());
            zip = new ZipFile(gpFile);
            if (FaultSystemSolution.isSolution(zip)) {
                this.externalGridProv = FaultSystemSolution.load(zip).requireModule(GridSourceProvider.class);
            } else {
                ModuleArchive avgArchive = new ModuleArchive(zip);
                this.externalGridProv = avgArchive.requireModule(GridSourceProvider.class);
            }
            Preconditions.checkArgument((this.gridSeisOp != IncludeBackgroundOption.EXCLUDE ? 1 : 0) != 0, (Object)"External grid provider was supplied, but background seismicity is disabled?");
            zip.close();
        }
        if (this.gridSeisOp != IncludeBackgroundOption.EXCLUDE) {
            this.combineWithHazardExcludingSubDirName = hazardPrefix + IncludeBackgroundOption.EXCLUDE.name();
            this.combineWithHazardBGOnlySubDirName = hazardPrefix + IncludeBackgroundOption.ONLY.name();
        }
        if (cmd.hasOption("combine-with-dir")) {
            this.combineWithOtherDir = new File(cmd.getOptionValue("combine-with-dir"));
            if (!this.combineWithOtherDir.exists()) {
                this.combineWithOtherDir = null;
            }
        }
        if (cmd.hasOption("quick-grid-calc") && (this.gridSeisOp == IncludeBackgroundOption.INCLUDE || this.gridSeisOp == IncludeBackgroundOption.ONLY)) {
            this.quickGridCalcs = new QuickGriddedHazardMapCalc[this.periods.length];
            for (int p = 0; p < this.quickGridCalcs.length; ++p) {
                this.quickGridCalcs[p] = new QuickGriddedHazardMapCalc(this.gmmRefs, this.periods[p], FaultSysHazardCalcSettings.getDefaultXVals(this.periods[p]), this.sourceFilter, this.griddedSettings);
            }
        }
        this.noMFDs = cmd.hasOption("no-mfds");
        this.noProxyRups = cmd.hasOption("no-proxy-ruptures");
        if (this.rank == 0) {
            MPJ_LogicTreeHazardCalc.waitOnDir(this.outputDir, 5, 1000L);
            this.outputFile = cmd.hasOption("output-file") ? new File(cmd.getOptionValue("output-file")) : new File(this.outputDir.getParentFile(), "results_hazard.zip");
            File simDir = this.getSolDir(this.singleSol.getModule(LogicTreeBranch.class));
            MPJ_LogicTreeHazardCalc.waitOnDir(simDir, 5, 1000L);
            File hazardSubDir = new File(simDir, this.hazardSubDirName);
            MPJ_LogicTreeHazardCalc.waitOnDir(hazardSubDir, 5, 1000L);
        }
        this.nodesCurveDir = new File(this.outputDir, "node_hazard_curves_" + this.gridSeisOp.name());
        if (this.rank == 0 && !SINGLE_NODE_NO_MPJ) {
            if (this.nodesCurveDir.exists()) {
                for (File file : this.nodesCurveDir.listFiles()) {
                    Preconditions.checkState((boolean)FileUtils.deleteRecursive(file));
                }
            } else {
                Preconditions.checkState((this.nodesCurveDir.mkdir() || this.nodesCurveDir.exists() ? 1 : 0) != 0);
            }
        }
    }

    protected void doFinalAssembly() throws Exception {
        if (!SINGLE_NODE_NO_MPJ) {
            String prefix = "node_" + this.rank + "_curves";
            if (this.calc != null) {
                this.debug("Writing curves CSVs");
                this.calc.writeCurvesCSVs(this.nodesCurveDir, prefix, false, true);
                this.debug("DONE writing CSVs");
            } else {
                for (double period : this.periods) {
                    String fileName = SolHazardMapCalc.getCSV_FileName(prefix, period);
                    File outputFile = new File(this.nodesCurveDir, fileName);
                    CSVFile csv = new CSVFile(true);
                    ArrayList<String> header = new ArrayList<String>();
                    header.add("Index");
                    header.add("Latitude");
                    header.add("Longitude");
                    csv.addLine(header);
                    csv.writeToFile(outputFile);
                }
            }
        }
        if (!SINGLE_NODE_NO_MPJ) {
            MPI.COMM_WORLD.Barrier();
        }
        if (this.rank == 0) {
            int p;
            ArrayList<DiscretizedFunc[]> curvesList = new ArrayList<DiscretizedFunc[]>(this.periods.length);
            for (p = 0; p < this.periods.length; ++p) {
                curvesList.add(new DiscretizedFunc[this.gridRegion.getNodeCount()]);
            }
            this.debug("Reading node curves");
            for (int rank = 0; rank < this.size; ++rank) {
                ArrayList<DiscretizedFunc[]> nodeCurves;
                if (rank == 0 && this.calc != null) {
                    nodeCurves = new ArrayList<DiscretizedFunc[]>();
                    for (double period : this.periods) {
                        nodeCurves.add(this.calc.getCurves(period));
                    }
                } else {
                    nodeCurves = null;
                    boolean anyEmpty = false;
                    boolean allEmpty = true;
                    for (int p2 = 0; p2 < this.periods.length; ++p2) {
                        File curvesFile = new File(this.nodesCurveDir, SolHazardMapCalc.getCSV_FileName("node_" + rank + "_curves", this.periods[p2]));
                        if (curvesFile.exists()) {
                            if (p2 == 0) {
                                nodeCurves = new ArrayList(this.periods.length);
                            } else {
                                Preconditions.checkNotNull(nodeCurves, (String)"Have curves for p=%s rank=%s, but not an earlier period", (Object)this.periods[p2], (int)rank);
                            }
                            CSVFile<String> csv = CSVFile.readFile(curvesFile, true);
                            if (csv.getNumRows() == 1) {
                                anyEmpty = true;
                                continue;
                            }
                            allEmpty = false;
                            nodeCurves.add(SolHazardMapCalc.loadCurvesCSV(csv, this.gridRegion, true));
                            continue;
                        }
                        Preconditions.checkState((curvesFile == null ? 1 : 0) != 0, (String)"Don't have curves for p=%s rank=%s, but did for an earlier period", (Object)this.periods[p2], (int)rank);
                    }
                    if (anyEmpty) {
                        Preconditions.checkState((boolean)allEmpty);
                        nodeCurves = null;
                    }
                }
                if (nodeCurves == null) continue;
                for (int p3 = 0; p3 < this.periods.length; ++p3) {
                    DiscretizedFunc[] curves = (DiscretizedFunc[])curvesList.get(p3);
                    DiscretizedFunc[] node = (DiscretizedFunc[])nodeCurves.get(p3);
                    Preconditions.checkState((node.length == curves.length ? 1 : 0) != 0);
                    for (int i = 0; i < node.length; ++i) {
                        if (node[i] == null) continue;
                        Preconditions.checkState((curves[i] == null ? 1 : 0) != 0, (String)"Duplicate curve for p=%s index=%s", (Object)this.periods[p3], (int)i);
                        curves[i] = node[i];
                    }
                }
            }
            for (p = 0; p < this.periods.length; ++p) {
                DiscretizedFunc[] curves = (DiscretizedFunc[])curvesList.get(p);
                for (int i = 0; i < curves.length; ++i) {
                    Preconditions.checkNotNull((Object)curves[i], (String)"Missing curves for p=%s and index=%s", (Object)this.periods[p], (int)i);
                }
            }
            this.calc = SolHazardMapCalc.forCurves(this.singleSol, this.gridRegion, this.periods, curvesList);
            File runDir = this.getSolDir(this.singleSol.getModule(LogicTreeBranch.class));
            File hazardSubDir = new File(runDir, this.hazardSubDirName);
            Preconditions.checkState((hazardSubDir.exists() || hazardSubDir.mkdir() ? 1 : 0) != 0);
            this.calc.writeCurvesCSVs(hazardSubDir, "curves", true);
            File workingFile = new File(this.outputFile.getAbsolutePath() + ".tmp");
            ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(workingFile)));
            Feature feature = this.gridRegion.toFeature();
            ZipEntry entry = new ZipEntry("gridded_region.geojson");
            zout.putNextEntry(entry);
            BufferedOutputStream out = new BufferedOutputStream(zout);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            Feature.write(feature, writer);
            out.flush();
            zout.closeEntry();
            if (this.tree != null) {
                entry = new ZipEntry("logic_tree.json");
                zout.putNextEntry(entry);
                Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LogicTree.class, new LogicTree.Adapter()).create();
                gson.toJson(this.tree, LogicTree.class, (Appendable)writer);
                writer.flush();
                zout.flush();
                zout.closeEntry();
            }
            if (this.tree != null) {
                zout.putNextEntry(new ZipEntry(runDir.getName() + "/"));
                zout.closeEntry();
                zout.flush();
            }
            for (SolHazardMapCalc.ReturnPeriods rp : this.rps) {
                for (double period : this.periods) {
                    GriddedGeoDataSet map = this.calc.buildMap(period, rp);
                    String prefix = MPJ_LogicTreeHazardCalc.mapPrefix(period, rp);
                    File mapFile = new File(hazardSubDir, prefix + ".txt");
                    AbstractXYZ_DataSet.writeXYZFile((XYZ_DataSet)map, mapFile);
                    ZipEntry mapEntry = this.tree == null ? new ZipEntry(mapFile.getName()) : new ZipEntry(runDir.getName() + "/" + mapFile.getName());
                    this.debug("Async: zipping " + mapEntry.getName());
                    zout.putNextEntry(mapEntry);
                    AbstractXYZ_DataSet.writeXYZStream(map, zout);
                    zout.flush();
                    zout.closeEntry();
                }
            }
            zout.close();
            Files.move((File)workingFile, (File)this.outputFile);
        }
    }

    protected int getNumTasks() {
        return this.gridRegion.getNodeCount();
    }

    protected File getSolDir(LogicTreeBranch<?> branch) {
        return this.getSolDir(this.outputDir, branch);
    }

    private File getSolDir(File outputDir, LogicTreeBranch<?> branch) {
        if (this.tree == null) {
            return outputDir;
        }
        Preconditions.checkNotNull(branch, (Object)"We have a tree but branch is null?");
        return branch.getBranchDirectory(outputDir, true);
    }

    private GriddedRegion detectRegion(FaultSystemSolution sol) {
        Region region = ReportMetadata.detectRegion(sol);
        return new GriddedRegion(region, this.gridSpacing, GriddedRegion.ANCHOR_0_0);
    }

    private boolean existsAndHazCurves(File dir, String prefix) {
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        for (double period : this.periods) {
            File curvesFile = new File(dir, SolHazardMapCalc.getCSV_FileName(prefix, period));
            if (!curvesFile.exists()) {
                curvesFile = new File(curvesFile.getAbsolutePath() + ".gz");
            }
            if (curvesFile.exists()) continue;
            return false;
        }
        return true;
    }

    protected void calculateBatch(int[] batch) throws Exception {
        if (this.externalDone) {
            return;
        }
        Preconditions.checkState((batch.length > 0 ? 1 : 0) != 0);
        List calcIndexes = Ints.asList((int[])batch);
        LogicTreeBranch branch = this.singleSol.getModule(LogicTreeBranch.class);
        File runDir = this.getSolDir(branch);
        File hazardSubDir = new File(runDir, this.hazardSubDirName);
        Preconditions.checkState((boolean)hazardSubDir.exists());
        String curvesPrefix = "curves";
        if (this.calc == null) {
            File tmp;
            File combineFromRunDir = runDir;
            if (this.combineWithOtherDir != null && (tmp = this.getSolDir(this.combineWithOtherDir, branch)).exists()) {
                combineFromRunDir = tmp;
            }
            if (this.gridSeisOp != IncludeBackgroundOption.EXCLUDE) {
                File combineWithSubDir;
                if (this.gridSeisOp != IncludeBackgroundOption.ONLY && this.combineWithExcludeCurves == null && this.existsAndHazCurves(combineWithSubDir = new File(combineFromRunDir, this.combineWithHazardExcludingSubDirName), curvesPrefix)) {
                    this.debug("Seeing if we can reuse existing curves excluding gridded seismicity from " + combineWithSubDir.getAbsolutePath());
                    try {
                        this.combineWithExcludeCurves = SolHazardMapCalc.loadCurves(this.singleSol, this.gridRegion, this.periods, combineWithSubDir, curvesPrefix);
                    }
                    catch (Exception e) {
                        this.debug("Can't reuse: " + e.getMessage());
                    }
                }
                if (this.existsAndHazCurves(combineWithSubDir = new File(combineFromRunDir, this.combineWithHazardBGOnlySubDirName), curvesPrefix) && this.combineWithOnlyCurves == null) {
                    this.debug("Seeing if we can reuse existing curves with only gridded seismicity from " + combineWithSubDir.getAbsolutePath());
                    try {
                        this.combineWithOnlyCurves = SolHazardMapCalc.loadCurves(this.singleSol, this.gridRegion, this.periods, combineWithSubDir, curvesPrefix);
                    }
                    catch (Exception e) {
                        this.debug("Can't reuse: " + e.getMessage());
                    }
                }
            }
            if (this.combineWithOnlyCurves == null && this.externalGridProv != null) {
                if (this.externalGriddedCurveCalc == null) {
                    this.debug("Calculating external grid source provider curves (will only do this once)");
                    FaultSystemSolution extSol = new FaultSystemSolution(this.singleSol.getRupSet(), this.singleSol.getRateForAllRups());
                    extSol.setGridSourceProvider(this.externalGridProv);
                    this.externalGriddedCurveCalc = new SolHazardMapCalc(extSol, this.gmmRefs, this.gridRegion, IncludeBackgroundOption.ONLY, this.applyAftershockFilter, this.periods);
                    this.externalGriddedCurveCalc.setSourceFilter(this.sourceFilter);
                    this.externalGriddedCurveCalc.setSiteSkipSourceFilter(this.siteSkipSourceFilter);
                    this.externalGriddedCurveCalc.setGriddedSeismicitySettings(this.griddedSettings);
                    this.externalGriddedCurveCalc.setCacheGridSources(true);
                    this.externalGriddedCurveCalc.calcHazardCurves(this.getNumThreads());
                }
                this.combineWithOnlyCurves = this.externalGriddedCurveCalc;
            }
            if (this.quickGridCalcs != null && this.combineWithOnlyCurves == null) {
                this.debug("Doing quick gridded seismicity calc");
                ArrayList<DiscretizedFunc[]> curves = new ArrayList<DiscretizedFunc[]>();
                if (this.quickGridExec == null) {
                    this.quickGridExec = Executors.newFixedThreadPool(this.getNumThreads());
                }
                for (int p = 0; p < this.periods.length; ++p) {
                    curves.add(this.quickGridCalcs[p].calc(this.singleSol.getGridSourceProvider(), this.gridRegion, this.quickGridExec, this.getNumThreads()));
                }
                this.combineWithOnlyCurves = SolHazardMapCalc.forCurves(this.singleSol, this.gridRegion, this.periods, curves);
            }
            if (this.gridSeisOp == IncludeBackgroundOption.INCLUDE && this.combineWithOnlyCurves != null && this.combineWithExcludeCurves != null) {
                ArrayList<DiscretizedFunc[]> combCurvesList = new ArrayList<DiscretizedFunc[]>();
                for (double period : this.periods) {
                    DiscretizedFunc[] excludeCurves = this.combineWithExcludeCurves.getCurves(period);
                    DiscretizedFunc[] onlyCurves = this.combineWithOnlyCurves.getCurves(period);
                    Preconditions.checkState((excludeCurves.length == this.gridRegion.getNodeCount() ? 1 : 0) != 0);
                    Preconditions.checkState((excludeCurves.length == onlyCurves.length ? 1 : 0) != 0);
                    DiscretizedFunc[] combCurves = new DiscretizedFunc[excludeCurves.length];
                    for (int i = 0; i < combCurves.length; ++i) {
                        DiscretizedFunc combCurve;
                        DiscretizedFunc curve1 = excludeCurves[i];
                        DiscretizedFunc curve2 = onlyCurves[i];
                        if (curve1 == null && curve2 == null) {
                            combCurve = null;
                        } else if (curve1 == null) {
                            combCurve = curve2;
                        } else if (curve2 == null) {
                            combCurve = curve1;
                        } else {
                            combCurve = curve1.deepClone();
                            SolHazardMapCalc.combineIn(combCurve, curve2);
                        }
                        combCurves[i] = combCurve;
                    }
                    combCurvesList.add(combCurves);
                }
                this.calc = SolHazardMapCalc.forCurves(this.singleSol, this.gridRegion, this.periods, combCurvesList);
                this.externalDone = true;
                return;
            }
            if (this.calc == null && this.gridSeisOp == IncludeBackgroundOption.ONLY && this.combineWithOnlyCurves != null) {
                this.calc = this.combineWithOnlyCurves;
                this.externalDone = true;
                return;
            }
        }
        if (this.calc == null) {
            Map<TectonicRegionType, AttenRelSupplier> gmpeSuppliers = FaultSysHazardCalcSettings.getGMM_Suppliers(branch, this.gmmRefs, true);
            if (gmpeSuppliers.size() == 1) {
                ScalarIMR gmpe = (ScalarIMR)((Supplier)gmpeSuppliers.values().iterator().next()).get();
                String gmpeParamsStr = "GMPE: " + gmpe.getName();
                for (Parameter<?> param : gmpe.getOtherParams()) {
                    gmpeParamsStr = gmpeParamsStr + "; " + param.getName() + ": " + String.valueOf(param.getValue());
                }
                this.debug(gmpeParamsStr);
            }
            if (this.combineWithExcludeCurves == null && this.combineWithOnlyCurves == null) {
                this.calc = new SolHazardMapCalc(this.singleSol, gmpeSuppliers, this.gridRegion, this.gridSeisOp, this.applyAftershockFilter, this.periods);
            } else if (this.combineWithExcludeCurves != null) {
                this.debug("Reusing fault-based hazard for " + batch.length + " sites, will only compute gridded hazard");
                this.combineWithCurves = this.combineWithExcludeCurves;
                this.calc = new SolHazardMapCalc(this.singleSol, gmpeSuppliers, this.gridRegion, IncludeBackgroundOption.ONLY, this.applyAftershockFilter, this.periods);
            } else if (this.combineWithOnlyCurves != null) {
                this.debug("Reusing fault-based hazard for " + batch.length + " sites, will only compute gridded hazard");
                this.combineWithCurves = this.combineWithOnlyCurves;
                this.calc = new SolHazardMapCalc(this.singleSol, gmpeSuppliers, this.gridRegion, IncludeBackgroundOption.EXCLUDE, this.applyAftershockFilter, this.periods);
            }
            this.calc.setSourceFilter(this.sourceFilter);
            this.calc.setSiteSkipSourceFilter(this.siteSkipSourceFilter);
            this.calc.setAseisReducesArea(this.aseisReducesArea);
            this.calc.setNoMFDs(this.noMFDs);
            this.calc.setUseProxyRups(!this.noProxyRups);
            this.calc.setGriddedSeismicitySettings(this.griddedSettings);
            this.calc.setCacheGridSources(true);
            if (this.erf != null) {
                this.calc.setERF(this.erf);
            }
        }
        this.debug("Calculating hazard curves for " + batch.length + " sites, bgOption=" + this.gridSeisOp.name() + ", combineExclude=" + (this.combineWithExcludeCurves != null) + ", combineOnly=" + (this.combineWithOnlyCurves != null) + "\n\tBranch: " + String.valueOf(branch));
        this.calc.calcHazardCurves(this.getNumThreads(), calcIndexes, this.combineWithCurves);
        this.erf = this.calc.getERF();
    }

    public static Options createOptions() {
        Options ops = MPJTaskCalculator.createOptions();
        FaultSysHazardCalcSettings.addCommonOptions(ops, true);
        ops.addRequiredOption("if", "input-file", true, "Path to input file (solution logic tree zip)");
        ops.addOption("lt", "logic-tree", true, "Path to logic tree JSON file, required if a results directory is supplied with --input-file");
        ops.addRequiredOption("od", "output-dir", true, "Path to output directory");
        ops.addOption("of", "output-file", true, "Path to output zip file. Default will be based on the output directory");
        ops.addOption("sp", "grid-spacing", true, "Grid spacing in decimal degrees. Default: 0.1");
        ops.addOption("gs", "gridded-seis", true, "Gridded seismicity option. One of " + FaultSysTools.enumOptions(IncludeBackgroundOption.class) + ". Default: " + MPJ_LogicTreeHazardCalc.GRID_SEIS_DEFAULT.name());
        ops.addOption("r", "region", true, "Optional path to GeoJSON file containing a region for which we should compute hazard. Can be a gridded region or an outline. If not supplied, then one will be detected from the model. If a zip file is supplied, then it is assumed that the file is a prior hazard calculation zip file and the region will be reused from that prior calculation.");
        ops.addOption("af", "aftershock-filter", false, "If supplied, the aftershock filter will be applied in the ERF");
        ops.addOption(null, "aseis-reduces-area", false, "If supplied, aseismicity area reductions are enabled");
        ops.addOption(null, "no-aseis-reduces-area", false, "If supplied, aseismicity area reductions are disabled");
        ops.addOption("egp", "external-grid-prov", true, "Path to external grid source provider to use for hazard calculations. Can be either a fault system solution, or a zip file containing just a grid source provider.");
        ops.addOption("cwd", "combine-with-dir", true, "Path to a different directory to serach for pre-computed curves to draw from.");
        ops.addOption(null, "no-mfds", false, "Flag to disable rupture MFDs, i.e., use a single magnitude for all ruptures in the case of a branch-averaged solution");
        ops.addOption(null, "no-proxy-ruptures", false, "Flag to disable proxy ruptures MFDs, i.e., use a single proxy fault instead of distributed proxies that fill the source zone");
        ops.addOption("qgc", "quick-grid-calc", false, "Flag to enable quick gridded seismicity calculation.");
        return ops;
    }

    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        try {
            args = MPJTaskCalculator.initMPJ((String[])args);
            Options options = MPJ_SingleSolHazardCalc.createOptions();
            CommandLine cmd = MPJ_SingleSolHazardCalc.parse((Options)options, (String[])args, MPJ_SingleSolHazardCalc.class);
            MPJ_SingleSolHazardCalc driver = new MPJ_SingleSolHazardCalc(cmd);
            driver.run();
            MPJ_SingleSolHazardCalc.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJ_SingleSolHazardCalc.abortAndExit((Throwable)t);
        }
    }
}

