/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.DoubleUnaryOperator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.uncertainty.UncertainBoundedIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertainIncrMagFreqDist;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfigurationFactory;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionSolver;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.JumpProbabilityConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.LaplacianSmoothingInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.MFDInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModels;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoRateInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.RelativeBValueConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SectionTotalRateConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SlipRateInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.SubSectMFDInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.TotalRateInversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.JumpProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.Shaw07JumpDistProb;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_ConstraintBuilder;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_SegmentationModels;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.SupraSeisBValues;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.SupraSeisBValInversionTargetMFDs;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.GRParticRateEstimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.PaleoSectNuclEstimator;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.targetMFDs.estimators.ScalingRelSlipRateMFD_Estimator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;

public class Inversions {
    public static JumpProbabilityConstraint.SectParticipationRateEstimator getDefaultSectParticEstimator(FaultSystemRupSet rupSet) {
        List<? extends IncrementalMagFreqDist> sectNuclRates;
        InversionTargetMFDs targetMFDs = rupSet.getModule(InversionTargetMFDs.class);
        if (targetMFDs == null) {
            targetMFDs = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, 1.0).subSeisMoRateReduction(SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction.FROM_INPUT_SLIP_RATES).applyDefModelUncertainties(false).build();
        }
        if ((sectNuclRates = targetMFDs.getOnFaultSupraSeisNucleationMFDs()) != null) {
            return new GRParticRateEstimator(rupSet, targetMFDs);
        }
        double[] basis = UCERF3InversionConfiguration.getSmoothStartingSolution(rupSet, targetMFDs.getTotalOnFaultSupraSeisMFD());
        return new JumpProbabilityConstraint.InitialModelParticipationRateEstimator(rupSet, basis);
    }

    public static double[] getDefaultVariablePerturbationBasis(FaultSystemRupSet rupSet) {
        return Inversions.getDefaultSectParticEstimator(rupSet).estimateRuptureRates();
    }

    private static double getMinMagForMFD(FaultSystemRupSet rupSet) {
        if (rupSet.hasModule(ModSectMinMags.class)) {
            return StatUtils.min((double[])rupSet.requireModule(ModSectMinMags.class).getMinMagForSections());
        }
        return rupSet.getMinMag();
    }

    public static GutenbergRichterMagFreqDist inferTargetGRFromSlipRates(FaultSystemRupSet rupSet, double bValue) {
        double totMomentRate = rupSet.requireModule(SectSlipRates.class).calcTotalMomentRate();
        System.out.println("Inferring target G-R");
        HistogramFunction tempHist = HistogramFunction.getEncompassingHistogram(Inversions.getMinMagForMFD(rupSet), rupSet.getMaxMag(), 0.1);
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(tempHist.getMinX(), tempHist.size(), tempHist.getDelta(), totMomentRate, bValue);
        return gr;
    }

    public static IncrementalMagFreqDist restrictMFDRange(IncrementalMagFreqDist orig, double minMag, double maxMag) {
        int minIndex = -1;
        int maxIndex = 0;
        for (int i = 0; i < orig.size(); ++i) {
            double mag = orig.getX(i);
            if (minIndex < 0 && (float)mag >= (float)minMag) {
                minIndex = i;
            }
            if (!((float)mag < (float)maxMag)) continue;
            maxIndex = i;
        }
        Preconditions.checkState((minIndex >= 0 && minIndex <= maxIndex ? 1 : 0) != 0, (String)"Could not restrict MFD to range [%s, %s]", (Object)minMag, (Object)maxMag);
        IncrementalMagFreqDist trimmed = new IncrementalMagFreqDist(orig.getX(minIndex), orig.getX(maxIndex), 1 + maxIndex - minIndex);
        for (int i = 0; i < trimmed.size(); ++i) {
            int refIndex = i + minIndex;
            Preconditions.checkState(((float)trimmed.getX(i) == (float)orig.getX(refIndex) ? 1 : 0) != 0);
            trimmed.set(i, orig.getY(refIndex));
        }
        trimmed.setRegion(orig.getRegion());
        if (orig instanceof UncertainIncrMagFreqDist) {
            EvenlyDiscretizedFunc origStdDevs = ((UncertainIncrMagFreqDist)orig).getStdDevs();
            EvenlyDiscretizedFunc trimmedStdDevs = new EvenlyDiscretizedFunc(trimmed.getMinX(), trimmed.getMaxX(), trimmed.size());
            for (int i = 0; i < trimmedStdDevs.size(); ++i) {
                int refIndex = i + minIndex;
                trimmedStdDevs.set(i, origStdDevs.getY(refIndex));
            }
            return new UncertainIncrMagFreqDist(trimmed, trimmedStdDevs);
        }
        return trimmed;
    }

    static Options createOptionsNoConstraints(boolean requireRupSet, boolean requireOutputFile) {
        Options ops = InversionConfiguration.createSAOptions();
        ops.addOption(FaultSysTools.helpOption());
        if (requireRupSet) {
            ops.addRequiredOption("rs", "rupture-set", true, "Path to Rupture Set zip file.");
        } else {
            ops.addOption("rs", "rupture-set", true, "Path to Rupture Set zip file.");
        }
        if (requireOutputFile) {
            ops.addRequiredOption("o", "output-file", true, "Path where output Solution zip file will be written.");
        } else {
            ops.addOption("o", "output-file", true, "Path where output Solution zip file will be written.");
        }
        ops.addOption("wcj", "write-config-json", true, "Path to write inversion configuration JSON");
        return ops;
    }

    private static Options createOptions() {
        Options ops = Inversions.createOptionsNoConstraints(true, true);
        ops.addOption("sl", "slip-constraint", false, "Enables the slip-rate constraint.");
        ops.addOption("sw", "slip-weight", true, "Sets weight for the regular (un-normalized) slip-rate constraint.");
        ops.addOption(null, "norm-slip-weight", true, "Sets weight for the normalized slip-rate constraint.");
        ops.addOption(null, "uncertain-slip-weight", true, "Sets weight for the uncertaintly-normalized slip-rate constraint.");
        ops.addOption("mfd", "mfd-constraint", false, "Enables the MFD constraint. Must supply either --infer-target-gr or --mfd-total-rate, or Rupture Set must have InversionTargetMFDs module already attached.");
        ops.addOption("mw", "mfd-weight", true, "Sets weight for the MFD constraint.");
        ops.addOption("b", "b-value", true, "Gutenberg-Richter b-value.");
        ops.addOption(null, "mfd-ineq", false, "Flag to configure MFD constraints as inequality rather than equality constraints. Used in conjunction with --mfd-constraint. Use --mfd-transition-mag instead if you want to transition from equality to inequality constraints.");
        ops.addOption(null, "mfd-transition-mag", true, "Magnitude at and above which the mfd constraint should be applied as a inequality, allowing a natural taper (default is equality only).");
        ops.addOption(null, "b-dependent-mfd-uncert", false, "Flag to enable NSHM23 b-value and magnitude-dependent uncertainty model: 0.1 * max[1, 10^(b*0.5*(M-6))]. This switches the constraint type to be uncertainty-weighted (otherwise it is an equality constraint).");
        ops.addOption(null, "infer-target-gr", false, "Flag to infer target MFD as a G-R from total deformation model moment rate.");
        ops.addOption(null, "mfd-total-rate", true, "Total (cumulative) rate for the MFD constraint. By default, this will apply to the minimum magnitude from the rupture set, but another magnitude can be supplied with --mfd-min-mag");
        ops.addOption(null, "mfd-min-mag", true, "Minimum magnitude for the MFD constraint (default is minimum magnitude of the rupture set), used with --mfd-total-rate.");
        ops.addOption(null, "rel-gr-constraint", false, "Enables the relative Gutenberg-Richter constraint, which constraints the overal MFD to be G-R withought constraining the total event rate. The b-value will default to 1, override with --b-value <vlalue>. Set constraint weight with --mfd-weight <weight>, or configure as an inequality with --mfd-ineq.");
        ops.addOption(null, "supra-b-mfds", false, "Flag to enable the supra-seismogenic b-value mode. Used in conjunction with `--mfd-constraint`, `--sect-rate-constraint`, and/or `--sect-mfd-constraint`.");
        ops.addOption(null, "adj-mfds-for-seg", false, "If supplied, MFDs will be adjusted for compatibility with the chosen segmentation model using the NSHM23 adjustment approach (Milner and Field, 2023). See segmentation model arguments for how to specify the segmentation model.");
        ops.addOption(null, "adj-mfds-for-slips", false, "If supplied, MFDs will be adjusted for compatibility with the scaling relationship. This can be needed if the chosen scaling relationship does not determine average slip directly from moment (e.g., in length-based relationships).");
        ops.addOption(null, "sub-seis-mo-red", true, "If supplied, slip rates will be adjusted to account for sub-seismogenic ruptures. The default implementation uses input slip rates attached to the rupture set; by default, this applies any coupling coefficient to reduct the slip rate but makes no adjustment for sub-seismogenic ruptures. Options: " + FaultSysTools.enumOptions(SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction.class));
        ops.addOption(null, "adj-mfd-ucert-slip", false, "If supplied, slip rate uncertainties are propagated to section and regional MFD constraints.");
        ops.addOption(null, "adj-mfd-ucert-paleo", false, "If supplied, section MFD uncertainties are expanded to account for any incompatibilities found with supplied paleoseismic constraints.");
        ops.addOption(null, "sect-rate-constraint", false, "Enables section nucleation rate constraints that match the total rate implied by their assumed MFDs.");
        ops.addOption(null, "sect-rate-weight", true, "Sets the weight for the section rate constraint.");
        ops.addOption(null, "sect-rate-uncert", false, "Flag to enable uncertainty-weighting of section rate constraints. Usually used in conjunction with `--adj-mfd-ucert-slip` (assuming that slip rate uncertainties are present). Otherwise, the constraint will be normalized.");
        ops.addOption(null, "sect-mfd-constraint", false, "Enables section nucleation MFD constraints.");
        ops.addOption(null, "sect-mfd-weight", true, "Sets the weight for the section MFD constraint.");
        ops.addOption(null, "sect-mfd-uncert", false, "Flag to enable uncertainty-weighting of section MFD constraints. Usually used in conjunction with `--adj-mfd-ucert-slip` (assuming that slip rate uncertainties are present) and `--b-dependent-mfd-uncert`. Otherwise, the constraint will be normalized.");
        ops.addOption("paleo", "paleo-constraint", false, "Enables the paleoseismic data constraint. Must supply --paleo-data, or rupture set must already have a PaleoseismicConstraintData module attached. See also --paleo-prob-model.");
        ops.addOption(null, "paleo-data", true, "Paleoseismic data CSV file. Format must be as follows (including a header row with column names, although those names are not tested to exactly match those that follow). If values are omitted (or are negative) for 'Subsection Index', the closest subsection to each site location will be mapped automatically. CSV File columns: Site Name, Subsection Index, Latitude, Longitude, Rate, Rate Std Dev");
        ops.addOption(null, "paleo-prob-model", false, "Paleoseismic probability of detection model, one of: " + FaultSysTools.enumOptions(PaleoProbabilityModels.class) + ", default: " + PaleoProbabilityModels.DEFAULT.name());
        ops.addOption(null, "paleo-weight", true, "Sets weight for the paleoseismic datat constraint.");
        ops.addOption(null, "event-rate-constraint", true, "Enables the total event-rate constraint with the supplied total event rate");
        ops.addOption(null, "event-rate-weight", true, "Sets weight for the event-rate constraint.");
        ops.addOption(null, "event-rate-ineq", true, "Flag to constraint total event rates as an inequality constraint (i.e., to no exceed the specified rate).");
        ops.addOption(null, "seg-constraint", false, "Enables the default segmentation constraint implementation where passthrough rates are constrained not to exceed the prescribed rate. Must supply a constraint model, e.g. via --seg-dist-d0 or --seg-rates.");
        ops.addOption(null, "slip-seg-constraint", false, "Enables the alternative segmentation constraint implementation where constraitns are applied as proxy-slip constraints. In this implementation, larger magnitude ruptures contribute more to the segmentation budget (because they consume more slip).");
        ops.addOption(null, "seg-constraint-eq", false, "Flag to make segmentation constraints an equality constraint. This is generally not recommended unless all faults only have a single connection. When Y's exist, it might be impossible to match imposed equality segmentation constraints.");
        ops.addOption(null, "seg-rates", true, "Specify custom segmentation passthrough rates via a CSV file. The format consists of a header line: Section ID1,Section ID2,Fractional Passthrough Rate, and a line for each constrained jump. Section IDs are subsection must be on different parent faults (unless the --seg-parent-rates flag is present), and passthrough rates should be in the range [0,1]. Passthrough rates are assumed to be 1 for all jumps not included in the file.");
        ops.addOption(null, "seg-parent-rates", false, "Flag to specify that the segmentation rates specified via --seg-rages <csv-file> use parent section IDs rather than subsection IDs.");
        ops.addOption(null, "seg-dist-d0", true, "Use Shaw and Dieterich (2007) distance-dependent segmentation rate model. Sets D0 (referred to as R0 in their model) in km, where D0=3 is the preferred value. Also see --seg-dist-delta.");
        ops.addOption(null, "seg-dist-delta", true, "Sets the fault uncertainty parameter, &delta;, in the NSHM23 implementation of the Shaw and Dieterich (2007) distance-dependent segmentation rate model. With uits in km, this shifts the exponential distribution to the right by &delta;; values less than this value are unconstrained. Used in conjunction with --seg-dist-d0.");
        ops.addOption(null, "seg-nshm23", true, "Use an NSHM23 segmentation constraint. This includes distance-dependent segmentation, along with special constraints on the SAF creeping section and Wasatch faults (if found by name). Note that this won't include all features of the NSHM23 segmentation constraint, such as rupture length limits or detection of special fault exceptions to the Classic model. Options: LOW,MID,HIGH,CLASSIC");
        ops.addOption(null, "seg-weight", true, "Sets weight for the segmentation constraint.");
        ops.addOption(null, "smooth", false, "Flag to enable the Laplacian smoothness constraint that smooths supra-seismogenic participation rates along adjacent subsections on a parent section.");
        ops.addOption(null, "paleo-smooth", false, "Enables the Laplacian smoothness constraint (see --smooth), but only for faults with paleoseismic constraints.");
        ops.addOption(null, "smooth-weight", true, "Sets weight for the smoothness constraint.");
        ops.addOption("cfg", "config-json", true, "Path to a JSON file containing a full inversion configuration, as an alternative to using command line options.");
        ops.addOption("cnstr", "constraints-json", true, "Path to a JSON file containing inversion constraints that should be included.");
        return ops;
    }

    /*
     * WARNING - void declaration
     */
    public static List<InversionConstraint> parseConstraints(FaultSystemRupSet rupSet, CommandLine cmd) throws IOException {
        ArrayList<InversionConstraint> constraints = new ArrayList<InversionConstraint>();
        if (cmd.hasOption("slip-constraint")) {
            double regWeight = 0.0;
            double normWeight = 0.0;
            double uncertWeight = 0.0;
            if (cmd.hasOption("norm-slip-weight")) {
                normWeight = Double.parseDouble(cmd.getOptionValue("norm-slip-weight"));
            }
            if (cmd.hasOption("slip-weight")) {
                regWeight = Double.parseDouble(cmd.getOptionValue("slip-weight"));
            }
            if (cmd.hasOption("uncertain-slip-weight")) {
                uncertWeight = Double.parseDouble(cmd.getOptionValue("uncertain-slip-weight"));
            }
            if (normWeight == 0.0 && regWeight == 0.0 && uncertWeight == 0.0) {
                regWeight = 1.0;
            }
            if (regWeight > 0.0) {
                constraints.add(new SlipRateInversionConstraint(regWeight, ConstraintWeightingType.UNNORMALIZED, rupSet));
            }
            if (normWeight > 0.0) {
                constraints.add(new SlipRateInversionConstraint(normWeight, ConstraintWeightingType.NORMALIZED, rupSet));
            }
            if (uncertWeight > 0.0) {
                constraints.add(new SlipRateInversionConstraint(uncertWeight, ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY, rupSet));
            }
        }
        JumpProbabilityCalc segModel = null;
        InversionTargetMFDs targetMFDs = null;
        PaleoseismicConstraintData paleoData = null;
        double bValue = cmd.hasOption("b-value") ? Double.parseDouble(cmd.getOptionValue("b-value")) : 1.0;
        DoubleUnaryOperator mfdMagDepUncertModel = null;
        if (cmd.hasOption("b-dependent-mfd-uncert")) {
            mfdMagDepUncertModel = M -> 0.1 * Math.max(1.0, Math.pow(10.0, bValue * 0.5 * (M - 6.0)));
        }
        LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        if (cmd.hasOption("supra-b-mfds")) {
            Preconditions.checkArgument((!cmd.hasOption("infer-target-gr") && !cmd.hasOption("mfd-total-rate") ? 1 : 0) != 0, (Object)"Can't supply --supra-b-mfds with either --infer-target-gr or --mfd-total-rate");
            SupraSeisBValInversionTargetMFDs.Builder builder = new SupraSeisBValInversionTargetMFDs.Builder(rupSet, bValue);
            if (branch != null && branch.hasValue(SupraSeisBValues.class)) {
                void var14_40;
                boolean found = false;
                SupraSeisBValues[] supraSeisBValuesArray = SupraSeisBValues.values();
                int n = supraSeisBValuesArray.length;
                boolean bl = false;
                while (var14_40 < n) {
                    SupraSeisBValues supraSeisBValues = supraSeisBValuesArray[var14_40];
                    if (supraSeisBValues.bValue == bValue) {
                        found = true;
                        branch.setValueUnchecked(supraSeisBValues);
                    }
                    ++var14_40;
                }
                if (!found) {
                    branch.clearValue(SupraSeisBValues.class);
                }
            }
            if (cmd.hasOption("adj-mfds-for-seg")) {
                segModel = Inversions.getSegModel(rupSet, cmd);
                Preconditions.checkNotNull((Object)segModel, (Object)"--adj-mfds-for-seg supplied but no segmentation model specified");
                if (segModel instanceof JumpProbabilityCalc.BinaryJumpProbabilityCalc) {
                    builder.forBinaryRupProbModel((JumpProbabilityCalc.BinaryJumpProbabilityCalc)segModel);
                } else {
                    builder.adjustTargetsForData(NSHM23_ConstraintBuilder.SEG_ADJ_METHOD_DEFAULT.getAdjustment(segModel));
                }
            }
            if (cmd.hasOption("adj-mfds-for-slips")) {
                builder.adjustTargetsForData(new ScalingRelSlipRateMFD_Estimator(false));
            }
            if (cmd.hasOption("sub-seis-mo-red")) {
                builder.subSeisMoRateReduction(SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction.valueOf(cmd.getOptionValue("sub-seis-mo-red")));
            } else {
                builder.subSeisMoRateReduction(SupraSeisBValInversionTargetMFDs.SubSeisMoRateReduction.FROM_INPUT_SLIP_RATES);
            }
            builder.applyDefModelUncertainties(cmd.hasOption("adj-mfd-ucert-slip"));
            if (cmd.hasOption("adj-mfd-ucert-paleo")) {
                paleoData = Inversions.getPaleoData(rupSet, cmd);
                Preconditions.checkNotNull((Object)paleoData, (Object)"--adj-mfd-ucert-paleo supplied but no paleoseismic data specified");
                ArrayList<PaleoSectNuclEstimator> dataConstraints = new ArrayList<PaleoSectNuclEstimator>();
                if (paleoData.getPaleoSlipConstraints() != null) {
                    rupSet.addModule(builder.buildSlipRatesOnly());
                }
                dataConstraints.addAll(PaleoSectNuclEstimator.buildPaleoEstimates(rupSet, true, null));
                builder.expandUncertaintiesForData(dataConstraints, UncertaintyBoundType.ONE_SIGMA);
            }
            if (mfdMagDepUncertModel != null) {
                builder.magDepDefaultRelStdDev(mfdMagDepUncertModel);
            }
            targetMFDs = builder.build();
            rupSet.addModule(targetMFDs);
        }
        if (cmd.hasOption("mfd-constraint")) {
            List<? extends IncrementalMagFreqDist> mfdConstraints;
            double weight = 1.0;
            if (cmd.hasOption("mfd-weight")) {
                weight = Double.parseDouble(cmd.getOptionValue("mfd-weight"));
            }
            if (targetMFDs == null) {
                if (cmd.hasOption("infer-target-gr")) {
                    IncrementalMagFreqDist targetMFD = Inversions.inferTargetGRFromSlipRates(rupSet, bValue);
                    if (mfdMagDepUncertModel != null) {
                        targetMFD = UncertainIncrMagFreqDist.relStdDev(targetMFD, mfdMagDepUncertModel);
                    }
                    mfdConstraints = List.of(targetMFD);
                    targetMFDs = new InversionTargetMFDs.Precomputed(rupSet, null, targetMFD, null, null, mfdConstraints, null, null);
                    rupSet.addModule(targetMFDs);
                } else if (cmd.hasOption("mfd-total-rate")) {
                    double minX;
                    double d = minX = 0.1 * Math.floor(Inversions.getMinMagForMFD(rupSet) * 10.0);
                    if (cmd.hasOption("mfd-min-mag")) {
                        d = Double.parseDouble(cmd.getOptionValue("mfd-min-mag"));
                        minX = Math.min(minX, d);
                    }
                    Preconditions.checkArgument((boolean)cmd.hasOption("mfd-total-rate"), (Object)"MFD constraint enabled, but no --mfd-total-rate <rate> or --infer-target-gr");
                    double totRate = Double.parseDouble(cmd.getOptionValue("mfd-total-rate"));
                    HistogramFunction histogramFunction = HistogramFunction.getEncompassingHistogram(minX, rupSet.getMaxMag(), 0.1);
                    GutenbergRichterMagFreqDist targetGR = new GutenbergRichterMagFreqDist(histogramFunction.getMinX(), histogramFunction.getMaxX(), histogramFunction.size());
                    targetGR.scaleToCumRate(d, totRate);
                    IncrementalMagFreqDist targetMFD = targetGR;
                    if (mfdMagDepUncertModel != null) {
                        targetMFD = UncertainIncrMagFreqDist.relStdDev(targetMFD, mfdMagDepUncertModel);
                    }
                    mfdConstraints = List.of(targetMFD);
                    targetMFDs = new InversionTargetMFDs.Precomputed(rupSet, null, targetMFD, null, null, mfdConstraints, null, null);
                    rupSet.addModule(targetMFDs);
                } else {
                    Preconditions.checkState((boolean)rupSet.hasModule(InversionTargetMFDs.class), (Object)"MFD Constraint enabled, but no target MFD specified. Rupture Set must either already have target MFDs attached, or MFD should be specified via --infer-target-gr or --mfd-total-rate <rate>.");
                    targetMFDs = rupSet.requireModule(InversionTargetMFDs.class);
                    if (mfdMagDepUncertModel != null) {
                        ArrayList<? extends IncrementalMagFreqDist> newConstraints = new ArrayList<IncrementalMagFreqDist>();
                        for (IncrementalMagFreqDist incrementalMagFreqDist : targetMFDs.getMFD_Constraints()) {
                            void var15_51;
                            if (!(incrementalMagFreqDist instanceof UncertainIncrMagFreqDist)) {
                                UncertainIncrMagFreqDist uncertainIncrMagFreqDist = UncertainIncrMagFreqDist.relStdDev(incrementalMagFreqDist, mfdMagDepUncertModel);
                            }
                            newConstraints.add((IncrementalMagFreqDist)var15_51);
                        }
                        mfdConstraints = newConstraints;
                    } else {
                        mfdConstraints = targetMFDs.getMFD_Constraints();
                    }
                }
            } else {
                mfdConstraints = targetMFDs.getMFD_Constraints();
            }
            ConstraintWeightingType mfdType = mfdMagDepUncertModel == null ? ConstraintWeightingType.NORMALIZED : ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY;
            for (IncrementalMagFreqDist incrementalMagFreqDist : mfdConstraints) {
                System.out.println("MFD Constraint for region " + (incrementalMagFreqDist.getRegion() == null ? "null" : incrementalMagFreqDist.getRegion().getName()) + ":\n" + String.valueOf(incrementalMagFreqDist));
            }
            if (cmd.hasOption("mfd-ineq")) {
                Preconditions.checkArgument((!cmd.hasOption("mfd-transition-mag") ? 1 : 0) != 0, (Object)"Can't specify both --mfd-transition-mag and --mfd-ineq");
                constraints.add(new MFDInversionConstraint(rupSet, weight, true, mfdType, mfdConstraints));
            } else if (cmd.hasOption("mfd-transition-mag")) {
                double d = Double.parseDouble(cmd.getOptionValue("mfd-transition-mag"));
                ArrayList<IncrementalMagFreqDist> eqConstrs = new ArrayList<IncrementalMagFreqDist>();
                ArrayList<IncrementalMagFreqDist> ieqConstrs = new ArrayList<IncrementalMagFreqDist>();
                for (IncrementalMagFreqDist incrementalMagFreqDist : mfdConstraints) {
                    eqConstrs.add(Inversions.restrictMFDRange(incrementalMagFreqDist, Double.NEGATIVE_INFINITY, d));
                    ieqConstrs.add(Inversions.restrictMFDRange(incrementalMagFreqDist, d, Double.POSITIVE_INFINITY));
                }
                constraints.add(new MFDInversionConstraint(rupSet, weight, false, mfdType, eqConstrs));
                constraints.add(new MFDInversionConstraint(rupSet, weight, true, mfdType, ieqConstrs));
            } else {
                constraints.add(new MFDInversionConstraint(rupSet, weight, false, mfdType, mfdConstraints));
            }
        }
        if (cmd.hasOption("rel-gr-constraint")) {
            double weight = 1.0;
            if (cmd.hasOption("mfd-weight")) {
                weight = Double.parseDouble(cmd.getOptionValue("mfd-weight"));
            }
            boolean ineq = cmd.hasOption("mfd-ineq");
            constraints.add(new RelativeBValueConstraint(rupSet, bValue, weight, ConstraintWeightingType.NORMALIZED, null, ineq));
        }
        if (cmd.hasOption("sect-rate-constraint")) {
            double weight = 1.0;
            if (cmd.hasOption("sect-rate-weight")) {
                weight = Double.parseDouble(cmd.getOptionValue("sect-rate-weight"));
            }
            ConstraintWeightingType type = cmd.hasOption("sect-rate-uncert") ? ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY : ConstraintWeightingType.NORMALIZED;
            Preconditions.checkNotNull((Object)targetMFDs, (Object)"Section rate constraint enabled but no target MFDs");
            List<? extends IncrementalMagFreqDist> sectSupraMFDs = targetMFDs.getOnFaultSupraSeisNucleationMFDs();
            Preconditions.checkNotNull(sectSupraMFDs, (Object)"Section rate constraint enabled but target MFDs doesn't supply section MFDs");
            double[] dArray = new double[rupSet.getNumSections()];
            double[] dArray2 = type == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY ? new double[rupSet.getNumSections()] : null;
            for (int s = 0; s < dArray.length; ++s) {
                IncrementalMagFreqDist sectSupraMFD = sectSupraMFDs.get(s);
                dArray[s] = sectSupraMFD.calcSumOfY_Vals();
                if (dArray2 == null) continue;
                Preconditions.checkState((boolean)(sectSupraMFD instanceof UncertainIncrMagFreqDist), (Object)"--sect-rate-uncert supplied but section MFDs have no uncertainty model");
                UncertainBoundedIncrMagFreqDist oneSigmaBoundedMFD = ((UncertainIncrMagFreqDist)sectSupraMFD).estimateBounds(UncertaintyBoundType.ONE_SIGMA);
                double d = oneSigmaBoundedMFD.getUpper().calcSumOfY_Vals();
                double lowerVal = oneSigmaBoundedMFD.getLower().calcSumOfY_Vals();
                dArray2[s] = UncertaintyBoundType.ONE_SIGMA.estimateStdDev(lowerVal, d);
            }
            constraints.add(new SectionTotalRateConstraint(rupSet, weight, type, dArray, dArray2, true));
        }
        if (cmd.hasOption("sect-mfd-constraint")) {
            double weight = 1.0;
            if (cmd.hasOption("sect-mfd-weight")) {
                weight = Double.parseDouble(cmd.getOptionValue("sect-mfd-weight"));
            }
            ConstraintWeightingType type = cmd.hasOption("sect-mfd-uncert") ? ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY : ConstraintWeightingType.NORMALIZED;
            Preconditions.checkNotNull((Object)targetMFDs, (Object)"Section MFD constraint enabled but no target MFDs");
            List<? extends IncrementalMagFreqDist> sectSupraMFDs = targetMFDs.getOnFaultSupraSeisNucleationMFDs();
            Preconditions.checkNotNull(sectSupraMFDs, (Object)"Section MFD constraint enabled but target MFDs doesn't supply section MFDs");
            constraints.add(new SubSectMFDInversionConstraint(rupSet, weight, type, sectSupraMFDs, true));
        }
        if (cmd.hasOption("event-rate-constraint")) {
            double targetEventRate = Double.parseDouble(cmd.getOptionValue("event-rate-constraint"));
            System.out.println("Target event rate: " + targetEventRate + " /yr");
            double weight = 1.0;
            if (cmd.hasOption("event-rate-weight")) {
                weight = Double.parseDouble(cmd.getOptionValue("event-rate-weight"));
            }
            constraints.add(new TotalRateInversionConstraint(weight, targetEventRate, rupSet, 0.0, ConstraintWeightingType.UNNORMALIZED, Double.NaN, cmd.hasOption("event-rate-ineq")));
        }
        if (cmd.hasOption("paleo-constraint")) {
            double weight = 1.0;
            if (cmd.hasOption("paleo-weight")) {
                weight = Double.parseDouble(cmd.getOptionValue("paleo-weight"));
            }
            if (paleoData == null) {
                paleoData = Inversions.getPaleoData(rupSet, cmd);
            }
            constraints.add(new PaleoRateInversionConstraint(rupSet, weight, paleoData.getPaleoRateConstraints(), paleoData.getPaleoProbModel()));
            if (paleoData.getPaleoSlipConstraints() != null && !paleoData.getPaleoSlipConstraints().isEmpty()) {
                System.err.println("WARNING: rupture set has paleo slip constraints, which are not supported via the command line inversion configuration, skipping");
            }
        }
        if (cmd.hasOption("seg-constraint") || cmd.hasOption("slip-seg-constraint")) {
            boolean inequality;
            System.out.println("Adding segmentation constraints");
            double weight = 1.0;
            if (cmd.hasOption("seg-weight")) {
                weight = Double.parseDouble(cmd.getOptionValue("seg-weight"));
            }
            if (segModel == null) {
                segModel = Inversions.getSegModel(rupSet, cmd);
            }
            if (segModel == null) {
                throw new IllegalArgumentException("Segmentation constraint enabled, but no segmentation rates specified.");
            }
            boolean bl = inequality = !cmd.hasOption("seg-constraint-eq");
            if (cmd.hasOption("seg-constraint")) {
                Preconditions.checkState((!cmd.hasOption("slip-seg-constraint") ? 1 : 0) != 0, (Object)"Can't enable both rate and slip segmentation constraints");
                JumpProbabilityConstraint.SectParticipationRateEstimator rateEst = Inversions.getDefaultSectParticEstimator(rupSet);
                constraints.add(new JumpProbabilityConstraint.RelativeRate(weight, inequality, rupSet, segModel, rateEst));
            } else {
                constraints.add(new JumpProbabilityConstraint.ProxySlip(weight, inequality, rupSet, segModel));
            }
        }
        if (cmd.hasOption("smooth") || cmd.hasOption("paleo-smooth")) {
            double weight = 1.0;
            if (cmd.hasOption("smooth-weight")) {
                weight = Double.parseDouble(cmd.getOptionValue("smooth-weight"));
            }
            if (cmd.hasOption("paleo-smooth")) {
                if (paleoData == null) {
                    paleoData = Inversions.getPaleoData(rupSet, cmd);
                }
                Preconditions.checkNotNull((Object)paleoData, (Object)"Can't smooth at paleo sites if no paleo data attached");
                HashSet<Integer> parentIDs = new HashSet<Integer>();
                for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : paleoData.getPaleoRateConstraints()) {
                    parentIDs.add(rupSet.getFaultSectionData(sectMappedUncertainDataConstraint.sectionIndex).getParentSectionId());
                }
                System.out.println("Enabling Laplacian smoothness constraint for " + parentIDs.size() + " parent fault sections");
                constraints.add(new LaplacianSmoothingInversionConstraint(rupSet, weight, parentIDs));
            } else {
                System.out.println("Enabling Laplacian smoothness constraint");
                constraints.add(new LaplacianSmoothingInversionConstraint(rupSet, weight));
            }
        }
        if (cmd.hasOption("constraints-json")) {
            File constraintsFile = new File(cmd.getOptionValue("constraints-json"));
            Preconditions.checkArgument((boolean)constraintsFile.exists(), (String)"File doesn't exist: %s", (Object)constraintsFile.getAbsolutePath());
            constraints.addAll(InversionConstraint.loadConstraintsJSON(constraintsFile, rupSet));
        }
        return constraints;
    }

    /*
     * WARNING - void declaration
     */
    private static JumpProbabilityCalc getSegModel(FaultSystemRupSet rupSet, CommandLine cmd) throws IOException {
        LogicTreeBranch branch = rupSet.getModule(LogicTreeBranch.class);
        if (cmd.hasOption("seg-dist-d0")) {
            Preconditions.checkState((!cmd.hasOption("seg-rates") && !cmd.hasOption("seg-nshm23") ? 1 : 0) != 0, (Object)"Cannot supply multiple segmentation constraints");
            double d0 = Double.parseDouble(cmd.getOptionValue("seg-dist-d0"));
            if (cmd.hasOption("seg-dist-delta")) {
                return Shaw07JumpDistProb.forHorzOffset(1.0, d0, Double.parseDouble(cmd.getOptionValue("seg-dist-delta")));
            }
            return new Shaw07JumpDistProb(1.0, d0);
        }
        if (cmd.hasOption("seg-rates")) {
            void var8_12;
            Preconditions.checkState((!cmd.hasOption("seg-dist-d0") && !cmd.hasOption("seg-nshm23") ? 1 : 0) != 0, (Object)"Cannot supply multiple segmentation constraints");
            File csvFile = new File(cmd.getOptionValue("seg-rates"));
            Preconditions.checkState((boolean)csvFile.exists(), (String)"Segmentation rate CSV file doesn't exist: %s", (Object)csvFile.getAbsolutePath());
            System.out.println("Loading segmentation rates from " + csvFile.getAbsolutePath());
            CSVFile<String> csv = CSVFile.readFile(csvFile, true);
            Preconditions.checkState((csv.getNumCols() == 3 ? 1 : 0) != 0, (Object)"Segmentation CSV file should be exactly 3 columns: Section ID1,Section ID2,Fractional Passthrough Rate");
            Preconditions.checkState((csv.getNumRows() > 1 ? 1 : 0) != 0, (Object)"Segmentation CSV file doesn't contain any rates");
            boolean parents = cmd.hasOption("--seg-parent-rates");
            HashSet<Integer> parentsSet = null;
            if (parents) {
                parentsSet = new HashSet<Integer>();
                for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                    if (faultSection.getParentSectionId() < 0) continue;
                    parentsSet.add(faultSection.getParentSectionId());
                }
                Preconditions.checkState((!parentsSet.isEmpty() ? 1 : 0) != 0, (Object)"Parents flag given, but fault section data have no valid parent section IDs");
            }
            HashMap<IDPairing, Double> rates = new HashMap<IDPairing, Double>();
            boolean bl = true;
            while (var8_12 < csv.getNumRows()) {
                int sect2;
                int sect1 = csv.getInt((int)var8_12, 0);
                Preconditions.checkState((sect1 != (sect2 = csv.getInt((int)var8_12, 1)) ? 1 : 0) != 0, (String)"Both section IDs the same? %s == %s", (int)sect1, (int)sect2);
                if (parents) {
                    Preconditions.checkState((boolean)parentsSet.contains(sect1), (String)"--seg-parent-rates was supplied, but no sections have the specified parent section ID: %s", (int)sect1);
                    Preconditions.checkState((boolean)parentsSet.contains(sect2), (String)"--seg-parent-rates was supplied, but no sections have the specified parent section ID: %s", (int)sect2);
                } else {
                    Preconditions.checkState((sect1 >= 0 && sect1 < rupSet.getNumSections() ? 1 : 0) != 0, (String)"Bad section ID: %s", (int)sect1);
                    Preconditions.checkState((sect2 >= 0 && sect2 < rupSet.getNumSections() ? 1 : 0) != 0, (String)"Bad section ID: %s", (int)sect2);
                    int parent1 = rupSet.getFaultSectionData(sect1).getParentSectionId();
                    int parent2 = rupSet.getFaultSectionData(sect2).getParentSectionId();
                    if (parent1 >= 0 || parent2 >= 0) {
                        Preconditions.checkState((parent1 != parent2 ? 1 : 0) != 0, (Object)"Cannot constrain segmentation between two subsections on the same parent section. You must split the parent fault section at any segmentation points before subsectioning (and building the rupture set).");
                    }
                }
                double rate = csv.getDouble((int)var8_12, 2);
                Preconditions.checkState((rate >= 0.0 && rate <= 1.0 ? 1 : 0) != 0, (String)"Passthrough rates must be in the range [0,1]: %s", (Object)rate);
                rates.put(new IDPairing(sect1, sect2), rate);
                ++var8_12;
            }
            System.out.println("Loaded " + rates.size() + " segmentation rates");
            return new JumpProbabilityCalc.HardcodedJumpProb(csvFile.getName(), rates, parents);
        }
        if (cmd.hasOption("seg-nshm23")) {
            Preconditions.checkState((!cmd.hasOption("seg-rates") && !cmd.hasOption("seg-dist-d0") ? 1 : 0) != 0, (Object)"Cannot supply multiple segmentation constraints");
            NSHM23_SegmentationModels model = NSHM23_SegmentationModels.valueOf(cmd.getOptionValue("seg-nshm23"));
            if (branch != null && branch.hasValue(NSHM23_SegmentationModels.class)) {
                branch.setValueUnchecked(model);
            }
            return model.getModel(rupSet, null);
        }
        return null;
    }

    private static PaleoseismicConstraintData getPaleoData(FaultSystemRupSet rupSet, CommandLine cmd) throws IOException {
        if (cmd.hasOption("paleo-data")) {
            File csvFile = new File(cmd.getOptionValue("paleo-data"));
            CSVFile<String> csv = CSVFile.readFile(csvFile, true);
            PaleoProbabilityModels modelChoice = PaleoProbabilityModels.DEFAULT;
            if (cmd.hasOption("paleo-prob-model")) {
                modelChoice = PaleoProbabilityModels.valueOf(cmd.getOptionValue("paleo-prob-model"));
            }
            PaleoseismicConstraintData paleoData = PaleoseismicConstraintData.fromSimpleCSV(rupSet, csv, modelChoice.get());
            rupSet.addModule(paleoData);
            return paleoData;
        }
        Preconditions.checkArgument((boolean)rupSet.hasModule(PaleoseismicConstraintData.class), (Object)"Must supply --paleo-data if PaleoseismicConstraintData module not attached to rupture set and --paleo-constraint enabled.");
        Preconditions.checkArgument((!cmd.hasOption("paleo-prob-model") ? 1 : 0) != 0, (Object)"Cannot supply paleoseismic probably model when using already attached paleo data.");
        return rupSet.requireModule(PaleoseismicConstraintData.class);
    }

    public static void main(String[] args) {
        try {
            Inversions.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static FaultSystemSolution run(String[] args) throws IOException {
        return Inversions.run(args, null);
    }

    public static FaultSystemSolution run(String[] args, List<InversionConstraint> constraints) throws IOException {
        InversionConfiguration config;
        File configFile;
        CommandLine cmd = FaultSysTools.parseOptions(Inversions.createOptions(), args, Inversions.class);
        FaultSysTools.checkPrintHelp(null, cmd, Inversions.class);
        File rupSetFile = new File(cmd.getOptionValue("rupture-set"));
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(rupSetFile);
        if (constraints == null) {
            constraints = new ArrayList<InversionConstraint>();
        } else if (!constraints.isEmpty()) {
            constraints = new ArrayList<InversionConstraint>(constraints);
        }
        int numExtra = constraints.size();
        File outputFile = new File(cmd.getOptionValue("output-file"));
        constraints.addAll(Inversions.parseConstraints(rupSet, cmd));
        if (cmd.hasOption("config-json")) {
            configFile = new File(cmd.getOptionValue("config-json"));
            Preconditions.checkArgument((boolean)configFile.exists(), (String)"File doesn't exist: %s", (Object)configFile.getAbsolutePath());
            config = InversionConfiguration.readJSON(configFile, rupSet);
            config = InversionConfiguration.builder(config).forCommandLine(cmd).build();
        } else {
            config = InversionConfiguration.builder(constraints, cmd).build();
        }
        Preconditions.checkState((!config.getConstraints().isEmpty() ? 1 : 0) != 0, (Object)"No constraints specified.");
        if (cmd.hasOption("write-config-json")) {
            configFile = new File(cmd.getOptionValue("write-config-json"));
            BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)config, InversionConfiguration.class, (Appendable)writer);
            writer.flush();
            writer.close();
        }
        String info = "Fault System Solution generated with OpenSHA Fault System Tools (https://github.com/opensha/opensha-fault-sys-tools), using the following command:\n\nfst_inversion_runner.sh " + Joiner.on((String)" ").join((Object[])args);
        if (numExtra > 0) {
            info = info + "\n\nNOTE: " + numExtra + " constraints were passed in directly, bypassing the command line interface and are not reflected in the command above.";
        }
        FaultSystemSolution sol = Inversions.run(rupSet, config, info);
        sol.write(outputFile);
        return sol;
    }

    public static FaultSystemSolution run(InversionConfigurationFactory factory, LogicTreeBranch<?> branch, int threads) throws IOException {
        return Inversions.run(factory, branch, threads, null);
    }

    public static FaultSystemSolution run(InversionConfigurationFactory factory, LogicTreeBranch<?> branch, int threads, CommandLine cmd) throws IOException {
        FaultSystemRupSet rupSet = factory.buildRuptureSet(branch, threads);
        return Inversions.run(rupSet, factory, branch, threads, cmd);
    }

    public static FaultSystemSolution run(FaultSystemRupSet rupSet, InversionConfigurationFactory factory, LogicTreeBranch<?> branch, int threads, CommandLine cmd) throws IOException {
        return factory.getSolver(rupSet, branch).run(rupSet, factory, branch, threads, cmd);
    }

    public static FaultSystemSolution run(FaultSystemRupSet rupSet, InversionConfiguration config) {
        return new InversionSolver.Default().run(rupSet, config, null);
    }

    public static FaultSystemSolution run(FaultSystemRupSet rupSet, InversionConfiguration config, String info) {
        return new InversionSolver.Default().run(rupSet, config, info);
    }
}

