/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints;

import com.google.common.base.Preconditions;

public enum ConstraintWeightingType {
    NORMALIZED("Normalized", "Norm", "Misfit (Fractional)"){

        @Override
        public double getA_Scalar(double targetRate, double targetStdDev) {
            return 1.0 / targetRate;
        }

        @Override
        public double getD(double targetRate, double targetStdDev) {
            return 1.0;
        }
    }
    ,
    UNNORMALIZED("Unnormlized", "Unnorm", "Misfit"){

        @Override
        public double getA_Scalar(double targetRate, double targetStdDev) {
            return 1.0;
        }

        @Override
        public double getD(double targetRate, double targetStdDev) {
            return targetRate;
        }
    }
    ,
    NORMALIZED_BY_UNCERTAINTY("Uncertain", "Uncert", "Misfit (Standard Deviations)"){

        @Override
        public double getA_Scalar(double targetRate, double targetStdDev) {
            Preconditions.checkState((targetStdDev > 0.0 ? 1 : 0) != 0);
            return 1.0 / targetStdDev;
        }

        @Override
        public double getD(double targetRate, double targetStdDev) {
            Preconditions.checkState((targetStdDev > 0.0 ? 1 : 0) != 0);
            return targetRate / targetStdDev;
        }
    };

    private String namePrefix;
    private String shortNamePrefix;
    private String misfitLabel;

    private ConstraintWeightingType(String namePrefix, String shortNamePrefix, String misfitLabel) {
        this.namePrefix = namePrefix;
        this.shortNamePrefix = shortNamePrefix;
        this.misfitLabel = misfitLabel;
    }

    public String applyNamePrefix(String name) {
        return this.namePrefix + " " + name;
    }

    public String applyShortNamePrefix(String shortName) {
        return this.shortNamePrefix + shortName;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public String getShortNamePrefix() {
        return this.shortNamePrefix;
    }

    public String getMisfitLabel() {
        return this.misfitLabel;
    }

    public abstract double getA_Scalar(double var1, double var3);

    public abstract double getD(double var1, double var3);
}

