/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.utils.U3SectionMFD_constraint;

public class MFDLaplacianSmoothingInversionConstraint
extends InversionConstraint {
    public static final String NAME = "MFD Laplacian Smoothing";
    public static final String SHORT_NAME = "LaplaceSmooth";
    private transient FaultSystemRupSet rupSet;
    private HashSet<Integer> parentIDs;
    private List<U3SectionMFD_constraint> constraints;

    public MFDLaplacianSmoothingInversionConstraint(FaultSystemRupSet rupSet, double weight, List<U3SectionMFD_constraint> constraints) {
        this(rupSet, weight, null, constraints);
    }

    public MFDLaplacianSmoothingInversionConstraint(FaultSystemRupSet rupSet, double weight, HashSet<Integer> parentIDs, List<U3SectionMFD_constraint> constraints) {
        super(NAME, SHORT_NAME, weight, false);
        this.rupSet = rupSet;
        this.parentIDs = parentIDs;
        this.constraints = constraints;
    }

    @Override
    public int getNumRows() {
        int parentID;
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        for (FaultSection iterator : this.rupSet.getFaultSectionDataList()) {
            parentID = iterator.getParentSectionId();
            parentIDs.add(parentID);
        }
        int totalNumMFDSmoothnessConstraints = 0;
        Iterator iterator = parentIDs.iterator();
        while (iterator.hasNext()) {
            parentID = (Integer)iterator.next();
            if (this.parentIDs != null && !this.parentIDs.contains(parentID)) continue;
            ArrayList<Integer> sectsForParent = new ArrayList<Integer>();
            for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
                int sectParentID = faultSection.getParentSectionId();
                if (sectParentID != parentID) continue;
                sectsForParent.add(faultSection.getSectionId());
            }
            for (int j = 1; j < sectsForParent.size() - 2; ++j) {
                int n = (Integer)sectsForParent.get(j);
                U3SectionMFD_constraint sectMFDConstraint = this.constraints.get(n);
                if (sectMFDConstraint == null) continue;
                int numMagBins = sectMFDConstraint.getNumMags();
                totalNumMFDSmoothnessConstraints += numMagBins;
            }
        }
        return totalNumMFDSmoothnessConstraints;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        void var9_10;
        long numNonZeroElements = 0L;
        int rowIndex = startRow;
        HashMap parentSectsMap = Maps.newHashMap();
        for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
            Integer parentID = faultSection.getParentSectionId();
            List parentSects = (List)parentSectsMap.get(parentID);
            if (parentSects == null) {
                parentSects = Lists.newArrayList();
                parentSectsMap.put(parentID, parentSects);
            }
            parentSects.add(faultSection);
        }
        ArrayList sectRupsHashes = Lists.newArrayList();
        boolean bl = false;
        while (var9_10 < this.rupSet.getNumSections()) {
            sectRupsHashes.add(new HashSet<Integer>(this.rupSet.getRupturesForSection((int)var9_10)));
            ++var9_10;
        }
        for (List sectsForParent : parentSectsMap.values()) {
            int parentID = this.rupSet.getFaultSectionDataList().get(((FaultSection)sectsForParent.get(0)).getSectionId()).getParentSectionId();
            if (this.parentIDs != null && !this.parentIDs.contains(parentID)) continue;
            for (int j = 1; j < sectsForParent.size() - 2; ++j) {
                int sect1 = ((FaultSection)sectsForParent.get(j - 1)).getSectionId();
                HashSet sect1Hash = (HashSet)sectRupsHashes.get(sect1);
                int sect2 = ((FaultSection)sectsForParent.get(j)).getSectionId();
                HashSet sect2Hash = (HashSet)sectRupsHashes.get(sect2);
                int sect3 = ((FaultSection)sectsForParent.get(j + 1)).getSectionId();
                HashSet sect3Hash = (HashSet)sectRupsHashes.get(sect3);
                ArrayList sect1Rups = Lists.newArrayList();
                ArrayList sect2Rups = Lists.newArrayList();
                ArrayList sect3Rups = Lists.newArrayList();
                for (Integer sect1Rup : sect1Hash) {
                    if (sect2Hash.contains(sect1Rup)) continue;
                    sect1Rups.add(sect1Rup);
                }
                for (Integer sect2Rup : sect2Hash) {
                    if (sect1Hash.contains(sect2Rup)) continue;
                    sect2Rups.add(sect2Rup);
                }
                for (Integer sect2Rup : sect2Hash) {
                    if (sect3Hash.contains(sect2Rup)) continue;
                    sect2Rups.add(sect2Rup);
                }
                for (Integer sect3Rup : sect3Hash) {
                    if (sect2Hash.contains(sect3Rup)) continue;
                    sect3Rups.add(sect3Rup);
                }
                U3SectionMFD_constraint sectMFDConstraint = this.constraints.get(sect2);
                if (sectMFDConstraint == null) continue;
                int numMagBins = sectMFDConstraint.getNumMags();
                for (int magBin = 0; magBin < numMagBins; ++magBin) {
                    ArrayList<Integer> sect1RupsForMagBin = new ArrayList<Integer>();
                    for (int i = 0; i < sect1Rups.size(); ++i) {
                        double mag = this.rupSet.getMagForRup((Integer)sect1Rups.get(i));
                        if (!sectMFDConstraint.isMagInBin(mag, magBin)) continue;
                        sect1RupsForMagBin.add((Integer)sect1Rups.get(i));
                    }
                    ArrayList<Integer> sect2RupsForMagBin = new ArrayList<Integer>();
                    for (int i = 0; i < sect2Rups.size(); ++i) {
                        double mag = this.rupSet.getMagForRup((Integer)sect2Rups.get(i));
                        if (!sectMFDConstraint.isMagInBin(mag, magBin)) continue;
                        sect2RupsForMagBin.add((Integer)sect2Rups.get(i));
                    }
                    ArrayList<Integer> sect3RupsForMagBin = new ArrayList<Integer>();
                    for (int i = 0; i < sect3Rups.size(); ++i) {
                        double mag = this.rupSet.getMagForRup((Integer)sect3Rups.get(i));
                        if (!sectMFDConstraint.isMagInBin(mag, magBin)) continue;
                        sect3RupsForMagBin.add((Integer)sect3Rups.get(i));
                    }
                    Iterator iterator = sect1RupsForMagBin.iterator();
                    while (iterator.hasNext()) {
                        int rup = (Integer)iterator.next();
                        this.setA(A, rowIndex, rup, this.weight);
                        ++numNonZeroElements;
                    }
                    iterator = sect2RupsForMagBin.iterator();
                    while (iterator.hasNext()) {
                        int rup = (Integer)iterator.next();
                        this.setA(A, rowIndex, rup, -this.weight);
                        ++numNonZeroElements;
                    }
                    iterator = sect3RupsForMagBin.iterator();
                    while (iterator.hasNext()) {
                        int rup = (Integer)iterator.next();
                        this.setA(A, rowIndex, rup, this.weight);
                        ++numNonZeroElements;
                    }
                    d[rowIndex] = 0.0;
                    ++rowIndex;
                }
            }
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

