/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.ArrayList;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;

public class MFDParticipationSmoothnessInversionConstraint
extends InversionConstraint {
    public static final String NAME = "MFD Participation Smoothness";
    public static final String SHORT_NAME = "MFDParticSmooth";
    private transient FaultSystemRupSet rupSet;
    private double particMagBinSize;

    public MFDParticipationSmoothnessInversionConstraint(FaultSystemRupSet rupSet, double weight, double particMagBinSize) {
        super(NAME, SHORT_NAME, weight, false);
        this.rupSet = rupSet;
        this.particMagBinSize = particMagBinSize;
    }

    @Override
    public int getNumRows() {
        int totalNumMagParticipationConstraints = 0;
        int numSections = this.rupSet.getNumSections();
        for (int sect = 0; sect < numSections; ++sect) {
            List<Integer> rupturesForSection = this.rupSet.getRupturesForSection(sect);
            double minMag = Double.POSITIVE_INFINITY;
            double maxMag = Double.NEGATIVE_INFINITY;
            for (int rupIndex = 0; rupIndex < rupturesForSection.size(); ++rupIndex) {
                double mag = this.rupSet.getMagForRup(rupturesForSection.get(rupIndex));
                minMag = Math.min(minMag, mag);
                maxMag = Math.max(maxMag, mag);
            }
            if (!Double.isFinite(minMag)) continue;
            block2: for (double m = minMag; m < maxMag; m += this.particMagBinSize) {
                for (int rupIndex = 0; rupIndex < rupturesForSection.size(); ++rupIndex) {
                    double mag = this.rupSet.getMagForRup(rupturesForSection.get(rupIndex));
                    if (!(mag >= m) || !(mag < m + this.particMagBinSize)) continue;
                    ++totalNumMagParticipationConstraints;
                    continue block2;
                }
            }
        }
        return totalNumMagParticipationConstraints;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        int numSections = this.rupSet.getNumSections();
        ArrayList<Integer> numRupsForMagBin = new ArrayList<Integer>();
        int rowIndex = startRow;
        for (int sect = 0; sect < numSections; ++sect) {
            List<Integer> rupturesForSection = this.rupSet.getRupturesForSection(sect);
            double minMag = Double.POSITIVE_INFINITY;
            double maxMag = Double.NEGATIVE_INFINITY;
            for (int rupIndex = 0; rupIndex < rupturesForSection.size(); ++rupIndex) {
                double mag = this.rupSet.getMagForRup(rupturesForSection.get(rupIndex));
                minMag = Math.min(minMag, mag);
                maxMag = Math.max(maxMag, mag);
            }
            if (!Double.isFinite(minMag)) {
                System.out.println("NO RUPTURES FOR SECTION #" + sect);
                continue;
            }
            numRupsForMagBin.clear();
            int numNonzeroMagBins = 0;
            for (double m = minMag; m < maxMag; m += this.particMagBinSize) {
                numRupsForMagBin.add(0);
                for (int rupIndex = 0; rupIndex < rupturesForSection.size(); ++rupIndex) {
                    double mag = this.rupSet.getMagForRup(rupturesForSection.get(rupIndex));
                    if (!(mag >= m) || !(mag < m + this.particMagBinSize)) continue;
                    numRupsForMagBin.set(numRupsForMagBin.size() - 1, (Integer)numRupsForMagBin.get(numRupsForMagBin.size() - 1) + 1);
                }
                if ((Integer)numRupsForMagBin.get(numRupsForMagBin.size() - 1) <= 0) continue;
                ++numNonzeroMagBins;
            }
            int magBinIndex = 0;
            for (double m = minMag; m < maxMag; m += this.particMagBinSize) {
                if ((Integer)numRupsForMagBin.get(magBinIndex) > 0) {
                    for (int rupIndex = 0; rupIndex < rupturesForSection.size(); ++rupIndex) {
                        int col = rupturesForSection.get(rupIndex);
                        double val = this.weight / (double)numNonzeroMagBins;
                        ++numNonZeroElements;
                        double mag = this.rupSet.getMagForRup(col);
                        if (mag >= m && mag < m + this.particMagBinSize) {
                            val -= this.weight;
                        }
                        this.setA(A, rowIndex, col, val);
                    }
                    d[rowIndex] = 0.0;
                    ++rowIndex;
                }
                ++magBinIndex;
            }
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

