/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.faultSurface.FaultSection;

public class ParentSectSmoothnessConstraint
extends InversionConstraint {
    private transient FaultSystemRupSet rupSet;
    private boolean slipRateAdjusted;

    public ParentSectSmoothnessConstraint(FaultSystemRupSet rupSet, double weight, boolean slipRateAdjusted) {
        super("Parent Section Smoothness", "ParentSmooth", weight, false, ConstraintWeightingType.UNNORMALIZED);
        this.rupSet = rupSet;
        this.slipRateAdjusted = slipRateAdjusted;
    }

    @Override
    public int getNumRows() {
        return this.rupSet.getNumSections();
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        Map<Integer, List<FaultSection>> parentSectsMap = this.rupSet.getFaultSectionDataList().stream().collect(Collectors.groupingBy(S -> S.getParentSectionId()));
        SectSlipRates slipRates = this.slipRateAdjusted ? this.rupSet.getSectSlipRates() : null;
        long numNonZero = 0L;
        for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
            int row = startRow + faultSection.getSectionId();
            List<FaultSection> parentSects = parentSectsMap.get(faultSection.getParentSectionId());
            HashMap<Integer, Double> rupAVals = new HashMap<Integer, Double>();
            for (int rup : this.rupSet.getRupturesForSection(faultSection.getSectionId())) {
                ParentSectSmoothnessConstraint.add(rupAVals, rup, this.weight);
            }
            ArrayList<Double> relWeights = new ArrayList<Double>();
            double sumRelWeights = 0.0;
            for (FaultSection oSect : parentSects) {
                double slip2;
                double slip1;
                double relWeight = 1.0;
                if (this.slipRateAdjusted && (slip1 = slipRates.getSlipRate(faultSection.getSectionId())) != (slip2 = slipRates.getSlipRate(oSect.getSectionId()))) {
                    relWeight *= Math.min(slip1, slip2) / Math.max(slip1, slip2);
                }
                relWeights.add(relWeight);
                sumRelWeights += relWeight;
            }
            for (int i = 0; i < parentSects.size(); ++i) {
                FaultSection oSect;
                oSect = parentSects.get(i);
                double myWeight = this.weight * (Double)relWeights.get(i) / sumRelWeights;
                for (int rup : this.rupSet.getRupturesForSection(oSect.getSectionId())) {
                    ParentSectSmoothnessConstraint.add(rupAVals, rup, -myWeight);
                }
            }
            Iterator<FaultSection> iterator = rupAVals.keySet().iterator();
            while (iterator.hasNext()) {
                int rup = (Integer)((Object)iterator.next());
                double val = (Double)rupAVals.get(rup);
                if (val == 0.0) continue;
                this.setA(A, row, rup, val);
                ++numNonZero;
            }
        }
        return numNonZero;
    }

    private static void add(Map<Integer, Double> vals, Integer key, double val) {
        Double prev = vals.get(key);
        if (prev != null) {
            val += prev.doubleValue();
        }
        vals.put(key, val);
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

