/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;

public class RupRateMinimizationConstraint
extends InversionConstraint {
    public static final String NAME = "Rupture Rate Minimization";
    public static final String SHORT_NAME = "RateMinimize";
    private List<Integer> rupIndexes;

    public RupRateMinimizationConstraint(double weight, List<Integer> rupIndexes) {
        super(NAME, SHORT_NAME, weight, false);
        this.rupIndexes = rupIndexes;
    }

    public List<Integer> getRupIndexes() {
        return this.rupIndexes;
    }

    @Override
    public int getNumRows() {
        return this.rupIndexes.size();
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        int rowIndex = startRow;
        for (int rupIndex : this.rupIndexes) {
            this.setA(A, rowIndex, rupIndex, this.weight);
            d[rowIndex] = 0.0;
            ++numNonZeroElements;
            ++rowIndex;
        }
        return numNonZeroElements;
    }
}

