/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;

public class TotalRateInversionConstraint
extends InversionConstraint {
    private transient FaultSystemRupSet rupSet;
    private double totalRateTarget;
    private double minMag;
    private double totalRateStdDev;

    public TotalRateInversionConstraint(double weight, double totalRateTarget) {
        this(weight, totalRateTarget, ConstraintWeightingType.UNNORMALIZED, 0.0);
    }

    public TotalRateInversionConstraint(double weight, double totalRateTarget, ConstraintWeightingType weightingType, double totalRateStdDev) {
        this(weight, totalRateTarget, null, 0.0, weightingType, totalRateStdDev, false);
    }

    public TotalRateInversionConstraint(double weight, double totalRateTarget, FaultSystemRupSet rupSet, double minMag, ConstraintWeightingType weightingType, double totalRateStdDev, boolean inequality) {
        super(weightingType.applyNamePrefix(TotalRateInversionConstraint.name(minMag)), weightingType.applyShortNamePrefix(TotalRateInversionConstraint.shortName(minMag)), weight, inequality, weightingType);
        this.totalRateTarget = totalRateTarget;
        this.rupSet = rupSet;
        this.minMag = minMag;
        this.totalRateStdDev = totalRateStdDev;
    }

    private static String name(double minMag) {
        if (minMag > 0.0) {
            return "M>" + new DecimalFormat("0.#").format(minMag) + " Rate";
        }
        return "Total Rate";
    }

    private static String shortName(double minMag) {
        if (minMag > 0.0) {
            return "M" + new DecimalFormat("0.#").format(minMag) + "Rate";
        }
        return "TotRate";
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        int numRuptures = A.columns();
        if (this.rupSet != null) {
            Preconditions.checkState((this.rupSet.getNumRuptures() == numRuptures ? 1 : 0) != 0);
        }
        if (this.minMag > 0.0) {
            Preconditions.checkNotNull((Object)this.rupSet, (Object)"Minimum magnitude supplied but not rupture set");
        }
        double scale = this.weightingType.getA_Scalar(this.totalRateTarget, this.totalRateStdDev);
        for (int rup = 0; rup < numRuptures; ++rup) {
            if (this.minMag > 0.0 && this.rupSet.getMagForRup(rup) < this.minMag) continue;
            this.setA(A, startRow, rup, this.weight * scale);
            ++numNonZeroElements;
        }
        d[startRow] = this.weight * this.weightingType.getD(this.totalRateTarget, this.totalRateStdDev);
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

