/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl;

import cern.colt.matrix.tdouble.DoubleMatrix2D;
import java.util.ArrayList;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.InversionConstraint;
import scratch.UCERF3.utils.U3SectionMFD_constraint;

public class U3MFDSubSectNuclInversionConstraint
extends InversionConstraint {
    public static final String NAME = "U3 Subsection Nucleation MFD";
    public static final String SHORT_NAME = "U3SectNuclMFD";
    private transient FaultSystemRupSet rupSet;
    private List<U3SectionMFD_constraint> constraints;

    public U3MFDSubSectNuclInversionConstraint(FaultSystemRupSet rupSet, double weight, List<U3SectionMFD_constraint> constraints) {
        super(NAME, SHORT_NAME, weight, false, ConstraintWeightingType.NORMALIZED);
        this.rupSet = rupSet;
        this.constraints = constraints;
    }

    public List<U3SectionMFD_constraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public int getNumRows() {
        int numRows = 0;
        for (U3SectionMFD_constraint constraint : this.constraints) {
            if (constraint == null) continue;
            for (int i = 0; i < constraint.getNumMags(); ++i) {
                if (!(constraint.getRate(i) > 0.0)) continue;
                ++numRows;
            }
        }
        return numRows;
    }

    @Override
    public long encode(DoubleMatrix2D A, double[] d, int startRow) {
        long numNonZeroElements = 0L;
        int numSections = this.rupSet.getNumSections();
        int rowIndex = startRow;
        for (int sect = 0; sect < numSections; ++sect) {
            U3SectionMFD_constraint sectMFDConstraint = this.constraints.get(sect);
            if (sectMFDConstraint == null) continue;
            int numMagBins = sectMFDConstraint.getNumMags();
            List<Integer> rupturesForSect = this.rupSet.getRupturesForSection(sect);
            for (int magBin = 0; magBin < numMagBins; ++magBin) {
                int i;
                if (!(sectMFDConstraint.getRate(magBin) > 0.0)) continue;
                ArrayList<Integer> rupturesForMagBin = new ArrayList<Integer>();
                for (i = 0; i < rupturesForSect.size(); ++i) {
                    double mag = this.rupSet.getMagForRup(rupturesForSect.get(i));
                    if (!sectMFDConstraint.isMagInBin(mag, magBin)) continue;
                    rupturesForMagBin.add(rupturesForSect.get(i));
                }
                for (i = 0; i < rupturesForMagBin.size(); ++i) {
                    int rup = (Integer)rupturesForMagBin.get(i);
                    double rupArea = this.rupSet.getAreaForRup(rup);
                    double sectArea = this.rupSet.getAreaForSection(sect);
                    this.setA(A, rowIndex, rup, this.weight * (sectArea / rupArea) / sectMFDConstraint.getRate(magBin));
                    ++numNonZeroElements;
                }
                d[rowIndex] = this.weight;
                ++rowIndex;
            }
        }
        return numNonZeroElements;
    }

    @Override
    public void setRuptureSet(FaultSystemRupSet rupSet) {
        this.rupSet = rupSet;
    }
}

