/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa;

import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.primitives.Doubles;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.Interpolate;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.inversion.InversionInputGenerator;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ColumnOrganizedAnnealingData;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SerialSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ThreadedSimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.ProgressTrackingCompletionCriteria;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfits;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.NSHM23_InvConfigFactory;
import org.opensha.sha.earthquake.rupForecastImpl.nshm23.logicTree.NSHM23_U3_HybridLogicTreeBranch;

public class ReweightEvenFitSimulatedAnnealing
extends ThreadedSimulatedAnnealing {
    public static final double MAX_INDV_ADJUSTMENT_FACTOR = 2.0;
    public static final double MAX_ADJUSTMENT_FACTOR = 100.0;
    public static final boolean PHASE_OUT_BELOW_LOWER_BOUND = true;
    public static final double PHASE_OUT_START_FACTOR = 50.0;
    public static final double PHASE_OUT_END_FACTOR = 100.0;
    public static final InversionMisfitStats.Quantity QUANTITY_DEFAULT = InversionMisfitStats.Quantity.MAD;
    public static final double AVG_TARGET_TRANSITION_UPPER_DEFAULT = Double.POSITIVE_INFINITY;
    public static final double AVG_TARGET_TRANSITION_LOWER_DEFAULT = Double.POSITIVE_INFINITY;
    public static final boolean CONSERVE_TOT_WEIGHT_DEFAULT = true;
    public static final boolean CONSERVE_SEPARATELY = false;
    public static final boolean TARGET_MEDIAN_DEFAULT = false;
    public static final boolean USE_SQRT_FOR_TARGET_RATIOS_DEFAULT = true;
    public static final boolean USE_VALUE_WEIGHTED_AVERAGE_DEFAULT = false;
    public static final boolean REMOVE_ZEROS_FOR_INEQUALITY = true;
    private static final int floatingPointDriftMod = 100;
    private static final long MIN_PRINT_DELTA_MILLIS_DEFAULT = 500L;
    private InversionMisfitStats.Quantity quantity = QUANTITY_DEFAULT;
    private boolean conserveTotalWeight = true;
    private boolean useValueWeightedAverage = false;
    private boolean targetMedian = false;
    private boolean useSqrtForTargetRatios = true;
    private String targetName = QUANTITY_DEFAULT.name();
    private double avgTargetWeight2 = Double.POSITIVE_INFINITY;
    private double avgTargetWeight1 = Double.POSITIVE_INFINITY;
    private long minPrintDeltaMillis = 500L;
    private DoubleMatrix2D origA;
    private DoubleMatrix2D origA_ineq;
    private DoubleMatrix2D modA;
    private DoubleMatrix2D modA_ineq;
    private double[] origD;
    private double[] origD_ineq;
    private double[] modD;
    private double[] modD_ineq;
    private List<ConstraintRange> origRanges;
    private double prevTarget = Double.NaN;
    private double[] prevConstraintVals = null;
    private double prevWeightConservationScalar = 1.0;
    private List<Long> iters;
    private List<Long> times;
    private List<Double> targetVals;
    private List<InversionMisfitStats> iterStats;
    private long prevPrintTime = 0L;
    private boolean printEnabled;
    private static final DecimalFormat fiveDigits = new DecimalFormat("0.00000");
    private static final DecimalFormat oDF = new DecimalFormat("0.##");

    public ReweightEvenFitSimulatedAnnealing(SimulatedAnnealing sa, CompletionCriteria subCompetionCriteria) {
        this(List.of(sa), subCompetionCriteria, false, QUANTITY_DEFAULT);
    }

    public ReweightEvenFitSimulatedAnnealing(SimulatedAnnealing sa, CompletionCriteria subCompetionCriteria, InversionMisfitStats.Quantity quantity) {
        this(List.of(sa), subCompetionCriteria, false, quantity);
    }

    public ReweightEvenFitSimulatedAnnealing(List<? extends SimulatedAnnealing> sas, CompletionCriteria subCompetionCriteria, boolean average) {
        this(sas, subCompetionCriteria, average, QUANTITY_DEFAULT);
    }

    public ReweightEvenFitSimulatedAnnealing(List<? extends SimulatedAnnealing> sas, CompletionCriteria subCompetionCriteria, boolean average, InversionMisfitStats.Quantity quantity) {
        super(sas, subCompetionCriteria, average);
        this.setConstraintRanges(sas.get(0).getConstraintRanges());
        this.setTargetQuantity(quantity);
    }

    public ReweightEvenFitSimulatedAnnealing(ThreadedSimulatedAnnealing tsa) {
        this(tsa, QUANTITY_DEFAULT);
    }

    public ReweightEvenFitSimulatedAnnealing(ThreadedSimulatedAnnealing tsa, InversionMisfitStats.Quantity quantity) {
        super(tsa.getSAs(), tsa.getSubCompetionCriteria(), tsa.isAverage());
        this.setConstraintRanges(tsa.getConstraintRanges());
        this.setTargetQuantity(quantity);
    }

    public void setTargetQuantity(InversionMisfitStats.Quantity quantity) {
        Preconditions.checkNotNull((Object)((Object)quantity));
        this.quantity = quantity;
        this.targetName = quantity.name();
    }

    public void setMinPrintDeltaMillis(long minPrintDeltaMillis) {
        this.minPrintDeltaMillis = minPrintDeltaMillis;
    }

    private List<InversionMisfitStats.MisfitStats> calcUncertWtStats(List<ConstraintRange> ranges, double[] misfits, double[] misfits_ineq) {
        ArrayList<InversionMisfitStats.MisfitStats> stats = new ArrayList<InversionMisfitStats.MisfitStats>();
        for (ConstraintRange range : ranges) {
            InversionMisfitStats.MisfitStats myStats = null;
            if (range.weightingType == ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) {
                double[] myMisfits = range.inequality ? misfits_ineq : misfits;
                myMisfits = Arrays.copyOfRange(myMisfits, range.startRow, range.endRow);
                int i = 0;
                while (i < myMisfits.length) {
                    int n = i++;
                    myMisfits[n] = myMisfits[n] / range.weight;
                }
                if (range.inequality) {
                    int numZero = 0;
                    int numNonZero = 0;
                    for (int i2 = 0; i2 < myMisfits.length; ++i2) {
                        if (myMisfits[i2] == 0.0) {
                            ++numZero;
                            continue;
                        }
                        ++numNonZero;
                    }
                    if (numZero > 0 && numNonZero > 0) {
                        double[] modMisfits = new double[numNonZero];
                        int index = 0;
                        for (int i3 = 0; i3 < myMisfits.length; ++i3) {
                            if (!(myMisfits[i3] > 0.0)) continue;
                            modMisfits[index++] = myMisfits[i3];
                        }
                        Preconditions.checkState((index == numNonZero ? 1 : 0) != 0);
                        myMisfits = modMisfits;
                        range = new ConstraintRange(range.name, range.shortName, range.startRow, range.startRow + numNonZero, range.inequality, range.weight, range.weightingType);
                    }
                }
                myStats = new InversionMisfitStats.MisfitStats(myMisfits, range);
            }
            stats.add(myStats);
        }
        return stats;
    }

    @Override
    protected void beforeRound(InversionState state, int round) {
        this.beforeRound(state, round, false);
    }

    protected double beforeRound(InversionState state, int round, boolean targetOnly) {
        double target;
        boolean verbose = this.isVerbose();
        if (round > 0) {
            boolean scaleToOrig;
            Stopwatch watch = Stopwatch.createStarted();
            List<ConstraintRange> ranges = this.getConstraintRanges();
            Preconditions.checkNotNull(ranges, (Object)"Constraint ranges must be set for re-weight inversion");
            Preconditions.checkState((ranges.size() == this.origRanges.size() ? 1 : 0) != 0);
            Preconditions.checkState((!this.targetMedian || !this.useValueWeightedAverage ? 1 : 0) != 0, (Object)"Can't have both value weighting and median enabled");
            if (this.modA == null) {
                this.modA = this.origA.copy();
                this.modD = Arrays.copyOf(this.origD, this.origD.length);
                if (this.origA_ineq != null) {
                    this.modA_ineq = this.origA_ineq.copy();
                    this.modD_ineq = Arrays.copyOf(this.origD_ineq, this.origD_ineq.length);
                }
            }
            double[] misfits = this.getBestMisfit();
            double[] misfits_ineq = this.getBestInequalityMisfit();
            List<InversionMisfitStats.MisfitStats> stats = this.calcUncertWtStats(ranges, misfits, misfits_ineq);
            int numConstraints = 0;
            int numValues = 0;
            ArrayList<Double> constraintTargetVals = new ArrayList<Double>();
            ArrayList<Double> phaseOutStatuses = new ArrayList<Double>();
            boolean hasPhaseOut = false;
            for (int r = 0; r < ranges.size(); ++r) {
                ConstraintRange range = ranges.get(r);
                InversionMisfitStats.MisfitStats myStats = stats.get(r);
                if (myStats == null) continue;
                double myVal = myStats.get(this.quantity);
                constraintTargetVals.add(myVal);
                ++numConstraints;
                int myNumVals = range.endRow - range.startRow;
                numValues += myNumVals;
                double origWeight = this.origRanges.get((int)r).weight;
                double phaseUpperTarget = origWeight / 50.0;
                double phaseLowerTarget = origWeight / 100.0;
                double status = range.weight < phaseLowerTarget ? 0.0 : (range.weight < phaseUpperTarget ? (range.weight - phaseLowerTarget) / (phaseUpperTarget - phaseLowerTarget) : 1.0);
                hasPhaseOut = hasPhaseOut || status != 1.0;
                phaseOutStatuses.add(status);
            }
            if (hasPhaseOut) {
                boolean allPhasedBelow;
                do {
                    if (this.targetMedian) {
                        List pairings = ComparablePairing.build(constraintTargetVals, phaseOutStatuses);
                        Collections.sort(pairings);
                        double sumWeights = 0.0;
                        Iterator myVal = phaseOutStatuses.iterator();
                        while (myVal.hasNext()) {
                            double status = (Double)myVal.next();
                            sumWeights += status;
                        }
                        Preconditions.checkState((sumWeights >= 1.0 ? 1 : 0) != 0, (Object)"All constraints phased out?");
                        double weightBelow = 0.0;
                        int indexAbove = -1;
                        for (int i = 0; i < pairings.size(); ++i) {
                            ComparablePairing pairing = pairings.get(i);
                            if (weightBelow >= 0.5 * sumWeights) {
                                indexAbove = i;
                                break;
                            }
                            weightBelow += ((Double)pairing.getData()).doubleValue();
                        }
                        Preconditions.checkState((indexAbove > 0 ? 1 : 0) != 0);
                        double val1 = (Double)pairings.get(indexAbove - 1).getComparable();
                        double weight1 = weightBelow;
                        double val2 = (Double)pairings.get(indexAbove).getComparable();
                        double weight2 = weightBelow + (Double)pairings.get(indexAbove).getData();
                        Preconditions.checkState((weight1 <= 0.5 && weight2 >= 0.5 ? 1 : 0) != 0);
                        target = Interpolate.findY(weight1, val1, weight2, val2, 0.5);
                    } else {
                        double numerator = 0.0;
                        double denominator = 0.0;
                        for (int i = 0; i < constraintTargetVals.size(); ++i) {
                            double val = (Double)constraintTargetVals.get(i);
                            double status = (Double)phaseOutStatuses.get(i);
                            numerator += val * status;
                            denominator += status;
                        }
                        target = numerator / denominator;
                    }
                    allPhasedBelow = true;
                    for (int i = 0; i < constraintTargetVals.size(); ++i) {
                        double val = (Double)constraintTargetVals.get(i);
                        double status = (Double)phaseOutStatuses.get(i);
                        if (!(status < 1.0) || !(val > target)) continue;
                        if (verbose) {
                            System.out.println("Un-phasing a constraint with status=" + (float)status + " but " + this.targetName + "=" + (float)val + " > " + target);
                        }
                        allPhasedBelow = false;
                        phaseOutStatuses.set(i, 1.0);
                    }
                } while (!allPhasedBelow);
            } else {
                target = this.targetMedian ? DataUtils.median(Doubles.toArray(constraintTargetVals)) : StatUtils.mean((double[])Doubles.toArray(constraintTargetVals));
            }
            if (targetOnly) {
                if (verbose) {
                    System.out.println("Final target value: " + (float)target);
                }
                return target;
            }
            String qStr = "Readjusting weights for " + numValues + " values across " + numConstraints + " uncertainty-weighted constraints with " + (this.targetMedian ? "median" : "average") + " misfit " + this.targetName + ":\t" + (float)target;
            if (round > 1) {
                double diff = target - this.prevTarget;
                qStr = qStr + " (";
                if (diff > 0.0) {
                    qStr = qStr + "+";
                }
                qStr = qStr + pDF.format(diff / this.prevTarget) + ")";
            }
            this.prevTarget = target;
            if (verbose) {
                System.out.println(qStr);
            }
            Preconditions.checkState((numConstraints > 0 ? 1 : 0) != 0, (Object)"Can't use re-weighted inversion without any uncertainty-weighted constraints!");
            Preconditions.checkState((target > 0.0 && Double.isFinite(target) ? 1 : 0) != 0, (String)("Bad avg " + this.targetName + ": %s"), (Object)target);
            double[] origValScalars = new double[misfits.length];
            double[] origValScalars_ineq = misfits_ineq == null ? null : new double[misfits_ineq.length];
            double origTotalWeight = 0.0;
            double newTotalWeight = 0.0;
            double[] newWeights = new double[ranges.size()];
            double conservableTotalWeight = 0.0;
            boolean[] conservableWeights = new boolean[ranges.size()];
            boolean bl = scaleToOrig = round > 0 && round % 100 == 0;
            if (this.prevConstraintVals == null) {
                this.prevConstraintVals = new double[ranges.size()];
            }
            for (int i = 0; i < ranges.size(); ++i) {
                double scalar;
                double newWeight;
                ConstraintRange range = ranges.get(i);
                InversionMisfitStats.MisfitStats myStats = stats.get(i);
                double prevWeight = range.weight;
                double origWeight = this.origRanges.get((int)i).weight;
                if (this.conserveTotalWeight) {
                    // empty if block
                }
                if (myStats == null) {
                    newWeight = Double.NaN;
                    scalar = 1.0;
                } else {
                    double myTarget = myStats.get(this.quantity);
                    int rangeRows = range.endRow - range.startRow;
                    origTotalWeight += (double)rangeRows * origWeight;
                    double misfitRatio = this.useSqrtForTargetRatios ? Math.sqrt(myTarget) / Math.sqrt(target) : myTarget / target;
                    misfitRatio = Math.max(misfitRatio, 0.5);
                    misfitRatio = Math.min(misfitRatio, 2.0);
                    double calcWeight = misfitRatio * prevWeight;
                    boolean bounded = false;
                    boolean phased = false;
                    String phaseStr = null;
                    if (calcWeight < origWeight) {
                        double status;
                        double phaseUpperTarget = origWeight / 50.0;
                        double phaseLowerTarget = origWeight / 100.0;
                        if ((float)calcWeight <= (float)phaseLowerTarget) {
                            status = 0.0;
                            newWeight = phaseLowerTarget;
                        } else if ((float)calcWeight < (float)phaseUpperTarget) {
                            status = (calcWeight - phaseLowerTarget) / (phaseUpperTarget - phaseLowerTarget);
                            newWeight = calcWeight;
                        } else {
                            status = 1.0;
                            newWeight = calcWeight;
                        }
                        boolean bl2 = phased = status != 1.0;
                        if (phased) {
                            phaseStr = status == 0.0 ? "FULLY PHASED OUT: " + (float)phaseLowerTarget : "phasing out (f=" + oDF.format(status) + ")";
                        }
                    } else {
                        newWeight = Math.max(calcWeight, origWeight / 100.0);
                        bounded = (newWeight = Math.min(newWeight, origWeight * 100.0)) != calcWeight;
                    }
                    conservableWeights[i] = !bounded && !phased;
                    String targetStr = fiveDigits.format(myTarget);
                    if (round > 1) {
                        double diff = myTarget - this.prevConstraintVals[i];
                        targetStr = targetStr + " (";
                        if (diff > 0.0) {
                            targetStr = targetStr + "+";
                        }
                        targetStr = targetStr + pDF.format(diff / this.prevConstraintVals[i]) + ")";
                    }
                    if (verbose) {
                        System.out.println("\t" + range.shortName + ":\t" + this.targetName + ": " + targetStr + ";\tcalcWeight = " + fiveDigits.format(prevWeight) + " x " + fiveDigits.format(misfitRatio) + " = " + fiveDigits.format(calcWeight) + (String)(bounded ? ";\tbounded: " + (float)newWeight : "") + (String)(phased ? ";\t" + phaseStr : ""));
                    }
                    if (target > this.avgTargetWeight2) {
                        newWeight = origWeight;
                        if (verbose) {
                            System.out.println("\t\tAbove max target, reverting to original weight: " + (float)origWeight);
                        }
                    } else if (target > this.avgTargetWeight1) {
                        double fract = (target - this.avgTargetWeight1) / (this.avgTargetWeight2 - this.avgTargetWeight1);
                        Preconditions.checkState((fract >= 0.0 && fract <= 1.0 ? 1 : 0) != 0);
                        newWeight = origWeight * fract + newWeight * (1.0 - fract);
                        if (verbose) {
                            System.out.println("\t\tTarget value is poorly fit, linearly blending (fract=" + (float)fract + ") calculated weight with orig: " + (float)newWeight);
                        }
                    }
                    this.prevConstraintVals[i] = myTarget;
                    newTotalWeight += (double)rangeRows * newWeight;
                    if (conservableWeights[i]) {
                        conservableTotalWeight += (double)rangeRows * newWeight;
                    }
                    if (scaleToOrig) {
                        scalar = newWeight / origWeight;
                    } else {
                        if (this.conserveTotalWeight) {
                            // empty if block
                        }
                        scalar = newWeight / prevWeight;
                    }
                }
                double[] myScalars = range.inequality ? origValScalars_ineq : origValScalars;
                for (int r = range.startRow; r < range.endRow; ++r) {
                    myScalars[r] = scalar;
                }
                newWeights[i] = newWeight;
            }
            if (this.conserveTotalWeight) {
                if (conservableTotalWeight == 0.0) {
                    if (verbose) {
                        System.out.println("Conservable total weight is zero, everything is bounded or phased, skipping conserve step");
                    }
                    this.prevWeightConservationScalar = 1.0;
                } else {
                    double fixedWeight = newTotalWeight - conservableTotalWeight;
                    double weightScalar = (origTotalWeight - fixedWeight) / conservableTotalWeight;
                    if (verbose) {
                        System.out.println("Re-scaling weights by " + (float)(origTotalWeight - fixedWeight) + " / " + (float)newTotalWeight + " = " + (float)weightScalar + " to conserve original total weight");
                    }
                    String weightsStr = null;
                    for (int i = 0; i < newWeights.length; ++i) {
                        if (!Double.isFinite(newWeights[i])) continue;
                        if (conservableWeights[i]) {
                            int n = i;
                            newWeights[n] = newWeights[n] * weightScalar;
                            ConstraintRange range = ranges.get(i);
                            double[] myScalars = range.inequality ? origValScalars_ineq : origValScalars;
                            int r = range.startRow;
                            while (r < range.endRow) {
                                int n2 = r++;
                                myScalars[n2] = myScalars[n2] * weightScalar;
                            }
                        }
                        weightsStr = weightsStr == null ? "" + (float)newWeights[i] : weightsStr + ", " + (float)newWeights[i];
                    }
                    if (verbose) {
                        System.out.println("\tAdjusted weights: " + weightsStr);
                    }
                    this.prevWeightConservationScalar = weightScalar;
                }
            }
            if (verbose) {
                System.out.println("Updating matrices");
            }
            if (scaleToOrig && verbose) {
                System.out.println("\tRescaling relative to original values in order to correct any floating-point drift, may take slighly longer (this is done every 100 rounds)");
            }
            ReweightEvenFitSimulatedAnnealing.reweight(origValScalars, scaleToOrig, this.origA, this.modA, this.origD, this.modD);
            if (misfits_ineq != null) {
                ReweightEvenFitSimulatedAnnealing.reweight(origValScalars_ineq, scaleToOrig, this.origA_ineq, this.modA_ineq, this.origD_ineq, this.modD_ineq);
            }
            ArrayList<ConstraintRange> modRanges = new ArrayList<ConstraintRange>();
            for (int i = 0; i < ranges.size(); ++i) {
                ConstraintRange range = ranges.get(i);
                if (stats.get(i) == null) {
                    modRanges.add(range);
                    continue;
                }
                modRanges.add(new ConstraintRange(range.name, range.shortName, range.startRow, range.endRow, range.inequality, newWeights[i], range.weightingType));
            }
            if (verbose) {
                System.out.println("Re-calculating misfits");
            }
            double[] xbest = this.getBestSolution();
            double[] misfit = new double[this.modD.length];
            SerialSimulatedAnnealing.calculateMisfit(this.modA, this.modD, xbest, misfit);
            double[] misfit_ineq = null;
            int nRow = this.modA.rows();
            int nCol = this.modA.columns();
            int ineqRows = 0;
            ColumnOrganizedAnnealingData modEqualityData = new ColumnOrganizedAnnealingData(this.modA, this.modD);
            ColumnOrganizedAnnealingData modInqualityData = null;
            if (this.modA_ineq != null) {
                modInqualityData = new ColumnOrganizedAnnealingData(this.modA_ineq, this.modD_ineq);
                misfit_ineq = new double[this.modD_ineq.length];
                ineqRows = misfit_ineq.length;
                SerialSimulatedAnnealing.calculateMisfit(this.modA_ineq, this.modD_ineq, xbest, misfit_ineq);
            }
            if (verbose) {
                System.out.println("Re-calculating energies");
            }
            double[] Ebest = SerialSimulatedAnnealing.calculateEnergy(xbest, misfit, misfit_ineq, nRow, nCol, ineqRows, ranges, 0.0);
            double prevE = this.getBestEnergy()[0];
            double newE = Ebest[0];
            String eStr = "\torigE=" + (float)prevE + ", newE=" + newE;
            double diffE = newE - prevE;
            eStr = eStr + " (";
            if (diffE > 0.0) {
                eStr = eStr + "+";
            }
            eStr = eStr + pDF.format(diffE / prevE) + ")";
            if (verbose) {
                System.out.println(eStr);
            }
            this.setAll(modEqualityData, modInqualityData, Ebest, xbest, misfit, misfit_ineq, this.getNumNonZero());
            this.setConstraintRanges(modRanges);
            watch.stop();
            Preconditions.checkNotNull(this.iters);
            Preconditions.checkNotNull(this.times);
            Preconditions.checkNotNull(this.iterStats);
            ArrayList<InversionMisfitStats.MisfitStats> uncertMisfits = new ArrayList<InversionMisfitStats.MisfitStats>();
            for (InversionMisfitStats.MisfitStats mstats : stats) {
                if (mstats == null) continue;
                uncertMisfits.add(mstats);
            }
            this.iters.add(state.iterations);
            this.times.add(state.elapsedTimeMillis);
            this.targetVals.add(target);
            this.iterStats.add(new InversionMisfitStats(uncertMisfits));
            if (verbose) {
                System.out.println("Took " + ReweightEvenFitSimulatedAnnealing.timeStr(watch.elapsed(TimeUnit.MILLISECONDS)) + " to re-weight");
            }
        } else {
            target = Double.NaN;
        }
        super.beforeRound(state, round);
        return target;
    }

    @Override
    protected void afterRound(InversionState prevState, InversionState newState, int rounds) {
        if (this.printEnabled && this.minPrintDeltaMillis > 0L) {
            boolean verbose;
            long curTime = System.currentTimeMillis();
            long delta = curTime - this.prevPrintTime;
            boolean bl = verbose = delta >= this.minPrintDeltaMillis;
            if (verbose) {
                this.prevPrintTime = curTime;
            } else if (this.isVerbose()) {
                System.out.println("Suppressing print output, minPrintDeltaMillis=" + this.minPrintDeltaMillis + " ms, curDelta=" + delta + " ms. Override with setMinPrintDeltaMillis(...).");
            }
            this.setVerbose(verbose);
        }
    }

    public InversionMisfitProgress getMisfitProgress() {
        Preconditions.checkNotNull(this.iters);
        return new InversionMisfitProgress(this.iters, this.times, this.iterStats, this.quantity, this.targetVals);
    }

    private static void reweight(final double[] scalars, final boolean scaleToOrig, final DoubleMatrix2D origA, DoubleMatrix2D modA, double[] origD, double[] modD) {
        for (int r = 0; r < scalars.length; ++r) {
            modD[r] = scaleToOrig ? origD[r] * scalars[r] : modD[r] * scalars[r];
        }
        modA.forEachNonZero(new IntIntDoubleFunction(){

            public double apply(int row, int col, double val) {
                if (scaleToOrig) {
                    return origA.get(row, col) * scalars[row];
                }
                return val * scalars[row];
            }
        });
    }

    @Override
    public InversionState iterate(InversionState startState, CompletionCriteria criteria) {
        this.origA = this.getA();
        this.origA_ineq = this.getA_ineq();
        this.origD = this.getD();
        this.origD_ineq = this.getD_ineq();
        this.printEnabled = this.isVerbose();
        this.prevPrintTime = System.currentTimeMillis() - 2L * this.minPrintDeltaMillis;
        this.origRanges = this.getConstraintRanges();
        this.prevWeightConservationScalar = 1.0;
        Preconditions.checkNotNull(this.origRanges, (Object)"Re-weigted inversion needs constraint ranges");
        this.origRanges = new ArrayList<ConstraintRange>(this.origRanges);
        boolean found = false;
        for (ConstraintRange range : this.origRanges) {
            if (range.weightingType != ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) continue;
            found = true;
            break;
        }
        Preconditions.checkState((boolean)found, (Object)"Must supply at least 1 uncertainty-weighted constraint for re-weighted inversion");
        this.iters = new ArrayList<Long>();
        this.times = new ArrayList<Long>();
        this.targetVals = new ArrayList<Double>();
        this.iterStats = new ArrayList<InversionMisfitStats>();
        InversionState ret = super.iterate(startState, criteria);
        this.setVerbose(this.printEnabled);
        List<InversionMisfitStats.MisfitStats> stats = this.calcUncertWtStats(this.getConstraintRanges(), this.getBestMisfit(), this.getBestInequalityMisfit());
        ArrayList<InversionMisfitStats.MisfitStats> uncertMisfits = new ArrayList<InversionMisfitStats.MisfitStats>();
        this.iters.add(ret.iterations);
        this.times.add(ret.elapsedTimeMillis);
        this.targetVals.add(this.beforeRound(ret, this.iters.size() + 1, true));
        this.iterStats.add(new InversionMisfitStats(uncertMisfits));
        if (this.printEnabled) {
            double avgMisfit = 0.0;
            for (InversionMisfitStats.MisfitStats mstats : stats) {
                if (mstats == null) continue;
                uncertMisfits.add(mstats);
                avgMisfit += mstats.get(this.quantity);
            }
            System.out.println("Final constraint weights with average misfit " + this.targetName + ": " + (float)(avgMisfit /= (double)uncertMisfits.size()));
            List<ConstraintRange> modRanges = this.getConstraintRanges();
            for (int i = 0; i < modRanges.size(); ++i) {
                ConstraintRange orig = this.origRanges.get(i);
                ConstraintRange mod = modRanges.get(i);
                if (orig.weightingType != ConstraintWeightingType.NORMALIZED_BY_UNCERTAINTY) continue;
                double ratio = mod.weight / orig.weight;
                System.out.println("\t" + orig.shortName + "\t" + this.targetName + ": " + (float)stats.get(i).get(this.quantity) + ";\tWeight = " + (float)orig.weight + " x " + (float)ratio + " = " + (float)mod.weight);
            }
        }
        return ret;
    }

    public static void main(String[] args) {
        File outputDir;
        FaultSystemRupSet rupSet;
        File parentDir = new File("/home/kevin/markdown/inversions");
        Object dirName = new SimpleDateFormat("yyyy_MM_dd").format(new Date());
        NSHM23_InvConfigFactory factory = new NSHM23_InvConfigFactory();
        dirName = (String)dirName + "-nshm23-cluster_specific";
        NSHM23_U3_HybridLogicTreeBranch branch = NSHM23_U3_HybridLogicTreeBranch.DEFAULT;
        try {
            rupSet = factory.buildRuptureSet(branch, 32);
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
        System.out.println("Slip along: " + rupSet.getModule(SlipAlongRuptureModel.class).getName());
        InversionConfiguration config = factory.buildInversionConfig(rupSet, branch, 16);
        boolean reweight = false;
        if (reweight) {
            dirName = (String)dirName + "-conserve";
        }
        CompletionCriteria completion = null;
        CompletionCriteria avgCompletion = null;
        InversionConfiguration.Builder builder = InversionConfiguration.builder(config);
        if (completion != null) {
            builder.completion(completion);
        }
        if (avgCompletion != null) {
            builder.avgThreads(4, avgCompletion);
        }
        if (!reweight) {
            builder.reweight(null);
        } else {
            builder.reweight();
        }
        config = builder.build();
        if (completion == null) {
            completion = config.getCompletionCriteria();
        }
        InversionInputGenerator inputs = new InversionInputGenerator(rupSet, config);
        inputs.generateInputs(true);
        inputs.columnCompress();
        ProgressTrackingCompletionCriteria progress = new ProgressTrackingCompletionCriteria(completion);
        SimulatedAnnealing sa = config.buildSA(inputs);
        if (sa instanceof SerialSimulatedAnnealing) {
            sa.setConstraintRanges(null);
        }
        sa.setRandom(new Random(1234L));
        System.out.println("SA Parameters:");
        System.out.println("\tImplementation: " + sa.getClass().getName());
        System.out.println("\tCompletion Criteria: " + String.valueOf(completion));
        System.out.println("\tPerturbation Function: " + String.valueOf((Object)sa.getPerturbationFunc()));
        System.out.println("\tNon-Negativity Constraint: " + String.valueOf((Object)sa.getNonnegativeityConstraintAlgorithm()));
        System.out.println("\tCooling Schedule: " + String.valueOf((Object)sa.getCoolingFunc()));
        if (sa instanceof ThreadedSimulatedAnnealing) {
            ThreadedSimulatedAnnealing tsa = (ThreadedSimulatedAnnealing)sa;
            System.out.println("\tTop-Level Threads: " + tsa.getNumThreads());
            System.out.println("\tSub-Completion Criteria: " + String.valueOf(tsa.getSubCompetionCriteria()));
            System.out.println("\tAveraging? " + tsa.isAverage());
        }
        System.out.println("Annealing!");
        sa.iterate(progress);
        System.out.println("DONE. Building solution...");
        double[] rawSol = sa.getBestSolution();
        double[] rates = inputs.adjustSolutionForWaterLevel(rawSol);
        FaultSystemSolution sol = new FaultSystemSolution(rupSet, rates);
        sol.addModule(progress.getProgress());
        sol.addModule(config);
        InversionMisfits misfits = new InversionMisfits(sa);
        sol.addModule(misfits);
        sol.addModule(misfits.getMisfitStats());
        if (reweight) {
            sol.addModule(((ReweightEvenFitSimulatedAnnealing)sa).getMisfitProgress());
        }
        Preconditions.checkState(((outputDir = new File(parentDir, (String)dirName)).exists() || outputDir.mkdir() ? 1 : 0) != 0);
        try {
            sol.write(new File(outputDir, "solution.zip"));
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }
}

