/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion;

import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.InversionState;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.CompletionCriteria;

public class TimeCompletionCriteria
implements CompletionCriteria.EstimationCompletionCriteria {
    private long millis;

    public TimeCompletionCriteria(long millis) {
        this.millis = millis;
    }

    @Override
    public boolean isSatisfied(InversionState state) {
        return state.elapsedTimeMillis >= this.millis;
    }

    public String toString() {
        return "TimeCompletionCriteria(milis: " + this.millis + " = " + (float)((double)this.millis / 1000.0) + " seconds)";
    }

    public long getMillis() {
        return this.millis;
    }

    public static TimeCompletionCriteria getInSeconds(long secs) {
        return new TimeCompletionCriteria(secs * 1000L);
    }

    public static TimeCompletionCriteria getInMinutes(long mins) {
        return TimeCompletionCriteria.getInSeconds(mins * 60L);
    }

    public static TimeCompletionCriteria getInHours(long hours) {
        return TimeCompletionCriteria.getInMinutes(hours * 60L);
    }

    public String getTimeStr() {
        return TimeCompletionCriteria.getTimeStr(this.millis);
    }

    public static String getTimeStr(long millis) {
        if (millis % 1000L != 0L) {
            return millis + "mi";
        }
        long secs = millis / 1000L;
        if (secs % 60L != 0L) {
            return secs + "s";
        }
        long mins = secs / 60L;
        if (mins % 60L != 0L) {
            return mins + "m";
        }
        long hours = mins / 60L;
        return hours + "h";
    }

    public static TimeCompletionCriteria fromTimeString(String str) {
        return new TimeCompletionCriteria(TimeCompletionCriteria.parseTimeString(str));
    }

    public static long parseTimeString(String str) {
        if (str.endsWith("h")) {
            str = str.substring(0, str.length() - 1);
            return Long.parseLong(str) * 60L * 60L * 1000L;
        }
        if (str.endsWith("m")) {
            str = str.substring(0, str.length() - 1);
            return Long.parseLong(str) * 60L * 1000L;
        }
        if (str.endsWith("s")) {
            str = str.substring(0, str.length() - 1);
            return Long.parseLong(str) * 1000L;
        }
        if (str.endsWith("mi")) {
            str = str.substring(0, str.length() - 2);
        }
        return Long.parseLong(str);
    }

    @Override
    public double estimateFractCompleted(InversionState state) {
        return Math.min(1.0, (double)state.elapsedTimeMillis / (double)this.millis);
    }

    @Override
    public long estimateTimeLeft(InversionState state) {
        return Long.max(0L, this.millis - state.elapsedTimeMillis);
    }
}

