/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.ModuleHelper;
import org.opensha.commons.util.modules.helpers.FileBackedModule;

@ModuleHelper
public abstract class AbstractLogicTreeModule
implements ArchivableModule {
    private ArchiveInput input;
    private String prefix;
    private LogicTree<?> logicTree;
    private List<LogicTreeLevel<?>> levels;
    private Map<LogicTreeLevel<?>, Integer> levelIndexes;
    protected boolean verbose;
    public static final String LOGIC_TREE_FILE_NAME = "logic_tree.json";
    public static final String LOGIC_TREE_MAPPINGS_FILE_NAME = "logic_tree_mappings.json";
    private Map<String, List<? extends LogicTreeLevel<?>>> levelsCache = new HashMap();

    protected AbstractLogicTreeModule(ArchiveInput input, String prefix, LogicTree<?> logicTree) {
        this.input = input;
        this.prefix = prefix;
        this.setLogicTree(logicTree);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected abstract String getSubDirectoryName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<? extends LogicTreeLevel<?>> getLevelsAffectingFile(String fileName, boolean affectedByDefault) {
        Map<String, List<? extends LogicTreeLevel<?>>> map = this.levelsCache;
        synchronized (map) {
            if (this.levelsCache.containsKey(fileName)) {
                List<? extends LogicTreeLevel<?>> mappingLevels = this.levelsCache.get(fileName);
            } else {
                List<? extends LogicTreeLevel<?>> mappingLevels = AbstractLogicTreeModule.getLevelsAffectingFile(fileName, affectedByDefault, this.levels);
                if (mappingLevels == null) {
                    if (this.verbose) {
                        System.out.println("no levels specified for file '" + fileName + "', assuming it's affected by all levels");
                    }
                    mappingLevels = this.logicTree.getLevels();
                }
                this.levelsCache.put(fileName, mappingLevels);
            }
        }
        return AbstractLogicTreeModule.getLevelsAffectingFile(fileName, affectedByDefault, this.levels);
    }

    public static List<? extends LogicTreeLevel<?>> getLevelsAffectingFile(String fileName, boolean affectedByDefault, List<LogicTreeLevel<?>> branchLevels) {
        ArrayList levels = new ArrayList();
        for (LogicTreeLevel<?> level : branchLevels) {
            if (!level.affects(fileName, affectedByDefault)) continue;
            levels.add(level);
        }
        return levels;
    }

    protected String getBranchFileName(LogicTreeBranch<?> branch, String fileName, boolean affectedByDefault) {
        return this.getBranchFileName(branch, this.prefix, fileName, affectedByDefault);
    }

    protected String getBranchFileName(LogicTreeBranch<?> branch, String fileName, List<? extends LogicTreeLevel<?>> mappingLevels) {
        return this.getBranchFileName(branch, this.prefix, fileName, mappingLevels);
    }

    protected String getBranchFileName(LogicTreeBranch<?> branch, String prefix, String fileName, boolean affectedByDefault) {
        return this.getRecordBranchFileName(branch, prefix, fileName, affectedByDefault, null);
    }

    protected String getRecordBranchFileName(LogicTreeBranch<?> branch, String prefix, String fileName, boolean affectedByDefault, Map<String, String> mappingTracker) {
        List<? extends LogicTreeLevel<?>> mappingLevels = this.getLevelsAffectingFile(fileName, affectedByDefault);
        return this.getRecordBranchFileName(branch, prefix, fileName, mappingLevels, mappingTracker);
    }

    protected String getBranchFileName(LogicTreeBranch<?> branch, String prefix, String fileName, List<? extends LogicTreeLevel<?>> mappingLevels) {
        return this.getRecordBranchFileName(branch, prefix, fileName, mappingLevels, null);
    }

    protected String getRecordBranchFileName(LogicTreeBranch<?> branch, String prefix, String fileName, List<? extends LogicTreeLevel<?>> mappingLevels, Map<String, String> mappingTracker) {
        String retStr;
        if (branch == null) {
            retStr = ArchivableModule.getEntryName(prefix, fileName);
        } else {
            StringBuilder ret = new StringBuilder(prefix);
            Preconditions.checkNotNull(mappingLevels, (String)"No mappings available for %", (Object)fileName);
            for (LogicTreeLevel<?> level : mappingLevels) {
                int levelIndex = this.levelIndexes.get(level);
                Object value = branch.getValue(levelIndex);
                Preconditions.checkNotNull(value, (String)"Branch does not have value for %s, needed to retrieve %s", (Object)level.getName(), (Object)fileName);
                ret.append(value.getFilePrefix()).append("/");
            }
            ret.append(fileName);
            retStr = ret.toString();
        }
        if (mappingTracker != null) {
            mappingTracker.put(fileName, retStr);
        }
        return retStr;
    }

    protected String buildPrefix(String upstreamPrefix) {
        if (upstreamPrefix == null) {
            upstreamPrefix = "";
        }
        return upstreamPrefix + this.getSubDirectoryName() + "/";
    }

    protected void setLogicTree(LogicTree<?> logicTree) {
        if (logicTree == null) {
            return;
        }
        this.logicTree = logicTree;
        this.setLogicTreeLevels((List<? extends LogicTreeLevel<?>>)logicTree.getLevels());
    }

    protected void setLogicTreeLevels(List<? extends LogicTreeLevel<?>> levels) {
        if (levels == null) {
            return;
        }
        this.levels = new ArrayList(levels);
        this.levelIndexes = new HashMap();
        for (int i = 0; i < levels.size(); ++i) {
            this.levelIndexes.put(levels.get(i), i);
        }
        Preconditions.checkState((this.levelIndexes.size() == levels.size() ? 1 : 0) != 0);
    }

    public LogicTree<?> getLogicTree() {
        return this.logicTree;
    }

    protected abstract Map<String, String> writeBranchFilesToArchive(ArchiveOutput var1, String var2, LogicTreeBranch<?> var3, HashSet<String> var4) throws IOException;

    protected String getFilePrefix() {
        Preconditions.checkNotNull((Object)this.prefix, (Object)"Not yet initialized");
        return this.prefix;
    }

    protected void setArchiveInput(ArchiveInput input) {
        this.input = input;
    }

    protected ArchiveInput getArchiveInput() {
        Preconditions.checkNotNull((Object)this.input, (Object)"Not yet initialized");
        return this.input;
    }

    protected void writeLogicTreeToArchive(ArchiveOutput output, String prefix, LogicTree<?> logicTree) throws IOException {
        if (this.verbose) {
            System.out.println("Writing full logic tree");
        }
        FileBackedModule.initEntry(output, prefix, LOGIC_TREE_FILE_NAME);
        Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(LogicTree.class, new LogicTree.Adapter()).create();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output.getOutputStream()));
        gson.toJson(logicTree, LogicTree.class, (Appendable)writer);
        writer.flush();
        output.closeEntry();
    }

    protected void writeLogicTreeMappingsToArchive(ArchiveOutput output, String prefix, LogicTree<?> logicTree, List<Map<String, String>> branchMappings) throws IOException {
        if (this.verbose) {
            System.out.println("Writing full logic tree");
        }
        if (this.verbose) {
            System.out.println("Writing branch file mappings");
        }
        FileBackedModule.initEntry(output, prefix, LOGIC_TREE_MAPPINGS_FILE_NAME);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output.getOutputStream()));
        AbstractLogicTreeModule.writeLogicTreeMappings(writer, logicTree, branchMappings);
        output.closeEntry();
    }

    public static void writeLogicTreeMappings(Writer out, LogicTree<?> logicTree, List<Map<String, String>> branchMappings) throws IOException {
        int i;
        if (!(out instanceof BufferedWriter)) {
            out = new BufferedWriter(out);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonWriter writer = gson.newJsonWriter(out);
        double sumWeight = 0.0;
        for (i = 0; i < logicTree.size(); ++i) {
            sumWeight += logicTree.getBranchWeight(i);
        }
        writer.beginArray();
        for (i = 0; i < logicTree.size(); ++i) {
            writer.beginObject();
            LogicTreeBranch<?> branch = logicTree.getBranch(i);
            writer.name("branch").beginArray();
            for (LogicTreeNode node : branch) {
                if (node == null) {
                    writer.nullValue();
                    continue;
                }
                writer.value(node.getFilePrefix());
            }
            writer.endArray();
            double weight = logicTree.getBranchWeight(i);
            if ((float)sumWeight != 1.0f) {
                weight /= sumWeight;
            }
            writer.name("weight").value(weight);
            Map<String, String> mappings = branchMappings.get(i);
            writer.name("mappings").beginObject();
            for (String key : mappings.keySet()) {
                writer.name(key).value(mappings.get(key));
            }
            writer.endObject();
            writer.endObject();
        }
        writer.endArray();
        writer.flush();
    }

    public static List<Map<String, String>> loadBranchMappings(Reader read, LogicTree<?> logicTree) throws IOException {
        if (!(read instanceof BufferedReader)) {
            read = new BufferedReader(read);
        }
        Gson gson = new GsonBuilder().create();
        JsonReader in = gson.newJsonReader(read);
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>(logicTree.size());
        in.beginArray();
        for (int i = 0; i < logicTree.size(); ++i) {
            in.beginObject();
            LogicTreeBranch<?> branch = logicTree.getBranch(i);
            LinkedHashMap<String, String> mappings = null;
            block11: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "branch": {
                        in.beginArray();
                        for (int j = 0; j < branch.size(); ++j) {
                            Object val = branch.getValue(j);
                            if (val == null) {
                                in.nextNull();
                                continue;
                            }
                            String nodeName = in.nextString();
                            Preconditions.checkState((boolean)nodeName.equals(val.getFilePrefix()));
                        }
                        in.endArray();
                        continue block11;
                    }
                    case "mappings": {
                        mappings = new LinkedHashMap<String, String>();
                        in.beginObject();
                        while (in.hasNext()) {
                            String key = in.nextName();
                            String value = in.nextString();
                            mappings.put(key, value);
                        }
                        in.endObject();
                        continue block11;
                    }
                    case "weight": {
                        in.skipValue();
                        continue block11;
                    }
                }
                throw new IllegalStateException("Unexpected JSON name: " + name);
            }
            Preconditions.checkNotNull(mappings);
            ret.add(mappings);
            in.endObject();
        }
        in.endArray();
        read.close();
        return ret;
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        String outPrefix = this.buildPrefix(entryPrefix);
        this.writeLogicTreeToArchive(output, outPrefix, this.logicTree);
        HashSet<String> writtenFiles = new HashSet<String>();
        ArrayList<Map<String, String>> branchMappings = new ArrayList<Map<String, String>>();
        for (int i = 0; i < this.logicTree.size(); ++i) {
            LogicTreeBranch<?> branch = this.logicTree.getBranch(i);
            if (this.verbose) {
                System.out.println("Writing branch " + i + "/" + this.logicTree.size() + ": " + String.valueOf(branch));
            }
            branchMappings.add(this.writeBranchFilesToArchive(output, outPrefix, branch, writtenFiles));
        }
        this.writeLogicTreeMappingsToArchive(output, outPrefix, this.logicTree, branchMappings);
    }

    @Override
    public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        this.input = input;
        this.prefix = this.buildPrefix(entryPrefix);
        BufferedInputStream logicTreeIS = FileBackedModule.getInputStream(input, this.prefix, LOGIC_TREE_FILE_NAME);
        Gson gson = new GsonBuilder().registerTypeAdapter(LogicTree.class, new LogicTree.Adapter()).create();
        InputStreamReader reader = new InputStreamReader(logicTreeIS);
        this.setLogicTree((LogicTree)gson.fromJson((Reader)reader, LogicTree.class));
    }

    protected LogicTreeLevel<?> getLevelForType(Class<? extends LogicTreeNode> type) {
        LogicTree<?> logicTree = this.getLogicTree();
        Preconditions.checkNotNull(logicTree, (Object)"Not yet initialized");
        for (LogicTreeLevel level : logicTree.getLevels()) {
            if (!level.matchesType(type)) continue;
            return level;
        }
        throw new IllegalStateException("No level found for type: " + String.valueOf(type));
    }
}

