/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchModuleBuilder;

public class BranchAveragingOrder
implements SubModule<ModuleContainer<?>>,
CSV_BackedModule {
    private FaultSystemSolution sol;
    private String[] branchFileNames;
    private double[] weights;
    private Map<String, Integer> nameIndexMap = null;
    private static final String FILE_NAME = "branch_averaging_order.csv";

    private BranchAveragingOrder() {
    }

    @Override
    public String getName() {
        return "Branch Averaging Order";
    }

    @Override
    public void setParent(ModuleContainer<?> parent) throws IllegalStateException {
        FaultSystemSolution sol;
        Preconditions.checkNotNull(parent);
        this.sol = parent instanceof FaultSystemSolution ? (sol = (FaultSystemSolution)parent) : null;
    }

    @Override
    public FaultSystemSolution getParent() {
        return this.sol;
    }

    public BranchAveragingOrder copy(ModuleContainer<?> newParent) throws IllegalStateException {
        BranchAveragingOrder ret = new BranchAveragingOrder();
        ret.branchFileNames = this.branchFileNames;
        ret.weights = this.weights;
        ret.setParent(newParent);
        return ret;
    }

    public int getNumBranches() {
        return this.branchFileNames.length;
    }

    public double[] getBranchWeights() {
        return this.weights;
    }

    public double getBranchWeight(int index) {
        return this.weights[index];
    }

    public String[] getBranchFileNames() {
        return this.getBranchFileNames();
    }

    public String getBranchFileName(int index) {
        return this.branchFileNames[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInitMap() {
        if (this.nameIndexMap == null) {
            BranchAveragingOrder branchAveragingOrder = this;
            synchronized (branchAveragingOrder) {
                if (this.nameIndexMap == null) {
                    HashMap<String, Integer> map = new HashMap<String, Integer>(this.branchFileNames.length);
                    for (int i = 0; i < this.branchFileNames.length; ++i) {
                        map.put(this.branchFileNames[i], i);
                    }
                    this.nameIndexMap = map;
                }
            }
        }
    }

    public int getBranchAveragingIndex(LogicTreeBranch<?> branch) {
        this.checkInitMap();
        String name = branch.buildFileName();
        Integer ret = this.nameIndexMap.get(name);
        Preconditions.checkState((ret != null ? 1 : 0) != 0, (String)"Branch not found: %s", (Object)name);
        return ret;
    }

    @Override
    public String getFileName() {
        return FILE_NAME;
    }

    @Override
    public CSVFile<?> getCSV() {
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Branch Index", "Branch Weight", "Branch Name");
        for (int i = 0; i < this.branchFileNames.length; ++i) {
            csv.addLine("" + i, "" + this.weights[i], this.branchFileNames[i]);
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        this.branchFileNames = new String[csv.getNumRows() - 1];
        this.weights = new double[this.branchFileNames.length];
        for (int i = 0; i < this.branchFileNames.length; ++i) {
            int row = i + 1;
            Preconditions.checkState((csv.getInt(row, 0) == i ? 1 : 0) != 0);
            this.weights[i] = csv.getDouble(row, 1);
            this.branchFileNames[i] = csv.get(row, 2);
        }
    }

    public static class Builder
    implements BranchModuleBuilder<FaultSystemSolution, BranchAveragingOrder> {
        private List<String> branchFileNames = new ArrayList<String>();
        private List<Double> weights = new ArrayList<Double>();

        @Override
        public synchronized void process(FaultSystemSolution sol, LogicTreeBranch<?> branch, double weight) {
            this.weights.add(weight);
            this.branchFileNames.add(branch.buildFileName());
        }

        @Override
        public BranchAveragingOrder build() {
            BranchAveragingOrder ret = new BranchAveragingOrder();
            ret.branchFileNames = this.branchFileNames.toArray(new String[0]);
            ret.weights = Doubles.toArray(this.weights);
            return ret;
        }
    }
}

