/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.CSVReader;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.geo.Region;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.commons.util.modules.helpers.LargeCSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchModuleBuilder;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.RegionsOfInterest;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

public class BranchRegionalMFDs
implements SubModule<ModuleContainer<?>>,
ArchivableModule {
    private FaultSystemSolution sol;
    private IncrementalMagFreqDist[] supraTotalBranchMFDs;
    private List<IncrementalMagFreqDist[]> supraRegionalBranchMFDs;
    private IncrementalMagFreqDist[] gridTotalBranchMFDs;
    private List<IncrementalMagFreqDist[]> gridRegionalBranchMFDs;
    private IncrementalMagFreqDist[] sumTotalBranchMFDs;
    private List<IncrementalMagFreqDist[]> sumRegionalBranchMFDs;
    private double[] weights;
    private static final String SUPRA_FILE_NAME = "branch_regional_supra_nucl_mfds.csv";
    private static final String GRID_FILE_NAME = "branch_regional_grid_nucl_mfds.csv";
    private static final String SUM_FILE_NAME = "branch_regional_sum_nucl_mfds.csv";
    private static final String TOTAL_REG_FLAG = "total";

    private BranchRegionalMFDs() {
    }

    public static BranchRegionalMFDs combine(List<BranchRegionalMFDs> regMFDsList, List<Double> weightsList) {
        double sumWeight;
        Preconditions.checkState((regMFDsList.size() > 1 ? 1 : 0) != 0);
        if (weightsList == null) {
            double weightEach = 1.0 / (double)regMFDsList.size();
            weightsList = new ArrayList<Double>(regMFDsList.size());
            for (int i = 0; i < regMFDsList.size(); ++i) {
                weightsList.add(weightEach);
            }
            sumWeight = 1.0;
        } else {
            Preconditions.checkState((regMFDsList.size() == weightsList.size() ? 1 : 0) != 0);
            sumWeight = weightsList.stream().mapToDouble(D -> D).sum();
        }
        int numCombBranches = 0;
        for (BranchRegionalMFDs regMFDs : regMFDsList) {
            numCombBranches += regMFDs.weights.length;
        }
        BranchRegionalMFDs ref = regMFDsList.get(0);
        IncrementalMagFreqDist[] supraTotalBranchMFDs = ref.supraTotalBranchMFDs == null ? null : new IncrementalMagFreqDist[numCombBranches];
        List<IncrementalMagFreqDist[]> supraRegionalBranchMFDs = BranchRegionalMFDs.initNewRegional(ref.supraRegionalBranchMFDs, numCombBranches);
        IncrementalMagFreqDist[] gridTotalBranchMFDs = ref.gridTotalBranchMFDs == null ? null : new IncrementalMagFreqDist[numCombBranches];
        List<IncrementalMagFreqDist[]> gridRegionalBranchMFDs = BranchRegionalMFDs.initNewRegional(ref.gridRegionalBranchMFDs, numCombBranches);
        IncrementalMagFreqDist[] sumTotalBranchMFDs = ref.sumTotalBranchMFDs == null ? null : new IncrementalMagFreqDist[numCombBranches];
        List<IncrementalMagFreqDist[]> sumRegionalBranchMFDs = BranchRegionalMFDs.initNewRegional(ref.sumRegionalBranchMFDs, numCombBranches);
        double[] weights = new double[numCombBranches];
        int index = 0;
        for (int r = 0; r < regMFDsList.size(); ++r) {
            BranchRegionalMFDs regMFDs = regMFDsList.get(r);
            double myWeight = weightsList.get(r) / sumWeight;
            for (int i = 0; i < regMFDs.weights.length; ++i) {
                weights[index] = regMFDs.weights[i] * myWeight;
                if (supraTotalBranchMFDs != null) {
                    supraTotalBranchMFDs[index] = regMFDs.supraTotalBranchMFDs[i];
                }
                if (gridTotalBranchMFDs != null) {
                    gridTotalBranchMFDs[index] = regMFDs.gridTotalBranchMFDs[i];
                }
                if (supraTotalBranchMFDs != null) {
                    sumTotalBranchMFDs[index] = regMFDs.sumTotalBranchMFDs[i];
                }
                BranchRegionalMFDs.addIntoRegional(supraRegionalBranchMFDs, index, regMFDs.supraRegionalBranchMFDs, i);
                BranchRegionalMFDs.addIntoRegional(gridRegionalBranchMFDs, index, regMFDs.gridRegionalBranchMFDs, i);
                BranchRegionalMFDs.addIntoRegional(sumRegionalBranchMFDs, index, regMFDs.sumRegionalBranchMFDs, i);
                ++index;
            }
        }
        Preconditions.checkState((index == numCombBranches ? 1 : 0) != 0);
        BranchRegionalMFDs ret = new BranchRegionalMFDs();
        ret.weights = weights;
        EvenlyDiscretizedFunc refMFD = BranchRegionalMFDs.getLargestRefMFD(List.of(supraTotalBranchMFDs, gridTotalBranchMFDs, sumTotalBranchMFDs));
        ret.supraTotalBranchMFDs = BranchRegionalMFDs.expandToSameSize(supraTotalBranchMFDs, refMFD);
        ret.supraRegionalBranchMFDs = BranchRegionalMFDs.expandToSameSize(supraRegionalBranchMFDs, refMFD);
        ret.gridTotalBranchMFDs = BranchRegionalMFDs.expandToSameSize(gridTotalBranchMFDs, refMFD);
        ret.gridRegionalBranchMFDs = BranchRegionalMFDs.expandToSameSize(gridRegionalBranchMFDs, refMFD);
        ret.sumTotalBranchMFDs = BranchRegionalMFDs.expandToSameSize(sumTotalBranchMFDs, refMFD);
        ret.sumRegionalBranchMFDs = BranchRegionalMFDs.expandToSameSize(sumRegionalBranchMFDs, refMFD);
        return ret;
    }

    private static EvenlyDiscretizedFunc getLargestRefMFD(List<IncrementalMagFreqDist[]> mfdsList) {
        double overallMinX = Double.POSITIVE_INFINITY;
        double overallMaxX = 0.0;
        boolean allSame = true;
        EvenlyDiscretizedFunc first = null;
        for (IncrementalMagFreqDist[] mfds : mfdsList) {
            if (mfds == null) continue;
            for (IncrementalMagFreqDist mfd : mfds) {
                if (first == null) {
                    first = mfd;
                }
                overallMinX = Math.min(overallMinX, mfd.getMinX());
                overallMaxX = Math.max(overallMaxX, mfd.getMaxX());
                allSame &= overallMinX == mfd.getMinX();
                allSame &= overallMaxX == mfd.getMaxX();
            }
        }
        if (allSame) {
            return first;
        }
        EvenlyDiscretizedFunc refMFD = new EvenlyDiscretizedFunc(overallMinX, overallMaxX, (int)((overallMaxX - overallMinX) / first.getDelta() + 0.5) + 1);
        Preconditions.checkState(((float)refMFD.getDelta() == (float)first.getDelta() ? 1 : 0) != 0, (String)"Bad delta for min=%s, max=%s, delta=%s, calcDelta=%s, size=%s", (Object[])new Object[]{overallMinX, overallMaxX, first.getDelta(), refMFD.getDelta(), refMFD.size()});
        return refMFD;
    }

    private static IncrementalMagFreqDist[] expandToSameSize(IncrementalMagFreqDist[] mfds, EvenlyDiscretizedFunc refMFD) {
        if (mfds == null) {
            return null;
        }
        boolean allSame = true;
        for (IncrementalMagFreqDist mfd : mfds) {
            allSame &= refMFD.size() == mfd.size();
            allSame &= (float)refMFD.getMinX() == (float)mfd.getMinX();
            if (!(allSame &= (float)refMFD.getMaxX() == (float)mfd.getMaxX())) break;
        }
        if (allSame) {
            return mfds;
        }
        for (int i = 0; i < mfds.length; ++i) {
            IncrementalMagFreqDist expanded = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.getMaxX(), refMFD.size());
            for (Point2D pt : mfds[i]) {
                expanded.set(refMFD.getClosestXIndex(pt.getX()), pt.getY());
            }
            mfds[i] = expanded;
        }
        return mfds;
    }

    private static List<IncrementalMagFreqDist[]> expandToSameSize(List<IncrementalMagFreqDist[]> mfdsList, EvenlyDiscretizedFunc refMFD) {
        if (mfdsList == null) {
            return null;
        }
        for (IncrementalMagFreqDist[] mfds : mfdsList) {
            BranchRegionalMFDs.expandToSameSize(mfds, refMFD);
        }
        return mfdsList;
    }

    private static List<IncrementalMagFreqDist[]> initNewRegional(List<IncrementalMagFreqDist[]> refRegional, int newSize) {
        if (refRegional == null) {
            return null;
        }
        ArrayList<IncrementalMagFreqDist[]> ret = new ArrayList<IncrementalMagFreqDist[]>();
        for (int i = 0; i < refRegional.size(); ++i) {
            if (refRegional.get(i) == null) {
                ret.add(null);
                continue;
            }
            ret.add(new IncrementalMagFreqDist[newSize]);
        }
        return ret;
    }

    private static void addIntoRegional(List<IncrementalMagFreqDist[]> to, int toIndex, List<IncrementalMagFreqDist[]> from, int fromIndex) {
        if (to == null) {
            return;
        }
        for (int i = 0; i < to.size(); ++i) {
            IncrementalMagFreqDist[] toMFDs = to.get(i);
            if (toMFDs == null) continue;
            toMFDs[toIndex] = from.get(i)[fromIndex];
        }
    }

    @Override
    public String getName() {
        return "Branch Regional MFDs";
    }

    @Override
    public void setParent(ModuleContainer<?> parent) throws IllegalStateException {
        Preconditions.checkNotNull(parent);
        if (parent instanceof FaultSystemSolution) {
            FaultSystemSolution sol = (FaultSystemSolution)parent;
            RegionsOfInterest roi = sol.getRupSet().getModule(RegionsOfInterest.class);
            if (this.supraRegionalBranchMFDs != null) {
                Preconditions.checkState((roi != null ? 1 : 0) != 0, (Object)"New solution doesn't have regions of interest");
                Preconditions.checkState((this.supraRegionalBranchMFDs.size() == roi.getRegions().size() ? 1 : 0) != 0, (Object)"Solution has different region count");
            }
            this.sol = sol;
        } else {
            this.sol = null;
        }
    }

    @Override
    public FaultSystemSolution getParent() {
        return this.sol;
    }

    public BranchRegionalMFDs copy(ModuleContainer<?> newParent) throws IllegalStateException {
        BranchRegionalMFDs ret = new BranchRegionalMFDs();
        ret.gridTotalBranchMFDs = this.gridTotalBranchMFDs;
        ret.gridRegionalBranchMFDs = this.gridRegionalBranchMFDs;
        ret.supraTotalBranchMFDs = this.supraTotalBranchMFDs;
        ret.supraRegionalBranchMFDs = this.supraRegionalBranchMFDs;
        ret.sumTotalBranchMFDs = this.sumTotalBranchMFDs;
        ret.sumRegionalBranchMFDs = this.sumRegionalBranchMFDs;
        ret.weights = this.weights;
        ret.setParent(newParent);
        return ret;
    }

    public int getNumRegions() {
        return this.supraRegionalBranchMFDs.size();
    }

    public double[] getBranchWeights() {
        return this.weights;
    }

    public IncrementalMagFreqDist[] getSupraTotalBranchMFDs() {
        return this.supraTotalBranchMFDs;
    }

    public IncrementalMagFreqDist[] getSupraRegionalBranchMFDs(int regionIndex) {
        return this.supraRegionalBranchMFDs.get(regionIndex);
    }

    public IncrementalMagFreqDist[] getGriddedTotalBranchMFDs() {
        return this.gridTotalBranchMFDs;
    }

    public IncrementalMagFreqDist[] getGriddedRegionalBranchMFDs(int regionIndex) {
        return this.gridRegionalBranchMFDs.get(regionIndex);
    }

    public IncrementalMagFreqDist[] getSumTotalBranchMFDs() {
        return this.sumTotalBranchMFDs;
    }

    public IncrementalMagFreqDist[] getSumRegionalBranchMFDs(int regionIndex) {
        return this.sumRegionalBranchMFDs.get(regionIndex);
    }

    public boolean hasMFDs(MFDType type) {
        switch (type.ordinal()) {
            case 0: {
                return this.supraTotalBranchMFDs != null;
            }
            case 1: {
                return this.gridTotalBranchMFDs != null;
            }
            case 2: {
                return this.sumTotalBranchMFDs != null;
            }
        }
        return false;
    }

    public IncrementalMagFreqDist[] getTotalBranchMFDs(MFDType type) {
        switch (type.ordinal()) {
            case 0: {
                return this.supraTotalBranchMFDs;
            }
            case 1: {
                return this.gridTotalBranchMFDs;
            }
            case 2: {
                return this.sumTotalBranchMFDs;
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasRegionalBranchMFDs(MFDType type) {
        switch (type.ordinal()) {
            case 0: {
                return this.supraRegionalBranchMFDs != null;
            }
            case 1: {
                return this.gridRegionalBranchMFDs != null;
            }
            case 2: {
                return this.sumRegionalBranchMFDs != null;
            }
        }
        return false;
    }

    public IncrementalMagFreqDist[] getRegionalBranchMFDs(MFDType type, int regionIndex) {
        List<IncrementalMagFreqDist[]> list;
        switch (type.ordinal()) {
            case 0: {
                list = this.supraRegionalBranchMFDs;
                break;
            }
            case 1: {
                list = this.gridRegionalBranchMFDs;
                break;
            }
            case 2: {
                list = this.sumRegionalBranchMFDs;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Preconditions.checkNotNull(list, (String)"No regional MFDs available for type %s (regIndex = %s)", (Object)((Object)type), (int)regionIndex);
        Preconditions.checkState((list.size() > regionIndex ? 1 : 0) != 0, (String)"Bad regIndex=%s with size %s for type %s", (Object)regionIndex, (Object)list.size(), (Object)((Object)type));
        return list.get(regionIndex);
    }

    public boolean hasGridded() {
        return this.gridTotalBranchMFDs != null;
    }

    public boolean hasRegionalMFDs() {
        return this.supraRegionalBranchMFDs != null;
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        Preconditions.checkNotNull((Object)this.supraTotalBranchMFDs);
        this.writeCSV(FileBackedModule.initOutputStream(output, entryPrefix, SUPRA_FILE_NAME), this.supraTotalBranchMFDs, this.supraRegionalBranchMFDs);
        output.closeEntry();
        if (this.hasGridded()) {
            Preconditions.checkNotNull((Object)this.gridTotalBranchMFDs);
            this.writeCSV(FileBackedModule.initOutputStream(output, entryPrefix, GRID_FILE_NAME), this.gridTotalBranchMFDs, this.gridRegionalBranchMFDs);
            output.closeEntry();
            Preconditions.checkNotNull((Object)this.sumTotalBranchMFDs);
            this.writeCSV(FileBackedModule.initOutputStream(output, entryPrefix, SUM_FILE_NAME), this.sumTotalBranchMFDs, this.sumRegionalBranchMFDs);
            output.closeEntry();
        }
    }

    private void writeCSV(OutputStream zout, IncrementalMagFreqDist[] totalMFDs, List<IncrementalMagFreqDist[]> regionalMFDs) throws IOException {
        CSVWriter csv = new CSVWriter(zout, true);
        ArrayList<String> header = new ArrayList<String>();
        header.add("Region Index");
        header.add("Branch Index");
        header.add("Branch Weight");
        IncrementalMagFreqDist refMFD = totalMFDs[0];
        for (Point2D pt : refMFD) {
            header.add("" + (float)pt.getX());
        }
        csv.write(header);
        int numReg = regionalMFDs == null ? 0 : regionalMFDs.size();
        for (int r = -1; r < numReg; ++r) {
            IncrementalMagFreqDist[] mfds = r < 0 ? totalMFDs : regionalMFDs.get(r);
            Preconditions.checkState((mfds.length == this.weights.length ? 1 : 0) != 0, (String)"Have %s weights but %s mfds for region %s", (Object)this.weights.length, (Object)mfds.length, (Object)r);
            for (int b = 0; b < mfds.length; ++b) {
                ArrayList<String> line = new ArrayList<String>(header.size());
                if (r < 0) {
                    line.add(TOTAL_REG_FLAG);
                } else {
                    line.add("" + r);
                }
                line.add("" + b);
                line.add("" + this.weights[b]);
                IncrementalMagFreqDist mfd = mfds[b];
                Preconditions.checkState((mfd.size() == refMFD.size() ? 1 : 0) != 0);
                Preconditions.checkState(((float)mfd.getMinX() == (float)refMFD.getMinX() ? 1 : 0) != 0);
                Preconditions.checkState(((float)mfd.getDelta() == (float)refMFD.getDelta() ? 1 : 0) != 0);
                for (Point2D pt : mfd) {
                    line.add("" + (float)pt.getY());
                }
                csv.write(line);
            }
        }
        csv.flush();
        zout.flush();
    }

    @Override
    public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        CSVReader csv = LargeCSV_BackedModule.loadFromArchive(input, entryPrefix, SUPRA_FILE_NAME);
        this.readCSV(csv, false, false);
        if (FileBackedModule.hasEntry(input, entryPrefix, GRID_FILE_NAME)) {
            csv = LargeCSV_BackedModule.loadFromArchive(input, entryPrefix, GRID_FILE_NAME);
            this.readCSV(csv, true, false);
            csv = LargeCSV_BackedModule.loadFromArchive(input, entryPrefix, SUM_FILE_NAME);
            this.readCSV(csv, true, true);
        }
    }

    private void readCSV(CSVReader csv, boolean gridded, boolean sum) {
        block19: {
            ArrayList regionalMFDs;
            ArrayList totalMFDs;
            block17: {
                block18: {
                    int expectedNum = this.weights == null ? 100 : this.weights.length;
                    totalMFDs = new ArrayList(expectedNum);
                    regionalMFDs = new ArrayList(10);
                    ArrayList<Double> myWeights = new ArrayList<Double>(expectedNum);
                    CSVReader.Row header = csv.read();
                    int mfdSize = header.columns() - 3;
                    EvenlyDiscretizedFunc refMFD = new EvenlyDiscretizedFunc(Double.parseDouble(header.get(3)), Double.parseDouble(header.get(header.columns() - 1)), mfdSize);
                    for (CSVReader.Row row : csv) {
                        List<IncrementalMagFreqDist> mfdList;
                        Preconditions.checkState((row.columns() == header.columns() ? 1 : 0) != 0, (String)"Row BranchRegionalMFDs csv file has %s columns but header has %s", (int)row.columns(), (int)header.columns());
                        String regStr = row.get(0);
                        int branchIndex = row.getInt(1);
                        while (myWeights.size() <= branchIndex) {
                            myWeights.add(null);
                        }
                        double weight = row.getDouble(2);
                        Double prevWeight = (Double)myWeights.get(branchIndex);
                        if (prevWeight != null) {
                            Preconditions.checkState(((float)weight == prevWeight.floatValue() ? 1 : 0) != 0);
                        } else {
                            myWeights.set(branchIndex, weight);
                        }
                        IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.getMaxX(), refMFD.size());
                        for (int i = 0; i < mfd.size(); ++i) {
                            mfd.set(i, row.getDouble(i + 3));
                        }
                        if (regStr.equals(TOTAL_REG_FLAG)) {
                            mfdList = totalMFDs;
                        } else {
                            int regIndex = Integer.parseInt(regStr);
                            while (regionalMFDs.size() <= regIndex) {
                                regionalMFDs.add(new ArrayList(expectedNum));
                            }
                            mfdList = (List)regionalMFDs.get(regIndex);
                        }
                        while (mfdList.size() <= branchIndex) {
                            mfdList.add(null);
                        }
                        Preconditions.checkState((mfdList.get(branchIndex) == null ? 1 : 0) != 0);
                        mfdList.set(branchIndex, mfd);
                    }
                    if (this.weights == null) {
                        this.weights = Doubles.toArray(myWeights);
                    }
                    Preconditions.checkState((totalMFDs.size() == this.weights.length ? 1 : 0) != 0);
                    if (regionalMFDs.isEmpty()) {
                        regionalMFDs = null;
                    } else {
                        for (int r = 0; r < regionalMFDs.size(); ++r) {
                            Preconditions.checkState((((List)regionalMFDs.get(r)).size() == this.weights.length ? 1 : 0) != 0);
                        }
                    }
                    if (!gridded) break block17;
                    if (!sum) break block18;
                    this.sumTotalBranchMFDs = totalMFDs.toArray(new IncrementalMagFreqDist[0]);
                    if (regionalMFDs == null) break block19;
                    this.sumRegionalBranchMFDs = new ArrayList<IncrementalMagFreqDist[]>();
                    for (List list : regionalMFDs) {
                        this.sumRegionalBranchMFDs.add(list.toArray(new IncrementalMagFreqDist[0]));
                    }
                    break block19;
                }
                this.gridTotalBranchMFDs = totalMFDs.toArray(new IncrementalMagFreqDist[0]);
                if (regionalMFDs == null) break block19;
                this.gridRegionalBranchMFDs = new ArrayList<IncrementalMagFreqDist[]>();
                for (List list : regionalMFDs) {
                    this.gridRegionalBranchMFDs.add(list.toArray(new IncrementalMagFreqDist[0]));
                }
                break block19;
            }
            Preconditions.checkState((!sum ? 1 : 0) != 0);
            this.supraTotalBranchMFDs = totalMFDs.toArray(new IncrementalMagFreqDist[0]);
            if (regionalMFDs != null) {
                this.supraRegionalBranchMFDs = new ArrayList<IncrementalMagFreqDist[]>();
                for (List list : regionalMFDs) {
                    this.supraRegionalBranchMFDs.add(list.toArray(new IncrementalMagFreqDist[0]));
                }
            }
        }
    }

    public IncrementalMagFreqDist[] calcTotalIncrementalFractiles(MFDType type, double ... fractiles) {
        return (IncrementalMagFreqDist[])this.calcFractiles(this.getTotalBranchMFDs(type), fractiles, false);
    }

    public EvenlyDiscretizedFunc[] calcTotalCumulativeFractiles(MFDType type, double ... fractiles) {
        return this.calcFractiles(this.getTotalBranchMFDs(type), fractiles, true);
    }

    public IncrementalMagFreqDist[] calcRegionalIncrementalFractiles(MFDType type, int regionIndex, double ... fractiles) {
        return (IncrementalMagFreqDist[])this.calcFractiles(this.getRegionalBranchMFDs(type, regionIndex), fractiles, false);
    }

    public EvenlyDiscretizedFunc[] calcRegionalCumulativeFractiles(MFDType type, int regionIndex, double ... fractiles) {
        return this.calcFractiles(this.getRegionalBranchMFDs(type, regionIndex), fractiles, true);
    }

    private EvenlyDiscretizedFunc[] calcFractiles(IncrementalMagFreqDist[] mfds, double[] fractiles, boolean cumulative) {
        int i;
        EvenlyDiscretizedFunc refMFD = mfds[0];
        for (int i2 = 1; i2 < mfds.length; ++i2) {
            Preconditions.checkState(((float)mfds[i2].getMinX() == (float)refMFD.getMinX() ? 1 : 0) != 0);
            if (mfds[i2].size() <= refMFD.size()) continue;
            refMFD = mfds[i2];
        }
        if (cumulative) {
            refMFD = ((IncrementalMagFreqDist)refMFD).getCumRateDistWithOffset();
        }
        double[][] branchVals = new double[refMFD.size()][mfds.length];
        for (int b = 0; b < mfds.length; ++b) {
            IncrementalMagFreqDist branchMFD = mfds[b];
            if (cumulative) {
                EvenlyDiscretizedFunc branchCmlMFD = branchMFD.getCumRateDistWithOffset();
                Preconditions.checkState((branchCmlMFD.size() <= refMFD.size() ? 1 : 0) != 0);
                Preconditions.checkState((branchCmlMFD.getMinX() == refMFD.getMinX() ? 1 : 0) != 0);
                for (i = 0; i < branchCmlMFD.size(); ++i) {
                    branchVals[i][b] = branchCmlMFD.getY(i);
                }
                continue;
            }
            Preconditions.checkState((branchMFD.getMinX() == refMFD.getMinX() ? 1 : 0) != 0);
            Preconditions.checkState((branchMFD.size() <= refMFD.size() ? 1 : 0) != 0, (String)"MFD size mismatch: %s != %s", (int)branchMFD.size(), (int)refMFD.size());
            for (int i3 = 0; i3 < branchMFD.size(); ++i3) {
                branchVals[i3][b] = branchMFD.getY(i3);
            }
        }
        LightFixedXFunc[] normCDFs = new LightFixedXFunc[refMFD.size()];
        for (int i4 = 0; i4 < normCDFs.length; ++i4) {
            normCDFs[i4] = ArbDiscrEmpiricalDistFunc.calcQuickNormCDF(branchVals[i4], this.weights);
        }
        EvenlyDiscretizedFunc[] ret = cumulative ? new EvenlyDiscretizedFunc[fractiles.length] : new IncrementalMagFreqDist[fractiles.length];
        for (int f = 0; f < ret.length; ++f) {
            Preconditions.checkState((fractiles[f] >= 0.0 && fractiles[f] <= 1.0 ? 1 : 0) != 0);
            ret[f] = cumulative ? new EvenlyDiscretizedFunc(refMFD.getMinX(), refMFD.size(), refMFD.getDelta()) : new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
            for (i = 0; i < normCDFs.length; ++i) {
                LightFixedXFunc ncdf = normCDFs[i];
                if ((float)fractiles[f] <= (float)ncdf.getMinY()) {
                    ret[f].set(i, ncdf.getX(0));
                    continue;
                }
                if (fractiles[f] == 1.0) {
                    ret[f].set(i, ncdf.getX(ncdf.size() - 1));
                    continue;
                }
                ret[f].set(i, ncdf.getFirstInterpolatedX(fractiles[f]));
            }
        }
        return ret;
    }

    public static enum MFDType {
        SUPRA_ONLY,
        GRID_ONLY,
        SUM;

    }

    public static class Builder
    implements BranchModuleBuilder<FaultSystemSolution, BranchRegionalMFDs> {
        private static final EvenlyDiscretizedFunc refMFD = new EvenlyDiscretizedFunc(0.05, 120, 0.1);
        private List<Double> weights;
        private List<IncrementalMagFreqDist> supraTotalMFDs;
        private List<List<IncrementalMagFreqDist>> supraRegionalMFDs;
        private List<IncrementalMagFreqDist> gridTotalMFDs;
        private List<List<IncrementalMagFreqDist>> gridRegionalMFDs;
        private List<IncrementalMagFreqDist> sumTotalMFDs;
        private List<List<IncrementalMagFreqDist>> sumRegionalMFDs;
        private int minMagIndex = Integer.MAX_VALUE;
        private int minSupraMagIndex = Integer.MAX_VALUE;
        private int maxMagIndex = 0;

        @Override
        public synchronized void process(FaultSystemSolution sol, LogicTreeBranch<?> branch, double weight) {
            this.process(sol, sol.getGridSourceProvider(), branch, weight);
        }

        public synchronized void process(FaultSystemSolution sol, GridSourceProvider gridProv, LogicTreeBranch<?> branch, double weight) {
            RegionsOfInterest roi = sol.getRupSet().getModule(RegionsOfInterest.class);
            this.processInitCheck(roi == null ? 0 : roi.getRegions().size(), gridProv != null);
            int numROI = this.supraRegionalMFDs == null ? 0 : this.supraRegionalMFDs.size();
            this.weights.add(weight);
            for (int r = -1; r < numROI; ++r) {
                Region region = r < 0 ? null : roi.getRegions().get(r);
                TectonicRegionType trt = r < 0 || roi.getTRTs() == null ? null : roi.getTRTs().get(r);
                IncrementalMagFreqDist supraMFD = sol.calcNucleationMFD_forRegion(region, refMFD.getMinX(), refMFD.getMaxX(), refMFD.getDelta(), false, trt);
                if (r < 0) {
                    this.addProcess(this.supraTotalMFDs, supraMFD, true);
                } else {
                    this.addProcess(this.supraRegionalMFDs.get(r), supraMFD, true);
                }
                if (this.gridTotalMFDs == null) continue;
                IncrementalMagFreqDist gridMFD = this.calcGridMFD(gridProv, region, trt);
                IncrementalMagFreqDist sumMFD = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.getMaxX(), refMFD.size());
                for (int i = 0; i < sumMFD.size(); ++i) {
                    sumMFD.set(i, supraMFD.getY(i) + gridMFD.getY(i));
                }
                if (r < 0) {
                    this.addProcess(this.gridTotalMFDs, gridMFD);
                    this.addProcess(this.sumTotalMFDs, sumMFD);
                    continue;
                }
                this.addProcess(this.gridRegionalMFDs.get(r), gridMFD);
                this.addProcess(this.sumRegionalMFDs.get(r), sumMFD);
            }
        }

        private void processInitCheck(int numROI, boolean hasGridded) {
            if (this.weights == null) {
                int r;
                this.weights = new ArrayList<Double>();
                this.supraTotalMFDs = new ArrayList<IncrementalMagFreqDist>();
                if (numROI > 0) {
                    this.supraRegionalMFDs = new ArrayList<List<IncrementalMagFreqDist>>();
                    for (r = 0; r < numROI; ++r) {
                        this.supraRegionalMFDs.add(new ArrayList());
                    }
                }
                if (hasGridded) {
                    this.gridTotalMFDs = new ArrayList<IncrementalMagFreqDist>();
                    if (numROI > 0) {
                        this.gridRegionalMFDs = new ArrayList<List<IncrementalMagFreqDist>>();
                        for (r = 0; r < numROI; ++r) {
                            this.gridRegionalMFDs.add(new ArrayList());
                        }
                    }
                    this.sumTotalMFDs = new ArrayList<IncrementalMagFreqDist>();
                    if (numROI > 0) {
                        this.sumRegionalMFDs = new ArrayList<List<IncrementalMagFreqDist>>();
                        for (r = 0; r < numROI; ++r) {
                            this.sumRegionalMFDs.add(new ArrayList());
                        }
                    }
                }
            } else {
                if (numROI == 0 && this.supraRegionalMFDs != null || this.supraRegionalMFDs != null && this.supraRegionalMFDs.size() != numROI) {
                    this.supraRegionalMFDs = null;
                    this.gridRegionalMFDs = null;
                    this.sumRegionalMFDs = null;
                }
                if (!hasGridded && this.gridTotalMFDs != null) {
                    this.gridTotalMFDs = null;
                    this.gridRegionalMFDs = null;
                    this.sumTotalMFDs = null;
                    this.sumRegionalMFDs = null;
                }
            }
        }

        public int getNumBranches() {
            return this.weights == null ? 0 : this.weights.size();
        }

        public synchronized void process(BranchRegionalMFDs mfds) {
            int numROI = mfds.supraRegionalBranchMFDs == null ? 0 : mfds.supraRegionalBranchMFDs.size();
            this.processInitCheck(numROI, mfds.hasGridded());
            int prevMinMagIndex = this.minMagIndex;
            this.minMagIndex = Integer.MAX_VALUE;
            this.minSupraMagIndex = Integer.MAX_VALUE;
            for (int b = 0; b < mfds.weights.length; ++b) {
                int r;
                this.weights.add(mfds.weights[b]);
                this.addProcess(this.supraTotalMFDs, this.unTrim(mfds.supraTotalBranchMFDs[b]), true);
                if (this.supraRegionalMFDs != null) {
                    for (r = 0; r < this.supraRegionalMFDs.size(); ++r) {
                        this.addProcess(this.supraRegionalMFDs.get(r), this.unTrim(mfds.supraRegionalBranchMFDs.get(r)[b]), true);
                    }
                }
                if (this.gridTotalMFDs == null) continue;
                this.addProcess(this.gridTotalMFDs, this.unTrim(mfds.gridTotalBranchMFDs[b]));
                if (this.gridRegionalMFDs != null) {
                    for (r = 0; r < this.gridRegionalMFDs.size(); ++r) {
                        this.addProcess(this.gridRegionalMFDs.get(r), this.unTrim(mfds.gridRegionalBranchMFDs.get(r)[b]));
                    }
                }
                this.addProcess(this.sumTotalMFDs, this.unTrim(mfds.sumTotalBranchMFDs[b]));
                if (this.sumRegionalMFDs == null) continue;
                for (r = 0; r < this.sumRegionalMFDs.size(); ++r) {
                    this.addProcess(this.sumRegionalMFDs.get(r), this.unTrim(mfds.sumRegionalBranchMFDs.get(r)[b]));
                }
            }
            Preconditions.checkState((this.minMagIndex < Integer.MAX_VALUE ? 1 : 0) != 0);
            if (prevMinMagIndex < Integer.MAX_VALUE) {
                this.minSupraMagIndex = this.minMagIndex = Integer.max(prevMinMagIndex, this.minMagIndex);
            }
        }

        private IncrementalMagFreqDist calcGridMFD(GridSourceProvider prov, Region region, TectonicRegionType trt) {
            SummedMagFreqDist gridMFD = new SummedMagFreqDist(refMFD.getMinX(), refMFD.getMaxX(), refMFD.size());
            for (int i = 0; i < prov.getNumLocations(); ++i) {
                IncrementalMagFreqDist nodeMFD;
                if (region != null && !region.contains(prov.getLocation(i)) || (nodeMFD = prov.getMFD(trt, i)) == null) continue;
                gridMFD.addIncrementalMagFreqDist(nodeMFD);
            }
            return gridMFD;
        }

        private void addProcess(List<IncrementalMagFreqDist> list, IncrementalMagFreqDist mfd) {
            this.addProcess(list, mfd, false);
        }

        private void addProcess(List<IncrementalMagFreqDist> list, IncrementalMagFreqDist mfd, boolean supra) {
            list.add(mfd);
            for (int i = 0; i < mfd.size(); ++i) {
                if (!(mfd.getY(i) > 0.0)) continue;
                this.minMagIndex = Integer.min(this.minMagIndex, i);
                if (supra) {
                    this.minSupraMagIndex = Integer.min(this.minSupraMagIndex, i);
                }
                this.maxMagIndex = Integer.max(this.maxMagIndex, i);
            }
        }

        @Override
        public BranchRegionalMFDs build() {
            BranchRegionalMFDs ret = new BranchRegionalMFDs();
            ret.weights = Doubles.toArray(this.weights);
            System.out.println("Building branch regional MFDs with " + this.supraTotalMFDs.size() + " solutions");
            if (this.supraRegionalMFDs == null) {
                System.out.println("\tno ROI");
            } else {
                System.out.println("\t" + this.supraRegionalMFDs.size() + " regions");
            }
            if (this.minMagIndex < this.minSupraMagIndex) {
                double minSupraMag = refMFD.getX(this.minSupraMagIndex);
                this.minMagIndex = Integer.max(this.minMagIndex, refMFD.getClosestXIndex(Math.min(5.0, Math.floor(minSupraMag)) + 0.01));
                System.out.println("\tWill store down to M=" + (float)refMFD.getX(this.minMagIndex));
            }
            ret.supraTotalBranchMFDs = this.mfdListToTrimmedArray(this.supraTotalMFDs);
            ret.supraRegionalBranchMFDs = this.mfdRegListToTrimmedArray(this.supraRegionalMFDs);
            if (this.gridTotalMFDs != null) {
                System.out.println("\thave gridded MFDs");
            }
            ret.gridTotalBranchMFDs = this.mfdListToTrimmedArray(this.gridTotalMFDs);
            ret.gridRegionalBranchMFDs = this.mfdRegListToTrimmedArray(this.gridRegionalMFDs);
            ret.sumTotalBranchMFDs = this.mfdListToTrimmedArray(this.sumTotalMFDs);
            ret.sumRegionalBranchMFDs = this.mfdRegListToTrimmedArray(this.sumRegionalMFDs);
            return ret;
        }

        private IncrementalMagFreqDist[] mfdListToTrimmedArray(List<IncrementalMagFreqDist> list) {
            if (list == null) {
                return null;
            }
            IncrementalMagFreqDist[] ret = new IncrementalMagFreqDist[list.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.trimToMinMax(list.get(i));
            }
            return ret;
        }

        private List<IncrementalMagFreqDist[]> mfdRegListToTrimmedArray(List<List<IncrementalMagFreqDist>> list) {
            if (list == null) {
                return null;
            }
            ArrayList<IncrementalMagFreqDist[]> ret = new ArrayList<IncrementalMagFreqDist[]>();
            for (int r = 0; r < list.size(); ++r) {
                ret.add(this.mfdListToTrimmedArray(list.get(r)));
            }
            return ret;
        }

        private IncrementalMagFreqDist trimToMinMax(IncrementalMagFreqDist mfd) {
            IncrementalMagFreqDist trimmed = new IncrementalMagFreqDist(refMFD.getX(this.minMagIndex), 1 + this.maxMagIndex - this.minMagIndex, refMFD.getDelta());
            for (int i = this.minMagIndex; i <= this.maxMagIndex; ++i) {
                trimmed.set(i - this.minMagIndex, mfd.getY(i));
            }
            return trimmed;
        }

        private IncrementalMagFreqDist unTrim(IncrementalMagFreqDist mfd) {
            IncrementalMagFreqDist ret = new IncrementalMagFreqDist(refMFD.getMinX(), refMFD.size(), refMFD.getDelta());
            Preconditions.checkState(((float)ret.getDelta() == (float)mfd.getDelta() ? 1 : 0) != 0);
            int offset = ret.getClosestXIndex(mfd.getX(0));
            for (int i = 0; i < mfd.size(); ++i) {
                ret.set(i + offset, mfd.getY(i));
            }
            return ret;
        }
    }
}

