/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.RupSetDeformationModel;

public class DefModelRupRakes
implements CSV_BackedModule,
SubModule<FaultSystemRupSet> {
    public static final String FILE_NAME = "def_model_rup_rakes.csv";
    private FaultSystemRupSet rupSet;
    private ImmutableMap<String, double[]> rakesMap;

    private DefModelRupRakes() {
    }

    public DefModelRupRakes(FaultSystemRupSet rupSet, Map<RupSetDeformationModel, double[]> rakesMap) {
        Preconditions.checkNotNull((Object)rupSet, (Object)"Must supply rupture set");
        this.rupSet = rupSet;
        Preconditions.checkNotNull(rakesMap, (Object)"Must supply rakes map");
        Preconditions.checkArgument((!rakesMap.isEmpty() ? 1 : 0) != 0, (Object)"Rakes map cannot be empty");
        LinkedHashMap<String, double[]> namesToRakesMap = new LinkedHashMap<String, double[]>();
        for (RupSetDeformationModel dm : rakesMap.keySet()) {
            double[] rakes = rakesMap.get(dm);
            Preconditions.checkArgument((rakes.length == rupSet.getNumRuptures() ? 1 : 0) != 0, (String)"Rake size mismatch for %s: %s != %s", (Object)dm, (Object)rakes.length, (Object)rupSet.getNumRuptures());
            Preconditions.checkState((!namesToRakesMap.containsKey(dm.getName()) ? 1 : 0) != 0, (String)"DM names not unique: %s", (Object)dm.getName());
            namesToRakesMap.put(dm.getName(), rakes);
        }
        this.rakesMap = ImmutableMap.copyOf(namesToRakesMap);
    }

    @Override
    public String getFileName() {
        return FILE_NAME;
    }

    @Override
    public String getName() {
        return "Def. Model-Specific Rupture Rakes";
    }

    public double[] getRakes(RupSetDeformationModel dm) {
        return this.getRakes(dm.getName());
    }

    public double[] getRakes(String dmName) {
        return (double[])this.rakesMap.get((Object)dmName);
    }

    @Override
    public CSVFile<?> getCSV() {
        CSVFile csv = new CSVFile(true);
        ArrayList<String> header = new ArrayList<String>();
        header.add("Rupture Index");
        ArrayList<double[]> dmRakes = new ArrayList<double[]>();
        for (String dm : this.rakesMap.keySet()) {
            header.add(dm);
            dmRakes.add((double[])this.rakesMap.get((Object)dm));
        }
        csv.addLine(header);
        for (int rupIndex = 0; rupIndex < this.rupSet.getNumRuptures(); ++rupIndex) {
            ArrayList<CallSite> line = new ArrayList<CallSite>(header.size());
            line.add((CallSite)((Object)("" + rupIndex)));
            for (double[] rakes : dmRakes) {
                line.add((CallSite)((Object)("" + (float)rakes[rupIndex])));
            }
            csv.addLine(line);
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        List<String> header = csv.getLine(0);
        int numRups = csv.getNumRows() - 1;
        LinkedHashMap<String, double[]> rakesMap = new LinkedHashMap<String, double[]>();
        ArrayList<double[]> rakesList = new ArrayList<double[]>();
        for (int col = 1; col < header.size(); ++col) {
            String name = header.get(col);
            Preconditions.checkState((!rakesMap.containsKey(name) ? 1 : 0) != 0, (String)"Duplicate name: %s", (Object)name);
            double[] rakes = new double[numRups];
            rakesMap.put(name, rakes);
            rakesList.add(rakes);
        }
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int rupIndex = csv.getInt(row, 0);
            Preconditions.checkState((rupIndex == row - 1 ? 1 : 0) != 0, (String)"Ruptures not in order? Expected rupIndex=%s for row %s, got %s", (Object)(row - 1), (Object)row, (Object)rupIndex);
            for (int d = 0; d < rakesMap.size(); ++d) {
                ((double[])rakesList.get((int)d))[rupIndex] = csv.getDouble(row, d + 1);
            }
        }
        this.rakesMap = ImmutableMap.copyOf(rakesMap);
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        Preconditions.checkNotNull((Object)parent, (Object)"Cannot set null rupture set");
        Preconditions.checkNotNull(this.rakesMap, (Object)"Must initialize first");
        if (this.rupSet == null) {
            for (String dm : this.rakesMap.keySet()) {
                double[] rakes = (double[])this.rakesMap.get((Object)dm);
                Preconditions.checkState((rakes.length == this.rupSet.getNumRuptures() ? 1 : 0) != 0);
            }
        } else {
            Preconditions.checkState((boolean)this.rupSet.isEquivalentTo(parent), (Object)"New rupture set is not equivalent to original");
        }
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    @Override
    public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
        DefModelRupRakes ret = new DefModelRupRakes();
        ret.rakesMap = this.rakesMap;
        ret.setParent(newParent);
        return ret;
    }
}

