/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.primitives.Ints;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.CSVReader;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.commons.util.modules.helpers.LargeCSV_BackedModule;
import org.opensha.sha.earthquake.PointSource;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.aftershocks.MagnitudeDependentAftershockFilter;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.utils.PointSurfaceBuilder;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.FocalMech;
import org.opensha.sha.util.TectonicRegionType;

public abstract class GridSourceList
implements GridSourceProvider,
ArchivableModule {
    private LocationList locs;
    private GriddedRegion gridReg;
    private double latGridSpacing = Double.NaN;
    private double lonGridSpacing = Double.NaN;
    private transient GriddedRegion encompassingRegion = null;
    private int[] encompassingIndexesToLocIndexes = null;
    private static List<Range<Double>> SS_RANGES = List.of(Range.closedOpen((Comparable)Double.valueOf(-180.0), (Comparable)Double.valueOf(-135.0)), Range.open((Comparable)Double.valueOf(-45.0), (Comparable)Double.valueOf(45.0)), Range.openClosed((Comparable)Double.valueOf(135.0), (Comparable)Double.valueOf(180.0)));
    private static Range<Double> REV_RANGE = Range.closed((Comparable)Double.valueOf(45.0), (Comparable)Double.valueOf(135.0));
    private static Range<Double> NORM_RANGE = Range.closed((Comparable)Double.valueOf(-135.0), (Comparable)Double.valueOf(-45.0));
    public static final String ARCHIVE_GRID_LOCS_FILE_NAME = "grid_source_locations.csv";
    public static final String ARCHIVE_GRID_SOURCES_FILE_NAME = "grid_sources.csv";
    private static final int locRoundScale = 3;
    private static final int magRoundScale = 3;
    private static final int mechRoundSigFigs = 3;
    private static final int depthRoundSigFigs = 3;
    private static final int lenRoundSigFigs = 3;
    private static final int rateRoundSigFigs = 6;
    private boolean round = true;
    private static GriddedRupturePropComparator RUP_NON_AVERAGED_PROPS_COMPARATOR = new GriddedRupturePropComparator(true);
    private static GriddedRupturePropComparator RUP_FULL_PROPS_COMPARATOR = new GriddedRupturePropComparator(false);

    private GridSourceList() {
    }

    protected GridSourceList(GriddedRegion gridReg) {
        this(gridReg, gridReg.getNodeList());
    }

    protected GridSourceList(LocationList locs) {
        this(null, locs);
    }

    protected GridSourceList(GriddedRegion gridReg, LocationList locs) {
        this.setLocations(gridReg, locs);
    }

    protected void setLocations(GriddedRegion gridReg, LocationList locs) {
        Preconditions.checkNotNull((Object)locs);
        if (gridReg != null) {
            Preconditions.checkState((locs.size() == gridReg.getNodeCount() ? 1 : 0) != 0, (String)"Location list has %s locations, gridded region has %s", (int)locs.size(), (int)gridReg.getNodeCount());
            this.latGridSpacing = gridReg.getLatSpacing();
            this.lonGridSpacing = gridReg.getLonSpacing();
        } else {
            double minLatSpacing = Double.POSITIVE_INFINITY;
            double minLonSpacing = Double.POSITIVE_INFINITY;
            Location prevLoc = null;
            for (Location loc : locs) {
                if (prevLoc != null) {
                    double latDiff = Math.abs(loc.lat - prevLoc.lat);
                    double lonDiff = Math.abs(loc.lon - prevLoc.lon);
                    if ((float)latDiff > 0.0f) {
                        minLatSpacing = Math.min(minLatSpacing, latDiff);
                    }
                    if ((float)lonDiff > 0.0f) {
                        minLonSpacing = Math.min(minLonSpacing, lonDiff);
                    }
                }
                prevLoc = loc;
            }
            this.latGridSpacing = minLatSpacing;
            this.lonGridSpacing = minLonSpacing;
        }
        this.gridReg = gridReg;
        this.locs = locs;
    }

    @Override
    public String getName() {
        return "Grid Source List";
    }

    @Override
    public AverageableModule.AveragingAccumulator<GridSourceProvider> averagingAccumulator() {
        return new Averager();
    }

    @Override
    public int getNumLocations() {
        return this.locs.size();
    }

    @Override
    public Location getLocation(int index) {
        return (Location)this.locs.get(index);
    }

    @Override
    public Location getLocationForSource(int sourceIndex) {
        return this.getLocation(this.getLocationIndexForSource(sourceIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocationIndex(Location location) {
        int encompassingIndex;
        if (this.gridReg != null) {
            return this.gridReg.indexForLocation(location);
        }
        if (this.encompassingRegion == null) {
            GridSourceList gridSourceList = this;
            synchronized (gridSourceList) {
                if (this.encompassingRegion == null) {
                    this.encompassingRegion = GriddedRegion.inferEncompassingRegion(this.locs);
                }
            }
        }
        if ((encompassingIndex = this.encompassingRegion.indexForLocation(location)) >= 0) {
            return this.encompassingIndexesToLocIndexes[encompassingIndex];
        }
        return -1;
    }

    public abstract TectonicRegionType tectonicRegionTypeForSourceIndex(int var1);

    public abstract IncrementalMagFreqDist getRefMFD();

    public abstract Set<Integer> getAssociatedGridIndexes(int var1);

    public abstract ImmutableList<GriddedRupture> getRuptures(TectonicRegionType var1, int var2);

    public ImmutableList<GriddedRupture> getAssociatedRuptures(int sectionIndex) {
        Set<Integer> gridIndexes = this.getAssociatedGridIndexes(sectionIndex);
        if (gridIndexes == null || gridIndexes.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        for (int gridIndex : gridIndexes) {
            for (TectonicRegionType trt : this.getTectonicRegionTypes()) {
                for (GriddedRupture rup : this.getRuptures(trt, gridIndex)) {
                    if (rup.associatedSections == null || !Ints.contains((int[])rup.associatedSections, (int)sectionIndex)) continue;
                    ret.add((Object)rup);
                }
            }
        }
        return ret.build();
    }

    public ImmutableList<GriddedRupture> getRupturesSubSeisOnFault(TectonicRegionType tectonicRegionType, int gridIndex) {
        ImmutableList.Builder subSeisRups = ImmutableList.builder();
        for (GriddedRupture rup : this.getRuptures(tectonicRegionType, gridIndex)) {
            if (rup.associatedSections == null || rup.associatedSections.length <= 0) continue;
            subSeisRups.add((Object)rup);
        }
        return subSeisRups.build();
    }

    public ImmutableList<GriddedRupture> getRupturesUnassociated(TectonicRegionType tectonicRegionType, int gridIndex) {
        ImmutableList.Builder unassocRups = ImmutableList.builder();
        for (GriddedRupture rup : this.getRuptures(tectonicRegionType, gridIndex)) {
            if (rup.associatedSections != null && rup.associatedSections.length != 0) continue;
            unassocRups.add((Object)rup);
        }
        return unassocRups.build();
    }

    @Override
    public ProbEqkSource getSource(int sourceIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
        return this.getSource(this.tectonicRegionTypeForSourceIndex(sourceIndex), this.getLocationIndexForSource(sourceIndex), duration, aftershockFilter, gridSourceSettings);
    }

    @Override
    public ProbEqkSource getSource(TectonicRegionType tectonicRegionType, int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
        return this.buildSource(this.getLocation(gridIndex), (List<GriddedRupture>)this.getRuptures(tectonicRegionType, gridIndex), duration, aftershockFilter, gridSourceSettings, tectonicRegionType);
    }

    @Override
    public ProbEqkSource getSourceSubSeisOnFault(TectonicRegionType tectonicRegionType, int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
        return this.buildSource(this.getLocation(gridIndex), (List<GriddedRupture>)this.getRupturesSubSeisOnFault(tectonicRegionType, gridIndex), duration, aftershockFilter, gridSourceSettings, tectonicRegionType);
    }

    @Override
    public ProbEqkSource getSourceUnassociated(TectonicRegionType tectonicRegionType, int gridIndex, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
        return this.buildSource(this.getLocation(gridIndex), (List<GriddedRupture>)this.getRupturesUnassociated(tectonicRegionType, gridIndex), duration, aftershockFilter, gridSourceSettings, tectonicRegionType);
    }

    @Override
    public IncrementalMagFreqDist getMFD_Unassociated(TectonicRegionType tectonicRegionType, int gridIndex) {
        return this.getMFD(tectonicRegionType, gridIndex, Double.NEGATIVE_INFINITY, true, false);
    }

    @Override
    public IncrementalMagFreqDist getMFD_SubSeisOnFault(TectonicRegionType tectonicRegionType, int gridIndex) {
        return this.getMFD(tectonicRegionType, gridIndex, Double.NEGATIVE_INFINITY, false, true);
    }

    @Override
    public IncrementalMagFreqDist getMFD(TectonicRegionType tectonicRegionType, int gridIndex, double minMag) {
        return this.getMFD(tectonicRegionType, gridIndex, minMag, true, true);
    }

    @Override
    public IncrementalMagFreqDist getMFD(TectonicRegionType tectonicRegionType, int gridIndex) {
        return this.getMFD(tectonicRegionType, gridIndex, Double.NEGATIVE_INFINITY, true, true);
    }

    @Override
    public double getCumulativeNucleationRate(int gridIndex, double minMag) {
        return this.getCumulativeNucleationRate(null, gridIndex, minMag);
    }

    @Override
    public double getCumulativeNucleationRate(TectonicRegionType tectonicRegionType, int gridIndex, double minMag) {
        double sum = 0.0;
        for (GriddedRupture rup : this.getRuptures(tectonicRegionType, gridIndex)) {
            if (!((float)rup.properties.magnitude >= (float)minMag)) continue;
            sum += rup.rate;
        }
        return sum;
    }

    @Override
    public IncrementalMagFreqDist getMFD_Unassociated(int gridIndex) {
        return this.getMFD(null, gridIndex, Double.NEGATIVE_INFINITY, true, false);
    }

    @Override
    public IncrementalMagFreqDist getMFD_SubSeisOnFault(int gridIndex) {
        return this.getMFD(null, gridIndex, Double.NEGATIVE_INFINITY, false, true);
    }

    @Override
    public IncrementalMagFreqDist getMFD(int gridIndex, double minMag) {
        return this.getMFD(null, gridIndex, minMag, true, true);
    }

    @Override
    public IncrementalMagFreqDist getMFD(int gridIndex) {
        return this.getMFD(null, gridIndex, Double.NEGATIVE_INFINITY, true, true);
    }

    private IncrementalMagFreqDist getMFD(TectonicRegionType tectonicRegionType, int gridIndex, double minMag, boolean includeUnassociated, boolean includeAssociated) {
        IncrementalMagFreqDist mfd;
        IncrementalMagFreqDist refMFD = this.getRefMFD();
        if (Double.isFinite(minMag)) {
            int minIndex = refMFD.getClosestXIndex(minMag);
            mfd = new IncrementalMagFreqDist(refMFD.getX(minIndex), refMFD.size() - minIndex, refMFD.getDelta());
            minMag = mfd.getMinX() - 0.5 * mfd.getDelta();
        } else {
            mfd = refMFD.deepClone();
            Preconditions.checkState((mfd.calcSumOfY_Vals() == 0.0 ? 1 : 0) != 0);
        }
        Preconditions.checkState((includeUnassociated || includeAssociated ? 1 : 0) != 0);
        int maxIndexNonZero = 0;
        for (GriddedRupture rup : this.getRuptures(tectonicRegionType, gridIndex)) {
            if (!(rup.properties.magnitude >= minMag) || !(rup.rate >= 0.0)) continue;
            double rate = !includeAssociated ? rup.getRateUnassociated() : (!includeUnassociated ? rup.getRateAssociated() : rup.rate);
            int index = mfd.getClosestXIndex(rup.properties.magnitude);
            mfd.add(index, rate);
            maxIndexNonZero = Integer.max(maxIndexNonZero, index);
        }
        if (maxIndexNonZero < mfd.size() - 1) {
            IncrementalMagFreqDist trimmed = new IncrementalMagFreqDist(mfd.getMinX(), maxIndexNonZero + 1, mfd.getDelta());
            for (int i = 0; i < trimmed.size(); ++i) {
                trimmed.set(i, mfd.getY(i));
            }
            mfd = trimmed;
        }
        return mfd;
    }

    @Override
    public GriddedRegion getGriddedRegion() {
        return this.gridReg;
    }

    @Override
    public GridSourceList getAboveMinMag(float minMag) {
        return new MinMagFiltered(this, minMag);
    }

    public static FocalMech getMechForRake(double rake) {
        if (REV_RANGE.contains((Comparable)Double.valueOf(rake))) {
            return FocalMech.REVERSE;
        }
        if (NORM_RANGE.contains((Comparable)Double.valueOf(rake))) {
            return FocalMech.NORMAL;
        }
        return FocalMech.STRIKE_SLIP;
    }

    @Override
    public double getFracStrikeSlip(int gridIndex) {
        return this.getFractWithRake(SS_RANGES, gridIndex);
    }

    @Override
    public double getFracReverse(int gridIndex) {
        return this.getFractWithRake(REV_RANGE, gridIndex);
    }

    @Override
    public double getFracNormal(int gridIndex) {
        return this.getFractWithRake(NORM_RANGE, gridIndex);
    }

    private double getFractWithRake(Range<Double> rakeRange, int gridIndex) {
        return this.getFractWithRake(List.of(rakeRange), gridIndex);
    }

    private double getFractWithRake(List<Range<Double>> rakeRanges, int gridIndex) {
        double totRate = 0.0;
        double rateMatching = 0.0;
        for (TectonicRegionType trt : this.getTectonicRegionTypes()) {
            ImmutableList<GriddedRupture> rups = this.getRuptures(trt, gridIndex);
            for (GriddedRupture rup : rups) {
                totRate += rup.rate;
                for (Range<Double> range : rakeRanges) {
                    if (!range.contains((Comparable)Double.valueOf(rup.properties.rake))) continue;
                    rateMatching += rup.rate;
                }
            }
        }
        if (totRate == 0.0) {
            return 0.0;
        }
        return rateMatching / totRate;
    }

    @Override
    public void scaleAll(double[] valuesArray) {
        for (TectonicRegionType trt : this.getTectonicRegionTypes()) {
            this.scaleAll(trt, valuesArray);
        }
    }

    public void setArchiveRounding(boolean round) {
        this.round = true;
    }

    public CSVFile<String> buildGridLocsCSV() {
        CSVFile<String> gridCSV = new CSVFile<String>(true);
        gridCSV.addLine("Grid Index", "Latitude", "Longitude");
        for (int i = 0; i < this.getNumLocations(); ++i) {
            Location loc = this.getLocation(i);
            gridCSV.addLine((String[])new String[]{"" + i, this.getFixedPrecision(loc.lat, 3), this.getFixedPrecision(loc.lon, 3)});
        }
        return gridCSV;
    }

    public void writeGridSourcesCSV(ArchiveOutput output, String entryName) throws IOException {
        output.putNextEntry(entryName);
        CSVWriter rupCSV = new CSVWriter(output.getOutputStream(), false);
        ArrayList<String> header = new ArrayList<String>();
        header.add("Grid Index");
        header.add("Magnitude");
        header.add("Annual Rate");
        header.add("Rake");
        header.add("Dip");
        header.add("Strike");
        header.add("Upper Depth (km)");
        header.add("Lower Depth (km)");
        header.add("Length (km)");
        header.add("Hypocentral Depth (km)");
        header.add("Hypocentral DAS (km)");
        header.add("Tectonic Regime");
        int maxNumAssoc = 0;
        for (TectonicRegionType trt : this.getTectonicRegionTypes()) {
            for (int i = 0; i < this.getNumLocations(); ++i) {
                for (GriddedRupture rup : this.getRuptures(trt, i)) {
                    if (rup.associatedSections == null) continue;
                    maxNumAssoc = Integer.max(maxNumAssoc, rup.associatedSections.length);
                }
            }
        }
        if (maxNumAssoc > 0) {
            if (maxNumAssoc == 1) {
                header.add("Associated Section Index");
                header.add("Fraction Associated");
            } else {
                header.add("Associated Section Index 1");
                header.add("Fraction Associated 1");
                header.add("Associated Section Index N");
                header.add("Fraction Associated N");
            }
        }
        rupCSV.write(header);
        for (int i = 0; i < this.getNumLocations(); ++i) {
            for (TectonicRegionType trt : this.getTectonicRegionTypes()) {
                for (GriddedRupture rup : this.getRuptures(trt, i)) {
                    List<String> line = this.buildRuptureCSVLine(rup);
                    rupCSV.write(line);
                }
            }
        }
        rupCSV.flush();
        output.closeEntry();
    }

    public List<String> buildRuptureCSVLine(GriddedRupture rup) {
        ArrayList<String> line = new ArrayList<String>(12);
        line.add("" + rup.gridIndex);
        line.add(this.getFixedPrecision(rup.properties.magnitude, 3));
        line.add(this.getSigFigs(rup.rate, 6));
        line.add(this.getSigFigs(rup.properties.rake, 3));
        line.add(this.getSigFigs(rup.properties.dip, 3));
        if (rup.properties.strikeRange != null) {
            line.add(this.rangeToString(rup.properties.strikeRange));
        } else {
            line.add(this.getSigFigs(rup.properties.strike, 3));
        }
        line.add(this.getSigFigs(rup.properties.upperDepth, 3));
        line.add(this.getSigFigs(rup.properties.lowerDepth, 3));
        line.add(this.getSigFigs(rup.properties.length, 3));
        line.add(this.getSigFigs(rup.properties.hypocentralDepth, 3));
        line.add(this.getSigFigs(rup.properties.hypocentralDAS, 3));
        line.add(rup.properties.tectonicRegionType.name());
        if (rup.associatedSections != null) {
            for (int s = 0; s < rup.associatedSections.length; ++s) {
                line.add("" + rup.associatedSections[s]);
                line.add(this.getSigFigs(rup.associatedSectionFracts[s], 6));
            }
        }
        return line;
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        if (this.gridReg != null) {
            FileBackedModule.initEntry(output, entryPrefix, "grid_region.geojson");
            Feature regFeature = this.gridReg.toFeature();
            OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
            Feature.write(regFeature, writer);
            writer.flush();
            output.closeEntry();
        }
        CSV_BackedModule.writeToArchive(this.buildGridLocsCSV(), output, entryPrefix, ARCHIVE_GRID_LOCS_FILE_NAME);
        this.writeGridSourcesCSV(output, ArchivableModule.getEntryName(entryPrefix, ARCHIVE_GRID_SOURCES_FILE_NAME));
    }

    @Override
    public Class<? extends ArchivableModule> getLoadingClass() {
        return Precomputed.class;
    }

    private static boolean isRangeString(String str) {
        return (str = str.trim()).startsWith("[") && str.endsWith("]");
    }

    private static Range<Double> parseRangeString(String str) {
        String lastStr;
        String firstStr;
        str = str.trim();
        Preconditions.checkState((boolean)GridSourceList.isRangeString(str));
        str = str.substring(1, str.length() - 1);
        if (str.contains(",")) {
            int commaIndex = str.indexOf(",");
            firstStr = str.substring(0, commaIndex);
            lastStr = str.substring(commaIndex + 1);
        } else {
            Preconditions.checkState((boolean)str.contains(".."));
            int dotsIndex = str.indexOf("..");
            firstStr = str.substring(0, dotsIndex);
            lastStr = str.substring(dotsIndex + 2);
        }
        double lower = Double.parseDouble(firstStr.trim());
        double upper = Double.parseDouble(lastStr.trim());
        return Range.closed((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper));
    }

    private String rangeToString(Range<Double> range) {
        Preconditions.checkState((range.hasLowerBound() && range.hasUpperBound() ? 1 : 0) != 0, (Object)"Must have fixed founds");
        return "[" + this.getSigFigs((Double)range.lowerEndpoint(), 3) + ".." + this.getSigFigs((Double)range.upperEndpoint(), 3) + "]";
    }

    private String getFixedPrecision(double val, int scale) {
        if (Double.isNaN(val)) {
            return "";
        }
        if (!Double.isFinite(val)) {
            return "" + val;
        }
        if (val == Math.floor(val)) {
            return "" + (int)val;
        }
        if (!this.round) {
            return "" + val;
        }
        if ((val = DataUtils.roundFixed(val, scale)) == Math.floor(val)) {
            return "" + (int)val;
        }
        return "" + val;
    }

    private String getSigFigs(double val, int sigFigs) {
        if (Double.isNaN(val)) {
            return "";
        }
        if (!Double.isFinite(val)) {
            return "" + val;
        }
        if (val == Math.floor(val)) {
            return "" + (int)val;
        }
        if (!this.round) {
            return "" + val;
        }
        if ((val = DataUtils.roundSigFigs(val, sigFigs)) == Math.floor(val)) {
            return "" + (int)val;
        }
        return "" + val;
    }

    public static LocationList loadGridLocsCSV(CSVFile<String> gridCSV, GriddedRegion gridReg) {
        LocationList fileLocs = new LocationList();
        for (int row = 1; row < gridCSV.getNumRows(); ++row) {
            int index = row - 1;
            int csvIndex = gridCSV.getInt(row, 0);
            Preconditions.checkState((csvIndex == index ? 1 : 0) != 0, (String)"Grid locations must be in order, expected index=%s for row=%s, encountered index=%s", (Object)index, (Object)row, (Object)csvIndex);
            double lat = gridCSV.getDouble(row, 1);
            double lon = gridCSV.getDouble(row, 2);
            fileLocs.add(new Location(lat, lon));
        }
        if (gridReg == null) {
            return fileLocs;
        }
        Preconditions.checkState((gridReg.getNodeCount() == fileLocs.size() ? 1 : 0) != 0, (String)"Gridded region has %s nodes, but %s has %s", (Object)gridReg.getNodeCount(), (Object)ARCHIVE_GRID_LOCS_FILE_NAME, (Object)fileLocs.size());
        for (int i = 0; i < fileLocs.size(); ++i) {
            Location gridLoc;
            Location fileLoc = (Location)fileLocs.get(i);
            if (LocationUtils.areSimilar(fileLoc, gridLoc = gridReg.getLocation(i))) continue;
            Location roundedLoc = new Location(DataUtils.roundFixed(gridLoc.lat, 3), DataUtils.roundFixed(gridLoc.lon, 3));
            Preconditions.checkState((boolean)LocationUtils.areSimilar(fileLoc, roundedLoc), (String)"Location mismatch at index=%s between gridded region and %s: %s != %s;also tried test with rounded form: %s != %s", (Object[])new Object[]{i, ARCHIVE_GRID_LOCS_FILE_NAME, gridLoc, fileLoc, roundedLoc, fileLoc});
        }
        return gridReg.getNodeList();
    }

    public static EnumMap<TectonicRegionType, List<List<GriddedRupture>>> loadGridSourcesCSV(CSVReader rupSectsCSV, LocationList locs) {
        CSVReader.Row row;
        rupSectsCSV.read();
        EnumMap<TectonicRegionType, List<List<GriddedRupture>>> trtRuptureLists = new EnumMap<TectonicRegionType, List<List<GriddedRupture>>>(TectonicRegionType.class);
        GriddedRupturePropertiesCache cache = new GriddedRupturePropertiesCache();
        while ((row = rupSectsCSV.read()) != null) {
            List<List<GriddedRupture>> ruptureLists;
            String hypocentralDASStr;
            double hypocentralDAS;
            double hypocentralDepth;
            int gridIndex;
            int col = 0;
            Preconditions.checkState(((gridIndex = row.getInt(col++)) >= 0 && gridIndex < locs.size() ? 1 : 0) != 0, (String)"Bad gridIndex=%s with %s locations", (int)gridIndex, (int)locs.size());
            double mag = row.getDouble(col++);
            Preconditions.checkState((boolean)Double.isFinite(mag), (String)"Bad magnitude=%s", (Object)mag);
            double rate = row.getDouble(col++);
            Preconditions.checkState((Double.isFinite(rate) && rate >= 0.0 ? 1 : 0) != 0, (String)"Bad rate=%s", (Object)rate);
            double rake = row.getDouble(col++);
            FaultUtils.assertValidRake(rake);
            double dip = row.getDouble(col++);
            FaultUtils.assertValidDip(dip);
            String strikeStr = row.get(col++);
            Range<Double> strikeRange = null;
            double strike = Double.NaN;
            if (GridSourceList.isRangeString(strikeStr)) {
                strikeRange = GridSourceList.parseRangeString(strikeStr);
            } else if (!strikeStr.isBlank()) {
                strike = Double.parseDouble(strikeStr);
            }
            double upperDepth = row.getDouble(col++);
            FaultUtils.assertValidDepth(upperDepth);
            double lowerDepth = row.getDouble(col++);
            FaultUtils.assertValidDepth(lowerDepth);
            double length = row.getDouble(col++);
            Preconditions.checkState((Double.isFinite(length) && length >= 0.0 ? 1 : 0) != 0, (String)"Bad length=%s", (Object)length);
            String hypocentralDepthStr = row.get(col++);
            double d = hypocentralDepth = hypocentralDepthStr.isBlank() ? Double.NaN : Double.parseDouble(hypocentralDepthStr);
            if (!Double.isNaN(hypocentralDepth)) {
                FaultUtils.assertValidDepth(hypocentralDepth);
                Preconditions.checkState(((float)hypocentralDepth >= (float)upperDepth ? 1 : 0) != 0, (String)"Hypocentral depth (%s) must be at or below upper depth (%s)", (Object)Float.valueOf((float)hypocentralDepth), (Object)Float.valueOf((float)upperDepth));
                Preconditions.checkState(((float)hypocentralDepth <= (float)lowerDepth ? 1 : 0) != 0, (String)"Hypocentral depth (%s) must be at or above lower depth (%s)", (Object)Float.valueOf((float)hypocentralDepth), (Object)Float.valueOf((float)lowerDepth));
            }
            double d2 = hypocentralDAS = (hypocentralDASStr = row.get(col++)).isBlank() ? Double.NaN : Double.parseDouble(hypocentralDASStr);
            if (!Double.isNaN(hypocentralDAS)) {
                Preconditions.checkState((hypocentralDAS >= 0.0 && (float)hypocentralDAS <= (float)length ? 1 : 0) != 0, (String)"Hypocentral DAS (%s) must be >= 0 and <= len (%s)", (Object)Float.valueOf((float)hypocentralDAS), (Object)Float.valueOf((float)length));
            }
            TectonicRegionType tectonicRegionType = TectonicRegionType.valueOf(row.get(col++));
            int colsLeft = row.columns() - col;
            int[] associatedSections = null;
            double[] associatedSectionFracts = null;
            if (colsLeft > 0) {
                Preconditions.checkState((colsLeft % 2 == 0 ? 1 : 0) != 0, (String)"Have %s columns left for associations, which is not divisible by 2; expected pairs of id, fract", (int)colsLeft);
                int numAssoc = colsLeft / 2;
                associatedSections = new int[numAssoc];
                associatedSectionFracts = new double[numAssoc];
                for (int i = 0; i < numAssoc; ++i) {
                    String sectStr;
                    if ((sectStr = row.get(col++)).isBlank()) {
                        if (i == 0) {
                            associatedSections = null;
                            associatedSectionFracts = null;
                            break;
                        }
                        associatedSections = Arrays.copyOf(associatedSections, i);
                        associatedSectionFracts = Arrays.copyOf(associatedSectionFracts, i);
                        break;
                    }
                    int sectID = Integer.parseInt(sectStr);
                    Preconditions.checkState((sectID >= 0 ? 1 : 0) != 0, (String)"Bad associated sectID=%s", (int)sectID);
                    float fract = row.getFloat(col++);
                    Preconditions.checkState(((double)fract >= 0.0 && (double)fract <= 1.0 ? 1 : 0) != 0, (String)"Bad associated fraction=%s", (Object)Float.valueOf(fract));
                    associatedSections[i] = sectID;
                    associatedSectionFracts[i] = fract;
                }
            }
            GriddedRuptureProperties props = cache.getCached(new GriddedRuptureProperties(mag, rake, dip, strike, strikeRange, upperDepth, lowerDepth, length, hypocentralDepth, hypocentralDAS, tectonicRegionType));
            GriddedRupture rup = new GriddedRupture(gridIndex, (Location)locs.get(gridIndex), props, rate, associatedSections, associatedSectionFracts);
            if (!trtRuptureLists.containsKey(tectonicRegionType)) {
                ruptureLists = new ArrayList<List<GriddedRupture>>(locs.size());
                for (int i = 0; i < locs.size(); ++i) {
                    ruptureLists.add(null);
                }
                trtRuptureLists.put(tectonicRegionType, ruptureLists);
            }
            if ((ruptureLists = trtRuptureLists.get(tectonicRegionType)).get(gridIndex) == null) {
                ruptureLists.set(gridIndex, new ArrayList());
            }
            ruptureLists.get(gridIndex).add(rup);
        }
        return trtRuptureLists;
    }

    public static PointSurfaceBuilder surfBuilderForRup(GriddedRupture rup) {
        PointSurfaceBuilder builder = new PointSurfaceBuilder(rup.location);
        return GridSourceList.updateSurfBuilderForLoc(builder, rup, false);
    }

    private static PointSurfaceBuilder updateSurfBuilderForLoc(PointSurfaceBuilder surfBuilder, GriddedRupture rup, boolean forcePointSurf) {
        surfBuilder.magnitude(rup.properties.magnitude);
        surfBuilder.dip(rup.properties.dip);
        if (forcePointSurf) {
            surfBuilder.strike(Double.NaN);
        } else if (Double.isFinite(rup.properties.strike)) {
            surfBuilder.strike(rup.properties.strike);
        } else if (rup.properties.strikeRange != null) {
            surfBuilder.strikeRange(rup.properties.strikeRange);
        } else {
            surfBuilder.strike(Double.NaN);
        }
        surfBuilder.upperDepth(rup.properties.upperDepth);
        surfBuilder.lowerDepth(rup.properties.lowerDepth);
        surfBuilder.length(rup.properties.length);
        double hypoDepth = rup.properties.getHypocentralDepth();
        surfBuilder.hypocentralDepth(hypoDepth);
        surfBuilder.das(rup.properties.getHypocentralDAS());
        return surfBuilder;
    }

    private PointSource.PoissonPointSource buildSource(Location gridLoc, List<GriddedRupture> gridRups, double duration, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings, TectonicRegionType tectonicRegionType) {
        if (gridRups.isEmpty()) {
            return null;
        }
        PointSource.PoissonBuilder builder = PointSource.poissonBuilder(gridLoc, tectonicRegionType);
        builder.data(new GriddedRuptureSourceData(gridLoc, gridRups, aftershockFilter, gridSourceSettings));
        builder.distCorrs(gridSourceSettings.distanceCorrections);
        builder.duration(duration);
        if (gridSourceSettings.supersamplingSettings != null) {
            Preconditions.checkState((this.latGridSpacing > 0.0 && this.lonGridSpacing > 0.0 ? 1 : 0) != 0);
            Region gridCell = new Region(new Location(gridLoc.lat - 0.5 * this.latGridSpacing, gridLoc.lon - 0.5 * this.lonGridSpacing), new Location(gridLoc.lat + 0.5 * this.latGridSpacing, gridLoc.lon + 0.5 * this.lonGridSpacing));
            builder.siteAdaptiveSupersampled(gridCell, gridSourceSettings.supersamplingSettings);
        }
        return builder.build();
    }

    private static List<GriddedRupture> convertGridIndex(MFDGridSourceProvider mfdGridProv, FaultGridAssociations associations, FiniteRuptureConverter converter, int gridIndex, GriddedRupturePropertiesCache cache) {
        double fractSS = mfdGridProv.getFracStrikeSlip(gridIndex);
        double fractN = mfdGridProv.getFracNormal(gridIndex);
        double fractR = mfdGridProv.getFracReverse(gridIndex);
        TectonicRegionType trt = mfdGridProv.getTectonicRegionType(gridIndex);
        IncrementalMagFreqDist mfd = mfdGridProv.getMFD(trt, gridIndex);
        if (mfd == null) {
            return null;
        }
        IncrementalMagFreqDist mfdAssoc = mfdGridProv.getMFD_SubSeisOnFault(gridIndex);
        HashMap<Integer, Double> nodeFractAssociations = null;
        if (mfdAssoc != null) {
            nodeFractAssociations = new HashMap<Integer, Double>(associations.getScaledSectFracsOnNode(gridIndex));
            Preconditions.checkState((!nodeFractAssociations.isEmpty() ? 1 : 0) != 0);
            double sumFracts = 0.0;
            Iterator<Object> iterator = nodeFractAssociations.values().iterator();
            while (iterator.hasNext()) {
                double fract = (Double)iterator.next();
                sumFracts += fract;
            }
            if ((float)sumFracts != 1.0f) {
                iterator = new ArrayList(nodeFractAssociations.keySet()).iterator();
                while (iterator.hasNext()) {
                    int sectIndex = (Integer)iterator.next();
                    nodeFractAssociations.put(sectIndex, (Double)nodeFractAssociations.get(sectIndex) / sumFracts);
                }
            }
        }
        ArrayList<GriddedRupture> ruptureList = new ArrayList<GriddedRupture>();
        for (int m = 0; m < mfd.size(); ++m) {
            double mag = mfd.getX(m);
            double totRate = mfd.getY(m);
            if (totRate == 0.0) continue;
            double associatedFract = 0.0;
            if (mfdAssoc != null && mfdAssoc.size() > m) {
                Preconditions.checkState(((float)mfdAssoc.getX(m) == (float)mag ? 1 : 0) != 0);
                double assocRate = mfdAssoc.getY(mag);
                associatedFract = assocRate / totRate;
                Preconditions.checkState(((float)associatedFract <= 1.0f ? 1 : 0) != 0, (String)"Bad associatedFract = %s / %s = %s", (Object)assocRate, (Object)totRate, (Object)associatedFract);
            }
            for (FocalMech mech : FocalMech.values()) {
                double mechRate;
                switch (mech) {
                    case STRIKE_SLIP: {
                        mechRate = totRate * fractSS;
                        break;
                    }
                    case NORMAL: {
                        mechRate = totRate * fractN;
                        break;
                    }
                    case REVERSE: {
                        mechRate = totRate * fractR;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if (mechRate == 0.0) continue;
                int[] associatedSections = null;
                double[] associatedSectionFracts = null;
                if (associatedFract > 0.0) {
                    ArrayList sectIndexes = new ArrayList(nodeFractAssociations.keySet());
                    Collections.sort(sectIndexes);
                    associatedSections = new int[sectIndexes.size()];
                    associatedSectionFracts = new double[sectIndexes.size()];
                    for (int s = 0; s < sectIndexes.size(); ++s) {
                        int sectIndex;
                        associatedSections[s] = sectIndex = ((Integer)sectIndexes.get(s)).intValue();
                        associatedSectionFracts[s] = associatedFract * (Double)nodeFractAssociations.get(sectIndex);
                    }
                }
                ruptureList.add(converter.buildFiniteRupture(gridIndex, mfdGridProv.getLocation(gridIndex), mag, mechRate, mech, trt, associatedSections, associatedSectionFracts, cache));
            }
        }
        return ruptureList;
    }

    public static GridSourceList convert(MFDGridSourceProvider mfdGridProv, FaultGridAssociations associations, FiniteRuptureConverter converter) {
        int numLocs = mfdGridProv.getNumLocations();
        GriddedRupturePropertiesCache cache = new GriddedRupturePropertiesCache();
        EnumMap<TectonicRegionType, ArrayList<List<GriddedRupture>>> trtRuptureLists = new EnumMap<TectonicRegionType, ArrayList<List<GriddedRupture>>>(TectonicRegionType.class);
        for (int gridIndex = 0; gridIndex < numLocs; ++gridIndex) {
            TectonicRegionType trt = mfdGridProv.getTectonicRegionType(gridIndex);
            ArrayList<List<GriddedRupture>> ruptureLists = (ArrayList<List<GriddedRupture>>)trtRuptureLists.get(trt);
            if (ruptureLists == null) {
                ruptureLists = new ArrayList<List<GriddedRupture>>(numLocs);
                for (int i = 0; i < numLocs; ++i) {
                    ruptureLists.add(null);
                }
                trtRuptureLists.put(trt, ruptureLists);
            }
            ruptureLists.set(gridIndex, GridSourceList.convertGridIndex(mfdGridProv, associations, converter, gridIndex, cache));
        }
        return new Precomputed(mfdGridProv.getGriddedRegion(), trtRuptureLists);
    }

    public static GridSourceList combine(GridSourceList ... gridLists) {
        Preconditions.checkState((gridLists.length > 1 ? 1 : 0) != 0);
        if (gridLists[0].gridReg != null) {
            GriddedRegion unionGridReg = gridLists[0].getGriddedRegion();
            double latSpacing = unionGridReg.getLatSpacing();
            double lonSpacing = unionGridReg.getLonSpacing();
            Location anchor = unionGridReg.getLocation(0);
            ArrayList<String> unionedNames = new ArrayList<String>();
            unionedNames.add(unionGridReg.getName());
            for (int i = 1; unionGridReg != null && i < gridLists.length; ++i) {
                GriddedRegion myReg = gridLists[i].getGriddedRegion();
                if (myReg == null) {
                    System.err.println("WARNING: region " + i + " is null, won't use regions when combining");
                    unionGridReg = null;
                    continue;
                }
                if ((float)myReg.getLatSpacing() != (float)latSpacing || (float)myReg.getLonSpacing() != (float)lonSpacing) {
                    System.err.println("WARNING: region " + i + " (" + myReg.getName() + ") has different spacing than previous region(s)");
                    unionGridReg = null;
                    continue;
                }
                if (myReg.equals(unionGridReg)) continue;
                int fullyContained = 1;
                for (Location loc : myReg.getNodeList()) {
                    if (unionGridReg.indexForLocation(loc) >= 0) continue;
                    fullyContained = 0;
                    break;
                }
                if (fullyContained != 0) continue;
                Region unionReg = Region.union(unionGridReg, myReg);
                if (unionReg == null) {
                    unionGridReg = null;
                    System.err.println("WARNING: couldn't union region " + i + " (" + myReg.getName() + ") with prior region(s): " + Joiner.on((String)"; ").join(unionedNames));
                    break;
                }
                unionedNames.add(myReg.getName());
                unionGridReg = new GriddedRegion(unionReg, latSpacing, lonSpacing, anchor);
            }
            if (unionGridReg != null) {
                boolean fullyContained = true;
                for (GridSourceList gridList : gridLists) {
                    GriddedRegion myReg = gridList.getGriddedRegion();
                    for (Location loc : myReg.getNodeList()) {
                        if (unionGridReg.indexForLocation(loc) >= 0) continue;
                        fullyContained = false;
                        break;
                    }
                    if (!fullyContained) break;
                }
                if (fullyContained) {
                    System.out.println("Building combined GridSourceList using stitched gridded region");
                    return GridSourceList.combine(unionGridReg, gridLists);
                }
                System.err.println("WARNING: built a stitched gridded region for all sub-regions but there's a gridding mismatch, will revert to just a location list");
            } else {
                System.err.println("WARNING: couldn't build a stitched gridded region for all sub-regions, will revert to just a location list");
            }
        }
        System.out.println("Building combined GridSourceList using a location list (no stitched region)");
        LocationList locs = new LocationList();
        HashMap<Location, Integer> locIndexMap = new HashMap<Location, Integer>();
        EnumMap trtRuptureLists = new EnumMap(TectonicRegionType.class);
        int rawNumLocs = 0;
        for (GridSourceList gridList : gridLists) {
            for (int gridIndex = 0; gridIndex < gridList.getNumLocations(); ++gridIndex) {
                Location loc = gridList.getLocation(gridIndex);
                Integer index = (Integer)locIndexMap.get(loc);
                ++rawNumLocs;
                if (index != null) continue;
                index = locs.size();
                locs.add(loc);
                locIndexMap.put(loc, index);
            }
        }
        System.out.println("Found " + locs.size() + " unique locations (out of " + rawNumLocs + " total)");
        for (GridSourceList gridList : gridLists) {
            for (TectonicRegionType trt : gridList.getTectonicRegionTypes()) {
                ArrayList ruptureLists = (ArrayList)trtRuptureLists.get(trt);
                if (ruptureLists == null) {
                    ruptureLists = new ArrayList(locs.size());
                    for (int i = 0; i < locs.size(); ++i) {
                        ruptureLists.add(null);
                    }
                    trtRuptureLists.put(trt, ruptureLists);
                }
                for (int gridIndex = 0; gridIndex < gridList.getNumLocations(); ++gridIndex) {
                    ImmutableList<GriddedRupture> rups = gridList.getRuptures(trt, gridIndex);
                    if (rups.isEmpty()) continue;
                    Location loc = gridList.getLocation(gridIndex);
                    Integer mappedIndex = (Integer)locIndexMap.get(loc);
                    Preconditions.checkNotNull((Object)mappedIndex, (String)"Location %s is not mapped to a location in the combined location list?", (Object)loc);
                    ArrayList<GriddedRupture> destRups = (ArrayList<GriddedRupture>)ruptureLists.get(mappedIndex);
                    if (destRups == null) {
                        destRups = new ArrayList<GriddedRupture>(rups.size());
                        ruptureLists.set(mappedIndex, destRups);
                    }
                    for (GriddedRupture rup : rups) {
                        destRups.add(rup.copyNewGridIndex(mappedIndex));
                    }
                }
            }
        }
        return new Precomputed(locs, trtRuptureLists);
    }

    public static GridSourceList combine(GriddedRegion combRegion, GridSourceList ... gridLists) {
        EnumMap trtRuptureLists = new EnumMap(TectonicRegionType.class);
        for (GridSourceList gridList : gridLists) {
            for (TectonicRegionType trt : gridList.getTectonicRegionTypes()) {
                ArrayList ruptureLists = (ArrayList)trtRuptureLists.get(trt);
                if (ruptureLists == null) {
                    ruptureLists = new ArrayList(combRegion.getNodeCount());
                    for (int i = 0; i < combRegion.getNodeCount(); ++i) {
                        ruptureLists.add(null);
                    }
                    trtRuptureLists.put(trt, ruptureLists);
                }
                for (int gridIndex = 0; gridIndex < gridList.getNumLocations(); ++gridIndex) {
                    ImmutableList<GriddedRupture> rups = gridList.getRuptures(trt, gridIndex);
                    if (rups.isEmpty()) continue;
                    Location loc = gridList.getLocation(gridIndex);
                    Preconditions.checkState((boolean)loc.equals(gridList.getGriddedRegion().getLocation(gridIndex)));
                    int mappedGridIndex = combRegion.indexForLocation(loc);
                    Preconditions.checkState((mappedGridIndex >= 0 ? 1 : 0) != 0, (String)"Location %s is not mapped to a location in the given combined gridded region", (Object)loc);
                    ArrayList<GriddedRupture> destRups = (ArrayList<GriddedRupture>)ruptureLists.get(mappedGridIndex);
                    if (destRups == null) {
                        destRups = new ArrayList<GriddedRupture>(rups.size());
                        ruptureLists.set(mappedGridIndex, destRups);
                    }
                    for (GriddedRupture rup : rups) {
                        destRups.add(rup.copyNewGridIndex(mappedGridIndex));
                    }
                }
            }
        }
        return new Precomputed(combRegion, trtRuptureLists);
    }

    public static GridSourceList remapAssociations(GridSourceList original, int[] sectRemappings) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(sectRemappings.length);
        for (int s = 0; s < sectRemappings.length; ++s) {
            map.put(s, sectRemappings[s]);
        }
        return GridSourceList.remapAssociations(original, map);
    }

    public static GridSourceList remapAssociations(GridSourceList original, Map<Integer, Integer> sectRemappings) {
        return new GridSourceListAssocRemapper(original, sectRemappings);
    }

    public static class Averager
    implements AverageableModule.AveragingAccumulator<GridSourceProvider> {
        private GriddedRegion gridReg = null;
        private LocationList locs;
        private EnumMap<TectonicRegionType, List<List<GriddedRuptureProperties>>> trtRupturePropLists;
        private EnumMap<TectonicRegionType, List<List<RuptureAverager>>> trtRuptureAvgLists;
        private double totWeight = 0.0;
        private GriddedRupturePropertiesCache cache = new GriddedRupturePropertiesCache();
        private boolean haveMultipleDepths;
        private final boolean D = true;

        @Override
        public Class<GridSourceProvider> getType() {
            return GridSourceProvider.class;
        }

        @Override
        public void process(GridSourceProvider module, double relWeight) {
            Preconditions.checkState((boolean)(module instanceof GridSourceList), (Object)"Can only average if all GridSourceProviders are of type GridSourceList");
            GridSourceList sourceList = (GridSourceList)module;
            if (this.trtRupturePropLists == null) {
                this.trtRupturePropLists = new EnumMap(TectonicRegionType.class);
                this.trtRuptureAvgLists = new EnumMap(TectonicRegionType.class);
                Preconditions.checkState((this.totWeight == 0.0 ? 1 : 0) != 0, (Object)"Can't reuse averagers");
                this.gridReg = sourceList.getGriddedRegion();
                this.locs = sourceList.locs;
                this.haveMultipleDepths = false;
                for (TectonicRegionType trt : sourceList.getTectonicRegionTypes()) {
                    for (int gridIndex = 0; !this.haveMultipleDepths && gridIndex < this.locs.size(); ++gridIndex) {
                        ImmutableList<GriddedRupture> ruptures = sourceList.getRuptures(trt, gridIndex);
                        if (ruptures.isEmpty()) continue;
                        ArrayList<GriddedRuptureProperties> props = new ArrayList<GriddedRuptureProperties>(ruptures.size());
                        for (GriddedRupture rup : ruptures) {
                            props.add(rup.properties);
                        }
                        props.sort(RUP_NON_AVERAGED_PROPS_COMPARATOR);
                        for (int i = 1; !this.haveMultipleDepths && i < ruptures.size(); ++i) {
                            this.haveMultipleDepths = RUP_NON_AVERAGED_PROPS_COMPARATOR.compare((GriddedRuptureProperties)props.get(i - 1), (GriddedRuptureProperties)props.get(i)) == 0;
                        }
                    }
                }
                if (this.haveMultipleDepths) {
                    System.out.println("GridSourceList.Averager: we have multiple depths/lengths for otherwise unique ruptures; will not average any depth information");
                }
            } else {
                Preconditions.checkState((this.locs.size() == sourceList.getNumLocations() ? 1 : 0) != 0);
                for (int i = 0; i < this.locs.size(); ++i) {
                    Preconditions.checkState((boolean)LocationUtils.areSimilar((Location)this.locs.get(i), sourceList.getLocation(i)));
                }
            }
            GriddedRupturePropComparator comp = this.haveMultipleDepths ? RUP_FULL_PROPS_COMPARATOR : RUP_NON_AVERAGED_PROPS_COMPARATOR;
            for (TectonicRegionType trt : sourceList.getTectonicRegionTypes()) {
                List<List<GriddedRuptureProperties>> rupturePropLists = this.trtRupturePropLists.get(trt);
                List<List<RuptureAverager>> ruptureAvgLists = this.trtRuptureAvgLists.get(trt);
                if (rupturePropLists == null) {
                    rupturePropLists = new ArrayList<List<GriddedRuptureProperties>>(this.locs.size());
                    ruptureAvgLists = new ArrayList<List<RuptureAverager>>(this.locs.size());
                    for (int i = 0; i < this.locs.size(); ++i) {
                        rupturePropLists.add(null);
                        ruptureAvgLists.add(null);
                    }
                    this.trtRupturePropLists.put(trt, rupturePropLists);
                    this.trtRuptureAvgLists.put(trt, ruptureAvgLists);
                }
                int[] prevMatchIndexes = null;
                for (int gridIndex = 0; gridIndex < this.locs.size(); ++gridIndex) {
                    ImmutableList<GriddedRupture> ruptures = sourceList.getRuptures(trt, gridIndex);
                    if (ruptures.isEmpty()) continue;
                    if (prevMatchIndexes == null) {
                        prevMatchIndexes = new int[ruptures.size()];
                        for (int i = 0; i < prevMatchIndexes.length; ++i) {
                            prevMatchIndexes[i] = -1;
                        }
                    } else if (ruptures.size() > prevMatchIndexes.length) {
                        int prevLen = prevMatchIndexes.length;
                        prevMatchIndexes = Arrays.copyOf(prevMatchIndexes, ruptures.size());
                        for (int i = prevLen; i < prevMatchIndexes.length; ++i) {
                            prevMatchIndexes[i] = -1;
                        }
                    }
                    List<GriddedRuptureProperties> rupturePropsList = rupturePropLists.get(gridIndex);
                    List<RuptureAverager> ruptureAvgs = ruptureAvgLists.get(gridIndex);
                    if (rupturePropsList == null) {
                        rupturePropsList = new ArrayList<GriddedRuptureProperties>();
                        ruptureAvgs = new ArrayList<RuptureAverager>();
                        rupturePropLists.set(gridIndex, rupturePropsList);
                        ruptureAvgLists.set(gridIndex, ruptureAvgs);
                    }
                    for (int i = 0; i < ruptures.size(); ++i) {
                        RuptureAverager props;
                        GriddedRupture rupture = (GriddedRupture)ruptures.get(i);
                        int index = prevMatchIndexes[i] >= 0 && rupturePropsList.size() > prevMatchIndexes[i] && comp.compare(rupture.properties, rupturePropsList.get(prevMatchIndexes[i])) == 0 ? prevMatchIndexes[i] : (i < rupturePropsList.size() && comp.compare(rupture.properties, rupturePropsList.get(i)) == 0 ? i : Collections.binarySearch(rupturePropsList, rupture.properties, comp));
                        if (index < 0) {
                            index = -(index + 1);
                            rupturePropsList.add(index, this.cache.getCached(rupture.properties));
                            props = new RuptureAverager();
                            ruptureAvgs.add(index, props);
                        } else {
                            props = ruptureAvgs.get(index);
                            if (i != index) {
                                prevMatchIndexes[i] = index;
                            }
                        }
                        props.add(rupture, relWeight);
                    }
                    Preconditions.checkState((rupturePropsList.size() == ruptureAvgs.size() ? 1 : 0) != 0);
                }
            }
            this.totWeight += relWeight;
        }

        @Override
        public GridSourceProvider getAverage() {
            Preconditions.checkState((this.totWeight > 0.0 ? 1 : 0) != 0, (Object)"No weight assigned?");
            EnumMap trtRuptureListsOut = new EnumMap(TectonicRegionType.class);
            for (TectonicRegionType trt : this.trtRupturePropLists.keySet()) {
                List<List<GriddedRuptureProperties>> rupturePropLists = this.trtRupturePropLists.get(trt);
                List<List<RuptureAverager>> ruptureAvgLists = this.trtRuptureAvgLists.get(trt);
                Preconditions.checkState((rupturePropLists.size() == this.locs.size() ? 1 : 0) != 0, (String)"rupList has %s, expected %s", (int)rupturePropLists.size(), (int)this.locs.size());
                Preconditions.checkState((ruptureAvgLists.size() == this.locs.size() ? 1 : 0) != 0, (String)"rupPropList has %s, expected %s", (int)ruptureAvgLists.size(), (int)this.locs.size());
                ArrayList ruptureListsOut = new ArrayList(this.locs.size());
                for (int gridIndex = 0; gridIndex < this.locs.size(); ++gridIndex) {
                    if (rupturePropLists.get(gridIndex) == null) {
                        ruptureListsOut.add(null);
                        continue;
                    }
                    List<GriddedRuptureProperties> rupturePropsList = rupturePropLists.get(gridIndex);
                    List<RuptureAverager> ruptureAvgs = ruptureAvgLists.get(gridIndex);
                    Preconditions.checkState((rupturePropsList.size() == ruptureAvgs.size() ? 1 : 0) != 0, (String)"rupList has %s, props has %s", (int)rupturePropsList.size(), (int)ruptureAvgs.size());
                    ArrayList<GriddedRupture> ruptureListOut = new ArrayList<GriddedRupture>(rupturePropsList.size());
                    for (int i = 0; i < rupturePropsList.size(); ++i) {
                        GriddedRupture modRup = ruptureAvgs.get(i).build(gridIndex, (Location)this.locs.get(gridIndex), this.totWeight, this.cache);
                        ruptureListOut.add(modRup);
                    }
                    ruptureListsOut.add(ruptureListOut);
                    Preconditions.checkState((ruptureListOut.size() == rupturePropsList.size() ? 1 : 0) != 0);
                }
                Preconditions.checkState((ruptureListsOut.size() == this.locs.size() ? 1 : 0) != 0);
                trtRuptureListsOut.put(trt, ruptureListsOut);
            }
            Precomputed ret = new Precomputed(this.gridReg, this.locs, trtRuptureListsOut);
            this.trtRupturePropLists = null;
            return ret;
        }
    }

    public static final class GriddedRupture
    implements Comparable<GriddedRupture> {
        public final GriddedRuptureProperties properties;
        public final int gridIndex;
        public final Location location;
        public final double rate;
        public final int[] associatedSections;
        public final double[] associatedSectionFracts;
        private transient int hashCode = -1;

        public GriddedRupture(int gridIndex, Location location, GriddedRuptureProperties props, double rate) {
            this(gridIndex, location, props, rate, null, null);
        }

        public GriddedRupture(int gridIndex, Location location, GriddedRuptureProperties props, double rate, int[] associatedSections, double[] associatedSectionFracts) {
            this.gridIndex = gridIndex;
            this.location = location;
            this.properties = props;
            this.rate = rate;
            Preconditions.checkState((associatedSections == null == (associatedSectionFracts == null) ? 1 : 0) != 0);
            if (associatedSections != null) {
                Preconditions.checkState((associatedSections.length > 0 ? 1 : 0) != 0, (Object)"Associations should be either null or non-empty");
                Preconditions.checkState((associatedSections.length == associatedSectionFracts.length ? 1 : 0) != 0);
                this.associatedSections = associatedSections;
                for (double assoc : associatedSectionFracts) {
                    Preconditions.checkState((assoc > 0.0 ? 1 : 0) != 0, (String)"Association fractions must be >0: %s", (Object)assoc);
                }
                this.associatedSectionFracts = associatedSectionFracts;
            } else {
                this.associatedSections = null;
                this.associatedSectionFracts = null;
            }
        }

        public GriddedRupture copyNewRate(double modRate) {
            return new GriddedRupture(this.gridIndex, this.location, this.properties, modRate, this.associatedSections, this.associatedSectionFracts);
        }

        public GriddedRupture copyNewGridIndex(int gridIndex) {
            return new GriddedRupture(gridIndex, this.location, this.properties, this.rate, this.associatedSections, this.associatedSectionFracts);
        }

        public double getFractAssociated(int sectionIndex) {
            if (this.associatedSections == null) {
                return 0.0;
            }
            for (int i = 0; i < this.associatedSections.length; ++i) {
                if (this.associatedSections[i] != sectionIndex) continue;
                return this.associatedSectionFracts[i];
            }
            return 0.0;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.calcHashCode();
            }
            return this.hashCode;
        }

        public int calcHashCode() {
            int prime = 31;
            int result = this.properties.hashCode();
            result = 31 * result + this.gridIndex;
            result = 31 * result + Double.hashCode(this.rate);
            result = 31 * result + Arrays.hashCode(this.associatedSectionFracts);
            result = 31 * result + Arrays.hashCode(this.associatedSections);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            GriddedRupture other = (GriddedRupture)obj;
            return this.gridIndex == other.gridIndex && Double.doubleToLongBits(this.rate) == Double.doubleToLongBits(other.rate) && Arrays.equals(this.associatedSectionFracts, other.associatedSectionFracts) && Arrays.equals(this.associatedSections, other.associatedSections) && this.properties.equals(other.properties);
        }

        @Override
        public int compareTo(GriddedRupture other) {
            return RUP_FULL_PROPS_COMPARATOR.compare(this.properties, other.properties);
        }

        public double getFractAssociated() {
            if (this.associatedSectionFracts == null) {
                return 0.0;
            }
            double fractSum = 0.0;
            for (double fract : this.associatedSectionFracts) {
                fractSum += fract;
            }
            Preconditions.checkState((fractSum > 0.0 && (float)fractSum <= 1.0f ? 1 : 0) != 0);
            if ((float)fractSum == 1.0f) {
                return 1.0;
            }
            return Math.min(fractSum, 1.0);
        }

        public double getRateAssociated() {
            if (this.associatedSectionFracts == null) {
                return 0.0;
            }
            double fractAssoc = this.getFractAssociated();
            if ((float)fractAssoc == 0.0f) {
                return 0.0;
            }
            return this.rate * fractAssoc;
        }

        public double getRateUnassociated() {
            if (this.associatedSectionFracts == null) {
                return this.rate;
            }
            double fractUnassoc = 1.0 - this.getFractAssociated();
            if ((float)fractUnassoc == 0.0f) {
                return 0.0;
            }
            if ((float)fractUnassoc == 1.0f) {
                return this.rate;
            }
            return this.rate * fractUnassoc;
        }
    }

    public static final class GriddedRuptureProperties
    implements Comparable<GriddedRuptureProperties> {
        public final double magnitude;
        public final double rake;
        public final double dip;
        public final double strike;
        public final Range<Double> strikeRange;
        public final double upperDepth;
        public final double lowerDepth;
        public final double length;
        public final double hypocentralDepth;
        public final double hypocentralDAS;
        public final TectonicRegionType tectonicRegionType;
        private transient int hashCode = -1;

        public GriddedRuptureProperties(double magnitude, double rake, double dip, double strike, Range<Double> strikeRange, double upperDepth, double lowerDepth, double length, double hypocentralDepth, double hypocentralDAS, TectonicRegionType tectonicRegionType) {
            this.magnitude = magnitude;
            this.rake = rake;
            this.dip = dip;
            this.strike = strike;
            this.strikeRange = strikeRange;
            this.upperDepth = upperDepth;
            this.lowerDepth = lowerDepth;
            this.length = length;
            this.hypocentralDepth = hypocentralDepth;
            this.hypocentralDAS = hypocentralDAS;
            this.tectonicRegionType = tectonicRegionType;
        }

        public double getHypocentralDepth() {
            if (Double.isFinite(this.hypocentralDepth)) {
                return this.hypocentralDepth;
            }
            if (this.lowerDepth == this.upperDepth) {
                return this.upperDepth;
            }
            return this.upperDepth + 0.5 * (this.lowerDepth - this.upperDepth);
        }

        public double getFractionalHypocentralDAS() {
            if (Double.isFinite(this.hypocentralDAS)) {
                return this.hypocentralDAS / this.length;
            }
            return 0.5;
        }

        public double getHypocentralDAS() {
            if (Double.isFinite(this.hypocentralDAS)) {
                return this.hypocentralDAS;
            }
            return 0.5 * this.length;
        }

        public double getDownDipWidth() {
            double height = this.lowerDepth - this.upperDepth;
            return height / Math.sin(Math.toRadians(this.dip));
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                this.hashCode = this.calcHashCode();
            }
            return this.hashCode;
        }

        public int calcHashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hash(this.dip, this.hypocentralDAS, this.hypocentralDepth, this.length, this.lowerDepth, this.magnitude, this.rake, this.strike, this.strikeRange, this.tectonicRegionType, this.upperDepth);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            GriddedRuptureProperties other = (GriddedRuptureProperties)obj;
            return Double.doubleToLongBits(this.dip) == Double.doubleToLongBits(other.dip) && Double.doubleToLongBits(this.hypocentralDAS) == Double.doubleToLongBits(other.hypocentralDAS) && Double.doubleToLongBits(this.hypocentralDepth) == Double.doubleToLongBits(other.hypocentralDepth) && Double.doubleToLongBits(this.length) == Double.doubleToLongBits(other.length) && Double.doubleToLongBits(this.lowerDepth) == Double.doubleToLongBits(other.lowerDepth) && Double.doubleToLongBits(this.magnitude) == Double.doubleToLongBits(other.magnitude) && Double.doubleToLongBits(this.rake) == Double.doubleToLongBits(other.rake) && Double.doubleToLongBits(this.strike) == Double.doubleToLongBits(other.strike) && Objects.equals(this.strikeRange, other.strikeRange) && this.tectonicRegionType == other.tectonicRegionType && Double.doubleToLongBits(this.upperDepth) == Double.doubleToLongBits(other.upperDepth);
        }

        @Override
        public int compareTo(GriddedRuptureProperties other) {
            return RUP_FULL_PROPS_COMPARATOR.compare(this, other);
        }

        public String toString() {
            return "GriddedRuptureProperties[magnitude=" + (float)this.magnitude + "; rake=" + (float)this.rake + "; dip=" + (float)this.dip + "; strike=" + (float)this.strike + "; strikeRange=" + String.valueOf(this.strikeRange) + "; upperDepth=" + (float)this.upperDepth + "; lowerDepth=" + (float)this.lowerDepth + "; length=" + (float)this.length + "; hypocentralDepth=" + (float)this.hypocentralDepth + "; hypocentralDAS=" + (float)this.hypocentralDAS + "; tectonicRegionType=" + (this.tectonicRegionType != null ? this.tectonicRegionType.name() : "null") + "]";
        }
    }

    private static class MinMagFiltered
    extends DynamicallyBuilt {
        private GridSourceList gridSources;
        private float minMag;

        public MinMagFiltered(GridSourceList gridSources, float minMag) {
            super(gridSources.getTectonicRegionTypes(), gridSources.getGriddedRegion(), gridSources.locs, gridSources.getRefMFD());
            this.gridSources = gridSources;
            this.minMag = minMag;
        }

        @Override
        public int getNumSources() {
            return this.gridSources.getNumSources();
        }

        @Override
        public int getLocationIndexForSource(int sourceIndex) {
            return this.gridSources.getLocationIndexForSource(sourceIndex);
        }

        @Override
        protected List<GriddedRupture> buildRuptures(TectonicRegionType tectonicRegionType, int gridIndex) {
            ImmutableList<GriddedRupture> origRups = this.gridSources.getRuptures(tectonicRegionType, gridIndex);
            if (origRups.isEmpty()) {
                return origRups;
            }
            ArrayList<GriddedRupture> rups = new ArrayList<GriddedRupture>();
            for (GriddedRupture rup : origRups) {
                if (!((float)rup.properties.magnitude >= this.minMag)) continue;
                rups.add(rup);
            }
            return rups;
        }

        @Override
        public TectonicRegionType tectonicRegionTypeForSourceIndex(int sourceIndex) {
            return this.gridSources.tectonicRegionTypeForSourceIndex(sourceIndex);
        }

        @Override
        public Set<Integer> getAssociatedGridIndexes(int sectionIndex) {
            return this.gridSources.getAssociatedGridIndexes(sectionIndex);
        }
    }

    public static class Precomputed
    extends GridSourceList {
        private IncrementalMagFreqDist refMFD;
        private EnumMap<TectonicRegionType, ImmutableList<ImmutableList<GriddedRupture>>> trtRuptureLists;
        private TectonicRegionType[] sourceTRTs;
        private int[] sourceGridIndexes;
        private Map<Integer, Set<Integer>> sectAssociations;

        private Precomputed() {
        }

        public Precomputed(LocationList locs, EnumMap<TectonicRegionType, ? extends List<? extends List<GriddedRupture>>> trtRuptureLists) {
            this.setAll(null, locs, trtRuptureLists);
        }

        public Precomputed(GriddedRegion gridReg, EnumMap<TectonicRegionType, ? extends List<? extends List<GriddedRupture>>> trtRuptureLists) {
            this.setAll(gridReg, gridReg.getNodeList(), trtRuptureLists);
        }

        public Precomputed(GriddedRegion gridReg, LocationList locs, EnumMap<TectonicRegionType, ? extends List<? extends List<GriddedRupture>>> trtRuptureLists) {
            this.setAll(gridReg, locs, trtRuptureLists);
        }

        public Precomputed(GridSourceList original, EnumMap<TectonicRegionType, ? extends List<? extends List<GriddedRupture>>> trtRuptureLists) {
            this.setAll(original.gridReg, original.locs, trtRuptureLists);
        }

        public Precomputed(GriddedRegion gridReg, TectonicRegionType trt, List<? extends List<GriddedRupture>> ruptureLists) {
            EnumMap<TectonicRegionType, List<? extends List<GriddedRupture>>> trtRuptureLists = new EnumMap<TectonicRegionType, List<? extends List<GriddedRupture>>>(TectonicRegionType.class);
            trtRuptureLists.put(trt, ruptureLists);
            this.setAll(gridReg, gridReg.getNodeList(), trtRuptureLists);
        }

        public Precomputed(LocationList locs, TectonicRegionType trt, List<? extends List<GriddedRupture>> ruptureLists) {
            EnumMap<TectonicRegionType, List<? extends List<GriddedRupture>>> trtRuptureLists = new EnumMap<TectonicRegionType, List<? extends List<GriddedRupture>>>(TectonicRegionType.class);
            trtRuptureLists.put(trt, ruptureLists);
            this.setAll(null, locs, trtRuptureLists);
        }

        private void setAll(GriddedRegion gridReg, LocationList locs, EnumMap<TectonicRegionType, ? extends List<? extends List<GriddedRupture>>> trtRuptureLists) {
            this.setLocations(gridReg, locs);
            int sourceCount = 0;
            for (TectonicRegionType trt : trtRuptureLists.keySet()) {
                for (List<GriddedRupture> list : trtRuptureLists.get(trt)) {
                    if (list == null || list.isEmpty()) continue;
                    ++sourceCount;
                }
            }
            TectonicRegionType[] sourceTRTs = new TectonicRegionType[sourceCount];
            int[] sourceGridIndexes = new int[sourceCount];
            EnumMap<TectonicRegionType, ImmutableList> trtRuptureListsOut = new EnumMap<TectonicRegionType, ImmutableList>(TectonicRegionType.class);
            double d = Double.POSITIVE_INFINITY;
            double maxMag = Double.NEGATIVE_INFINITY;
            boolean magsTenthAligned = true;
            int numRups = 0;
            int sourceIndex = 0;
            HashMap<Integer, Set<Integer>> sectAssociations = new HashMap<Integer, Set<Integer>>();
            for (TectonicRegionType trt : TectonicRegionType.values()) {
                List<? extends List<GriddedRupture>> ruptureLists = trtRuptureLists.get(trt);
                if (ruptureLists == null) continue;
                Preconditions.checkState((ruptureLists.size() == locs.size() ? 1 : 0) != 0);
                ImmutableList.Builder ruptureListsBuilder = ImmutableList.builder();
                for (int gridIndex = 0; gridIndex < locs.size(); ++gridIndex) {
                    Location gridLoc = (Location)locs.get(gridIndex);
                    List<GriddedRupture> ruptures = ruptureLists.get(gridIndex);
                    if (ruptures == null || ruptures.isEmpty()) {
                        ruptureListsBuilder.add((Object)ImmutableList.of());
                        continue;
                    }
                    for (GriddedRupture rup : ruptures) {
                        Preconditions.checkState((rup.properties.tectonicRegionType == trt ? 1 : 0) != 0, (String)"Rupture says TRT is %s, but we're in the list for %s", (Object)rup.properties.tectonicRegionType, (Object)trt);
                        Preconditions.checkState((boolean)LocationUtils.areSimilar(rup.location, gridLoc));
                        ++numRups;
                        d = Math.min(d, rup.properties.magnitude);
                        maxMag = Math.max(maxMag, rup.properties.magnitude);
                        magsTenthAligned &= (float)(rup.properties.magnitude * 10.0) == (float)Math.floor(rup.properties.magnitude * 10.0);
                        if (rup.associatedSections == null) continue;
                        for (int sectID : rup.associatedSections) {
                            Set<Integer> sectNodes = sectAssociations.get(sectID);
                            if (sectNodes == null) {
                                sectNodes = new HashSet<Integer>();
                                sectAssociations.put(sectID, sectNodes);
                            }
                            sectNodes.add(gridIndex);
                        }
                    }
                    ruptureListsBuilder.add((Object)ImmutableList.copyOf(ruptures));
                    sourceTRTs[sourceIndex] = trt;
                    sourceGridIndexes[sourceIndex] = gridIndex;
                    ++sourceIndex;
                }
                trtRuptureListsOut.put(trt, ruptureListsBuilder.build());
            }
            Preconditions.checkState((sourceIndex == sourceCount ? 1 : 0) != 0, (String)"Source count mismatch; expected=%s, sourceIndex=%s after last", (int)sourceCount, (int)sourceIndex);
            Preconditions.checkState((numRups > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 rupture to determine MFD gridding");
            double delta = 0.1;
            if (!magsTenthAligned) {
                d = Math.floor(d * 10.0) / 10.0 + 0.5 * delta;
                maxMag = Math.floor(maxMag * 10.0) / 10.0 + 0.5 * delta;
            }
            int size = (int)Math.round((maxMag - d) / delta) + 1;
            this.refMFD = new IncrementalMagFreqDist(d, size, delta);
            this.trtRuptureLists = trtRuptureListsOut;
            this.sourceTRTs = sourceTRTs;
            this.sourceGridIndexes = sourceGridIndexes;
            this.sectAssociations = sectAssociations;
        }

        @Override
        public Set<TectonicRegionType> getTectonicRegionTypes() {
            return this.trtRuptureLists.keySet();
        }

        @Override
        public int getNumSources() {
            return this.sourceGridIndexes.length;
        }

        @Override
        public int getLocationIndexForSource(int sourceIndex) {
            return this.sourceGridIndexes[sourceIndex];
        }

        @Override
        public TectonicRegionType tectonicRegionTypeForSourceIndex(int sourceIndex) {
            return this.sourceTRTs[sourceIndex];
        }

        @Override
        public Set<Integer> getAssociatedGridIndexes(int sectionIndex) {
            Set<Integer> ret = this.sectAssociations.get(sectionIndex);
            if (ret == null) {
                return Set.of();
            }
            return ret;
        }

        @Override
        public IncrementalMagFreqDist getRefMFD() {
            return this.refMFD;
        }

        @Override
        public ImmutableList<GriddedRupture> getRuptures(TectonicRegionType tectonicRegionType, int gridIndex) {
            if (tectonicRegionType == null) {
                ImmutableList.Builder listBuilder = ImmutableList.builder();
                for (TectonicRegionType trt : this.trtRuptureLists.keySet()) {
                    listBuilder.addAll((Iterable)this.trtRuptureLists.get(trt).get(gridIndex));
                }
                return listBuilder.build();
            }
            ImmutableList<ImmutableList<GriddedRupture>> trtList = this.trtRuptureLists.get(tectonicRegionType);
            if (trtList == null) {
                return ImmutableList.of();
            }
            return (ImmutableList)trtList.get(gridIndex);
        }

        @Override
        public void scaleAll(TectonicRegionType tectonicRegionType, double[] valuesArray) {
            Preconditions.checkState((valuesArray.length == this.getNumLocations() ? 1 : 0) != 0, (String)"Scale value size mismatch: %s != %s", (int)valuesArray.length, (int)this.getNumLocations());
            ImmutableList.Builder modRupListBuilder = ImmutableList.builder();
            ImmutableList<ImmutableList<GriddedRupture>> ruptureLists = this.trtRuptureLists.get(tectonicRegionType);
            for (int i = 0; i < valuesArray.length; ++i) {
                ImmutableList origRups = (ImmutableList)ruptureLists.get(i);
                if (valuesArray[i] == 0.0) {
                    modRupListBuilder.add((Object)ImmutableList.of());
                    continue;
                }
                if (valuesArray[i] == 1.0) {
                    modRupListBuilder.add((Object)origRups);
                    continue;
                }
                ImmutableList.Builder modRupBuilder = ImmutableList.builder();
                for (GriddedRupture rup : origRups) {
                    modRupBuilder.add((Object)rup.copyNewRate(rup.rate * valuesArray[i]));
                }
                modRupListBuilder.add((Object)modRupBuilder.build());
            }
            this.trtRuptureLists.put(tectonicRegionType, (ImmutableList<ImmutableList<GriddedRupture>>)modRupListBuilder.build());
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            GriddedRegion gridReg = null;
            if (FileBackedModule.hasEntry(input, entryPrefix, "grid_region.geojson")) {
                BufferedInputStream regionIS = FileBackedModule.getInputStream(input, entryPrefix, "grid_region.geojson");
                InputStreamReader regionReader = new InputStreamReader(regionIS);
                Feature regFeature = Feature.read(regionReader);
                gridReg = GriddedRegion.fromFeature(regFeature);
            }
            CSVFile<String> gridCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, GridSourceList.ARCHIVE_GRID_LOCS_FILE_NAME);
            LocationList locs = Precomputed.loadGridLocsCSV(gridCSV, gridReg);
            CSVReader rupSectsCSV = LargeCSV_BackedModule.loadFromArchive(input, entryPrefix, GridSourceList.ARCHIVE_GRID_SOURCES_FILE_NAME);
            EnumMap<TectonicRegionType, List<List<GriddedRupture>>> trtRuptureLists = Precomputed.loadGridSourcesCSV(rupSectsCSV, locs);
            this.setAll(gridReg, locs, trtRuptureLists);
        }
    }

    public static final class GriddedRupturePropertiesCache {
        private HashMap<GriddedRuptureProperties, GriddedRuptureProperties> cache = new HashMap();

        public GriddedRuptureProperties getCached(GriddedRuptureProperties props) {
            GriddedRuptureProperties cached = this.cache.get(props);
            if (cached == null) {
                this.cache.put(props, props);
                return props;
            }
            return cached;
        }
    }

    private static class GriddedRuptureSourceData
    implements PointSource.PoissonPointSourceData {
        private List<GriddedRupture> rups;
        private List<Double> rates;
        private final List<RuptureSurface> surfs;

        public GriddedRuptureSourceData(Location gridLoc, List<GriddedRupture> gridRups, MagnitudeDependentAftershockFilter aftershockFilter, GriddedSeismicitySettings gridSourceSettings) {
            Preconditions.checkState((!gridRups.isEmpty() ? 1 : 0) != 0);
            if (gridRups.get((int)0).properties.magnitude >= gridSourceSettings.minimumMagnitude) {
                int expectedSize = gridRups.size();
                if (gridSourceSettings.surfaceType == BackgroundRupType.CROSSHAIR) {
                    expectedSize *= 2;
                }
                this.rups = new ArrayList<GriddedRupture>(expectedSize);
                this.rates = new ArrayList<Double>(expectedSize);
                this.surfs = new ArrayList<RuptureSurface>(expectedSize);
            } else {
                this.rups = new ArrayList<GriddedRupture>();
                this.rates = new ArrayList<Double>();
                this.surfs = new ArrayList<RuptureSurface>();
            }
            PointSurfaceBuilder surfBuilder = new PointSurfaceBuilder(gridLoc);
            for (GriddedRupture rup : gridRups) {
                if (rup.properties.magnitude < gridSourceSettings.minimumMagnitude) continue;
                boolean forcePointSurf = rup.properties.magnitude < gridSourceSettings.pointSourceMagnitudeCutoff;
                double rate = rup.rate;
                if (aftershockFilter != null) {
                    rate = aftershockFilter.getFilteredRate(rup.properties.magnitude, rup.rate);
                }
                if (rate == 0.0) continue;
                GridSourceList.updateSurfBuilderForLoc(surfBuilder, rup, forcePointSurf);
                WeightedList<? extends RuptureSurface> rupSurfs = surfBuilder.build(forcePointSurf ? BackgroundRupType.POINT : gridSourceSettings.surfaceType, null);
                for (int i = 0; i < rupSurfs.size(); ++i) {
                    RuptureSurface surf = rupSurfs.getValue(i);
                    double weight = rupSurfs.getWeight(i);
                    this.rups.add(rup);
                    this.rates.add(rate * weight);
                    this.surfs.add(surf);
                }
            }
        }

        @Override
        public int getNumRuptures() {
            return this.rups.size();
        }

        @Override
        public double getMagnitude(int rupIndex) {
            return this.rups.get((int)rupIndex).properties.magnitude;
        }

        @Override
        public double getAveRake(int rupIndex) {
            return this.rups.get((int)rupIndex).properties.rake;
        }

        @Override
        public double getRate(int rupIndex) {
            return this.rates.get(rupIndex);
        }

        @Override
        public RuptureSurface getSurface(int rupIndex) {
            return this.surfs.get(rupIndex);
        }

        @Override
        public boolean isFinite(int rupIndex) {
            return !(this.surfs.get(rupIndex) instanceof PointSurface);
        }

        @Override
        public Location getHypocenter(Location sourceLoc, RuptureSurface rupSurface, int rupIndex) {
            return new Location(sourceLoc.lat, sourceLoc.lon, this.rups.get((int)rupIndex).properties.getHypocentralDepth());
        }
    }

    public static interface FiniteRuptureConverter {
        public GriddedRupture buildFiniteRupture(int var1, Location var2, double var3, double var5, FocalMech var7, TectonicRegionType var8, int[] var9, double[] var10, GriddedRupturePropertiesCache var11);
    }

    private static class GridSourceListAssocRemapper
    extends DynamicallyBuilt {
        private GridSourceList orig;
        private Map<Integer, Integer> sectRemappings;
        private Map<Integer, Integer> sectRemappingsReversed;
        private HashSet<Integer> unmappedAssociations;

        public GridSourceListAssocRemapper(GridSourceList orig, Map<Integer, Integer> sectRemappings) {
            super(orig.getTectonicRegionTypes(), orig.getGriddedRegion(), orig.locs, orig.getRefMFD());
            this.orig = orig;
            this.sectRemappings = sectRemappings;
            this.sectRemappingsReversed = new HashMap<Integer, Integer>(sectRemappings.size());
            for (int key : sectRemappings.keySet()) {
                this.sectRemappingsReversed.put(sectRemappings.get(key), key);
            }
            this.unmappedAssociations = new HashSet();
        }

        @Override
        public int getNumSources() {
            return this.orig.getNumSources();
        }

        @Override
        public int getLocationIndexForSource(int sourceIndex) {
            return this.orig.getLocationIndexForSource(sourceIndex);
        }

        @Override
        protected List<GriddedRupture> buildRuptures(TectonicRegionType tectonicRegionType, int gridIndex) {
            ImmutableList<GriddedRupture> origRups = this.orig.getRuptures(tectonicRegionType, gridIndex);
            if (origRups.isEmpty()) {
                return origRups;
            }
            ArrayList<GriddedRupture> ret = new ArrayList<GriddedRupture>(origRups.size());
            for (GriddedRupture rup : origRups) {
                if (rup.associatedSections != null && rup.associatedSections.length > 0) {
                    int[] remapped = new int[rup.associatedSections.length];
                    for (int i = 0; i < rup.associatedSections.length; ++i) {
                        int origIndex = rup.associatedSections[i];
                        if (!this.sectRemappings.containsKey(origIndex)) {
                            if (!this.unmappedAssociations.contains(origIndex)) {
                                for (Map.Entry<Integer, Integer> remapping : this.sectRemappings.entrySet()) {
                                    Preconditions.checkState((!remapping.getValue().equals(origIndex) ? 1 : 0) != 0, (String)"Encountered association with index=%s for which no remapping exists, and it conflicts with a remapping from %s->%s.", (Object)origIndex, (Object)remapping.getKey(), (Object)remapping.getValue());
                                }
                                this.unmappedAssociations.add(origIndex);
                                System.err.println("WARNING (GridSourceListAssocRemapper): encountered unexpected association ID of " + origIndex + " without a remapping; allowing it because there are no ID conflicts.");
                            }
                            remapped[i] = origIndex;
                            continue;
                        }
                        remapped[i] = this.sectRemappings.get(rup.associatedSections[i]);
                    }
                    ret.add(new GriddedRupture(rup.gridIndex, rup.location, rup.properties, rup.rate, remapped, rup.associatedSectionFracts));
                    continue;
                }
                ret.add(rup);
            }
            return ret;
        }

        @Override
        public TectonicRegionType tectonicRegionTypeForSourceIndex(int sourceIndex) {
            return this.orig.tectonicRegionTypeForSourceIndex(sourceIndex);
        }

        @Override
        public Set<Integer> getAssociatedGridIndexes(int sectionIndex) {
            Integer origIndex = this.sectRemappingsReversed.get(sectionIndex);
            Preconditions.checkNotNull((Object)origIndex, (String)"No mapping found for new sectionIndex=%s", (int)sectionIndex);
            return this.orig.getAssociatedGridIndexes(origIndex);
        }
    }

    private static class GriddedRupturePropComparator
    implements Comparator<GriddedRuptureProperties> {
        private boolean averageQuantitiesOnly;

        private GriddedRupturePropComparator(boolean averageQuantitiesOnly) {
            this.averageQuantitiesOnly = averageQuantitiesOnly;
        }

        @Override
        public int compare(GriddedRuptureProperties rup1, GriddedRuptureProperties rup2) {
            int result = this.doubleCompAsFloat(rup1.magnitude, rup2.magnitude);
            if (result != 0) {
                return result;
            }
            result = this.doubleCompAsFloat(rup1.rake, rup2.rake);
            if (result != 0) {
                return result;
            }
            result = this.doubleCompAsFloat(rup1.dip, rup2.dip);
            if (result != 0) {
                return result;
            }
            result = this.doubleCompAsFloat(rup1.strike, rup2.strike);
            if (result != 0) {
                return result;
            }
            if (rup1.strikeRange == null && rup2.strikeRange != null) {
                return -1;
            }
            if (rup1.strikeRange != null && rup2.strikeRange == null) {
                return 1;
            }
            if (rup1.strikeRange != null && rup2.strikeRange != null) {
                result = ((Double)rup1.strikeRange.lowerEndpoint()).compareTo((Double)rup2.strikeRange.lowerEndpoint());
                if (result != 0) {
                    return result;
                }
                result = ((Double)rup1.strikeRange.upperEndpoint()).compareTo((Double)rup2.strikeRange.upperEndpoint());
                if (result != 0) {
                    return result;
                }
            }
            if ((result = this.doubleCompAsFloat(rup1.getHypocentralDepth(), rup2.getHypocentralDepth())) != 0) {
                return result;
            }
            result = this.doubleCompAsFloat(rup1.getFractionalHypocentralDAS(), rup2.getFractionalHypocentralDAS());
            if (!this.averageQuantitiesOnly) {
                result = this.doubleCompAsFloat(rup1.upperDepth, rup2.upperDepth);
                if (result != 0) {
                    return result;
                }
                result = this.doubleCompAsFloat(rup1.lowerDepth, rup2.lowerDepth);
                if (result != 0) {
                    return result;
                }
                result = this.doubleCompAsFloat(rup1.length, rup2.length);
                if (result != 0) {
                    return result;
                }
                result = this.doubleCompAsFloat(rup1.hypocentralDAS, rup2.hypocentralDAS);
                if (result != 0) {
                    return result;
                }
                result = this.doubleCompAsFloat(rup1.hypocentralDepth, rup2.hypocentralDepth);
                if (result != 0) {
                    return result;
                }
            }
            result = rup1.tectonicRegionType.compareTo(rup2.tectonicRegionType);
            return result;
        }

        private int doubleCompAsFloat(double val1, double val2) {
            return Float.compare((float)val1, (float)val2);
        }
    }

    public static class DynamicConverter
    extends DynamicallyBuilt {
        private MFDGridSourceProvider mfdGridProv;
        private FaultGridAssociations associations;
        private FiniteRuptureConverter converter;
        private GriddedRupturePropertiesCache cache;

        public DynamicConverter(MFDGridSourceProvider mfdGridProv, FaultGridAssociations associations, FiniteRuptureConverter converter) {
            super(mfdGridProv.getTectonicRegionTypes(), mfdGridProv.getGriddedRegion(), DynamicConverter.getRefMFD(mfdGridProv));
            this.mfdGridProv = mfdGridProv;
            this.associations = associations;
            this.converter = converter;
            this.cache = new GriddedRupturePropertiesCache();
        }

        private static IncrementalMagFreqDist getRefMFD(MFDGridSourceProvider mfdGridProv) {
            EvenlyDiscretizedFunc ref = null;
            int maxSize = 0;
            for (int gridIndex = 0; gridIndex < mfdGridProv.getNumLocations(); ++gridIndex) {
                IncrementalMagFreqDist mfd = mfdGridProv.getMFD(gridIndex);
                if (mfd == null) continue;
                if (ref == null) {
                    ref = mfd;
                }
                maxSize = Integer.max(maxSize, mfd.size());
            }
            return new IncrementalMagFreqDist(ref.getMinX(), maxSize, ref.getDelta());
        }

        @Override
        public int getLocationIndexForSource(int sourceIndex) {
            return sourceIndex;
        }

        @Override
        public TectonicRegionType tectonicRegionTypeForSourceIndex(int sourceIndex) {
            return this.mfdGridProv.getTectonicRegionType(sourceIndex);
        }

        @Override
        protected List<GriddedRupture> buildRuptures(TectonicRegionType tectonicRegionType, int gridIndex) {
            if (tectonicRegionType == this.mfdGridProv.getTectonicRegionType(gridIndex)) {
                return GridSourceList.convertGridIndex(this.mfdGridProv, this.associations, this.converter, gridIndex, this.cache);
            }
            return null;
        }

        @Override
        public double getFracStrikeSlip(int gridIndex) {
            return this.mfdGridProv.getFracStrikeSlip(gridIndex);
        }

        @Override
        public double getFracReverse(int gridIndex) {
            return this.mfdGridProv.getFracReverse(gridIndex);
        }

        @Override
        public double getFracNormal(int gridIndex) {
            return this.mfdGridProv.getFracNormal(gridIndex);
        }

        @Override
        public int getNumSources() {
            return this.getNumLocations();
        }

        @Override
        public Set<Integer> getAssociatedGridIndexes(int sectionIndex) {
            Map<Integer, Double> assoc = this.associations.getNodeFractions(sectionIndex);
            if (assoc == null || assoc.isEmpty()) {
                return Set.of();
            }
            return assoc.keySet();
        }
    }

    public static abstract class DynamicallyBuilt
    extends GridSourceList {
        private Set<TectonicRegionType> trts;
        private IncrementalMagFreqDist refMFD;

        public DynamicallyBuilt(Set<TectonicRegionType> trts, LocationList locs, IncrementalMagFreqDist refMFD) {
            this(trts, null, locs, refMFD);
        }

        public DynamicallyBuilt(Set<TectonicRegionType> trts, GriddedRegion gridReg, IncrementalMagFreqDist refMFD) {
            this(trts, gridReg, gridReg.getNodeList(), refMFD);
        }

        private DynamicallyBuilt(Set<TectonicRegionType> trts, GriddedRegion gridReg, LocationList locs, IncrementalMagFreqDist refMFD) {
            super(gridReg, locs);
            this.trts = trts;
            this.refMFD = refMFD;
        }

        protected abstract List<GriddedRupture> buildRuptures(TectonicRegionType var1, int var2);

        @Override
        public Set<TectonicRegionType> getTectonicRegionTypes() {
            return this.trts;
        }

        @Override
        public ImmutableList<GriddedRupture> getRuptures(TectonicRegionType tectonicRegionType, int gridIndex) {
            List<GriddedRupture> rups = this.buildRuptures(tectonicRegionType, gridIndex);
            if (rups == null || rups.isEmpty()) {
                return ImmutableList.of();
            }
            return ImmutableList.copyOf(rups);
        }

        @Override
        public void scaleAll(TectonicRegionType tectonicRegionType, double[] valuesArray) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public IncrementalMagFreqDist getRefMFD() {
            return this.refMFD;
        }
    }

    private static class PropAverager {
        private double weightedSum = 0.0;
        private Double firstVal;
        private boolean allSame;

        public PropAverager(double initialValue, double initialWeight) {
            this.firstVal = initialValue;
            this.allSame = true;
            this.weightedSum = initialValue * initialWeight;
        }

        public void add(double value, double weight) {
            if (this.firstVal == null) {
                this.firstVal = value;
                this.allSame = true;
            } else {
                this.allSame &= value == this.firstVal;
            }
            this.weightedSum = Math.fma(value, weight, this.weightedSum);
        }

        public double getAverage(double processedSumWeights, double overallSumWeights) {
            if (this.allSame && (float)overallSumWeights == (float)processedSumWeights) {
                return this.firstVal;
            }
            Preconditions.checkState((processedSumWeights > 0.0 ? 1 : 0) != 0);
            return this.weightedSum / processedSumWeights;
        }
    }

    private static class RuptureAverager {
        private double rateWeightedSum = 0.0;
        private int[] associatedSectIDs = null;
        private double[] associatedWeightedRates = null;
        private GriddedRuptureProperties firstProps;
        private boolean allPropsIdentical;
        private RupturePropertyAverager propAverager;
        private double processedSumWeights = 0.0;

        private RuptureAverager() {
        }

        public void add(GriddedRupture rup, double weight) {
            if (this.firstProps == null) {
                this.firstProps = rup.properties;
                this.allPropsIdentical = true;
            } else {
                this.allPropsIdentical &= this.firstProps.equals(rup.properties);
            }
            this.rateWeightedSum = Math.fma(rup.rate, weight, this.rateWeightedSum);
            if (rup.associatedSections != null) {
                if (this.associatedSectIDs == null) {
                    this.associatedSectIDs = rup.associatedSections;
                    this.associatedWeightedRates = new double[this.associatedSectIDs.length];
                    for (int i = 0; i < this.associatedWeightedRates.length; ++i) {
                        this.associatedWeightedRates[i] = rup.rate * rup.associatedSectionFracts[i] * weight;
                    }
                } else {
                    for (int i = 0; i < rup.associatedSections.length; ++i) {
                        int index = Ints.indexOf((int[])this.associatedSectIDs, (int)rup.associatedSections[i]);
                        if (index < 0) {
                            this.associatedSectIDs = Arrays.copyOf(this.associatedSectIDs, this.associatedSectIDs.length + 1);
                            this.associatedWeightedRates = Arrays.copyOf(this.associatedWeightedRates, this.associatedWeightedRates.length + 1);
                            this.associatedSectIDs[this.associatedSectIDs.length - 1] = rup.associatedSections[i];
                            this.associatedWeightedRates[this.associatedWeightedRates.length - 1] = rup.rate * rup.associatedSectionFracts[i] * weight;
                            continue;
                        }
                        this.associatedWeightedRates[index] = Math.fma(rup.rate * rup.associatedSectionFracts[i], weight, this.associatedWeightedRates[index]);
                    }
                }
            }
            if (!this.allPropsIdentical) {
                if (this.propAverager == null) {
                    this.propAverager = new RupturePropertyAverager(this.firstProps, this.processedSumWeights);
                }
                this.propAverager.add(rup.properties, weight);
            }
            this.processedSumWeights += weight;
        }

        public GriddedRupture build(int gridIndex, Location loc, double sumWeights, GriddedRupturePropertiesCache cache) {
            GriddedRuptureProperties properties;
            boolean D = false;
            if (D) {
                System.out.println("DEBUG build(gridIndex=" + gridIndex + ", mag=" + (float)this.firstProps.magnitude + ", sumWeights=" + (float)sumWeights + "); processedSumWeights=" + (float)this.processedSumWeights);
            }
            double[] associatedFracts = null;
            if (this.associatedWeightedRates != null) {
                associatedFracts = new double[this.associatedWeightedRates.length];
                for (int i = 0; i < associatedFracts.length; ++i) {
                    associatedFracts[i] = this.associatedWeightedRates[i] / this.rateWeightedSum;
                }
            }
            GriddedRuptureProperties griddedRuptureProperties = properties = this.allPropsIdentical ? this.firstProps : cache.getCached(this.propAverager.build(this.firstProps, this.processedSumWeights, sumWeights));
            if (D) {
                System.out.println("\tfirst props: " + String.valueOf(this.firstProps));
            }
            if (D) {
                System.out.println("\tbuilt props: " + String.valueOf(properties));
            }
            double rate = this.rateWeightedSum / sumWeights;
            return new GriddedRupture(gridIndex, loc, properties, rate, this.associatedSectIDs, associatedFracts);
        }
    }

    private static class RupturePropertyAverager {
        private final PropAverager upperDepthAverager;
        private final PropAverager lowerDepthAverager;
        private final PropAverager lengthAverager;
        private final PropAverager dasAverager;
        private final PropAverager hypoDepthAverager;
        private boolean explicitHalfDAS = false;
        private boolean explicitHalfDepth = false;

        public RupturePropertyAverager(GriddedRuptureProperties firstProps, double processedSumWeights) {
            this.upperDepthAverager = new PropAverager(firstProps.upperDepth, processedSumWeights);
            this.lowerDepthAverager = new PropAverager(firstProps.lowerDepth, processedSumWeights);
            this.lengthAverager = new PropAverager(firstProps.length, processedSumWeights);
            double halfLength = 0.5 * firstProps.length;
            if (Double.isNaN(firstProps.hypocentralDAS)) {
                this.dasAverager = new PropAverager(halfLength, processedSumWeights);
            } else {
                if ((float)firstProps.hypocentralDAS == (float)halfLength) {
                    this.explicitHalfDAS = true;
                }
                this.dasAverager = new PropAverager(firstProps.hypocentralDAS, processedSumWeights);
            }
            double midDepth = firstProps.upperDepth + 0.5 * (firstProps.lowerDepth - firstProps.upperDepth);
            if (Double.isNaN(firstProps.hypocentralDepth)) {
                this.hypoDepthAverager = new PropAverager(midDepth, processedSumWeights);
            } else {
                if ((double)((float)firstProps.hypocentralDepth) == midDepth) {
                    this.explicitHalfDepth = true;
                }
                this.hypoDepthAverager = new PropAverager(firstProps.hypocentralDepth, processedSumWeights);
            }
        }

        public void add(GriddedRuptureProperties properties, double weight) {
            this.upperDepthAverager.add(properties.upperDepth, weight);
            this.lowerDepthAverager.add(properties.lowerDepth, weight);
            this.lengthAverager.add(properties.length, weight);
            double halfLength = 0.5 * properties.length;
            if (Double.isNaN(properties.hypocentralDAS)) {
                this.dasAverager.add(halfLength, weight);
            } else {
                if ((float)properties.hypocentralDAS == (float)halfLength) {
                    this.explicitHalfDAS = true;
                }
                this.dasAverager.add(properties.hypocentralDAS, weight);
            }
            double midDepth = properties.upperDepth + 0.5 * (properties.lowerDepth - properties.upperDepth);
            if (Double.isNaN(properties.hypocentralDepth)) {
                this.hypoDepthAverager.add(midDepth, weight);
            } else {
                if ((double)((float)properties.hypocentralDepth) == midDepth) {
                    this.explicitHalfDepth = true;
                }
                this.hypoDepthAverager.add(properties.hypocentralDepth, weight);
            }
        }

        public GriddedRuptureProperties build(GriddedRuptureProperties ref, double processedSumWeights, double sumWeights) {
            double upper = this.upperDepthAverager.getAverage(processedSumWeights, sumWeights);
            double lower = this.lowerDepthAverager.getAverage(processedSumWeights, sumWeights);
            double hypoDepth = this.hypoDepthAverager.getAverage(processedSumWeights, sumWeights);
            if (this.hypoDepthAverager.allSame && (float)hypoDepth == (float)(upper + 0.5 * (lower - upper)) && !this.explicitHalfDepth) {
                hypoDepth = Double.NaN;
            }
            double length = this.lengthAverager.getAverage(processedSumWeights, sumWeights);
            double hypoDAS = this.dasAverager.getAverage(processedSumWeights, sumWeights);
            if (this.dasAverager.allSame && (float)hypoDAS == (float)(0.5 * length) && !this.explicitHalfDAS) {
                hypoDAS = Double.NaN;
            }
            return new GriddedRuptureProperties(ref.magnitude, ref.rake, ref.dip, ref.strike, ref.strikeRange, upper, lower, length, hypoDepth, hypoDAS, ref.tectonicRegionType);
        }
    }
}

