/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import java.util.Collection;
import java.util.Set;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.aftershocks.MagnitudeDependentAftershockFilter;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;

public interface GridSourceProvider
extends OpenSHA_Module,
BranchAverageableModule<GridSourceProvider> {
    public static final String ARCHIVE_GRID_REGION_FILE_NAME = "grid_region.geojson";

    public int getNumLocations();

    public int getNumSources();

    public Location getLocation(int var1);

    public Location getLocationForSource(int var1);

    public int getLocationIndexForSource(int var1);

    public int getLocationIndex(Location var1);

    public ProbEqkSource getSource(int var1, double var2, MagnitudeDependentAftershockFilter var4, GriddedSeismicitySettings var5);

    public ProbEqkSource getSource(TectonicRegionType var1, int var2, double var3, MagnitudeDependentAftershockFilter var5, GriddedSeismicitySettings var6);

    public ProbEqkSource getSourceSubSeisOnFault(TectonicRegionType var1, int var2, double var3, MagnitudeDependentAftershockFilter var5, GriddedSeismicitySettings var6);

    public ProbEqkSource getSourceUnassociated(TectonicRegionType var1, int var2, double var3, MagnitudeDependentAftershockFilter var5, GriddedSeismicitySettings var6);

    public Set<TectonicRegionType> getTectonicRegionTypes();

    public IncrementalMagFreqDist getMFD_Unassociated(int var1);

    public IncrementalMagFreqDist getMFD_Unassociated(TectonicRegionType var1, int var2);

    public IncrementalMagFreqDist getMFD_SubSeisOnFault(int var1);

    public IncrementalMagFreqDist getMFD_SubSeisOnFault(TectonicRegionType var1, int var2);

    public IncrementalMagFreqDist getMFD(int var1, double var2);

    public IncrementalMagFreqDist getMFD(TectonicRegionType var1, int var2, double var3);

    public IncrementalMagFreqDist getMFD(int var1);

    public IncrementalMagFreqDist getMFD(TectonicRegionType var1, int var2);

    public double getCumulativeNucleationRate(int var1, double var2);

    public double getCumulativeNucleationRate(TectonicRegionType var1, int var2, double var3);

    public GriddedRegion getGriddedRegion();

    public double getFracStrikeSlip(int var1);

    public double getFracReverse(int var1);

    public double getFracNormal(int var1);

    public GridSourceProvider getAboveMinMag(float var1);

    public void scaleAll(double[] var1);

    public void scaleAll(TectonicRegionType var1, double[] var2);

    public static boolean affectedByLevel(LogicTreeLevel<?> level) {
        boolean gridRegAffectedByDefault = false;
        boolean mechsAffectedByDefault = true;
        boolean unassocAffectedByDefault = true;
        boolean subSeisAffectedByDefault = true;
        boolean sourcesLocsAffectedByDefault = false;
        boolean sourcesAffectedByDefault = true;
        Collection<String> notAffected = level.getNotAffected();
        if (!notAffected.isEmpty()) {
            if (notAffected.contains("grid_sources.csv")) {
                mechsAffectedByDefault = false;
                unassocAffectedByDefault = false;
                subSeisAffectedByDefault = false;
            }
            if (notAffected.contains("grid_mech_weights.csv") || notAffected.contains("grid_unassociated_mfds.csv") || notAffected.contains("grid_sub_seis_mfds.csv")) {
                sourcesAffectedByDefault = false;
                sourcesLocsAffectedByDefault = false;
            }
        }
        return level.affects(ARCHIVE_GRID_REGION_FILE_NAME, gridRegAffectedByDefault) || level.affects("grid_source_locations.csv", sourcesLocsAffectedByDefault) || level.affects("grid_sources.csv", sourcesAffectedByDefault) || level.affects("grid_mech_weights.csv", mechsAffectedByDefault) || level.affects("grid_unassociated_mfds.csv", unassocAffectedByDefault) || level.affects("grid_sub_seis_mfds.csv", subSeisAffectedByDefault);
    }
}

