/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.ConstraintWeightingType;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;

public class InversionMisfits
implements ArchivableModule,
AverageableModule<InversionMisfits> {
    private List<ConstraintRange> constraintRanges;
    private double[] misfits;
    private double[] data;
    private double[] misfits_ineq;
    private double[] data_ineq;
    private static final String MISFITS_CSV = "inversion_misfits.csv";
    private static final String MISFITS_INEQ_CSV = "inversion_misfits_ineq.csv";
    private static final String RANGES_CSV = "inversion_constraint_ranges.csv";

    public InversionMisfits(SimulatedAnnealing sa) {
        this(sa.getConstraintRanges(), sa.getBestMisfit(), sa.getD(), sa.getBestInequalityMisfit(), sa.getD_ineq());
    }

    public InversionMisfits(List<ConstraintRange> constraintRanges, double[] misfits, double[] data) {
        this(constraintRanges, misfits, data, null, null);
    }

    public InversionMisfits(List<ConstraintRange> constraintRanges, double[] misfits, double[] data, double[] misfits_ineq, double[] data_ineq) {
        this.constraintRanges = constraintRanges;
        if (misfits != null) {
            Preconditions.checkNotNull((Object)data, (Object)"misfits supplied but data are null");
            Preconditions.checkState((misfits.length == data.length ? 1 : 0) != 0, (String)"misfits has %s values but data has %s", (int)misfits.length, (int)data.length);
        }
        this.misfits = misfits;
        this.data = data;
        if (misfits_ineq != null) {
            Preconditions.checkNotNull((Object)data_ineq, (Object)"misfits_ineq supplied but data_ineq are null");
            Preconditions.checkState((misfits_ineq.length == data_ineq.length ? 1 : 0) != 0, (String)"misfits_ineq has %s values but data_ineq has %s", (int)misfits_ineq.length, (int)data_ineq.length);
        }
        this.misfits_ineq = misfits_ineq;
        this.data_ineq = data_ineq;
    }

    private InversionMisfits() {
    }

    public List<ConstraintRange> getConstraintRanges() {
        return this.constraintRanges;
    }

    public double[] getMisfits() {
        return this.misfits;
    }

    public double[] getData() {
        return this.data;
    }

    public double[] getInequalityMisfits() {
        return this.misfits_ineq;
    }

    public double[] getInequalityData() {
        return this.data_ineq;
    }

    public double[] getMisfits(ConstraintRange range, boolean removeWeighting) {
        double[] ret;
        if (range.inequality) {
            Preconditions.checkNotNull((Object)this.misfits_ineq, (Object)"Inequality range supplied but no inequality misfits found");
            ret = this.getInRange(range, this.misfits_ineq);
        } else {
            Preconditions.checkNotNull((Object)this.misfits, (Object)"Equality range supplied but no equality misfits found");
            ret = this.getInRange(range, this.misfits);
        }
        if (removeWeighting) {
            Preconditions.checkState((Double.isFinite(range.weight) && range.weight > 0.0 ? 1 : 0) != 0, (String)"Bad weight for constraint %s: %s", (Object)range.name, (Object)range.weight);
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] / range.weight;
            }
        }
        return ret;
    }

    public double[] getData(ConstraintRange range, boolean removeWeighting) {
        double[] ret;
        if (range.inequality) {
            Preconditions.checkNotNull((Object)this.data_ineq, (Object)"Inequality range supplied but not inequality misfits found");
            ret = this.getInRange(range, this.data_ineq);
        } else {
            Preconditions.checkNotNull((Object)this.data, (Object)"Equality range supplied but not equality misfits found");
            ret = this.getInRange(range, this.data);
        }
        if (removeWeighting) {
            Preconditions.checkState((Double.isFinite(range.weight) && range.weight > 0.0 ? 1 : 0) != 0, (String)"Bad weight for constraint %s: %s", (Object)range.name, (Object)range.weight);
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] / range.weight;
            }
        }
        return ret;
    }

    public InversionMisfitStats getMisfitStats() {
        ArrayList<InversionMisfitStats.MisfitStats> stats = new ArrayList<InversionMisfitStats.MisfitStats>();
        if (this.constraintRanges == null) {
            if (this.misfits != null) {
                stats.add(this.getMisfitStats(new ConstraintRange("Equality", "Eq", 0, this.misfits.length, false, Double.NaN, null)));
            }
            if (this.misfits_ineq != null) {
                stats.add(this.getMisfitStats(new ConstraintRange("Inequality", "Ineq", 0, this.misfits_ineq.length, true, Double.NaN, null)));
            }
        } else {
            for (ConstraintRange range : this.constraintRanges) {
                stats.add(this.getMisfitStats(range));
            }
        }
        return new InversionMisfitStats(stats);
    }

    public InversionMisfitStats.MisfitStats getMisfitStats(ConstraintRange range) {
        double[] misfits = this.getMisfits(range, range.weight > 0.0);
        return new InversionMisfitStats.MisfitStats(misfits, range);
    }

    private double[] getInRange(ConstraintRange range, double[] array) {
        Preconditions.checkState((range.startRow >= 0 ? 1 : 0) != 0, (String)"Bad start row: %s", (int)range.startRow);
        Preconditions.checkState((range.endRow <= array.length ? 1 : 0) != 0, (String)"End row (%s) out of data bounds (%s)", (int)range.endRow, (int)array.length);
        double[] ret = new double[range.endRow - range.startRow];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = array[i + range.startRow];
        }
        return ret;
    }

    @Override
    public String getName() {
        return "Inversion Misfits";
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        if (this.misfits != null) {
            InversionMisfits.writeData(this.misfits, this.data, entryPrefix, MISFITS_CSV, output);
        }
        if (this.misfits_ineq != null) {
            InversionMisfits.writeData(this.misfits_ineq, this.data_ineq, entryPrefix, MISFITS_INEQ_CSV, output);
        }
        if (this.constraintRanges != null && !this.constraintRanges.isEmpty()) {
            CSVFile<String> rangesCSV = new CSVFile<String>(true);
            rangesCSV.addLine("Name", "Short Name", "Start Row (inclusive)", "End Row (exclusive)", "Inequality", "Weight", "Weighting Type");
            for (ConstraintRange range : this.constraintRanges) {
                rangesCSV.addLine(range.name, range.shortName, "" + range.startRow, "" + range.endRow, "" + range.inequality, "" + range.weight, range.weightingType == null ? "" : range.weightingType.name());
            }
            CSV_BackedModule.writeToArchive(rangesCSV, output, entryPrefix, RANGES_CSV);
        }
    }

    private static void writeData(double[] misfits, double[] data, String entryPrefix, String fileName, ArchiveOutput output) throws IOException {
        CSVFile<String> csv = new CSVFile<String>(true);
        Preconditions.checkState((misfits.length == data.length ? 1 : 0) != 0, (String)"%s != %s", (int)misfits.length, (int)data.length);
        csv.addLine("Row", "Data", "Misfit");
        for (int i = 0; i < misfits.length; ++i) {
            csv.addLine("" + i, "" + data[i], "" + misfits[i]);
        }
        CSV_BackedModule.writeToArchive(csv, output, entryPrefix, fileName);
    }

    private void readData(ArchiveInput input, String entryPrefix, boolean ineq) throws IOException {
        String fileName;
        String string = fileName = ineq ? MISFITS_INEQ_CSV : MISFITS_CSV;
        if (!FileBackedModule.hasEntry(input, entryPrefix, fileName)) {
            return;
        }
        CSVFile<String> csv = CSV_BackedModule.loadFromArchive(input, entryPrefix, fileName);
        double[] data = new double[csv.getNumRows() - 1];
        double[] misfits = new double[csv.getNumRows() - 1];
        for (int i = 0; i < data.length; ++i) {
            int row = i + 1;
            int myRow = csv.getInt(row, 0);
            Preconditions.checkState((myRow == i ? 1 : 0) != 0, (String)"Rows must be in order and 0-based after a single header. Expected %s, was %s.", (int)i, (int)myRow);
            data[i] = csv.getDouble(row, 1);
            misfits[i] = csv.getDouble(row, 2);
        }
        if (ineq) {
            this.data_ineq = data;
            this.misfits_ineq = misfits;
        } else {
            this.data = data;
            this.misfits = misfits;
        }
    }

    @Override
    public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        this.readData(input, entryPrefix, false);
        this.readData(input, entryPrefix, true);
        if (FileBackedModule.hasEntry(input, entryPrefix, RANGES_CSV)) {
            CSVFile<String> rangesCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, RANGES_CSV);
            this.constraintRanges = new ArrayList<ConstraintRange>();
            for (int row = 1; row < rangesCSV.getNumRows(); ++row) {
                String typeStr;
                List<String> line = rangesCSV.getLine(row);
                int col = 0;
                String name = line.get(col++);
                String shortName = line.get(col++);
                int startRow = Integer.parseInt(line.get(col++));
                int endRow = Integer.parseInt(line.get(col++));
                boolean inequality = Boolean.parseBoolean(line.get(col++));
                double weight = Double.parseDouble(line.get(col++));
                ConstraintWeightingType weightingType = null;
                if (col < line.size() && !(typeStr = line.get(col++)).isBlank()) {
                    weightingType = ConstraintWeightingType.valueOf(typeStr);
                }
                this.constraintRanges.add(new ConstraintRange(name, shortName, startRow, endRow, inequality, weight, weightingType));
            }
        }
    }

    public static InversionMisfits average(List<InversionMisfits> misfitsList) {
        InversionMisfits ref = misfitsList.get(0);
        List<ConstraintRange> ranges = ref.constraintRanges;
        int numEQ = ref.misfits == null ? 0 : ref.misfits.length;
        int numINEQ = ref.misfits_ineq == null ? 0 : ref.misfits_ineq.length;
        double[] misfits = numEQ > 0 ? new double[numEQ] : null;
        double[] data = numEQ > 0 ? new double[numEQ] : null;
        double[] misfits_ineq = numINEQ > 0 ? new double[numINEQ] : null;
        double[] data_ineq = numINEQ > 0 ? new double[numINEQ] : null;
        double scalarEach = 1.0 / (double)misfitsList.size();
        for (InversionMisfits myMisfits : misfitsList) {
            if (numEQ > 0) {
                InversionMisfits.averageIn(scalarEach, misfits, myMisfits.misfits);
                InversionMisfits.averageIn(scalarEach, data, myMisfits.data);
            }
            if (numINEQ <= 0) continue;
            InversionMisfits.averageIn(scalarEach, misfits_ineq, myMisfits.misfits_ineq);
            InversionMisfits.averageIn(scalarEach, data_ineq, myMisfits.data_ineq);
        }
        return new InversionMisfits(ranges, misfits, data, misfits_ineq, data_ineq);
    }

    private static void averageIn(double scalar, double[] avgVals, double[] myVals) {
        for (int i = 0; i < avgVals.length; ++i) {
            int n = i;
            avgVals[n] = avgVals[n] + scalar * myVals[i];
        }
    }

    @Override
    public AverageableModule.AveragingAccumulator<InversionMisfits> averagingAccumulator() {
        return new MisfitsAccumulator(this);
    }

    public static InversionMisfits appendSeparate(List<InversionMisfits> misfitsList) {
        HashBasedTable constraintMisfits = HashBasedTable.create();
        HashBasedTable constraintDatas = HashBasedTable.create();
        HashBasedTable constraintWeights = HashBasedTable.create();
        ArrayList<ConstraintRange> uniqueEqualityRanges = new ArrayList<ConstraintRange>();
        ArrayList<ConstraintRange> uniqueInequalityRanges = new ArrayList<ConstraintRange>();
        int rowsEQ = 0;
        int rowsINEQ = 0;
        for (InversionMisfits subMisfits : misfitsList) {
            Preconditions.checkNotNull(subMisfits.constraintRanges, (Object)"Must have constraint ranges attached");
            for (ConstraintRange range : subMisfits.constraintRanges) {
                Preconditions.checkState((range.weight > 0.0 ? 1 : 0) != 0, (String)"Bad weight for %s: %s", (Object)range.name, (Object)range.weight);
                if (!constraintMisfits.contains((Object)range.name, (Object)range.inequality)) {
                    constraintMisfits.put((Object)range.name, (Object)range.inequality, new ArrayList());
                    constraintDatas.put((Object)range.name, (Object)range.inequality, new ArrayList());
                    constraintWeights.put((Object)range.name, (Object)range.inequality, new ArrayList());
                    if (range.inequality) {
                        uniqueInequalityRanges.add(range);
                    } else {
                        uniqueEqualityRanges.add(range);
                    }
                }
                ((List)constraintMisfits.get((Object)range.name, (Object)range.inequality)).add(subMisfits.getMisfits(range, false));
                ((List)constraintDatas.get((Object)range.name, (Object)range.inequality)).add(subMisfits.getData(range, false));
                ((List)constraintWeights.get((Object)range.name, (Object)range.inequality)).add(range.weight);
                if (range.inequality) {
                    rowsINEQ += range.endRow - range.startRow;
                    continue;
                }
                rowsEQ += range.endRow - range.startRow;
            }
        }
        double[] misfits = null;
        double[] data = null;
        if (rowsEQ > 0) {
            misfits = new double[rowsEQ];
            data = new double[rowsEQ];
        }
        double[] misfits_ineq = null;
        double[] data_ineq = null;
        if (rowsINEQ > 0) {
            misfits_ineq = new double[rowsINEQ];
            data_ineq = new double[rowsINEQ];
        }
        ArrayList<ConstraintRange> allRanges = new ArrayList<ConstraintRange>();
        int indexEQ = 0;
        int indexINEQ = 0;
        for (boolean ineq : new boolean[]{false, true}) {
            ArrayList<ConstraintRange> rawRanges;
            ArrayList<ConstraintRange> arrayList = rawRanges = ineq ? uniqueInequalityRanges : uniqueEqualityRanges;
            if (rawRanges.isEmpty()) continue;
            int index = ineq ? indexINEQ : indexEQ;
            double[] destMisfits = ineq ? misfits_ineq : misfits;
            double[] destData = ineq ? data_ineq : data;
            for (ConstraintRange range : rawRanges) {
                double avgWeight;
                List rangeMisfits = (List)constraintMisfits.get((Object)range.name, (Object)ineq);
                List rangeDatas = (List)constraintDatas.get((Object)range.name, (Object)ineq);
                List rangeWeights = (List)constraintWeights.get((Object)range.name, (Object)ineq);
                boolean weightsEqual = true;
                double prevWeight = (Double)rangeWeights.get(0);
                for (int i = 1; weightsEqual && i < rangeWeights.size(); ++i) {
                    double weight = (Double)rangeWeights.get(i);
                    weightsEqual = weightsEqual && (float)weight == (float)prevWeight;
                    prevWeight = weight;
                }
                int startRow = index;
                if (weightsEqual) {
                    avgWeight = prevWeight;
                    for (int i = 0; i < rangeMisfits.size(); ++i) {
                        double[] myData;
                        double[] myMisfits = (double[])rangeMisfits.get(i);
                        Preconditions.checkState((myMisfits.length == (myData = (double[])rangeDatas.get(i)).length ? 1 : 0) != 0);
                        System.arraycopy(myMisfits, 0, destMisfits, index, myMisfits.length);
                        System.arraycopy(myData, 0, destData, index, myData.length);
                        index += myMisfits.length;
                    }
                } else {
                    int i;
                    avgWeight = 0.0;
                    int totRows = 0;
                    for (i = 0; i < rangeMisfits.size(); ++i) {
                        int myRows = ((double[])rangeMisfits.get(i)).length;
                        double weight = (Double)rangeWeights.get(i);
                        avgWeight += weight * (double)myRows;
                        totRows += myRows;
                    }
                    avgWeight /= (double)totRows;
                    for (i = 0; i < rangeMisfits.size(); ++i) {
                        double[] myMisfits = (double[])rangeMisfits.get(i);
                        double[] myData = (double[])rangeDatas.get(i);
                        double weight = (Double)rangeWeights.get(i);
                        Preconditions.checkState((myMisfits.length == myData.length ? 1 : 0) != 0);
                        double scalar = avgWeight / weight;
                        for (int j = 0; j < myMisfits.length; ++j) {
                            destMisfits[index] = myMisfits[j] * scalar;
                            destData[index] = myData[j] * scalar;
                            ++index;
                        }
                    }
                }
                int endRow = index;
                allRanges.add(new ConstraintRange(range.name, range.shortName, startRow, endRow, ineq, avgWeight, range.weightingType));
            }
            if (ineq) {
                indexINEQ = index;
                continue;
            }
            indexEQ = index;
        }
        Preconditions.checkState((indexEQ == rowsEQ ? 1 : 0) != 0, (String)"Expected to process %s EQ rows, processed %s", (int)rowsEQ, (int)indexEQ);
        Preconditions.checkState((indexEQ == rowsEQ ? 1 : 0) != 0, (String)"Expected to process %s INEQ rows, processed %s", (int)rowsINEQ, (int)indexINEQ);
        return new InversionMisfits(allRanges, misfits, data, misfits_ineq, data_ineq);
    }

    private static class MisfitsAccumulator
    implements AverageableModule.AveragingAccumulator<InversionMisfits> {
        private List<ConstraintRange> ranges;
        private int numEQ;
        private int numINEQ;
        private double[] misfits;
        private double[] data;
        private double[] misfits_ineq;
        private double[] data_ineq;
        private double sumWeight = 0.0;

        public MisfitsAccumulator(InversionMisfits ref) {
            this.ranges = ref.constraintRanges;
            this.numEQ = ref.misfits == null ? 0 : ref.misfits.length;
            this.numINEQ = ref.misfits_ineq == null ? 0 : ref.misfits_ineq.length;
            this.misfits = this.numEQ > 0 ? new double[this.numEQ] : null;
            this.data = this.numEQ > 0 ? new double[this.numEQ] : null;
            this.misfits_ineq = this.numINEQ > 0 ? new double[this.numINEQ] : null;
            this.data_ineq = this.numINEQ > 0 ? new double[this.numINEQ] : null;
        }

        @Override
        public void process(InversionMisfits module, double relWeight) {
            if (this.numEQ > 0) {
                Preconditions.checkState((module.misfits.length == this.numEQ ? 1 : 0) != 0, (String)"Expected %s EQ misfits, have %s", (int)this.numEQ, (int)module.misfits.length);
                InversionMisfits.averageIn(relWeight, this.misfits, module.misfits);
                InversionMisfits.averageIn(relWeight, this.data, module.data);
            }
            if (this.numINEQ > 0) {
                Preconditions.checkState((module.misfits_ineq.length == this.numINEQ ? 1 : 0) != 0, (String)"Expected %s INEQ misfits, have %s", (int)this.numINEQ, (int)module.misfits_ineq.length);
                InversionMisfits.averageIn(relWeight, this.misfits_ineq, module.misfits_ineq);
                InversionMisfits.averageIn(relWeight, this.data_ineq, module.data_ineq);
            }
            this.sumWeight += relWeight;
        }

        @Override
        public InversionMisfits getAverage() {
            if (this.numEQ > 0) {
                AverageableModule.scaleToTotalWeight(this.misfits, this.sumWeight);
                AverageableModule.scaleToTotalWeight(this.data, this.sumWeight);
            }
            if (this.numINEQ > 0) {
                AverageableModule.scaleToTotalWeight(this.misfits_ineq, this.sumWeight);
                AverageableModule.scaleToTotalWeight(this.data_ineq, this.sumWeight);
            }
            return new InversionMisfits(this.ranges, this.misfits, this.data, this.misfits_ineq, this.data_ineq);
        }

        @Override
        public Class<InversionMisfits> getType() {
            return InversionMisfits.class;
        }
    }
}

