/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.JSON_TypeAdapterBackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSubSetMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.faultSurface.FaultSection;

public class NamedFaults
implements SubModule<FaultSystemRupSet>,
BranchAverageableModule<NamedFaults>,
AverageableModule.ConstantAverageable<NamedFaults>,
JSON_TypeAdapterBackedModule<Map<String, List<Integer>>>,
SplittableRuptureModule<NamedFaults> {
    private transient FaultSystemRupSet rupSet;
    private Map<String, List<Integer>> namedFaults;
    private Map<Integer, String> faultNames;
    private static final Type listIntType = TypeToken.getParameterized(List.class, (Type[])new Type[]{Integer.class}).getType();
    private static final Type mapListIntType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, listIntType}).getType();

    private NamedFaults() {
    }

    public NamedFaults(FaultSystemRupSet rupSet, Map<String, List<Integer>> namedFaults) {
        this.rupSet = rupSet;
        this.set(namedFaults);
    }

    @Override
    public String getName() {
        return "Named Faults";
    }

    @Override
    public void setParent(FaultSystemRupSet parent) throws IllegalStateException {
        this.rupSet = parent;
    }

    @Override
    public FaultSystemRupSet getParent() {
        return this.rupSet;
    }

    @Override
    public SubModule<FaultSystemRupSet> copy(FaultSystemRupSet newParent) throws IllegalStateException {
        return new NamedFaults(newParent, this.namedFaults);
    }

    @Override
    public String getFileName() {
        return "named_faults.json";
    }

    @Override
    public Type getType() {
        return mapListIntType;
    }

    @Override
    public Map<String, List<Integer>> get() {
        return this.namedFaults;
    }

    @Override
    public void set(Map<String, List<Integer>> value) {
        Preconditions.checkNotNull(value);
        this.namedFaults = value;
        this.faultNames = new HashMap<Integer, String>();
        for (String name : this.namedFaults.keySet()) {
            for (int parentID : this.namedFaults.get(name)) {
                Preconditions.checkState((!this.faultNames.containsKey(parentID) ? 1 : 0) != 0, (Object)"Parent section ID=%s is mapped to multiple named faults");
                this.faultNames.put(parentID, name);
            }
        }
    }

    @Override
    public void registerTypeAdapters(GsonBuilder builder) {
    }

    public Set<String> getFaultNames() {
        return this.namedFaults.keySet();
    }

    public List<Integer> getParentIDsForFault(String name) {
        return this.namedFaults.get(name);
    }

    public List<FaultSection> getSectsForFault(String name) {
        HashSet<Integer> parentIDs = new HashSet<Integer>(this.getParentIDsForFault(name));
        ArrayList<FaultSection> sects = new ArrayList<FaultSection>();
        for (FaultSection faultSection : this.rupSet.getFaultSectionDataList()) {
            if (!parentIDs.contains(faultSection.getParentSectionId())) continue;
            sects.add(faultSection);
        }
        return sects;
    }

    public String getFaultName(int parentID) {
        return this.faultNames.get(parentID);
    }

    public static String stripFaultNameFromSect(String faultName, String sectName) {
        faultName = faultName.trim();
        while (faultName.contains("  ")) {
            faultName = faultName.replace("  ", " ");
        }
        sectName = sectName.trim();
        while (sectName.contains("  ")) {
            sectName = sectName.replace("  ", " ");
        }
        if (sectName.startsWith(faultName)) {
            return sectName.substring(faultName.length()).replace("(", "").replace(")", "").trim();
        }
        if (faultName.contains("(")) {
            faultName = faultName.substring(0, faultName.indexOf("("));
        }
        if (faultName.contains("[")) {
            faultName = faultName.substring(0, faultName.indexOf("["));
        }
        if (sectName.startsWith(faultName = faultName.trim())) {
            return sectName.substring(faultName.length()).replace("(", "").replace(")", "").trim();
        }
        if (sectName.contains(" ")) {
            String[] stringArray;
            if (faultName.contains(" ")) {
                stringArray = faultName.split(" ");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = faultName;
            }
            String[] faultWords = stringArray;
            String[] sectWords = sectName.split(" ");
            int numToSkip = 0;
            for (int i = 0; i < faultWords.length && i < sectWords.length && faultWords[i].equalsIgnoreCase(sectWords[i]); ++i) {
                ++numToSkip;
            }
            if (numToSkip > 0) {
                return Joiner.on((String)" ").join((Object[])Arrays.copyOfRange(sectWords, numToSkip, sectWords.length));
            }
        }
        return sectName;
    }

    @Override
    public Class<NamedFaults> getAveragingType() {
        return NamedFaults.class;
    }

    @Override
    public boolean isIdentical(NamedFaults module) {
        if (this.namedFaults.size() != module.namedFaults.size()) {
            return false;
        }
        for (String name : this.namedFaults.keySet()) {
            if (module.namedFaults.containsKey(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NamedFaults getForRuptureSubSet(FaultSystemRupSet rupSubSet, RuptureSubSetMappings mappings) {
        return new NamedFaults(rupSubSet, this.namedFaults);
    }

    @Override
    public NamedFaults getForSplitRuptureSet(FaultSystemRupSet splitRupSet, RuptureSetSplitMappings mappings) {
        return new NamedFaults(splitRupSet, this.namedFaults);
    }
}

