/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensha.commons.data.CSVReader;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.Region;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.geo.json.FeatureProperties;
import org.opensha.commons.geo.json.Geometry;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.commons.util.modules.helpers.LargeCSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RuptureSetSplitMappings;
import org.opensha.sha.earthquake.faultSysSolution.modules.SplittableRuptureModule;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSectionBranchAverager;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;

public class ProxyFaultSectionInstances
implements ArchivableModule,
BranchAverageableModule<ProxyFaultSectionInstances> {
    public static final String PROXY_SECTS_FILE_NAME = "proxy_fault_section_instances.geojson";
    public static final String PROXY_RUP_SECTS_FILE_NAME = "proxy_rup_sect_indices.csv";
    private List<? extends FaultSection> proxySects;
    private Map<Integer, List<List<Integer>>> proxyRupSectIndices;
    private static final int TRACE_BUF_LENGTHS_ALONG_STRIKE_DEFAULT = 5;
    private static final int TRACE_BUF_LENGTHS_FAULT_NORMAL_DEFAULT = 10;
    private static final double MIN_FRACT_TRACE_LEN_DEFAULT = 0.25;
    private static final boolean SHEAR_TO_CONNECT_DEFAULT = true;
    private static final boolean D = false;
    private static final double min_dist_to_resample = 0.1;

    public static ProxyFaultSectionInstances build(FaultSystemRupSet rupSet, int minNumProxySectsPerPoly, double maxProxySpacing) {
        return ProxyFaultSectionInstances.build(rupSet, minNumProxySectsPerPoly, maxProxySpacing, 0.25, 5, 10, true);
    }

    public static ProxyFaultSectionInstances build(FaultSystemRupSet rupSet, int minNumProxySectsPerPoly, double maxProxySpacing, double minFractTraceLen, int traceBufLengthsAlongStrike, int traceBufLengthsFaultNormal, boolean shearToConnect) {
        boolean bl;
        ArrayList<GeoJSONFaultSection> allProxySects = new ArrayList<GeoJSONFaultSection>();
        Preconditions.checkArgument((minNumProxySectsPerPoly > 1 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxProxySpacing > 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((minFractTraceLen > 0.0 && minFractTraceLen <= 1.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((traceBufLengthsAlongStrike > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((traceBufLengthsFaultNormal > 0 ? 1 : 0) != 0);
        ArbitrarilyDiscretizedFunc improvementWorthItFunc = new ArbitrarilyDiscretizedFunc();
        if (minFractTraceLen < 0.5) {
            improvementWorthItFunc.set(0.5, 0.06);
        }
        if (minFractTraceLen < 0.75) {
            improvementWorthItFunc.set(0.75, 0.065);
        }
        if (minFractTraceLen < 0.9) {
            improvementWorthItFunc.set(0.9, 0.07);
        }
        if (minFractTraceLen < 0.95) {
            improvementWorthItFunc.set(0.95, 0.075);
        }
        if (minFractTraceLen < 1.0) {
            improvementWorthItFunc.set(1.0, 0.08);
        }
        if (improvementWorthItFunc.size() == 0) {
            improvementWorthItFunc = null;
        }
        ArrayList<Integer> proxySectIDs = new ArrayList<Integer>();
        HashMap<Integer, double[]> proxyMaxRelocationDists = new HashMap<Integer, double[]>();
        HashMap<Integer, Integer> numProxySectsPerPolys = new HashMap<Integer, Integer>();
        HashSet<Integer> possibleProxyRups = new HashSet<Integer>();
        for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
            double traceLen;
            if (!faultSection.isProxyFault() || faultSection.getZonePolygon() == null) continue;
            proxySectIDs.add(faultSection.getSectionId());
            possibleProxyRups.addAll(rupSet.getRupturesForSection(faultSection.getSectionId()));
            Region poly = faultSection.getZonePolygon();
            FaultTrace trace = faultSection.getFaultTrace();
            double maxTraceOrWidth = traceLen = trace.getTraceLength();
            if (faultSection.getAveDip() < 90.0 && faultSection.getOrigDownDipWidth() > 0.0) {
                maxTraceOrWidth = Math.max(traceLen, Math.sqrt(Math.pow(faultSection.getOrigDownDipWidth(), 2.0)) - Math.pow(faultSection.getOrigAveUpperDepth() - faultSection.getAveLowerDepth(), 2.0));
            }
            double maxDistFaultNorm = maxTraceOrWidth * (double)traceBufLengthsFaultNormal;
            double rightAz = faultSection.getDipDirection();
            if (faultSection instanceof GeoJSONFaultSection) {
                rightAz = ((GeoJSONFaultSection)faultSection).getProperties().getDouble("SectPolyDir", rightAz);
            }
            double leftAz = rightAz + 180.0;
            double maxDistForLeft = ProxyFaultSectionInstances.findFurtherstViableRelocatedTrace(trace, poly, leftAz, maxDistFaultNorm, minFractTraceLen, improvementWorthItFunc);
            double maxDistForRight = ProxyFaultSectionInstances.findFurtherstViableRelocatedTrace(trace, poly, rightAz, maxDistFaultNorm, minFractTraceLen, improvementWorthItFunc);
            double width = maxDistForLeft + maxDistForRight;
            int numProxySectsPerPoly = Integer.max(minNumProxySectsPerPoly, (int)(Math.ceil(width / maxProxySpacing) + 1.0));
            Preconditions.checkState((maxDistForLeft > 0.0 ? 1 : 0) != 0);
            Preconditions.checkState((maxDistForRight > 0.0 ? 1 : 0) != 0);
            proxyMaxRelocationDists.put(faultSection.getSectionId(), new double[]{maxDistForLeft, maxDistForRight});
            numProxySectsPerPolys.put(faultSection.getSectionId(), numProxySectsPerPoly);
        }
        Preconditions.checkState((!proxyMaxRelocationDists.isEmpty() ? 1 : 0) != 0, (Object)"No proxy faults found with polygons attached");
        ArrayList<Integer> fullyProxyRuptures = new ArrayList<Integer>();
        Iterator iterator = possibleProxyRups.iterator();
        while (iterator.hasNext()) {
            int rupIndex = (Integer)iterator.next();
            boolean allOnProxies = true;
            List<Integer> rupSects = rupSet.getSectionsIndicesForRup(rupIndex);
            for (int sectIndex : rupSects) {
                if (proxyMaxRelocationDists.containsKey(sectIndex)) continue;
                allOnProxies = false;
                break;
            }
            if (!allOnProxies) continue;
            fullyProxyRuptures.add(rupIndex);
        }
        Preconditions.checkState((!fullyProxyRuptures.isEmpty() ? 1 : 0) != 0, (Object)"No ruptures exclusively on proxy faults?");
        boolean bl2 = true;
        while (bl) {
            bl = false;
            Iterator rupIndex = fullyProxyRuptures.iterator();
            while (rupIndex.hasNext()) {
                int rupIndex2 = (Integer)rupIndex.next();
                List<Integer> rupSects = rupSet.getSectionsIndicesForRup(rupIndex2);
                int maxNum = 0;
                int minNum = Integer.MAX_VALUE;
                for (int sectID : rupSects) {
                    int myNum = (Integer)numProxySectsPerPolys.get(sectID);
                    maxNum = Integer.max(maxNum, myNum);
                    minNum = Integer.min(minNum, myNum);
                }
                Preconditions.checkState((maxNum > 0 ? 1 : 0) != 0);
                if (maxNum == minNum) continue;
                bl = true;
                for (int sectID : rupSects) {
                    numProxySectsPerPolys.put(sectID, maxNum);
                }
            }
        }
        HashMap subProxyExtendedTraces = new HashMap();
        HashMap subProxyTraces = new HashMap();
        HashMap proxySectsByParent = new HashMap();
        HashMap<Integer, Double> proxySectsRightAzimuths = new HashMap<Integer, Double>();
        Iterator minNum = proxySectIDs.iterator();
        while (minNum.hasNext()) {
            int sectID = (Integer)minNum.next();
            FaultSection sect3 = rupSet.getFaultSectionData(sectID);
            if (sect3.getParentSectionId() >= 0) {
                if (!proxySectsByParent.containsKey(sect3.getParentSectionId())) {
                    proxySectsByParent.put(sect3.getParentSectionId(), new ArrayList());
                }
                ((List)proxySectsByParent.get(sect3.getParentSectionId())).add(sect3);
            }
            double[] leftRightDists = (double[])proxyMaxRelocationDists.get(sectID);
            double maxDistForLeft = leftRightDists[0];
            double maxDistForRight = leftRightDists[1];
            int numProxySectsPerPoly = (Integer)numProxySectsPerPolys.get(sectID);
            Region poly = sect3.getZonePolygon();
            FaultTrace trace = sect3.getFaultTrace();
            double traceLen = trace.getTraceLength();
            double rightAz = sect3.getDipDirection();
            if (sect3 instanceof GeoJSONFaultSection) {
                rightAz = ((GeoJSONFaultSection)sect3).getProperties().getDouble("SectPolyDir", rightAz);
            }
            LocationVector traceVect = LocationUtils.vector(trace.first(), trace.last());
            proxySectsRightAzimuths.put(sect3.getSectionId(), rightAz);
            EvenlyDiscretizedFunc distBins = new EvenlyDiscretizedFunc(-maxDistForLeft, maxDistForRight, numProxySectsPerPoly);
            Preconditions.checkState((distBins.size() == numProxySectsPerPoly ? 1 : 0) != 0);
            Preconditions.checkState(((float)distBins.getX(0) == (float)(-maxDistForLeft) ? 1 : 0) != 0);
            Preconditions.checkState(((float)distBins.getX(distBins.size() - 1) == (float)maxDistForRight ? 1 : 0) != 0);
            double spacing = distBins.getX(1) - distBins.getX(0);
            double spacing2 = (distBins.getX(distBins.size() - 1) - distBins.getX(0)) / (double)(distBins.size() - 1);
            Preconditions.checkState(((float)spacing == (float)spacing2 ? 1 : 0) != 0, (String)"%s != %s", (Object)spacing, (Object)spacing2);
            Preconditions.checkState(((float)spacing <= (float)maxProxySpacing ? 1 : 0) != 0, (String)"Spacing=%s for %s with %s proxies exceeds the max of %s", (Object)Float.valueOf((float)spacing), (Object)sect3.getSectionName(), (Object)numProxySectsPerPoly, (Object)Float.valueOf((float)maxProxySpacing));
            ArrayList<FaultTrace> extendedProxyTraces = new ArrayList<FaultTrace>();
            ArrayList<FaultTrace> proxyTraces = new ArrayList<FaultTrace>();
            for (int p = 0; p < numProxySectsPerPoly; ++p) {
                double dist = distBins.getX(p);
                FaultTrace relocatedTrace = ProxyFaultSectionInstances.relocate(trace, new LocationVector(rightAz, dist, 0.0));
                FaultTrace extended = new FaultTrace(null);
                extended.add(LocationUtils.location(relocatedTrace.first(), traceVect.getAzimuthRad() + Math.PI, traceLen * (double)traceBufLengthsAlongStrike));
                extended.addAll(relocatedTrace);
                extended.add(LocationUtils.location(relocatedTrace.last(), traceVect.getAzimuthRad(), traceLen * (double)traceBufLengthsAlongStrike));
                FaultTrace proxyTrace = ProxyFaultSectionInstances.trimTraceToRegion(poly, extended);
                proxyTraces.add(proxyTrace);
                extendedProxyTraces.add(extended);
            }
            subProxyExtendedTraces.put(sect3.getSectionId(), extendedProxyTraces);
            subProxyTraces.put(sect3.getSectionId(), proxyTraces);
        }
        if (shearToConnect && !proxySectsByParent.isEmpty()) {
            int[] shearIters = new int[]{11, 5, 3};
            for (List parentBundle : proxySectsByParent.values()) {
                if (parentBundle.size() == 1) continue;
                int numProxySectsPerPoly = -1;
                for (FaultSection sect4 : parentBundle) {
                    int myNum = (Integer)numProxySectsPerPolys.get(sect4.getSectionId());
                    if (numProxySectsPerPoly < 0) {
                        numProxySectsPerPoly = myNum;
                        continue;
                    }
                    Preconditions.checkState((numProxySectsPerPoly == myNum ? 1 : 0) != 0);
                }
                for (int p = 0; p < numProxySectsPerPoly; ++p) {
                    for (int iter = 0; iter < shearIters.length; ++iter) {
                        for (int b = 0; b < parentBundle.size() - 1; ++b) {
                            double angle2;
                            double angle1;
                            Location sect2L2;
                            Location sect2L1;
                            double sect2Start;
                            FaultSection sect1 = (FaultSection)parentBundle.get(b);
                            FaultSection sect2 = (FaultSection)parentBundle.get(b + 1);
                            int sectID1 = sect1.getSectionId();
                            int sectID2 = sect2.getSectionId();
                            Region poly1 = sect1.getZonePolygon();
                            Region poly2 = sect2.getZonePolygon();
                            FaultTrace trimmedTrace1 = (FaultTrace)((List)subProxyTraces.get(sectID1)).get(p);
                            FaultTrace extendedTrace1 = (FaultTrace)((List)subProxyExtendedTraces.get(sectID1)).get(p);
                            if (b == 0) {
                                extendedTrace1 = ProxyFaultSectionInstances.trimTraceToRegion(poly1, extendedTrace1, true, false);
                            }
                            Location sect1L1 = sect1.getFaultTrace().first();
                            Location sect1L2 = sect1.getFaultTrace().last();
                            double sect1End = LocationUtils.distanceToLineFast(sect1L1, sect1L2, trimmedTrace1.last());
                            FaultTrace trimmedTrace2 = (FaultTrace)((List)subProxyTraces.get(sectID2)).get(p);
                            FaultTrace extendedTrace2 = (FaultTrace)((List)subProxyExtendedTraces.get(sectID2)).get(p);
                            if (b == parentBundle.size() - 2) {
                                extendedTrace2 = ProxyFaultSectionInstances.trimTraceToRegion(poly2, extendedTrace2, false, true);
                            }
                            if ((float)sect1End == (float)(sect2Start = LocationUtils.distanceToLineFast(sect2L1 = sect2.getFaultTrace().first(), sect2L2 = sect2.getFaultTrace().last(), trimmedTrace2.first()))) continue;
                            double maxShear = Math.abs(sect1End - sect2Start);
                            double avgRightAngle = FaultUtils.getAngleAverage(List.of((Double)proxySectsRightAzimuths.get(sectID1), (Double)proxySectsRightAzimuths.get(sectID2)));
                            if (Math.abs(sect1End) > Math.abs(sect2Start)) {
                                if (sect1End >= 0.0) {
                                    angle1 = avgRightAngle + 180.0;
                                    angle2 = avgRightAngle;
                                } else {
                                    angle1 = avgRightAngle;
                                    angle2 = avgRightAngle + 180.0;
                                }
                            } else if (sect2Start >= 0.0) {
                                angle1 = avgRightAngle;
                                angle2 = avgRightAngle + 180.0;
                            } else {
                                angle1 = avgRightAngle + 180.0;
                                angle2 = avgRightAngle;
                            }
                            EvenlyDiscretizedFunc shearTries = new EvenlyDiscretizedFunc(0.0, maxShear, shearIters[iter]);
                            FaultTrace closestTrimmedTrace1 = null;
                            FaultTrace closestTrimmedTrace2 = null;
                            FaultTrace closestExtendedTrace1 = null;
                            FaultTrace closestExtendedTrace2 = null;
                            int closestIndex = -1;
                            double closestDist = Double.POSITIVE_INFINITY;
                            for (int i = 0; i < shearIters[iter]; ++i) {
                                FaultTrace shearedTrimmedTrace2;
                                FaultTrace shearedTrimmedTrace1;
                                double shearDist = shearTries.getX(i);
                                FaultTrace shearedExtendedTrace1 = ProxyFaultSectionInstances.shearTrace(extendedTrace1, trimmedTrace1.first(), trimmedTrace1.last(), shearDist, angle1);
                                FaultTrace shearedExtendedTrace2 = ProxyFaultSectionInstances.shearTrace(extendedTrace2, trimmedTrace2.last(), trimmedTrace2.first(), shearDist, angle2);
                                try {
                                    shearedTrimmedTrace1 = ProxyFaultSectionInstances.trimTraceToRegion(poly1, shearedExtendedTrace1);
                                    shearedTrimmedTrace2 = ProxyFaultSectionInstances.trimTraceToRegion(poly2, shearedExtendedTrace2);
                                }
                                catch (Exception e) {
                                    continue;
                                }
                                double dist = LocationUtils.horzDistanceFast(shearedTrimmedTrace1.last(), shearedTrimmedTrace2.first());
                                if (!(dist < closestDist)) continue;
                                closestDist = dist;
                                closestIndex = i;
                                closestTrimmedTrace1 = shearedTrimmedTrace1;
                                closestTrimmedTrace2 = shearedTrimmedTrace2;
                                closestExtendedTrace1 = shearedExtendedTrace1;
                                closestExtendedTrace2 = shearedExtendedTrace2;
                            }
                            if (closestIndex <= 0) continue;
                            ((List)subProxyTraces.get(sectID1)).set(p, closestTrimmedTrace1);
                            ((List)subProxyExtendedTraces.get(sectID1)).set(p, closestExtendedTrace1);
                            ((List)subProxyTraces.get(sectID2)).set(p, closestTrimmedTrace2);
                            ((List)subProxyExtendedTraces.get(sectID2)).set(p, closestExtendedTrace2);
                        }
                    }
                }
            }
        }
        HashMap subProxySects = new HashMap();
        Iterator sectID = proxySectIDs.iterator();
        while (sectID.hasNext()) {
            int sectID2 = (Integer)sectID.next();
            FaultSection sect5 = rupSet.getFaultSectionData(sectID2);
            List proxyTraces = (List)subProxyTraces.get(sectID2);
            int numProxySectsPerPoly = (Integer)numProxySectsPerPolys.get(sectID2);
            Preconditions.checkState((proxyTraces.size() == numProxySectsPerPoly ? 1 : 0) != 0);
            GeoJSONFaultSection geoSect = sect5 instanceof GeoJSONFaultSection ? (GeoJSONFaultSection)sect5 : new GeoJSONFaultSection(sect5);
            Feature origFeature = geoSect.toFeature();
            FeatureProperties proxyProps = new FeatureProperties(origFeature.properties);
            proxyProps.remove("FaultID");
            proxyProps.remove("FaultName");
            proxyProps.remove("ParentID");
            proxyProps.remove("ParentName");
            double origSlip = sect5.getOrigAveSlipRate();
            double proxySlip = origSlip / (double)numProxySectsPerPoly;
            double origSlipSD = sect5.getOrigSlipRateStdDev();
            double proxySlipSD = origSlip > 0.0 && origSlipSD > 0.0 ? origSlipSD / (double)numProxySectsPerPoly : origSlipSD;
            proxyProps.set("SlipRate", proxySlip);
            proxyProps.set("SlipRateStdDev", proxySlipSD);
            ArrayList<GeoJSONFaultSection> myProxySects = new ArrayList<GeoJSONFaultSection>(numProxySectsPerPoly);
            subProxySects.put(sect5.getSectionId(), myProxySects);
            for (int p = 0; p < numProxySectsPerPoly; ++p) {
                FaultTrace proxyTrace = (FaultTrace)proxyTraces.get(p);
                Geometry.LineString geom = new Geometry.LineString(proxyTrace);
                int id = allProxySects.size();
                String name = sect5.getSectionName() + ", Proxy " + p;
                FeatureProperties myProxyProps = new FeatureProperties(proxyProps);
                myProxyProps.set("FaultID", id);
                myProxyProps.set("FaultName", name);
                myProxyProps.set("ParentID", sect5.getSectionId());
                myProxyProps.set("ParentName", sect5.getSectionName());
                Feature proxyFeature = new Feature(id, (Geometry)geom, myProxyProps);
                GeoJSONFaultSection proxySect = GeoJSONFaultSection.fromFeature(proxyFeature);
                allProxySects.add(proxySect);
                myProxySects.add(proxySect);
            }
        }
        HashMap<Integer, List<List<Integer>>> proxyRupSectIndices = new HashMap<Integer, List<List<Integer>>>();
        Iterator iterator2 = fullyProxyRuptures.iterator();
        while (iterator2.hasNext()) {
            int rupIndex = (Integer)iterator2.next();
            List<Integer> rupSects = rupSet.getSectionsIndicesForRup(rupIndex);
            int numProxySectsPerPoly = -1;
            for (int sectID3 : rupSects) {
                int myNum = (Integer)numProxySectsPerPolys.get(sectID3);
                if (numProxySectsPerPoly < 0) {
                    numProxySectsPerPoly = myNum;
                    continue;
                }
                Preconditions.checkState((numProxySectsPerPoly == myNum ? 1 : 0) != 0);
            }
            ArrayList proxyIndexesList = new ArrayList();
            for (int p = 0; p < numProxySectsPerPoly; ++p) {
                ArrayList<Integer> proxyIndexes = new ArrayList<Integer>(rupSects.size());
                for (int sectIndex : rupSects) {
                    FaultSection proxyFault = (FaultSection)((List)subProxySects.get(sectIndex)).get(p);
                    proxyIndexes.add(proxyFault.getSectionId());
                }
                proxyIndexesList.add(proxyIndexes);
            }
            proxyRupSectIndices.put(rupIndex, proxyIndexesList);
        }
        return new ProxyFaultSectionInstances(allProxySects, proxyRupSectIndices);
    }

    private static FaultTrace shearTrace(FaultTrace trace, Location anchor, Location reference, double distance, double azimuthDegrees) {
        double azimuth = Math.toRadians(azimuthDegrees);
        Location newReference = LocationUtils.location(reference, azimuth, distance);
        double distAR = LocationUtils.horzDistance(anchor, reference);
        double azimuthAR = LocationUtils.azimuthRad(anchor, reference);
        double distAR_new = LocationUtils.horzDistance(anchor, newReference);
        double azimuthAR_new = LocationUtils.azimuthRad(anchor, newReference);
        double shearFactor = distAR_new / distAR;
        double azimuthDelta = azimuthAR_new - azimuthAR;
        FaultTrace shearedTrace = new FaultTrace(null);
        for (Location point : trace) {
            double distAP = LocationUtils.horzDistance(anchor, point);
            double azimuthAP = LocationUtils.azimuthRad(anchor, point);
            double newDistAP = distAP * shearFactor;
            double newAzimuthAP = azimuthAP + azimuthDelta;
            Location newPoint = LocationUtils.location(anchor, newAzimuthAP, newDistAP);
            shearedTrace.add(newPoint);
        }
        return shearedTrace;
    }

    private static FaultTrace trimTraceToRegion(Region poly, FaultTrace extended) {
        return ProxyFaultSectionInstances.trimTraceToRegion(poly, extended, true, true);
    }

    private static FaultTrace trimTraceToRegion(Region poly, FaultTrace extended, boolean trimBefore, boolean trimAfter) {
        FaultTrace proxyTrace = new FaultTrace(null);
        boolean polyContainedPrev = false;
        ArrayList<Location> origLocsBefore = new ArrayList<Location>();
        ArrayList<Location> origLocsAfter = new ArrayList<Location>();
        for (int i = 0; i < extended.size(); ++i) {
            Location loc = (Location)extended.get(i);
            boolean polyContainsLoc = poly.contains(loc);
            if (i > 0 && LocationUtils.horzDistanceFast(loc, (Location)extended.get(i - 1)) > 0.1) {
                int j;
                Location prev = (Location)extended.get(i - 1);
                FaultTrace seg = new FaultTrace(null);
                seg.add(prev);
                seg.add(loc);
                Preconditions.checkState((!prev.equals(loc) && !LocationUtils.areSimilar(prev, loc) ? 1 : 0) != 0, (String)"Trace contains duplicates: %s == %s", (Object)prev, (Object)loc);
                int numSamples = Integer.max(100, (int)(seg.getTraceLength() * 10.0));
                FaultTrace resampled = FaultUtils.resampleTrace(seg, numSamples);
                boolean polyContainsResampledLoc = poly.contains(resampled.last());
                if (polyContainsLoc != polyContainsResampledLoc) {
                    polyContainsLoc = true;
                }
                boolean[] resampledInsides = new boolean[resampled.size()];
                for (j = 0; j < resampledInsides.length; ++j) {
                    resampledInsides[j] = j == 0 ? polyContainedPrev : (j == resampledInsides.length - 1 ? polyContainsLoc : poly.contains((Location)resampled.get(j)));
                }
                for (j = 1; j < resampled.size(); ++j) {
                    if (resampledInsides[j - 1] == resampledInsides[j]) continue;
                    FaultTrace seg2 = new FaultTrace(null);
                    seg2.add((Location)resampled.get(j - 1));
                    seg2.add((Location)resampled.get(j));
                    FaultTrace resampled2 = FaultUtils.resampleTrace(seg2, Integer.max(10, (int)(seg2.getTraceLength() * 10.0)));
                    boolean[] resampledInsides2 = new boolean[resampled2.size()];
                    for (int k = 0; k < resampledInsides2.length; ++k) {
                        resampledInsides2[k] = k == 0 ? resampledInsides[j - 1] : (k == resampledInsides2.length - 1 ? resampledInsides[j] : poly.contains((Location)resampled2.get(k)));
                    }
                    boolean found = false;
                    for (int k = 1; k < resampled2.size(); ++k) {
                        if (resampledInsides2[k - 1] == resampledInsides2[k]) continue;
                        Location newLoc = resampledInsides2[k - 1] ? (Location)resampled2.get(k - 1) : (Location)resampled2.get(k);
                        proxyTrace.add(newLoc);
                        found = true;
                        break;
                    }
                    Preconditions.checkState((boolean)found);
                }
            }
            if (polyContainsLoc) {
                proxyTrace.add(loc);
                origLocsAfter.clear();
            } else if (proxyTrace.isEmpty()) {
                origLocsBefore.add(loc);
            } else {
                origLocsAfter.add(loc);
            }
            polyContainedPrev = polyContainsLoc;
        }
        if (!trimBefore && !origLocsBefore.isEmpty()) {
            proxyTrace.addAll(0, origLocsBefore);
        }
        if (!trimAfter && !origLocsAfter.isEmpty()) {
            proxyTrace.addAll(origLocsAfter);
        }
        Preconditions.checkState((proxyTrace.size() > 1 ? 1 : 0) != 0, (String)"Only found %s locations within poly?", (int)proxyTrace.size());
        return proxyTrace;
    }

    private static FaultTrace relocate(FaultTrace trace, LocationVector vect) {
        FaultTrace ret = new FaultTrace(null);
        for (Location loc : trace) {
            ret.add(LocationUtils.location(loc, vect));
        }
        return ret;
    }

    private static double fractInside(FaultTrace trace, Region poly) {
        FaultTrace resampled = FaultUtils.resampleTrace(trace, 100);
        int numInside = 0;
        for (Location loc : resampled) {
            if (!poly.contains(loc)) continue;
            ++numInside;
        }
        return (double)numInside / (double)resampled.size();
    }

    private static double findFurtherstViableRelocatedTrace(FaultTrace trace, Region poly, double azimuth, double maxDistAway, double minFract, DiscretizedFunc improvementWorthItFunc) {
        double fract;
        FaultTrace relocated;
        LocationVector vector;
        double dist;
        int i;
        EvenlyDiscretizedFunc distFractFunc = new EvenlyDiscretizedFunc(0.0, maxDistAway, 100);
        double maxCoarse = 0.0;
        for (i = 0; i < distFractFunc.size(); ++i) {
            dist = distFractFunc.getX(i);
            vector = new LocationVector(azimuth, dist, 0.0);
            relocated = ProxyFaultSectionInstances.relocate(trace, vector);
            fract = ProxyFaultSectionInstances.fractInside(relocated, poly);
            if (fract > 0.0) {
                maxCoarse = dist;
            }
            distFractFunc.set(i, fract);
        }
        distFractFunc = new EvenlyDiscretizedFunc(0.0, maxCoarse + 2.0 * distFractFunc.getDelta(), 100);
        for (i = 0; i < distFractFunc.size(); ++i) {
            dist = distFractFunc.getX(i);
            vector = new LocationVector(azimuth, dist, 0.0);
            relocated = ProxyFaultSectionInstances.relocate(trace, vector);
            fract = ProxyFaultSectionInstances.fractInside(relocated, poly);
            distFractFunc.set(i, fract);
        }
        double fractForRet = -1.0;
        double retDist = -1.0;
        int i2 = distFractFunc.size();
        while (--i2 >= 0) {
            double dist2 = distFractFunc.getX(i2);
            double fract2 = distFractFunc.getY(i2);
            if (!(fract2 >= minFract)) continue;
            retDist = dist2;
            fractForRet = fract2;
            break;
        }
        Preconditions.checkState((fractForRet > 0.0 ? 1 : 0) != 0, (String)"Bad fract for %s: %s\nfunc: %s", (Object)trace.getName(), (Object)fractForRet, (Object)distFractFunc);
        if (improvementWorthItFunc != null) {
            double origDist = retDist;
            for (Point2D pt : improvementWorthItFunc) {
                double targetFract = pt.getX();
                double testDist = -1.0;
                double fractForTest = -1.0;
                int i3 = distFractFunc.size();
                while (--i3 >= 0) {
                    double dist3 = distFractFunc.getX(i3);
                    double fract3 = distFractFunc.getY(i3);
                    if (!(fract3 >= targetFract)) continue;
                    testDist = dist3;
                    fractForTest = fract3;
                    break;
                }
                if (!(testDist > 0.0)) break;
                double deltaFract = (origDist - testDist) / origDist;
                double maxDelta = pt.getY();
                if (!(deltaFract <= maxDelta)) continue;
                retDist = testDist;
                fractForRet = fractForTest;
            }
        }
        return retDist;
    }

    private ProxyFaultSectionInstances() {
    }

    private ProxyFaultSectionInstances(List<? extends FaultSection> proxySects, Map<Integer, List<List<Integer>>> proxyRupSectIndices) {
        this.proxySects = proxySects;
        this.proxyRupSectIndices = proxyRupSectIndices;
    }

    @Override
    public String getName() {
        return "Proxy Fault Sections";
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(FileBackedModule.initOutputStream(output, entryPrefix, PROXY_SECTS_FILE_NAME));
        GeoJSONFaultReader.writeFaultSections(writer, this.proxySects);
        writer.flush();
        output.closeEntry();
        CSVWriter csvWriter = new CSVWriter(FileBackedModule.initOutputStream(output, entryPrefix, PROXY_RUP_SECTS_FILE_NAME), false);
        ProxyFaultSectionInstances.buildRupSectsCSV(this.proxyRupSectIndices, csvWriter);
        csvWriter.flush();
        output.closeEntry();
    }

    public static void buildRupSectsCSV(Map<Integer, List<List<Integer>>> proxyRupSectIndices, CSVWriter writer) throws IOException {
        int maxNumSects = 0;
        for (List<List<Integer>> list : proxyRupSectIndices.values()) {
            for (List<Integer> ids : list) {
                maxNumSects = Integer.max(maxNumSects, ids.size());
            }
        }
        ArrayList<String> header = new ArrayList<String>(List.of("Rupture Index", "Num Proxy Representations", "Proxy Representation Index", "Num Sections", "Proxy Sect # 1"));
        for (int s = 1; s < maxNumSects; ++s) {
            header.add("# " + (s + 1));
        }
        writer.write(header);
        ArrayList<Integer> rupIndexes = new ArrayList<Integer>(proxyRupSectIndices.keySet());
        Collections.sort(rupIndexes);
        Iterator<List<Integer>> iterator = rupIndexes.iterator();
        while (iterator.hasNext()) {
            int r = (Integer)((Object)iterator.next());
            List<List<Integer>> sectIDsList = proxyRupSectIndices.get(r);
            int numProxies = sectIDsList.size();
            for (int p = 0; p < numProxies; ++p) {
                List<Integer> sectIDs = sectIDsList.get(p);
                ArrayList<String> line = new ArrayList<String>(4 + sectIDs.size());
                line.add("" + r);
                line.add("" + numProxies);
                line.add("" + p);
                line.add("" + sectIDs.size());
                for (int s : sectIDs) {
                    line.add("" + s);
                }
                writer.write(line);
            }
        }
        writer.flush();
    }

    @Override
    public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        List<GeoJSONFaultSection> sections = GeoJSONFaultReader.readFaultSections(new InputStreamReader(FileBackedModule.getInputStream(input, entryPrefix, PROXY_SECTS_FILE_NAME)));
        for (int s = 0; s < sections.size(); ++s) {
            FaultSection sect = sections.get(s);
            Preconditions.checkState((sect.getSectionId() == s ? 1 : 0) != 0, (Object)"Fault sections must be provided in order starting with ID=0");
            Preconditions.checkState((sect.getParentSectionId() >= 0 ? 1 : 0) != 0, (Object)"All proxy faults should have their parent ID set (to the corresponding subsection)");
        }
        this.proxySects = sections;
        CSVReader rupSectsCSV = LargeCSV_BackedModule.loadFromArchive(input, entryPrefix, PROXY_RUP_SECTS_FILE_NAME);
        this.proxyRupSectIndices = ProxyFaultSectionInstances.loadRupSectsCSV(rupSectsCSV, sections.size());
    }

    public static Map<Integer, List<List<Integer>>> loadRupSectsCSV(CSVReader rupSectsCSV, int numSections) {
        int rupIndex;
        Object csvRow;
        HashMap<Integer, List<List<Integer>>> proxyRupSectIndices = new HashMap<Integer, List<List<Integer>>>();
        boolean shortSafe = numSections < Short.MAX_VALUE;
        rupSectsCSV.read();
        while ((csvRow = rupSectsCSV.read()) != null) {
            rupIndex = ((CSVReader.Row)csvRow).getInt(0);
            Preconditions.checkState((rupIndex >= 0 ? 1 : 0) != 0, (String)"Bad rupIndex=%s", (int)rupIndex);
            int numProxies = ((CSVReader.Row)csvRow).getInt(1);
            Preconditions.checkState((numProxies > 0 ? 1 : 0) != 0, (String)"Bad numProxies=%s for rupIndex=%s", (int)numProxies, (int)rupIndex);
            int proxyIndex = ((CSVReader.Row)csvRow).getInt(2);
            Preconditions.checkState((proxyIndex >= 0 && proxyIndex < numProxies ? 1 : 0) != 0, (String)"Bad proxyIndex=%s for rupIndex=%s with numProxies=%s", (Object)proxyIndex, (Object)rupIndex, (Object)numProxies);
            int numRupSects = ((CSVReader.Row)csvRow).getInt(3);
            Preconditions.checkState((numRupSects > 0 ? 1 : 0) != 0, (String)"Bad numRupSects=%s for rupIndex=%s", (int)numRupSects, (int)rupIndex);
            Preconditions.checkState((((CSVReader.Row)csvRow).getLine().size() == numRupSects + 4 ? 1 : 0) != 0, (String)"Expected numRupSects+4=%s columns for rupIndex=%s proxyIndex=%s, have %s columns", (Object)(numRupSects + 4), (Object)rupIndex, (Object)proxyIndex, (Object)((CSVReader.Row)csvRow).getLine().size());
            ArrayList<ArrayList<Integer>> sectIDsList = (ArrayList<ArrayList<Integer>>)proxyRupSectIndices.get(rupIndex);
            if (sectIDsList == null) {
                sectIDsList = new ArrayList<ArrayList<Integer>>(numProxies);
                for (int p = 0; p < numProxies; ++p) {
                    sectIDsList.add(null);
                }
                proxyRupSectIndices.put(rupIndex, sectIDsList);
            } else {
                Preconditions.checkState((sectIDsList.size() == numProxies ? 1 : 0) != 0);
                Preconditions.checkState((sectIDsList.get(proxyIndex) == null ? 1 : 0) != 0);
            }
            AbstractList sectIDs = new ArrayList<Integer>(numRupSects);
            for (int i = 0; i < numRupSects; ++i) {
                sectIDs.add(((CSVReader.Row)csvRow).getInt(i + 4));
            }
            sectIDs = shortSafe ? new FaultSystemRupSet.ShortListWrapper(sectIDs) : new FaultSystemRupSet.IntListWrapper(sectIDs);
            sectIDsList.set(proxyIndex, (ArrayList<Integer>)sectIDs);
        }
        Preconditions.checkState((!proxyRupSectIndices.isEmpty() ? 1 : 0) != 0, (Object)"No proxy ruptures included?");
        csvRow = proxyRupSectIndices.keySet().iterator();
        while (csvRow.hasNext()) {
            rupIndex = (Integer)csvRow.next();
            List sectIDsList = (List)proxyRupSectIndices.get(rupIndex);
            for (int p = 0; p < sectIDsList.size(); ++p) {
                Preconditions.checkNotNull((Object)((List)sectIDsList.get(p)), (String)"Proxy %s/%s never filled in for rupIndex=%s", (Object)p, (Object)sectIDsList.size(), (Object)rupIndex);
            }
        }
        try {
            rupSectsCSV.close();
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
        return proxyRupSectIndices;
    }

    public List<? extends FaultSection> getProxySects() {
        return this.proxySects;
    }

    public Set<Integer> getProxyRupIndexes() {
        return this.proxyRupSectIndices.keySet();
    }

    public boolean rupHasProxies(int rupIndex) {
        return this.proxyRupSectIndices.containsKey(rupIndex);
    }

    public List<List<Integer>> getRupProxySectIndexes(int rupIndex) {
        return this.proxyRupSectIndices.get(rupIndex);
    }

    public List<List<FaultSection>> getRupProxySects(int rupIndex) {
        List<List<Integer>> sectIDsList = this.proxyRupSectIndices.get(rupIndex);
        ArrayList<List<FaultSection>> ret = new ArrayList<List<FaultSection>>(sectIDsList.size());
        for (List<Integer> sectIDs : sectIDsList) {
            ArrayList<FaultSection> sects = new ArrayList<FaultSection>();
            for (int sectID : sectIDs) {
                sects.add(this.proxySects.get(sectID));
            }
            ret.add(sects);
        }
        return ret;
    }

    @Override
    public AverageableModule.AveragingAccumulator<ProxyFaultSectionInstances> averagingAccumulator() {
        return new Averager();
    }

    public FaultSystemRupSet getSplitRuptureSet(FaultSystemRupSet origRupSet) {
        HashMap<Integer, ArrayList<FaultSection>> proxySectsMap = new HashMap<Integer, ArrayList<FaultSection>>();
        for (FaultSection faultSection : this.proxySects) {
            int origID = faultSection.getParentSectionId();
            ArrayList<FaultSection> sectProxies = (ArrayList<FaultSection>)proxySectsMap.get(origID);
            if (sectProxies == null) {
                sectProxies = new ArrayList<FaultSection>();
                proxySectsMap.put(origID, sectProxies);
            }
            sectProxies.add(faultSection);
        }
        HashMap<Integer, Integer> proxyIDs_toNew = new HashMap<Integer, Integer>(this.proxySects.size());
        HashMap<Integer, List<Integer>> hashMap = new HashMap<Integer, List<Integer>>();
        ArrayList<FaultSection> modSects = new ArrayList<FaultSection>();
        for (int s = 0; s < origRupSet.getNumSections(); ++s) {
            FaultSection origSect = origRupSet.getFaultSectionData(s);
            int origID = origSect.getSectionId();
            ArrayList<Integer> newIDs = new ArrayList<Integer>();
            if (proxySectsMap.containsKey(origID)) {
                for (FaultSection proxySect : (List)proxySectsMap.get(origID)) {
                    FaultSection copy = proxySect.clone();
                    copy.setParentSectionId(origSect.getParentSectionId());
                    copy.setParentSectionName(origSect.getParentSectionName());
                    int modID = modSects.size();
                    newIDs.add(modID);
                    copy.setSectionId(modID);
                    modSects.add(copy);
                    proxyIDs_toNew.put(proxySect.getSectionId(), modID);
                }
            } else {
                FaultSection copy = origSect.clone();
                int modID = modSects.size();
                newIDs.add(modID);
                copy.setSectionId(modID);
                modSects.add(copy);
            }
            hashMap.put(origID, newIDs);
        }
        int rupIndex = 0;
        HashMap<Integer, List<Integer>> rupIDs_oldToNew = new HashMap<Integer, List<Integer>>();
        HashMap<Integer, Integer> rupIDs_newToOld = new HashMap<Integer, Integer>();
        ArrayList<List<Integer>> modSectionForRups = new ArrayList<List<Integer>>();
        for (int origID = 0; origID < origRupSet.getNumRuptures(); ++origID) {
            if (this.rupHasProxies(origID)) {
                List<List<FaultSection>> proxies = this.getRupProxySects(origID);
                ArrayList<Integer> newIDs = new ArrayList<Integer>(proxies.size());
                for (int i = 0; i < proxies.size(); ++i) {
                    rupIDs_newToOld.put(rupIndex, origID);
                    newIDs.add(rupIndex++);
                    List<FaultSection> rupProxies = proxies.get(i);
                    ArrayList<Integer> sectsForRups = new ArrayList<Integer>(rupProxies.size());
                    for (FaultSection proxy : rupProxies) {
                        sectsForRups.add((Integer)proxyIDs_toNew.get(proxy.getSectionId()));
                    }
                    modSectionForRups.add(sectsForRups);
                }
                rupIDs_oldToNew.put(origID, newIDs);
                continue;
            }
            rupIDs_newToOld.put(rupIndex, origID);
            rupIDs_oldToNew.put(origID, List.of(Integer.valueOf(rupIndex++)));
            List<Integer> origSectsForRups = origRupSet.getSectionsIndicesForRup(origID);
            ArrayList<Integer> sectsForRups = new ArrayList<Integer>();
            for (int sectID : origSectsForRups) {
                List newSectIDs = (List)hashMap.get(sectID);
                Preconditions.checkState((newSectIDs.size() == 1 ? 1 : 0) != 0, (Object)"Rupture not identified as proxy rup but uses proxy sects; we do not yet support ruptures on proxy and non-proxy faults. Could add support in the future by keeping proxy surfaces around in this case and just using those for these ruptures.");
                sectsForRups.add((Integer)newSectIDs.get(0));
            }
            modSectionForRups.add(sectsForRups);
        }
        double[] rupLengths = origRupSet.getLengthForAllRups();
        double[] modMags = new double[rupIndex];
        double[] modRakes = new double[rupIndex];
        double[] modRupAreas = new double[rupIndex];
        double[] modRupLengths = rupLengths == null ? null : new double[rupIndex];
        for (rupIndex = 0; rupIndex < rupIDs_newToOld.size(); ++rupIndex) {
            int origID = (Integer)rupIDs_newToOld.get(rupIndex);
            modMags[rupIndex] = origRupSet.getMagForRup(origID);
            modRakes[rupIndex] = origRupSet.getAveRakeForRup(origID);
            modRupAreas[rupIndex] = origRupSet.getAreaForRup(origID);
            if (modRupLengths == null) continue;
            modRupLengths[rupIndex] = rupLengths[origID];
        }
        FaultSystemRupSet modRupSet = new FaultSystemRupSet(modSects, modSectionForRups, modMags, modRakes, modRupAreas, modRupLengths);
        System.out.println("Split from " + origRupSet.getNumSections() + " sects to " + modRupSet.getNumSections());
        System.out.println("Split from " + origRupSet.getNumRuptures() + " rups to " + modRupSet.getNumRuptures());
        RuptureSetSplitMappings mappings = new RuptureSetSplitMappings(hashMap, rupIDs_oldToNew);
        modRupSet.addModule(mappings);
        for (OpenSHA_Module module : origRupSet.getModulesAssignableTo(SplittableRuptureModule.class, true)) {
            Object modModule;
            try {
                modModule = ((SplittableRuptureModule)module).getForSplitRuptureSet(modRupSet, mappings);
            }
            catch (Exception e) {
                System.out.println("Couldn't split module " + module.getName() + ", skipping: " + e.getMessage());
                continue;
            }
            if (modModule == null) continue;
            modRupSet.addModule(modModule);
        }
        return modRupSet;
    }

    private static class Averager
    implements AverageableModule.AveragingAccumulator<ProxyFaultSectionInstances> {
        private FaultSectionBranchAverager sectAverager;
        private Map<Integer, List<List<Integer>>> proxyRupSectIndices;

        private Averager() {
        }

        @Override
        public Class<ProxyFaultSectionInstances> getType() {
            return ProxyFaultSectionInstances.class;
        }

        @Override
        public void process(ProxyFaultSectionInstances module, double relWeight) {
            if (this.sectAverager == null) {
                this.sectAverager = new FaultSectionBranchAverager(module.proxySects);
                this.proxyRupSectIndices = module.proxyRupSectIndices;
            } else {
                Preconditions.checkState((this.proxyRupSectIndices.size() == module.proxyRupSectIndices.size() ? 1 : 0) != 0);
                for (int rupIndex : this.proxyRupSectIndices.keySet()) {
                    List<List<Integer>> mine = this.proxyRupSectIndices.get(rupIndex);
                    List<List<Integer>> theirs = module.proxyRupSectIndices.get(rupIndex);
                    Preconditions.checkNotNull(theirs);
                    Preconditions.checkState((mine.size() == theirs.size() ? 1 : 0) != 0);
                    Preconditions.checkState((boolean)mine.get(0).equals(theirs.get(0)));
                    Preconditions.checkState((boolean)mine.get(mine.size() - 1).equals(theirs.get(mine.size() - 1)));
                }
            }
            this.sectAverager.addWeighted(module.proxySects, relWeight);
        }

        @Override
        public ProxyFaultSectionInstances getAverage() {
            return new ProxyFaultSectionInstances(this.sectAverager.buildAverageSects(), this.proxyRupSectIndices);
        }
    }
}

