/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.zip.ZipFile;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.CSVReader;
import org.opensha.commons.data.CSVWriter;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.json.Feature;
import org.opensha.commons.logicTree.BranchWeightProvider;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.io.archive.ArchiveInput;
import org.opensha.commons.util.io.archive.ArchiveOutput;
import org.opensha.commons.util.modules.ArchivableModule;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.commons.util.modules.helpers.FileBackedModule;
import org.opensha.commons.util.modules.helpers.LargeCSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.completion.AnnealingProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.AbstractLogicTreeModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BuildInfoModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceList;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitProgress;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfits;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupSetTectonicRegimes;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.GeoJSONFaultReader;
import org.opensha.sha.earthquake.faultSysSolution.util.BranchAverageSolutionCreator;
import org.opensha.sha.earthquake.faultSysSolution.util.SolModuleStripper;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.imr.logicTree.ScalarIMR_ParamsLogicTreeNode;
import org.opensha.sha.imr.logicTree.ScalarIMRsLogicTreeNode;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.U3FaultSystemSolutionFetcher;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.U3InversionConfigFactory;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.LastEventData;

public class SolutionLogicTree
extends AbstractLogicTreeModule {
    public static final String SUB_DIRECTORY_NAME = "solution_logic_tree";
    private static final boolean SERIALIZE_GRIDDED_DEFAULT = true;
    private boolean serializeGridded = true;
    private SolutionProcessor processor;
    protected ModuleArchive<OpenSHA_Module> archive;
    protected GridSourceProvider constantGridProv;
    protected boolean firstConstantGridProvTry = true;
    protected ArchiveInput directCopySource;
    public static final String GRID_PROV_INSTANCE_FILE_NAME = "grid_provider_instance.json";
    private List<? extends FaultSection> prevSubSects;
    private String prevSectsFile;
    private List<List<Integer>> prevRupIndices;
    private String prevIndicesFile;
    private FaultSystemRupSet.RuptureProperties prevProps;
    private String prevPropsFile;
    private RupSetTectonicRegimes prevTRTs;
    private String prevTRTsFile;
    private GriddedRegion prevGridReg;
    private String prevGridRegFile;
    private LocationList prevGridLocs;
    private String prevGridLocsFile;
    private CSVFile<String> prevGridMechs;
    private String prevGridMechFile;
    private double[] prevRates;
    private String prevRatesFile;
    private static final String PROCESSOR_FILE_NAME = "solution_processor.json";
    protected boolean writeREADME = false;

    private static U3LogicTreeBranch asU3Branch(LogicTreeBranch<?> branch) {
        if (branch instanceof U3LogicTreeBranch) {
            return (U3LogicTreeBranch)branch;
        }
        Preconditions.checkState((branch.size() >= U3LogicTreeBranch.getLogicTreeLevels().size() ? 1 : 0) != 0);
        ArrayList vals = new ArrayList();
        for (LogicTreeNode val : branch) {
            Preconditions.checkState((boolean)(val instanceof U3LogicTreeBranchNode));
            vals.add((U3LogicTreeBranchNode)val);
        }
        return U3LogicTreeBranch.fromValues(vals);
    }

    private SolutionLogicTree() {
        this(null, null);
    }

    protected SolutionLogicTree(SolutionProcessor processor, LogicTree<?> logicTree) {
        this(processor, null, null, logicTree);
    }

    protected SolutionLogicTree(SolutionProcessor processor, ArchiveInput input, String prefix, LogicTree<?> logicTree) {
        super(input, prefix, logicTree);
        this.processor = processor;
    }

    public SolutionProcessor getProcessor() {
        return this.processor;
    }

    public void setProcessor(SolutionProcessor processor) {
        this.processor = processor;
    }

    @Override
    public String getName() {
        return "Rupture Set Logic Tree";
    }

    @Override
    protected String getSubDirectoryName() {
        return SUB_DIRECTORY_NAME;
    }

    public void setSerializeGridded(boolean serializeGridded) {
        this.serializeGridded = serializeGridded;
    }

    public void setConstantGridProv(GridSourceProvider constantGridProv) {
        this.constantGridProv = constantGridProv;
    }

    public void setDirectCopySource(ArchiveInput input) {
        this.directCopySource = input;
    }

    @Override
    protected Map<String, String> writeBranchFilesToArchive(ArchiveOutput output, String prefix, LogicTreeBranch<?> branch, HashSet<String> writtenFiles) throws IOException {
        FaultSystemSolution sol = this.forBranch(branch);
        return this.writeBranchFilesToArchive(output, prefix, branch, writtenFiles, sol);
    }

    protected Map<String, String> writeBranchFilesToArchive(ArchiveOutput output, String prefix, LogicTreeBranch<?> branch, HashSet<String> writtenFiles, FaultSystemSolution sol) throws IOException {
        PlausibilityConfiguration plausibility;
        String plausibilityFile;
        String progressFile;
        InversionMisfitProgress misfitProgress;
        String progressFile2;
        AnnealingProgress progress;
        String statsFile;
        String mfdsFile;
        String ratesFile;
        String trtsFile;
        String propsFile;
        String indicesFile;
        String sectsFile;
        FaultSystemRupSet rupSet = sol.getRupSet();
        String entryPrefix = null;
        LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
        String rsPrefix = "ruptures/";
        String solPrefix = "solution/";
        ArchiveInput input = this.directCopySource;
        boolean inputIsSolArchive = false;
        if (input == null) {
            input = sol.getArchive().getInput();
            inputIsSolArchive = true;
        }
        if (!writtenFiles.contains(sectsFile = this.getRecordBranchFileName(branch, prefix, "fault_sections.geojson", true, mappings))) {
            if (!this.directCopy(input, output, rsPrefix + "fault_sections.geojson", sectsFile, inputIsSolArchive)) {
                FileBackedModule.initEntry(output, entryPrefix, sectsFile);
                OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
                GeoJSONFaultReader.writeFaultSections(writer, rupSet.getFaultSectionDataList());
                writer.flush();
                output.closeEntry();
            }
            writtenFiles.add(sectsFile);
        }
        if (!writtenFiles.contains(indicesFile = this.getRecordBranchFileName(branch, prefix, "indices.csv", true, mappings))) {
            if (!this.directCopy(input, output, rsPrefix + "indices.csv", indicesFile, inputIsSolArchive)) {
                FileBackedModule.initEntry(output, entryPrefix, indicesFile);
                CSVWriter entryWriter = new CSVWriter(output.getOutputStream(), false);
                FaultSystemRupSet.buildRupSectsCSV(rupSet, entryWriter);
                entryWriter.flush();
                output.closeEntry();
            }
            writtenFiles.add(indicesFile);
        }
        if (!writtenFiles.contains(propsFile = this.getRecordBranchFileName(branch, prefix, "properties.csv", true, mappings))) {
            if (!this.directCopy(input, output, rsPrefix + "properties.csv", propsFile, inputIsSolArchive)) {
                FileBackedModule.initEntry(output, entryPrefix, propsFile);
                CSVWriter entryWriter = new CSVWriter(output.getOutputStream(), true);
                new FaultSystemRupSet.RuptureProperties(rupSet).buildCSV(entryWriter);
                entryWriter.flush();
                output.closeEntry();
            }
            writtenFiles.add(propsFile);
        }
        List<? extends LogicTreeLevel<?>> rupSectLevels = this.getLevelsAffectingFile("indices.csv", true);
        if (rupSet.hasModule(RupSetTectonicRegimes.class) && !writtenFiles.contains(trtsFile = this.getRecordBranchFileName(branch, prefix, "tectonic_regimes.csv", rupSectLevels, mappings))) {
            if (!this.directCopy(input, output, rsPrefix + "tectonic_regimes.csv", trtsFile, inputIsSolArchive)) {
                RupSetTectonicRegimes trts = rupSet.requireModule(RupSetTectonicRegimes.class);
                CSV_BackedModule.writeToArchive(trts.getCSV(), output, entryPrefix, trtsFile);
            }
            writtenFiles.add(trtsFile);
        }
        if (!writtenFiles.contains(ratesFile = this.getRecordBranchFileName(branch, prefix, "rates.csv", true, mappings))) {
            if (!this.directCopy(input, output, solPrefix + "rates.csv", ratesFile, inputIsSolArchive)) {
                CSV_BackedModule.writeToArchive(FaultSystemSolution.buildRatesCSV(sol), output, entryPrefix, ratesFile);
            }
            writtenFiles.add(ratesFile);
        }
        if (sol.hasModule(RupMFDsModule.class) && !writtenFiles.contains(mfdsFile = this.getRecordBranchFileName(branch, prefix, "rup_mfds.csv", true, mappings))) {
            if (!this.directCopy(input, output, solPrefix + "rup_mfds.csv", mfdsFile, inputIsSolArchive)) {
                RupMFDsModule mfds = sol.requireModule(RupMFDsModule.class);
                CSV_BackedModule.writeToArchive(mfds.getCSV(), output, entryPrefix, mfdsFile);
            }
            writtenFiles.add(mfdsFile);
        }
        if (this.constantGridProv != null) {
            mappings.putAll(this.writeGridProvToArchive(this.constantGridProv, output, prefix, null, writtenFiles));
        } else if (this.serializeGridded && sol.hasModule(GridSourceProvider.class)) {
            GridSourceProvider prov = sol.getModule(GridSourceProvider.class);
            mappings.putAll(this.writeGridProvToArchive(prov, output, prefix, branch, writtenFiles));
        }
        InversionMisfitStats misfitStats = sol.getModule(InversionMisfitStats.class);
        if (misfitStats == null && sol.hasModule(InversionMisfits.class)) {
            misfitStats = sol.requireModule(InversionMisfits.class).getMisfitStats();
        }
        if (misfitStats != null && !writtenFiles.contains(statsFile = this.getRecordBranchFileName(branch, prefix, "inversion_misfit_stats.csv", true, mappings))) {
            if (!this.directCopy(input, output, solPrefix + "inversion_misfit_stats.csv", statsFile, inputIsSolArchive)) {
                CSV_BackedModule.writeToArchive(misfitStats.getCSV(), output, entryPrefix, statsFile);
            }
            writtenFiles.add(statsFile);
        }
        if ((progress = sol.getModule(AnnealingProgress.class)) != null && !writtenFiles.contains(progressFile2 = this.getRecordBranchFileName(branch, prefix, "annealing_progress.csv", true, mappings))) {
            if (!this.directCopy(input, output, solPrefix + "annealing_progress.csv", progressFile2, inputIsSolArchive)) {
                CSV_BackedModule.writeToArchive(progress.getCSV(), output, entryPrefix, progressFile2);
            }
            writtenFiles.add(progressFile2);
        }
        if ((misfitProgress = sol.getModule(InversionMisfitProgress.class)) != null && !writtenFiles.contains(progressFile = this.getRecordBranchFileName(branch, prefix, "inversion_misfit_progress.csv", true, mappings))) {
            if (!this.directCopy(input, output, solPrefix + "inversion_misfit_progress.csv", progressFile, inputIsSolArchive)) {
                CSV_BackedModule.writeToArchive(misfitProgress.getCSV(), output, entryPrefix, progressFile);
            }
            writtenFiles.add(progressFile);
        }
        if (!writtenFiles.contains(plausibilityFile = this.getBranchFileName(branch, prefix, "plausibility.json", rupSectLevels)) && (plausibility = rupSet.getModule(PlausibilityConfiguration.class)) != null) {
            if (!writtenFiles.contains(plausibilityFile)) {
                if (!this.directCopy(input, output, rsPrefix + "plausibility.json", plausibilityFile, inputIsSolArchive)) {
                    plausibility.writeToArchive(output, entryPrefix, plausibilityFile);
                }
                writtenFiles.add(plausibilityFile);
            }
            mappings.put("plausibility.json", plausibilityFile);
        }
        return mappings;
    }

    public Map<String, String> writeGridProvToArchive(GridSourceProvider prov, ArchiveOutput output, String prefix, LogicTreeBranch<?> branch, HashSet<String> writtenFiles) throws IOException {
        return this.writeGridProvToArchive(prov, output, prefix, branch, writtenFiles, this.directCopySource, false);
    }

    protected Map<String, String> writeGridProvToArchive(GridSourceProvider prov, ArchiveOutput output, String prefix, LogicTreeBranch<?> branch, HashSet<String> writtenFiles, ArchiveInput input, boolean inputIsSolArchive) throws IOException {
        LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>();
        String solPrefix = "solution/";
        if (prov instanceof MFDGridSourceProvider) {
            List<? extends LogicTreeLevel<?>> mappingLevels;
            String gridProvFile;
            String unassociatedFile;
            String subSeisFile;
            String mechFile;
            String gridRegFile;
            MFDGridSourceProvider.AbstractPrecomputed precomputed = prov instanceof MFDGridSourceProvider.AbstractPrecomputed ? (MFDGridSourceProvider.AbstractPrecomputed)prov : new MFDGridSourceProvider.Default((MFDGridSourceProvider)prov);
            Class<? extends ArchivableModule> loadingClass = precomputed.getLoadingClass();
            if (!MFDGridSourceProvider.AbstractPrecomputed.class.isAssignableFrom(loadingClass)) {
                loadingClass = MFDGridSourceProvider.Default.class;
            }
            if ((gridRegFile = this.getRecordBranchFileName(branch, prefix, "grid_region.geojson", false, mappings)) != null && !writtenFiles.contains(gridRegFile)) {
                if (!this.directCopy(input, output, solPrefix + "grid_region.geojson", gridRegFile, inputIsSolArchive)) {
                    FileBackedModule.initEntry(output, null, gridRegFile);
                    Feature regFeature = precomputed.getGriddedRegion().toFeature();
                    OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
                    Feature.write(regFeature, writer);
                    writer.flush();
                    output.closeEntry();
                }
                writtenFiles.add(gridRegFile);
            }
            if ((mechFile = this.getRecordBranchFileName(branch, prefix, "grid_mech_weights.csv", false, mappings)) != null && !writtenFiles.contains(mechFile)) {
                if (!this.directCopy(input, output, solPrefix + "grid_mech_weights.csv", mechFile, inputIsSolArchive)) {
                    CSV_BackedModule.writeToArchive(precomputed.buildWeightsCSV(), output, null, mechFile);
                }
                writtenFiles.add(mechFile);
            }
            if ((subSeisFile = this.getRecordBranchFileName(branch, prefix, "grid_sub_seis_mfds.csv", true, mappings)) != null && !writtenFiles.contains(subSeisFile)) {
                if (!this.directCopy(input, output, solPrefix + "grid_sub_seis_mfds.csv", subSeisFile, inputIsSolArchive)) {
                    CSVFile<String> csv = precomputed.buildSubSeisCSV();
                    if (csv != null) {
                        CSV_BackedModule.writeToArchive(csv, output, null, subSeisFile);
                        writtenFiles.add(subSeisFile);
                    }
                } else {
                    writtenFiles.add(subSeisFile);
                }
            }
            if ((unassociatedFile = this.getRecordBranchFileName(branch, prefix, "grid_unassociated_mfds.csv", true, mappings)) != null && !writtenFiles.contains(unassociatedFile)) {
                if (!this.directCopy(input, output, solPrefix + "grid_unassociated_mfds.csv", unassociatedFile, inputIsSolArchive)) {
                    CSVFile<String> csv = precomputed.buildUnassociatedCSV();
                    if (csv != null) {
                        CSV_BackedModule.writeToArchive(csv, output, null, unassociatedFile);
                        writtenFiles.add(unassociatedFile);
                    }
                } else {
                    writtenFiles.add(unassociatedFile);
                }
            }
            if (!writtenFiles.contains(gridProvFile = this.getRecordBranchFileName(branch, prefix, GRID_PROV_INSTANCE_FILE_NAME, mappingLevels = this.getLevelsAffectingFile("grid_sub_seis_mfds.csv", true), mappings))) {
                FileBackedModule.initEntry(output, null, gridProvFile);
                SolutionLogicTree.writeGridSourceProvInstanceFile(output.getOutputStream(), loadingClass);
                output.closeEntry();
                writtenFiles.add(gridProvFile);
            }
        } else if (prov instanceof GridSourceList) {
            String sourcesFile;
            String locsFile;
            String gridRegFile;
            GridSourceList gridSources = (GridSourceList)prov;
            if (gridSources.getGriddedRegion() != null && (gridRegFile = this.getRecordBranchFileName(branch, prefix, "grid_region.geojson", false, mappings)) != null && !writtenFiles.contains(gridRegFile)) {
                if (!this.directCopy(input, output, solPrefix + "grid_region.geojson", gridRegFile, inputIsSolArchive)) {
                    FileBackedModule.initEntry(output, null, gridRegFile);
                    Feature regFeature = gridSources.getGriddedRegion().toFeature();
                    OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
                    Feature.write(regFeature, writer);
                    writer.flush();
                    output.closeEntry();
                }
                writtenFiles.add(gridRegFile);
            }
            if ((locsFile = this.getRecordBranchFileName(branch, prefix, "grid_source_locations.csv", false, mappings)) != null && !writtenFiles.contains(locsFile)) {
                if (!this.directCopy(input, output, solPrefix + "grid_source_locations.csv", locsFile, inputIsSolArchive)) {
                    CSV_BackedModule.writeToArchive(gridSources.buildGridLocsCSV(), output, null, locsFile);
                }
                writtenFiles.add(locsFile);
            }
            if ((sourcesFile = this.getRecordBranchFileName(branch, prefix, "grid_sources.csv", true, mappings)) != null && !writtenFiles.contains(sourcesFile)) {
                if (!this.directCopy(input, output, solPrefix + "grid_sources.csv", sourcesFile, inputIsSolArchive)) {
                    gridSources.writeGridSourcesCSV(output, sourcesFile);
                }
                writtenFiles.add(sourcesFile);
            }
        } else {
            throw new UnsupportedOperationException("Don't yet support writing grid source provider of type: " + prov.getClass().getName());
        }
        return mappings;
    }

    protected boolean directCopy(ArchiveInput input, ArchiveOutput output, String origFileName, String outputFileName, boolean useOrigFileName) throws IOException {
        String inputName;
        if (input == null) {
            return false;
        }
        String testFileName = origFileName;
        if (origFileName.contains("/")) {
            testFileName = testFileName.substring(testFileName.lastIndexOf(47));
        }
        Preconditions.checkState((boolean)outputFileName.endsWith(testFileName), (String)"directCopy name mismatch, probably a typo? origFileName='%s'; outputFileName='%s'", (Object)origFileName, (Object)outputFileName);
        String string = inputName = useOrigFileName ? origFileName : outputFileName;
        if (!input.hasEntry(inputName)) {
            return false;
        }
        output.transferFrom(input, inputName, outputFileName);
        return true;
    }

    protected Map<String, String> directCopyGridProvToArchive(ArchiveInput input, ArchiveOutput output, String prefix, LogicTreeBranch<?> branch, HashSet<String> writtenFiles) throws IOException {
        ArrayList<String> inputFileNames = new ArrayList<String>(6);
        ArrayList<Boolean> inputAffectedByDefaults = new ArrayList<Boolean>(6);
        inputFileNames.add("grid_region.geojson");
        inputAffectedByDefaults.add(false);
        inputFileNames.add("grid_mech_weights.csv");
        inputAffectedByDefaults.add(false);
        inputFileNames.add("grid_sub_seis_mfds.csv");
        inputAffectedByDefaults.add(true);
        inputFileNames.add("grid_unassociated_mfds.csv");
        inputAffectedByDefaults.add(true);
        inputFileNames.add("grid_source_locations.csv");
        inputAffectedByDefaults.add(false);
        inputFileNames.add("grid_sources.csv");
        inputAffectedByDefaults.add(true);
        LinkedHashMap<String, String> possibleFiles = new LinkedHashMap<String, String>(inputFileNames.size());
        for (int i = 0; i < inputFileNames.size(); ++i) {
            String fileName = (String)inputFileNames.get(i);
            String branchFileName = this.getBranchFileName(branch, prefix, fileName, (Boolean)inputAffectedByDefaults.get(i));
            if (branchFileName == null) continue;
            possibleFiles.put(fileName, branchFileName);
        }
        LinkedHashMap<String, String> mappings = new LinkedHashMap<String, String>(possibleFiles.size());
        boolean anyPresent = false;
        for (String fileName : possibleFiles.keySet()) {
            String branchFileName = (String)possibleFiles.get(fileName);
            if (writtenFiles.contains(branchFileName)) {
                anyPresent = true;
                mappings.put(fileName, branchFileName);
                continue;
            }
            if (!input.hasEntry(branchFileName)) continue;
            output.transferFrom(input, branchFileName);
            writtenFiles.add(branchFileName);
            mappings.put(fileName, branchFileName);
            anyPresent = true;
        }
        Preconditions.checkState((boolean)anyPresent, (Object)"Couldn't direct-copy a GridSourceProvider (no matching entries found in zip)");
        return mappings;
    }

    public static void writeGridSourceProvInstanceFile(OutputStream out, Class<? extends ArchivableModule> loadingClass) throws IOException {
        BufferedWriter bWrite = new BufferedWriter(new OutputStreamWriter(out));
        JsonWriter writer = new JsonWriter((Writer)bWrite);
        writer.beginObject().name("gridSourceProvider").value(loadingClass.getName()).endObject();
        writer.flush();
        bWrite.flush();
    }

    public synchronized double[] loadRatesForBranch(LogicTreeBranch<?> branch) throws IOException {
        String ratesFile = this.getBranchFileName(branch, "rates.csv", true);
        if (this.prevRates != null && ratesFile.equals(this.prevRatesFile)) {
            if (this.verbose) {
                System.out.println("\tRe-using previous rupture rates");
            }
            return this.prevRates;
        }
        if (this.verbose) {
            System.out.println("\tLoading rate data from " + ratesFile);
        }
        ArchiveInput input = this.getArchiveInput();
        CSVFile<String> ratesCSV = CSV_BackedModule.loadFromArchive(input, null, ratesFile);
        double[] rates = FaultSystemSolution.loadRatesCSV(ratesCSV);
        this.prevRates = rates;
        this.prevRatesFile = ratesFile;
        return rates;
    }

    public synchronized FaultSystemRupSet.RuptureProperties loadPropsForBranch(LogicTreeBranch<?> branch) throws IOException {
        FaultSystemRupSet.RuptureProperties props;
        String propsFile = this.getBranchFileName(branch, "properties.csv", true);
        if (this.prevProps != null && propsFile.equals(this.prevPropsFile)) {
            if (this.verbose) {
                System.out.println("\tRe-using previous rupture properties");
            }
            props = this.prevProps;
        } else {
            if (this.verbose) {
                System.out.println("\tLoading rupture properties from " + propsFile);
            }
            ArchiveInput input = this.getArchiveInput();
            CSVFile<String> rupPropsCSV = CSV_BackedModule.loadFromArchive(input, null, propsFile);
            this.prevProps = props = new FaultSystemRupSet.RuptureProperties(rupPropsCSV);
            this.prevPropsFile = propsFile;
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GridSourceProvider loadGridProvForBranch(LogicTreeBranch<?> branch) throws IOException {
        List<? extends LogicTreeLevel<?>> mappingLevels;
        String gridProvFile;
        CSVFile<String> mechCSV;
        GriddedRegion region;
        String gridRegFile = this.getBranchFileName(branch, "grid_region.geojson", false);
        String mechFile = this.getBranchFileName(branch, "grid_mech_weights.csv", false);
        String locsFile = this.getBranchFileName(branch, "grid_source_locations.csv", false);
        ArchiveInput input = this.getArchiveInput();
        if (locsFile != null && input.hasEntry(locsFile)) {
            LocationList locs;
            Object regionIS;
            GriddedRegion region2;
            SolutionLogicTree solutionLogicTree = this;
            synchronized (solutionLogicTree) {
                if (this.prevGridReg != null && gridRegFile.equals(this.prevGridRegFile)) {
                    region2 = this.prevGridReg;
                } else if (input.hasEntry(gridRegFile)) {
                    regionIS = FileBackedModule.getInputStream(input, null, gridRegFile);
                    InputStreamReader regionReader = new InputStreamReader((InputStream)regionIS);
                    Feature regFeature = Feature.read(regionReader);
                    this.prevGridReg = region2 = GriddedRegion.fromFeature(regFeature);
                    this.prevGridRegFile = gridRegFile;
                } else {
                    region2 = null;
                }
            }
            if (region2 != null) {
                locs = region2.getNodeList();
            } else {
                regionIS = this;
                synchronized (regionIS) {
                    if (this.prevGridLocs != null && locsFile.equals(this.prevGridLocsFile)) {
                        locs = this.prevGridLocs;
                    } else {
                        CSVFile<String> locsCSV = CSV_BackedModule.loadFromArchive(input, null, locsFile);
                        this.prevGridLocs = locs = GridSourceList.loadGridLocsCSV(locsCSV, region2);
                        this.prevGridLocsFile = locsFile;
                    }
                }
            }
            String sourcesFile = this.getBranchFileName(branch, "grid_sources.csv", true);
            CSVReader rupSectsCSV = LargeCSV_BackedModule.loadFromArchive(input, null, sourcesFile);
            EnumMap<TectonicRegionType, List<List<GridSourceList.GriddedRupture>>> trtRuptureLists = GridSourceList.loadGridSourcesCSV(rupSectsCSV, locs);
            if (region2 != null) {
                return new GridSourceList.Precomputed(region2, trtRuptureLists);
            }
            return new GridSourceList.Precomputed(locs, trtRuptureLists);
        }
        if (gridRegFile == null || !input.hasEntry(gridRegFile) || mechFile == null || !input.hasEntry(mechFile)) {
            return null;
        }
        SolutionLogicTree sourcesFile = this;
        synchronized (sourcesFile) {
            if (this.prevGridReg != null && gridRegFile.equals(this.prevGridRegFile)) {
                region = this.prevGridReg;
            } else {
                BufferedInputStream regionIS = FileBackedModule.getInputStream(input, null, gridRegFile);
                InputStreamReader regionReader = new InputStreamReader(regionIS);
                Feature regFeature = Feature.read(regionReader);
                this.prevGridReg = region = GriddedRegion.fromFeature(regFeature);
                this.prevGridRegFile = gridRegFile;
            }
            if (this.prevGridMechs != null && mechFile.equals(this.prevGridMechFile)) {
                mechCSV = this.prevGridMechs;
            } else {
                mechCSV = CSV_BackedModule.loadFromArchive(input, null, mechFile);
                this.prevGridMechs = mechCSV;
                this.prevGridMechFile = mechFile;
            }
        }
        CSVFile<String> subSeisCSV = null;
        CSVFile<String> nodeUnassociatedCSV = null;
        String subSeisFile = this.getBranchFileName(branch, "grid_sub_seis_mfds.csv", true);
        String nodeUnassociatedFile = this.getBranchFileName(branch, "grid_unassociated_mfds.csv", true);
        if (subSeisFile != null && input.hasEntry(subSeisFile)) {
            subSeisCSV = MFDGridSourceProvider.AbstractPrecomputed.loadCSV(input, null, subSeisFile);
        }
        if (nodeUnassociatedFile != null && input.hasEntry(nodeUnassociatedFile)) {
            nodeUnassociatedCSV = MFDGridSourceProvider.AbstractPrecomputed.loadCSV(input, null, nodeUnassociatedFile);
        }
        if (input.hasEntry(gridProvFile = this.getBranchFileName(branch, GRID_PROV_INSTANCE_FILE_NAME, mappingLevels = this.getLevelsAffectingFile("grid_sub_seis_mfds.csv", true)))) {
            try {
                BufferedReader bRead = new BufferedReader(new InputStreamReader(input.getInputStream(gridProvFile)));
                JsonReader reader = new JsonReader((Reader)bRead);
                reader.beginObject();
                reader.nextName();
                String className = reader.nextString();
                reader.endObject();
                reader.close();
                bRead.close();
                Class<?> loadingClass = Class.forName(className);
                Constructor<?> constructor = loadingClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                MFDGridSourceProvider.AbstractPrecomputed module = (MFDGridSourceProvider.AbstractPrecomputed)constructor.newInstance(new Object[0]);
                module.init(region, subSeisCSV, nodeUnassociatedCSV, mechCSV);
                return module;
            }
            catch (Exception e) {
                System.err.println("Warning: couldn't load specified GridSourceProvider instance: " + e.getMessage());
            }
        }
        return new MFDGridSourceProvider.Default(region, subSeisCSV, nodeUnassociatedCSV, mechCSV);
    }

    public synchronized FaultSystemSolution forBranch(LogicTreeBranch<?> branch) throws IOException {
        return this.forBranch(branch, true);
    }

    public synchronized FaultSystemSolution forBranch(final LogicTreeBranch<?> branch, boolean process) throws IOException {
        String mfdsFile;
        String plausibilityFile;
        String misfitProgressFile;
        String progressFile;
        List<List<Integer>> rupIndices;
        List<? extends FaultSection> subSects;
        if (this.verbose) {
            System.out.println("Loading rupture set for logic tree branch: " + String.valueOf(branch));
        }
        final ArchiveInput input = this.getArchiveInput();
        final String entryPrefix = null;
        String sectsFile = this.getBranchFileName(branch, "fault_sections.geojson", true);
        if (this.prevSubSects != null && sectsFile.equals(this.prevSectsFile)) {
            if (this.verbose) {
                System.out.println("\tRe-using previous section data");
            }
            subSects = this.prevSubSects;
        } else {
            if (this.verbose) {
                System.out.println("\tLoading section data from " + sectsFile);
            }
            subSects = GeoJSONFaultReader.readFaultSections(new InputStreamReader(FileBackedModule.getInputStream(input, entryPrefix, sectsFile)));
            for (int s = 0; s < subSects.size(); ++s) {
                Preconditions.checkState((subSects.get(s).getSectionId() == s ? 1 : 0) != 0, (Object)"Fault sections must be provided in order starting with ID=0");
            }
            this.prevSubSects = subSects;
            this.prevSectsFile = sectsFile;
        }
        FaultSystemRupSet.RuptureProperties props = this.loadPropsForBranch(branch);
        String indicesFile = this.getBranchFileName(branch, "indices.csv", true);
        if (this.prevRupIndices != null && indicesFile.equals(this.prevIndicesFile)) {
            if (this.verbose) {
                System.out.println("\tRe-using previous rupture indices");
            }
            rupIndices = this.prevRupIndices;
        } else {
            if (this.verbose) {
                System.out.println("\tLoading rupture indices from " + indicesFile);
            }
            CSVReader rupSectsCSV = LargeCSV_BackedModule.loadFromArchive(input, entryPrefix, indicesFile);
            this.prevRupIndices = rupIndices = FaultSystemRupSet.loadRupSectsCSV(rupSectsCSV, subSects.size(), props.mags.length);
            this.prevIndicesFile = indicesFile;
        }
        FaultSystemRupSet rupSet = new FaultSystemRupSet(subSects, rupIndices, props.mags, props.rakes, props.areas, props.lengths);
        if (process && this.processor != null) {
            rupSet = this.processor.processRupSet(rupSet, branch);
        }
        List<? extends LogicTreeLevel<?>> rupSectLevels = this.getLevelsAffectingFile("indices.csv", true);
        String trtsFile = this.getBranchFileName(branch, "tectonic_regimes.csv", rupSectLevels);
        if (this.prevTRTs != null && this.prevTRTsFile.equals(trtsFile)) {
            if (this.verbose) {
                System.out.println("\tRe-using previous TRTs data");
            }
            rupSet.addModule(this.prevTRTs);
        } else if (input.hasEntry(trtsFile)) {
            CSVFile<String> trtsCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, trtsFile);
            RupSetTectonicRegimes trts = RupSetTectonicRegimes.forCSV(rupSet, trtsCSV);
            rupSet.addModule(trts);
            this.prevTRTs = trts;
            this.prevTRTsFile = trtsFile;
        }
        double[] rates = this.loadRatesForBranch(branch);
        Preconditions.checkState((rates.length == rupIndices.size() ? 1 : 0) != 0);
        rupSet.addModule(branch);
        FaultSystemSolution sol = new FaultSystemSolution(rupSet, rates);
        if (process && this.processor != null) {
            sol = this.processor.processSolution(sol, branch);
        }
        sol.addModule(branch);
        String gridRegFile = this.getBranchFileName(branch, "grid_region.geojson", false);
        String mechFile = this.getBranchFileName(branch, "grid_mech_weights.csv", false);
        String locsFile = this.getBranchFileName(branch, "grid_source_locations.csv", false);
        Class provClass = null;
        if (gridRegFile != null && input.hasEntry(gridRegFile) && mechFile != null && input.hasEntry(mechFile)) {
            provClass = MFDGridSourceProvider.class;
        } else if (locsFile != null && input.hasEntry(locsFile)) {
            provClass = GridSourceList.class;
        }
        if (provClass == null && this.constantGridProv == null && this.firstConstantGridProvTry) {
            String prefix = this.getFilePrefix();
            gridRegFile = ArchivableModule.getEntryName(prefix, "grid_region.geojson");
            mechFile = ArchivableModule.getEntryName(prefix, "grid_mech_weights.csv");
            locsFile = ArchivableModule.getEntryName(prefix, "grid_source_locations.csv");
            if (gridRegFile != null && input.hasEntry(gridRegFile) && mechFile != null && input.hasEntry(mechFile)) {
                try {
                    if (this.verbose) {
                        System.out.println("Loading constantGridProv as an MFDGridSourceProvider");
                    }
                    this.constantGridProv = this.archive.loadUnlistedModule(MFDGridSourceProvider.class, prefix);
                }
                catch (Exception e) {
                    System.err.println("Failed to load a constantGridProv: " + e.getMessage());
                }
            } else if (locsFile != null && input.hasEntry(locsFile)) {
                if (this.verbose) {
                    System.out.println("Loading constantGridProv as a GridSourceList");
                }
                this.constantGridProv = this.archive.loadUnlistedModule(GridSourceList.class, prefix);
            }
            this.firstConstantGridProvTry = false;
        }
        if (provClass != null) {
            sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<GridSourceProvider>(){
                final /* synthetic */ SolutionLogicTree this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public GridSourceProvider call() throws Exception {
                    return this.this$0.loadGridProvForBranch(branch);
                }
            }, provClass);
        } else if (this.constantGridProv != null) {
            sol.addModule(this.constantGridProv);
        }
        final String statsFile = this.getBranchFileName(branch, "inversion_misfit_stats.csv", true);
        if (statsFile != null && input.hasEntry(statsFile)) {
            sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<InversionMisfitStats>(){
                final /* synthetic */ SolutionLogicTree this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public InversionMisfitStats call() throws Exception {
                    CSVFile<String> misfitStatsCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, statsFile);
                    InversionMisfitStats stats = new InversionMisfitStats(null);
                    stats.initFromCSV(misfitStatsCSV);
                    return stats;
                }
            }, InversionMisfitStats.class);
        }
        if ((progressFile = this.getBranchFileName(branch, "annealing_progress.csv", true)) != null && input.hasEntry(progressFile)) {
            sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<AnnealingProgress>(){
                final /* synthetic */ SolutionLogicTree this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public AnnealingProgress call() throws Exception {
                    CSVFile<String> progressCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, progressFile);
                    return new AnnealingProgress(progressCSV);
                }
            }, AnnealingProgress.class);
        }
        if ((misfitProgressFile = this.getBranchFileName(branch, "inversion_misfit_progress.csv", true)) != null && input.hasEntry(misfitProgressFile)) {
            sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<InversionMisfitProgress>(){
                final /* synthetic */ SolutionLogicTree this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public InversionMisfitProgress call() throws Exception {
                    CSVFile<String> progressCSV = CSV_BackedModule.loadFromArchive(input, entryPrefix, misfitProgressFile);
                    return new InversionMisfitProgress(progressCSV);
                }
            }, InversionMisfitProgress.class);
        }
        if ((plausibilityFile = this.getBranchFileName(branch, "plausibility.json", rupSectLevels)) != null && input.hasEntry(plausibilityFile)) {
            final List<? extends FaultSection> fsd = rupSet.getFaultSectionDataList();
            rupSet.addAvailableModule((Callable<OpenSHA_Module>)new Callable<PlausibilityConfiguration>(){
                final /* synthetic */ SolutionLogicTree this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public PlausibilityConfiguration call() throws Exception {
                    BufferedInputStream zin = FileBackedModule.getInputStream(input, entryPrefix, plausibilityFile);
                    InputStreamReader reader = new InputStreamReader(zin);
                    PlausibilityConfiguration plausibility = PlausibilityConfiguration.readJSON(reader, (List<? extends FaultSection>)fsd);
                    reader.close();
                    return plausibility;
                }
            }, PlausibilityConfiguration.class);
        }
        if ((mfdsFile = this.getBranchFileName(branch, "rup_mfds.csv", true)) != null && input.hasEntry(mfdsFile)) {
            final FaultSystemSolution solTmp = sol;
            sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<RupMFDsModule>(){
                final /* synthetic */ SolutionLogicTree this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public RupMFDsModule call() throws Exception {
                    CSVFile<String> csv = CSV_BackedModule.loadFromArchive(input, entryPrefix, mfdsFile);
                    RupMFDsModule mfds = new RupMFDsModule(solTmp, null);
                    mfds.initFromCSV(csv);
                    return mfds;
                }
            }, RupMFDsModule.class);
        }
        return sol;
    }

    public void write(File outputFile) throws IOException {
        ModuleArchive<ArchivableModule> archive = new ModuleArchive<ArchivableModule>();
        archive.addModule(this);
        try {
            archive.addModule(BuildInfoModule.detect());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.writeREADME = true;
        archive.write(outputFile);
        this.writeREADME = false;
    }

    public static SolutionLogicTree load(File treeFile) throws IOException {
        return SolutionLogicTree.load(treeFile, null);
    }

    public static SolutionLogicTree load(File treeFile, LogicTree<?> logicTree) throws IOException {
        return SolutionLogicTree.load(new ZipFile(treeFile), logicTree);
    }

    public static SolutionLogicTree load(ZipFile treeZip) throws IOException {
        return SolutionLogicTree.load(treeZip, null);
    }

    public static SolutionLogicTree load(ZipFile treeZip, LogicTree<?> logicTree) throws IOException {
        return SolutionLogicTree.load(new ArchiveInput.ZipFileInput(treeZip), logicTree);
    }

    public static SolutionLogicTree load(ArchiveInput input) throws IOException {
        return SolutionLogicTree.load(input, null);
    }

    public static SolutionLogicTree load(ArchiveInput input, LogicTree<?> logicTree) throws IOException {
        ModuleArchive<SolutionLogicTree> archive = new ModuleArchive<SolutionLogicTree>(input, SolutionLogicTree.class);
        SolutionLogicTree ret = archive.requireModule(SolutionLogicTree.class);
        ret.archive = archive;
        if (logicTree != null) {
            ret.setLogicTree(logicTree);
        }
        return ret;
    }

    public FaultSystemSolution calcBranchAveraged() throws IOException {
        BranchAverageSolutionCreator baCreator = new BranchAverageSolutionCreator(this.getLogicTree().getWeightProvider());
        for (LogicTreeBranch branch : this.getLogicTree().getBranches()) {
            FaultSystemSolution sol = this.forBranch(branch);
            baCreator.addSolution(sol, branch);
        }
        return baCreator.build();
    }

    @Override
    public Class<? extends ArchivableModule> getLoadingClass() {
        return SolutionLogicTree.class;
    }

    protected void writeREADMEToArchive(ArchiveOutput output) throws IOException {
        FileBackedModule.initEntry(output, null, "README");
        OutputStreamWriter writer = new OutputStreamWriter(output.getOutputStream());
        if (this.verbose) {
            System.out.println("Writing README at root");
        }
        BufferedWriter readme = new BufferedWriter(writer);
        readme.write("This is an OpenSHA Fault System Solution Logic Tree zip file.\n\n");
        readme.write("The file format is described in detail at https://opensha.org/Modular-Fault-System-Solution\n\n");
        readme.write("Unlike a regular Fault System Solution, this archive contains information for multiple solutions across multiple logic tree branches. Individual files that make up a solution are often only affected by some logic tree branching levels. For example, fault section data ('fault_sections.geojson') is often affected by fault and deformation model branching levels, but neither scaling relationships nor rate model branches. We store information efficiently for each branch by not duplicating those files that are constant across multiple branches.\n\n");
        readme.write("All relevant files are stored in the 'solution_logic_tree' directory. Solution and rupture set files will be stored in branch-specific subdirectories, and information on the logic tree branches available and their file mapping structure are available in the following files:\n\n");
        readme.write(" - solution_logic_tree/logic_tree.json: Logic Tree JSON file listing all logic tree branches, weights, and details of the branch levels.\n");
        readme.write(" - solution_logic_tree/logic_tree_mappings.json: File name mappings and weights for each logic tree branch. This file is not used by OpenSHA, but is written to help external users quickly identify the location of each solution or rupture set file for individual logic tree branches.\n");
        readme.write(" - solution_logic_tree/solution_processor.json: This file format does not support all optional modules that can be attached to a solution or rupture set. Instead, a solution processor class in OpenSHA can be used to provide additional modules as a function of logic tree branch. This file, if present, gives the class name in OpenSHA of that processor.\n");
        readme.flush();
        writer.flush();
        output.closeEntry();
    }

    @Override
    public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
        super.writeToArchive(output, entryPrefix);
        if (this.processor != null) {
            SolutionLogicTree.writeProcessorJSON(output, this.buildPrefix(entryPrefix), this.processor);
        }
        if (this.writeREADME) {
            this.writeREADMEToArchive(output);
        }
    }

    private static void writeProcessorJSON(ArchiveOutput output, String prefix, SolutionProcessor processor) throws IOException {
        try {
            Preconditions.checkNotNull(processor.getClass().getDeclaredConstructor(new Class[0]));
        }
        catch (Throwable t) {
            System.err.println("WARNING: Loading class for solution logic tree processor doesn't contain ano-arg constructor, loading from a zip file will fail: " + processor.getClass().getName());
        }
        FileBackedModule.initEntry(output, prefix, PROCESSOR_FILE_NAME);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output.getOutputStream()));
        gson.toJson((Object)processor.getClass().getName(), String.class, (Appendable)writer);
        writer.flush();
        output.closeEntry();
    }

    @Override
    public void initFromArchive(ArchiveInput input, String entryPrefix) throws IOException {
        super.initFromArchive(input, entryPrefix);
        String outPrefix = this.buildPrefix(entryPrefix);
        if (FileBackedModule.hasEntry(input, outPrefix, PROCESSOR_FILE_NAME)) {
            Constructor<?> constructor;
            Class<?> processorClass;
            Class<?> clazz;
            BufferedInputStream is = FileBackedModule.getInputStream(input, outPrefix, PROCESSOR_FILE_NAME);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            InputStreamReader reader = new InputStreamReader(is);
            String className = (String)gson.fromJson((Reader)reader, String.class);
            try {
                clazz = Class.forName(className);
            }
            catch (Exception e) {
                if (className.endsWith("$UCERF3_SolutionProcessor")) {
                    System.err.println("WARNING: found reference to previous oudated solution processor, changing to new class");
                    this.processor = new U3InversionConfigFactory.UCERF3_SolutionProcessor();
                    return;
                }
                System.err.println("WARNING: Skipping solution processor', couldn't locate class: " + className);
                return;
            }
            try {
                processorClass = clazz;
            }
            catch (Exception e) {
                System.err.println("WARNING: cannot load solution processor: " + e.getMessage());
                return;
            }
            try {
                constructor = processorClass.getDeclaredConstructor(new Class[0]);
            }
            catch (Exception e) {
                System.err.println("WARNING: cannot load solution processor as the loading class doesn't have a no-arg constructor: " + clazz.getName());
                return;
            }
            try {
                constructor.setAccessible(true);
            }
            catch (Exception e) {
                System.err.println("WANRING: couldn't make constructor accessible, loading will likely fail: " + e.getMessage());
                return;
            }
            try {
                if (this.verbose) {
                    System.out.println("Building instance: " + processorClass.getName());
                }
                this.processor = (SolutionProcessor)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Error loading solution processor, skipping.");
            }
        }
    }

    public static void simplify(SolutionLogicTree slt, File outputFile) throws IOException {
        SolutionLogicTree.simplify(slt, outputFile, false, false);
    }

    public static void simplify(SolutionLogicTree slt, File outputFile, boolean keepRupMFDs, boolean updateBuildInfo) throws IOException {
        UnaryOperator reprocessor = sol -> SolModuleStripper.stripModules(sol, 5.0, keepRupMFDs, false);
        SolutionLogicTree.reprocess(slt, outputFile, reprocessor, updateBuildInfo, false);
    }

    public static void reprocess(SolutionLogicTree slt, File outputFile, UnaryOperator<FaultSystemSolution> reprocessor, boolean updateBuildInfo, boolean processModules) throws IOException {
        boolean hasBranchSpecificGridded;
        final LogicTree<?> tree = slt.getLogicTree();
        ArchiveInput directCopyInput = slt.getArchiveInput();
        if (directCopyInput instanceof ArchiveInput.FileBacked && !(directCopyInput instanceof ArchiveInput.ApacheZipFileInput)) {
            directCopyInput = new ArchiveInput.ApacheZipFileInput(((ArchiveInput.FileBacked)directCopyInput).getInputFile());
        }
        boolean directCopyGridded = false;
        if (slt.constantGridProv == null && slt.forBranch(tree.getBranch(0), false).hasModule(GridSourceProvider.class)) {
            hasBranchSpecificGridded = true;
            try {
                ArchiveInput input = slt.getArchiveInput();
                if (input instanceof ArchiveInput.FileBacked && !(input instanceof ArchiveInput.ApacheZipFileInput)) {
                    input = new ArchiveInput.ApacheZipFileInput(((ArchiveInput.FileBacked)input).getInputFile());
                }
                System.out.println("Will directly copy gridded seismicity data");
                directCopyInput = input;
                directCopyGridded = true;
            }
            catch (Exception e) {
                System.out.println("Will load and write gridded seismicity data (if applicable): " + e.getMessage());
            }
        } else {
            hasBranchSpecificGridded = false;
        }
        final FileBuilder builder = new FileBuilder(slt.getProcessor(), ArchiveOutput.getDefaultOutput(outputFile, directCopyInput));
        if (slt.constantGridProv != null) {
            builder.setConstantGridProv(slt.constantGridProv);
        }
        if (hasBranchSpecificGridded) {
            if (directCopyInput == null) {
                builder.setSerializeGridded(true);
            } else {
                builder.setDirectCopyGriddedFrom(directCopyInput);
            }
        } else {
            builder.setSerializeGridded(false);
        }
        if (directCopyInput != null) {
            builder.setDirectCopySource(directCopyInput);
        }
        builder.setWeightProv(tree.getWeightProvider());
        if (!updateBuildInfo && slt.archive != null) {
            builder.setBuildInfo(slt.archive.getModule(BuildInfoModule.class));
        }
        boolean prevVerbose = ModuleContainer.VERBOSE_DEFAULT;
        final Stopwatch totalWatch = Stopwatch.createStarted();
        final Stopwatch blockingWriteWatch = Stopwatch.createUnstarted();
        ModuleContainer.VERBOSE_DEFAULT = false;
        CompletableFuture<Void> writeFuture = null;
        final DecimalFormat pDF = new DecimalFormat("0.0%");
        final DecimalFormat tDF = new DecimalFormat("0.##");
        int i = 0;
        while (i < tree.size()) {
            final LogicTreeBranch<?> branch = tree.getBranch(i);
            FaultSystemSolution sol = slt.forBranch(branch, processModules);
            if (directCopyGridded) {
                sol.removeAvailableModuleInstances(GridSourceList.class);
            }
            final FaultSystemSolution outputSol = reprocessor != null ? (FaultSystemSolution)reprocessor.apply(sol) : sol;
            if (writeFuture != null) {
                blockingWriteWatch.start();
                writeFuture.join();
                blockingWriteWatch.stop();
            }
            final int myIndex = i++;
            writeFuture = CompletableFuture.runAsync(new Runnable(){

                @Override
                public void run() {
                    try {
                        String timeStr;
                        builder.solution(outputSol, branch);
                        double elapsedSecs = (double)totalWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                        double blockWritingSecs = (double)blockingWriteWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                        double estSecs = elapsedSecs * (double)tree.size() / ((double)myIndex + 1.0);
                        double estSecsRemaining = estSecs - elapsedSecs;
                        if (estSecs > 90.0) {
                            double elapsedMins = elapsedSecs / 60.0;
                            double estMins = estSecs / 60.0;
                            double estMinsRemaining = estSecsRemaining / 60.0;
                            if (estMins > 60.0) {
                                double elapsedHours = elapsedMins / 60.0;
                                double estHoursRemaining = estMinsRemaining / 60.0;
                                timeStr = tDF.format(elapsedHours) + " h";
                                if (myIndex < tree.size() - 1) {
                                    timeStr = (String)timeStr + ", " + tDF.format(estHoursRemaining) + " h remaining";
                                }
                            } else {
                                timeStr = tDF.format(elapsedMins) + " m";
                                if (myIndex < tree.size() - 1) {
                                    timeStr = (String)timeStr + ", " + tDF.format(estMinsRemaining) + " m remaining";
                                }
                            }
                        } else {
                            timeStr = tDF.format(elapsedSecs) + " s";
                            if (myIndex < tree.size() - 1) {
                                timeStr = timeStr + ", " + tDF.format(estSecsRemaining) + " s remaining";
                            }
                        }
                        System.out.println("DONE branch " + myIndex + "/" + tree.size() + " in " + timeStr + " (" + pDF.format(blockWritingSecs / elapsedSecs) + " waiting on blocking write)");
                    }
                    catch (IOException e) {
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
            });
        }
        if (writeFuture != null) {
            blockingWriteWatch.start();
            writeFuture.join();
            blockingWriteWatch.stop();
        }
        ModuleContainer.VERBOSE_DEFAULT = prevVerbose;
        builder.close();
    }

    public static void main(String[] args) throws IOException {
        File dir = new File("/home/kevin/OpenSHA/nshm23/batch_inversions/2024_02_02-nshm23_branches-WUS_FM_v3");
        File inSLTfile = new File(dir, "results.zip");
        File outSLTfile = new File("/tmp/results_simplified.zip");
        SolutionLogicTree inSLT = SolutionLogicTree.load(inSLTfile);
        SolutionLogicTree.simplify(inSLT, outSLTfile);
    }

    public static interface SolutionProcessor {
        public FaultSystemRupSet processRupSet(FaultSystemRupSet var1, LogicTreeBranch<?> var2);

        public FaultSystemSolution processSolution(FaultSystemSolution var1, LogicTreeBranch<?> var2);
    }

    public static class FileBuilder
    extends Builder {
        private static final String DNAME = ClassUtils.getClassNameWithoutPackage(FileBuilder.class);
        private static final boolean D = false;
        private SolutionProcessor processor;
        private ModuleArchive<OpenSHA_Module> archive;
        private BuildInfoModule buildInfo;
        private CompletableFuture<Void> startModuleWriteFuture = null;
        private CompletableFuture<Void> endModuleWriteFuture = null;
        private CompletableFuture<Void> endArchiveWriteFuture = null;
        private Thread archiveWriteThread;
        private ArchiveOutput output;
        private String entryPrefix;
        private SolutionLogicTree solTree;
        private HashSet<String> writtenFiles = new HashSet();
        private BranchWeightProvider weightProv;
        private List<LogicTreeBranch<LogicTreeNode>> branches = new ArrayList<LogicTreeBranch<LogicTreeNode>>();
        private List<Map<String, String>> branchMappings = new ArrayList<Map<String, String>>();
        private List<LogicTreeLevel<? extends LogicTreeNode>> levels = null;
        private boolean serializeGridded = true;
        private ArchiveInput directCopyGriddedFrom;
        private GridSourceProvider constantGridProv;
        private ArchiveInput directCopySource = null;

        public FileBuilder(File outputFile) throws IOException {
            this(null, outputFile);
        }

        public FileBuilder(SolutionProcessor processor, File outputFile) throws IOException {
            this(processor, ArchiveOutput.getDefaultOutput(outputFile));
        }

        public FileBuilder(ArchiveOutput output) throws IOException {
            this(null, output);
        }

        public FileBuilder(SolutionProcessor processor, ArchiveOutput output) throws IOException {
            this(processor, output, "");
        }

        public FileBuilder(SolutionProcessor processor, ArchiveOutput output, String entryPrefix) throws IOException {
            this.processor = processor;
            this.output = output;
            this.archive = new ModuleArchive();
        }

        public synchronized void sortLogicTreeBranchesToMatchTree(LogicTree<?> tree) {
            final HashMap branchIndexes = new HashMap(tree.size());
            for (int i = 0; i < tree.size(); ++i) {
                branchIndexes.put(tree.getBranch(i), i);
            }
            this.sortLogicTreeBranches(new Comparator<LogicTreeBranch<LogicTreeNode>>(){
                final /* synthetic */ FileBuilder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(LogicTreeBranch<LogicTreeNode> o1, LogicTreeBranch<LogicTreeNode> o2) {
                    int index1 = (Integer)branchIndexes.get(o1);
                    int index2 = (Integer)branchIndexes.get(o2);
                    return Integer.compare(index1, index2);
                }
            });
        }

        public synchronized void sortLogicTreeBranches(Comparator<LogicTreeBranch<LogicTreeNode>> comparator) {
            ArrayList<ComparablePairing<LogicTreeBranch<LogicTreeNode>, Map<String, String>>> pairings = new ArrayList<ComparablePairing<LogicTreeBranch<LogicTreeNode>, Map<String, String>>>(this.branches.size());
            for (int i = 0; i < this.branches.size(); ++i) {
                pairings.add(new ComparablePairing<LogicTreeBranch<LogicTreeNode>, Map<String, String>>(this.branches.get(i), this.branchMappings.get(i), comparator));
            }
            Collections.sort(pairings);
            ArrayList<LogicTreeBranch<LogicTreeNode>> branches = new ArrayList<LogicTreeBranch<LogicTreeNode>>(pairings.size());
            ArrayList<Map<String, String>> branchMappings = new ArrayList<Map<String, String>>(pairings.size());
            for (ComparablePairing comparablePairing : pairings) {
                branches.add((LogicTreeBranch)comparablePairing.getComparable());
                branchMappings.add((Map)comparablePairing.getData());
            }
            this.branches = branches;
            this.branchMappings = branchMappings;
        }

        private void debug(String message) {
            System.out.println(DNAME + "[" + Thread.currentThread().getName() + "]: " + message);
        }

        public void setSerializeGridded(boolean serializeGridded) {
            this.serializeGridded = serializeGridded;
            if (serializeGridded) {
                Preconditions.checkState((this.directCopyGriddedFrom == null ? 1 : 0) != 0, (Object)"Cannot set serialize gridded to true when directCopyGriddedFrom != null");
            }
            if (this.solTree != null) {
                this.solTree.setSerializeGridded(serializeGridded);
            }
        }

        public void setConstantGridProv(GridSourceProvider constantGridProv) {
            this.constantGridProv = constantGridProv;
        }

        public void setDirectCopyGriddedFrom(ArchiveInput input) {
            if (input != null) {
                this.serializeGridded = false;
            }
            this.directCopyGriddedFrom = input;
        }

        public void setDirectCopySource(ArchiveInput input) {
            this.directCopySource = input;
        }

        public void setBuildInfo(BuildInfoModule buildInfo) {
            this.buildInfo = buildInfo;
        }

        private void initSolTree(LogicTreeBranch<?> branch) {
            if (this.levels == null) {
                this.levels = new ArrayList<LogicTreeLevel<? extends LogicTreeNode>>();
                for (LogicTreeLevel level : branch.getLevels()) {
                    this.levels.add(level);
                }
            }
            this.startModuleWriteFuture = new CompletableFuture();
            this.endModuleWriteFuture = new CompletableFuture();
            this.solTree = new SolutionLogicTree(){

                @Override
                public void writeToArchive(ArchiveOutput output, String entryPrefix) throws IOException {
                    output = output;
                    entryPrefix = entryPrefix;
                    startModuleWriteFuture.complete(null);
                    try {
                        endModuleWriteFuture.get();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
            };
            this.solTree.setLogicTreeLevels(this.levels);
            this.solTree.setSerializeGridded(this.serializeGridded);
            this.solTree.setConstantGridProv(this.constantGridProv);
            this.solTree.setDirectCopySource(this.directCopySource);
            this.archive.addModule(this.solTree);
            if (this.buildInfo == null) {
                try {
                    this.archive.addModule(BuildInfoModule.detect());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                this.archive.addModule(this.buildInfo);
            }
            this.endArchiveWriteFuture = new CompletableFuture();
            this.archiveWriteThread = new Thread("slt-file-builder-archive-write"){

                @Override
                public void run() {
                    try {
                        archive.write(output);
                        endArchiveWriteFuture.complete(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw ExceptionUtils.asRuntimeException(e);
                    }
                }
            };
            this.archiveWriteThread.start();
        }

        private void waitUntilWriting() {
            try {
                this.startModuleWriteFuture.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw ExceptionUtils.asRuntimeException(e);
            }
            Preconditions.checkNotNull((Object)this.output);
            Preconditions.checkNotNull((Object)this.entryPrefix);
        }

        @Override
        public synchronized void solution(FaultSystemSolution sol, LogicTreeBranch<?> branch) throws IOException {
            ImmutableList<LogicTreeLevel<?>> myLevels;
            if (this.solTree == null) {
                this.initSolTree(branch);
            }
            Preconditions.checkState(((myLevels = branch.getLevels()).size() == this.levels.size() ? 1 : 0) != 0, (String)"Branch %s has a different number of levels than the first branch", branch);
            for (int i = 0; i < myLevels.size(); ++i) {
                Preconditions.checkState((boolean)((LogicTreeLevel)myLevels.get(i)).equals(this.levels.get(i)), (String)"Branch %s has a different level at position %s than the first branch", (int)i, branch);
            }
            this.branches.add(branch);
            this.waitUntilWriting();
            String outPrefix = this.solTree.buildPrefix(this.entryPrefix);
            HashMap<String, String> mappings = new HashMap<String, String>();
            mappings.putAll(this.solTree.writeBranchFilesToArchive(this.output, outPrefix, branch, this.writtenFiles, sol));
            if (this.directCopyGriddedFrom != null) {
                Preconditions.checkState((!this.serializeGridded ? 1 : 0) != 0);
                mappings.putAll(this.solTree.directCopyGridProvToArchive(this.directCopyGriddedFrom, this.output, outPrefix, branch, this.writtenFiles));
            }
            this.branchMappings.add(mappings);
        }

        public void setWeightProv(BranchWeightProvider weightProv) {
            this.weightProv = weightProv;
        }

        public synchronized void close() throws IOException {
            if (this.output != null) {
                LogicTree<LogicTreeNode> tree = LogicTree.fromExisting(this.levels, this.branches);
                if (this.weightProv != null) {
                    tree.setWeightProvider(this.weightProv);
                }
                this.solTree.writeLogicTreeToArchive(this.output, this.solTree.buildPrefix(this.entryPrefix), tree);
                if (this.processor != null) {
                    SolutionLogicTree.writeProcessorJSON(this.output, this.solTree.buildPrefix(this.entryPrefix), this.processor);
                }
                this.solTree.writeLogicTreeMappingsToArchive(this.output, this.solTree.buildPrefix(this.entryPrefix), tree, this.branchMappings);
                this.solTree.writeREADMEToArchive(this.output);
                this.entryPrefix = null;
                this.solTree = null;
                this.endModuleWriteFuture.complete(null);
                try {
                    this.endArchiveWriteFuture.get();
                    this.archiveWriteThread.join();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }

        @Override
        public SolutionLogicTree build() throws IOException {
            this.close();
            return new ModuleArchive<SolutionLogicTree>(this.output.getCompletedInput(), SolutionLogicTree.class).requireModule(SolutionLogicTree.class);
        }

        public synchronized void copyDataFrom(ArchiveInput input, List<LogicTreeBranch<?>> branches) throws IOException {
            if (this.solTree == null) {
                this.initSolTree(branches.get(0));
            }
            this.waitUntilWriting();
            String processorName = this.solTree.getSubDirectoryName() + "/solution_processor.json";
            String treeName = this.solTree.getSubDirectoryName() + "/solution_processor.json";
            String modulesName = "modules.json";
            for (String name : input.getEntries()) {
                if (this.writtenFiles.contains(name) || name.equals(processorName) || name.equals(treeName) || name.endsWith(modulesName)) continue;
                System.out.println("Copying over file from previous archive: " + name);
                this.output.transferFrom(input, name);
                this.writtenFiles.add(name);
            }
            branches.addAll(branches);
        }

        public synchronized void writeGridProvToArchive(GridSourceProvider prov, LogicTreeBranch<?> branch) throws IOException {
            this.waitUntilWriting();
            String prefix = this.solTree.buildPrefix(this.entryPrefix);
            this.solTree.writeGridProvToArchive(prov, this.output, prefix, branch, this.writtenFiles);
        }
    }

    public static class ResultsDirReader
    extends AbstractExternalFetcher {
        private File resultsDir;
        private File prevSolFile;
        private FaultSystemSolution prevSol;
        private double[] prevRates;
        private FaultSystemRupSet.RuptureProperties prevProps;
        private GridSourceProvider prevGridProv;

        public ResultsDirReader(File resultsDir, LogicTree<?> logicTree) {
            this(resultsDir, logicTree, null);
        }

        public ResultsDirReader(File resultsDir, LogicTree<?> logicTree, SolutionProcessor processor) {
            super(processor, logicTree);
            this.resultsDir = resultsDir;
        }

        private File getBranchSubDir(LogicTreeBranch<?> branch, List<LogicTreeNode> gridOnlyNodes, List<LogicTreeLevel<? extends LogicTreeNode>> gridOnlyLevels) {
            File subDir = branch.getBranchDirectory(this.resultsDir, false);
            if (!subDir.exists()) {
                LogicTreeBranch rateBranch;
                File testSubDir;
                ArrayList levelsAffecting = new ArrayList();
                ArrayList nodesAffecting = new ArrayList();
                for (int i = 0; i < branch.size(); ++i) {
                    Object node = branch.getValue(i);
                    LogicTreeLevel<?> level = branch.getLevel(i);
                    if (level.affects("rates.csv", true)) {
                        levelsAffecting.add(level);
                        nodesAffecting.add(node);
                        continue;
                    }
                    if (!level.affects("grid_unassociated_mfds.csv", true) && !level.affects("grid_sub_seis_mfds.csv", true)) continue;
                    if (gridOnlyLevels != null) {
                        gridOnlyLevels.add(level);
                    }
                    if (gridOnlyNodes == null) continue;
                    gridOnlyNodes.add((LogicTreeNode)node);
                }
                if (nodesAffecting.size() < branch.size() && (testSubDir = new File(this.resultsDir, (rateBranch = new LogicTreeBranch(levelsAffecting, nodesAffecting)).buildFileName())).exists()) {
                    System.out.println("Not all branches affect solution, reverting to branch: " + testSubDir.getName());
                    subDir = testSubDir;
                }
            }
            Preconditions.checkState((boolean)subDir.exists(), (String)"Branch directory doesn't exist: %s", (Object)subDir.getAbsolutePath());
            return subDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FaultSystemSolution loadExternalForBranch(LogicTreeBranch<?> branch) throws IOException {
            ArrayList<LogicTreeNode> gridOnlyNodes = new ArrayList<LogicTreeNode>();
            ArrayList gridOnlyLevels = new ArrayList();
            File subDir = this.getBranchSubDir(branch, gridOnlyNodes, gridOnlyLevels);
            File solFile = new File(subDir, "solution.zip");
            Preconditions.checkState((boolean)solFile.exists(), (String)"Solution file doesn't exist: %s", (Object)solFile.getAbsolutePath());
            FaultSystemSolution sol = null;
            ResultsDirReader resultsDirReader = this;
            synchronized (resultsDirReader) {
                if (this.prevSol != null && solFile.equals(this.prevSolFile)) {
                    sol = this.prevSol;
                }
            }
            if (sol == null) {
                sol = FaultSystemSolution.load(solFile);
                resultsDirReader = this;
                synchronized (resultsDirReader) {
                    this.clearPrevSol();
                    this.prevSol = sol;
                    this.prevSolFile = solFile;
                    this.prevRates = sol.getRateForAllRups();
                    this.prevProps = new FaultSystemRupSet.RuptureProperties(sol.getRupSet());
                }
            }
            if (!sol.hasAvailableModule(GridSourceProvider.class)) {
                File gridProvsDir = new File(subDir, "grid_source_providers");
                if (!gridProvsDir.exists()) {
                    LogicTreeBranch subBranch;
                    File subRunDir;
                    ArrayList gridLevels = new ArrayList();
                    ArrayList gridNodes = new ArrayList();
                    for (int i = 0; i < branch.size(); ++i) {
                        LogicTreeLevel<?> level = branch.getLevel(i);
                        Object node = branch.getValue(i);
                        if (gridOnlyLevels.contains(level) || !GridSourceProvider.affectedByLevel(level) && !(node instanceof ScalarIMRsLogicTreeNode) && !(node instanceof ScalarIMR_ParamsLogicTreeNode)) continue;
                        gridLevels.add(level);
                        gridNodes.add(branch.getValue(i));
                    }
                    if (gridLevels.size() < branch.size() && (subRunDir = (subBranch = new LogicTreeBranch(gridLevels, gridNodes)).getBranchDirectory(this.resultsDir, false)).exists()) {
                        gridProvsDir = new File(subRunDir, "grid_source_providers");
                    }
                }
                if (gridProvsDir.exists()) {
                    File gridProvFile;
                    if (gridOnlyLevels.isEmpty()) {
                        gridProvFile = new File(gridProvsDir, "avg_grid_seis.zip");
                    } else {
                        LogicTreeBranch<LogicTreeNode> gridBranch = new LogicTreeBranch<LogicTreeNode>(gridOnlyLevels, gridOnlyNodes);
                        gridProvFile = new File(gridProvsDir, gridBranch.buildFileName() + ".zip");
                        if (gridProvFile.exists()) {
                            FaultSystemSolution copy = new FaultSystemSolution(sol.getRupSet(), sol.getRateForAllRups());
                            for (OpenSHA_Module module : sol.getModules()) {
                                copy.addModule(module);
                            }
                            sol = copy;
                        }
                    }
                    if (gridProvFile.exists()) {
                        sol.addAvailableModule((Callable<OpenSHA_Module>)new Callable<GridSourceProvider>(){
                            final /* synthetic */ ResultsDirReader this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public GridSourceProvider call() throws Exception {
                                ModuleArchive archive = new ModuleArchive(gridProvFile);
                                return archive.requireModule(GridSourceProvider.class);
                            }
                        }, GridSourceProvider.class);
                    }
                }
            }
            return sol;
        }

        private synchronized void clearPrevSol() {
            this.prevSolFile = null;
            this.prevSol = null;
            this.prevRates = null;
            this.prevProps = null;
            this.prevGridProv = null;
        }

        @Override
        public synchronized double[] loadRatesForBranch(LogicTreeBranch<?> branch) throws IOException {
            File subDir = this.getBranchSubDir(branch, null, null);
            File solFile = new File(subDir, "solution.zip");
            if (!solFile.equals(this.prevSolFile)) {
                this.clearPrevSol();
                this.prevSolFile = solFile;
            }
            if (this.prevRates != null) {
                return this.prevRates;
            }
            ArchiveInput.ZipFileInput input = new ArchiveInput.ZipFileInput(solFile);
            String ratesFile = "solution/rates.csv";
            System.out.println("\tLoading rate data from " + ratesFile);
            CSVFile<String> ratesCSV = CSV_BackedModule.loadFromArchive(input, null, ratesFile);
            double[] rates = FaultSystemSolution.loadRatesCSV(ratesCSV);
            this.prevRates = rates;
            input.close();
            return rates;
        }

        @Override
        public synchronized FaultSystemRupSet.RuptureProperties loadPropsForBranch(LogicTreeBranch<?> branch) throws IOException {
            FaultSystemRupSet.RuptureProperties props;
            File subDir = this.getBranchSubDir(branch, null, null);
            File solFile = new File(subDir, "solution.zip");
            if (!solFile.equals(this.prevSolFile)) {
                this.clearPrevSol();
                this.prevSolFile = solFile;
            }
            if (this.prevProps != null) {
                return this.prevProps;
            }
            ArchiveInput.ZipFileInput input = new ArchiveInput.ZipFileInput(solFile);
            String propsFile = "ruptures/properties.csv";
            System.out.println("\tLoading rupture properties from " + propsFile);
            CSVFile<String> rupPropsCSV = CSV_BackedModule.loadFromArchive(input, null, propsFile);
            this.prevProps = props = new FaultSystemRupSet.RuptureProperties(rupPropsCSV);
            input.close();
            return props;
        }

        @Override
        public synchronized GridSourceProvider loadGridProvForBranch(LogicTreeBranch<?> branch) throws IOException {
            File gridProvsDir;
            ArrayList<LogicTreeNode> gridOnlyNodes = new ArrayList<LogicTreeNode>();
            ArrayList gridOnlyLevels = new ArrayList();
            File subDir = this.getBranchSubDir(branch, gridOnlyNodes, gridOnlyLevels);
            File solFile = new File(subDir, "solution.zip");
            if (gridOnlyLevels.isEmpty() && solFile.equals(this.prevSolFile)) {
                if (this.prevGridProv != null) {
                    return this.prevGridProv;
                }
                if (this.prevSol != null && this.prevSol.hasAvailableModule(GridSourceProvider.class)) {
                    return this.prevSol.getGridSourceProvider();
                }
            } else {
                this.clearPrevSol();
                this.prevSolFile = solFile;
            }
            if ((gridProvsDir = new File(subDir, "grid_source_providers")).exists()) {
                File gridProvFile;
                if (gridOnlyLevels.isEmpty()) {
                    gridProvFile = new File(gridProvsDir, "avg_grid_seis.zip");
                } else {
                    LogicTreeBranch<LogicTreeNode> gridBranch = new LogicTreeBranch<LogicTreeNode>(gridOnlyLevels, gridOnlyNodes);
                    gridProvFile = new File(gridProvsDir, gridBranch.buildFileName() + ".zip");
                }
                if (gridProvFile.exists()) {
                    ModuleArchive archive = new ModuleArchive(gridProvFile);
                    this.prevGridProv = archive.requireModule(GridSourceProvider.class);
                    return this.prevGridProv;
                }
            }
            return null;
        }
    }

    protected static abstract class Builder {
        protected Builder() {
        }

        public abstract void solution(FaultSystemSolution var1, LogicTreeBranch<?> var2) throws IOException;

        public abstract SolutionLogicTree build() throws IOException;
    }

    public static class SubsetSolutionLogicTree
    extends AbstractExternalFetcher {
        private SolutionLogicTree slt;

        public SubsetSolutionLogicTree(SolutionLogicTree slt, LogicTree<?> subsetTree) {
            super(slt.getProcessor(), subsetTree);
            this.slt = slt;
            this.setArchiveInput(slt.getArchiveInput());
        }

        @Override
        protected FaultSystemSolution loadExternalForBranch(LogicTreeBranch<?> branch) throws IOException {
            return this.slt.forBranch(branch, false);
        }

        @Override
        public synchronized double[] loadRatesForBranch(LogicTreeBranch<?> branch) throws IOException {
            return this.slt.loadRatesForBranch(branch);
        }

        @Override
        public synchronized FaultSystemRupSet.RuptureProperties loadPropsForBranch(LogicTreeBranch<?> branch) throws IOException {
            return this.slt.loadPropsForBranch(branch);
        }

        @Override
        public synchronized GridSourceProvider loadGridProvForBranch(LogicTreeBranch<?> branch) throws IOException {
            return this.slt.loadGridProvForBranch(branch);
        }
    }

    public static abstract class AbstractExternalFetcher
    extends SolutionLogicTree {
        protected AbstractExternalFetcher(SolutionProcessor processor, LogicTree<?> logicTree) {
            super(processor, null, null, logicTree);
        }

        protected abstract FaultSystemSolution loadExternalForBranch(LogicTreeBranch<?> var1) throws IOException;

        @Override
        public synchronized FaultSystemSolution forBranch(LogicTreeBranch<?> branch, boolean process) throws IOException {
            FaultSystemSolution external = this.loadExternalForBranch(branch);
            if (external != null) {
                SolutionProcessor processor;
                if (process && (processor = this.getProcessor()) != null) {
                    FaultSystemSolution sol;
                    FaultSystemRupSet origRupSet = external.getRupSet();
                    FaultSystemRupSet rupSet = processor.processRupSet(origRupSet, branch);
                    if (rupSet != origRupSet) {
                        sol = new FaultSystemSolution(rupSet, external.getRateForAllRups());
                        for (OpenSHA_Module module : external.getModules()) {
                            try {
                                sol.addModule(module);
                            }
                            catch (Exception e) {
                                System.err.println("WARNING: couldn't copy module to updated solution with processed rupture set: " + e.getMessage());
                            }
                        }
                    } else {
                        sol = external;
                    }
                    return processor.processSolution(sol, branch);
                }
                return external;
            }
            return super.forBranch(branch, process);
        }
    }

    public static class InMemory
    extends AbstractExternalFetcher {
        private Map<LogicTreeBranch<?>, Integer> branchIndexMap;
        private List<FaultSystemSolution> solutions;

        public InMemory(FaultSystemSolution sol, LogicTreeBranch<?> branch) {
            super(null, InMemory.singleSolTree(branch));
            this.init(List.of(sol), this.getLogicTree());
        }

        private static LogicTree<?> singleSolTree(LogicTreeBranch<?> branch) {
            if (branch == null) {
                return null;
            }
            ArrayList levels = new ArrayList();
            ArrayList nodes = new ArrayList();
            for (int i = 0; i < branch.size(); ++i) {
                levels.add(branch.getLevel(i));
                nodes.add(branch.getValue(i));
            }
            LogicTreeBranch modBranch = new LogicTreeBranch(levels, nodes);
            modBranch.setOrigBranchWeight(branch.getOrigBranchWeight());
            return LogicTree.fromExisting(levels, List.of(modBranch));
        }

        public InMemory(List<FaultSystemSolution> solutions, LogicTree<?> tree) {
            super(null, tree);
            this.init(solutions, tree);
        }

        private void init(List<FaultSystemSolution> solutions, LogicTree<?> tree) {
            this.solutions = solutions;
            this.branchIndexMap = new HashMap(solutions.size());
            if (tree == null) {
                Preconditions.checkState((solutions.size() == 1 ? 1 : 0) != 0);
                this.branchIndexMap.put(null, 0);
            } else {
                Preconditions.checkState((solutions.size() == tree.size() ? 1 : 0) != 0);
                for (int i = 0; i < tree.size(); ++i) {
                    this.branchIndexMap.put(tree.getBranch(i), i);
                }
            }
        }

        @Override
        protected FaultSystemSolution loadExternalForBranch(LogicTreeBranch<?> branch) throws IOException {
            Integer index = this.branchIndexMap.get(branch);
            Preconditions.checkNotNull((Object)index, (String)"Unexpected branch: %s", branch);
            return this.solutions.get(index);
        }

        @Override
        public synchronized double[] loadRatesForBranch(LogicTreeBranch<?> branch) throws IOException {
            return this.loadExternalForBranch(branch).getRateForAllRups();
        }

        @Override
        public synchronized FaultSystemRupSet.RuptureProperties loadPropsForBranch(LogicTreeBranch<?> branch) throws IOException {
            FaultSystemRupSet rupSet = this.loadExternalForBranch(branch).getRupSet();
            return new FaultSystemRupSet.RuptureProperties(rupSet);
        }

        @Override
        public synchronized GridSourceProvider loadGridProvForBranch(LogicTreeBranch<?> branch) throws IOException {
            return this.loadExternalForBranch(branch).getGridSourceProvider();
        }
    }

    public static class UCERF3
    extends AbstractExternalFetcher {
        private U3FaultSystemSolutionFetcher oldFetcher;
        private Map<Integer, List<LastEventData>> lastEventData = null;

        private UCERF3() {
            super(new U3InversionConfigFactory.UCERF3_SolutionProcessor(), null);
        }

        public UCERF3(LogicTree<?> logicTree) {
            super(new U3InversionConfigFactory.UCERF3_SolutionProcessor(), logicTree);
        }

        public UCERF3(U3FaultSystemSolutionFetcher oldFetcher) {
            super(new U3InversionConfigFactory.UCERF3_SolutionProcessor(), LogicTree.fromExisting(U3LogicTreeBranch.getLogicTreeLevels(), oldFetcher.getBranches()));
            this.oldFetcher = oldFetcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected FaultSystemSolution loadExternalForBranch(LogicTreeBranch<?> branch) throws IOException {
            if (this.oldFetcher != null) {
                UCERF3 uCERF3 = this;
                synchronized (uCERF3) {
                    if (this.lastEventData == null) {
                        this.lastEventData = LastEventData.load();
                    }
                }
                InversionFaultSystemSolution sol = this.oldFetcher.getSolution(SolutionLogicTree.asU3Branch(branch));
                LastEventData.populateSubSects(((FaultSystemSolution)sol).getRupSet().getFaultSectionDataList(), this.lastEventData);
                return sol;
            }
            return null;
        }
    }
}

