/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.helpers.CSV_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;

public class SubSeismoOnFaultMFDs
implements CSV_BackedModule,
BranchAverageableModule<SubSeismoOnFaultMFDs> {
    private ImmutableList<IncrementalMagFreqDist> subSeismoOnFaultMFDs;
    public static final String DATA_FILE_NAME = "sub_seismo_on_fault_mfds.csv";

    private SubSeismoOnFaultMFDs() {
    }

    public SubSeismoOnFaultMFDs(List<? extends IncrementalMagFreqDist> subSeismoOnFaultMFDs) {
        this.subSeismoOnFaultMFDs = ImmutableList.copyOf(subSeismoOnFaultMFDs);
    }

    public IncrementalMagFreqDist get(int sectIndex) {
        return (IncrementalMagFreqDist)this.subSeismoOnFaultMFDs.get(sectIndex);
    }

    public int size() {
        return this.subSeismoOnFaultMFDs.size();
    }

    public ImmutableList<IncrementalMagFreqDist> getAll() {
        return this.subSeismoOnFaultMFDs;
    }

    public SummedMagFreqDist getTotal() {
        SummedMagFreqDist sum = null;
        for (int i = 0; i < this.size(); ++i) {
            IncrementalMagFreqDist mfd = this.get(i);
            if (mfd == null) continue;
            if (sum == null) {
                sum = new SummedMagFreqDist(mfd.getMinX(), mfd.getMaxX(), mfd.size());
            }
            sum.addIncrementalMagFreqDist(mfd);
        }
        return sum;
    }

    @Override
    public String getFileName() {
        return DATA_FILE_NAME;
    }

    @Override
    public String getName() {
        return "Sub-Seismogenic On-Fault MFDs";
    }

    @Override
    public CSVFile<?> getCSV() {
        Preconditions.checkNotNull(this.subSeismoOnFaultMFDs);
        CSVFile csv = new CSVFile(false);
        IncrementalMagFreqDist maxMagFunc = null;
        for (IncrementalMagFreqDist mfd : this.subSeismoOnFaultMFDs) {
            if (maxMagFunc == null) {
                maxMagFunc = mfd;
                continue;
            }
            Preconditions.checkState(((float)mfd.getMinX() == (float)maxMagFunc.getMinX() ? 1 : 0) != 0);
            Preconditions.checkState(((float)mfd.getDelta() == (float)maxMagFunc.getDelta() ? 1 : 0) != 0);
            if (mfd.size() <= maxMagFunc.size()) continue;
            maxMagFunc = mfd;
        }
        ArrayList<Object> header = new ArrayList<Object>();
        header.add("Section Index");
        for (int i = 0; i < maxMagFunc.size(); ++i) {
            header.add("" + maxMagFunc.getX(i));
        }
        csv.addLine(header);
        for (int s = 0; s < this.subSeismoOnFaultMFDs.size(); ++s) {
            IncrementalMagFreqDist mfd = (IncrementalMagFreqDist)this.subSeismoOnFaultMFDs.get(s);
            ArrayList<CallSite> line = new ArrayList<CallSite>(mfd.size() + 1);
            line.add((CallSite)((Object)("" + s)));
            for (int i = 0; i < mfd.size(); ++i) {
                line.add((CallSite)((Object)("" + mfd.getY(i))));
            }
            csv.addLine(line);
        }
        return csv;
    }

    @Override
    public void initFromCSV(CSVFile<String> csv) {
        List<String> header = csv.getLine(0);
        double min = Double.parseDouble(header.get(1));
        double max = Double.parseDouble(header.get(header.size() - 1));
        int num = header.size() - 1;
        IncrementalMagFreqDist refMFD = new IncrementalMagFreqDist(min, max, num);
        for (int i = 0; i < num; ++i) {
            double csvX;
            double myX = refMFD.getX(i);
            Preconditions.checkState(((float)myX == (float)(csvX = Double.parseDouble(header.get(i + 1))) ? 1 : 0) != 0, (String)"Expected M=%s as value %s in the MFD x-values, got %s", (Object)Float.valueOf((float)myX), (Object)i, (Object)Float.valueOf((float)csvX));
        }
        ArrayList<IncrementalMagFreqDist> mfds = new ArrayList<IncrementalMagFreqDist>();
        for (int row = 1; row < csv.getNumRows(); ++row) {
            List<String> line = csv.getLine(row);
            Preconditions.checkState((Integer.parseInt(line.get(0)) == row - 1 ? 1 : 0) != 0, (Object)"File out of order or not 0-based");
            int myNum = 0;
            for (int i = 1; i < line.size() && !line.get(i).isBlank(); ++i) {
                ++myNum;
            }
            IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(min, refMFD.getX(myNum - 1), myNum);
            for (int i = 0; i < mfd.size(); ++i) {
                Preconditions.checkState(((float)mfd.getX(i) == (float)refMFD.getX(i) ? 1 : 0) != 0);
                mfd.set(i, Double.parseDouble(line.get(i + 1)));
            }
            mfds.add(mfd);
        }
        this.subSeismoOnFaultMFDs = ImmutableList.copyOf(mfds);
    }

    public static SubSeismoOnFaultMFDs fromCSV(CSVFile<String> csv) {
        SubSeismoOnFaultMFDs mfds = new SubSeismoOnFaultMFDs();
        mfds.initFromCSV(csv);
        return mfds;
    }

    @Override
    public AverageableModule.AveragingAccumulator<SubSeismoOnFaultMFDs> averagingAccumulator() {
        return new AverageableModule.AveragingAccumulator<SubSeismoOnFaultMFDs>(){
            private List<IncrementalMagFreqDist> avgMFDs;
            private double totWeight = 0.0;

            @Override
            public void process(SubSeismoOnFaultMFDs module, double relWeight) {
                int i;
                if (this.avgMFDs == null) {
                    this.avgMFDs = new ArrayList<IncrementalMagFreqDist>();
                    for (i = 0; i < module.size(); ++i) {
                        this.avgMFDs.add(null);
                    }
                }
                for (i = 0; i < module.size(); ++i) {
                    IncrementalMagFreqDist avg = this.avgMFDs.get(i);
                    IncrementalMagFreqDist mine = module.get(i);
                    if (mine == null) continue;
                    if (avg == null) {
                        avg = new IncrementalMagFreqDist(mine.getMinX(), mine.size(), mine.getDelta());
                        this.avgMFDs.set(i, avg);
                    }
                    Preconditions.checkState(((float)mine.getMinX() == (float)avg.getMinX() ? 1 : 0) != 0);
                    Preconditions.checkState(((float)mine.getDelta() == (float)avg.getDelta() ? 1 : 0) != 0);
                    if (mine.size() > avg.size()) {
                        IncrementalMagFreqDist larger = new IncrementalMagFreqDist(mine.getMinX(), mine.size(), mine.getDelta());
                        for (int j = 0; j < avg.size(); ++j) {
                            larger.set(j, avg.getY(j));
                        }
                        avg = larger;
                        this.avgMFDs.set(i, larger);
                    }
                    for (int j = 0; j < mine.size(); ++j) {
                        avg.add(j, mine.getY(j) * relWeight);
                    }
                }
                this.totWeight += relWeight;
            }

            @Override
            public SubSeismoOnFaultMFDs getAverage() {
                if (this.totWeight != 1.0) {
                    double scale = 1.0 / this.totWeight;
                    for (IncrementalMagFreqDist mfd : this.avgMFDs) {
                        if (mfd == null) continue;
                        mfd.scale(scale);
                    }
                }
                return new SubSeismoOnFaultMFDs(this.avgMFDs);
            }

            @Override
            public Class<SubSeismoOnFaultMFDs> getType() {
                return SubSeismoOnFaultMFDs.class;
            }
        };
    }
}

