/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jfree.data.Range;
import org.opensha.commons.data.Named;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;

public abstract class AbstractRupSetPlot
implements Named {
    private String subHeading = "###";
    private int numThreads = -1;
    private ReportPageGen.PlotLevel plotLevel;
    protected static DecimalFormat optionalDigitDF = new DecimalFormat("0.##");
    protected static DecimalFormat twoDigits = new DecimalFormat("0.00");
    protected static DecimalFormat normProbDF = new DecimalFormat("0.000");
    protected static DecimalFormat expProbDF = new DecimalFormat("0.00E0");
    protected static DecimalFormat percentDF = new DecimalFormat("0.00%");
    protected static DecimalFormat countDF = new DecimalFormat("#");
    protected static DecimalFormat riDF = new DecimalFormat("#.##");
    protected static final String na = "_(N/A)_";
    protected static final Color MAIN_COLOR;
    protected static final Color COMP_COLOR;
    protected static final Color COMMON_COLOR;

    public void writePlot(FaultSystemRupSet rupSet, FaultSystemSolution sol, String name, File outputDir) throws IOException {
        File resourcesDir = new File(outputDir, "resources");
        Preconditions.checkState((resourcesDir.exists() || resourcesDir.mkdir() ? 1 : 0) != 0);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# " + this.getName());
        String topLink = MarkdownUtils.getAnchorName(this.getName());
        lines.add("");
        lines.addAll(this.plot(rupSet, sol, name, resourcesDir, resourcesDir.getName(), topLink));
        MarkdownUtils.writeReadmeAndHTML(lines, outputDir);
    }

    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, String name, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        RupSetMetadata meta = new RupSetMetadata(name, rupSet, sol);
        ReportPageGen.attachDefaultModules(meta, FaultSysTools.getCacheDir(), ReportPageGen.DEFAULT_MAX_DIST);
        return this.plot(rupSet, sol, new ReportMetadata(meta), resourcesDir, relPathToResources, topLink);
    }

    protected String getSubHeading() {
        return this.subHeading;
    }

    public void setSubHeading(String subHeading) {
        this.subHeading = subHeading;
    }

    public synchronized int getNumThreads() {
        if (this.numThreads < 0) {
            this.numThreads = FaultSysTools.defaultNumThreads();
        }
        return this.numThreads;
    }

    public synchronized void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public void setPlotLevel(ReportPageGen.PlotLevel plotLevel) {
        this.plotLevel = plotLevel;
    }

    public ReportPageGen.PlotLevel getPlotLevel() {
        return this.plotLevel;
    }

    public abstract List<String> plot(FaultSystemRupSet var1, FaultSystemSolution var2, ReportMetadata var3, File var4, String var5, String var6) throws IOException;

    public List<String> getSummary(ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) {
        return null;
    }

    public abstract Collection<Class<? extends OpenSHA_Module>> getRequiredModules();

    protected static String getProbStr(double prob) {
        return AbstractRupSetPlot.getProbStr(prob, false);
    }

    protected static String getProbStr(double prob, boolean includePercent) {
        Object ret = prob < 0.01 && prob > 0.0 ? expProbDF.format(prob) : normProbDF.format(prob);
        if (includePercent) {
            ret = (String)ret + " (" + percentDF.format(prob) + ")";
        }
        return ret;
    }

    protected static String getTruncatedTitle(String title) {
        if (title != null && title.length() > 30) {
            return title.substring(0, 29).trim() + "\u2026";
        }
        return title;
    }

    protected static String getFileSafe(String name) {
        return FileNameUtils.simplify(name);
    }

    protected static Range calcEncompassingLog10Range(double min, double max) {
        double logMax;
        Preconditions.checkState((min > 0.0 ? 1 : 0) != 0, (String)"Min must be positive for log plot! %s", (Object)min);
        Preconditions.checkState((min < max ? 1 : 0) != 0, (String)"Min must be < max: %s >= %s", (Object)min, (Object)max);
        double logMin = Math.floor(Math.log10(min));
        if (Math.log10(min) - logMin > 0.8) {
            logMin += 0.8;
        }
        if ((logMax = Math.ceil(Math.log10(max))) - Math.log10(max) > 0.8) {
            logMax -= 0.8;
        }
        return new Range(Math.pow(10.0, logMin), Math.pow(10.0, logMax));
    }

    static {
        countDF.setGroupingUsed(true);
        countDF.setGroupingSize(3);
        riDF.setGroupingUsed(true);
        riDF.setGroupingSize(3);
        MAIN_COLOR = Color.RED;
        COMP_COLOR = Color.BLUE;
        COMMON_COLOR = Color.GREEN;
    }
}

