/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RupHistogramPlots;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;

public class RupSetMetadata {
    public final String name;
    public final int numRuptures;
    public final double totalRate;
    public final int numSingleStrandRuptures;
    public final int availableConnections;
    public final int actualConnections;
    public final List<ScalarRange> scalarRanges;
    public final transient List<RupHistogramPlots.HistScalarValues> scalarValues;
    public final transient FaultSystemRupSet rupSet;
    public final transient FaultSystemSolution sol;
    public final transient HashSet<Jump> jumps;
    public final transient HashMap<Jump, Double> jumpRates;
    public final transient List<UniqueRupture> uniques;
    public final transient HashMap<Jump, List<Integer>> jumpRupsMap;

    public RupSetMetadata(String name, FaultSystemRupSet rupSet) {
        this(name, rupSet, null);
    }

    public RupSetMetadata(String name, FaultSystemSolution sol) {
        this(name, sol.getRupSet(), sol);
    }

    public RupSetMetadata(String name, FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        Preconditions.checkNotNull((Object)rupSet, (Object)"Must supply a rupture set");
        this.rupSet = rupSet;
        this.sol = sol;
        this.name = name;
        this.numRuptures = rupSet.getNumRuptures();
        this.totalRate = sol == null ? Double.NaN : sol.getTotalRateForAllFaultSystemRups();
        this.jumps = new HashSet();
        this.uniques = new ArrayList<UniqueRupture>();
        ClusterRuptures cRups = rupSet.getModule(ClusterRuptures.class);
        if (cRups == null) {
            cRups = ClusterRuptures.singleStranged(rupSet);
        }
        this.jumpRates = sol == null ? null : new HashMap();
        this.jumpRupsMap = new HashMap();
        int numSingleStrandRuptures = 0;
        for (int r = 0; r < this.numRuptures; ++r) {
            ClusterRupture rupture = cRups.get(r);
            if (rupture.singleStrand) {
                ++numSingleStrandRuptures;
            }
            this.uniques.add(rupture.unique);
            for (Jump jump : rupture.getJumpsIterable()) {
                if (jump.fromSection.getSectionId() > jump.toSection.getSectionId()) {
                    jump = jump.reverse();
                }
                this.jumps.add(jump);
                List<Integer> jumpRups = this.jumpRupsMap.get(jump);
                if (jumpRups == null) {
                    jumpRups = new ArrayList<Integer>();
                    this.jumpRupsMap.put(jump, jumpRups);
                }
                jumpRups.add(r);
                if (sol == null) continue;
                double rate = sol.getRateForRup(r);
                if (this.jumpRates.containsKey(jump)) {
                    this.jumpRates.put(jump, this.jumpRates.get(jump) + rate);
                    continue;
                }
                this.jumpRates.put(jump, rate);
            }
        }
        this.actualConnections = this.jumps.size();
        this.numSingleStrandRuptures = numSingleStrandRuptures;
        if (rupSet.hasModule(PlausibilityConfiguration.class)) {
            PlausibilityConfiguration config = rupSet.getModule(PlausibilityConfiguration.class);
            HashSet<Jump> availableJumps = new HashSet<Jump>();
            for (Jump jump : config.getConnectionStrategy().getAllPossibleJumps()) {
                if (jump.fromSection.getSectionId() > jump.toSection.getSectionId()) {
                    jump = jump.reverse();
                }
                availableJumps.add(jump);
            }
            this.availableConnections = availableJumps.size();
        } else {
            this.availableConnections = -1;
        }
        this.scalarRanges = new ArrayList<ScalarRange>();
        this.scalarValues = new ArrayList<RupHistogramPlots.HistScalarValues>();
    }

    public void addScalar(RupHistogramPlots.HistScalarValues values) {
        this.scalarRanges.add(new ScalarRange(values));
        this.scalarValues.add(values);
    }

    public static class ScalarRange {
        public final RupHistogramPlots.HistScalar scalar;
        public final double min;
        public final double max;

        public ScalarRange(RupHistogramPlots.HistScalarValues values) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (double val : values.getValues()) {
                min = Math.min(val, min);
                max = Math.max(val, max);
            }
            this.min = min;
            this.max = max;
            this.scalar = values.getScalar();
        }
    }
}

