/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.xyz.GeoDataSetMath;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.util.SolHazardMapCalc;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.ScalarIMR;

public class HazardMapPlot
extends AbstractSolutionPlot {
    public static double SPACING_DEFAULT = 1.0;
    private AttenRelRef gmpeRef;
    private double spacing;
    private double[] periods;
    private static SolHazardMapCalc prevCompCalc;
    private static FaultSystemSolution prevSol;

    public HazardMapPlot() {
        this(AttenRelRef.ASK_2014, SPACING_DEFAULT, 0.0, 1.0);
    }

    public HazardMapPlot(AttenRelRef gmpeRef, double spacing, double ... periods) {
        this.gmpeRef = gmpeRef;
        this.spacing = spacing;
        this.periods = periods;
        Preconditions.checkState((periods.length > 0 ? 1 : 0) != 0);
        for (double period : periods) {
            Preconditions.checkState((period >= 0.0 ? 1 : 0) != 0, (Object)"Period must be 0 (PGA) or >0 for SA");
        }
    }

    @Override
    public String getName() {
        return "Hazard Maps";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        GriddedRegion gridReg = new GriddedRegion(meta.region, this.spacing, GriddedRegion.ANCHOR_0_0);
        int numSites = gridReg.getNodeCount();
        System.out.println("Hazard gridded region with " + numSites + " sites, " + this.periods.length + " periods");
        int numThreads = this.getNumThreads();
        SolHazardMapCalc calc = new SolHazardMapCalc(sol, (Supplier<ScalarIMR>)this.gmpeRef, gridReg, this.periods);
        ArbitrarilyDiscretizedFunc xVals = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : IMT_Info.getUSGS_SA_Function()) {
            xVals.set(pt);
        }
        xVals.set(xVals.getMinX() * 0.1, 1.0);
        xVals.set(xVals.getMinX() * 0.1, 1.0);
        calc.setXVals(xVals);
        calc.calcHazardCurves(numThreads);
        SolHazardMapCalc compCalc = null;
        if (!meta.hasComparisonSol()) return this.plot(resourcesDir, relPathToResources, topLink, gridReg, calc, compCalc);
        System.out.println("Calculating comparison hazard map...");
        Class<HazardMapPlot> clazz = HazardMapPlot.class;
        synchronized (HazardMapPlot.class) {
            if (prevCompCalc != null && prevSol == meta.comparison.sol) {
                compCalc = prevCompCalc;
            }
            // ** MonitorExit[var12_12] (shouldn't be in output)
            if (compCalc == null) {
                compCalc = new SolHazardMapCalc(meta.comparison.sol, (Supplier<ScalarIMR>)this.gmpeRef, gridReg, this.periods);
                compCalc.setXVals(xVals);
                compCalc.calcHazardCurves(numThreads);
                clazz = HazardMapPlot.class;
                synchronized (HazardMapPlot.class) {
                    prevCompCalc = compCalc;
                    prevSol = meta.comparison.sol;
                    // ** MonitorExit[var12_12] (shouldn't be in output)
                    return this.plot(resourcesDir, relPathToResources, topLink, gridReg, calc, compCalc);
                }
            } else {
                System.out.println("Reusing previous comparison calculator");
            }
            return this.plot(resourcesDir, relPathToResources, topLink, gridReg, calc, compCalc);
        }
    }

    public List<String> plot(File resourcesDir, String relPathToResources, String topLink, GriddedRegion gridReg, SolHazardMapCalc calc, SolHazardMapCalc compCalc) throws IOException {
        int numSites = gridReg.getNodeCount();
        System.out.println("Done calculating hazard maps!");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Hazard map comparisons with a resolution of " + optionalDigitDF.format(this.spacing) + " degrees (" + numSites + " sites). Hazard is computed with the " + this.gmpeRef.getShortName() + " GMPE, default site parameters, and supra-seismogenic fault sources only.");
        lines.add("");
        CPT logCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-3.0, 1.0);
        CPT logRatioCPT = GMT_CPT_Files.GMT_POLAR.instance().rescale(-1.0, 1.0);
        CPT pDiffCPT = GMT_CPT_Files.GMT_POLAR.instance().rescale(-100.0, 100.0);
        logRatioCPT.setNanColor(Color.GRAY);
        for (int p = 0; p < this.periods.length; ++p) {
            String perUnits;
            Object perLabel;
            if (this.periods[p] == -1.0) {
                perLabel = "PGV";
                perUnits = "cm/s";
            } else if (this.periods[p] == 0.0) {
                perLabel = "PGA";
                perUnits = "g";
            } else {
                Preconditions.checkState((this.periods[p] > 0.0 ? 1 : 0) != 0);
                perLabel = optionalDigitDF.format(this.periods[p]) + "s SA";
                perUnits = "g";
            }
            String perPrefix = ((String)perLabel).toLowerCase().replaceAll(" ", "_");
            Object subHeading = this.getSubHeading();
            if (this.periods.length > 1) {
                lines.add((String)subHeading + " " + (String)perLabel + " Hazard Maps");
                lines.add(topLink);
                lines.add("");
                subHeading = (String)subHeading + "#";
            }
            for (SolHazardMapCalc.ReturnPeriods rp : SolHazardMapCalc.MAP_RPS) {
                lines.add((String)subHeading + " " + (String)perLabel + ", " + rp.label + " Hazard Maps");
                lines.add(topLink);
                lines.add("");
                String prefix = "hazard_map_" + perPrefix + "_" + rp.name().toLowerCase();
                GriddedGeoDataSet xyz = calc.buildMap(this.periods[p], rp);
                GriddedGeoDataSet logXYZ = xyz.copy();
                logXYZ.log10();
                String zLabel = "Log10 " + (String)perLabel + " (" + perUnits + "), " + rp.label;
                File map = calc.plotMap(resourcesDir, prefix, logXYZ, logCPT, " ", zLabel);
                if (compCalc == null) {
                    lines.add("![Hazard Map](" + relPathToResources + "/" + map.getName() + ")");
                } else {
                    GriddedGeoDataSet compXYZ = compCalc.buildMap(this.periods[p], rp);
                    GriddedGeoDataSet compLogXYZ = compXYZ.copy();
                    compLogXYZ.log10();
                    File compMap = compCalc.plotMap(resourcesDir, prefix + "_comp", compLogXYZ, logCPT, " ", zLabel);
                    MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
                    table.addLine(MarkdownUtils.boldCentered("Primary"), MarkdownUtils.boldCentered("Comparison"));
                    table.addLine("![Hazard Map](" + relPathToResources + "/" + map.getName() + ")", "![Hazard Map](" + relPathToResources + "/" + compMap.getName() + ")");
                    table.addLine(MarkdownUtils.boldCentered("Log10 Ratio, Primary/Comparison"), MarkdownUtils.boldCentered("% Difference, 100*(Primary-Comparison)/Comparison"));
                    GriddedGeoDataSet ratioXYZ = (GriddedGeoDataSet)GeoDataSetMath.divide(xyz, compXYZ);
                    ratioXYZ.log10();
                    for (int i = 0; i < xyz.size(); ++i) {
                        if (Double.isFinite(ratioXYZ.get(i))) continue;
                        double z1 = xyz.get(i);
                        double z2 = compXYZ.get(i);
                        if ((float)z1 == 0.0f && (float)z2 == 0.0f) {
                            ratioXYZ.set(i, 0.0);
                            continue;
                        }
                        if ((float)z1 == 0.0f && (float)z2 > 0.0f) {
                            ratioXYZ.set(i, Double.NEGATIVE_INFINITY);
                            continue;
                        }
                        if ((float)z2 != 0.0f || !((float)z1 > 0.0f)) continue;
                        ratioXYZ.set(i, Double.POSITIVE_INFINITY);
                    }
                    Object ratioLabel = zLabel;
                    ratioLabel = ((String)ratioLabel).replace(" (g)", "");
                    ratioLabel = ((String)ratioLabel).replace(" (cm/s)", "");
                    ratioLabel = ((String)ratioLabel).replaceAll("Log10 ", "");
                    File ratioMap = calc.plotMap(resourcesDir, prefix + "_ratio", ratioXYZ, logRatioCPT, " ", (String)ratioLabel + ", Log10 Comparison Ratio");
                    table.initNewLine();
                    table.addColumn("![Ratio Map](" + relPathToResources + "/" + ratioMap.getName() + ")");
                    GriddedGeoDataSet pDiffXYZ = new GriddedGeoDataSet(gridReg, false);
                    for (int i = 0; i < xyz.size(); ++i) {
                        double z1 = xyz.get(i);
                        double z2 = compXYZ.get(i);
                        double val = z1 == 0.0 && z2 == 0.0 ? 0.0 : (z2 == 0.0 ? Double.POSITIVE_INFINITY : 100.0 * (z1 - z2) / z2);
                        pDiffXYZ.set(i, val);
                    }
                    Object pDiffLabel = ratioLabel;
                    File pDiffMap = calc.plotMap(resourcesDir, prefix + "_pDiff", pDiffXYZ, pDiffCPT, " ", (String)pDiffLabel + ", % Difference", true);
                    table.addColumn("![Percent Difference Map](" + relPathToResources + "/" + pDiffMap.getName() + ")");
                    table.finalizeLine();
                    table.initNewLine();
                    File scatter = HazardMapPlot.compScatterPlot(resourcesDir, prefix + "_scatter", xyz, compXYZ, zLabel);
                    table.addColumn("![Scatter Plot](" + relPathToResources + "/" + scatter.getName() + ")");
                    File pDiffHist = HazardMapPlot.compRatioHist(resourcesDir, prefix + "_pDiff_hist", xyz, compXYZ, (String)pDiffLabel + ", % Difference", HistType.PERCENT_DIFF);
                    table.addColumn("![Hist Plot](" + relPathToResources + "/" + pDiffHist.getName() + ")");
                    table.finalizeLine();
                    table.initNewLine();
                    File logRatioHist = HazardMapPlot.compRatioHist(resourcesDir, prefix + "_ratio_hist_log", xyz, compXYZ, (String)ratioLabel + ", Comparison Ratio", HistType.LOG_RATIO);
                    table.addColumn("![Hist Plot](" + relPathToResources + "/" + logRatioHist.getName() + ")");
                    File linearRatioHist = HazardMapPlot.compRatioHist(resourcesDir, prefix + "_ratio_hist", xyz, compXYZ, (String)ratioLabel + ", Comparison Ratio", HistType.RATIO);
                    table.addColumn("![Hist Plot](" + relPathToResources + "/" + linearRatioHist.getName() + ")");
                    table.finalizeLine();
                    lines.addAll(table.build());
                }
                lines.add("");
            }
        }
        return lines;
    }

    private static double withinRange(Range range, double val) {
        if (val < range.getLowerBound()) {
            return range.getLowerBound();
        }
        if (val > range.getUpperBound()) {
            return range.getUpperBound();
        }
        return val;
    }

    private static File compScatterPlot(File outputDir, String prefix, GriddedGeoDataSet xyz1, GriddedGeoDataSet xyz2, String label) throws IOException {
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        Range range = new Range(1.0E-4, 10.0);
        for (int i = 0; i < xyz1.size(); ++i) {
            scatter.set(HazardMapPlot.withinRange(range, xyz1.get(i)), HazardMapPlot.withinRange(range, xyz2.get(i)));
        }
        double min = Math.min(scatter.getMinX(), scatter.getMinY());
        double max = Math.max(scatter.getMaxX(), scatter.getMaxY());
        if (min > 0.02) {
            range = new Range(0.01, range.getUpperBound());
        } else if (min > 0.002) {
            range = new Range(0.001, range.getUpperBound());
        }
        if (max < 0.07) {
            range = new Range(range.getLowerBound(), 0.1);
        } else if (max < 0.7) {
            range = new Range(range.getLowerBound(), 1.0);
        }
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        funcs.add(scatter);
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(range.getLowerBound(), range.getLowerBound());
        line.set(range.getUpperBound(), range.getUpperBound());
        funcs.add(line);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        PlotSpec spec = new PlotSpec(funcs, chars, " ", "Primary " + label, "Comparison " + label);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(spec, true, true, range, range);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, -1, true, true, false);
        return new File(outputDir, prefix + ".png");
    }

    private static File compRatioHist(File outputDir, String prefix, GriddedGeoDataSet xyz1, GriddedGeoDataSet xyz2, String label, HistType type) throws IOException {
        String aboveLabel;
        String belowLabel;
        String withinLabel;
        double delta;
        boolean xLog;
        Range xRange;
        switch (type.ordinal()) {
            case 0: {
                xRange = new Range(0.0, 2.0);
                xLog = false;
                delta = 0.05;
                break;
            }
            case 1: {
                xRange = new Range(-1.0, 1.0);
                xLog = true;
                delta = 0.05;
                break;
            }
            case 2: {
                xRange = new Range(-100.0, 100.0);
                xLog = false;
                delta = 5.0;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(xRange.getLowerBound() + 0.1 * delta, xRange.getUpperBound() - 0.1 * delta, delta);
        hist = new HistogramFunction(hist.getMinX() - 0.5 * hist.getDelta(), hist.size() + 1, hist.getDelta());
        double[] vals = new double[xyz1.size()];
        for (int i = 0; i < xyz1.size(); ++i) {
            double v1 = xyz1.get(i);
            double v2 = xyz2.get(i);
            double val = type == HistType.LOG_RATIO || type == HistType.RATIO ? (v1 == 0.0 && v2 == 0.0 ? 1.0 : (v2 == 0.0 ? Double.POSITIVE_INFINITY : v1 / v2)) : (v1 == 0.0 && v2 == 0.0 ? 0.0 : (v2 == 0.0 ? Double.POSITIVE_INFINITY : 100.0 * (v1 - v2) / v2));
            vals[i] = val;
            if (Double.isInfinite(val)) {
                if (val > 0.0) {
                    hist.add(hist.size() - 1, 1.0);
                    continue;
                }
                hist.add(0, 1.0);
                continue;
            }
            if (xLog) {
                val = Math.log10(val);
            }
            hist.add(hist.getClosestXIndex(val), 1.0);
        }
        hist.normalizeBySumOfY_Vals();
        Range yRange = new Range(0.0, hist.getMaxY() < 0.35 ? 0.5 : 1.0);
        double annY1 = yRange.getUpperBound() * 0.95;
        double annY2 = yRange.getUpperBound() * 0.88;
        double annY3 = yRange.getUpperBound() * 0.81;
        double annLeftX = 0.05 * xRange.getLength() + xRange.getLowerBound();
        double annRightX = 0.95 * xRange.getLength() + xRange.getLowerBound();
        if (xLog) {
            annLeftX = Math.pow(10.0, annLeftX);
            annRightX = Math.pow(10.0, annRightX);
        }
        Font annFont = new Font("SansSerif", 1, 20);
        ArrayList<XYTextAnnotation> anns = new ArrayList<XYTextAnnotation>();
        XYTextAnnotation ann = new XYTextAnnotation("Mean: " + twoDigits.format(StatUtils.mean((double[])vals)), annLeftX, annY1);
        ann.setFont(annFont);
        ann.setTextAnchor(TextAnchor.TOP_LEFT);
        anns.add(ann);
        ann = new XYTextAnnotation("Median: " + twoDigits.format(DataUtils.median(vals)), annLeftX, annY2);
        ann.setFont(annFont);
        ann.setTextAnchor(TextAnchor.TOP_LEFT);
        anns.add(ann);
        ann = new XYTextAnnotation("Range: [" + twoDigits.format(StatUtils.min((double[])vals)) + "," + twoDigits.format(StatUtils.max((double[])vals)) + "]", annLeftX, annY3);
        ann.setFont(annFont);
        ann.setTextAnchor(TextAnchor.TOP_LEFT);
        anns.add(ann);
        int numBelow = 0;
        int numAbove = 0;
        int numWithin = 0;
        if (type == HistType.LOG_RATIO || type == HistType.RATIO) {
            withinLabel = "Within [0.9,1.1]";
            belowLabel = "< 0.9";
            aboveLabel = "> 1.1";
            for (double val : vals) {
                if (val > 1.1) {
                    ++numAbove;
                    continue;
                }
                if (val < 0.9) {
                    ++numBelow;
                    continue;
                }
                ++numWithin;
            }
        } else {
            withinLabel = "Within \u00b110%";
            belowLabel = "< 10%";
            aboveLabel = "> 10%";
            for (double val : vals) {
                if (val > 10.0) {
                    ++numAbove;
                    continue;
                }
                if (val < -10.0) {
                    ++numBelow;
                    continue;
                }
                ++numWithin;
            }
        }
        ann = new XYTextAnnotation(withinLabel + ": " + percentDF.format((double)numWithin / (double)vals.length), annRightX, annY1);
        ann.setFont(annFont);
        ann.setTextAnchor(TextAnchor.TOP_RIGHT);
        anns.add(ann);
        ann = new XYTextAnnotation(belowLabel + ": " + percentDF.format((double)numBelow / (double)vals.length), annRightX, annY2);
        ann.setFont(annFont);
        ann.setTextAnchor(TextAnchor.TOP_RIGHT);
        anns.add(ann);
        ann = new XYTextAnnotation(aboveLabel + ": " + percentDF.format((double)numAbove / (double)vals.length), annRightX, annY3);
        ann.setFont(annFont);
        ann.setTextAnchor(TextAnchor.TOP_RIGHT);
        anns.add(ann);
        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
        if (xLog) {
            ArbitrarilyDiscretizedFunc logHist = new ArbitrarilyDiscretizedFunc();
            for (Point2D pt : hist) {
                logHist.set(Math.pow(10.0, pt.getX()), pt.getY());
            }
            funcs.add(logHist);
            xRange = new Range(Math.pow(10.0, xRange.getLowerBound()), Math.pow(10.0, xRange.getUpperBound()));
        } else {
            funcs.add(hist);
        }
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        label = label.replace(" (g)", "");
        label = label.replace(" (cm/s)", "");
        PlotSpec spec = new PlotSpec(funcs, chars, " ", label, "Fraction");
        spec.setPlotAnnotations(anns);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(spec, xLog, false, xRange, yRange);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, 550, true, false, false);
        return new File(outputDir, prefix + ".png");
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return null;
    }

    public static void main(String[] args) throws IOException {
        File solFile = new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2021_10_19-coulomb-fm31-ref_branch-uniform-new_anneal-5x_avg-try_zero-var_perturb-noWL-5h/mean_solution.zip");
        File compSolFile = new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2021_11_01-reproduce-ucerf3-ref_branch-uniform-new_anneal-5x_avg-try_zero-var_perturb-noWL-5h/mean_solution.zip");
        File outputDir = new File("/tmp/report");
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        FaultSystemSolution sol = FaultSystemSolution.load(solFile);
        FaultSystemSolution compSol = FaultSystemSolution.load(compSolFile);
        ReportMetadata meta = new ReportMetadata(new RupSetMetadata("Primary", sol), new RupSetMetadata("Comparison", compSol));
        ReportPageGen gen = new ReportPageGen(meta, outputDir, List.of(new HazardMapPlot()));
        gen.setReplot(true);
        gen.generatePage();
    }

    static {
        String spacingEnv = System.getenv("FST_HAZARD_SPACING");
        if (spacingEnv != null && !spacingEnv.isBlank()) {
            try {
                SPACING_DEFAULT = Double.parseDouble(spacingEnv);
            }
            catch (NumberFormatException e) {
                System.err.println("Couldn't parse FST_HAZARD_SPACING environmental variable as a double: " + spacingEnv);
                e.printStackTrace();
            }
        }
        prevCompCalc = null;
        prevSol = null;
    }

    private static enum HistType {
        RATIO,
        LOG_RATIO,
        PERCENT_DIFF;

    }
}

