/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.ConstraintRange;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfitStats;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionMisfits;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;

public class InversionMisfitsPlot
extends AbstractSolutionPlot {
    @Override
    public String getName() {
        return "Inversion Misfits";
    }

    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        ArrayList<double[]> rangeMisfitVals;
        List<InversionMisfitStats.MisfitStats> rangeStats;
        InversionMisfits misfits = sol.getModule(InversionMisfits.class);
        InversionMisfitStats misfitStats = sol.getModule(InversionMisfitStats.class);
        if (misfits == null && misfitStats == null) {
            return null;
        }
        List<ConstraintRange> ranges = InversionMisfitsPlot.getRanges(misfits, misfitStats);
        if (misfits == null) {
            rangeStats = misfitStats.getStats();
            rangeMisfitVals = null;
        } else {
            rangeStats = new ArrayList<InversionMisfitStats.MisfitStats>();
            rangeMisfitVals = new ArrayList<double[]>();
            for (ConstraintRange range : ranges) {
                double[] misfitVals = misfits.getMisfits(range, true);
                rangeMisfitVals.add(misfitVals);
                rangeStats.add(new InversionMisfitStats.MisfitStats(misfitVals, range));
            }
        }
        InversionMisfits compMisfits = null;
        List<ConstraintRange> compRanges = null;
        List<InversionMisfitStats.MisfitStats> compRangeStats = null;
        ArrayList<double[]> compRangeMisfitVals = null;
        if (meta.comparison != null && meta.comparison.sol != null && (meta.comparison.sol.hasModule(InversionMisfits.class) || meta.comparison.sol.hasModule(InversionMisfitStats.class))) {
            compMisfits = meta.comparison.sol.getModule(InversionMisfits.class);
            InversionMisfitStats compMisfitStats = meta.comparison.sol.getModule(InversionMisfitStats.class);
            compRanges = InversionMisfitsPlot.getRanges(compMisfits, compMisfitStats);
            if (compMisfits == null) {
                compRangeStats = compMisfitStats.getStats();
            } else {
                compRangeStats = new ArrayList<InversionMisfitStats.MisfitStats>();
                compRangeMisfitVals = new ArrayList<double[]>();
                for (ConstraintRange range : compRanges) {
                    double[] misfitVals = compMisfits.getMisfits(range, true);
                    compRangeMisfitVals.add(misfitVals);
                    compRangeStats.add(new InversionMisfitStats.MisfitStats(misfitVals, range));
                }
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        boolean anyMisfits = false;
        for (int r = 0; r < ranges.size(); ++r) {
            ConstraintRange range = ranges.get(r);
            String prefix = "misfits_" + FileNameUtils.simplify(range.shortName);
            double[] misfitVals = rangeMisfitVals == null ? null : (double[])rangeMisfitVals.get(r);
            InversionMisfitStats.MisfitStats stats = rangeStats.get(r);
            anyMisfits = anyMisfits || misfitVals != null;
            lines.add(this.getSubHeading() + " " + range.name + " Misfits");
            lines.add(topLink);
            lines.add("");
            ConstraintRange compRange = null;
            double[] compMisfitVals = null;
            InversionMisfitStats.MisfitStats compStats = null;
            if (compRanges != null) {
                for (int r2 = 0; r2 < compRanges.size(); ++r2) {
                    ConstraintRange comp = compRanges.get(r2);
                    if (!comp.name.equals(range.name) || comp.inequality != range.inequality) continue;
                    compRange = comp;
                    compMisfitVals = compRangeMisfitVals == null ? null : (double[])compRangeMisfitVals.get(r2);
                    compStats = compRangeStats.get(r2);
                    break;
                }
            }
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            if (compStats == null) {
                table.addLine("Property", "Value");
            } else {
                table.addLine("Property", "Primary", "Comparison");
            }
            table.initNewLine().addColumn("Number of Rows").addColumn(stats.numRows);
            if (compStats != null) {
                table.addColumn(compStats.numRows);
            }
            table.finalizeLine();
            table.initNewLine().addColumn("Inversion Weight").addColumn(range.weight);
            if (compStats != null) {
                table.addColumn(compRange.weight);
            }
            table.finalizeLine();
            table.initNewLine().addColumn("Mean Misfit").addColumn(Float.valueOf((float)stats.mean));
            if (compStats != null) {
                table.addColumn(Float.valueOf((float)compStats.mean));
            }
            table.finalizeLine();
            table.initNewLine().addColumn("MAD").addColumn(Float.valueOf((float)stats.absMean));
            if (compStats != null) {
                table.addColumn(Float.valueOf((float)compStats.absMean));
            }
            table.finalizeLine();
            table.initNewLine().addColumn("Range").addColumn("[" + (float)stats.min + "," + (float)stats.max + "]");
            if (compStats != null) {
                table.addColumn("[" + (float)compStats.min + "," + (float)compStats.max + "]");
            }
            table.finalizeLine();
            table.initNewLine().addColumn("Standard Deviation").addColumn(Float.valueOf((float)stats.std));
            if (compStats != null) {
                table.addColumn(Float.valueOf((float)compStats.std));
            }
            table.finalizeLine();
            table.initNewLine().addColumn("RMSE").addColumn(Float.valueOf((float)stats.rmse));
            if (compStats != null) {
                table.addColumn(Float.valueOf((float)compStats.rmse));
            }
            table.finalizeLine();
            table.initNewLine().addColumn("L2 Norm").addColumn(Float.valueOf((float)stats.l2Norm));
            if (compStats != null) {
                table.addColumn(Float.valueOf((float)compStats.l2Norm));
            }
            table.finalizeLine();
            table.initNewLine().addColumn("Weighting Type").addColumn(String.valueOf((Object)range.weightingType));
            if (compStats != null) {
                table.addColumn(String.valueOf((Object)compRange.weightingType));
            }
            table.finalizeLine();
            if (range.inequality) {
                lines.add("_NOTE: This is in inequality constraint, so all misfit values below zero are treated as zeros._");
                lines.add("");
            }
            lines.addAll(table.build());
            lines.add("");
            if (misfitVals == null) continue;
            HistogramFunction refHist = InversionMisfitsPlot.refHist(stats, compStats);
            File histPlot = InversionMisfitsPlot.buildHistPlot(refHist, misfitVals, stats, range, resourcesDir, prefix + "_hist", range.name + " Misfits", range.weightingType == null ? "Misfit" : range.weightingType.getMisfitLabel(), MAIN_COLOR);
            if (compMisfitVals == null) {
                lines.add("![Misfit Plot](" + relPathToResources + "/" + histPlot.getName() + ")");
            } else {
                table = MarkdownUtils.tableBuilder();
                table.addLine("Primary", "Comparison");
                table.initNewLine().addColumn("![Misfit Plot](" + relPathToResources + "/" + histPlot.getName() + ")");
                File compPlot = InversionMisfitsPlot.buildHistPlot(refHist, compMisfitVals, compStats, compRange, resourcesDir, prefix + "_hist_comp", compRange.name + " Misfits", compRange.weightingType == null ? "Misfit" : compRange.weightingType.getMisfitLabel(), COMP_COLOR);
                table.addColumn("![Misfit Plot](" + relPathToResources + "/" + compPlot.getName() + ")");
                table.finalizeLine();
                if (misfitVals.length == compMisfitVals.length) {
                    double[] diffs = new double[misfitVals.length];
                    DefaultXY_DataSet scatter = new DefaultXY_DataSet();
                    for (int i = 0; i < diffs.length; ++i) {
                        double n = misfitVals[i];
                        double c = compMisfitVals[i];
                        if (compRange.inequality) {
                            n = Math.max(n, 0.0);
                            c = Math.max(c, 0.0);
                        }
                        diffs[i] = n - c;
                        scatter.set(n, c);
                    }
                    refHist = InversionMisfitsPlot.refHist(new InversionMisfitStats.MisfitStats(diffs, false, Double.NaN), null);
                    File histDiffPlot = InversionMisfitsPlot.buildHistPlot(refHist, misfitVals, null, range, resourcesDir, prefix + "_diff", range.name + " Misfit Difference", "Misfit Difference: Primary - Comparison", COMMON_COLOR);
                    table.initNewLine().addColumn("![Diff Plot](" + relPathToResources + "/" + histDiffPlot.getName() + ")");
                    ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
                    ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                    double min = Math.min(scatter.getMinX(), scatter.getMinY());
                    double max = Math.max(scatter.getMaxX(), scatter.getMaxY());
                    if (min == max) {
                        max = min == 0.0 ? 1.0 : (min > 0.0 ? min * 2.0 : min * 0.5);
                    }
                    Range scatterRange = new Range(min, max);
                    DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
                    oneToOne.set(scatterRange.getLowerBound(), scatterRange.getLowerBound());
                    oneToOne.set(scatterRange.getUpperBound(), scatterRange.getUpperBound());
                    funcs.add(oneToOne);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
                    funcs.add(scatter);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
                    PlotSpec scatterSpec = new PlotSpec(funcs, chars, "Primary vs Comparison", "Primary Misfit", "Comparison Misfit");
                    HeadlessGraphPanel gp = PlotUtils.initHeadless();
                    gp.drawGraphPanel(scatterSpec, false, false, scatterRange, scatterRange);
                    String scatterPrefix = prefix + "_scatter";
                    PlotUtils.writePlots(resourcesDir, scatterPrefix, (GraphPanel)gp, 800, 650, true, true, false);
                    table.addColumn("![Scatter Plot](" + relPathToResources + "/" + scatterPrefix + ".png)");
                    table.finalizeLine();
                }
                lines.addAll(table.build());
            }
            lines.add("");
        }
        ArrayList<String> summaryLines = new ArrayList<String>();
        CSVFile<String> summaryCSV = InversionMisfitsPlot.getMisfitsTable(ranges, rangeStats);
        summaryCSV.writeToFile(new File(resourcesDir, "misfits_summary.csv"));
        if (compMisfits == null) {
            summaryLines.addAll(MarkdownUtils.tableFromCSV(summaryCSV, true).build());
        } else {
            summaryLines.add("**" + meta.primary.name + " Misfits**");
            summaryLines.add("");
            summaryLines.addAll(MarkdownUtils.tableFromCSV(summaryCSV, true).build());
            CSVFile<String> compSummaryCSV = InversionMisfitsPlot.getMisfitsTable(compRanges, compRangeStats);
            compSummaryCSV.writeToFile(new File(resourcesDir, "misfits_summary_comp.csv"));
            summaryLines.add("");
            summaryLines.add("**" + meta.comparison.name + " Misfits**");
            summaryLines.add("");
            summaryLines.addAll(MarkdownUtils.tableFromCSV(compSummaryCSV, true).build());
        }
        summaryLines.add("");
        if (anyMisfits) {
            lines.addAll(0, summaryLines);
            return lines;
        }
        return summaryLines;
    }

    private static HistogramFunction refHist(InversionMisfitStats.MisfitStats stats, InversionMisfitStats.MisfitStats compStats) {
        double span;
        double min = Math.min(0.0, stats.min);
        double max = stats.max;
        if (compStats != null) {
            min = Math.min(min, compStats.min);
            max = Math.max(max, compStats.max);
        }
        if (max <= min) {
            max = 1.0;
        }
        Preconditions.checkState(((span = max - min) > 0.0 ? 1 : 0) != 0, (String)"Bad span=%s for min=%s, max=%s", (Object)span, (Object)min, (Object)max);
        double histDelta = Math.max(1.0E-6, Math.pow(10.0, Math.floor(Math.log10(span)) - 1.0) / 2.0);
        if ((float)max < (float)(min + histDelta)) {
            max = min + histDelta * 1.1;
        }
        return HistogramFunction.getEncompassingHistogram(min, max, histDelta);
    }

    private static List<ConstraintRange> getRanges(InversionMisfits misfits, InversionMisfitStats stats) {
        if (misfits == null) {
            ArrayList<ConstraintRange> ranges = new ArrayList<ConstraintRange>();
            for (InversionMisfitStats.MisfitStats myStats : stats.getStats()) {
                ranges.add(myStats.range);
            }
            return ranges;
        }
        List<ConstraintRange> ranges = misfits.getConstraintRanges();
        if (ranges == null || ranges.isEmpty()) {
            double[] eqMisfits = misfits.getMisfits();
            double[] ineqMisfits = misfits.getInequalityMisfits();
            ranges = new ArrayList<ConstraintRange>();
            if (eqMisfits != null) {
                ranges.add(new ConstraintRange("Equality Constraints", "Equality", 0, eqMisfits.length, false, 1.0, null));
            }
            if (ineqMisfits != null) {
                ranges.add(new ConstraintRange("Inequality Constraints", "Inequality", 0, ineqMisfits.length, true, 1.0, null));
            }
        }
        return ranges;
    }

    private static CSVFile<String> getMisfitsTable(List<ConstraintRange> ranges, List<InversionMisfitStats.MisfitStats> rangeStats) {
        Preconditions.checkState((ranges.size() == rangeStats.size() ? 1 : 0) != 0);
        CSVFile<String> summaryCSV = new CSVFile<String>(true);
        summaryCSV.addLine("Constraint Name", "Weight", "Rows", "Mean", "Std. Dev.", "MAD", "RMSE", "L2 Norm", "Energy", "Weighting Type");
        for (int r = 0; r < ranges.size(); ++r) {
            ConstraintRange range = ranges.get(r);
            InversionMisfitStats.MisfitStats stats = rangeStats.get(r);
            summaryCSV.addLine((String[])new String[]{range.name, "" + (float)range.weight, "" + (range.endRow - range.startRow), "" + (float)stats.mean, "" + (float)stats.std, "" + (float)stats.absMean, "" + (float)stats.rmse, "" + (float)stats.l2Norm, "" + (float)stats.energy, String.valueOf((Object)range.weightingType)});
        }
        return summaryCSV;
    }

    private static File buildHistPlot(HistogramFunction refHist, double[] data, InversionMisfitStats.MisfitStats stats, ConstraintRange range, File outputDir, String prefix, String title, String xAxisLabel, Color color) throws IOException {
        HistogramFunction hist = new HistogramFunction(refHist.getMinX(), refHist.getMaxX(), refHist.size());
        for (double val : data) {
            if (range.inequality && val < 0.0) continue;
            hist.add(hist.getClosestXIndex(val), 1.0);
        }
        hist.setName("Histogram");
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        funcs.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
        double minX = hist.getMinX() - 0.5 * hist.getDelta();
        double maxX = hist.getMaxX() + 0.5 * hist.getDelta();
        if (stats != null) {
            maxX = Math.max(maxX, 1.05 * stats.absMean);
        }
        Range xRange = new Range(minX, maxX);
        Range yRange = new Range(0.0, Math.max(1.0, hist.getMaxY() * 1.05));
        if (stats != null) {
            funcs.add(InversionMisfitsPlot.vertLine(stats.mean, 0.0, yRange.getUpperBound(), "Mean"));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.CYAN.darker()));
            funcs.add(InversionMisfitsPlot.vertLine(stats.absMean, 0.0, yRange.getUpperBound(), "|Mean|"));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.MAGENTA.darker()));
        }
        PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, "Count");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(spec, false, false, xRange, yRange);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, 650, true, true, false);
        return new File(outputDir, prefix + ".png");
    }

    private static XY_DataSet vertLine(double x, double y0, double y1, String name) {
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        xy.setName(name);
        xy.set(x, y0);
        xy.set(x, y1);
        return xy;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of();
    }
}

