/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.data.xyz.XYZ_DataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.FaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractSolutionPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.earthquake.faultSysSolution.util.FaultSysTools;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class NucleationRatePlot
extends AbstractSolutionPlot {
    @Override
    public String getName() {
        return "Regional Nucleation Rates";
    }

    @Override
    public List<String> plot(FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        FaultSystemRupSet rupSet = sol.getRupSet();
        double maxMag = rupSet.getMaxMag();
        GridSourceProvider gridProv = sol.requireModule(GridSourceProvider.class);
        GriddedRegion gridReg = NucleationRatePlot.getProvRegion(gridProv);
        FaultGridAssociations faultAssoc = rupSet.getModule(FaultGridAssociations.class);
        boolean intersectionAssoc = false;
        if (faultAssoc == null) {
            intersectionAssoc = true;
            faultAssoc = FaultGridAssociations.getIntersectionAssociations(rupSet, gridReg);
        }
        for (int i = 0; i < gridReg.getNodeCount(); ++i) {
            IncrementalMagFreqDist mfd = gridProv.getMFD(i);
            if (mfd == null) continue;
            for (Point2D pt : mfd) {
                if (!(pt.getY() > 0.0) || !(pt.getX() > maxMag)) continue;
                maxMag = pt.getX();
            }
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("The gridded seismicity model attached to this solution is of type `" + ClassUtils.getClassNameWithoutPackage(gridProv.getClass()) + "` and has a spatial resolution of " + (float)gridReg.getSpacing() + " degrees.");
        lines.add("");
        lines.add("The following maps show the faulting type at each grid cell from the gridded seismicity model:");
        lines.add("");
        CPT fractCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
        fractCPT.setNanColor(Color.WHITE);
        GriddedGeoDataSet ssMap = new GriddedGeoDataSet(gridReg, false);
        GriddedGeoDataSet revMap = new GriddedGeoDataSet(gridReg, false);
        GriddedGeoDataSet normMap = new GriddedGeoDataSet(gridReg, false);
        for (int i = 0; i < gridReg.getNodeCount(); ++i) {
            ssMap.set(i, gridProv.getFracStrikeSlip(i));
            revMap.set(i, gridProv.getFracReverse(i));
            normMap.set(i, gridProv.getFracNormal(i));
        }
        RupSetMapMaker mapMaker = new RupSetMapMaker(sol.getRupSet(), meta.region);
        mapMaker.setWriteGeoJSON(false);
        mapMaker.setSectOutlineChar(null);
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.addLine("Fraction Strike-Slip", "Fraction Normal", "Fraction Reverse");
        table.initNewLine();
        mapMaker.plotXYZData(ssMap, fractCPT, "Fraction Strike-Slip");
        mapMaker.plot(resourcesDir, "gridded_fract_ss", " ");
        table.addColumn("![SS](" + relPathToResources + "/gridded_fract_ss.png)");
        mapMaker.plotXYZData(normMap, fractCPT, "Fraction Normal");
        mapMaker.plot(resourcesDir, "gridded_fract_norm", " ");
        table.addColumn("![Norm](" + relPathToResources + "/gridded_fract_norm.png)");
        mapMaker.plotXYZData(revMap, fractCPT, "Fraction Reverse");
        mapMaker.plot(resourcesDir, "gridded_fract_rev", " ");
        table.addColumn("![Rev](" + relPathToResources + "/gridded_fract_rev.png)");
        table.finalizeLine();
        lines.addAll(table.build());
        lines.add("");
        Object nuclDescription = "The following maps show the total nucleation rate in each grid cell, summed across both gridded seismicity and fault-based sources, as well as their individual contributions.";
        nuclDescription = intersectionAssoc ? (String)nuclDescription + " No model-specific fault-to-grid-cell associations were supplied, so rates on faults are mapped to the grid cells that their 3D surfaces intersect." : (String)nuclDescription + " Rates from faults are mapped to grid cells according to the model supplied association fractions.";
        lines.add((String)nuclDescription);
        lines.add("");
        List<IncrementalMagFreqDist> solNuclMFDs = NucleationRatePlot.calcNuclMFDs(sol);
        ArrayList<Double> minMags = new ArrayList<Double>();
        ArrayList<String> magLabels = new ArrayList<String>();
        ArrayList<String> magPrefixes = new ArrayList<String>();
        minMags.add(5.0);
        magLabels.add("M\u22655");
        magPrefixes.add("m5");
        if (maxMag > 6.0) {
            minMags.add(6.0);
            magLabels.add("M\u22656");
            magPrefixes.add("m6");
        }
        if (maxMag > 7.0) {
            minMags.add(7.0);
            magLabels.add("M\u22657");
            magPrefixes.add("m7");
        }
        if (maxMag > 8.0) {
            minMags.add(8.0);
            magLabels.add("M\u22658");
            magPrefixes.add("m8");
        }
        if (maxMag > 9.0) {
            minMags.add(9.0);
            magLabels.add("M\u22659");
            magPrefixes.add("m9");
        }
        CPT nuclCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-6.0, -1.0);
        nuclCPT.setNanColor(Color.WHITE);
        CPT ratioCPT = null;
        GridSourceProvider compGridProv = null;
        FaultGridAssociations compFaultAssoc = null;
        List<IncrementalMagFreqDist> compSolNuclMFDs = null;
        if (meta.hasComparisonSol()) {
            compGridProv = meta.comparison.sol.getGridSourceProvider();
            GriddedRegion compGridReg = NucleationRatePlot.getProvRegion(compGridProv);
            if (compGridProv != null && !gridReg.equalsRegion(compGridReg)) {
                compGridProv = null;
            }
            if (compGridProv != null) {
                compFaultAssoc = meta.comparison.rupSet.getModule(FaultGridAssociations.class);
                if (compFaultAssoc == null) {
                    compFaultAssoc = FaultGridAssociations.getIntersectionAssociations(meta.comparison.rupSet, compGridReg);
                }
                compSolNuclMFDs = NucleationRatePlot.calcNuclMFDs(meta.comparison.sol);
            }
        }
        table = MarkdownUtils.tableBuilder();
        if (compGridProv != null) {
            CPT belowCPT = new CPT(0.5, 1.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE);
            CPT aboveCPT = new CPT(1.0, 2.0, Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
            ratioCPT = new CPT();
            ratioCPT.addAll(belowCPT);
            ratioCPT.addAll(aboveCPT);
            ratioCPT.setNanColor(Color.LIGHT_GRAY);
            ratioCPT.setBelowMinColor(ratioCPT.getMinColor());
            ratioCPT.setAboveMaxColor(ratioCPT.getMaxColor());
        }
        for (int m = 0; m < minMags.size(); ++m) {
            double myMinMag = (Double)minMags.get(m);
            GriddedGeoDataSet gridXYZ = NucleationRatePlot.calcGriddedNucleationRates(gridProv, myMinMag);
            GriddedGeoDataSet faultXYZ = NucleationRatePlot.calcFaultNucleationRates(gridReg, sol, faultAssoc, solNuclMFDs, myMinMag);
            GriddedGeoDataSet xyz = NucleationRatePlot.sum(gridXYZ, faultXYZ);
            GriddedGeoDataSet logXYZ = NucleationRatePlot.maskZeroesAsNan(xyz);
            logXYZ.log10();
            String myLabel = (String)magLabels.get(m);
            String markdownLabel = myLabel.replaceAll("\u2265", "&ge;");
            String magPrefix = (String)magPrefixes.get(m);
            table.initNewLine();
            table.addColumn(MarkdownUtils.boldCentered(markdownLabel + ", Total"));
            if (compGridProv != null) {
                table.addColumn(MarkdownUtils.boldCentered("Primary / Comparison Ratio"));
            } else {
                table.addColumn(MarkdownUtils.boldCentered(markdownLabel + ", Gridded Only"));
                table.addColumn(MarkdownUtils.boldCentered(markdownLabel + ", Fault Only"));
            }
            table.finalizeLine();
            String mainPrefix = "sol_nucl_" + magPrefix;
            mapMaker.plotXYZData(logXYZ, nuclCPT, "Log10 " + myLabel + " Nucleation Rate (events/yr)");
            mapMaker.plot(resourcesDir, mainPrefix, " ");
            table.initNewLine();
            table.addColumn("![Map](" + relPathToResources + "/" + mainPrefix + ".png)");
            if (ratioCPT != null) {
                GriddedGeoDataSet compGridXYZ = NucleationRatePlot.calcGriddedNucleationRates(compGridProv, myMinMag);
                GriddedGeoDataSet compFaultXYZ = NucleationRatePlot.calcFaultNucleationRates(gridReg, meta.comparison.sol, compFaultAssoc, compSolNuclMFDs, myMinMag);
                GriddedGeoDataSet compXYZ = NucleationRatePlot.sum(compGridXYZ, compFaultXYZ);
                GriddedGeoDataSet ratioXYZ = new GriddedGeoDataSet(gridReg, false);
                for (int i = 0; i < xyz.size(); ++i) {
                    double v1 = xyz.get(i);
                    double v2 = compXYZ.get(i);
                    if (v1 == 0.0 && v2 == 0.0) {
                        ratioXYZ.set(i, Double.NaN);
                        continue;
                    }
                    if (v2 == 0.0) {
                        ratioXYZ.set(i, Double.POSITIVE_INFINITY);
                        continue;
                    }
                    ratioXYZ.set(i, v1 / v2);
                }
                String compPrefix = "sol_nucl_compare_" + magPrefix;
                mapMaker.plotXYZData(ratioXYZ, ratioCPT, myLabel + " Primary/Comparison Nucleation Ratio");
                mapMaker.plot(resourcesDir, compPrefix, " ");
                table.addColumn("![Map](" + relPathToResources + "/" + compPrefix + ".png)");
                table.finalizeLine().initNewLine();
                table.addColumn(MarkdownUtils.boldCentered(markdownLabel + ", Gridded Only"));
                table.addColumn(MarkdownUtils.boldCentered(markdownLabel + ", Fault Only"));
                table.finalizeLine().initNewLine();
            }
            gridXYZ = NucleationRatePlot.maskZeroesAsNan(gridXYZ);
            gridXYZ.log10();
            faultXYZ = NucleationRatePlot.maskZeroesAsNan(faultXYZ);
            faultXYZ.log10();
            mapMaker.plotXYZData(gridXYZ, nuclCPT, "Log10 " + myLabel + " Gridded Nucleation Rate (events/yr)");
            mapMaker.plot(resourcesDir, mainPrefix + "_gridded", " ");
            table.addColumn("![Map](" + relPathToResources + "/" + mainPrefix + "_gridded.png)");
            mapMaker.plotXYZData(faultXYZ, nuclCPT, "Log10 " + myLabel + " Fault Nucleation Rate (events/yr)");
            mapMaker.plot(resourcesDir, mainPrefix + "_fault", " ");
            table.addColumn("![Map](" + relPathToResources + "/" + mainPrefix + "_fault.png)");
            table.finalizeLine();
        }
        lines.addAll(table.build());
        GriddedGeoDataSet gridXYZ = NucleationRatePlot.calcGriddedNucleationMomentRates(gridProv);
        GriddedGeoDataSet faultXYZ = NucleationRatePlot.calcFaultNucleationMomentRates(gridReg, sol, faultAssoc, solNuclMFDs);
        GriddedGeoDataSet xyz = NucleationRatePlot.sum(gridXYZ, faultXYZ);
        double minMoRate = Double.POSITIVE_INFINITY;
        double maxMoRate = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < xyz.size(); ++i) {
            double val = xyz.get(i);
            if (!(val > 0.0)) continue;
            minMoRate = Math.min(minMoRate, val);
            maxMoRate = Math.max(maxMoRate, val);
        }
        if (minMoRate < maxMoRate) {
            double logMaxMo = Math.ceil(Math.log10(maxMoRate));
            double logMinMo = Math.max(logMaxMo - 10.0, Math.floor(Math.log10(minMoRate)));
            CPT moCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(logMinMo, logMaxMo);
            moCPT.setNanColor(Color.WHITE);
            GriddedGeoDataSet faultGriddedRatioXYZ = new GriddedGeoDataSet(gridReg, false);
            for (int i = 0; i < xyz.size(); ++i) {
                faultGriddedRatioXYZ.set(i, faultXYZ.get(i) / gridXYZ.get(i));
            }
            faultGriddedRatioXYZ.log10();
            CPT moRatioCPT = GMT_CPT_Files.DIVERGING_BLUE_RED_UNIFORM.instance().rescale(-1.0, 1.0);
            GriddedGeoDataSet logXYZ = NucleationRatePlot.maskZeroesAsNan(xyz);
            logXYZ.log10();
            gridXYZ = NucleationRatePlot.maskZeroesAsNan(gridXYZ);
            gridXYZ.log10();
            faultXYZ = NucleationRatePlot.maskZeroesAsNan(faultXYZ);
            faultXYZ.log10();
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            table.addColumn(MarkdownUtils.boldCentered("Total Moment Rate"));
            table.addColumn(MarkdownUtils.boldCentered("Fault/Gridded Moment Rate Ratio"));
            table.finalizeLine();
            String prefix = "sol_nucl_moment";
            table.initNewLine();
            mapMaker.plotXYZData(logXYZ, moCPT, "Log10 Total Moment Rate (N-m/yr)");
            mapMaker.plot(resourcesDir, prefix, " ");
            table.addColumn("![Map](" + relPathToResources + "/" + prefix + ".png)");
            mapMaker.plotXYZData(faultGriddedRatioXYZ, moRatioCPT, "Log10 Fault/Gridded Moment Rate Ratio");
            mapMaker.plot(resourcesDir, prefix + "_fault_gridded_ratio", " ");
            table.addColumn("![Map](" + relPathToResources + "/" + prefix + "_fault_gridded_ratio.png)");
            table.finalizeLine();
            table.initNewLine();
            table.addColumn(MarkdownUtils.boldCentered("Fault Moment Rate"));
            table.addColumn(MarkdownUtils.boldCentered("Gridded Moment Rate"));
            table.finalizeLine();
            table.initNewLine();
            mapMaker.plotXYZData(faultXYZ, moCPT, "Log10 Fault Moment Rate (N-m/yr)");
            mapMaker.plot(resourcesDir, prefix + "_fault", " ");
            table.addColumn("![Map](" + relPathToResources + "/" + prefix + "_fault.png)");
            mapMaker.plotXYZData(gridXYZ, moCPT, "Log10 Gridded Moment Rate (N-m/yr)");
            mapMaker.plot(resourcesDir, prefix + "_gridded", " ");
            table.addColumn("![Map](" + relPathToResources + "/" + prefix + "_gridded.png)");
            table.finalizeLine();
            File gridMoRatesFile = new File(resourcesDir, "gridded_moment_rates.xyz");
            File faultMoRatesFile = new File(resourcesDir, "fault_moment_rates.xyz");
            GriddedGeoDataSet.writeXYZFile((XYZ_DataSet)gridXYZ, gridMoRatesFile);
            GriddedGeoDataSet.writeXYZFile((XYZ_DataSet)faultXYZ, faultMoRatesFile);
            lines.add("");
            lines.add("Download moment rate XYZ data: [Fault moment Rates](" + relPathToResources + "/" + faultMoRatesFile.getName() + ") [Gridded moment Rates](" + relPathToResources + "/" + gridMoRatesFile.getName() + ")");
            lines.add("");
            lines.add("The following table shows nucleation moment rates in each cell, as well as the ratio of fault to gridded moment.");
            lines.add("");
            lines.addAll(table.build());
        }
        return lines;
    }

    public static List<IncrementalMagFreqDist> calcNuclMFDs(FaultSystemSolution sol) {
        ArrayList<IncrementalMagFreqDist> ret = new ArrayList<IncrementalMagFreqDist>();
        FaultSystemRupSet rupSet = sol.getRupSet();
        IncrementalMagFreqDist refMFD = FaultSysTools.initEmptyMFD(rupSet);
        for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
            ret.add(sol.calcNucleationMFD_forSect(sectIndex, refMFD.getMinX(), refMFD.getMaxX(), refMFD.size()));
        }
        return ret;
    }

    public static GriddedGeoDataSet calcGriddedNucleationRates(GridSourceProvider gridProv, double minMag) {
        return NucleationRatePlot.calcGriddedNucleationRates(gridProv, NucleationRatePlot.getProvRegion(gridProv), minMag);
    }

    public static GriddedGeoDataSet calcGriddedNucleationRates(GridSourceProvider gridProv, GriddedRegion gridReg, double minMag) {
        GriddedGeoDataSet xyz = new GriddedGeoDataSet(gridReg, false);
        boolean sameIndexing = gridProv.getGriddedRegion() == gridReg;
        for (int i = 0; i < xyz.size(); ++i) {
            IncrementalMagFreqDist mfd;
            int provIndex;
            Location loc = xyz.getLocation(i);
            int n = provIndex = sameIndexing ? i : gridProv.getLocationIndex(loc);
            if (provIndex < 0 || (mfd = gridProv.getMFD(provIndex)) == null || !((float)(mfd.getMaxX() + 0.5 * mfd.getDelta()) >= (float)minMag)) continue;
            for (int j = mfd.getClosestXIndex(minMag + 0.001); j < mfd.size(); ++j) {
                xyz.set(i, xyz.get(i) + mfd.getY(j));
            }
        }
        return xyz;
    }

    public static GriddedGeoDataSet calcFaultNucleationRates(GriddedRegion gridReg, FaultSystemSolution sol, FaultGridAssociations faultGridAssoc, List<IncrementalMagFreqDist> sectNuclMFDs, double minMag) {
        GriddedGeoDataSet xyz = new GriddedGeoDataSet(gridReg, false);
        for (int sectIndex = 0; sectIndex < sectNuclMFDs.size(); ++sectIndex) {
            IncrementalMagFreqDist mfd = sectNuclMFDs.get(sectIndex);
            if (mfd == null || !((float)(mfd.getMaxX() + 0.5 * mfd.getDelta()) >= (float)minMag)) continue;
            Map<Integer, Double> nodeFracts = faultGridAssoc.getNodeFractions(sectIndex);
            for (int nodeIndex : nodeFracts.keySet()) {
                double nodeFract = nodeFracts.get(nodeIndex);
                for (int j = mfd.getClosestXIndex(minMag + 0.001); j < mfd.size(); ++j) {
                    xyz.set(nodeIndex, xyz.get(nodeIndex) + mfd.getY(j) * nodeFract);
                }
            }
        }
        return xyz;
    }

    public static GriddedGeoDataSet calcGriddedNucleationMomentRates(GridSourceProvider gridProv) {
        return NucleationRatePlot.calcGriddedNucleationMomentRates(gridProv, NucleationRatePlot.getProvRegion(gridProv));
    }

    public static GriddedGeoDataSet calcGriddedNucleationMomentRates(GridSourceProvider gridProv, GriddedRegion gridReg) {
        GriddedGeoDataSet xyz = new GriddedGeoDataSet(gridReg, false);
        boolean sameIndexing = gridProv.getGriddedRegion() == gridReg;
        for (int i = 0; i < xyz.size(); ++i) {
            IncrementalMagFreqDist mfd;
            int provIndex;
            Location loc = xyz.getLocation(i);
            int n = provIndex = sameIndexing ? i : gridProv.getLocationIndex(loc);
            if (provIndex < 0 || (mfd = gridProv.getMFD(provIndex)) == null) continue;
            xyz.set(i, xyz.get(i) + mfd.getTotalMomentRate());
        }
        return xyz;
    }

    public static GriddedGeoDataSet calcFaultNucleationMomentRates(GriddedRegion gridReg, FaultSystemSolution sol, FaultGridAssociations faultGridAssoc, List<IncrementalMagFreqDist> sectNuclMFDs) {
        GriddedGeoDataSet xyz = new GriddedGeoDataSet(gridReg, false);
        for (int sectIndex = 0; sectIndex < sectNuclMFDs.size(); ++sectIndex) {
            IncrementalMagFreqDist mfd = sectNuclMFDs.get(sectIndex);
            if (mfd == null) continue;
            double moment = mfd.getTotalMomentRate();
            Map<Integer, Double> nodeFracts = faultGridAssoc.getNodeFractions(sectIndex);
            for (int nodeIndex : nodeFracts.keySet()) {
                double nodeFract = nodeFracts.get(nodeIndex);
                xyz.set(nodeIndex, xyz.get(nodeIndex) + moment * nodeFract);
            }
        }
        return xyz;
    }

    private static GriddedRegion getProvRegion(GridSourceProvider gridProv) {
        GriddedRegion gridReg = gridProv.getGriddedRegion();
        if (gridReg == null) {
            LocationList locs = new LocationList();
            for (int i = 0; i < gridProv.getNumLocations(); ++i) {
                locs.add(gridProv.getLocation(i));
            }
            gridReg = GriddedRegion.inferEncompassingRegion(locs);
        }
        return gridReg;
    }

    private static GriddedGeoDataSet sum(GriddedGeoDataSet xyz1, GriddedGeoDataSet xyz2) {
        Preconditions.checkState((xyz1.size() == xyz2.size() ? 1 : 0) != 0);
        GriddedGeoDataSet ret = new GriddedGeoDataSet(xyz1.getRegion(), false);
        for (int i = 0; i < ret.size(); ++i) {
            ret.set(i, xyz1.get(i) + xyz2.get(i));
        }
        return ret;
    }

    private static GriddedGeoDataSet maskZeroesAsNan(GriddedGeoDataSet xyz) {
        GriddedGeoDataSet ret = new GriddedGeoDataSet(xyz.getRegion(), false);
        for (int i = 0; i < xyz.size(); ++i) {
            double val = xyz.get(i);
            if (val == 0.0) {
                val = Double.NaN;
            }
            ret.set(i, val);
        }
        return ret;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return Collections.singleton(GridSourceProvider.class);
    }
}

