/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.uncertainty.BoundedUncertainty;
import org.opensha.commons.data.uncertainty.UncertaintyBoundType;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.plot.GeographicMapMaker;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.PaleoSlipProbabilityModel;
import org.opensha.sha.earthquake.faultSysSolution.inversion.constraints.impl.UncertainDataConstraint;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.PaleoseismicConstraintData;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.faultSurface.FaultSection;

public class PaleoDataComparisonPlot
extends AbstractRupSetPlot {
    @Override
    public String getName() {
        return "Paleoseismic Data Comparison";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        String title;
        MarkdownUtils.TableBuilder table;
        String prefix;
        String compMappingStr;
        FaultSystemSolution compSol;
        PaleoseismicConstraintData data = rupSet.requireModule(PaleoseismicConstraintData.class);
        FaultSystemSolution faultSystemSolution = compSol = meta.hasComparisonSol() ? meta.comparison.sol : null;
        if (compSol != null && !rupSet.areSectionsEquivalentTo(compSol.getRupSet())) {
            compSol = null;
        }
        boolean hasRateData = data.hasPaleoRateConstraints();
        boolean hasSlipData = data.hasPaleoSlipConstraints();
        Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> paleoRates = null;
        Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> compPaleoRates = null;
        Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> paleoSlips = null;
        Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> compPaleoSlips = null;
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> slipToRateData = null;
        List<UncertainDataConstraint.SectMappedUncertainDataConstraint> compSlipToRateData = null;
        if (sol != null) {
            if (hasRateData) {
                paleoRates = PaleoDataComparisonPlot.calcSolPaleoRates(data.getPaleoRateConstraints(), data.getPaleoProbModel(), sol);
                if (compSol != null) {
                    compPaleoRates = PaleoDataComparisonPlot.calcSolPaleoRates(data.getPaleoRateConstraints(), data.getPaleoProbModel(), compSol);
                }
            }
            if (hasSlipData) {
                slipToRateData = PaleoseismicConstraintData.inferRatesFromSlipConstraints(rupSet, data.getPaleoSlipConstraints(), true);
                paleoSlips = PaleoDataComparisonPlot.calcSolPaleoSlipRates(slipToRateData, data.getPaleoSlipProbModel(), sol);
                if (compSol != null) {
                    compSlipToRateData = PaleoseismicConstraintData.inferRatesFromSlipConstraints(rupSet, data.getPaleoSlipConstraints(), true);
                    compPaleoSlips = PaleoDataComparisonPlot.calcSolPaleoSlipRates(compSlipToRateData, data.getPaleoSlipProbModel(), compSol);
                }
            }
        } else if (hasSlipData) {
            slipToRateData = PaleoseismicConstraintData.inferRatesFromSlipConstraints(rupSet, data.getPaleoSlipConstraints(), true);
        }
        ArrayList<String> lines = new ArrayList<String>();
        RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, meta.region);
        String string = compMappingStr = sol == null ? "Mappings" : "Comparison";
        if (hasRateData) {
            if (hasSlipData) {
                lines.add(this.getSubHeading() + " Paleo-Rate Data " + compMappingStr);
                lines.add(topLink);
                lines.add("");
            }
            prefix = "paleo_rate_mappings";
            PaleoDataComparisonPlot.plotMappings(mapMaker, rupSet, resourcesDir, prefix, "Paleo Rate Site/Sect Mappings", data.getPaleoRateConstraints(), paleoRates);
            table = MarkdownUtils.tableBuilder();
            table.addLine("![Map](" + relPathToResources + "/" + prefix + ".png)");
            table.addLine(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + prefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + prefix + ".geojson)");
            lines.addAll(table.build());
            lines.add("");
            if (sol != null) {
                title = "Paleo-Rate Data Fits";
                lines.addAll(PaleoDataComparisonPlot.paleoLines(resourcesDir, "paleo_rate", relPathToResources, title, meta, paleoRates, compPaleoRates));
                lines.add("");
            }
        }
        if (hasSlipData) {
            if (hasRateData) {
                lines.add(this.getSubHeading() + " Paleo-Slip Data " + compMappingStr);
                lines.add(topLink);
                lines.add("");
            }
            prefix = "paleo_slip_mappings";
            PaleoDataComparisonPlot.plotMappings(mapMaker, rupSet, resourcesDir, prefix, "Paleo Slip Site/Sect Mappings", slipToRateData, paleoSlips);
            table = MarkdownUtils.tableBuilder();
            table.addLine("![Map](" + relPathToResources + "/" + prefix + ".png)");
            table.addLine(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + prefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + prefix + ".geojson)");
            lines.addAll(table.build());
            lines.add("");
            if (sol != null) {
                title = "Paleo-Rate (Implied from Slip) Data Fits";
                lines.addAll(PaleoDataComparisonPlot.paleoLines(resourcesDir, "paleo_slip", relPathToResources, title, meta, paleoSlips, compPaleoSlips));
                lines.add("");
            }
        }
        return lines;
    }

    private static List<String> paleoLines(File resourcesDir, String prefix, String relPathToResources, String title, ReportMetadata meta, Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> data, Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> compData) throws IOException {
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        if (compData == null) {
            table.addLine("![Paleo Data Comparison](" + relPathToResources + "/" + PaleoDataComparisonPlot.plotScatter(resourcesDir, prefix + "_scatter", data, title, PaleoDataComparisonPlot.getTruncatedTitle(meta.primary.name) + " Recurrence Rate (/yr)").getName() + ")");
            table.addLine("![Paleo Data Fits](" + relPathToResources + "/" + PaleoDataComparisonPlot.plotFitHist(resourcesDir, prefix + "_hist", data, title, MAIN_COLOR).getName() + ")");
        } else {
            table.addLine("Primary", "Comparison");
            table.addLine("![Paleo Data Comparison](" + relPathToResources + "/" + PaleoDataComparisonPlot.plotScatter(resourcesDir, prefix + "_scatter", data, title, PaleoDataComparisonPlot.getTruncatedTitle(meta.primary.name) + " Recurrence Rate (/yr)").getName() + ")", "![Paleo Data Comparison](" + relPathToResources + "/" + PaleoDataComparisonPlot.plotScatter(resourcesDir, prefix + "_scatter_comp", compData, title, PaleoDataComparisonPlot.getTruncatedTitle(meta.comparison.name) + " Recurrence Rate (/yr)").getName() + ")");
            table.addLine("![Paleo Data Fits](" + relPathToResources + "/" + PaleoDataComparisonPlot.plotFitHist(resourcesDir, prefix + "_hist", data, title, MAIN_COLOR).getName() + ")", "![Paleo Data Fits](" + relPathToResources + "/" + PaleoDataComparisonPlot.plotFitHist(resourcesDir, prefix + "_hist_comp", compData, title, COMP_COLOR).getName() + ")");
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.addAll(table.build());
        lines.add("");
        table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumns("Site Name", "Mapped Subsection ID", "Mapped Parent Section", "Constraint Mean Rate", "68% Bounds", "Constraint 95% Bounds", "Std. Dev", "Solution Rate", "z-score");
        if (compData != null) {
            table.addColumns("Comparison Solution Rate", "Comparison z-score");
        }
        table.finalizeLine();
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint val : data.keySet()) {
            table.initNewLine();
            table.addColumn(val.name);
            if (val.sectionIndex >= 0) {
                table.addColumn(val.sectionIndex).addColumn(meta.primary.rupSet.getFaultSectionData(val.sectionIndex).getParentSectionName());
            } else {
                table.addColumn("_N/A_").addColumn("_N/A_");
            }
            table.addColumn(Float.valueOf((float)val.bestEstimate));
            BoundedUncertainty bounds68 = val.estimateUncertaintyBounds(UncertaintyBoundType.CONF_68);
            BoundedUncertainty bounds95 = val.estimateUncertaintyBounds(UncertaintyBoundType.CONF_95);
            table.addColumn("[" + (float)bounds68.lowerBound + ", " + (float)bounds68.upperBound + "]");
            table.addColumn("[" + (float)bounds95.lowerBound + ", " + (float)bounds95.upperBound + "]");
            table.addColumn(Float.valueOf((float)val.getPreferredStdDev()));
            Double solVal = data.get(val);
            if (solVal == null) {
                table.addColumn("_N/A_").addColumn("_N/A_");
            } else {
                if (bounds68.contains(solVal)) {
                    table.addColumn("**" + solVal.floatValue() + "**");
                } else if (bounds95.contains(solVal)) {
                    table.addColumn("_" + solVal.floatValue() + "_");
                } else {
                    table.addColumn(Float.valueOf(solVal.floatValue()));
                }
                double z = (solVal - val.bestEstimate) / val.getPreferredStdDev();
                table.addColumn(Float.valueOf((float)z));
            }
            if (compData != null) {
                Double compVal = compData.get(val);
                if (compVal == null) {
                    for (UncertainDataConstraint.SectMappedUncertainDataConstraint oData : compData.keySet()) {
                        if (!oData.name.equals(val.name) || oData.sectionIndex != val.sectionIndex) continue;
                        compVal = compData.get(oData);
                        break;
                    }
                }
                if (compVal == null) {
                    table.addColumn("_N/A_").addColumn("_N/A_");
                } else {
                    if (bounds68.contains(compVal)) {
                        table.addColumn("**" + compVal.floatValue() + "**");
                    } else if (bounds95.contains(compVal)) {
                        table.addColumn("_" + compVal.floatValue() + "_");
                    } else {
                        table.addColumn(Float.valueOf(compVal.floatValue()));
                    }
                    double z = (compVal - val.bestEstimate) / val.getPreferredStdDev();
                    table.addColumn(Float.valueOf((float)z));
                }
            }
            table.finalizeLine();
        }
        File csvFile = new File(resourcesDir, prefix + ".csv");
        CSVFile<String> csv = table.toCSV(true);
        csv.writeToFile(csvFile);
        Object line = "Paleo data comparison table. For the solution";
        line = compData == null ? (String)line + " column" : (String)line + " and comparison columns";
        line = (String)line + ", text is **bold if within 68% bounds**, _italicized if within 95% bounds_, and otherwise plain text.";
        line = (String)line + " [Download CSV here](" + resourcesDir.getName() + "/" + csvFile.getName() + ").";
        lines.add((String)line);
        lines.add("");
        lines.addAll(table.build());
        return lines;
    }

    private static Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> calcSolPaleoRates(List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> paleoRateData, PaleoProbabilityModel paleoProbModel, FaultSystemSolution sol) {
        LinkedHashMap<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> ret = new LinkedHashMap<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double>();
        FaultSystemRupSet rupSet = sol.getRupSet();
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : paleoRateData) {
            if (sectMappedUncertainDataConstraint.sectionIndex < 0) continue;
            double rate = 0.0;
            for (int rupIndex : rupSet.getRupturesForSection(sectMappedUncertainDataConstraint.sectionIndex)) {
                rate += sol.getRateForRup(rupIndex) * paleoProbModel.getProbPaleoVisible(rupSet, rupIndex, sectMappedUncertainDataConstraint.sectionIndex);
            }
            ret.put(sectMappedUncertainDataConstraint, rate);
        }
        return ret;
    }

    private static Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> calcSolPaleoSlipRates(List<UncertainDataConstraint.SectMappedUncertainDataConstraint> rateData, PaleoSlipProbabilityModel paleoSlipProbModel, FaultSystemSolution sol) {
        LinkedHashMap<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> ret = new LinkedHashMap<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double>();
        FaultSystemRupSet rupSet = sol.getRupSet();
        AveSlipModule aveSlipModule = rupSet.requireModule(AveSlipModule.class);
        SlipAlongRuptureModel slipAloModel = rupSet.requireModule(SlipAlongRuptureModel.class);
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint constr : rateData) {
            if (constr.sectionIndex < 0) continue;
            double rate = 0.0;
            for (int rupIndex : rupSet.getRupturesForSection(constr.sectionIndex)) {
                int sectIndexInRup = rupSet.getSectionsIndicesForRup(rupIndex).indexOf(constr.sectionIndex);
                double slipOnSect = slipAloModel.calcSlipOnSectionsForRup(rupSet, aveSlipModule, rupIndex)[sectIndexInRup];
                double probVisible = paleoSlipProbModel.getProbabilityOfObservedSlip(slipOnSect);
                rate += sol.getRateForRup(rupIndex) * probVisible;
            }
            ret.put(constr, rate);
        }
        return ret;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return Collections.singleton(PaleoseismicConstraintData.class);
    }

    private static File plotScatter(File outputDir, String prefix, Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> rateMap, String title, String yAxisLabel) throws IOException {
        ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        DefaultXY_DataSet scatterInside68 = new DefaultXY_DataSet();
        DefaultXY_DataSet scatterInside95 = new DefaultXY_DataSet();
        DefaultXY_DataSet scatterOutside = new DefaultXY_DataSet();
        DataUtils.MinMaxAveTracker valTrack = new DataUtils.MinMaxAveTracker();
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint constr : rateMap.keySet()) {
            double rate = rateMap.get(constr);
            if (!(rate > 0.0)) continue;
            valTrack.addValue(rate);
            if (constr.bestEstimate > 0.0) {
                valTrack.addValue(constr.bestEstimate);
            }
            BoundedUncertainty halfSigaBounds = constr.estimateUncertaintyBounds(UncertaintyBoundType.HALF_SIGMA);
            if (halfSigaBounds.lowerBound > 0.0) {
                valTrack.addValue(halfSigaBounds.lowerBound);
            }
            if (!(halfSigaBounds.upperBound > 0.0)) continue;
            valTrack.addValue(halfSigaBounds.upperBound);
        }
        Range range = Double.isInfinite(valTrack.getMin()) ? new Range(1.0E-10, 1.0) : PaleoDataComparisonPlot.calcEncompassingLog10Range(valTrack.getMin(), valTrack.getMax());
        double logWhiskerDelta95 = 0.03;
        double logWhiskerDelta68 = 0.04;
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint constr : rateMap.keySet()) {
            double rate = rateMap.get(constr);
            if (rate == 0.0) continue;
            double paleoRate = constr.bestEstimate;
            BoundedUncertainty conf68 = constr.estimateUncertaintyBounds(UncertaintyBoundType.CONF_68);
            BoundedUncertainty conf95 = constr.estimateUncertaintyBounds(UncertaintyBoundType.CONF_95);
            double lower68 = conf68.lowerBound;
            double upper68 = conf68.upperBound;
            double lower95 = conf95.lowerBound;
            double upper95 = conf95.upperBound;
            if (rate >= lower68 && rate <= upper68) {
                scatterInside68.set(paleoRate, rate);
            } else if (rate >= lower95 && rate <= upper95) {
                scatterInside95.set(paleoRate, rate);
            } else {
                scatterOutside.set(paleoRate, rate);
            }
            double whiskerAbove95 = Math.pow(10.0, Math.log10(rate) + logWhiskerDelta95);
            double whiskerBelow95 = Math.pow(10.0, Math.log10(rate) - logWhiskerDelta95);
            DefaultXY_DataSet confRange95 = new DefaultXY_DataSet();
            if (range.contains(lower95)) {
                confRange95.set(lower95, whiskerAbove95);
                confRange95.set(lower95, whiskerBelow95);
                confRange95.set(lower95, rate);
            } else {
                confRange95.set(range.getLowerBound(), rate);
            }
            if (range.contains(upper95)) {
                confRange95.set(upper95, rate);
                confRange95.set(upper95, whiskerAbove95);
                confRange95.set(upper95, whiskerBelow95);
            } else {
                confRange95.set(range.getUpperBound(), rate);
            }
            funcs.add(confRange95);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.LIGHT_GRAY));
            double whiskerAbove68 = Math.pow(10.0, Math.log10(rate) + logWhiskerDelta68);
            double whiskerBelow68 = Math.pow(10.0, Math.log10(rate) - logWhiskerDelta68);
            DefaultXY_DataSet confRange68 = new DefaultXY_DataSet();
            if (range.contains(lower68)) {
                confRange68.set(lower68, whiskerAbove68);
                confRange68.set(lower68, whiskerBelow68);
                confRange68.set(lower68, rate);
            } else {
                confRange68.set(range.getLowerBound(), rate);
            }
            if (range.contains(upper68)) {
                confRange68.set(upper68, rate);
                confRange68.set(upper68, whiskerAbove68);
                confRange68.set(upper68, whiskerBelow68);
            } else {
                confRange68.set(range.getUpperBound(), rate);
            }
            funcs.add(confRange68);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY));
        }
        if (scatterInside68.size() > 0) {
            scatterInside68.setName("Inside 68% Conf");
            funcs.add(scatterInside68);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 7.0f, Color.GREEN.darker()));
        }
        if (scatterInside95.size() > 0) {
            scatterInside95.setName("Inside 95% Conf");
            funcs.add(scatterInside95);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 7.0f, Color.BLUE.darker()));
        }
        if (scatterOutside.size() > 0) {
            scatterOutside.setName("Outside 95% Conf");
            funcs.add(scatterOutside);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 7.0f, Color.RED.darker()));
        }
        double minVal = Double.POSITIVE_INFINITY;
        double maxVal = Double.NEGATIVE_INFINITY;
        if (scatterInside68.size() > 0) {
            minVal = Math.min(minVal, scatterInside68.getMinX());
            minVal = Math.min(minVal, scatterInside68.getMinY());
            maxVal = Math.max(maxVal, scatterInside68.getMaxX());
            maxVal = Math.max(maxVal, scatterInside68.getMaxY());
        }
        if (scatterInside95.size() > 0) {
            minVal = Math.min(minVal, scatterInside95.getMinX());
            minVal = Math.min(minVal, scatterInside95.getMinY());
            maxVal = Math.max(maxVal, scatterInside95.getMaxX());
            maxVal = Math.max(maxVal, scatterInside95.getMaxY());
        }
        if (scatterOutside.size() > 0) {
            minVal = Math.min(minVal, scatterOutside.getMinX());
            minVal = Math.min(minVal, scatterOutside.getMinY());
            maxVal = Math.max(maxVal, scatterOutside.getMaxX());
            maxVal = Math.max(maxVal, scatterOutside.getMaxY());
        }
        DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
        oneToOne.set(range.getLowerBound(), range.getLowerBound());
        oneToOne.set(range.getUpperBound(), range.getUpperBound());
        if (funcs.isEmpty()) {
            funcs.add(oneToOne);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
        } else {
            funcs.add(0, oneToOne);
            chars.add(0, new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
        }
        PlotSpec plot = new PlotSpec(funcs, chars, title, "Paleoseismic Data Recurrence Rate (/yr)", yAxisLabel);
        plot.setLegendVisible(true);
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(plot, true, true, range, range);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, false, true, true, false);
        return new File(outputDir, prefix + ".png");
    }

    private static File plotFitHist(File outputDir, String prefix, Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> rateMap, String title, Color color) throws IOException {
        ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        Range xRange = new Range(-3.0, 3.0);
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(-2.99, 2.99, 0.1);
        for (UncertainDataConstraint.SectMappedUncertainDataConstraint constr : rateMap.keySet()) {
            double rate = rateMap.get(constr);
            if (rate == 0.0) continue;
            double paleoRate = constr.bestEstimate;
            double stdDev = constr.getPreferredStdDev();
            double z = (rate - paleoRate) / stdDev;
            hist.add(hist.getClosestXIndex(z), 1.0);
        }
        funcs.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
        Range yRange = new Range(0.0, hist.getMaxY() + 2.0);
        PlotSpec plot = new PlotSpec(funcs, chars, title, "z-score (standard deviations)", "Count");
        HeadlessGraphPanel gp = PlotUtils.initHeadless();
        gp.drawGraphPanel(plot, false, false, xRange, yRange);
        PlotUtils.setYTick(gp, 1.0);
        PlotUtils.writePlots(outputDir, prefix, (GraphPanel)gp, 800, 650, true, false, false);
        return new File(outputDir, prefix + ".png");
    }

    private static void plotMappings(GeographicMapMaker mapMaker, FaultSystemRupSet rupSet, File outputDir, String prefix, String title, List<? extends UncertainDataConstraint.SectMappedUncertainDataConstraint> datas, Map<UncertainDataConstraint.SectMappedUncertainDataConstraint, Double> rates) throws IOException {
        mapMaker.clearScatters();
        mapMaker.clearSectScalars();
        mapMaker.clearSectHighlights();
        if (rates != null) {
            CPT zScoreCPT = GMT_CPT_Files.GMT_POLAR.instance().rescale(-2.0, 2.0);
            zScoreCPT.setNanColor(Color.LIGHT_GRAY);
            int[] mappingCounts = new int[rupSet.getNumSections()];
            double[] dArray = new double[mappingCounts.length];
            ArrayList<Location> arrayList = new ArrayList<Location>();
            ArrayList<Double> scatterZs = new ArrayList<Double>();
            for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : datas) {
                arrayList.add(sectMappedUncertainDataConstraint.dataLocation);
                if (sectMappedUncertainDataConstraint.sectionIndex < 0) {
                    scatterZs.add(Double.NaN);
                    continue;
                }
                Double rate = rates.get(sectMappedUncertainDataConstraint);
                if (rate == null) {
                    rate = zScoreCPT.getMinValue();
                }
                double z = (rate - sectMappedUncertainDataConstraint.bestEstimate) / sectMappedUncertainDataConstraint.getPreferredStdDev();
                scatterZs.add(z);
                int n = sectMappedUncertainDataConstraint.sectionIndex;
                mappingCounts[n] = mappingCounts[n] + 1;
                int n2 = sectMappedUncertainDataConstraint.sectionIndex;
                dArray[n2] = dArray[n2] + z;
            }
            for (int i = 0; i < mappingCounts.length; ++i) {
                if (mappingCounts[i] == 0) {
                    dArray[i] = Double.NaN;
                    continue;
                }
                if (mappingCounts[i] <= 1) continue;
                int n = i;
                dArray[n] = dArray[n] / (double)mappingCounts[i];
            }
            mapMaker.plotSectScalars(dArray, zScoreCPT, "Paleo Site z-scores");
            mapMaker.plotScatterScalars(arrayList, scatterZs, zScoreCPT, null);
            mapMaker.setSkipNaNs(true);
        } else {
            HashSet<FaultSection> highlightSects = new HashSet<FaultSection>();
            for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : datas) {
                if (sectMappedUncertainDataConstraint.sectionIndex < 0) continue;
                highlightSects.add(rupSet.getFaultSectionData(sectMappedUncertainDataConstraint.sectionIndex));
            }
            mapMaker.setSectHighlights(highlightSects, new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
            ArrayList<Location> siteLocs = new ArrayList<Location>();
            for (UncertainDataConstraint.SectMappedUncertainDataConstraint sectMappedUncertainDataConstraint : datas) {
                siteLocs.add(sectMappedUncertainDataConstraint.dataLocation);
            }
            mapMaker.plotScatters(siteLocs, Color.GRAY);
        }
        mapMaker.setWriteGeoJSON(true);
        mapMaker.plot(outputDir, prefix, title);
    }

    public static void main(String[] args) throws IOException {
        File solFile = new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2021_11_03-reproduce-ucerf3-ref_branch-uniform-nshm23_draft-supra_b_0.8-2h/mean_solution.zip");
        FaultSystemSolution sol1 = FaultSystemSolution.load(solFile);
        FaultSystemSolution sol2 = FaultSystemSolution.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2021_11_03-reproduce-ucerf3-ref_branch-uniform-nshm23_draft-supra_b_0.8-no_sect_rate-2h/mean_solution.zip"));
        File outputDir = new File("/tmp/temp_report");
        PaleoDataComparisonPlot plot = new PaleoDataComparisonPlot();
        List<PaleoDataComparisonPlot> plots = List.of(plot);
        ReportPageGen report = new ReportPageGen(sol1.getRupSet(), null, "Solution", outputDir, List.of(plot));
        report.setReplot(true);
        report.generatePage();
    }
}

