/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.faultSurface.FaultSection;

public class PlausibilityConfigurationReport
extends AbstractRupSetPlot {
    @Override
    public String getName() {
        return "Plausibility Configuration";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<String> header = new ArrayList<String>();
        header.add(" ");
        header.add(meta.primary.name);
        if (meta.comparison != null) {
            header.add(meta.comparison.name);
        }
        FaultSystemRupSet compRupSet = meta.comparison == null ? null : meta.comparison.rupSet;
        PlausibilityConfiguration config = rupSet.requireModule(PlausibilityConfiguration.class);
        PlausibilityConfiguration compConfig = meta.comparison == null ? null : compRupSet.getModule(PlausibilityConfiguration.class);
        lines.add(this.getSubHeading() + " Connection Strategy");
        lines.add(topLink);
        lines.add("");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.addLine(header);
        table.initNewLine();
        table.addColumn("**Name**");
        table.addColumn(config.getConnectionStrategy().getName());
        if (meta.comparison != null) {
            if (compConfig == null) {
                table.addColumn("*(N/A)*");
            } else {
                table.addColumn(compConfig.getConnectionStrategy().getName());
            }
        }
        table.finalizeLine();
        table.initNewLine();
        table.addColumn("**Max Jump Dist**");
        table.addColumn(optionalDigitDF.format(config.getConnectionStrategy().getMaxJumpDist()) + " km");
        if (meta.comparison != null) {
            if (compConfig == null) {
                table.addColumn("*(N/A)*");
            } else {
                table.addColumn(optionalDigitDF.format(compConfig.getConnectionStrategy().getMaxJumpDist()) + " km");
            }
        }
        table.finalizeLine();
        table.initNewLine();
        table.addColumn("**Possible parent-section connections**");
        table.addColumn(PlausibilityConfigurationReport.getParentConnsStr(config.getConnectionStrategy()));
        if (meta.comparison != null) {
            if (compConfig == null) {
                table.addColumn("*(N/A)*");
            } else {
                table.addColumn(PlausibilityConfigurationReport.getParentConnsStr(compConfig.getConnectionStrategy()));
            }
        }
        table.finalizeLine();
        if (rupSet.hasModule(ClusterRuptures.class) || meta.comparison != null && compRupSet.hasModule(ClusterRuptures.class)) {
            table.initNewLine();
            table.addColumn("**Actual connections (after applying filters)**");
            table.addColumn(PlausibilityConfigurationReport.getActualConnsStr(rupSet.getModule(ClusterRuptures.class)));
            if (compRupSet != null) {
                table.addColumn(PlausibilityConfigurationReport.getActualConnsStr(compRupSet.getModule(ClusterRuptures.class)));
            }
            table.finalizeLine();
        }
        lines.addAll(table.build());
        lines.add("");
        lines.add(this.getSubHeading() + " Splays");
        lines.add(topLink);
        lines.add("");
        table = MarkdownUtils.tableBuilder();
        table.addLine(header);
        table.initNewLine();
        table.addColumn("**Max Allowed Splays**");
        table.addColumn(config.getMaxNumSplays());
        if (meta.comparison != null) {
            if (compConfig == null) {
                table.addColumn("*(N/A)*");
            } else {
                table.addColumn(compConfig.getMaxNumSplays());
            }
        }
        table.finalizeLine();
        lines.addAll(table.build());
        lines.add("");
        lines.add(this.getSubHeading() + " Plausibility Filters");
        lines.add(topLink);
        lines.add("");
        table = MarkdownUtils.tableBuilder();
        if (meta.comparison == null) {
            table.addLine(meta.primary.name);
        } else {
            table.addLine(meta.primary.name, meta.comparison.name);
        }
        HashSet<String> primaryFilters = new HashSet<String>();
        for (PlausibilityFilter plausibilityFilter : config.getFilters()) {
            primaryFilters.add(plausibilityFilter.getName());
        }
        HashSet<String> compFilters = new HashSet<String>();
        if (compConfig != null) {
            for (PlausibilityFilter filter : compConfig.getFilters()) {
                compFilters.add(filter.getName());
            }
        }
        HashSet<String> hashSet = new HashSet<String>(primaryFilters);
        hashSet.addAll(compFilters);
        ArrayList allFiltersSorted = new ArrayList(hashSet);
        Collections.sort(allFiltersSorted);
        for (String filter : allFiltersSorted) {
            table.initNewLine();
            if (primaryFilters.contains(filter)) {
                table.addColumn(filter);
            } else {
                table.addColumn("");
            }
            if (compRupSet != null) {
                if (compFilters.contains(filter)) {
                    table.addColumn(filter);
                } else {
                    table.addColumn("");
                }
            }
            table.finalizeLine();
        }
        lines.addAll(table.build());
        return lines;
    }

    private static String getParentConnsStr(ClusterConnectionStrategy connStrat) {
        if (connStrat == null) {
            return "*(N/A)*";
        }
        DataUtils.MinMaxAveTracker parentConnTrack = new DataUtils.MinMaxAveTracker();
        HashSet<Integer> parentIDs = new HashSet<Integer>();
        for (FaultSection iterator : connStrat.getSubSections()) {
            parentIDs.add(iterator.getParentSectionId());
        }
        int total = 0;
        Iterator iterator = parentIDs.iterator();
        while (iterator.hasNext()) {
            int parentID1 = (Integer)iterator.next();
            int myConnections = 0;
            Iterator iterator2 = parentIDs.iterator();
            while (iterator2.hasNext()) {
                int parentID2 = (Integer)iterator2.next();
                if (parentID1 == parentID2 || !connStrat.areParentSectsConnected(parentID1, parentID2)) continue;
                ++myConnections;
            }
            parentConnTrack.addValue(myConnections);
            total += myConnections;
        }
        return "Total: " + total + ", Avg: " + twoDigits.format(parentConnTrack.getAverage()) + ", Range: [" + (int)parentConnTrack.getMin() + "," + (int)parentConnTrack.getMax() + "]";
    }

    private static String getActualConnsStr(ClusterRuptures cRups) {
        if (cRups == null) {
            return "*(N/A)*";
        }
        HashSet<Jump> jumps = new HashSet<Jump>();
        int numRups = cRups.size();
        for (int r = 0; r < numRups; ++r) {
            ClusterRupture rupture = cRups.get(r);
            for (Jump jump : rupture.getJumpsIterable()) {
                if (jump.fromSection.getSectionId() > jump.toSection.getSectionId()) {
                    jump = jump.reverse();
                }
                jumps.add(jump);
            }
        }
        HashMap<Integer, Integer> actualParentCountsMap = new HashMap<Integer, Integer>();
        for (Jump jump : jumps) {
            int parent1 = jump.fromCluster.parentSectionID;
            if (actualParentCountsMap.containsKey(parent1)) {
                actualParentCountsMap.put(parent1, (Integer)actualParentCountsMap.get(parent1) + 1);
            } else {
                actualParentCountsMap.put(parent1, 1);
            }
            int parent2 = jump.toCluster.parentSectionID;
            if (actualParentCountsMap.containsKey(parent2)) {
                actualParentCountsMap.put(parent2, (Integer)actualParentCountsMap.get(parent2) + 1);
                continue;
            }
            actualParentCountsMap.put(parent2, 1);
        }
        DataUtils.MinMaxAveTracker actualTrack = new DataUtils.MinMaxAveTracker();
        for (Integer parentID : actualParentCountsMap.keySet()) {
            actualTrack.addValue(((Integer)actualParentCountsMap.get(parentID)).intValue());
        }
        return "Total: " + jumps.size() + ", Avg: " + twoDigits.format(actualTrack.getAverage()) + ", Range: [" + (int)actualTrack.getMin() + "," + (int)actualTrack.getMax() + "]";
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return Collections.singleton(PlausibilityConfiguration.class);
    }
}

