/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jfree.chart.annotations.XYBoxAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.plots.RupHistogramPlots;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarCoulombPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.GapWithinSectFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpDistFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.MultiDirectionalPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.SplayCountFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupCartoonGenerator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;

public class PlausibilityFilterPlot
extends AbstractRupSetPlot {
    private List<PlausibilityFilter> externalFilters;
    private String externalName;
    private boolean externalToComparison;
    private static Color[] FILTER_COLORS = new Color[]{Color.DARK_GRAY, new Color(102, 51, 0), Color.RED, Color.BLUE, Color.GREEN.darker(), Color.CYAN, Color.PINK};
    private static double[] plausibility_min_mags = new double[]{6.5, 7.0, 7.5, 8.0};
    private static final DecimalFormat percentDF = new DecimalFormat("0.00%");

    public PlausibilityFilterPlot() {
        this(null, null, false);
    }

    public PlausibilityFilterPlot(List<PlausibilityFilter> externalFilters, String externalName, boolean externalToComparison) {
        this.externalFilters = externalFilters;
        this.externalName = externalName;
        this.externalToComparison = externalToComparison;
    }

    @Override
    public String getName() {
        return "Plausibility Comparisons";
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return this.externalFilters == null ? List.of(PlausibilityConfiguration.class, ClusterRuptures.class) : Collections.singleton(ClusterRuptures.class);
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        boolean canDoComparison;
        ArrayList<String> lines = new ArrayList<String>();
        PlausibilityConfiguration primaryConfig = meta.primary.rupSet.getModule(PlausibilityConfiguration.class);
        PlausibilityConfiguration compConfig = null;
        if (meta.comparison != null) {
            compConfig = meta.comparison.rupSet.getModule(PlausibilityConfiguration.class);
        }
        boolean bl = canDoComparison = meta.comparison != null && meta.comparison.rupSet.hasModule(ClusterRuptures.class);
        if (this.externalFilters == null) {
            double jumpDist;
            ArrayList<PlausibilityFilter> filters;
            if (compConfig != null && compConfig.getFilters() != null && !compConfig.getFilters().isEmpty()) {
                lines.add(this.getSubHeading() + " Comparisons with " + meta.comparison.name + " filters");
                lines.add(topLink);
                lines.add("");
                filters = new ArrayList();
                jumpDist = compConfig.getConnectionStrategy().getMaxJumpDist();
                if (Double.isFinite(jumpDist)) {
                    filters.add(new JumpDistFilter(jumpDist));
                }
                filters.add(new SplayCountFilter(compConfig.getMaxNumSplays()));
                filters.add(new GapWithinSectFilter());
                filters.addAll(compConfig.getFilters());
                lines.addAll(this.doPlot(filters, meta.primary, resourcesDir, relPathToResources, "comp_filter_", "Comparison with " + PlausibilityFilterPlot.getTruncatedTitle(meta.comparison.name) + " Filters", topLink));
                lines.add("");
            }
            if (primaryConfig != null && canDoComparison) {
                lines.add(this.getSubHeading() + " " + meta.comparison.name + " comparisons with new filters");
                lines.add(topLink);
                lines.add("");
                filters = new ArrayList<PlausibilityFilter>();
                jumpDist = primaryConfig.getConnectionStrategy().getMaxJumpDist();
                if (Double.isFinite(jumpDist)) {
                    filters.add(new JumpDistFilter(jumpDist));
                }
                filters.add(new SplayCountFilter(primaryConfig.getMaxNumSplays()));
                filters.add(new GapWithinSectFilter());
                filters.addAll(primaryConfig.getFilters());
                lines.addAll(this.doPlot(filters, meta.comparison, resourcesDir, relPathToResources, "main_filter_", "Comparison with " + PlausibilityFilterPlot.getTruncatedTitle(meta.primary.name) + " Filters", topLink));
                lines.add("");
            }
        } else {
            if (this.externalName == null) {
                this.externalName = "Alternative Filters";
            }
            if (this.externalToComparison) {
                Preconditions.checkState((boolean)canDoComparison, (Object)"External filters are applied to comparison, but can't do a comparison.");
                lines.add(this.getSubHeading() + " " + meta.comparison.name + " Comparisons with " + this.externalName);
                lines.add(topLink);
                lines.add("");
                lines.addAll(this.doPlot(this.externalFilters, meta.comparison, resourcesDir, relPathToResources, "alt_comp_filter_", "Comparison with " + this.externalName, topLink));
            } else {
                lines.add(this.getSubHeading() + " Comparisons with " + this.externalName);
                lines.add(topLink);
                lines.add("");
                lines.addAll(this.doPlot(this.externalFilters, meta.primary, resourcesDir, relPathToResources, "alt_main_filter_", "Comparison with " + this.externalName, topLink));
            }
            lines.add("");
        }
        return lines;
    }

    private List<String> doPlot(List<PlausibilityFilter> filters, RupSetMetadata meta, File outputDir, String relPath, String prefix, String title, String topLink) throws IOException {
        List<ClusterRupture> rups = meta.rupSet.getModule(ClusterRuptures.class).getAll();
        PlausibilityConfiguration config = meta.rupSet.getModule(PlausibilityConfiguration.class);
        RuptureConnectionSearch search = meta.rupSet.getModule(RuptureConnectionSearch.class);
        RupSetPlausibilityResult result = PlausibilityFilterPlot.testRupSetPlausibility(rups, filters, config, search);
        File plot = PlausibilityFilterPlot.plotRupSetPlausibility(result, outputDir, prefix + "_compare", title);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("![plot](" + relPath + "/" + plot.getName() + ")");
        lines.add("");
        lines.addAll(PlausibilityFilterPlot.getRupSetPlausibilityTable(result, meta.sol, meta.name).build());
        lines.add("");
        lines.add("**Magnitude-filtered comparisons**");
        lines.add("");
        lines.addAll(PlausibilityFilterPlot.getMagPlausibilityTable(meta.rupSet, result, outputDir, relPath, prefix + "_mag_comp").wrap(2, 0).build());
        lines.add("");
        lines.addAll(PlausibilityFilterPlot.getRupSetPlausibilityDetailLines(result, false, meta.rupSet, rups, 15, outputDir, relPath, this.getSubHeading() + "# " + meta.name, topLink, search, meta.scalarValues));
        return lines;
    }

    public static RupSetPlausibilityResult testRupSetPlausibility(List<ClusterRupture> rups, List<PlausibilityFilter> filters, PlausibilityConfiguration config, RuptureConnectionSearch connSearch) {
        int threads = Runtime.getRuntime().availableProcessors();
        if (threads > 8) {
            threads -= 2;
        }
        threads = Integer.max(1, Integer.min(31, threads));
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        RupSetPlausibilityResult ret = PlausibilityFilterPlot.testRupSetPlausibility(rups, filters, config, connSearch, exec);
        exec.shutdown();
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static RupSetPlausibilityResult testRupSetPlausibility(List<ClusterRupture> rups, List<PlausibilityFilter> filters, PlausibilityConfiguration config, RuptureConnectionSearch connSearch, ExecutorService exec) {
        void var8_17;
        boolean hasSplays = false;
        for (ClusterRupture clusterRupture : rups) {
            if (clusterRupture.splays.isEmpty()) continue;
            hasSplays = true;
            break;
        }
        ArrayList<PlausibilityFilter> newFilters = new ArrayList<PlausibilityFilter>();
        for (PlausibilityFilter plausibilityFilter : filters) {
            void var8_10;
            if (plausibilityFilter instanceof JumpAzimuthChangeFilter) {
                ((JumpAzimuthChangeFilter)plausibilityFilter).setErrOnCantEvaluate(true);
            }
            if (plausibilityFilter.isDirectional(false) || hasSplays && plausibilityFilter.isDirectional(true)) {
                if (config == null) {
                    if (plausibilityFilter instanceof ScalarValuePlausibiltyFilter) {
                        MultiDirectionalPlausibilityFilter.Scalar scalar = new MultiDirectionalPlausibilityFilter.Scalar((ScalarValuePlausibiltyFilter)plausibilityFilter, connSearch, !plausibilityFilter.isDirectional(false));
                    } else {
                        MultiDirectionalPlausibilityFilter multiDirectionalPlausibilityFilter = new MultiDirectionalPlausibilityFilter(plausibilityFilter, connSearch, !plausibilityFilter.isDirectional(false));
                    }
                } else if (plausibilityFilter instanceof ScalarValuePlausibiltyFilter) {
                    MultiDirectionalPlausibilityFilter.Scalar scalar = new MultiDirectionalPlausibilityFilter.Scalar((ScalarValuePlausibiltyFilter)plausibilityFilter, config, !plausibilityFilter.isDirectional(false));
                } else {
                    MultiDirectionalPlausibilityFilter multiDirectionalPlausibilityFilter = new MultiDirectionalPlausibilityFilter(plausibilityFilter, config, !plausibilityFilter.isDirectional(false));
                }
            }
            newFilters.add((PlausibilityFilter)var8_10);
        }
        ArrayList<Future<PlausibilityCalcCallable>> arrayList = new ArrayList<Future<PlausibilityCalcCallable>>();
        boolean bl = false;
        while (var8_17 < rups.size()) {
            ClusterRupture rupture = rups.get((int)var8_17);
            arrayList.add(exec.submit(new PlausibilityCalcCallable(newFilters, rupture, (int)var8_17)));
            ++var8_17;
        }
        RupSetPlausibilityResult rupSetPlausibilityResult = new RupSetPlausibilityResult(filters, rups.size());
        System.out.println("Waiting on " + arrayList.size() + " plausibility calc futures...");
        for (Future future : arrayList) {
            try {
                ((PlausibilityCalcCallable)future.get()).merge(rupSetPlausibilityResult);
            }
            catch (Exception e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        System.out.println("DONE with plausibility");
        return rupSetPlausibilityResult;
    }

    public static File plotRupSetPlausibility(RupSetPlausibilityResult result, File outputDir, String prefix, String title) throws IOException {
        double dx = 1.0;
        double buffer = 0.2 * dx;
        double deltaEachSide = (dx - buffer) / 2.0;
        double maxY = 50.0;
        for (int i = 0; i < result.filters.size(); ++i) {
            int failCount = result.erredCounts[i] + result.failCounts[i];
            double percent = 100.0 * (double)failCount / (double)result.numRuptures;
            while (percent > maxY - 25.0) {
                maxY += 10.0;
            }
        }
        Font font = new Font("SansSerif", 1, 20);
        Font allFont = new Font("SansSerif", 1, 26);
        double topRowY = maxY * 0.95;
        double secondRowY = maxY * 0.91;
        double thirdRowY = maxY * 0.85;
        int numPlots = 1 + result.filters.size() / FILTER_COLORS.length;
        int filtersEach = (int)Math.ceil((double)result.filters.size() / (double)numPlots);
        System.out.println("Have " + result.filters.size() + " filters. Will do " + numPlots + " plots with " + filtersEach + " each");
        Preconditions.checkState((filtersEach <= FILTER_COLORS.length && filtersEach > 0 ? 1 : 0) != 0);
        ArrayList<PlotSpec> specs = new ArrayList<PlotSpec>();
        Range xRange = new Range(-0.3 * dx, (double)filtersEach * dx + 0.15 * dx);
        ArrayList<Range> yRanges = new ArrayList<Range>();
        for (int p = 0; p < numPlots; ++p) {
            ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            funcs.add(new DefaultXY_DataSet(new double[]{0.0, 1.0}, new double[]{0.0, 0.0}));
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 0.0f, Color.WHITE));
            ArrayList<Object> anns = new ArrayList<Object>();
            for (int i = p * filtersEach; i < result.filters.size() && i < (p + 1) * filtersEach; ++i) {
                int relIndex = i % filtersEach;
                double x = (double)relIndex * dx + 0.5 * dx;
                double percentFailed = 100.0 * (double)result.failCounts[i] / (double)result.numRuptures;
                double percentOnly = 100.0 * (double)result.onlyFailCounts[i] / (double)result.numRuptures;
                double percentErred = 100.0 * (double)result.erredCounts[i] / (double)result.numRuptures;
                Color c = FILTER_COLORS[relIndex];
                Object name = result.filters.get(i).getShortName();
                if (percentErred > 0.0) {
                    anns.add(PlausibilityFilterPlot.emptyBox(x - deltaEachSide, 0.0, x + deltaEachSide, percentFailed + percentErred, PlotLineType.DASHED, Color.LIGHT_GRAY, 2.0f));
                    name = (String)name + "*";
                }
                anns.add(PlausibilityFilterPlot.filledBox(x - deltaEachSide, 0.0, x + deltaEachSide, percentFailed, c));
                if (percentOnly > 0.0) {
                    anns.add(PlausibilityFilterPlot.filledBox(x - deltaEachSide, 0.0, x + deltaEachSide, percentOnly, PlausibilityFilterPlot.darker(c)));
                }
                XYTextAnnotation ann = new XYTextAnnotation((String)name, x, i % 2 == 0 ? secondRowY : thirdRowY);
                ann.setTextAnchor(TextAnchor.TOP_CENTER);
                ann.setPaint((Paint)c);
                ann.setFont(font);
                anns.add(ann);
                ann = new XYTextAnnotation(percentDF.format(percentFailed / 100.0), x, percentFailed + 0.6);
                ann.setTextAnchor(TextAnchor.BOTTOM_CENTER);
                ann.setPaint((Paint)Color.BLACK);
                ann.setFont(font);
                anns.add(ann);
            }
            if (p == 0) {
                String passedStr = result.allPassCount + "/" + result.numRuptures + " = " + percentDF.format((double)result.allPassCount / (double)result.numRuptures) + " passed all";
                XYTextAnnotation ann = new XYTextAnnotation(passedStr, xRange.getCentralValue(), topRowY);
                ann.setTextAnchor(TextAnchor.CENTER);
                ann.setPaint((Paint)Color.BLACK);
                ann.setFont(allFont);
                anns.add(ann);
            }
            PlotSpec spec = new PlotSpec(funcs, chars, p == 0 ? title : "", " ", "Percent Failed");
            spec.setPlotAnnotations(anns);
            specs.add(spec);
            yRanges.add(new Range(0.0, maxY));
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        ArrayList<Range> xRanges = new ArrayList<Range>();
        xRanges.add(xRange);
        gp.drawGraphPanel(specs, false, false, xRanges, yRanges);
        gp.getXAxis().setTickLabelsVisible(false);
        gp.getChartPanel().setSize(1200, 150 + 450 * numPlots);
        File pngFile = new File(outputDir, prefix + ".png");
        File pdfFile = new File(outputDir, prefix + ".pdf");
        File txtFile = new File(outputDir, prefix + ".txt");
        gp.saveAsPNG(pngFile.getAbsolutePath());
        gp.saveAsPDF(pdfFile.getAbsolutePath());
        gp.saveAsTXT(txtFile.getAbsolutePath());
        return pngFile;
    }

    private static MarkdownUtils.TableBuilder getMagPlausibilityTable(FaultSystemRupSet rupSet, RupSetPlausibilityResult fullResult, File resourcesDir, String relPathToResources, String prefix) throws IOException {
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder().initNewLine();
        for (double minMag : plausibility_min_mags) {
            RupSetPlausibilityResult result = fullResult.filterByMag(rupSet, minMag);
            if (result == null) continue;
            String magPrefix = prefix + "_m" + (float)minMag;
            String title = "M\u2265" + (float)minMag + " Comparison";
            File file = PlausibilityFilterPlot.plotRupSetPlausibility(result, resourcesDir, magPrefix, title);
            table.addColumn("![M>=" + (float)minMag + "](" + relPathToResources + "/" + file.getName() + ")");
        }
        table.finalizeLine();
        return table;
    }

    private static Color darker(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color(r /= 2, g /= 2, b /= 2);
    }

    private static DefaultXY_DataSet vertLine(double x, double y0, double y1) {
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(x, y0);
        line.set(x, y1);
        return line;
    }

    private static XYBoxAnnotation filledBox(double x0, double y0, double x1, double y1, Color c) {
        XYBoxAnnotation ann = new XYBoxAnnotation(x0, y0, x1, y1, null, null, (Paint)c);
        return ann;
    }

    private static XYBoxAnnotation emptyBox(double x0, double y0, double x1, double y1, PlotLineType lineType, Color c, float thickness) {
        Stroke stroke = lineType.buildStroke(thickness);
        XYBoxAnnotation ann = new XYBoxAnnotation(x0, y0, x1, y1, stroke, (Paint)c, null);
        return ann;
    }

    public static MarkdownUtils.TableBuilder getRupSetPlausibilityTable(RupSetPlausibilityResult result, FaultSystemSolution sol, String linkHeading) {
        boolean hasRates;
        linkHeading = linkHeading.replaceAll("#", "").trim();
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        boolean bl = hasRates = sol != null && sol.getRupSet().getNumRuptures() == result.numRuptures;
        if (hasRates) {
            table.addLine("Filter", "Failed", "Failure Rate", "Only Failure", "Erred");
        } else {
            table.addLine("Filter", "Failed", "Only Failure", "Erred");
        }
        for (int t = 0; t < result.filters.size(); ++t) {
            table.initNewLine();
            String name = result.filters.get(t).getName();
            if (linkHeading != null && (result.failCounts[t] > 0 || result.erredCounts[t] > 0)) {
                table.addColumn("**[" + name + "](#" + MarkdownUtils.getAnchorName(linkHeading + " " + name) + ")**");
            } else {
                table.addColumn("**" + name + "**");
            }
            table.addColumn(PlausibilityFilterPlot.countStats(result.failCounts[t], result.numRuptures));
            if (hasRates) {
                FaultSystemRupSet rupSet = sol.getRupSet();
                double totRate = sol.getTotalRateForAllFaultSystemRups();
                double failRate = 0.0;
                for (int r = 0; r < result.numRuptures; ++r) {
                    PlausibilityResult filterResult = result.filterResults.get(t).get(r);
                    if (filterResult == null || filterResult.isPass()) continue;
                    failRate += sol.getRateForRup(r);
                }
                table.addColumn((float)failRate + " (" + percentDF.format(failRate / totRate) + ")");
            }
            table.addColumn(PlausibilityFilterPlot.countStats(result.onlyFailCounts[t], result.numRuptures));
            table.addColumn(PlausibilityFilterPlot.countStats(result.erredCounts[t], result.numRuptures));
            table.finalizeLine();
        }
        table.initNewLine();
        table.addColumn("**Combined**");
        int numFails = 0;
        int numErrs = 0;
        double failRate = 0.0;
        for (int r = 0; r < result.numRuptures; ++r) {
            boolean fails = false;
            boolean errs = false;
            for (List<PlausibilityResult> filterResults : result.filterResults) {
                PlausibilityResult filterResult = filterResults.get(r);
                if (filterResult == null) {
                    errs = true;
                    continue;
                }
                if (filterResult.isPass()) continue;
                fails = true;
            }
            if (fails) {
                ++numFails;
            }
            if (errs) {
                ++numErrs;
            }
            if (!fails || !hasRates) continue;
            failRate += sol.getRateForRup(r);
        }
        table.addColumn(PlausibilityFilterPlot.countStats(numFails, result.numRuptures));
        if (hasRates) {
            table.addColumn((float)failRate + " (" + percentDF.format(failRate / sol.getTotalRateForAllFaultSystemRups()) + ")");
        }
        table.addColumn("*N/A*");
        table.addColumn(PlausibilityFilterPlot.countStats(numErrs, result.numRuptures));
        table.finalizeLine();
        return table;
    }

    public static List<String> getRupSetPlausibilityDetailLines(RupSetPlausibilityResult result, boolean compRups, FaultSystemRupSet rupSet, List<ClusterRupture> rups, int maxNumToPlot, File resourcesDir, String relPathToResources, String heading, String topLink, RuptureConnectionSearch connSearch, List<RupHistogramPlots.HistScalarValues> scalarVals) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        File rupHtmlDir = new File(resourcesDir.getParentFile(), "rupture_pages");
        Preconditions.checkState((rupHtmlDir.exists() || rupHtmlDir.mkdir() ? 1 : 0) != 0);
        for (int i = 0; i < result.filters.size(); ++i) {
            Object track;
            MarkdownUtils.TableBuilder table;
            if (result.failCounts[i] == 0 && result.erredCounts[i] == 0) continue;
            PlausibilityFilter filter = result.filters.get(i);
            lines.add(heading + " " + filter.getName());
            lines.add(topLink);
            lines.add("");
            Object filterPrefix = FileNameUtils.simplify(filter.getShortName());
            if (compRups) {
                filterPrefix = (String)filterPrefix + "_compRups";
            }
            Color color = compRups ? COMP_COLOR : MAIN_COLOR;
            HashSet<Integer> failIndexes = new HashSet<Integer>();
            HashSet<Integer> errIndexes = new HashSet<Integer>();
            for (int r = 0; r < result.numRuptures; ++r) {
                PlausibilityResult res = result.filterResults.get(i).get(r);
                if (res == null) {
                    errIndexes.add(r);
                    continue;
                }
                if (res.isPass()) continue;
                failIndexes.add(r);
            }
            HashSet<Integer> combIndexes = new HashSet<Integer>(failIndexes);
            combIndexes.addAll(errIndexes);
            if (scalarVals != null) {
                table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                for (RupHistogramPlots.HistScalarValues vals : scalarVals) {
                    RupHistogramPlots.HistScalar scalar = vals.getScalar();
                    String prefix = "filter_hist_" + (String)filterPrefix + "_" + scalar.name();
                    File plot = RupHistogramPlots.plotRuptureHistogram(resourcesDir, prefix, vals, combIndexes, null, null, color, false, false);
                    table.addColumn("![" + scalar.getName() + "](" + relPathToResources + "/" + plot.getName() + ")");
                }
                table.finalizeLine();
                lines.add("**Distributions of ruptures that failed (" + countDF.format(result.failCounts[i]) + ") or erred (" + countDF.format(result.erredCounts[i]) + "):**");
                lines.add("");
                lines.addAll(table.wrap(5, 0).build());
                lines.add("");
            }
            if (result.failCounts[i] > 0) {
                lines.add("This filter has " + result.failCounts[i] + " failures, of which " + result.onlyFailCounts[i] + " are unique, i.e., fail this filter but no other filters. The table below shows how the non-unique failues overlap with other filters.");
                lines.add("");
                table = MarkdownUtils.tableBuilder();
                table.addLine("Filter", "Failures In Common", "% of My Failures", "% Of All Failures", "% Of All Ruptures");
                List<PlausibilityResult> myFilterResults = result.filterResults.get(i);
                for (int j = 0; j < result.filters.size(); ++j) {
                    if (i == j || result.failCounts[j] == 0) continue;
                    table.initNewLine();
                    String oName = result.filters.get(j).getName();
                    table.addColumn("**[" + oName + "](#" + MarkdownUtils.getAnchorName(heading + " " + oName) + ")**");
                    int numCommon = 0;
                    Object altFilterResults = result.filterResults.get(j);
                    for (int r = 0; r < result.numRuptures; ++r) {
                        PlausibilityResult myResult = myFilterResults.get(r);
                        PlausibilityResult altResult = (PlausibilityResult)((Object)altFilterResults.get(r));
                        if (myResult == null || myResult.isPass() || altResult == null || altResult.isPass()) continue;
                        ++numCommon;
                    }
                    table.addColumn(countDF.format(numCommon));
                    table.addColumn(percentDF.format((double)numCommon / (double)result.failCounts[i]));
                    table.addColumn(percentDF.format((double)numCommon / (double)(result.numRuptures - result.allPassCount)));
                    table.addColumn(percentDF.format((double)numCommon / (double)result.numRuptures));
                    table.finalizeLine();
                }
                lines.addAll(table.build());
                lines.add("");
            }
            if (result.failCounts[i] > 0 && filter instanceof ScalarValuePlausibiltyFilter) {
                System.out.println(filter.getName() + " is scalar");
                ScalarValuePlausibiltyFilter scaleFilter = (ScalarValuePlausibiltyFilter)filter;
                com.google.common.collect.Range range = scaleFilter.getAcceptableRange();
                Double lower = null;
                Double upper = null;
                if (range != null) {
                    if (range.hasLowerBound()) {
                        lower = ((Number)((Object)range.lowerEndpoint())).doubleValue();
                    }
                    if (range.hasUpperBound()) {
                        upper = ((Number)((Object)range.upperEndpoint())).doubleValue();
                    }
                }
                MarkdownUtils.TableBuilder table2 = MarkdownUtils.tableBuilder();
                table2.addLine("Fail Scalar Distribution", "Pass Scalar Distribution");
                table2.initNewLine();
                for (boolean passes : new boolean[]{false, true}) {
                    track = new DataUtils.MinMaxAveTracker();
                    ArrayList<Double> scalars = new ArrayList<Double>();
                    for (int r = 0; r < result.numRuptures; ++r) {
                        Double scalar;
                        PlausibilityResult res = result.filterResults.get(i).get(r);
                        if (res == null || res.isPass() != passes || (scalar = result.scalarVals.get(i).get(r)) == null || !Double.isFinite(scalar)) continue;
                        scalars.add(scalar);
                        ((DataUtils.MinMaxAveTracker)track).addValue(scalar);
                    }
                    System.out.println("Have " + scalars.size() + " scalars, passes=" + passes);
                    if (scalars.size() > 0) {
                        Range xRange;
                        boolean xNegFlip;
                        boolean xLog;
                        AbstractDiscretizedFunc hist;
                        Iterator<Object> iterator;
                        HistogramFunction logHist;
                        AggregatedStiffnessCalculator aggCalc;
                        Object xAxisLabel;
                        if (scaleFilter.getScalarName() == null) {
                            xAxisLabel = "Scalar Value";
                        } else {
                            xAxisLabel = scaleFilter.getScalarName();
                            if (scaleFilter.getScalarUnits() != null) {
                                xAxisLabel = (String)xAxisLabel + " (" + scaleFilter.getScalarUnits() + ")";
                            }
                        }
                        System.out.println("tracker: " + String.valueOf(track));
                        ScalarCoulombPlausibilityFilter coulombFilter = null;
                        if (filter instanceof ScalarCoulombPlausibilityFilter && !(aggCalc = (coulombFilter = (ScalarCoulombPlausibilityFilter)filter).getAggregator()).hasUnits()) {
                            coulombFilter = null;
                        }
                        if (coulombFilter != null && lower != null && lower.floatValue() <= 0.0f && ((DataUtils.MinMaxAveTracker)track).getMax() < 0.0) {
                            double logMinNeg = Math.log10(-((DataUtils.MinMaxAveTracker)track).getMax());
                            double logMaxNeg = Math.log10(-((DataUtils.MinMaxAveTracker)track).getMin());
                            System.out.println("Flipping with track: " + String.valueOf(track));
                            System.out.println("\tlogMinNeg=" + logMinNeg);
                            System.out.println("\tlogMaxNeg=" + logMaxNeg);
                            logMinNeg = logMinNeg < -8.0 ? -8.0 : Math.floor(logMinNeg);
                            logMaxNeg = logMaxNeg < -1.0 ? -1.0 : Math.ceil(logMaxNeg);
                            System.out.println("\tlogMinNeg=" + logMinNeg);
                            System.out.println("\tlogMaxNeg=" + logMaxNeg);
                            logHist = HistogramFunction.getEncompassingHistogram(logMinNeg, logMaxNeg, 0.1);
                            iterator = scalars.iterator();
                            while (iterator.hasNext()) {
                                double scalar = (Double)iterator.next();
                                scalar = Math.log10(-scalar);
                                logHist.add(logHist.getClosestXIndex(scalar), 1.0);
                            }
                            hist = new ArbitrarilyDiscretizedFunc();
                            for (Point2D pt : logHist) {
                                hist.set(Math.pow(10.0, pt.getX()), pt.getY());
                            }
                            xLog = true;
                            xNegFlip = false;
                            xRange = new Range(Math.pow(10.0, logHist.getMinX() - 0.5 * logHist.getDelta()), Math.pow(10.0, logHist.getMaxX() + 0.5 * logHist.getDelta()));
                            xAxisLabel = "-" + (String)xAxisLabel;
                        } else if (coulombFilter != null && lower != null && lower.floatValue() >= 0.0f && ((DataUtils.MinMaxAveTracker)track).getMin() > 0.0) {
                            double logMin = Math.log10(((DataUtils.MinMaxAveTracker)track).getMin());
                            double logMax = Math.log10(((DataUtils.MinMaxAveTracker)track).getMax());
                            logMin = logMin < -8.0 ? -8.0 : Math.floor(logMin);
                            logMax = logMax < -1.0 ? -1.0 : Math.ceil(logMax);
                            System.out.println("\tlogMin=" + logMin);
                            System.out.println("\tlogMax=" + logMax);
                            logHist = HistogramFunction.getEncompassingHistogram(logMin, logMax, 0.1);
                            iterator = scalars.iterator();
                            while (iterator.hasNext()) {
                                double scalar = (Double)iterator.next();
                                scalar = Math.log10(scalar);
                                logHist.add(logHist.getClosestXIndex(scalar), 1.0);
                            }
                            hist = new ArbitrarilyDiscretizedFunc();
                            for (Point2D pt : logHist) {
                                hist.set(Math.pow(10.0, pt.getX()), pt.getY());
                            }
                            xLog = true;
                            xNegFlip = false;
                            xRange = new Range(Math.pow(10.0, logHist.getMinX() - 0.5 * logHist.getDelta()), Math.pow(10.0, logHist.getMaxX() + 0.5 * logHist.getDelta()));
                        } else {
                            HistogramFunction myHist;
                            double max;
                            double len = ((DataUtils.MinMaxAveTracker)track).getMax() - ((DataUtils.MinMaxAveTracker)track).getMin();
                            double delta = len > 1000.0 ? 50.0 : (len > 100.0 ? 10.0 : (len > 50.0 ? 5.0 : (len > 10.0 ? 2.0 : (len > 5.0 ? 1.0 : (len > 2.0 ? 0.5 : (len > 1.0 ? 0.1 : (len > 0.5 ? 0.05 : (len > 0.1 ? 0.01 : len / 10.0))))))));
                            double min = ((DataUtils.MinMaxAveTracker)track).getMin();
                            if (min == (max = ((DataUtils.MinMaxAveTracker)track).getMax())) {
                                myHist = new HistogramFunction(min, max, 1);
                                myHist.set(0, (double)scalars.size());
                                hist = myHist;
                                xLog = false;
                                xNegFlip = false;
                                xRange = new Range(min - 0.5, max + 0.5);
                            } else {
                                myHist = HistogramFunction.getEncompassingHistogram(((DataUtils.MinMaxAveTracker)track).getMin(), ((DataUtils.MinMaxAveTracker)track).getMax(), delta);
                                Iterator iterator2 = scalars.iterator();
                                while (iterator2.hasNext()) {
                                    double scalar = (Double)iterator2.next();
                                    myHist.add(myHist.getClosestXIndex(scalar), 1.0);
                                }
                                hist = myHist;
                                xLog = false;
                                xNegFlip = false;
                                xRange = new Range(myHist.getMinX() - 0.5 * myHist.getDelta(), myHist.getMaxX() + 0.5 * myHist.getDelta());
                            }
                        }
                        ArrayList<AbstractDiscretizedFunc> funcs = new ArrayList<AbstractDiscretizedFunc>();
                        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                        funcs.add(hist);
                        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, color));
                        Object title = filter.getName();
                        title = passes ? (String)title + " Passes" : (String)title + " Failures";
                        PlotSpec spec = new PlotSpec(funcs, chars, (String)title, (String)xAxisLabel, "Count");
                        HeadlessGraphPanel gp = new HeadlessGraphPanel();
                        gp.setTickLabelFontSize(18);
                        gp.setAxisLabelFontSize(24);
                        gp.setPlotLabelFontSize(24);
                        gp.setBackgroundColor(Color.WHITE);
                        gp.drawGraphPanel(spec, xLog, false, xRange, null);
                        gp.getPlot().getDomainAxis().setInverted(xNegFlip);
                        String prefix = "filter_hist_" + (String)filterPrefix;
                        prefix = passes ? prefix + "_passed_scalars" : prefix + "_failed_scalars";
                        File file = new File(resourcesDir, prefix);
                        gp.getChartPanel().setSize(800, 600);
                        gp.saveAsPNG(file.getAbsolutePath() + ".png");
                        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                        table2.addColumn("![hist](" + relPathToResources + "/" + file.getName() + ".png)");
                        continue;
                    }
                    table2.addColumn("*N/A*");
                }
                table2.finalizeLine();
                lines.add("**Scalar values of ruptures**");
                lines.add("");
                lines.addAll(table2.build());
                lines.add("");
            }
            for (boolean err : new boolean[]{false, true}) {
                if (!err && result.failCounts[i] == 0 || err && result.erredCounts[i] == 0) continue;
                int shortestIndex = -1;
                int shortestNumSects = Integer.MAX_VALUE;
                int longestIndex = -1;
                int longestNumClusters = 0;
                HashSet<Integer> plotIndexes = err ? errIndexes : failIndexes;
                track = plotIndexes.iterator();
                while (track.hasNext()) {
                    int index = (Integer)track.next();
                    ClusterRupture rup = rups.get(index);
                    int sects = rup.getTotalNumSects();
                    int clusters = rup.getTotalNumClusters();
                    if (sects < shortestNumSects) {
                        shortestIndex = index;
                        shortestNumSects = sects;
                    }
                    if (clusters <= longestNumClusters) continue;
                    longestIndex = index;
                    longestNumClusters = clusters;
                }
                plotIndexes.remove(shortestIndex);
                plotIndexes.remove(longestIndex);
                List<Integer> plotSorted = new ArrayList(plotIndexes);
                Collections.sort(plotSorted);
                Collections.shuffle(plotSorted, new Random(plotIndexes.size()));
                if (plotSorted.size() > maxNumToPlot - 2) {
                    plotSorted = plotSorted.subList(0, maxNumToPlot - 2);
                }
                int r = plotSorted.size();
                while (--r >= 0) {
                    int index = (Integer)plotSorted.get(r);
                    if (index != shortestIndex && index != longestIndex) continue;
                    plotSorted.remove(r);
                }
                plotSorted.add(0, shortestIndex);
                if (longestIndex != shortestIndex) {
                    plotSorted.add(longestIndex);
                }
                MarkdownUtils.TableBuilder table3 = MarkdownUtils.tableBuilder();
                table3.initNewLine();
                String prefix = "filter_examples_" + (String)filterPrefix;
                boolean plotAzimuths = filter.getName().toLowerCase().contains("azimuth");
                Iterator iterator = plotSorted.iterator();
                while (iterator.hasNext()) {
                    int rupIndex = (Integer)iterator.next();
                    String rupPrefix = prefix + "_" + rupIndex;
                    RupCartoonGenerator.plotRupture(resourcesDir, rupPrefix, rups.get(rupIndex), "Rupture " + rupIndex, plotAzimuths, true);
                    table3.addColumn("[<img src=\"" + resourcesDir.getName() + "/" + rupPrefix + ".png\" />](" + RupHistogramPlots.generateRuptureInfoPage(rupSet, rups.get(rupIndex), rupIndex, rupHtmlDir, rupPrefix, result, connSearch.getDistAzCalc()) + ")");
                }
                table3.finalizeLine();
                if (err) {
                    lines.add("Example ruptures which erred:");
                } else {
                    lines.add("Example ruptures which failed:");
                }
                lines.add("");
                lines.addAll(table3.wrap(5, 0).build());
                lines.add("");
            }
        }
        return lines;
    }

    private static String countStats(int count, int tot) {
        return countDF.format(count) + "/" + countDF.format(tot) + " (" + percentDF.format((double)count / (double)tot) + ")";
    }

    public static class RupSetPlausibilityResult {
        public final List<PlausibilityFilter> filters;
        public final int numRuptures;
        public int allPassCount;
        public final List<List<PlausibilityResult>> filterResults;
        public final List<List<Double>> scalarVals;
        public final List<Boolean> singleFailures;
        public final int[] failCounts;
        public final int[] failCanContinueCounts;
        public final int[] onlyFailCounts;
        public final int[] erredCounts;

        private RupSetPlausibilityResult(List<PlausibilityFilter> filters, int numRuptures) {
            this.filters = filters;
            this.numRuptures = numRuptures;
            this.allPassCount = 0;
            this.filterResults = new ArrayList<List<PlausibilityResult>>();
            this.scalarVals = new ArrayList<List<Double>>();
            for (PlausibilityFilter filter : filters) {
                this.filterResults.add(new ArrayList());
                if (filter instanceof ScalarValuePlausibiltyFilter) {
                    this.scalarVals.add(new ArrayList());
                    continue;
                }
                this.scalarVals.add(null);
            }
            this.singleFailures = new ArrayList<Boolean>();
            this.failCounts = new int[filters.size()];
            this.failCanContinueCounts = new int[filters.size()];
            this.onlyFailCounts = new int[filters.size()];
            this.erredCounts = new int[filters.size()];
        }

        public RupSetPlausibilityResult(List<PlausibilityFilter> filters, int numRuptures, int allPassCount, List<List<PlausibilityResult>> filterResults, List<List<Double>> scalarVals, List<Boolean> singleFailures, int[] failCounts, int[] failCanContinueCounts, int[] onlyFailCounts, int[] erredCounts) {
            this.filters = filters;
            this.numRuptures = numRuptures;
            this.allPassCount = allPassCount;
            this.filterResults = filterResults;
            this.scalarVals = scalarVals;
            this.singleFailures = singleFailures;
            this.failCounts = failCounts;
            this.failCanContinueCounts = failCanContinueCounts;
            this.onlyFailCounts = onlyFailCounts;
            this.erredCounts = erredCounts;
        }

        public RupSetPlausibilityResult filterByMag(FaultSystemRupSet rupSet, double minMag) {
            ArrayList<Integer> matchingRups = new ArrayList<Integer>();
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                if (!(rupSet.getMagForRup(r) >= minMag)) continue;
                matchingRups.add(r);
            }
            return this.filterByRups(matchingRups);
        }

        public RupSetPlausibilityResult filterByRups(Collection<Integer> matchingRups) {
            if (matchingRups.isEmpty()) {
                return null;
            }
            RupSetPlausibilityResult ret = new RupSetPlausibilityResult(this.filters, matchingRups.size());
            RuntimeException fakeException = new RuntimeException("Placeholder exception");
            for (int r : matchingRups) {
                PlausibilityResult[] results = new PlausibilityResult[this.filters.size()];
                Throwable[] exceptions = new Throwable[this.filters.size()];
                Double[] scalars = new Double[this.filters.size()];
                for (int f = 0; f < this.filters.size(); ++f) {
                    results[f] = this.filterResults.get(f).get(r);
                    if (results[f] == null) {
                        exceptions[f] = fakeException;
                    }
                    if (this.scalarVals.get(f) == null) continue;
                    scalars[f] = this.scalarVals.get(f).get(r);
                }
                ret.addResult(null, results, exceptions, scalars);
            }
            return ret;
        }

        private void addResult(ClusterRupture rupture, PlausibilityResult[] results, Throwable[] exceptions, Double[] scalars) {
            Preconditions.checkState((results.length == this.filters.size() ? 1 : 0) != 0);
            boolean allPass = true;
            int onlyFailureIndex = -1;
            for (int t = 0; t < this.filters.size(); ++t) {
                boolean subPass;
                PlausibilityFilter test = this.filters.get(t);
                PlausibilityResult result = results[t];
                if (exceptions[t] != null) {
                    if (!(this.erredCounts[t] != 0 || exceptions[t].getMessage() != null && exceptions[t].getMessage().startsWith("Placeholder"))) {
                        System.err.println("First exception for " + test.getName() + ":");
                        exceptions[t].printStackTrace();
                        if (rupture != null) {
                            System.err.println("Running in verbose mode for rupture:\n\t" + String.valueOf(rupture));
                            try {
                                this.filters.get(t).apply(rupture, true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            System.err.println("DONE verbose");
                        }
                    }
                    int n = t;
                    this.erredCounts[n] = this.erredCounts[n] + 1;
                    subPass = true;
                    result = null;
                } else {
                    if (result == PlausibilityResult.FAIL_FUTURE_POSSIBLE) {
                        int n = t;
                        this.failCanContinueCounts[n] = this.failCanContinueCounts[n] + 1;
                    }
                    subPass = result.isPass();
                }
                if (!subPass && allPass) {
                    onlyFailureIndex = t;
                } else if (!subPass) {
                    onlyFailureIndex = -1;
                }
                boolean bl = allPass = subPass && allPass;
                if (!subPass) {
                    int n = t;
                    this.failCounts[n] = this.failCounts[n] + 1;
                }
                this.filterResults.get(t).add(result);
                if (this.scalarVals.get(t) == null) continue;
                this.scalarVals.get(t).add(scalars[t]);
            }
            if (allPass) {
                ++this.allPassCount;
            }
            if (onlyFailureIndex >= 0) {
                int n = onlyFailureIndex;
                this.onlyFailCounts[n] = this.onlyFailCounts[n] + 1;
                this.singleFailures.add(true);
            } else {
                this.singleFailures.add(false);
            }
        }
    }

    private static class PlausibilityCalcCallable
    implements Callable<PlausibilityCalcCallable> {
        private ClusterRupture rupture;
        private List<PlausibilityFilter> filters;
        private int rupIndex;
        private PlausibilityResult[] results;
        private Throwable[] exceptions;
        private Double[] scalars;

        public PlausibilityCalcCallable(List<PlausibilityFilter> filters, ClusterRupture rupture, int rupIndex) {
            this.filters = filters;
            this.rupture = rupture;
            this.rupIndex = rupIndex;
        }

        @Override
        public PlausibilityCalcCallable call() throws Exception {
            this.results = new PlausibilityResult[this.filters.size()];
            this.exceptions = new Throwable[this.filters.size()];
            this.scalars = new Double[this.filters.size()];
            for (int t = 0; t < this.filters.size(); ++t) {
                PlausibilityFilter filter = this.filters.get(t);
                try {
                    Object scalar;
                    this.results[t] = filter.apply(this.rupture, false);
                    if (!(filter instanceof ScalarValuePlausibiltyFilter) || (scalar = ((ScalarValuePlausibiltyFilter)filter).getValue(this.rupture)) == null) continue;
                    this.scalars[t] = ((Number)scalar).doubleValue();
                    continue;
                }
                catch (Exception e) {
                    this.exceptions[t] = e;
                }
            }
            return this;
        }

        public void merge(RupSetPlausibilityResult fullResults) {
            fullResults.addResult(this.rupture, this.results, this.exceptions, this.scalars);
        }
    }
}

