/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.RupSetMetadata;

public class RuptureScalingPlot
extends AbstractRupSetPlot {
    @Override
    public String getName() {
        return "Rupture Scaling";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        Scatters primary = new Scatters(rupSet);
        Scatters comp = meta.comparison == null ? null : new Scatters(meta.comparison.rupSet);
        boolean hasSlips = primary.slipMags != null;
        ArrayList<String> lines = new ArrayList<String>();
        if (hasSlips) {
            lines.add(this.getSubHeading() + " Magnitude Scaling");
            lines.add(topLink);
            lines.add("");
        }
        int threads = this.getNumThreads();
        ExecutorService exec = null;
        ArrayList futures = null;
        if (threads > 1) {
            exec = Executors.newFixedThreadPool(threads);
            futures = new ArrayList();
        }
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.addLine("Linear Plots", "Log10 Plots");
        table.initNewLine();
        File plot = RuptureScalingPlot.plot(resourcesDir, "mag_area_scaling", " ", primary.magAreas, meta.primary.name, comp == null ? null : comp.magAreas, comp == null ? null : meta.comparison.name, "Area (m\u00b2)", false, "Magnitude", false, exec, futures);
        table.addColumn("![Mag/Area](" + relPathToResources + "/" + plot.getName() + ")");
        plot = RuptureScalingPlot.plot(resourcesDir, "mag_log_area_scaling", " ", primary.magAreas, meta.primary.name, comp == null ? null : comp.magAreas, comp == null ? null : meta.comparison.name, "Area (m\u00b2)", true, "Magnitude", false, exec, futures);
        table.addColumn("![Mag/Area](" + relPathToResources + "/" + plot.getName() + ")");
        table.finalizeLine();
        if (primary.magLengths != null) {
            table.initNewLine();
            plot = RuptureScalingPlot.plot(resourcesDir, "mag_length_scaling", " ", primary.magLengths, meta.primary.name, comp == null ? null : comp.magLengths, comp == null ? null : meta.comparison.name, "Length (m)", false, "Magnitude", false, exec, futures);
            table.addColumn("![Mag/Length](" + relPathToResources + "/" + plot.getName() + ")");
            plot = RuptureScalingPlot.plot(resourcesDir, "mag_log_length_scaling", " ", primary.magLengths, meta.primary.name, comp == null ? null : comp.magLengths, comp == null ? null : meta.comparison.name, "Length (m)", true, "Magnitude", false, exec, futures);
            table.addColumn("![Mag/Length](" + relPathToResources + "/" + plot.getName() + ")");
            table.finalizeLine();
        }
        lines.addAll(table.build());
        lines.add("");
        if (hasSlips) {
            lines.add(this.getSubHeading() + " Slip Scaling");
            lines.add(topLink);
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.addLine("Linear Plots", "Log10 Plots");
            table.initNewLine();
            plot = RuptureScalingPlot.plot(resourcesDir, "slip_area_scaling", " ", primary.slipAreas, meta.primary.name, comp == null ? null : comp.slipAreas, comp == null ? null : meta.comparison.name, "Area (km\u00b2)", false, "Slip (m)", false, exec, futures);
            table.addColumn("![Slip/Area](" + relPathToResources + "/" + plot.getName() + ")");
            plot = RuptureScalingPlot.plot(resourcesDir, "slip_log_area_scaling", " ", primary.slipAreas, meta.primary.name, comp == null ? null : comp.slipAreas, comp == null ? null : meta.comparison.name, "Area (km\u00b2)", true, "Slip (m)", false, exec, futures);
            table.addColumn("![Slip/Area](" + relPathToResources + "/" + plot.getName() + ")");
            table.finalizeLine();
            if (primary.slipLengths != null) {
                table.initNewLine();
                plot = RuptureScalingPlot.plot(resourcesDir, "slip_length_scaling", " ", primary.slipLengths, meta.primary.name, comp == null ? null : comp.slipLengths, comp == null ? null : meta.comparison.name, "Length (km)", false, "Slip (m)", false, exec, futures);
                table.addColumn("![Slip/Length](" + relPathToResources + "/" + plot.getName() + ")");
                plot = RuptureScalingPlot.plot(resourcesDir, "slip_log_length_scaling", " ", primary.slipLengths, meta.primary.name, comp == null ? null : comp.slipLengths, comp == null ? null : meta.comparison.name, "Length (km)", true, "Slip (m)", false, exec, futures);
                table.addColumn("![Slip/Length](" + relPathToResources + "/" + plot.getName() + ")");
                table.finalizeLine();
            }
            table.initNewLine();
            plot = RuptureScalingPlot.plot(resourcesDir, "slip_mag_scaling", " ", primary.slipMags, meta.primary.name, comp == null ? null : comp.slipMags, comp == null ? null : meta.comparison.name, "Magnitude", false, "Slip (m)", false, exec, futures);
            table.addColumn("![Slip/Mag](" + relPathToResources + "/" + plot.getName() + ")");
            plot = RuptureScalingPlot.plot(resourcesDir, "log_slip_mag_scaling", " ", primary.slipMags, meta.primary.name, comp == null ? null : comp.slipMags, comp == null ? null : meta.comparison.name, "Magnitude", false, "Slip (m)", true, exec, futures);
            table.addColumn("![Slip/Mag](" + relPathToResources + "/" + plot.getName() + ")");
            table.finalizeLine();
            lines.addAll(table.build());
            lines.add("");
        }
        if (futures != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
            exec.shutdown();
        }
        return lines;
    }

    static File plot(File resourcesDir, String prefix, String title, XY_DataSet scatter, String name, XY_DataSet compScatter, String compName, String xAxisLabel, boolean xLog, String yAxisLabel, boolean yLog, ExecutorService exec, List<Future<?>> futures) throws IOException {
        return RuptureScalingPlot.plot(resourcesDir, prefix, title, scatter, name, compScatter, compName, xAxisLabel, xLog, yAxisLabel, yLog, null, exec, futures);
    }

    static File plot(final File resourcesDir, final String prefix, String title, XY_DataSet scatter, String name, XY_DataSet compScatter, String compName, String xAxisLabel, final boolean xLog, String yAxisLabel, final boolean yLog, DiscretizedFunc meanFunc, ExecutorService exec, List<Future<?>> futures) throws IOException {
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        PlotSymbol symbol = PlotSymbol.CROSS;
        float thickness = 3.0f;
        float legendThickness = 5.0f;
        funcs.add(scatter);
        chars.add(new PlotCurveCharacterstics(symbol, thickness, RuptureScalingPlot.color(scatter.size(), MAIN_COLOR)));
        if (compScatter != null) {
            funcs.add(compScatter);
            chars.add(new PlotCurveCharacterstics(symbol, thickness, RuptureScalingPlot.color(compScatter.size(), COMP_COLOR)));
        }
        if (meanFunc != null) {
            if (name == null) {
                meanFunc.setName("Mean");
            } else {
                meanFunc.setName(name + " Mean");
            }
            funcs.add(meanFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, MAIN_COLOR));
        }
        double minX = Double.POSITIVE_INFINITY;
        double maxX = 0.0;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = 0.0;
        for (XY_DataSet func : funcs) {
            maxX = Math.max(maxX, func.getMaxX());
            maxY = Math.max(maxY, func.getMaxY());
            if (xLog) {
                for (Point2D pt : func) {
                    if (!(pt.getX() > 0.0)) continue;
                    minX = Math.min(minX, pt.getX());
                }
            } else {
                minX = Math.min(minX, func.getMinX());
            }
            if (yLog) {
                for (Point2D pt : func) {
                    if (!(pt.getY() > 0.0)) continue;
                    minY = Math.min(minY, pt.getY());
                }
                continue;
            }
            minY = Math.min(minY, func.getMinY());
        }
        Preconditions.checkState((minX < maxX ? 1 : 0) != 0, (String)"minX=%s >= maxX=%s for plot %s", (Object)minX, (Object)maxX, (Object)prefix);
        Preconditions.checkState((minY < maxY ? 1 : 0) != 0, (String)"minY=%s >= maxY=%s for plot %s", (Object)minY, (Object)maxY, (Object)prefix);
        final Range xRange = RuptureScalingPlot.cleanRange(minX, maxX, xLog);
        final Range yRange = RuptureScalingPlot.cleanRange(minY, maxY, yLog);
        if (compScatter != null) {
            DefaultXY_DataSet fakeXY;
            if (name != null) {
                fakeXY = new DefaultXY_DataSet();
                fakeXY.setName(name);
                fakeXY.set(xRange.getLowerBound() - 10.0, yRange.getLowerBound() - 10.0);
                funcs.add(0, fakeXY);
                chars.add(0, new PlotCurveCharacterstics(symbol, legendThickness, MAIN_COLOR));
            }
            if (compName != null) {
                fakeXY = new DefaultXY_DataSet();
                fakeXY.setName(compName);
                fakeXY.set(xRange.getLowerBound() - 10.0, yRange.getLowerBound() - 10.0);
                funcs.add(0, fakeXY);
                chars.add(0, new PlotCurveCharacterstics(symbol, legendThickness, COMP_COLOR));
            }
        }
        final PlotSpec spec = new PlotSpec(funcs, chars, title, xAxisLabel, yAxisLabel);
        spec.setLegendVisible(compScatter != null);
        Runnable plotRun = new Runnable(){

            @Override
            public void run() {
                HeadlessGraphPanel gp = PlotUtils.initHeadless();
                gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
                gp.drawGraphPanel(spec, xLog, yLog, xRange, yRange);
                try {
                    PlotUtils.writePlots(resourcesDir, prefix, (GraphPanel)gp, 800, 700, true, false, false);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        };
        if (exec == null) {
            plotRun.run();
        } else {
            futures.add(exec.submit(plotRun));
        }
        return new File(resourcesDir, prefix + ".png");
    }

    private static Color color(int num, Color baseColor) {
        int n;
        if (num > 500000) {
            n = 20;
        }
        if (num > 200000) {
            n = 40;
        }
        int alpha = num > 100000 ? 60 : (num > 50000 ? 80 : (num > 20000 ? 120 : (num > 10000 ? 160 : 255)));
        return new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha);
    }

    private static Range cleanRange(double min, double max, boolean log) {
        if (log) {
            return new Range(Math.pow(10.0, Math.floor(Math.log10(min))), Math.pow(10.0, Math.ceil(Math.log10(max))));
        }
        double scalar = max > 1000.0 ? 500.0 : (max > 100.0 ? 50.0 : (max > 20.0 ? 5.0 : (max > 10.0 ? 2.0 : 1.0)));
        max = scalar * Math.ceil(max / scalar);
        min = min == 0.0 ? 0.0 : scalar * Math.floor(min / scalar);
        return new Range(min, max);
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return null;
    }

    public static void main(String[] args) throws IOException {
        FaultSystemRupSet rupSet = FaultSystemRupSet.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2022_08_15-nshm23_u3_hybrid_branches-FM3_1-CoulombRupSet-U3_MEAN-MeanU3Scale-DsrUni-TotNuclRate-SubB1-ThreshAvgIterRelGR/results_FM3_1_CoulombRupSet_branch_averaged.zip"));
        FaultSystemRupSet compRupSet = FaultSystemRupSet.load(new File("/home/kevin/OpenSHA/UCERF4/batch_inversions/2022_08_15-nshm23_branches-NSHM23_v2-CoulombRupSet-AVERAGE-NSHM23_Avg-TotNuclRate-SubB1-ThreshAvgIterRelGR/results_NSHM23_v2_CoulombRupSet_branch_averaged.zip"));
        ReportMetadata meta = compRupSet == null ? new ReportMetadata(new RupSetMetadata("Rupture Set", rupSet)) : new ReportMetadata(new RupSetMetadata("Rupture Set", rupSet), new RupSetMetadata("Comparison Rup Set", compRupSet));
        ReportPageGen pageGen = new ReportPageGen(meta, new File("/tmp/test_plot"), List.of(new RuptureScalingPlot()));
        pageGen.setReplot(true);
        pageGen.generatePage();
    }

    private static class Scatters {
        private DefaultXY_DataSet magAreas;
        private DefaultXY_DataSet magLengths;
        private DefaultXY_DataSet slipAreas;
        private DefaultXY_DataSet slipLengths;
        private DefaultXY_DataSet slipMags;

        public Scatters(FaultSystemRupSet rupSet) {
            double[] mags = rupSet.getMagForAllRups();
            double[] areas = rupSet.getAreaForAllRups();
            double[] lengths = rupSet.getLengthForAllRups();
            this.magAreas = new DefaultXY_DataSet();
            this.magLengths = lengths == null ? null : new DefaultXY_DataSet();
            AveSlipModule aveSlips = rupSet.getModule(AveSlipModule.class);
            this.slipAreas = aveSlips == null ? null : new DefaultXY_DataSet();
            this.slipLengths = aveSlips == null || lengths == null ? null : new DefaultXY_DataSet();
            this.slipMags = aveSlips == null ? null : new DefaultXY_DataSet();
            for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
                this.magAreas.set(areas[r] * 1.0E-6, mags[r]);
                if (this.magLengths != null) {
                    this.magLengths.set(lengths[r] * 0.001, mags[r]);
                }
                if (aveSlips == null) continue;
                double aveSlip = aveSlips.getAveSlip(r);
                this.slipAreas.set(areas[r] * 1.0E-6, aveSlip);
                if (this.slipLengths != null) {
                    this.slipLengths.set(lengths[r] * 0.001, aveSlip);
                }
                this.slipMags.set(mags[r], aveSlip);
            }
        }
    }
}

