/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.reports.plots;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.jfree.data.Range;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.gui.plot.GraphPanel;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.PlotUtils;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SlipAlongRuptureModel;
import org.opensha.sha.earthquake.faultSysSolution.reports.AbstractRupSetPlot;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportMetadata;
import org.opensha.sha.earthquake.faultSysSolution.reports.ReportPageGen;
import org.opensha.sha.earthquake.faultSysSolution.reports.SolidFillPlot;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RupSetMapMaker;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.GeoJSONFaultSection;

public class SlipRatePlots
extends AbstractRupSetPlot
implements SolidFillPlot {
    boolean fillSurfaces = false;

    @Override
    public void setFillSurfaces(boolean fillSurfaces) {
        this.fillSurfaces = fillSurfaces;
    }

    @Override
    public String getName() {
        return "Slip Rates";
    }

    @Override
    public List<String> plot(FaultSystemRupSet rupSet, FaultSystemSolution sol, ReportMetadata meta, File resourcesDir, String relPathToResources, String topLink) throws IOException {
        boolean bl;
        RupSetMapMaker mapMaker = new RupSetMapMaker(rupSet, meta.region);
        mapMaker.setWriteGeoJSON(true);
        mapMaker.setFillSurfaces(this.fillSurfaces);
        ArrayList<String> lines = new ArrayList<String>();
        String rawPrefix = "slip_rates";
        double[] nonReduced = SlipRatePlots.nonReduced(rupSet);
        double maxSlip = StatUtils.max((double[])nonReduced);
        double[] origReduced = SlipRatePlots.origReduced(rupSet);
        double[] solRates = null;
        SectSlipRates slipRates = rupSet.getModule(SectSlipRates.class);
        double[] targets = null;
        if (slipRates != null) {
            targets = SlipRatePlots.target(rupSet, slipRates);
        }
        for (boolean log : new boolean[]{false, true}) {
            Object prefix;
            CPT slipCPT;
            String labelPrefix = "";
            if (log) {
                if (!lines.isEmpty()) {
                    lines.add("");
                }
                lines.add(this.getSubHeading() + " Log10 Slip Rate Plots");
                slipCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(-3.0, 2.0);
                slipCPT.setBelowMinColor(slipCPT.getMinColor());
                slipCPT.setAboveMaxColor(slipCPT.getMaxColor());
                slipCPT.setNanColor(Color.GRAY);
                prefix = rawPrefix + "_log";
                labelPrefix = "Log10 ";
            } else {
                lines.add(this.getSubHeading() + " Linear Slip Rate Plots");
                slipCPT = SlipRatePlots.linearSlipCPT(maxSlip);
                prefix = rawPrefix;
            }
            lines.add(topLink);
            lines.add("");
            MarkdownUtils.TableBuilder tableBuilder = MarkdownUtils.tableBuilder();
            tableBuilder.initNewLine();
            mapMaker.plotSectScalars(log ? SlipRatePlots.log10(nonReduced) : nonReduced, slipCPT, labelPrefix + "Original (non-reduced) Slip Rate (mm/yr)");
            mapMaker.plot(resourcesDir, (String)prefix + "_orig", " ");
            tableBuilder.addColumn("![Map](" + relPathToResources + "/" + (String)prefix + "_orig.png)");
            mapMaker.plotSectScalars(log ? SlipRatePlots.log10(origReduced) : origReduced, slipCPT, labelPrefix + "Creep Reduced Slip Rate (mm/yr)");
            mapMaker.plot(resourcesDir, (String)prefix + "_reduced", " ");
            tableBuilder.addColumn("![Map](" + relPathToResources + "/" + (String)prefix + "_reduced.png)");
            tableBuilder.finalizeLine();
            tableBuilder.initNewLine();
            tableBuilder.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_orig.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_orig.geojson)");
            tableBuilder.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_reduced.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_reduced.geojson)");
            tableBuilder.finalizeLine();
            if (rupSet.hasModule(SectSlipRates.class) || sol != null) {
                tableBuilder.initNewLine();
                if (slipRates != null) {
                    mapMaker.plotSectScalars(log ? SlipRatePlots.log10(targets) : targets, slipCPT, labelPrefix + "Target Slip Rate (mm/yr)");
                    mapMaker.plot(resourcesDir, (String)prefix + "_target", " ");
                    tableBuilder.addColumn("![Map](" + relPathToResources + "/" + (String)prefix + "_target.png)");
                } else {
                    tableBuilder.addColumn("_(no target slip rates found)_");
                }
                if (sol != null) {
                    solRates = SlipRatePlots.solution(sol);
                    mapMaker.plotSectScalars(log ? SlipRatePlots.log10(solRates) : solRates, slipCPT, labelPrefix + "Solution Slip Rate (mm/yr)");
                    mapMaker.plot(resourcesDir, (String)prefix + "_sol", " ");
                    tableBuilder.addColumn("![Map](" + relPathToResources + "/" + (String)prefix + "_sol.png)");
                } else {
                    tableBuilder.addColumn("");
                }
                tableBuilder.finalizeLine();
                tableBuilder.initNewLine();
                if (targets == null) {
                    tableBuilder.addColumn("");
                } else {
                    tableBuilder.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_target.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_target.geojson)");
                }
                if (sol == null) {
                    tableBuilder.addColumn("");
                } else {
                    tableBuilder.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_sol.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_sol.geojson)");
                }
                tableBuilder.finalizeLine();
                if (targets != null && solRates != null) {
                    String ratioLabel;
                    String diffLabel;
                    CPT ratioCPT;
                    CPT diffCPT;
                    if (log) {
                        diffCPT = null;
                        ratioCPT = new CPT(-1.0, 1.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
                    } else {
                        diffCPT = new CPT(-10.0, 10.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
                        diffCPT.setNanColor(Color.GRAY);
                        diffCPT.setBelowMinColor(diffCPT.getMinColor());
                        diffCPT.setAboveMaxColor(diffCPT.getMaxColor());
                        CPT belowCPT = new CPT(0.5, 1.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE);
                        CPT aboveCPT = new CPT(1.0, 2.0, Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
                        ratioCPT = new CPT();
                        ratioCPT.addAll(belowCPT);
                        ratioCPT.addAll(aboveCPT);
                        ratioCPT.setNanColor(Color.GRAY);
                        ratioCPT.setBelowMinColor(ratioCPT.getMinColor());
                        ratioCPT.setAboveMaxColor(ratioCPT.getMaxColor());
                    }
                    tableBuilder.initNewLine();
                    double[] diffs = SlipRatePlots.diff(solRates, targets);
                    double[] ratios = SlipRatePlots.ratio(solRates, targets);
                    if (log) {
                        diffLabel = null;
                        ratioLabel = "Log10(Solution / Target Slip Rate)";
                    } else {
                        diffLabel = "Solution - Target Slip Rate (mm/yr)";
                        ratioLabel = "Solution / Target Slip Rate";
                    }
                    if (!log) {
                        mapMaker.plotSectScalars(diffs, diffCPT, diffLabel);
                        mapMaker.plot(resourcesDir, (String)prefix + "_sol_diff", " ");
                        tableBuilder.addColumn("![Map](" + relPathToResources + "/" + (String)prefix + "_sol_diff.png)");
                    }
                    mapMaker.plotSectScalars(log ? SlipRatePlots.log10(ratios) : ratios, ratioCPT, ratioLabel);
                    mapMaker.plot(resourcesDir, (String)prefix + "_sol_ratio", " ");
                    tableBuilder.addColumn("![Map](" + relPathToResources + "/" + (String)prefix + "_sol_ratio.png)");
                    HeadlessGraphPanel headlessGraphPanel = PlotUtils.initHeadless();
                    if (!log) {
                        tableBuilder.finalizeLine().initNewLine();
                        tableBuilder.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_sol_diff.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_sol_diff.geojson)");
                        tableBuilder.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_sol_ratio.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_sol_ratio.geojson)");
                        tableBuilder.finalizeLine().initNewLine();
                        HistogramFunction diffHist = HistogramFunction.getEncompassingHistogram(-10.0, 10.0, 1.0);
                        for (double diff : diffs) {
                            diffHist.add(diffHist.getClosestXIndex(diff), 1.0);
                        }
                        ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
                        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                        funcs.add(diffHist);
                        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
                        headlessGraphPanel.drawGraphPanel(new PlotSpec(funcs, chars, "Slip Rate Differences", "Solution - Target Slip Rate (mm/yr)", "Count"));
                        PlotUtils.writePlots(resourcesDir, (String)prefix + "_sol_diff_hist", (GraphPanel)headlessGraphPanel, 800, 650, true, true, false);
                        tableBuilder.addColumn("![Diff hist](" + relPathToResources + "/" + (String)prefix + "_sol_diff_hist.png)");
                    }
                    DefaultXY_DataSet scatter = new DefaultXY_DataSet(targets, solRates);
                    Range scatterRange = log ? new Range(0.001, 100.0) : new Range(0.0, Math.max(scatter.getMaxX(), scatter.getMaxY()));
                    ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
                    ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                    funcs.add(scatter);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
                    DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
                    oneToOne.set(scatterRange.getLowerBound(), scatterRange.getLowerBound());
                    oneToOne.set(scatterRange.getUpperBound(), scatterRange.getUpperBound());
                    funcs.add(oneToOne);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.GRAY));
                    headlessGraphPanel.drawGraphPanel(new PlotSpec(funcs, chars, "Slip Rates Scatter", "Target Slip Rate (mm/yr)", "Solution Slip Rate (mm/yr)"), log, log, scatterRange, scatterRange);
                    PlotUtils.writePlots(resourcesDir, (String)prefix + "_sol_scatter", (GraphPanel)headlessGraphPanel, 800, 650, true, true, false);
                    tableBuilder.addColumn("![Diff hist](" + relPathToResources + "/" + (String)prefix + "_sol_scatter.png)");
                    tableBuilder.finalizeLine();
                    if (log) {
                        tableBuilder.initNewLine();
                        tableBuilder.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_sol_ratio.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_sol_ratio.geojson)");
                        tableBuilder.addColumn("");
                        tableBuilder.finalizeLine();
                    }
                }
            }
            lines.addAll(tableBuilder.build());
        }
        boolean hasStdDev = false;
        if (slipRates != null) {
            double[] stdDevs = slipRates.getSlipRateStdDevs();
            for (int s = 0; s < slipRates.size(); ++s) {
                if (!(stdDevs[s] > 0.0)) continue;
                hasStdDev = true;
            }
            if (hasStdDev) {
                CPT relStdDevCPT = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
                relStdDevCPT.setNanColor(Color.GRAY);
                CPT misfitCPT = new CPT(-3.0, 3.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
                misfitCPT.setNanColor(Color.GRAY);
                double[] relStdDevs = new double[stdDevs.length];
                for (int s = 0; s < stdDevs.length; ++s) {
                    relStdDevs[s] = stdDevs[s] / slipRates.getSlipRate(s);
                }
                MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                String relPrefix = rawPrefix + "_rel_std_dev";
                String string = rawPrefix + "_std_dev_misfit";
                mapMaker.plotSectScalars(relStdDevs, relStdDevCPT, "Relative Standard Deviations (COV)");
                mapMaker.plot(resourcesDir, relPrefix, " ");
                table.addColumn("![Map](" + relPathToResources + "/" + relPrefix + ".png)");
                if (sol != null) {
                    double[] solSlips = SlipRatePlots.solution(sol);
                    double[] misfits = new double[stdDevs.length];
                    for (int s = 0; s < misfits.length; ++s) {
                        double target = slipRates.getSlipRate(s);
                        double solSlip = solSlips[s] * 0.001;
                        double stdDev = stdDevs[s];
                        misfits[s] = (solSlip - target) / stdDev;
                    }
                    mapMaker.plotSectScalars(misfits, misfitCPT, "Solution Misfit (Standard Deviations)");
                    mapMaker.plot(resourcesDir, string, " ");
                    table.addColumn("![Map](" + relPathToResources + "/" + string + ".png)");
                }
                table.finalizeLine().initNewLine();
                table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + relPrefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + relPrefix + ".geojson)");
                table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + string + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + string + ".geojson)");
                table.finalizeLine();
                if (meta.hasComparisonSol() && meta.comparisonHasSameSects && meta.comparison.rupSet.hasModule(SectSlipRates.class) && meta.comparison.rupSet.hasModule(SlipAlongRuptureModel.class) && meta.comparison.rupSet.hasModule(AveSlipModule.class)) {
                    relPrefix = relPrefix + "_comp";
                    String string2 = string + "_comp";
                    SectSlipRates compSlips = meta.comparison.rupSet.requireModule(SectSlipRates.class);
                    stdDevs = compSlips.getSlipRateStdDevs();
                    relStdDevs = new double[stdDevs.length];
                    for (int s = 0; s < stdDevs.length; ++s) {
                        relStdDevs[s] = stdDevs[s] / compSlips.getSlipRate(s);
                    }
                    table.initNewLine();
                    mapMaker.plotSectScalars(relStdDevs, relStdDevCPT, "Comparison Relative Standard Deviations");
                    mapMaker.plot(resourcesDir, relPrefix, " ");
                    table.addColumn("![Map](" + relPathToResources + "/" + relPrefix + ".png)");
                    double[] solSlips = SlipRatePlots.solution(meta.comparison.sol);
                    double[] misfits = new double[stdDevs.length];
                    for (int s = 0; s < misfits.length; ++s) {
                        double target = compSlips.getSlipRate(s);
                        double d = solSlips[s] * 0.001;
                        double stdDev = stdDevs[s];
                        misfits[s] = (d - target) / stdDev;
                    }
                    mapMaker.plotSectScalars(misfits, misfitCPT, "Comparison Solution Misfit (Standard Deviations)");
                    mapMaker.plot(resourcesDir, string2, " ");
                    table.addColumn("![Map](" + relPathToResources + "/" + string2 + ".png)");
                    table.finalizeLine().initNewLine();
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + relPrefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + relPrefix + ".geojson)");
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + string2 + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + string2 + ".geojson)");
                    table.finalizeLine();
                }
                lines.add("");
                lines.add(this.getSubHeading() + " Slip Rate Std Dev Plots");
                lines.add(topLink);
                lines.add("");
                lines.addAll(table.build());
            }
        }
        boolean doComp = meta.comparison != null && meta.comparisonHasSameSects && this.getPlotLevel() != ReportPageGen.PlotLevel.LIGHT;
        SectSlipRates compSlipRates = null;
        double[] compTargets = null;
        if (doComp) {
            compSlipRates = meta.comparison.rupSet.getModule(SectSlipRates.class);
            if (compSlipRates != null) {
                compTargets = SlipRatePlots.target(meta.comparison.rupSet, compSlipRates);
            }
            if (!meta.hasPrimarySol() || !meta.hasComparisonSol()) {
                if (targets == null || compTargets == null) {
                    doComp = false;
                } else {
                    boolean allSame = true;
                    for (int s = 0; allSame && s < targets.length; ++s) {
                        allSame = !Double.isFinite(targets[s]) ? !Double.isFinite(compTargets[s]) : (float)targets[s] == (float)compTargets[s];
                    }
                    boolean bl2 = doComp = !allSame;
                }
            }
        }
        if (doComp) {
            double[] compSolRates = null;
            if (solRates != null && meta.hasComparisonSol()) {
                compSolRates = SlipRatePlots.solution(meta.comparison.sol);
            }
            boolean[] isTargets = solRates != null && compSolRates != null ? new boolean[]{true, false} : new boolean[]{false};
            boolean[] isLogs = new boolean[]{false, true};
            for (boolean isTarget : isTargets) {
                double[] myComparison;
                double[] myPrimary;
                if (isTarget) {
                    lines.add(this.getSubHeading() + " Comparison Model Target Slip Rates");
                    lines.add(topLink);
                    lines.add("");
                    myPrimary = targets;
                    myComparison = compTargets;
                } else {
                    lines.add(this.getSubHeading() + " Comparison Model Solution Slip Rates");
                    lines.add(topLink);
                    lines.add("");
                    myPrimary = solRates;
                    myComparison = compSolRates;
                }
                MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
                for (boolean log : isLogs) {
                    String myYLabel;
                    String myXLabel;
                    String ratioLabel;
                    String diffLabel;
                    CPT ratioCPT;
                    CPT diffCPT;
                    Object prefix = rawPrefix;
                    prefix = isTarget ? (String)prefix + "_target" : (String)prefix + "_solution";
                    prefix = (String)prefix + "_comp";
                    if (log) {
                        prefix = (String)prefix + "_log";
                    }
                    if (log) {
                        diffCPT = null;
                        ratioCPT = new CPT(-1.0, 1.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
                    } else {
                        diffCPT = new CPT(-10.0, 10.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
                        diffCPT.setNanColor(Color.GRAY);
                        diffCPT.setBelowMinColor(diffCPT.getMinColor());
                        diffCPT.setAboveMaxColor(diffCPT.getMaxColor());
                        CPT belowCPT = new CPT(0.5, 1.0, new Color(0, 0, 140), new Color(0, 60, 200), new Color(0, 120, 255), Color.WHITE);
                        CPT aboveCPT = new CPT(1.0, 2.0, Color.WHITE, new Color(255, 120, 0), new Color(200, 60, 0), new Color(140, 0, 0));
                        ratioCPT = new CPT();
                        ratioCPT.addAll(belowCPT);
                        ratioCPT.addAll(aboveCPT);
                        ratioCPT.setNanColor(Color.GRAY);
                        ratioCPT.setBelowMinColor(ratioCPT.getMinColor());
                        ratioCPT.setAboveMaxColor(ratioCPT.getMaxColor());
                    }
                    table.initNewLine();
                    double[] diffs = SlipRatePlots.diff(myPrimary, myComparison);
                    double[] ratios = SlipRatePlots.ratio(myPrimary, myComparison);
                    if (isTarget) {
                        if (log) {
                            diffLabel = null;
                            ratioLabel = "Log10(Primary Target / Comparison Target Slip Rate)";
                        } else {
                            diffLabel = "Primary Target - Comparison Target Slip Rate (mm/yr)";
                            ratioLabel = "Primary Target / Comparison Target Slip Rate";
                        }
                    } else if (log) {
                        diffLabel = null;
                        ratioLabel = "Log10(Primary Solution / Comparison Solution Slip Rate)";
                    } else {
                        diffLabel = "Primary Solution - Comparison Solution Slip Rate (mm/yr)";
                        ratioLabel = "Primary Solution / Comparison Solution Slip Rate";
                    }
                    if (!log) {
                        mapMaker.plotSectScalars(diffs, diffCPT, diffLabel);
                        mapMaker.plot(resourcesDir, (String)prefix + "_diff", " ");
                        table.addColumn("![Map](" + relPathToResources + "/" + (String)prefix + "_diff.png)");
                    }
                    mapMaker.plotSectScalars(log ? SlipRatePlots.log10(ratios) : ratios, ratioCPT, ratioLabel);
                    mapMaker.plot(resourcesDir, (String)prefix + "_ratio", " ");
                    table.addColumn("![Map](" + relPathToResources + "/" + (String)prefix + "_ratio.png)");
                    HeadlessGraphPanel gp = PlotUtils.initHeadless();
                    if (!log) {
                        String myXLabel2;
                        String myTitle;
                        table.finalizeLine().initNewLine();
                        table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_diff.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_diff.geojson)");
                        table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_ratio.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_ratio.geojson)");
                        table.finalizeLine().initNewLine();
                        HistogramFunction diffHist = HistogramFunction.getEncompassingHistogram(-10.0, 10.0, 1.0);
                        for (double diff : diffs) {
                            diffHist.add(diffHist.getClosestXIndex(diff), 1.0);
                        }
                        ArrayList<HistogramFunction> funcs = new ArrayList<HistogramFunction>();
                        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                        funcs.add(diffHist);
                        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
                        if (isTarget) {
                            myTitle = "Comparison Target Slip Rate Differences";
                            String myXLabel22 = "Primary Target - Comparison Target Slip Rate (mm/yr)";
                        } else {
                            myTitle = "Comparison Solution Slip Rate Differences";
                            myXLabel2 = "Primary Solution - Comparison Solution Slip Rate (mm/yr)";
                        }
                        gp.drawGraphPanel(new PlotSpec(funcs, chars, myTitle, myXLabel2, "Count"));
                        PlotUtils.writePlots(resourcesDir, (String)prefix + "_diff_hist", (GraphPanel)gp, 800, 650, true, true, false);
                        table.addColumn("![Diff hist](" + relPathToResources + "/" + (String)prefix + "_diff_hist.png)");
                    }
                    DefaultXY_DataSet scatter = new DefaultXY_DataSet(myComparison, myPrimary);
                    Range scatterRange = log ? new Range(0.001, 100.0) : new Range(0.0, Math.max(scatter.getMaxX(), scatter.getMaxY()));
                    ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
                    ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                    funcs.add(scatter);
                    chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLACK));
                    DefaultXY_DataSet oneToOne = new DefaultXY_DataSet();
                    oneToOne.set(scatterRange.getLowerBound(), scatterRange.getLowerBound());
                    oneToOne.set(scatterRange.getUpperBound(), scatterRange.getUpperBound());
                    funcs.add(oneToOne);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.GRAY));
                    if (isTarget) {
                        myXLabel = "Comparison Target Slip Rate (mm/yr)";
                        myYLabel = "Primary Target Slip Rate (mm/yr)";
                    } else {
                        myXLabel = "Comparison Solution Slip Rate (mm/yr)";
                        myYLabel = "Primary Solution Slip Rate (mm/yr)";
                    }
                    gp.drawGraphPanel(new PlotSpec(funcs, chars, "Slip Rates Scatter", myXLabel, myYLabel), log, log, scatterRange, scatterRange);
                    PlotUtils.writePlots(resourcesDir, (String)prefix + "_scatter", (GraphPanel)gp, 800, 650, true, true, false);
                    table.addColumn("![Diff hist](" + relPathToResources + "/" + (String)prefix + "_scatter.png)");
                    table.finalizeLine();
                    if (!log) continue;
                    table.initNewLine();
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + (String)prefix + "_ratio.geojson") + " [Download GeoJSON](" + relPathToResources + "/" + (String)prefix + "_ratio.geojson)");
                    table.addColumn("");
                    table.finalizeLine();
                }
                lines.addAll(table.build());
                lines.add("");
            }
        }
        boolean hasAseis = false;
        boolean hasCoupling = false;
        boolean hasSubSeis = false;
        boolean bl3 = false;
        SectSlipRates slips = rupSet.getModule(SectSlipRates.class);
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            FaultSection sect = rupSet.getFaultSectionData(s);
            hasAseis = hasAseis || (float)sect.getAseismicSlipFactor() > 0.0f;
            boolean bl4 = hasCoupling = hasCoupling || (float)sect.getCouplingCoeff() < 1.0f;
            if (slips != null) {
                hasSubSeis = hasSubSeis || (float)sect.getReducedAveSlipRate() > (float)slips.getSlipRate(s);
            }
            bl = bl || sect instanceof GeoJSONFaultSection && ((GeoJSONFaultSection)sect).getProperty("CreepRate", Double.NaN) >= 0.0;
        }
        if (hasAseis || hasCoupling || hasSubSeis) {
            CPT cpt;
            ArrayList<CallSite> compPlotPrefixes;
            lines.add("");
            lines.add(this.getSubHeading() + " Slip Rate & Area Reductions");
            lines.add(topLink);
            lines.add("");
            ArrayList<String> plotHeadings = new ArrayList<String>();
            ArrayList<CallSite> plotPrefixes = new ArrayList<CallSite>();
            ArrayList<CallSite> arrayList = compPlotPrefixes = meta.comparisonHasSameSects ? new ArrayList<CallSite>() : null;
            if (bl) {
                double[] creepRates = SlipRatePlots.creep(rupSet);
                double max = 10.0;
                for (double creepRate : creepRates) {
                    if (!Double.isFinite(creepRate)) continue;
                    max = Math.max(max, creepRate);
                }
                CPT cpt2 = SlipRatePlots.linearSlipCPT(max);
                String prefix = rawPrefix + "_creep";
                plotHeadings.add("Creep Rates");
                mapMaker.plotSectScalars(creepRates, cpt2, "Creep Rate (mm/yr)");
                mapMaker.plot(resourcesDir, prefix, " ");
                plotPrefixes.add((CallSite)((Object)prefix));
                if (meta.comparisonHasSameSects) {
                    mapMaker.plotSectScalars(SlipRatePlots.creep(meta.comparison.rupSet), cpt2, "Creep Rate (mm/yr)");
                    mapMaker.plot(resourcesDir, prefix + "_comp", " ");
                    compPlotPrefixes.add((CallSite)((Object)(prefix + "_comp")));
                }
            }
            if (hasAseis) {
                cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
                String prefix = rawPrefix + "_aseis";
                plotHeadings.add("Aseismic Slip Factors");
                mapMaker.plotSectScalars(SlipRatePlots.aseis(rupSet), cpt, "Aseismic Slip Factor");
                mapMaker.plot(resourcesDir, prefix, " ");
                plotPrefixes.add((CallSite)((Object)prefix));
                if (meta.comparisonHasSameSects) {
                    mapMaker.plotSectScalars(SlipRatePlots.aseis(meta.comparison.rupSet), cpt, "Aseismic Slip Factor");
                    mapMaker.plot(resourcesDir, prefix + "_comp", " ");
                    compPlotPrefixes.add((CallSite)((Object)(prefix + "_comp")));
                }
            }
            if (hasCoupling) {
                cpt = GMT_CPT_Files.BLACK_RED_YELLOW_UNIFORM.instance().rescale(0.0, 1.0);
                String prefix = rawPrefix + "_coupling";
                plotHeadings.add("Coupling Coefficients");
                mapMaker.setReverseSort(true);
                mapMaker.plotSectScalars(SlipRatePlots.coupling(rupSet), cpt, "Coupling Coefficient");
                mapMaker.plot(resourcesDir, prefix, " ");
                plotPrefixes.add((CallSite)((Object)prefix));
                if (meta.comparisonHasSameSects) {
                    mapMaker.plotSectScalars(SlipRatePlots.coupling(meta.comparison.rupSet), cpt, "Coupling Coefficient");
                    mapMaker.plot(resourcesDir, prefix + "_comp", " ");
                    compPlotPrefixes.add((CallSite)((Object)(prefix + "_comp")));
                }
                mapMaker.setReverseSort(false);
            }
            if (hasSubSeis) {
                cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance().rescale(0.0, 1.0);
                String prefix = rawPrefix + "_sub_seis_red";
                plotHeadings.add("Subseismogenic Reduction Factors");
                mapMaker.plotSectScalars(SlipRatePlots.subSeisReduction(rupSet, rupSet.getModule(SectSlipRates.class)), cpt, "Subseismogenic Reduction Factor");
                mapMaker.plot(resourcesDir, prefix, " ");
                plotPrefixes.add((CallSite)((Object)prefix));
                if (meta.comparisonHasSameSects) {
                    mapMaker.plotSectScalars(SlipRatePlots.subSeisReduction(meta.comparison.rupSet, meta.comparison.rupSet.getModule(SectSlipRates.class)), cpt, "Subseismogenic Reduction Factor");
                    mapMaker.plot(resourcesDir, prefix + "_comp", " ");
                    compPlotPrefixes.add((CallSite)((Object)(prefix + "_comp")));
                }
            }
            MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
            if (meta.comparisonHasSameSects) {
                for (int i = 0; i < plotHeadings.size(); ++i) {
                    table.initNewLine();
                    String string = (String)plotHeadings.get(i);
                    table.addColumn(MarkdownUtils.boldCentered("Primary " + string));
                    table.addColumn(MarkdownUtils.boldCentered("Comparison " + string));
                    table.finalizeLine().initNewLine();
                    String prefix = (String)plotPrefixes.get(i);
                    String compPrefix = (String)compPlotPrefixes.get(i);
                    table.addColumn("![Map](" + relPathToResources + "/" + prefix + ".png)");
                    table.addColumn("![Map](" + relPathToResources + "/" + compPrefix + ".png)");
                    table.finalizeLine().initNewLine();
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + prefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + prefix + ".geojson)");
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + compPrefix + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + compPrefix + ".geojson)");
                    table.finalizeLine();
                }
            } else {
                table.initNewLine();
                for (String string : plotHeadings) {
                    table.addColumn(MarkdownUtils.boldCentered(string));
                }
                table.finalizeLine().initNewLine();
                for (String string : plotPrefixes) {
                    table.addColumn("![Map](" + relPathToResources + "/" + string + ".png)");
                }
                table.finalizeLine().initNewLine();
                for (String string : plotPrefixes) {
                    table.addColumn(RupSetMapMaker.getGeoJSONViewerRelativeLink("View GeoJSON", relPathToResources + "/" + string + ".geojson") + " [Download GeoJSON](" + relPathToResources + "/" + string + ".geojson)");
                }
                table.finalizeLine();
                table = table.wrap(2, 0);
            }
            lines.addAll(table.build());
        }
        ArrayList<String> header = new ArrayList<String>();
        header.add("Section Index");
        header.add("Section Name");
        header.add("Original (non-reduced) Slip Rate (mm/yr)");
        header.add("Creep-Reduced Slip Rate (mm/yr)");
        if (targets != null) {
            header.add("Target Slip Rate (mm/yr)");
            if (hasStdDev) {
                header.add("Target Slip Rate Std. Dev. (mm/yr)");
            }
        }
        if (sol != null) {
            header.add("Solution Slip Rate (mm/yr)");
            if (targets != null) {
                header.add("Solution - Target, Slip Rate Misfit (mm/yr)");
                header.add("Solution / Target, Slip Rate Ratio");
                if (hasStdDev) {
                    header.add("Solution Slip Rate Rate z-score (std. devs.)");
                }
            }
        }
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine((List<String>)header);
        for (int s = 0; s < rupSet.getNumSections(); ++s) {
            ArrayList<Object> line = new ArrayList<Object>();
            line.add("" + s);
            line.add(rupSet.getFaultSectionData(s).getSectionName());
            line.add("" + (float)nonReduced[s]);
            line.add("" + (float)origReduced[s]);
            if (targets != null) {
                line.add("" + (float)targets[s]);
                if (hasStdDev) {
                    line.add("" + (float)(slipRates.getSlipRateStdDev(s) * 1000.0));
                }
            }
            if (sol != null) {
                line.add("" + (float)solRates[s]);
                if (targets != null) {
                    line.add("" + (float)(solRates[s] - targets[s]));
                    line.add("" + (float)(solRates[s] / targets[s]));
                    if (hasStdDev) {
                        double sd = slipRates.getSlipRateStdDev(s) * 1000.0;
                        double z = (solRates[s] - targets[s]) / sd;
                        line.add("" + (float)z);
                    }
                }
            }
            csv.addLine((List<String>)line);
        }
        csv.writeToFile(new File(resourcesDir, rawPrefix + ".csv"));
        ArrayList<Object> csvLines = new ArrayList<Object>();
        csvLines.add("Download CSV file with slip rate data: [" + rawPrefix + ".csv](" + relPathToResources + "/" + rawPrefix + ".csv)");
        csvLines.add("");
        lines.addAll(0, csvLines);
        return lines;
    }

    public static CPT linearSlipCPT(double maxSlip) {
        CPT slipCPT = new CPT();
        slipCPT.setBelowMinColor(Color.GRAY);
        slipCPT.setNanColor(Color.GRAY);
        slipCPT.add(new CPTVal(1.4E-45f, Color.BLUE, 10.0, Color.MAGENTA));
        slipCPT.add(new CPTVal(10.0, Color.MAGENTA, 20.0, Color.RED));
        slipCPT.add(new CPTVal(20.0, Color.RED, 30.0, Color.ORANGE));
        slipCPT.add(new CPTVal(30.0, Color.ORANGE, 40.0, Color.YELLOW));
        slipCPT.setAboveMaxColor(Color.YELLOW);
        if (maxSlip < 10.0) {
            slipCPT = slipCPT.rescale(0.0, 10.0);
        } else if (maxSlip < 20.0) {
            slipCPT = slipCPT.rescale(0.0, 20.0);
        } else if (maxSlip > 60.0) {
            slipCPT = slipCPT.rescale(0.0, 60.0);
        }
        return slipCPT;
    }

    private static double[] nonReduced(FaultSystemRupSet rupSet) {
        double[] slips = new double[rupSet.getNumSections()];
        for (int s = 0; s < slips.length; ++s) {
            slips[s] = rupSet.getFaultSectionData(s).getOrigAveSlipRate();
        }
        return slips;
    }

    private static double[] origReduced(FaultSystemRupSet rupSet) {
        double[] slips = new double[rupSet.getNumSections()];
        for (int s = 0; s < slips.length; ++s) {
            slips[s] = rupSet.getFaultSectionData(s).getReducedAveSlipRate();
        }
        return slips;
    }

    private static double[] target(FaultSystemRupSet rupSet, SectSlipRates slipRates) {
        double[] slips = new double[rupSet.getNumSections()];
        for (int s = 0; s < slips.length; ++s) {
            slips[s] = slipRates.getSlipRate(s) * 1000.0;
        }
        return slips;
    }

    private static double[] aseis(FaultSystemRupSet rupSet) {
        double[] aseis = new double[rupSet.getNumSections()];
        for (int s = 0; s < aseis.length; ++s) {
            aseis[s] = rupSet.getFaultSectionData(s).getAseismicSlipFactor();
        }
        return aseis;
    }

    private static double[] creep(FaultSystemRupSet rupSet) {
        double[] creep = new double[rupSet.getNumSections()];
        for (int s = 0; s < creep.length; ++s) {
            FaultSection sect = rupSet.getFaultSectionData(s);
            creep[s] = sect instanceof GeoJSONFaultSection ? ((GeoJSONFaultSection)sect).getProperties().getDouble("CreepRate", Double.NaN) : Double.NaN;
        }
        return creep;
    }

    private static double[] coupling(FaultSystemRupSet rupSet) {
        double[] coupling = new double[rupSet.getNumSections()];
        for (int s = 0; s < coupling.length; ++s) {
            coupling[s] = rupSet.getFaultSectionData(s).getCouplingCoeff();
        }
        return coupling;
    }

    private static double[] subSeisReduction(FaultSystemRupSet rupSet, SectSlipRates slipRates) {
        double[] subSeisRed = new double[rupSet.getNumSections()];
        if (slipRates == null) {
            return subSeisRed;
        }
        for (int s = 0; s < subSeisRed.length; ++s) {
            double nonReduced = rupSet.getFaultSectionData(s).getReducedAveSlipRate();
            if (!(nonReduced > 0.0)) continue;
            double subSeisReduced = 1000.0 * slipRates.getSlipRate(s);
            subSeisRed[s] = (nonReduced - subSeisReduced) / nonReduced;
        }
        return subSeisRed;
    }

    static double[] solution(FaultSystemSolution sol) {
        FaultSystemRupSet rupSet = sol.getRupSet();
        AveSlipModule aveSlips = rupSet.requireModule(AveSlipModule.class);
        SlipAlongRuptureModel slipAlongs = rupSet.requireModule(SlipAlongRuptureModel.class);
        double[] slips = slipAlongs.calcSlipRateForSects(sol, aveSlips);
        slips = Arrays.copyOf(slips, slips.length);
        int s = 0;
        while (s < slips.length) {
            int n = s++;
            slips[n] = slips[n] * 1000.0;
        }
        return slips;
    }

    private static double[] diff(double[] v1, double[] v2) {
        double[] diff = new double[v1.length];
        for (int i = 0; i < diff.length; ++i) {
            diff[i] = v1[i] - v2[i];
        }
        return diff;
    }

    private static double[] ratio(double[] v1, double[] v2) {
        double[] ratio = new double[v1.length];
        for (int i = 0; i < ratio.length; ++i) {
            ratio[i] = v1[i] / v2[i];
        }
        return ratio;
    }

    private static double[] log10(double[] vals) {
        double[] ret = new double[vals.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Math.log10(vals[i]);
        }
        return ret;
    }

    private static double[] abs(double[] vals) {
        double[] ret = new double[vals.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Math.abs(vals[i]);
        }
        return ret;
    }

    @Override
    public Collection<Class<? extends OpenSHA_Module>> getRequiredModules() {
        return List.of(SlipAlongRuptureModel.class, AveSlipModule.class);
    }
}

