/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensha.commons.util.modules.AverageableModule;
import org.opensha.commons.util.modules.ModuleContainer;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.commons.util.modules.SubModule;
import org.opensha.commons.util.modules.helpers.JSON_BackedModule;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.BranchAverageableModule;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.AspectRatioFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativePenaltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeRakeChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.DirectPathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.MinSectsPerParentFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.NoProxyFaultConnectionsFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.NumClustersFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.RuptureLengthFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.SplayLengthFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.TotalAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.U3CompatibleCumulativeRakeChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.ClusterCoulombCompatibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.NetClusterCoulombFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.NetRuptureCoulombFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.ParentCoulombCompatibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.coulomb.U3CoulombJunctionFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.ClusterCoulombPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.CumulativeProbPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.SectCoulombPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CoulombSectRatioProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeCoulombProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RelativeSlipRateProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.DistCutoffClosestSectClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.UCERF3ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.inversion.coulomb.CoulombRates;
import scratch.UCERF3.inversion.coulomb.CoulombRatesTester;
import scratch.UCERF3.utils.DeformationModelFetcher;

public class PlausibilityConfiguration
implements SubModule<ModuleContainer<OpenSHA_Module>>,
JSON_BackedModule,
BranchAverageableModule<PlausibilityConfiguration> {
    private List<PlausibilityFilter> filters;
    private int maxNumSplays;
    private ClusterConnectionStrategy connectionStrategy;
    private SectionDistanceAzimuthCalculator distAzCalc;
    private static Gson prevGson;
    private static List<? extends FaultSection> prevSubSects;
    public static final String JSON_FILE_NAME = "plausibility.json";
    private ModuleContainer<OpenSHA_Module> parent;

    public static PlausibilityConfiguration getUCERF3(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distAzCalc, FaultModels fm) throws IOException {
        return PlausibilityConfiguration.getUCERF3(subSects, distAzCalc, fm == null ? null : CoulombRates.loadUCERF3CoulombRates(fm));
    }

    public static PlausibilityConfiguration getUCERF3(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distAzCalc, CoulombRates coulombRates) {
        return PlausibilityConfiguration.getUCERF3(subSects, distAzCalc, coulombRates, 5.0);
    }

    public static PlausibilityConfiguration getUCERF3(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distAzCalc, CoulombRates coulombRates, double maxJumpDist) {
        UCERF3ClusterConnectionStrategy connectionStrategy = new UCERF3ClusterConnectionStrategy(subSects, distAzCalc, maxJumpDist, coulombRates);
        return PlausibilityConfiguration.builder((ClusterConnectionStrategy)connectionStrategy, distAzCalc).maxSplays(0).u3All(coulombRates).build();
    }

    private PlausibilityConfiguration() {
    }

    public PlausibilityConfiguration(List<PlausibilityFilter> filters, int maxNumSplays, ClusterConnectionStrategy connectionStrategy, SectionDistanceAzimuthCalculator distAzCalc) {
        this.filters = filters;
        this.maxNumSplays = maxNumSplays;
        this.connectionStrategy = connectionStrategy;
        this.distAzCalc = distAzCalc;
    }

    public List<PlausibilityFilter> getFilters() {
        return this.filters;
    }

    public int getMaxNumSplays() {
        return this.maxNumSplays;
    }

    public ClusterConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public SectionDistanceAzimuthCalculator getDistAzCalc() {
        return this.distAzCalc;
    }

    public static Builder builder(ClusterConnectionStrategy connectionStrategy, SectionDistanceAzimuthCalculator distAzCalc) {
        return new Builder(connectionStrategy, distAzCalc);
    }

    public static Builder builder(ClusterConnectionStrategy connectionStrategy, List<? extends FaultSection> subSects) {
        return new Builder(connectionStrategy, new SectionDistanceAzimuthCalculator(subSects));
    }

    public String toJSON() {
        Gson gson = PlausibilityConfiguration.buildGson(this.connectionStrategy.getSubSections());
        return gson.toJson((Object)this);
    }

    public void writeJSON(File jsonFile) throws IOException {
        Gson gson = PlausibilityConfiguration.buildGson(this.connectionStrategy.getSubSections());
        FileWriter fw = new FileWriter(jsonFile);
        gson.toJson((Object)this, (Appendable)fw);
        fw.write("\n");
        fw.close();
    }

    public static PlausibilityConfiguration readJSON(File jsonFile, List<? extends FaultSection> subSects) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return PlausibilityConfiguration.readJSON(reader, subSects);
    }

    public static PlausibilityConfiguration readJSON(String json, List<? extends FaultSection> subSects) {
        return PlausibilityConfiguration.readJSON(new StringReader(json), subSects);
    }

    public static PlausibilityConfiguration readJSON(Reader json, List<? extends FaultSection> subSects) {
        Gson gson = PlausibilityConfiguration.buildGson(subSects);
        PlausibilityConfiguration conf = (PlausibilityConfiguration)gson.fromJson(json, PlausibilityConfiguration.class);
        try {
            json.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return conf;
    }

    public String filtersToJSON(List<PlausibilityFilter> filters) {
        ArrayList<PlausibilityFilterRecord> records = new ArrayList<PlausibilityFilterRecord>();
        for (PlausibilityFilter filter : filters) {
            records.add(new PlausibilityFilterRecord(filter));
        }
        Gson gson = PlausibilityConfiguration.buildGson(this.connectionStrategy.getSubSections(), this.distAzCalc, this.connectionStrategy);
        return gson.toJson(records);
    }

    public void writeFiltersJSON(File jsonFile) throws IOException {
        ArrayList<PlausibilityFilterRecord> records = new ArrayList<PlausibilityFilterRecord>();
        for (PlausibilityFilter filter : this.filters) {
            records.add(new PlausibilityFilterRecord(filter));
        }
        Gson gson = PlausibilityConfiguration.buildGson(this.connectionStrategy.getSubSections(), this.distAzCalc, this.connectionStrategy);
        FileWriter fw = new FileWriter(jsonFile);
        gson.toJson(records, (Appendable)fw);
        fw.write("\n");
        fw.close();
    }

    public static List<PlausibilityFilter> readFiltersJSON(File jsonFile, ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(jsonFile));
        return PlausibilityConfiguration.readFiltersJSON(reader, connStrat, distAzCalc);
    }

    public static List<PlausibilityFilter> readFiltersJSON(String json, ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
        return PlausibilityConfiguration.readFiltersJSON(new StringReader(json), connStrat, distAzCalc);
    }

    public static List<PlausibilityFilter> readFiltersJSON(Reader json, ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
        Gson gson = PlausibilityConfiguration.buildGson(connStrat.getSubSections(), distAzCalc, connStrat);
        Type listType = new TypeToken<List<PlausibilityFilterRecord>>(){}.getType();
        List records = (List)gson.fromJson(json, listType);
        ArrayList<PlausibilityFilter> filters = new ArrayList<PlausibilityFilter>();
        for (PlausibilityFilterRecord record : records) {
            filters.add(record.filter);
        }
        try {
            json.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return filters;
    }

    private static synchronized Gson buildGson(List<? extends FaultSection> subSects) {
        Gson gson;
        if (prevGson != null && prevSubSects != null && prevSubSects.size() == subSects.size()) {
            boolean match = true;
            for (int s = 0; s < subSects.size(); ++s) {
                FaultSection s1 = subSects.get(s);
                FaultSection s2 = prevSubSects.get(s);
                if (s1.getSectionId() == s2.getSectionId() && s1.getParentSectionId() == s2.getParentSectionId()) continue;
                match = false;
                break;
            }
            if (match) {
                System.out.println("Reusing PlausibilityConfiguration Gson instance");
                return prevGson;
            }
        }
        prevGson = gson = PlausibilityConfiguration.buildGson(subSects, null, null);
        prevSubSects = subSects;
        return gson;
    }

    private static Gson buildGson(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distAzCalc, ClusterConnectionStrategy connStrat) {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        if (distAzCalc == null) {
            distAzCalc = new SectionDistanceAzimuthCalculator(subSects);
        }
        ClusterConnectionStrategy.ConnStratTypeAdapter connStratAdapter = new ClusterConnectionStrategy.ConnStratTypeAdapter(subSects, distAzCalc);
        builder.registerTypeHierarchyAdapter(ClusterConnectionStrategy.class, (Object)connStratAdapter);
        builder.registerTypeHierarchyAdapter(FaultSection.class, (Object)new FaultSectTypeAdapter(subSects));
        DistAzCalcTypeAdapter distAzAdapter = new DistAzCalcTypeAdapter(distAzCalc);
        builder.registerTypeAdapter(SectionDistanceAzimuthCalculator.class, (Object)distAzAdapter);
        PlausibilityConfigTypeAdapter configAdapter = new PlausibilityConfigTypeAdapter(connStratAdapter, distAzAdapter);
        builder.registerTypeAdapter(PlausibilityConfiguration.class, (Object)configAdapter);
        builder.registerTypeAdapter(JumpAzimuthChangeFilter.AzimuthCalc.class, (Object)new JumpAzimuthChangeFilter.AzimuthCalcTypeAdapter(distAzCalc));
        builder.registerTypeAdapter(SubSectStiffnessCalculator.class, (Object)new SubSectStiffnessTypeAdapter(subSects));
        builder.registerTypeAdapter(CoulombRates.class, (Object)new CoulombRates.Adapter());
        PlausibilityFilterAdapter filterAdapter = new PlausibilityFilterAdapter(null, connStrat, distAzCalc);
        builder.registerTypeHierarchyAdapter(PlausibilityFilterRecord.class, (Object)filterAdapter);
        builder.registerTypeAdapter(TypeToken.getParameterized(Range.class, (Type[])new Type[]{Float.class}).getType(), (Object)new FloatRangeTypeAdapter());
        Gson gson = builder.create();
        configAdapter.setGson(gson);
        filterAdapter.setGson(gson);
        return gson;
    }

    private static void skipUntilEndObject(JsonReader in, String startPath) throws IOException {
        while (true) {
            String path = in.getPath();
            JsonToken peek = in.peek();
            if (peek == JsonToken.BEGIN_OBJECT && path.equals(startPath)) {
                in.skipValue();
                break;
            }
            if (peek == JsonToken.END_OBJECT && path.equals(startPath)) break;
            if (peek == JsonToken.END_DOCUMENT) {
                in.close();
                throw new IllegalStateException("Failed to skipUnilEndObject to " + startPath + ", encountered END_DOCUMENT");
            }
            if (peek == JsonToken.END_ARRAY) {
                in.endArray();
                continue;
            }
            if (peek == JsonToken.END_OBJECT) {
                in.endObject();
                continue;
            }
            in.skipValue();
        }
    }

    public static <T> Class<T> getDeclaredTypeClass(String className) throws ClassNotFoundException {
        Class<?> raw = Class.forName(className);
        return raw;
    }

    @Override
    public String getName() {
        return "Plausibility Configuration";
    }

    @Override
    public String getFileName() {
        return JSON_FILE_NAME;
    }

    @Override
    public Gson buildGson() {
        List<? extends FaultSection> subSects;
        if (this.distAzCalc == null) {
            Preconditions.checkNotNull(this.parent, (Object)"Can't [de]serialize plausibility configuration without either first supplying a sub-sections, or a parent module from which we can retrieve them");
            this.distAzCalc = this.parent.getModule(SectionDistanceAzimuthCalculator.class);
            if (this.distAzCalc == null) {
                Preconditions.checkState((boolean)(this.parent instanceof FaultSystemRupSet), (Object)"Can't [de]serialize plausibility configuration without either first supplying sub-sections, or a parent module from which we can retrieve them (a rupture set, or something with a distance-azimuth cache)");
                subSects = ((FaultSystemRupSet)this.parent).getFaultSectionDataList();
            } else {
                subSects = this.distAzCalc.getSubSections();
            }
        } else {
            subSects = this.distAzCalc.getSubSections();
        }
        return PlausibilityConfiguration.buildGson(subSects, this.distAzCalc, this.connectionStrategy);
    }

    @Override
    public void writeToJSON(JsonWriter out, Gson gson) throws IOException {
        gson.toJson((Object)this, PlausibilityConfiguration.class, out);
    }

    @Override
    public void initFromJSON(JsonReader in, Gson gson) throws IOException {
        PlausibilityConfiguration config = (PlausibilityConfiguration)gson.fromJson(in, PlausibilityConfiguration.class);
        this.connectionStrategy = config.connectionStrategy;
        this.distAzCalc = config.distAzCalc;
        this.filters = config.filters;
        this.maxNumSplays = config.maxNumSplays;
    }

    @Override
    public void setParent(ModuleContainer<OpenSHA_Module> parent) throws IllegalStateException {
        this.parent = parent;
    }

    @Override
    public ModuleContainer<OpenSHA_Module> getParent() {
        return this.parent;
    }

    @Override
    public SubModule<ModuleContainer<OpenSHA_Module>> copy(ModuleContainer<OpenSHA_Module> newParent) throws IllegalStateException {
        SectionDistanceAzimuthCalculator distAzCalc = this.distAzCalc;
        if (distAzCalc != null) {
            SectionDistanceAzimuthCalculator oCalc = newParent.getModule(SectionDistanceAzimuthCalculator.class);
            if (oCalc != null) {
                Preconditions.checkState((oCalc.getSubSections().size() == distAzCalc.getSubSections().size() ? 1 : 0) != 0);
                distAzCalc = oCalc;
            } else if (newParent instanceof FaultSystemRupSet) {
                Preconditions.checkState((((FaultSystemRupSet)newParent).getNumSections() == distAzCalc.getSubSections().size() ? 1 : 0) != 0);
            }
        }
        return new PlausibilityConfiguration(this.filters, this.maxNumSplays, this.connectionStrategy, distAzCalc);
    }

    @Override
    public AverageableModule.AveragingAccumulator<PlausibilityConfiguration> averagingAccumulator() {
        return new AverageableModule.AveragingAccumulator<PlausibilityConfiguration>(){
            private PlausibilityConfiguration module;
            private FaultSystemRupSet rupSet;

            @Override
            public void process(PlausibilityConfiguration module, double relWeight) {
                if (this.module == null) {
                    this.module = module;
                    if (module.getParent() instanceof FaultSystemRupSet) {
                        this.rupSet = (FaultSystemRupSet)module.getParent();
                    }
                } else if (this.rupSet != null) {
                    Preconditions.checkState((boolean)this.rupSet.isEquivalentTo((FaultSystemRupSet)module.getParent()));
                }
            }

            @Override
            public PlausibilityConfiguration getAverage() {
                Preconditions.checkNotNull((Object)this.module);
                return this.module;
            }

            @Override
            public Class<PlausibilityConfiguration> getType() {
                return PlausibilityConfiguration.class;
            }
        };
    }

    public static void main(String[] args) throws IOException {
        FaultModels fm = FaultModels.FM3_1;
        DeformationModels dm = fm.getFilterBasis();
        DeformationModelFetcher dmFetch = new DeformationModelFetcher(fm, dm, null, 0.1);
        List<? extends FaultSection> subSects = dmFetch.getSubSectionList();
        SectionDistanceAzimuthCalculator distAzCalc = new SectionDistanceAzimuthCalculator(subSects);
        subSects = subSects.subList(0, 30);
        double maxDist = 50.0;
        DistCutoffClosestSectClusterConnectionStrategy connStrat = new DistCutoffClosestSectClusterConnectionStrategy(subSects, distAzCalc, maxDist);
        Builder builder = PlausibilityConfiguration.builder((ClusterConnectionStrategy)connStrat, distAzCalc);
        SubSectStiffnessCalculator stiffnessCalc = new SubSectStiffnessCalculator(subSects, 2.0, 30000.0, 30000.0, 0.5, SubSectStiffnessCalculator.PatchAlignment.FILL_OVERLAP, 1.0);
        AggregatedStiffnessCalculator medSumAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, false, AggregatedStiffnessCalculator.AggregationMethod.FLATTEN, AggregatedStiffnessCalculator.AggregationMethod.MEDIAN, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        AggregatedStiffnessCalculator sumAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM);
        AggregatedStiffnessCalculator fractRpatchPosAgg = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.PASSTHROUGH, AggregatedStiffnessCalculator.AggregationMethod.RECEIVER_SUM, AggregatedStiffnessCalculator.AggregationMethod.FRACT_POSITIVE);
        builder.cumulativeProbability(0.05f, new RelativeSlipRateProb(connStrat, true, false));
        builder.netRupCoulomb(new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, stiffnessCalc, true, AggregatedStiffnessCalculator.AggregationMethod.NUM_POSITIVE, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.SUM, AggregatedStiffnessCalculator.AggregationMethod.THREE_QUARTER_INTERACTIONS), 0.0f);
        RelativeCoulombProb prefCFFProb = new RelativeCoulombProb(sumAgg, connStrat, false, true, true, 10.0f, distAzCalc);
        CumulativeProbPathEvaluator cffProbPathEval = new CumulativeProbPathEvaluator(0.02f, PlausibilityResult.FAIL_HARD_STOP, prefCFFProb);
        CoulombSectRatioProb cffRatioProb = new CoulombSectRatioProb(sumAgg, 2, true, 10.0f, distAzCalc);
        CumulativeProbPathEvaluator cffRatioProbPathEval = new CumulativeProbPathEvaluator(0.2f, PlausibilityResult.FAIL_HARD_STOP, cffRatioProb);
        builder.path(cffProbPathEval, cffRatioProbPathEval);
        String destFileName = "cur_pref_filters.json";
        PlausibilityConfiguration config = builder.build();
        config.writeFiltersJSON(new File("/home/kevin/OpenSHA/UCERF4/rup_sets/" + destFileName));
        Gson gson = PlausibilityConfiguration.buildGson(subSects);
        String json = gson.toJson((Object)config);
        System.out.println(json);
        System.out.println("Deserializing");
        gson = PlausibilityConfiguration.buildGson(subSects);
        gson.fromJson(json, PlausibilityConfiguration.class);
        System.out.println("Serializing filters only");
        json = config.filtersToJSON(config.getFilters());
        System.out.println("Filters JSON:\n" + json);
        System.out.println("Deserializing filters JSON");
        PlausibilityConfiguration.readFiltersJSON(json, config.getConnectionStrategy(), config.getDistAzCalc());
    }

    public static class Builder {
        private ClusterConnectionStrategy connectionStrategy;
        private SectionDistanceAzimuthCalculator distAzCalc;
        private int maxSplays;
        private List<PlausibilityFilter> filters;

        private Builder(ClusterConnectionStrategy connectionStrategy, SectionDistanceAzimuthCalculator distAzCalc) {
            this.connectionStrategy = connectionStrategy;
            this.distAzCalc = distAzCalc;
            this.maxSplays = 0;
            this.filters = new ArrayList<PlausibilityFilter>();
        }

        public Builder maxSplays(int maxSplays) {
            this.maxSplays = maxSplays;
            return this;
        }

        public Builder add(PlausibilityFilter filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder addAll(Collection<? extends PlausibilityFilter> filters) {
            this.filters.addAll(filters);
            return this;
        }

        public Builder addFirst(PlausibilityFilter filter) {
            this.filters.add(0, filter);
            return this;
        }

        public Builder u3All(CoulombRates coulombRates) {
            this.u3Azimuth();
            this.u3Cumulatives();
            this.minSectsPerParent(2, true, true);
            if (coulombRates != null) {
                this.u3Coulomb(coulombRates);
            }
            return this;
        }

        public Builder u3Azimuth() {
            JumpAzimuthChangeFilter.UCERF3LeftLateralFlipAzimuthCalc u3AzCalc = new JumpAzimuthChangeFilter.UCERF3LeftLateralFlipAzimuthCalc(this.distAzCalc);
            this.filters.add(new JumpAzimuthChangeFilter(u3AzCalc, 60.0f));
            this.filters.add(new TotalAzimuthChangeFilter(u3AzCalc, 60.0f, true, true));
            return this;
        }

        public Builder u3Cumulatives() {
            this.cumulativeAzChange(new JumpAzimuthChangeFilter.SimpleAzimuthCalc(this.distAzCalc), 560.0f);
            this.filters.add(new U3CompatibleCumulativeRakeChangeFilter(180.0));
            return this;
        }

        public Builder u3Coulomb(CoulombRates coulombRates) {
            return this.u3Coulomb(coulombRates, null);
        }

        public Builder u3Coulomb(CoulombRates coulombRates, SubSectStiffnessCalculator fallbackCalc) {
            CoulombRatesTester coulombTester = new CoulombRatesTester(CoulombRatesTester.TestType.COULOMB_STRESS, 0.04, 0.04, 1.25, true, true);
            U3CoulombJunctionFilter filter = new U3CoulombJunctionFilter(coulombTester, coulombRates);
            if (fallbackCalc != null) {
                filter.setFallbackCalculator(fallbackCalc, this.connectionStrategy);
            }
            this.filters.add(filter);
            return this;
        }

        public Builder minSectsPerParent(int minPerParent, boolean allowIfNoDirect, boolean allowChained) {
            this.filters.add(new MinSectsPerParentFilter(minPerParent, allowIfNoDirect, allowChained, this.connectionStrategy));
            return this;
        }

        public Builder noIndirectPaths(boolean onlyLargerDist) {
            this.filters.add(new DirectPathPlausibilityFilter(this.connectionStrategy, onlyLargerDist));
            return this;
        }

        public Builder clusterCoulomb(AggregatedStiffnessCalculator aggCalc, float threshold) {
            this.filters.add(new ClusterCoulombCompatibilityFilter(aggCalc, threshold));
            return this;
        }

        public Builder clusterPathCoulomb(AggregatedStiffnessCalculator aggCalc, float threshold) {
            return this.clusterPathCoulomb(aggCalc, (Range<Float>)Range.atLeast((Comparable)Float.valueOf(threshold)));
        }

        public Builder clusterPathCoulomb(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange) {
            return this.clusterPathCoulomb(aggCalc, acceptableRange, 0.0f, false);
        }

        public Builder clusterPathCoulomb(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange, float fractPathsThreshold, boolean failFuturePossible) {
            PlausibilityResult failureType = failFuturePossible ? PlausibilityResult.FAIL_FUTURE_POSSIBLE : PlausibilityResult.FAIL_HARD_STOP;
            return this.path(fractPathsThreshold, new ClusterCoulombPathEvaluator(aggCalc, acceptableRange, failureType));
        }

        public Builder sectPathCoulomb(AggregatedStiffnessCalculator aggCalc, float threshold) {
            return this.sectPathCoulomb(aggCalc, (Range<Float>)Range.atLeast((Comparable)Float.valueOf(threshold)), false, 0.0f);
        }

        public Builder sectPathCoulomb(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange, boolean jumpToMostFavorable, float maxJumpDist) {
            return this.sectPathCoulomb(aggCalc, acceptableRange, 0.0f, jumpToMostFavorable, maxJumpDist, false);
        }

        public Builder sectPathCoulomb(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange, float fractPassThreshold, boolean jumpToMostFavorable, float maxJumpDist, boolean failFuturePossible) {
            PlausibilityResult failureType = failFuturePossible ? PlausibilityResult.FAIL_FUTURE_POSSIBLE : PlausibilityResult.FAIL_HARD_STOP;
            this.path(fractPassThreshold, new SectCoulombPathEvaluator(aggCalc, acceptableRange, failureType, jumpToMostFavorable, maxJumpDist, this.distAzCalc));
            return this;
        }

        public Builder path(NucleationClusterEvaluator ... evaluators) {
            this.filters.add(new PathPlausibilityFilter(evaluators));
            return this;
        }

        public Builder path(float fractPassThreshold, NucleationClusterEvaluator ... evaluators) {
            this.filters.add(new PathPlausibilityFilter(fractPassThreshold, evaluators));
            return this;
        }

        public Builder path(float fractPassThreshold, boolean logicalOr, NucleationClusterEvaluator ... evaluators) {
            this.filters.add(new PathPlausibilityFilter(fractPassThreshold, logicalOr, evaluators));
            return this;
        }

        public Builder parentCoulomb(AggregatedStiffnessCalculator aggCalc, float threshold, ParentCoulombCompatibilityFilter.Directionality directionality) {
            this.filters.add(new ParentCoulombCompatibilityFilter(aggCalc, threshold, directionality));
            return this;
        }

        public Builder netRupCoulomb(AggregatedStiffnessCalculator aggCalc, float threshold) {
            this.filters.add(new NetRuptureCoulombFilter(aggCalc, threshold));
            return this;
        }

        public Builder netRupCoulomb(AggregatedStiffnessCalculator aggCalc, Range<Float> acceptableRange) {
            this.filters.add(new NetRuptureCoulombFilter(aggCalc, acceptableRange));
            return this;
        }

        public Builder netClusterCoulomb(AggregatedStiffnessCalculator aggCalc, float threshold) {
            this.filters.add(new NetClusterCoulombFilter(aggCalc, threshold));
            return this;
        }

        public Builder cumulativeRakeChange(float threshold) {
            this.filters.add(new CumulativeRakeChangeFilter(threshold));
            return this;
        }

        public Builder noProxyConnections() {
            this.filters.add(new NoProxyFaultConnectionsFilter());
            return this;
        }

        public Builder cumulativeAzChange(float threshold) {
            return this.cumulativeAzChange(new JumpAzimuthChangeFilter.SimpleAzimuthCalc(this.distAzCalc), threshold);
        }

        public Builder cumulativeAzChange(JumpAzimuthChangeFilter.AzimuthCalc azCalc, float threshold) {
            this.filters.add(new CumulativeAzimuthChangeFilter(azCalc, threshold));
            return this;
        }

        public Builder jumpAzChange(JumpAzimuthChangeFilter.AzimuthCalc azCalc, float threshold) {
            this.filters.add(new JumpAzimuthChangeFilter(azCalc, threshold));
            return this;
        }

        public Builder totAzChange(JumpAzimuthChangeFilter.AzimuthCalc azCalc, float threshold, boolean multiFaultOnly, boolean testFullEnd) {
            this.filters.add(new TotalAzimuthChangeFilter(azCalc, threshold, multiFaultOnly, testFullEnd));
            return this;
        }

        public Builder splayLength(double maxLen, boolean isFractOfMain, boolean totalAcrossSplays, boolean allowFullCluster) {
            this.filters.add(new SplayLengthFilter(maxLen, isFractOfMain, totalAcrossSplays, allowFullCluster));
            return this;
        }

        public Builder maxLength(double maxLen) {
            this.filters.add(new RuptureLengthFilter(maxLen));
            return this;
        }

        public Builder cumulativePenalty(float threshold, boolean noDoubleCount, CumulativePenaltyFilter.Penalty ... penalties) {
            this.filters.add(new CumulativePenaltyFilter(threshold, noDoubleCount, penalties));
            return this;
        }

        public Builder cumulativeProbability(float minProbability, RuptureProbabilityCalc ... calcs) {
            this.filters.add(new CumulativeProbabilityFilter(minProbability, calcs));
            return this;
        }

        public Builder maxNumClusters(int maxNumClusters) {
            this.filters.add(new NumClustersFilter(maxNumClusters));
            return this;
        }

        public Builder minAspectRatio(float threshold, boolean allowIfNoDirect, boolean allowChained) {
            this.filters.add(new AspectRatioFilter(threshold, allowIfNoDirect, allowChained, this.connectionStrategy));
            return this;
        }

        public PlausibilityConfiguration build() {
            return new PlausibilityConfiguration(this.filters, this.maxSplays, this.connectionStrategy, this.distAzCalc);
        }
    }

    private static class PlausibilityFilterRecord {
        private final PlausibilityFilter filter;

        public PlausibilityFilterRecord(PlausibilityFilter filter) {
            this.filter = filter;
        }
    }

    private static class FaultSectTypeAdapter
    extends TypeAdapter<FaultSection> {
        private List<? extends FaultSection> subSects;

        public FaultSectTypeAdapter(List<? extends FaultSection> subSects) {
            this.subSects = subSects;
        }

        public void write(JsonWriter out, FaultSection value) throws IOException {
            out.value((long)value.getSectionId());
        }

        public FaultSection read(JsonReader in) throws IOException {
            int id = in.nextInt();
            return this.subSects.get(id);
        }
    }

    private static class DistAzCalcTypeAdapter
    extends TypeAdapter<SectionDistanceAzimuthCalculator> {
        private SectionDistanceAzimuthCalculator distAzCalc;

        public DistAzCalcTypeAdapter(SectionDistanceAzimuthCalculator distAzCalc) {
            Preconditions.checkNotNull((Object)distAzCalc);
            this.distAzCalc = distAzCalc;
        }

        public void write(JsonWriter out, SectionDistanceAzimuthCalculator value) throws IOException {
            if (value == null) {
                if (!out.getSerializeNulls()) {
                    out.setSerializeNulls(true);
                    out.nullValue();
                    out.setSerializeNulls(false);
                } else {
                    out.nullValue();
                }
            } else {
                out.beginObject();
                out.name("numSects").value((long)value.getSubSections().size());
                out.endObject();
            }
        }

        public SectionDistanceAzimuthCalculator read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            in.beginObject();
            in.nextName();
            int numSects = in.nextInt();
            Preconditions.checkState((numSects == this.distAzCalc.getSubSections().size() ? 1 : 0) != 0, (String)"JSON says %s sects, expected %s", (int)numSects, (int)this.distAzCalc.getSubSections().size());
            in.endObject();
            return this.distAzCalc;
        }
    }

    private static class PlausibilityConfigTypeAdapter
    extends TypeAdapter<PlausibilityConfiguration> {
        private ClusterConnectionStrategy.ConnStratTypeAdapter connStratAdapter;
        private DistAzCalcTypeAdapter distAzAdapter;
        private Gson gson;

        public PlausibilityConfigTypeAdapter(ClusterConnectionStrategy.ConnStratTypeAdapter connStratAdapter, DistAzCalcTypeAdapter distAzAdapter) {
            this.connStratAdapter = connStratAdapter;
            this.distAzAdapter = distAzAdapter;
        }

        public void setGson(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, PlausibilityConfiguration config) throws IOException {
            out.beginObject();
            out.name("connectionStrategy");
            this.connStratAdapter.write(out, config.getConnectionStrategy());
            out.name("maxNumSplays").value((long)config.getMaxNumSplays());
            out.name("filters");
            if (config.filters == null) {
                out.nullValue();
            } else {
                out.beginArray();
                PlausibilityFilterAdapter adapter = new PlausibilityFilterAdapter(this.gson, config.getConnectionStrategy(), config.getDistAzCalc());
                for (PlausibilityFilter filter : config.filters) {
                    adapter.write(out, new PlausibilityFilterRecord(filter));
                }
                out.endArray();
            }
            out.endObject();
        }

        public PlausibilityConfiguration read(JsonReader in) throws IOException {
            in.beginObject();
            Integer maxNumSplays = null;
            ClusterConnectionStrategy connectionStrategy = null;
            ArrayList<PlausibilityFilter> filters = null;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "connectionStrategy": {
                        connectionStrategy = this.connStratAdapter.read(in);
                        break;
                    }
                    case "maxNumSplays": {
                        maxNumSplays = in.nextInt();
                        break;
                    }
                    case "filters": {
                        if (in.peek() == JsonToken.NULL) {
                            in.nextNull();
                            break;
                        }
                        Preconditions.checkNotNull((Object)connectionStrategy, (Object)"Connection strategy must be before filters in JSON");
                        PlausibilityFilterAdapter adapter = new PlausibilityFilterAdapter(this.gson, connectionStrategy, this.distAzAdapter.distAzCalc);
                        filters = new ArrayList<PlausibilityFilter>();
                        in.beginArray();
                        while (in.hasNext()) {
                            PlausibilityFilter filter = adapter.read((JsonReader)in).filter;
                            Preconditions.checkNotNull((Object)filter, (Object)"Filter not found in JSON object");
                            filters.add(filter);
                        }
                        in.endArray();
                        break;
                    }
                }
            }
            in.endObject();
            return new PlausibilityConfiguration(filters, maxNumSplays, connectionStrategy, this.distAzAdapter.distAzCalc);
        }
    }

    private static class SubSectStiffnessTypeAdapter
    extends TypeAdapter<SubSectStiffnessCalculator> {
        private List<? extends FaultSection> subSects;
        private SubSectStiffnessCalculator prevCalc;

        public SubSectStiffnessTypeAdapter(List<? extends FaultSection> subSects) {
            this.subSects = subSects;
        }

        public void write(JsonWriter out, SubSectStiffnessCalculator calc) throws IOException {
            out.beginObject();
            out.name("gridSpacing").value(calc.getGridSpacing());
            out.name("lameLambda").value(calc.getLameLambda());
            out.name("lameMu").value(calc.getLameMu());
            out.name("coeffOfFriction").value(calc.getCoeffOfFriction());
            out.name("patchAlignment").value(calc.getPatchAlignment().name());
            out.name("selfStiffnessCap").value(calc.getSelfStiffnessCap());
            out.endObject();
        }

        public SubSectStiffnessCalculator read(JsonReader in) throws IOException {
            SubSectStiffnessCalculator calc;
            in.beginObject();
            Double mu = null;
            Double lambda = null;
            Double coeffOfFriction = null;
            Double gridSpacing = null;
            double selfStiffnessCap = 0.0;
            SubSectStiffnessCalculator.PatchAlignment alignment = SubSectStiffnessCalculator.alignment_default;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "lameMu": {
                        mu = in.nextDouble();
                        break;
                    }
                    case "lameLambda": {
                        lambda = in.nextDouble();
                        break;
                    }
                    case "coeffOfFriction": {
                        coeffOfFriction = in.nextDouble();
                        break;
                    }
                    case "gridSpacing": {
                        gridSpacing = in.nextDouble();
                        break;
                    }
                    case "patchAlignment": {
                        alignment = SubSectStiffnessCalculator.PatchAlignment.valueOf(in.nextString());
                        break;
                    }
                    case "selfStiffnessCap": {
                        selfStiffnessCap = in.nextDouble();
                        break;
                    }
                }
            }
            in.endObject();
            if (this.prevCalc != null && gridSpacing.doubleValue() == this.prevCalc.getGridSpacing() && lambda.doubleValue() == this.prevCalc.getLameLambda() && mu.doubleValue() == this.prevCalc.getLameMu() && coeffOfFriction.doubleValue() == this.prevCalc.getCoeffOfFriction() && selfStiffnessCap == this.prevCalc.getSelfStiffnessCap()) {
                return this.prevCalc;
            }
            this.prevCalc = calc = new SubSectStiffnessCalculator(this.subSects, gridSpacing, lambda, mu, coeffOfFriction, alignment, selfStiffnessCap);
            return calc;
        }
    }

    private static class PlausibilityFilterAdapter
    extends TypeAdapter<PlausibilityFilterRecord> {
        private Gson gson;
        private ClusterConnectionStrategy connStrat;
        private SectionDistanceAzimuthCalculator distAzCalc;

        public PlausibilityFilterAdapter(Gson gson, ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
            this.gson = gson;
            this.connStrat = connStrat;
            this.distAzCalc = distAzCalc;
        }

        public void setGson(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, PlausibilityFilterRecord record) throws IOException {
            out.beginObject();
            PlausibilityFilter filter = record.filter;
            out.name("name").value(filter.getName());
            out.name("shortName").value(filter.getShortName());
            out.name("class").value(filter.getClass().getName());
            TypeAdapter<PlausibilityFilter> adapter = filter.getTypeAdapter();
            if (adapter == null) {
                out.name("filter");
                this.gson.toJson((Object)filter, filter.getClass(), out);
            } else {
                if (adapter instanceof PlausibilityFilter.PlausibilityFilterTypeAdapter) {
                    PlausibilityFilter.PlausibilityFilterTypeAdapter pAdapt = (PlausibilityFilter.PlausibilityFilterTypeAdapter)adapter;
                    pAdapt.init(this.connStrat, this.distAzCalc, this.gson);
                }
                out.name("adapter").value(adapter.getClass().getName());
                out.name("filter");
                adapter.write(out, (Object)filter);
            }
            out.endObject();
        }

        public PlausibilityFilterRecord read(JsonReader in) throws IOException {
            Class type = null;
            TypeAdapter adapter = null;
            PlausibilityFilter filter = null;
            String name = null;
            String shortName = null;
            in.beginObject();
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "class": {
                        String clazz = in.nextString();
                        try {
                            type = PlausibilityConfiguration.getDeclaredTypeClass(clazz);
                        }
                        catch (Exception e) {
                            System.err.println("Warning: adapter class not found, will use stub: " + clazz);
                        }
                        break;
                    }
                    case "adapter": {
                        Preconditions.checkState((filter == null ? 1 : 0) != 0, (Object)"adapter must be before filter in JSON");
                        String adapterClassName = in.nextString();
                        try {
                            Class adapterClass = PlausibilityConfiguration.getDeclaredTypeClass(adapterClassName);
                            Constructor constructor = adapterClass.getConstructor(new Class[0]);
                            adapter = (TypeAdapter)constructor.newInstance(new Object[0]);
                        }
                        catch (ClassNotFoundException e) {
                            System.err.println("Warning: adapter specified but class not found, will attempt default serialization");
                            break;
                        }
                        catch (Exception e) {
                            System.err.println("Warning: error calling no-arg constructor to instantiate adapter");
                            e.printStackTrace();
                            break;
                        }
                        if (!(adapter instanceof PlausibilityFilter.PlausibilityFilterTypeAdapter)) break;
                        ((PlausibilityFilter.PlausibilityFilterTypeAdapter)adapter).init(this.connStrat, this.distAzCalc, this.gson);
                        break;
                    }
                    case "name": {
                        name = in.nextString();
                        break;
                    }
                    case "shortName": {
                        shortName = in.nextString();
                        break;
                    }
                    case "filter": {
                        String startPath = in.getPath();
                        if (type == null) {
                            filter = new PlausibilityFilterStub(name, shortName);
                            PlausibilityConfiguration.skipUntilEndObject(in, startPath);
                            break;
                        }
                        Preconditions.checkNotNull(type, (Object)"filter must be last in json object");
                        try {
                            if (adapter == null) {
                                filter = (PlausibilityFilter)this.gson.fromJson(in, type);
                                break;
                            }
                            filter = (PlausibilityFilter)adapter.read(in);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.println("Warning: couldn't de-serialize filter (using stub instead): " + type.getName());
                            System.err.flush();
                            filter = new PlausibilityFilterStub(name, shortName);
                            PlausibilityConfiguration.skipUntilEndObject(in, startPath);
                        }
                        break;
                    }
                }
            }
            in.endObject();
            return new PlausibilityFilterRecord(filter);
        }
    }

    private static class FloatRangeTypeAdapter
    extends TypeAdapter<Range<Float>> {
        private FloatRangeTypeAdapter() {
        }

        public void write(JsonWriter out, Range<Float> value) throws IOException {
            out.beginObject();
            if (value.hasLowerBound()) {
                out.name("lower").value((Number)((Object)value.lowerEndpoint())).name("lowerType").value(value.lowerBoundType().name());
            }
            if (value.hasUpperBound()) {
                out.name("upper").value((Number)((Object)value.upperEndpoint())).name("upperType").value(value.upperBoundType().name());
            }
            out.endObject();
        }

        public Range<Float> read(JsonReader in) throws IOException {
            Float lower = null;
            BoundType lowerType = null;
            Float upper = null;
            BoundType upperType = null;
            in.beginObject();
            block12: while (in.hasNext()) {
                String name;
                switch (name = in.nextName()) {
                    case "lower": {
                        lower = Float.valueOf((float)in.nextDouble());
                        continue block12;
                    }
                    case "lowerType": {
                        lowerType = BoundType.valueOf((String)in.nextString());
                        continue block12;
                    }
                    case "upper": {
                        upper = Float.valueOf((float)in.nextDouble());
                        continue block12;
                    }
                    case "upperType": {
                        upperType = BoundType.valueOf((String)in.nextString());
                        continue block12;
                    }
                }
                throw new IllegalStateException("unexpected json name: " + name);
            }
            in.endObject();
            Preconditions.checkState((lower != null || upper != null ? 1 : 0) != 0);
            if (lower != null) {
                Preconditions.checkNotNull(lowerType, (Object)"lower bound supplied without type");
            }
            if (upper != null) {
                Preconditions.checkNotNull(upperType, (Object)"upper bound supplied without type");
            }
            if (lower == null) {
                return Range.upTo(upper, (BoundType)upperType);
            }
            if (upper == null) {
                return Range.downTo((Comparable)lower, (BoundType)lowerType);
            }
            return Range.range((Comparable)lower, (BoundType)lowerType, (Comparable)upper, (BoundType)upperType);
        }
    }

    private static class PlausibilityFilterStub
    implements PlausibilityFilter {
        private String name;
        private String shortName;

        public PlausibilityFilterStub(String name, String shortName) {
            this.name = name;
            this.shortName = shortName;
        }

        @Override
        public String getShortName() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.shortName;
        }

        @Override
        public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
            throw new UnsupportedOperationException(this.getShortName() + " could not be deserialized from JSON and cannot be used for filtering");
        }
    }
}

