/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.AbstractClusterSizeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

public class AspectRatioFilter
extends AbstractClusterSizeFilter {
    private float minAspectRatio;

    public AspectRatioFilter(float minAspectRatio, boolean allowIfNoDirect, boolean allowChained, ClusterConnectionStrategy connStrategy) {
        super(allowIfNoDirect, allowChained, connStrategy);
        this.minAspectRatio = minAspectRatio;
    }

    @Override
    String getQuantityStr(FaultSubsectionCluster cluster) {
        return "aspect=" + AspectRatioFilter.clusterAspectRatio(cluster);
    }

    @Override
    boolean isClusterSufficient(FaultSubsectionCluster cluster) {
        return AspectRatioFilter.clusterAspectRatio(cluster) >= this.minAspectRatio;
    }

    public static float clusterAspectRatio(FaultSubsectionCluster cluster) {
        return AspectRatioFilter.clusterAspectRatio(cluster.subSects);
    }

    public static float clusterAspectRatio(Collection<? extends FaultSection> subSects) {
        boolean debug = false;
        double sumArea = 0.0;
        double sumLength = 0.0;
        for (FaultSection faultSection : subSects) {
            sumArea += faultSection.getArea(false) * 1.0E-6;
            double len = faultSection.getTraceLength();
            if (faultSection.getLowerFaultTrace() != null) {
                len = 0.5 * len + 0.5 * faultSection.getLowerFaultTrace().getTraceLength();
            }
            if (debug) {
                double myArea = faultSection.getArea(false) * 1.0E-6;
                double ddw = myArea / len;
                System.out.println("Sect " + faultSection.getSectionId() + ": len=" + (float)len + ", area=" + (float)myArea + ", impliedDDW=" + (float)ddw);
                System.out.println("\tdip=" + faultSection.getAveDip());
                System.out.println("\treported ddw=" + (float)faultSection.getOrigDownDipWidth());
            }
            sumLength += len;
        }
        double ddw = sumArea / sumLength;
        if (debug) {
            System.out.println("total ddw = " + (float)sumArea + " / " + (float)sumLength + " = " + (float)ddw);
            System.out.println("aspect = " + (float)sumLength + " / " + (float)ddw + " = " + (float)(sumLength / ddw));
        }
        return (float)(sumLength / ddw);
    }

    @Override
    public String getShortName() {
        return "Aspect";
    }

    @Override
    public String getName() {
        return "Minimum Aspect Ratio";
    }

    @Override
    public TypeAdapter<PlausibilityFilter> getTypeAdapter() {
        return new Adapter();
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }

    public static class Adapter
    extends PlausibilityFilter.PlausibilityFilterTypeAdapter {
        private ClusterConnectionStrategy connStrategy;

        @Override
        public void init(ClusterConnectionStrategy connStrategy, SectionDistanceAzimuthCalculator distAzCalc, Gson gson) {
            this.connStrategy = connStrategy;
        }

        public void write(JsonWriter out, PlausibilityFilter value) throws IOException {
            AspectRatioFilter filter = (AspectRatioFilter)value;
            out.beginObject();
            out.name("minAspectRatio").value((double)filter.minAspectRatio);
            out.name("allowIfNoDirect").value(filter.allowIfNoDirect);
            out.name("allowChained").value(filter.allowChained);
            out.endObject();
        }

        public PlausibilityFilter read(JsonReader in) throws IOException {
            in.beginObject();
            Float minAspectRatio = null;
            Boolean allowIfNoDirect = null;
            boolean allowChained = false;
            while (in.hasNext()) {
                switch (in.nextName()) {
                    case "minAspectRatio": {
                        minAspectRatio = Float.valueOf((float)in.nextDouble());
                        break;
                    }
                    case "allowIfNoDirect": {
                        allowIfNoDirect = in.nextBoolean();
                        break;
                    }
                    case "allowChained": {
                        allowChained = in.nextBoolean();
                        break;
                    }
                }
            }
            in.endObject();
            return new AspectRatioFilter(minAspectRatio.floatValue(), allowIfNoDirect, allowChained, this.connStrategy);
        }
    }
}

