/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.Named;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.CumulativeRakeChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.JumpAzimuthChangeFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

public class CumulativePenaltyFilter
implements ScalarValuePlausibiltyFilter<Float> {
    private float threshold;
    private boolean noDoubleCount = false;
    private Penalty[] penalties;

    public CumulativePenaltyFilter(float threshold, boolean noDoubleCount, Penalty ... penalties) {
        Preconditions.checkArgument((threshold > 0.0f ? 1 : 0) != 0, (Object)"Penalty threshold must be positive");
        this.threshold = threshold;
        Preconditions.checkArgument((penalties.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least 1 penalty");
        this.penalties = penalties;
        this.noDoubleCount = noDoubleCount;
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        double sum = this.calcTotalPenalty(rupture, verbose);
        if ((float)sum > this.threshold) {
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }

    @Override
    public String getShortName() {
        return "CumPenalty";
    }

    @Override
    public String getName() {
        return "Cumulative Penalty Filter";
    }

    public double calcTotalPenalty(ClusterRupture rupture, boolean verbose) {
        double sum = 0.0;
        for (Jump jump : rupture.getJumpsIterable()) {
            sum += this.calcJumpPenalty(rupture, jump, verbose);
        }
        if (verbose) {
            System.out.println(this.getShortName() + ": total penalty: " + sum);
        }
        return sum;
    }

    public double calcJumpPenalty(ClusterRupture rupture, Jump jump, boolean verbose) {
        double ret = 0.0;
        if (verbose) {
            System.out.println(this.getShortName() + ": Jump=" + String.valueOf(jump));
        }
        for (Penalty penalty : this.penalties) {
            double val = penalty.calcPenalty(rupture, jump);
            Preconditions.checkState((val >= 0.0 ? 1 : 0) != 0, (String)"Penalty must be postitive. Jump=%s, %s=%s", (Object)jump, (Object)penalty.getName(), (Object)val);
            if (verbose) {
                System.out.println("\t" + penalty.getName() + " = " + val);
            }
            if (this.noDoubleCount) {
                ret = Math.max(ret, val);
                continue;
            }
            ret += val;
        }
        if (verbose) {
            System.out.println("\taggregated jump penalty: " + ret);
        }
        return ret;
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        return Float.valueOf((float)this.calcTotalPenalty(rupture, false));
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.closed((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(this.threshold));
    }

    @Override
    public String getScalarName() {
        return "Penalty";
    }

    @Override
    public String getScalarUnits() {
        return null;
    }

    @Override
    public TypeAdapter<PlausibilityFilter> getTypeAdapter() {
        return new Adapter();
    }

    public static interface Penalty
    extends Named {
        public double calcPenalty(ClusterRupture var1, Jump var2);
    }

    public static class Adapter
    extends PlausibilityFilter.PlausibilityFilterTypeAdapter {
        private Gson gson;

        @Override
        public void init(ClusterConnectionStrategy connStrategy, SectionDistanceAzimuthCalculator distAzCalc, Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, PlausibilityFilter value) throws IOException {
            Preconditions.checkState((boolean)(value instanceof CumulativePenaltyFilter));
            CumulativePenaltyFilter filter = (CumulativePenaltyFilter)value;
            out.beginObject();
            out.name("threshold").value((double)filter.threshold);
            out.name("noDoubleCount").value(filter.noDoubleCount);
            out.name("penalties").beginArray();
            for (Penalty penalty : filter.penalties) {
                out.beginObject();
                out.name("class").value(penalty.getClass().getName());
                out.name("value");
                this.gson.toJson((Object)penalty, penalty.getClass(), out);
                out.endObject();
            }
            out.endArray();
            out.endObject();
        }

        public PlausibilityFilter read(JsonReader in) throws IOException {
            in.beginObject();
            Float threshold = null;
            boolean noDoubleCount = false;
            Penalty[] penalties = null;
            block20: while (in.hasNext()) {
                switch (in.nextName()) {
                    case "threshold": {
                        threshold = Float.valueOf((float)in.nextDouble());
                        continue block20;
                    }
                    case "noDoubleCount": {
                        noDoubleCount = in.nextBoolean();
                        continue block20;
                    }
                    case "penalties": {
                        ArrayList<Penalty> list = new ArrayList<Penalty>();
                        in.beginArray();
                        while (in.hasNext()) {
                            in.beginObject();
                            Class type = null;
                            Penalty penalty = null;
                            block22: while (in.hasNext()) {
                                switch (in.nextName()) {
                                    case "class": {
                                        try {
                                            type = PlausibilityConfiguration.getDeclaredTypeClass(in.nextString());
                                            continue block22;
                                        }
                                        catch (ClassNotFoundException e) {
                                            throw ExceptionUtils.asRuntimeException(e);
                                        }
                                    }
                                    case "value": {
                                        Preconditions.checkNotNull(type, (Object)"Class must preceed value in Penalty JSON");
                                        penalty = (Penalty)this.gson.fromJson(in, type);
                                        continue block22;
                                    }
                                }
                                throw new IllegalStateException("Unexpected JSON field");
                            }
                            Preconditions.checkNotNull(penalty, (Object)"Penalty is null?");
                            list.add(penalty);
                            in.endObject();
                        }
                        in.endArray();
                        Preconditions.checkState((!list.isEmpty() ? 1 : 0) != 0, (Object)"No penalties?");
                        penalties = list.toArray(new Penalty[0]);
                        continue block20;
                    }
                }
                throw new IllegalStateException("Unexpected JSON field");
            }
            in.endObject();
            Preconditions.checkNotNull(threshold, (Object)"threshold not supplied");
            Preconditions.checkNotNull(penalties, (Object)"penalties not supplied");
            return new CumulativePenaltyFilter(threshold.floatValue(), noDoubleCount, penalties);
        }
    }

    public static class AzimuthChangePenalty
    implements Penalty {
        private float minDifference;
        private double penalty;
        private boolean isDiffMultiplier;
        private JumpAzimuthChangeFilter.AzimuthCalc calc;

        public AzimuthChangePenalty(float minDifference, double penalty, boolean isDiffMultiplier, JumpAzimuthChangeFilter.AzimuthCalc calc) {
            this.minDifference = minDifference;
            this.penalty = penalty;
            this.isDiffMultiplier = isDiffMultiplier;
            this.calc = calc;
        }

        @Override
        public double calcPenalty(ClusterRupture fullRup, Jump jump) {
            FaultSection[] after2s;
            FaultSection before2;
            RuptureTreeNavigator nav = fullRup.getTreeNavigator();
            FaultSection before1 = nav.getPredecessor(before2 = jump.fromSection);
            if (before1 == null) {
                return 0.0;
            }
            FaultSection after1 = jump.toSection;
            if (jump.toCluster.subSects.size() > 1) {
                after2s = new FaultSection[]{(FaultSection)jump.toCluster.subSects.get(1)};
            } else if (fullRup.contains(after1)) {
                after2s = nav.getDescendants(after1).toArray(new FaultSection[0]);
            } else {
                return 0.0;
            }
            double beforeAz = this.calc.calcAzimuth(before1, before2);
            double max = 0.0;
            for (FaultSection after2 : after2s) {
                double afterAz = this.calc.calcAzimuth(after1, after2);
                double diff = JumpAzimuthChangeFilter.getAzimuthDifference(beforeAz, afterAz);
                if (!((float)diff > this.minDifference)) continue;
                max = this.isDiffMultiplier ? Math.max(max, diff * this.penalty) : Math.max(max, this.penalty);
            }
            return max;
        }

        @Override
        public String getName() {
            return "Azimuth Penalty > " + this.minDifference + " deg: " + this.penalty;
        }
    }

    public static class DipChangePenalty
    implements Penalty {
        private float minDifference;
        private double penalty;
        private boolean isDiffMultiplier;

        public DipChangePenalty(float minDifference, double penalty, boolean isDiffMultiplier) {
            this.minDifference = minDifference;
            this.penalty = penalty;
            this.isDiffMultiplier = isDiffMultiplier;
        }

        @Override
        public double calcPenalty(ClusterRupture fullRup, Jump jump) {
            double diff = Math.abs(jump.fromSection.getAveDip() - jump.toSection.getAveDip());
            if ((float)diff <= this.minDifference) {
                return 0.0;
            }
            if (this.isDiffMultiplier) {
                return diff * this.penalty;
            }
            return this.penalty;
        }

        @Override
        public String getName() {
            return "Dip Change Penalty > " + this.minDifference + " deg: " + this.penalty + (this.isDiffMultiplier ? " (multiplier)" : "");
        }
    }

    public static class RakeChangePenalty
    implements Penalty {
        private float minDifference;
        private double penalty;
        private boolean isDiffMultiplier;

        public RakeChangePenalty(float minDifference, double penalty, boolean isDiffMultiplier) {
            this.minDifference = minDifference;
            this.penalty = penalty;
            this.isDiffMultiplier = isDiffMultiplier;
        }

        @Override
        public double calcPenalty(ClusterRupture fullRup, Jump jump) {
            double diff = CumulativeRakeChangeFilter.rakeDiff(jump.fromSection.getAveRake(), jump.toSection.getAveRake());
            if ((float)diff <= this.minDifference) {
                return 0.0;
            }
            if (this.isDiffMultiplier) {
                return diff * this.penalty;
            }
            return this.penalty;
        }

        @Override
        public String getName() {
            return "Rake Penalty > " + this.minDifference + " deg: " + this.penalty + (this.isDiffMultiplier ? " (multiplier)" : "");
        }
    }

    public static class JumpPenalty
    implements Penalty {
        private float minDistance;
        private double penalty;
        private boolean isDistMultiplier;

        public JumpPenalty(float minDistance, double penalty, boolean isDistMultiplier) {
            this.minDistance = minDistance;
            this.penalty = penalty;
            this.isDistMultiplier = isDistMultiplier;
        }

        @Override
        public double calcPenalty(ClusterRupture fullRup, Jump jump) {
            if ((float)jump.distance <= this.minDistance) {
                return 0.0;
            }
            if (this.isDistMultiplier) {
                return this.penalty * jump.distance;
            }
            return this.penalty;
        }

        @Override
        public String getName() {
            return "Jump Penalty > " + this.minDistance + " km: " + this.penalty + (this.isDistMultiplier ? " (multiplier)" : "");
        }
    }
}

