/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.collect.Range;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.JumpPlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.ScalarValuePlausibiltyFilter;

public class JumpDistFilter
extends JumpPlausibilityFilter
implements ScalarValuePlausibiltyFilter<Float> {
    private double maxDist;

    public JumpDistFilter(double maxDist) {
        this.maxDist = maxDist;
    }

    @Override
    public PlausibilityResult testJump(ClusterRupture rupture, Jump newJump, boolean verbose) {
        if ((float)newJump.distance > (float)this.maxDist) {
            if (verbose) {
                System.out.println("Failing for jump over maxDist: " + String.valueOf(newJump));
            }
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }

    @Override
    public String getShortName() {
        return "JumpDist";
    }

    @Override
    public String getName() {
        return "Maximum Jump Dist";
    }

    @Override
    public Float getValue(ClusterRupture rupture) {
        float max = 0.0f;
        for (Jump jump : rupture.getJumpsIterable()) {
            max = Float.max(max, (float)jump.distance);
        }
        return Float.valueOf(max);
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.atMost((Comparable)Float.valueOf((float)this.maxDist));
    }

    @Override
    public String getScalarName() {
        return "Jump Distance";
    }

    @Override
    public String getScalarUnits() {
        return "km";
    }
}

