/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;

public class SingleClusterPerParentFilter
implements PlausibilityFilter {
    @Override
    public String getShortName() {
        return "1ClusterPerParent";
    }

    @Override
    public String getName() {
        return "Single Cluster Per Parent";
    }

    private void count(ClusterRupture rup, HashSet<Integer> parents, List<FaultSubsectionCluster> clusters) {
        for (FaultSubsectionCluster cluster : rup.getClustersIterable()) {
            parents.add(cluster.parentSectionID);
            clusters.add(cluster);
        }
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        HashSet<Integer> parents = new HashSet<Integer>();
        ArrayList<FaultSubsectionCluster> clusters = new ArrayList<FaultSubsectionCluster>();
        this.count(rupture, parents, clusters);
        if (parents.size() != clusters.size()) {
            if (verbose) {
                System.out.println(this.getShortName() + ": have " + parents.size() + " parents but " + clusters.size() + " clusters");
            }
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }
}

