/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl;

import com.google.common.collect.UnmodifiableIterator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;

public class SplayLengthFilter
implements PlausibilityFilter {
    private double maxLen;
    private boolean isFractOfMain;
    private boolean totalAcrossSplays;
    private boolean allowFullCluster = false;

    public SplayLengthFilter(double maxLen, boolean isFractOfMain, boolean totalAcrossSplays, boolean allowFullCluster) {
        this.maxLen = maxLen;
        this.isFractOfMain = isFractOfMain;
        this.totalAcrossSplays = totalAcrossSplays;
        this.allowFullCluster = allowFullCluster;
    }

    @Override
    public String getShortName() {
        return "StrandLen";
    }

    @Override
    public String getName() {
        return "Strand Length";
    }

    @Override
    public PlausibilityResult apply(ClusterRupture rupture, boolean verbose) {
        double maxLen;
        if (rupture.splays.isEmpty()) {
            return PlausibilityResult.PASS;
        }
        double d = maxLen = this.isFractOfMain ? this.maxLen * SplayLengthFilter.calcLen(rupture, null, false) : this.maxLen;
        if (verbose) {
            System.out.println(this.getShortName() + ": maxLen=" + maxLen);
        }
        double totSplay = 0.0;
        for (ClusterRupture splay : rupture.splays.values()) {
            double splayLen = SplayLengthFilter.calcLen(splay, null, true);
            if (verbose) {
                System.out.println(this.getShortName() + ": splay with length=" + splayLen);
            }
            if (this.totalAcrossSplays) {
                if (!((float)(totSplay += splayLen) > (float)maxLen)) continue;
                if (verbose) {
                    System.out.println(this.getShortName() + ": failing with cumulative length=" + totSplay);
                }
                return PlausibilityResult.FAIL_HARD_STOP;
            }
            if (!((float)splayLen > (float)maxLen) || this.allowFullCluster) continue;
            if (this.allowFullCluster && splay.clusters.length == 1 && splay.splays.isEmpty()) {
                if (!verbose) continue;
                System.out.println(this.getShortName() + ": allowing over length because it's within the first cluster");
                continue;
            }
            if (verbose) {
                System.out.println(this.getShortName() + ": failing");
            }
            return PlausibilityResult.FAIL_HARD_STOP;
        }
        return PlausibilityResult.PASS;
    }

    private static double calcLen(ClusterRupture rupture, FaultSubsectionCluster addition, boolean takeSplays) {
        double len = 0.0;
        if (rupture != null) {
            for (UnmodifiableIterator cluster : rupture.clusters) {
                for (FaultSection sect : cluster.subSects) {
                    len += sect.getTraceLength();
                }
            }
        }
        if (addition != null) {
            for (FaultSection sect : addition.subSects) {
                len += sect.getTraceLength();
            }
        }
        if (takeSplays && rupture != null) {
            for (ClusterRupture splay : rupture.splays.values()) {
                len += SplayLengthFilter.calcLen(splay, null, true);
            }
        }
        return len;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return splayed;
    }
}

