/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.NucleationClusterEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.RuptureProbabilityCalc;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public class CumulativeProbPathEvaluator
implements NucleationClusterEvaluator.Scalar<Float> {
    RuptureProbabilityCalc[] calcs;
    float minProbability;
    PlausibilityResult failureType;

    public CumulativeProbPathEvaluator(float minProbability, PlausibilityResult failureType, RuptureProbabilityCalc ... calcs) {
        Preconditions.checkState((calcs.length > 0 ? 1 : 0) != 0, (Object)"Must supply at least one calculator");
        this.calcs = calcs;
        Preconditions.checkState((minProbability >= 0.0f && minProbability <= 1.0f ? 1 : 0) != 0);
        this.minProbability = minProbability;
        Preconditions.checkState((!failureType.isPass() ? 1 : 0) != 0);
        this.failureType = failureType;
    }

    @Override
    public void init(ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
        for (RuptureProbabilityCalc calc : this.calcs) {
            calc.init(connStrat, distAzCalc);
        }
    }

    public RuptureProbabilityCalc[] getCalcs() {
        return this.calcs;
    }

    @Override
    public Range<Float> getAcceptableRange() {
        return Range.atLeast((Comparable)Float.valueOf(this.minProbability));
    }

    @Override
    public String getScalarName() {
        return "Conditional Probability";
    }

    @Override
    public String getScalarUnits() {
        return null;
    }

    @Override
    public PlausibilityResult getFailureType() {
        return this.failureType;
    }

    private ClusterRupture buildRuptureForwards(ClusterRupture curRup, RuptureTreeNavigator nav, FaultSubsectionCluster fromCluster) {
        for (FaultSubsectionCluster toCluster : nav.getDescendants(fromCluster)) {
            Jump jump = nav.getJump(fromCluster, toCluster);
            curRup = curRup.take(jump);
            curRup = this.buildRuptureForwards(curRup, nav, toCluster);
        }
        return curRup;
    }

    private ClusterRupture getNucleationRupture(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster, boolean verbose) {
        ClusterRupture nucleationRupture;
        if (rupture.clusters[0] == nucleationCluster) {
            nucleationRupture = rupture;
        } else if (rupture.singleStrand && rupture.clusters[rupture.clusters.length - 1] == nucleationCluster) {
            nucleationRupture = rupture.reversed();
        } else {
            FaultSubsectionCluster prevReversed;
            RuptureTreeNavigator nav = rupture.getTreeNavigator();
            nucleationRupture = new ClusterRupture(nucleationCluster);
            nucleationRupture = this.buildRuptureForwards(nucleationRupture, nav, nucleationCluster);
            FaultSubsectionCluster predecessor = nav.getPredecessor(nucleationCluster);
            FaultSubsectionCluster prevOrig = nucleationCluster;
            if (nucleationRupture.getTotalNumClusters() == 1) {
                prevReversed = nucleationCluster.reversed();
                nucleationRupture = new ClusterRupture(prevReversed);
            } else {
                prevReversed = nucleationCluster;
            }
            while (predecessor != null) {
                Jump origJump = nav.getJump(predecessor, prevOrig);
                FaultSubsectionCluster reversed = predecessor.reversed(origJump.fromSection);
                Jump reverseJump = new Jump(origJump.toSection, prevReversed, origJump.fromSection, reversed, origJump.distance);
                nucleationRupture = nucleationRupture.take(reverseJump);
                for (FaultSubsectionCluster descendant : nav.getDescendants(predecessor)) {
                    if (nucleationRupture.contains(descendant.startSect)) continue;
                    Jump origSplayJump = nav.getJump(predecessor, descendant);
                    Jump newSplayJump = new Jump(origSplayJump.fromSection, reversed, origSplayJump.toSection, origSplayJump.toCluster, origSplayJump.distance);
                    nucleationRupture = nucleationRupture.take(newSplayJump);
                    nucleationRupture = this.buildRuptureForwards(nucleationRupture, nav, descendant);
                }
                prevOrig = predecessor;
                prevReversed = reversed;
                predecessor = nav.getPredecessor(predecessor);
            }
            Preconditions.checkState((nucleationRupture.getTotalNumSects() == rupture.getTotalNumSects() ? 1 : 0) != 0, (String)"Nucleation view of rupture is incomplete!\n\tOriginal: %s\n\tNucleation cluster: %s\n\tNucleation rupture: %s", (Object)rupture, (Object)nucleationCluster, (Object)nucleationRupture);
        }
        if (verbose) {
            System.out.println("Nucleation rupture: " + String.valueOf(nucleationRupture));
        }
        return nucleationRupture;
    }

    @Override
    public PlausibilityResult testNucleationCluster(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster, boolean verbose) {
        ClusterRupture nucleationRupture = this.getNucleationRupture(rupture, nucleationCluster, verbose);
        double prob = 1.0;
        for (RuptureProbabilityCalc calc : this.calcs) {
            double myProb = calc.calcRuptureProb(nucleationRupture, verbose);
            prob *= myProb;
            if (verbose) {
                System.out.println("\t" + calc.getName() + ": P=" + myProb);
                continue;
            }
            if (!((float)prob < this.minProbability)) continue;
            return this.failureType;
        }
        if ((float)prob >= this.minProbability) {
            return PlausibilityResult.PASS;
        }
        return this.failureType;
    }

    @Override
    public Float getNucleationClusterValue(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster, boolean verbose) {
        ClusterRupture nucleationRupture = this.getNucleationRupture(rupture, nucleationCluster, verbose);
        double prob = 1.0;
        for (RuptureProbabilityCalc calc : this.calcs) {
            double myProb = calc.calcRuptureProb(nucleationRupture, verbose);
            prob *= myProb;
            if (!verbose) continue;
            System.out.println("\t" + calc.getName() + ": P=" + myProb);
        }
        return Float.valueOf((float)prob);
    }

    @Override
    public String getShortName() {
        return "P(" + Arrays.stream(this.calcs).map(E -> E.getName().replaceAll(" ", "")).collect(Collectors.joining(", ")) + ")\u2265" + this.minProbability;
    }

    @Override
    public String getName() {
        return "P(" + Arrays.stream(this.calcs).map(E -> E.getName()).collect(Collectors.joining(", ")) + ") \u2265" + this.minProbability;
    }
}

