/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.data.ShortNamed;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;

public interface NucleationClusterEvaluator
extends ShortNamed {
    public PlausibilityResult testNucleationCluster(ClusterRupture var1, FaultSubsectionCluster var2, boolean var3);

    public PlausibilityResult getFailureType();

    default public List<FaultSubsectionCluster> getDestinations(RuptureTreeNavigator nav, FaultSubsectionCluster from, HashSet<FaultSubsectionCluster> strandClusters) {
        ArrayList<FaultSubsectionCluster> ret = new ArrayList<FaultSubsectionCluster>();
        FaultSubsectionCluster predecessor = nav.getPredecessor(from);
        if (!(predecessor == null || strandClusters != null && strandClusters.contains(predecessor))) {
            ret.add(predecessor);
        }
        for (FaultSubsectionCluster descendant : nav.getDescendants(from)) {
            if (strandClusters != null && strandClusters.contains(descendant)) continue;
            ret.add(descendant);
        }
        return ret;
    }

    default public void init(ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
    }

    public static interface Scalar<E extends Number>
    extends NucleationClusterEvaluator {
        public E getNucleationClusterValue(ClusterRupture var1, FaultSubsectionCluster var2, boolean var3);

        public Range<E> getAcceptableRange();

        public String getScalarName();

        public String getScalarUnits();
    }
}

