/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Collection;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.SectCoulombPathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.AbstractRelativeProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.CumulativeProbabilityFilter;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;

public class RelativeCoulombProb
extends AbstractRelativeProb {
    private AggregatedStiffnessCalculator aggCalc;
    private boolean sectBySect;
    private boolean jumpToMostFavorable;
    private float maxJumpDist;
    private transient SectionDistanceAzimuthCalculator distAzCalc;
    private static final Range<Float> posRange = Range.atLeast((Comparable)Float.valueOf(0.0f));

    public RelativeCoulombProb(AggregatedStiffnessCalculator aggCalc, ClusterConnectionStrategy connStrat, boolean allowNegative, boolean sectBySect) {
        this(aggCalc, connStrat, allowNegative, sectBySect, false, 0.0f, null);
    }

    public RelativeCoulombProb(AggregatedStiffnessCalculator aggCalc, ClusterConnectionStrategy connStrat, boolean allowNegative, boolean sectBySect, boolean jumpToMostFavorable, float maxJumpDist, SectionDistanceAzimuthCalculator distAzCalc) {
        super(connStrat, allowNegative, true, true);
        this.aggCalc = aggCalc;
        this.sectBySect = sectBySect;
        this.jumpToMostFavorable = jumpToMostFavorable;
        if (jumpToMostFavorable) {
            Preconditions.checkState((boolean)sectBySect);
            Preconditions.checkState((maxJumpDist > 0.0f ? 1 : 0) != 0);
            this.maxJumpDist = maxJumpDist;
            Preconditions.checkNotNull((Object)distAzCalc);
            this.distAzCalc = distAzCalc;
        }
    }

    public AggregatedStiffnessCalculator getAggregator() {
        return this.aggCalc;
    }

    @Override
    public void init(ClusterConnectionStrategy connStrat, SectionDistanceAzimuthCalculator distAzCalc) {
        super.init(connStrat, distAzCalc);
        this.distAzCalc = distAzCalc;
    }

    public void setMaxJumpDist(float maxJumpDist) {
        this.maxJumpDist = maxJumpDist;
    }

    @Override
    public String getName() {
        Object name = "Rel CFF";
        if (this.sectBySect) {
            name = (String)name + " Sect";
            if (this.jumpToMostFavorable) {
                name = (String)name + ", Fav" + CumulativeProbabilityFilter.optionalDigitDF.format(this.maxJumpDist) + "km";
            }
        } else {
            name = (String)name + " Cluster";
        }
        if (this.allowNegative) {
            name = (String)name + ", Allow Neg";
        }
        if (!this.relativeToBest) {
            name = (String)name + ", Rel Total";
        }
        return name;
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return true;
    }

    @Override
    public double calcAdditionValue(ClusterRupture fullRupture, Collection<? extends FaultSection> currentSects, PathEvaluator.PathAddition addition) {
        return this.aggCalc.calc(currentSects, addition.toSects);
    }

    @Override
    public boolean isAddFullClusters() {
        return !this.sectBySect;
    }

    @Override
    public PathEvaluator.PathNavigator getPathNav(ClusterRupture rupture, FaultSubsectionCluster nucleationCluster) {
        if (this.jumpToMostFavorable) {
            return new SectCoulombPathEvaluator.CoulombFavorableSectionPathNavigator((Collection<FaultSection>)nucleationCluster.subSects, rupture.getTreeNavigator(), this.aggCalc, posRange, this.distAzCalc, this.maxJumpDist);
        }
        return super.getPathNav(rupture, nucleationCluster);
    }

    @Override
    public PathEvaluator.PathAddition targetJumpToAddition(Collection<? extends FaultSection> curSects, PathEvaluator.PathAddition testAddition, Jump alternateJump) {
        if (this.jumpToMostFavorable) {
            Preconditions.checkState((boolean)this.sectBySect);
            FaultSection destSect = SectCoulombPathEvaluator.findMostFavorableJumpSect(curSects, alternateJump, this.maxJumpDist, posRange, this.aggCalc, this.distAzCalc, false);
            return new PathEvaluator.PathAddition(testAddition.fromSect, testAddition.fromCluster, destSect, alternateJump.toCluster, alternateJump.distance);
        }
        return super.targetJumpToAddition(curSects, testAddition, alternateJump);
    }
}

