/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.path.PathEvaluator;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.impl.prob.AbstractRelativeProb;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureTreeNavigator;
import org.opensha.sha.faultSurface.FaultSection;

public class RelativeSlipRateProb
extends AbstractRelativeProb {
    private boolean onlyAtIncreases;

    public RelativeSlipRateProb(ClusterConnectionStrategy connStrat, boolean onlyAtIncreases, boolean includeLongerJumps) {
        super(connStrat, false, true, includeLongerJumps);
        this.onlyAtIncreases = onlyAtIncreases;
    }

    @Override
    public double calcAdditionValue(ClusterRupture fullRupture, Collection<? extends FaultSection> currentSects, PathEvaluator.PathAddition addition) {
        return this.calcAveSlipRate(addition.toSects);
    }

    private double calcAveSlipRate(Collection<? extends FaultSection> subSects) {
        double aveVal = 0.0;
        for (FaultSection faultSection : subSects) {
            aveVal += faultSection.getOrigAveSlipRate();
        }
        return aveVal /= (double)subSects.size();
    }

    @Override
    public String getName() {
        if (this.onlyAtIncreases) {
            return "Rel Slip Rate (@incr.)";
        }
        return "Rel Slip Rate";
    }

    @Override
    public boolean isAddFullClusters() {
        return true;
    }

    @Override
    public HashSet<FaultSubsectionCluster> getSkipToClusters(ClusterRupture rupture) {
        if (this.onlyAtIncreases) {
            int totNumClusters = rupture.getTotalNumClusters();
            if (totNumClusters == 1) {
                return null;
            }
            ArrayList<FaultSubsectionCluster> endClusters = new ArrayList<FaultSubsectionCluster>();
            this.findEndClusters(rupture, endClusters);
            HashSet<FaultSubsectionCluster> skipToClusters = new HashSet<FaultSubsectionCluster>();
            RuptureTreeNavigator nav = rupture.getTreeNavigator();
            for (FaultSubsectionCluster cluster : endClusters) {
                double predecessorVal;
                double clusterVal = this.calcAveSlipRate((Collection<? extends FaultSection>)cluster.subSects);
                FaultSubsectionCluster predecessor = nav.getPredecessor(cluster);
                while (predecessor != null && !((predecessorVal = this.calcAveSlipRate((Collection<? extends FaultSection>)predecessor.subSects)) < clusterVal)) {
                    skipToClusters.add(cluster);
                    cluster = predecessor;
                    clusterVal = predecessorVal;
                    predecessor = nav.getPredecessor(cluster);
                }
            }
            Preconditions.checkState((skipToClusters.size() < totNumClusters ? 1 : 0) != 0);
            return skipToClusters;
        }
        return null;
    }

    private void findEndClusters(ClusterRupture rupture, List<FaultSubsectionCluster> endClusters) {
        endClusters.add(rupture.clusters[rupture.clusters.length - 1]);
        for (ClusterRupture splay : rupture.splays.values()) {
            this.findEndClusters(splay, endClusters);
        }
    }

    @Override
    public boolean isDirectional(boolean splayed) {
        return true;
    }
}

