/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.collect.HashMultimap;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;

class PrecomputedClusterConnectionStrategy
extends ClusterConnectionStrategy {
    private String name;
    private double maxJumpDist;

    public PrecomputedClusterConnectionStrategy(String name, List<? extends FaultSection> subSections, List<FaultSubsectionCluster> clusters, double maxJumpDist, SectionDistanceAzimuthCalculator distCalc) {
        super(subSections, clusters, distCalc);
        this.name = name;
        this.maxJumpDist = maxJumpDist;
        this.connectionsAdded = true;
        this.connectedParents = new HashSet();
        this.jumpsFrom = HashMultimap.create();
        for (FaultSubsectionCluster cluster : clusters) {
            for (Jump jump : cluster.getConnections()) {
                this.connectedParents.add(new IDPairing(cluster.parentSectionID, jump.toCluster.parentSectionID));
                this.jumpsFrom.put((Object)jump.fromSection, (Object)jump);
            }
        }
        if (this.connectedParents.isEmpty()) {
            System.err.println("WARNING: no connections detected");
        }
    }

    @Override
    protected List<Jump> buildPossibleConnections(FaultSubsectionCluster from, FaultSubsectionCluster to) {
        throw new IllegalStateException("Already built when pre-computed");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getMaxJumpDist() {
        return this.maxJumpDist;
    }
}

