/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies;

import com.google.common.collect.Lists;
import java.util.List;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.Jump;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.strategies.ClusterConnectionStrategy;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.coulomb.CoulombRates;

public class UCERF3ClusterConnectionStrategy
extends ClusterConnectionStrategy {
    private SectionDistanceAzimuthCalculator distCalc;
    private double maxJumpDist;
    private CoulombRates coulombRates;

    public UCERF3ClusterConnectionStrategy(List<? extends FaultSection> subSects, SectionDistanceAzimuthCalculator distCalc, double maxJumpDist, CoulombRates coulombRates) {
        super(subSects, distCalc);
        this.distCalc = distCalc;
        this.maxJumpDist = maxJumpDist;
        this.coulombRates = coulombRates;
    }

    @Override
    protected List<Jump> buildPossibleConnections(FaultSubsectionCluster from, FaultSubsectionCluster to) {
        Jump jump = null;
        for (FaultSection s1 : from.subSects) {
            for (FaultSection s2 : to.subSects) {
                double dist = this.distCalc.getDistance(s1, s2);
                if (!((float)dist <= (float)this.maxJumpDist) || jump != null && !((float)dist <= (float)jump.distance)) continue;
                if (jump != null && (float)dist == (float)jump.distance) {
                    boolean prevValCoulomb = false;
                    boolean curValCoulomb = false;
                    if (this.coulombRates != null) {
                        prevValCoulomb = this.coulombRates.containsKey(new IDPairing(jump.fromSection.getSectionId(), jump.toSection.getSectionId()));
                        curValCoulomb = this.coulombRates.containsKey(new IDPairing(s1.getSectionId(), s2.getSectionId()));
                    }
                    if (prevValCoulomb || !curValCoulomb) continue;
                }
                jump = new Jump(s1, from, s2, to, dist);
            }
        }
        if (jump == null) {
            return null;
        }
        return Lists.newArrayList((Object[])new Jump[]{jump});
    }

    @Override
    public String getName() {
        String name = "UCERF3: maxDist=" + (float)this.maxJumpDist + " km";
        if (this.coulombRates != null) {
            name = name + ", precomputed Coulomb pairings";
        }
        return name;
    }

    @Override
    public double getMaxJumpDist() {
        return this.maxJumpDist;
    }
}

